/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-rrc.c                                                               */
/* asn2wrs.py -q -L -p rrc -c ./rrc.cnf -s ./packet-rrc-template -D . -O ../.. Class-definitions.asn PDU-definitions.asn InformationElements.asn Constant-definitions.asn Internode-definitions.asn */

/* packet-rrc.c
 * Routines for Universal Mobile Telecommunications System (UMTS);
 * Radio Resource Control (RRC) protocol specification
 * (3GPP TS 25.331  packet dissection)
 * Copyright 2006-2010, Anders Broman <anders.broman@ericsson.com>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Ref: 3GPP TS 25.331 V17.1.0 (2022-06)
 */

/**
 *
 * TODO:
 * - Fix ciphering information for circuit switched stuff
 */

#include "config.h"

#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/conversation.h>
#include <epan/expert.h>
#include <epan/proto_data.h>
#include <epan/prefs.h>
#include <epan/tfs.h>
#include <wsutil/array.h>

#include "packet-ber.h"
#include "packet-per.h"
#include "packet-rrc.h"
#include "packet-gsm_a_common.h"
#include "packet-nbap.h"
#include "packet-umts_fp.h"
#include "packet-umts_mac.h"
#include "packet-umts_rlc.h"

#ifdef _MSC_VER
/* disable: "warning C4049: compiler limit : terminating line number emission" */
#pragma warning(disable:4049)
#endif

extern int proto_fp;       /*Handler to FP*/
extern int proto_umts_mac; /*Handler to MAC*/
extern int proto_umts_rlc; /*Handler to RLC*/

GTree * hsdsch_muxed_flows;
GTree * rrc_ciph_info_tree;
wmem_tree_t* rrc_global_urnti_crnti_map;
static int msg_type _U_;
static bool rrc_nas_in_root_tree;

enum rrc_sib_segment_type {
  RRC_SIB_SEG_NO_SEGMENT = 0,
  RRC_SIB_SEG_FIRST = 1,
  RRC_SIB_SEG_SUBSEQUENT = 2,
  RRC_SIB_SEG_LAST_SHORT = 3,
  RRC_SIB_SEG_LAST_AND_FIRST = 4,
  RRC_SIB_SEG_LAST_AND_COMP = 5,
  RRC_SIB_SEG_LAST_AND_COMP_AND_FIRST = 6,
  RRC_SIB_SEG_COMP_LIST = 7,
  RRC_SIB_SEG_COMP_AND_FIRST = 8,
  RRC_SIB_SEG_COMP = 10,
};

/*****************************************************************************/
/* Packet private data                                                       */
/* For this dissector, all access to actx->private_data should be made       */
/* through this API, which ensures that they will not overwrite each other!! */
/*****************************************************************************/

typedef struct umts_rrc_private_data_t
{
  uint32_t s_rnc_id; /* The S-RNC ID part of a U-RNTI */
  uint32_t s_rnti; /* The S-RNTI part of a U-RNTI */
  uint32_t new_u_rnti;
  uint32_t current_u_rnti;
  uint32_t scrambling_code;
  enum nas_sys_info_gsm_map cn_domain;
  wmem_strbuf_t* digits_strbuf; /* A collection of digits in a string. Used for reconstructing IMSIs or MCC-MNC pairs */
  wmem_strbuf_t* last_mcc_strbuf; /* Last seen MCC digits string */
  bool digits_strbuf_parsing_failed_flag; /* Whether an error occurred when creating the IMSI/MCC-MNC pair string */
  uint32_t rbid;
  uint32_t rlc_ciphering_sqn; /* Sequence number where ciphering starts in a given bearer */
  rrc_ciphering_info* ciphering_info;
  enum rrc_ue_state rrc_state_indicator;
  enum rrc_sib_segment_type curr_sib_segment_type;
  uint32_t curr_sib_type;
} umts_rrc_private_data_t;


/* Helper function to get or create a struct that will be actx->private_data */
static umts_rrc_private_data_t* umts_rrc_get_private_data(asn1_ctx_t *actx)
{
  if (actx->private_data == NULL) {
    actx->private_data = wmem_new0(actx->pinfo->pool, umts_rrc_private_data_t);
  }
  return (umts_rrc_private_data_t*)actx->private_data;
}

static uint32_t private_data_get_s_rnc_id(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->s_rnc_id;
}

static void private_data_set_s_rnc_id(asn1_ctx_t *actx, uint32_t s_rnc_id)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->s_rnc_id = s_rnc_id;
}

static uint32_t private_data_get_s_rnti(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->s_rnti;
}

static void private_data_set_s_rnti(asn1_ctx_t *actx, uint32_t s_rnti)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->s_rnti = s_rnti;
}

static uint32_t private_data_get_new_u_rnti(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->new_u_rnti;
}

static void private_data_set_new_u_rnti(asn1_ctx_t *actx, uint32_t new_u_rnti)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->new_u_rnti = new_u_rnti;
}

static uint32_t private_data_get_current_u_rnti(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->current_u_rnti;
}

static void private_data_set_current_u_rnti(asn1_ctx_t *actx, uint32_t current_u_rnti)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->current_u_rnti = current_u_rnti;
}

static uint32_t private_data_get_scrambling_code(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->scrambling_code;
}

static void private_data_set_scrambling_code(asn1_ctx_t *actx, uint32_t scrambling_code)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->scrambling_code = scrambling_code;
}

static enum nas_sys_info_gsm_map private_data_get_cn_domain(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->cn_domain;
}

static void private_data_set_cn_domain(asn1_ctx_t *actx, enum nas_sys_info_gsm_map cn_domain)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->cn_domain = cn_domain;
}

static wmem_strbuf_t* private_data_get_digits_strbuf(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->digits_strbuf;
}

static void private_data_set_digits_strbuf(asn1_ctx_t *actx, wmem_strbuf_t* digits_strbuf)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->digits_strbuf = digits_strbuf;
}

static bool private_data_get_digits_strbuf_parsing_failed_flag(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->digits_strbuf_parsing_failed_flag;
}

static void private_data_set_digits_strbuf_parsing_failed_flag(asn1_ctx_t *actx, bool digits_strbuf_parsing_failed_flag)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->digits_strbuf_parsing_failed_flag = digits_strbuf_parsing_failed_flag;
}

static wmem_strbuf_t* private_data_get_last_mcc_strbuf(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->last_mcc_strbuf;
}

static void private_data_set_last_mcc_strbuf(asn1_ctx_t *actx, wmem_strbuf_t* last_mcc_strbuf)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->last_mcc_strbuf = last_mcc_strbuf;
}

static uint32_t private_data_get_rbid(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->rbid;
}

static void private_data_set_rbid(asn1_ctx_t *actx, uint32_t rbid)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->rbid = rbid;
}

static uint32_t private_data_get_rlc_ciphering_sqn(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->rlc_ciphering_sqn;
}

static void private_data_set_rlc_ciphering_sqn(asn1_ctx_t *actx, uint32_t rlc_ciphering_sqn)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->rlc_ciphering_sqn = rlc_ciphering_sqn;
}

static rrc_ciphering_info* private_data_get_ciphering_info(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->ciphering_info;
}

static void private_data_set_ciphering_info(asn1_ctx_t *actx, rrc_ciphering_info* ciphering_info)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->ciphering_info = ciphering_info;
}

static enum rrc_ue_state private_data_get_rrc_state_indicator(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->rrc_state_indicator;
}

static void private_data_set_rrc_state_indicator(asn1_ctx_t *actx, enum rrc_ue_state rrc_state_indicator)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->rrc_state_indicator = rrc_state_indicator;
}

static enum rrc_sib_segment_type private_data_get_curr_sib_segment_type(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->curr_sib_segment_type;
}

static void private_data_set_curr_sib_segment_type(asn1_ctx_t *actx, enum rrc_sib_segment_type curr_sib_segment_type)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->curr_sib_segment_type = curr_sib_segment_type;
}

static uint32_t private_data_get_curr_sib_type(asn1_ctx_t *actx)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  return private_data->curr_sib_type;
}

static void private_data_set_curr_sib_type(asn1_ctx_t *actx, uint32_t curr_sib_type)
{
  umts_rrc_private_data_t *private_data = (umts_rrc_private_data_t*)umts_rrc_get_private_data(actx);
  private_data->curr_sib_type = curr_sib_type;
}

/*****************************************************************************/

static dissector_handle_t gsm_a_dtap_handle;
static dissector_handle_t rrc_ue_radio_access_cap_info_handle;
static dissector_handle_t rrc_pcch_handle;
static dissector_handle_t rrc_ul_ccch_handle;
static dissector_handle_t rrc_dl_ccch_handle;
static dissector_handle_t rrc_ul_dcch_handle;
static dissector_handle_t rrc_dl_dcch_handle;
static dissector_handle_t rrc_bcch_fach_handle;
static dissector_handle_t lte_rrc_ue_eutra_cap_handle;
static dissector_handle_t lte_rrc_dl_dcch_handle;
static dissector_handle_t gsm_rlcmac_dl_handle;

/* Forward declarations */
void proto_register_rrc(void);
void proto_reg_handoff_rrc(void);
static int dissect_UE_RadioAccessCapabilityInfo_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SysInfoType11bis_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SysInfoType11ter_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SysInfoType22_PDU(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);

/* Include constants */
#define hiPDSCHidentities              64
#define hiPUSCHidentities              64
#define hiRM                           256
#define maxAC                          16
#define maxAdditionalMeas              4
#define maxAddPos                      8
#define maxASC                         8
#define maxASCmap                      7
#define maxASCpersist                  6
#define maxBeacons                     64
#define maxBTs                         32
#define maxCCTrCH                      8
#define maxCellMeas                    32
#define maxCellMeas_ext                80
#define maxCellMeas_ext2               48
#define maxCellMeasOnSecULFreq         32
#define maxCellMeas_1                  31
#define maxCellMeas_ext_1              79
#define maxCellMeasOnSecULFreq_1       31
#define maxCNdomains                   4
#define maxCommonHRNTI                 4
#define maxCommonQueueID               2
#define maxCPCHsets                    16
#define maxDedicatedCSGFreq            4
#define maxDPCH_DLchan                 8
#define maxDPDCH_UL                    6
#define maxDRACclasses                 8
#define maxExcludedDetectedSetCells    64
#define maxE_DCHMACdFlow               8
#define maxE_DCHMACdFlow_1             7
#define maxMultipleFrequencyBandsFDD   8
#define maxMultipleFrequencyBandsEUTRA 8
#define maxEUTRACellPerFreq            16
#define maxEUTRATargetFreqs            8
#define maxEDCHRL                      4
#define maxEDCHRL_1                    3
#define maxEDCHs                       32
#define maxEDCHs_1                     31
#define maxEDCHTxPattern_TDD128        4
#define maxEDCHTxPattern_TDD128_1      3
#define maxERNTIgroup                  32
#define maxERNTIperGroup               2
#define maxERUCCH                      256
#define maxFACHPCH                     8
#define maxFreq                        8
#define maxFreqBandsEUTRA              16
#define maxFreqBandsEUTRA_ext          48
#define maxFreqBandsFDD                8
#define maxFreqBandsFDD2               22
#define maxFreqBandsFDD3               86
#define maxFreqBandsFDD_ext            15
#define maxFreqBandsFDD_ext2           64
#define maxFreqBandsFDD_ext3           78
#define maxFreqBandsIndicatorSupport   2
#define maxFreqBandsTDD                4
#define maxFreqBandsTDD_ext            16
#define maxFreqBandsGSM                16
#define maxFreqMeasWithoutCM           2
#define maxGANSS                       8
#define maxGANSS_1                     7
#define maxGANSSSat                    64
#define maxGANSSSat_1                  63
#define maxGERAN_SI                    8
#define maxGSMTargetCells              32
#define maxHNBNameSize                 48
#define maxHProcesses                  8
#define maxHS_SCCHLessTrBlk            4
#define maxHSDSCHTBIndex               64
#define maxHSDSCHTBIndex_tdd384        512
#define maxHSSCCHs                     4
#define maxHSSCCHs_1                   3
#define maxHSSICH_TDD128               4
#define maxHSSICH_TDD128_1             3
#define maxIGPInfo                     320
#define maxInterSysMessages            4
#define maxLoCHperRLC                  2
#define maxLoggedMeasReport            128
#define maxMAC_d_PDUsizes              8
#define maxMBMS_CommonCCTrCh           32
#define maxMBMS_CommonPhyCh            32
#define maxMBMS_CommonRB               32
#define maxMBMS_CommonTrCh             32
#define maxMBMS_Freq                   4
#define maxMBMS_L1CP                   4
#define maxMBMSservCount               8
#define maxMBMSservModif               32
#define maxMBMSservSched               16
#define maxMBMSservSelect              8
#define maxMBMSservUnmodif             64
#define maxMBMSTransmis                4
#define maxMBSFNClusters               16
#define maxMeasCSGRange                4
#define maxMeasEvent                   8
#define maxMeasEventOnSecULFreq        8
#define maxMeasIdentity                32
#define maxMeasIntervals               3
#define maxMeasOccasionPattern         5
#define maxMeasOccasionPattern_1       4
#define maxMeasParEvent                2
#define maxNonContiguousMultiCellCombinations 3
#define maxNumAccessGroups             16
#define maxNumAcdcCategory             16
#define maxNumCDMA2000Freqs            8
#define maxNumE_AGCH                   4
#define maxNumE_HICH                   4
#define maxNumEUTRAFreqs               8
#define maxNumEUTRAFreqs_FACH          4
#define maxNumEUTRAFreqs_FACH_ext      8
#define maxNumGSMCellGroup             16
#define maxNumGSMFreqRanges            32
#define maxNumFDDFreqs                 8
#define maxNumANRLoggedItems           4
#define maxnumLoggedMeas               8
#define maxNumMDTPLMN                  15
#define maxNumTDDFreqs                 8
#define maxNoOfMeas                    16
#define maxOtherRAT                    15
#define maxOtherRAT_16                 16
#define maxPage1                       8
#define maxPCPCH_APsig                 16
#define maxPCPCH_APsubCh               12
#define maxPCPCH_CDsig                 16
#define maxPCPCH_CDsubCh               12
#define maxPCPCH_SF                    7
#define maxPCPCHs                      64
#define maxPDCPAlgoType                8
#define maxPDSCH                       8
#define maxPDSCH_TFCIgroups            256
#define maxPRACH                       16
#define maxPRACH_EUL                   4
#define maxPRACH_FPACH                 8
#define maxPredefConfig                16
#define maxOtherStateConfig            4
#define maxOtherStateConfig_1          3
#define maxPrio                        8
#define maxPrio_1                      7
#define maxPrio_ext                    16
#define maxPUSCH                       8
#define maxQueueIDs                    8
#define maxRABsetup                    16
#define maxRAT                         16
#define maxRB                          32
#define maxRBallRABs                   27
#define maxRBMuxOptions                8
#define maxRBperRAB                    8
#define maxRBperTrCh                   16
#define maxReportedEUTRACellPerFreq    4
#define maxReportedEUTRAFreqs          4
#define maxReportedEUTRAFreqs_ext      8
#define maxReportedGSMCells            8
#define maxRetrievConfig               8
#define maxRetrievConfig_1             7
#define maxRL                          8
#define maxRL_1                        7
#define maxRLCPDUsizePerLogChan        32
#define maxRMPfrequencies              8
#define maxRFC3095_CID                 16384
#define maxROHC_PacketSizes_r4         16
#define maxROHC_Profile_r4             8
#define maxRxPatternForHSDSCH_TDD128   4
#define maxRxPatternForHSDSCH_TDD128_1 3
#define maxSat                         16
#define maxSatClockModels              4
#define maxSCCPCH                      16
#define maxSgnType                     8
#define maxSIB                         32
#define maxSIB2                        64
#define maxSIB_FACH                    8
#define maxSIBperMsg                   16
#define maxSIrequest                   4
#define maxSRBsetup                    8
#define maxSystemCapability            16
#define maxTDD128Carrier               6
#define maxTDD128Carrier_1             5
#define maxTbsForHSDSCH_TDD128         4
#define maxTbsForHSDSCH_TDD128_1       3
#define maxTF                          32
#define maxTF_CPCH                     16
#define maxTFC                         1024
#define maxTFCsub                      1024
#define maxTFCI_2_Combs                512
#define maxTGPS                        6
#define maxTrCH                        32
#define maxTrCHConcat                  3
#define maxTrCHpreconf                 32
#define maxTS                          14
#define maxTS_1                        13
#define maxTS_2                        12
#define maxTS_LCR                      6
#define maxTS_LCR_1                    5
#define maxURA                         8
#define maxURNTI_Group                 8
#define maxWLANID                      16
#define maxWLANs                       64

/* Initialize the protocol and registered fields */
int proto_rrc;
static int hf_test;
static int hf_urnti;
static int hf_urnti_new;
static int hf_urnti_current;
static int hf_rrc_DL_DCCH_Message_PDU;            /* DL_DCCH_Message */
static int hf_rrc_UL_DCCH_Message_PDU;            /* UL_DCCH_Message */
static int hf_rrc_DL_CCCH_Message_PDU;            /* DL_CCCH_Message */
static int hf_rrc_UL_CCCH_Message_PDU;            /* UL_CCCH_Message */
static int hf_rrc_PCCH_Message_PDU;               /* PCCH_Message */
static int hf_rrc_DL_SHCCH_Message_PDU;           /* DL_SHCCH_Message */
static int hf_rrc_UL_SHCCH_Message_PDU;           /* UL_SHCCH_Message */
static int hf_rrc_BCCH_FACH_Message_PDU;          /* BCCH_FACH_Message */
static int hf_rrc_BCCH_BCH_Message_PDU;           /* BCCH_BCH_Message */
static int hf_rrc_BCCH_BCH2_Message_PDU;          /* BCCH_BCH2_Message */
static int hf_rrc_MCCH_Message_PDU;               /* MCCH_Message */
static int hf_rrc_MSCH_Message_PDU;               /* MSCH_Message */
static int hf_rrc_rrc_HandoverToUTRANCommand_PDU;  /* HandoverToUTRANCommand */
static int hf_rrc_rrc_InterRATHandoverInfo_PDU;   /* InterRATHandoverInfo */
static int hf_rrc_rrc_MeasurementReport_PDU;      /* MeasurementReport */
static int hf_rrc_SystemInformation_BCH_PDU;      /* SystemInformation_BCH */
static int hf_rrc_SystemInformation2_BCH_PDU;     /* SystemInformation2_BCH */
static int hf_rrc_System_Information_Container_PDU;  /* System_Information_Container */
static int hf_rrc_UE_RadioAccessCapabilityInfo_PDU;  /* UE_RadioAccessCapabilityInfo */
static int hf_rrc_rrc_MasterInformationBlock_PDU;  /* MasterInformationBlock */
static int hf_rrc_rrc_SysInfoType1_PDU;           /* SysInfoType1 */
static int hf_rrc_rrc_SysInfoType2_PDU;           /* SysInfoType2 */
static int hf_rrc_rrc_SysInfoType3_PDU;           /* SysInfoType3 */
static int hf_rrc_rrc_SysInfoType4_PDU;           /* SysInfoType4 */
static int hf_rrc_rrc_SysInfoType5_PDU;           /* SysInfoType5 */
static int hf_rrc_SysInfoType5bis_PDU;            /* SysInfoType5bis */
static int hf_rrc_rrc_SysInfoType6_PDU;           /* SysInfoType6 */
static int hf_rrc_rrc_SysInfoType7_PDU;           /* SysInfoType7 */
static int hf_rrc_SysInfoType8_PDU;               /* SysInfoType8 */
static int hf_rrc_SysInfoType9_PDU;               /* SysInfoType9 */
static int hf_rrc_SysInfoType10_PDU;              /* SysInfoType10 */
static int hf_rrc_rrc_SysInfoType11_PDU;          /* SysInfoType11 */
static int hf_rrc_SysInfoType11bis_PDU;           /* SysInfoType11bis */
static int hf_rrc_SysInfoType11ter_PDU;           /* SysInfoType11ter */
static int hf_rrc_rrc_SysInfoType12_PDU;          /* SysInfoType12 */
static int hf_rrc_rrc_SysInfoType13_PDU;          /* SysInfoType13 */
static int hf_rrc_rrc_SysInfoType13_1_PDU;        /* SysInfoType13_1 */
static int hf_rrc_rrc_SysInfoType13_2_PDU;        /* SysInfoType13_2 */
static int hf_rrc_rrc_SysInfoType13_3_PDU;        /* SysInfoType13_3 */
static int hf_rrc_rrc_SysInfoType13_4_PDU;        /* SysInfoType13_4 */
static int hf_rrc_rrc_SysInfoType14_PDU;          /* SysInfoType14 */
static int hf_rrc_rrc_SysInfoType15_PDU;          /* SysInfoType15 */
static int hf_rrc_SysInfoType15bis_PDU;           /* SysInfoType15bis */
static int hf_rrc_rrc_SysInfoType15_1_PDU;        /* SysInfoType15_1 */
static int hf_rrc_SysInfoType15_1bis_PDU;         /* SysInfoType15_1bis */
static int hf_rrc_SysInfoType15_1ter_PDU;         /* SysInfoType15_1ter */
static int hf_rrc_rrc_SysInfoType15_2_PDU;        /* SysInfoType15_2 */
static int hf_rrc_SysInfoType15_2bis_PDU;         /* SysInfoType15_2bis */
static int hf_rrc_SysInfoType15_2ter_PDU;         /* SysInfoType15_2ter */
static int hf_rrc_rrc_SysInfoType15_3_PDU;        /* SysInfoType15_3 */
static int hf_rrc_SysInfoType15_3bis_PDU;         /* SysInfoType15_3bis */
static int hf_rrc_rrc_SysInfoType15_4_PDU;        /* SysInfoType15_4 */
static int hf_rrc_SysInfoType15_5_PDU;            /* SysInfoType15_5 */
static int hf_rrc_SysInfoType15_6_PDU;            /* SysInfoType15_6 */
static int hf_rrc_SysInfoType15_7_PDU;            /* SysInfoType15_7 */
static int hf_rrc_SysInfoType15_8_PDU;            /* SysInfoType15_8 */
static int hf_rrc_rrc_SysInfoType16_PDU;          /* SysInfoType16 */
static int hf_rrc_rrc_SysInfoType17_PDU;          /* SysInfoType17 */
static int hf_rrc_rrc_SysInfoType18_PDU;          /* SysInfoType18 */
static int hf_rrc_rrc_SysInfoType19_PDU;          /* SysInfoType19 */
static int hf_rrc_SysInfoType20_PDU;              /* SysInfoType20 */
static int hf_rrc_SysInfoType21_PDU;              /* SysInfoType21 */
static int hf_rrc_SysInfoType22_PDU;              /* SysInfoType22 */
static int hf_rrc_SysInfoType23_PDU;              /* SysInfoType23 */
static int hf_rrc_SysInfoType24_PDU;              /* SysInfoType24 */
static int hf_rrc_SysInfoType25_PDU;              /* SysInfoType25 */
static int hf_rrc_rrc_SysInfoTypeSB1_PDU;         /* SysInfoTypeSB1 */
static int hf_rrc_rrc_SysInfoTypeSB2_PDU;         /* SysInfoTypeSB2 */
static int hf_rrc_SysInfoTypeSB3_PDU;             /* SysInfoTypeSB3 */
static int hf_rrc_rrc_ToTargetRNC_Container_PDU;  /* ToTargetRNC_Container */
static int hf_rrc_rrc_TargetRNC_ToSourceRNC_Container_PDU;  /* TargetRNC_ToSourceRNC_Container */
static int hf_rrc_CellUpdate_r3_add_ext_IEs_PDU;  /* CellUpdate_r3_add_ext_IEs */
static int hf_rrc_CellUpdateConfirm_r7_add_ext_IEs_PDU;  /* CellUpdateConfirm_r7_add_ext_IEs */
static int hf_rrc_InitialDirectTransfer_r3_add_ext_IEs_PDU;  /* InitialDirectTransfer_r3_add_ext_IEs */
static int hf_rrc_InterRATHandoverInfo_r3_add_ext_IEs_PDU;  /* InterRATHandoverInfo_r3_add_ext_IEs */
static int hf_rrc_RadioBearerSetup_r7_add_ext_IEs_PDU;  /* RadioBearerSetup_r7_add_ext_IEs */
static int hf_rrc_RRCConnectionSetupComplete_r3_add_ext_IEs_PDU;  /* RRCConnectionSetupComplete_r3_add_ext_IEs */
static int hf_rrc_UE_CapabilityContainer_IEs_PDU;  /* UE_CapabilityContainer_IEs */
static int hf_rrc_UECapabilityInformation_r3_add_ext_IEs_PDU;  /* UECapabilityInformation_r3_add_ext_IEs */
static int hf_rrc_URAUpdate_r3_add_ext_IEs_PDU;   /* URAUpdate_r3_add_ext_IEs */
static int hf_rrc_SRNC_RelocationInfo_v3h0ext_IEs_PDU;  /* SRNC_RelocationInfo_v3h0ext_IEs */
static int hf_rrc_SRNC_RelocationInfo_r6_add_ext_IEs_PDU;  /* SRNC_RelocationInfo_r6_add_ext_IEs */
static int hf_rrc_SRNC_RelocationInfo_r7_add_ext_IEs_PDU;  /* SRNC_RelocationInfo_r7_add_ext_IEs */
static int hf_rrc_integrityCheckInfo;             /* IntegrityCheckInfo */
static int hf_rrc_message;                        /* DL_DCCH_MessageType */
static int hf_rrc_activeSetUpdate;                /* ActiveSetUpdate */
static int hf_rrc_assistanceDataDelivery;         /* AssistanceDataDelivery */
static int hf_rrc_cellChangeOrderFromUTRAN;       /* CellChangeOrderFromUTRAN */
static int hf_rrc_cellUpdateConfirm;              /* CellUpdateConfirm */
static int hf_rrc_counterCheck;                   /* CounterCheck */
static int hf_rrc_downlinkDirectTransfer;         /* DownlinkDirectTransfer */
static int hf_rrc_handoverFromUTRANCommand_GSM;   /* HandoverFromUTRANCommand_GSM */
static int hf_rrc_handoverFromUTRANCommand_CDMA2000;  /* HandoverFromUTRANCommand_CDMA2000 */
static int hf_rrc_measurementControl;             /* MeasurementControl */
static int hf_rrc_pagingType2;                    /* PagingType2 */
static int hf_rrc_physicalChannelReconfiguration;  /* PhysicalChannelReconfiguration */
static int hf_rrc_physicalSharedChannelAllocation;  /* PhysicalSharedChannelAllocation */
static int hf_rrc_radioBearerReconfiguration;     /* RadioBearerReconfiguration */
static int hf_rrc_radioBearerRelease;             /* RadioBearerRelease */
static int hf_rrc_radioBearerSetup;               /* RadioBearerSetup */
static int hf_rrc_rrcConnectionRelease;           /* RRCConnectionRelease */
static int hf_rrc_securityModeCommand;            /* SecurityModeCommand */
static int hf_rrc_signallingConnectionRelease;    /* SignallingConnectionRelease */
static int hf_rrc_transportChannelReconfiguration;  /* TransportChannelReconfiguration */
static int hf_rrc_transportFormatCombinationControl;  /* TransportFormatCombinationControl */
static int hf_rrc_ueCapabilityEnquiry;            /* UECapabilityEnquiry */
static int hf_rrc_ueCapabilityInformationConfirm;  /* UECapabilityInformationConfirm */
static int hf_rrc_uplinkPhysicalChannelControl;   /* UplinkPhysicalChannelControl */
static int hf_rrc_uraUpdateConfirm;               /* URAUpdateConfirm */
static int hf_rrc_utranMobilityInformation;       /* UTRANMobilityInformation */
static int hf_rrc_handoverFromUTRANCommand_GERANIu;  /* HandoverFromUTRANCommand_GERANIu */
static int hf_rrc_mbmsModifiedServicesInformation;  /* MBMSModifiedServicesInformation */
static int hf_rrc_etwsPrimaryNotificationWithSecurity;  /* ETWSPrimaryNotificationWithSecurity */
static int hf_rrc_handoverFromUTRANCommand_EUTRA;  /* HandoverFromUTRANCommand_EUTRA */
static int hf_rrc_ueInformationRequest;           /* UEInformationRequest */
static int hf_rrc_loggingMeasurementConfiguration;  /* LoggingMeasurementConfiguration */
static int hf_rrc_spare1;                         /* NULL */
static int hf_rrc_message_01;                     /* UL_DCCH_MessageType */
static int hf_rrc_activeSetUpdateComplete;        /* ActiveSetUpdateComplete */
static int hf_rrc_activeSetUpdateFailure;         /* ActiveSetUpdateFailure */
static int hf_rrc_cellChangeOrderFromUTRANFailure;  /* CellChangeOrderFromUTRANFailure */
static int hf_rrc_counterCheckResponse;           /* CounterCheckResponse */
static int hf_rrc_handoverToUTRANComplete;        /* HandoverToUTRANComplete */
static int hf_rrc_initialDirectTransfer;          /* InitialDirectTransfer */
static int hf_rrc_handoverFromUTRANFailure;       /* HandoverFromUTRANFailure */
static int hf_rrc_measurementControlFailure;      /* MeasurementControlFailure */
static int hf_rrc_measurementReport;              /* MeasurementReport */
static int hf_rrc_physicalChannelReconfigurationComplete;  /* PhysicalChannelReconfigurationComplete */
static int hf_rrc_physicalChannelReconfigurationFailure;  /* PhysicalChannelReconfigurationFailure */
static int hf_rrc_radioBearerReconfigurationComplete;  /* RadioBearerReconfigurationComplete */
static int hf_rrc_radioBearerReconfigurationFailure;  /* RadioBearerReconfigurationFailure */
static int hf_rrc_radioBearerReleaseComplete;     /* RadioBearerReleaseComplete */
static int hf_rrc_radioBearerReleaseFailure;      /* RadioBearerReleaseFailure */
static int hf_rrc_radioBearerSetupComplete;       /* RadioBearerSetupComplete */
static int hf_rrc_radioBearerSetupFailure;        /* RadioBearerSetupFailure */
static int hf_rrc_rrcConnectionReleaseComplete;   /* RRCConnectionReleaseComplete */
static int hf_rrc_rrcConnectionSetupComplete;     /* RRCConnectionSetupComplete */
static int hf_rrc_rrcStatus;                      /* RRCStatus */
static int hf_rrc_securityModeComplete;           /* SecurityModeComplete */
static int hf_rrc_securityModeFailure;            /* SecurityModeFailure */
static int hf_rrc_signallingConnectionReleaseIndication;  /* SignallingConnectionReleaseIndication */
static int hf_rrc_transportChannelReconfigurationComplete;  /* TransportChannelReconfigurationComplete */
static int hf_rrc_transportChannelReconfigurationFailure;  /* TransportChannelReconfigurationFailure */
static int hf_rrc_transportFormatCombinationControlFailure;  /* TransportFormatCombinationControlFailure */
static int hf_rrc_ueCapabilityInformation;        /* UECapabilityInformation */
static int hf_rrc_uplinkDirectTransfer;           /* UplinkDirectTransfer */
static int hf_rrc_utranMobilityInformationConfirm;  /* UTRANMobilityInformationConfirm */
static int hf_rrc_utranMobilityInformationFailure;  /* UTRANMobilityInformationFailure */
static int hf_rrc_mbmsModificationRequest;        /* MBMSModificationRequest */
static int hf_rrc_ul_DCCH_MessageType_ext;        /* UL_DCCH_MessageType_ext */
static int hf_rrc_ueInformationResponse;          /* UEInformationResponse */
static int hf_rrc_spare15;                        /* NULL */
static int hf_rrc_spare14;                        /* NULL */
static int hf_rrc_spare13;                        /* NULL */
static int hf_rrc_spare12;                        /* NULL */
static int hf_rrc_spare11;                        /* NULL */
static int hf_rrc_spare10;                        /* NULL */
static int hf_rrc_spare9;                         /* NULL */
static int hf_rrc_spare8;                         /* NULL */
static int hf_rrc_spare7;                         /* NULL */
static int hf_rrc_spare6;                         /* NULL */
static int hf_rrc_spare5;                         /* NULL */
static int hf_rrc_spare4;                         /* NULL */
static int hf_rrc_spare3;                         /* NULL */
static int hf_rrc_spare2;                         /* NULL */
static int hf_rrc_message_02;                     /* DL_CCCH_MessageType */
static int hf_rrc_cellUpdateConfirm_01;           /* CellUpdateConfirm_CCCH */
static int hf_rrc_rrcConnectionReject;            /* RRCConnectionReject */
static int hf_rrc_rrcConnectionRelease_01;        /* RRCConnectionRelease_CCCH */
static int hf_rrc_rrcConnectionSetup;             /* RRCConnectionSetup */
static int hf_rrc_uraUpdateConfirm_01;            /* URAUpdateConfirm_CCCH */
static int hf_rrc_dummy;                          /* ETWSPrimaryNotificationWithSecurity */
static int hf_rrc_message_03;                     /* UL_CCCH_MessageType */
static int hf_rrc_cellUpdate;                     /* CellUpdate */
static int hf_rrc_rrcConnectionRequest;           /* RRCConnectionRequest */
static int hf_rrc_uraUpdate;                      /* URAUpdate */
static int hf_rrc_uL_CCCH_MessageType_r11;        /* UL_CCCH_MessageType_r11 */
static int hf_rrc_cellUpdate_01;                  /* CellUpdateFDD_r11 */
static int hf_rrc_message_04;                     /* PCCH_MessageType */
static int hf_rrc_pagingType1;                    /* PagingType1 */
static int hf_rrc_spare;                          /* NULL */
static int hf_rrc_message_05;                     /* DL_SHCCH_MessageType */
static int hf_rrc_message_06;                     /* UL_SHCCH_MessageType */
static int hf_rrc_puschCapacityRequest;           /* PUSCHCapacityRequest */
static int hf_rrc_message_07;                     /* BCCH_FACH_MessageType */
static int hf_rrc_dummy_01;                       /* SystemInformation_FACH */
static int hf_rrc_systemInformationChangeIndication;  /* SystemInformationChangeIndication */
static int hf_rrc_message_08;                     /* SystemInformation_BCH */
static int hf_rrc_message_09;                     /* SystemInformation2_BCH */
static int hf_rrc_message_10;                     /* MCCH_MessageType */
static int hf_rrc_mbmsAccessInformation;          /* MBMSAccessInformation */
static int hf_rrc_mbmsCommonPTMRBInformation;     /* MBMSCommonPTMRBInformation */
static int hf_rrc_mbmsCurrentCellPTMRBInformation;  /* MBMSCurrentCellPTMRBInformation */
static int hf_rrc_mbmsGeneralInformation;         /* MBMSGeneralInformation */
static int hf_rrc_mbmsNeighbouringCellPTMRBInformation;  /* MBMSNeighbouringCellPTMRBInformation */
static int hf_rrc_mbmsUnmodifiedServicesInformation;  /* MBMSUnmodifiedServicesInformation */
static int hf_rrc_message_11;                     /* MSCH_MessageType */
static int hf_rrc_mbmsSchedulingInformation;      /* MBMSSchedulingInformation */
static int hf_rrc_r3;                             /* T_r3 */
static int hf_rrc_activeSetUpdate_r3;             /* ActiveSetUpdate_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions;     /* T_laterNonCriticalExtensions */
static int hf_rrc_activeSetUpdate_r3_add_ext;     /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions;      /* T_v4b0NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v4b0ext;        /* ActiveSetUpdate_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions;      /* T_v590NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v590ext;        /* ActiveSetUpdate_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions;      /* T_v690NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v690ext;        /* ActiveSetUpdate_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions;          /* T_nonCriticalExtensions */
static int hf_rrc_later_than_r3;                  /* T_later_than_r3 */
static int hf_rrc_rrc_TransactionIdentifier;      /* RRC_TransactionIdentifier */
static int hf_rrc_criticalExtensions;             /* T_criticalExtensions */
static int hf_rrc_r6;                             /* T_r6 */
static int hf_rrc_activeSetUpdate_r6;             /* ActiveSetUpdate_r6_IEs */
static int hf_rrc_activeSetUpdate_r6_add_ext;     /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions;      /* T_v6b0NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v6b0ext;        /* ActiveSetUpdate_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_01;       /* T_nonCriticalExtensions_01 */
static int hf_rrc_criticalExtensions_01;          /* T_criticalExtensions_01 */
static int hf_rrc_r7;                             /* T_r7 */
static int hf_rrc_activeSetUpdate_r7;             /* ActiveSetUpdate_r7_IEs */
static int hf_rrc_activeSetUpdate_r7_add_ext;     /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions;      /* T_v780NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v780ext;        /* ActiveSetUpdate_v780ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions;      /* T_v7f0NonCriticalExtensions */
static int hf_rrc_activeSetUdpate_v7f0ext;        /* ActiveSetUpdate_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions;      /* T_v7g0NonCriticalExtensions */
static int hf_rrc_activeSetUdpate_v7g0ext;        /* ActiveSetUpdate_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_02;       /* T_nonCriticalExtensions_02 */
static int hf_rrc_criticalExtensions_02;          /* T_criticalExtensions_02 */
static int hf_rrc_r8;                             /* T_r8 */
static int hf_rrc_activeSetUpdate_r8;             /* ActiveSetUpdate_r8_IEs */
static int hf_rrc_activeSetUpdate_r8_add_ext;     /* BIT_STRING */
static int hf_rrc_v890NonCriticalExtensions;      /* T_v890NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v890ext;        /* ActiveSetUpdate_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_01;   /* T_v7g0NonCriticalExtensions_01 */
static int hf_rrc_activeSetUpdate_v7g0ext;        /* ActiveSetUpdate_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_03;       /* T_nonCriticalExtensions_03 */
static int hf_rrc_criticalExtensions_03;          /* T_criticalExtensions_03 */
static int hf_rrc_r9;                             /* T_r9 */
static int hf_rrc_activeSetUpdate_r9;             /* ActiveSetUpdate_r9_IEs */
static int hf_rrc_activeSetUpdate_r9_add_ext;     /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions;      /* T_v950NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_v950ext;        /* ActiveSetUpdate_v950ext_IEs */
static int hf_rrc_nonCriticalExtensions_04;       /* T_nonCriticalExtensions_04 */
static int hf_rrc_criticalExtensions_04;          /* T_criticalExtensions_04 */
static int hf_rrc_r10;                            /* T_r10 */
static int hf_rrc_activeSetUpdate_r10;            /* ActiveSetUpdate_r10_IEs */
static int hf_rrc_activeSetUpdate_r10_add_ext;    /* BIT_STRING */
static int hf_rrc_vb50NonCriticalExtensions;      /* T_vb50NonCriticalExtensions */
static int hf_rrc_activeSetUpdate_vb50ext;        /* ActiveSetUpdate_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_05;       /* T_nonCriticalExtensions_05 */
static int hf_rrc_criticalExtensions_05;          /* T_criticalExtensions_05 */
static int hf_rrc_r11;                            /* T_r11 */
static int hf_rrc_activeSetUpdate_r11;            /* ActiveSetUpdate_r11_IEs */
static int hf_rrc_activeSetUpdate_r11_add_ext;    /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_06;       /* T_nonCriticalExtensions_06 */
static int hf_rrc_criticalExtensions_06;          /* T_criticalExtensions_06 */
static int hf_rrc_r12;                            /* T_r12 */
static int hf_rrc_activeSetUpdate_r12;            /* ActiveSetUpdate_r12_IEs */
static int hf_rrc_activeSetUpdate_r12_add_ext;    /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_07;       /* T_nonCriticalExtensions_07 */
static int hf_rrc_criticalExtensions_07;          /* T_criticalExtensions_07 */
static int hf_rrc_r13;                            /* T_r13 */
static int hf_rrc_activeSetUpdate_r13;            /* ActiveSetUpdate_r13_IEs */
static int hf_rrc_activeSetUpdate_r13_add_ext;    /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_08;       /* T_nonCriticalExtensions_08 */
static int hf_rrc_criticalExtensions_08;          /* T_criticalExtensions_08 */
static int hf_rrc_integrityProtectionModeInfo;    /* IntegrityProtectionModeInfo */
static int hf_rrc_cipheringModeInfo;              /* CipheringModeInfo */
static int hf_rrc_activationTime;                 /* ActivationTime */
static int hf_rrc_newU_RNTI;                      /* U_RNTI */
static int hf_rrc_cn_InformationInfo;             /* CN_InformationInfo */
static int hf_rrc_dL_CounterSynchronisationInfo;  /* DL_CounterSynchronisationInfo */
static int hf_rrc_maxAllowedUL_TX_Power;          /* MaxAllowedUL_TX_Power */
static int hf_rrc_rl_AdditionInformationList;     /* RL_AdditionInformationList */
static int hf_rrc_rl_RemovalInformationList;      /* RL_RemovalInformationList */
static int hf_rrc_tx_DiversityMode;               /* TX_DiversityMode */
static int hf_rrc_sSDT_Information;               /* SSDT_Information */
static int hf_rrc_sSDT_UL;                        /* SSDT_UL */
static int hf_rrc_cell_id_PerRL_List;             /* CellIdentity_PerRL_List */
static int hf_rrc_dpc_Mode;                       /* DPC_Mode */
static int hf_rrc_dl_TPC_PowerOffsetPerRL_List;   /* DL_TPC_PowerOffsetPerRL_List */
static int hf_rrc_primary_plmn_Identity;          /* PLMN_Identity */
static int hf_rrc_newH_RNTI;                      /* H_RNTI */
static int hf_rrc_newPrimary_E_RNTI;              /* E_RNTI */
static int hf_rrc_newSecondary_E_RNTI;            /* E_RNTI */
static int hf_rrc_cn_InformationInfo_01;          /* CN_InformationInfo_r6 */
static int hf_rrc_rl_AdditionInformationList_01;  /* RL_AdditionInformationList_r6 */
static int hf_rrc_serving_HSDSCH_CellInformation;  /* Serving_HSDSCH_CellInformation */
static int hf_rrc_e_dch_ReconfigurationInfo;      /* E_DCH_ReconfigurationInfo */
static int hf_rrc_rl_AdditionInformation_list_v6b0ext;  /* RL_AdditionInformation_list_v6b0ext */
static int hf_rrc_dtx_drx_TimingInfo;             /* DTX_DRX_TimingInfo_r7 */
static int hf_rrc_dtx_drx_Info;                   /* DTX_DRX_Info_r7 */
static int hf_rrc_hs_scch_LessInfo;               /* HS_SCCH_LessInfo_r7 */
static int hf_rrc_mimoParameters;                 /* MIMO_Parameters_r7 */
static int hf_rrc_rl_AdditionInformationList_02;  /* RL_AdditionInformationList_r7 */
static int hf_rrc_serving_HSDSCH_CellInformation_01;  /* Serving_HSDSCH_CellInformation_r7 */
static int hf_rrc_e_dch_ReconfigurationInfo_01;   /* E_DCH_ReconfigurationInfo_r7 */
static int hf_rrc_ul_16QAM_Config;                /* UL_16QAM_Config */
static int hf_rrc_e_dch_ReconfInfoSameCell;       /* E_DCH_RL_InfoSameServingCell */
static int hf_rrc_e_TFC_Boost_Info;               /* E_TFC_Boost_Info_r7 */
static int hf_rrc_e_DPDCH_PowerInterpolation;     /* E_DPDCH_PowerInterpolation */
static int hf_rrc_hs_DSCH_TBSizeTable;            /* HS_DSCH_TBSizeTable */
static int hf_rrc_mimoParameters_01;              /* MIMO_Parameters_v7f0ext */
static int hf_rrc_mimoParameters_02;              /* MIMO_Parameters_v7g0ext */
static int hf_rrc_mimoParameters_03;              /* MIMO_Parameters_r8 */
static int hf_rrc_rl_AdditionInformationList_03;  /* RL_AdditionInformationList_r8 */
static int hf_rrc_servingCellChangeParameters;    /* ServingCellChangeParameters */
static int hf_rrc_serving_HSDSCH_CellInformation_02;  /* Serving_HSDSCH_CellInformation_r8 */
static int hf_rrc_dl_SecondaryCellInfoFDD;        /* DL_SecondaryCellInfoFDD */
static int hf_rrc_dl_SecondaryCellInfoFDD_v890ext;  /* DL_SecondaryCellInfoFDD_v890ext */
static int hf_rrc_rl_AdditionInformationList_04;  /* RL_AdditionInformationList_v890ext */
static int hf_rrc_mimoParameters_04;              /* MIMO_Parameters_r9 */
static int hf_rrc_ul_SecondaryCellInfoFDD;        /* UL_SecondaryCellInfoFDD */
static int hf_rrc_e_dch_ReconfigurationInfo_SecULFrequency;  /* E_DCH_ReconfigurationInfo_SecULFrequency */
static int hf_rrc_rl_AdditionInformationList_05;  /* RL_AdditionInformationList_r9 */
static int hf_rrc_rl_AdditionInformationList_SecULFreq;  /* RL_AdditionInformationList_SecULFreq */
static int hf_rrc_rl_RemovalInformationList_SecULFreq;  /* RL_RemovalInformationList_SecULFreq */
static int hf_rrc_serving_HSDSCH_CellInformation_03;  /* Serving_HSDSCH_CellInformation_r9 */
static int hf_rrc_dl_SecondaryCellInfoFDD_01;     /* DL_SecondaryCellInfoFDD_r9 */
static int hf_rrc_secondaryCellMimoParameters;    /* SecondaryCellMIMOparametersFDD_v950ext */
static int hf_rrc_rl_AdditionInformationList_06;  /* RL_AdditionInformationList_v950ext */
static int hf_rrc_rl_AdditionInformationList_07;  /* RL_AdditionInformationList_r10 */
static int hf_rrc_dl_SecondaryCellInfoFDD_02;     /* DL_SecondaryCellInfoFDD_r10 */
static int hf_rrc_additionalDLSecCellInfoListFDD;  /* AdditionalDLSecCellInfoListFDD */
static int hf_rrc_ulOLTDInfoFDD;                  /* UL_OLTD_InfoFDD */
static int hf_rrc_rl_AdditionInformationList_08;  /* RL_AdditionInformationList_vb50ext */
static int hf_rrc_mimo4x4Parameters;              /* MIMO4x4_Parameters */
static int hf_rrc_ul_CLTD_InfoFDD;                /* UL_CLTD_InfoFDD */
static int hf_rrc_f_tpich_ReconfigurationInfo;    /* F_TPICH_ReconfigurationInfo */
static int hf_rrc_ul_OLTD_InfoFDD;                /* UL_OLTD_InfoFDD */
static int hf_rrc_rl_AdditionInformationList_09;  /* RL_AdditionInformationList_r11 */
static int hf_rrc_serving_HSDSCH_CellInformation_04;  /* Serving_HSDSCH_CellInformation_r11 */
static int hf_rrc_e_dch_ReconfigurationInfo_02;   /* E_DCH_ReconfigurationInfo_r11 */
static int hf_rrc_ul_64QAM_Config;                /* UL_64QAM_Config */
static int hf_rrc_ul_MIMO_InfoFDD;                /* UL_MIMO_InfoFDD */
static int hf_rrc_dl_SecondaryCellInfoFDD_03;     /* DL_SecondaryCellInfoFDD_r11 */
static int hf_rrc_additionalDLSecCellInfoListFDD_01;  /* AdditionalDLSecCellInfoListFDD_r11 */
static int hf_rrc_additionalDLSecCellInfoListFDD2;  /* AdditionalDLSecCellInfoListFDD2 */
static int hf_rrc_dtx_drx_Info_01;                /* DTX_DRX_Info_r12 */
static int hf_rrc_dch_Enhancements_Info_FDD;      /* DCH_Enhancements_Info_FDD */
static int hf_rrc_ul_SecondaryCellInfoFDD_01;     /* UL_SecondaryCellInfoFDD_r12 */
static int hf_rrc_rl_AdditionInformationList_10;  /* RL_AdditionInformationList_r12 */
static int hf_rrc_rl_AdditionInformationList_SecULFreq_01;  /* RL_AdditionInformationList_SecULFreq_r12 */
static int hf_rrc_servingCellChangeParameters_01;  /* ServingCellChangeParameters_r12 */
static int hf_rrc_serving_HSDSCH_CellInformation_05;  /* Serving_HSDSCH_CellInformation_r12 */
static int hf_rrc_dPCCH2InfoFDD;                  /* DPCCH2InfoFDD */
static int hf_rrc_dynamicActivationTime;          /* DynamicActivationTime */
static int hf_rrc_ul_SecondaryCellInfoFDD_02;     /* UL_SecondaryCellInfoFDD_r13 */
static int hf_rrc_rl_AdditionInformationList_11;  /* RL_AdditionInformationList_r13 */
static int hf_rrc_rl_AdditionInformationList_SecULFreq_02;  /* RL_AdditionInformationList_SecULFreq_r13 */
static int hf_rrc_integrityProtActivationInfo;    /* IntegrityProtActivationInfo */
static int hf_rrc_rB_ActivationTimeInfoList;      /* RB_ActivationTimeInfoList */
static int hf_rrc_uL_CounterSynchronisationInfo;  /* UL_CounterSynchronisationInfo */
static int hf_rrc_laterNonCriticalExtensions_01;  /* T_laterNonCriticalExtensions_01 */
static int hf_rrc_activeSetUpdateComplete_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_09;       /* T_nonCriticalExtensions_09 */
static int hf_rrc_failureCause;                   /* FailureCauseWithProtErr */
static int hf_rrc_laterNonCriticalExtensions_02;  /* T_laterNonCriticalExtensions_02 */
static int hf_rrc_activeSetUpdateFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_10;       /* T_nonCriticalExtensions_10 */
static int hf_rrc_r3_01;                          /* T_r3_01 */
static int hf_rrc_assistanceDataDelivery_r3;      /* AssistanceDataDelivery_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions;      /* T_v3a0NonCriticalExtensions */
static int hf_rrc_assistanceDataDelivery_v3a0ext;  /* AssistanceDataDelivery_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_03;  /* T_laterNonCriticalExtensions_03 */
static int hf_rrc_assistanceDataDelivery_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_01;   /* T_v4b0NonCriticalExtensions_01 */
static int hf_rrc_assistanceDataDelivery_v4b0ext;  /* AssistanceDataDelivery_v4b0ext_IEs */
static int hf_rrc_v770NonCriticalExtension;       /* T_v770NonCriticalExtension */
static int hf_rrc_assistanceDataDelivery_v770ext;  /* AssistanceDataDelivery_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtension;       /* T_v860NonCriticalExtension */
static int hf_rrc_assistanceDataDelivery_v860ext;  /* AssistanceDataDelivery_v860ext_IEs */
static int hf_rrc_v920NonCriticalExtension;       /* T_v920NonCriticalExtension */
static int hf_rrc_assistanceDataDelivery_v920ext;  /* AssistanceDataDelivery_v920ext_IEs */
static int hf_rrc_va40NonCriticalExtension;       /* T_va40NonCriticalExtension */
static int hf_rrc_assistanceDataDelivery_va40ext;  /* AssistanceDataDelivery_va40ext_IEs */
static int hf_rrc_vc50NonCriticalExtension;       /* T_vc50NonCriticalExtension */
static int hf_rrc_assistanceDataDelivery_vc50ext;  /* AssistanceDataDelivery_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_11;       /* T_nonCriticalExtensions_11 */
static int hf_rrc_later_than_r3_01;               /* T_later_than_r3_01 */
static int hf_rrc_criticalExtensions_09;          /* T_criticalExtensions_09 */
static int hf_rrc_ue_positioning_GPS_AssistanceData;  /* UE_Positioning_GPS_AssistanceData */
static int hf_rrc_ue_positioning_OTDOA_AssistanceData_UEB;  /* UE_Positioning_OTDOA_AssistanceData_UEB */
static int hf_rrc_sfn_Offset_Validity;            /* SFN_Offset_Validity */
static int hf_rrc_ue_Positioning_OTDOA_AssistanceData_r4ext;  /* UE_Positioning_OTDOA_AssistanceData_r4ext */
static int hf_rrc_ue_Positioning_OTDOA_AssistanceData_UEB_ext;  /* UE_Positioning_OTDOA_AssistanceData_UEB_ext */
static int hf_rrc_ue_Positioning_GPS_AssistanceData;  /* UE_Positioning_GPS_AssistanceData_v770ext */
static int hf_rrc_ue_positioning_GANSS_AssistanceData;  /* UE_Positioning_GANSS_AssistanceData */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_v860ext;  /* UE_Positioning_GANSS_AssistanceData_v860ext */
static int hf_rrc_ue_positioning_GPS_AssistanceData_v920ext;  /* UE_Positioning_GPS_AssistanceData_v920ext */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_v920ext;  /* UE_Positioning_GANSS_AssistanceData_v920ext */
static int hf_rrc_ue_positioning_GPS_AssistanceData_va40ext;  /* UE_Positioning_GPS_AssistanceData_va40ext */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_va40ext;  /* UE_Positioning_GANSS_AssistanceData_va40ext */
static int hf_rrc_ue_positioning_GPS_AssistanceData_vc50ext;  /* UE_Positioning_GPS_AssistanceData_vc50ext */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_vc50ext;  /* UE_Positioning_GANSS_AssistanceData_vc50ext */
static int hf_rrc_r3_02;                          /* T_r3_02 */
static int hf_rrc_cellChangeOrderFromUTRAN_IEs;   /* CellChangeOrderFromUTRAN_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_04;  /* T_laterNonCriticalExtensions_04 */
static int hf_rrc_cellChangeOrderFromUTRAN_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_01;   /* T_v590NonCriticalExtensions_01 */
static int hf_rrc_cellChangeOrderFromUTRAN_v590ext;  /* CellChangeOrderFromUTRAN_v590ext_IEs */
static int hf_rrc_nonCriticalExtensions_12;       /* T_nonCriticalExtensions_12 */
static int hf_rrc_later_than_r3_02;               /* T_later_than_r3_02 */
static int hf_rrc_criticalExtensions_10;          /* T_criticalExtensions_10 */
static int hf_rrc_rab_InformationList;            /* RAB_InformationList */
static int hf_rrc_interRAT_TargetCellDescription;  /* InterRAT_TargetCellDescription */
static int hf_rrc_geran_SystemInfoType;           /* T_geran_SystemInfoType */
static int hf_rrc_sI;                             /* GERAN_SystemInformation */
static int hf_rrc_pSI;                            /* GERAN_SystemInformation */
static int hf_rrc_r3_03;                          /* T_r3_03 */
static int hf_rrc_cellChangeOrderFromUTRANFailure_r3;  /* CellChangeOrderFromUTRANFailure_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_05;  /* T_laterNonCriticalExtensions_05 */
static int hf_rrc_cellChangeOrderFromUTRANFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_13;       /* T_nonCriticalExtensions_13 */
static int hf_rrc_dummy_02;                       /* T_dummy */
static int hf_rrc_criticalExtensions_11;          /* T_criticalExtensions_11 */
static int hf_rrc_interRAT_ChangeFailureCause;    /* InterRAT_ChangeFailureCause */
static int hf_rrc_u_RNTI;                         /* U_RNTI */
static int hf_rrc_startList;                      /* STARTList */
static int hf_rrc_am_RLC_ErrorIndicationRb2_3or4;  /* BOOLEAN */
static int hf_rrc_am_RLC_ErrorIndicationRb5orAbove;  /* BOOLEAN */
static int hf_rrc_cellUpdateCause;                /* CellUpdateCause */
static int hf_rrc_failureCause_01;                /* FailureCauseWithProtErrTrId */
static int hf_rrc_rb_timer_indicator;             /* Rb_timer_indicator */
static int hf_rrc_measuredResultsOnRACH;          /* MeasuredResultsOnRACH */
static int hf_rrc_laterNonCriticalExtensions_06;  /* T_laterNonCriticalExtensions_06 */
static int hf_rrc_cellUpdate_r3_add_ext;          /* T_cellUpdate_r3_add_ext */
static int hf_rrc_v590NonCriticalExtensions_02;   /* T_v590NonCriticalExtensions_02 */
static int hf_rrc_cellUpdate_v590ext;             /* CellUpdate_v590ext */
static int hf_rrc_v690NonCriticalExtensions_01;   /* T_v690NonCriticalExtensions_01 */
static int hf_rrc_cellUpdate_v690ext;             /* CellUpdate_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_01;   /* T_v6b0NonCriticalExtensions_01 */
static int hf_rrc_cellUpdate_v6b0ext;             /* CellUpdate_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions;      /* T_v770NonCriticalExtensions */
static int hf_rrc_cellUpdate_v770ext;             /* CellUpdate_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions;      /* T_v860NonCriticalExtensions */
static int hf_rrc_cellUpdate_v860ext;             /* CellUpdate_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions;      /* T_va40NonCriticalExtensions */
static int hf_rrc_cellUpdate_va40ext;             /* CellUpdate_va40ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_01;   /* T_vb50NonCriticalExtensions_01 */
static int hf_rrc_cellUpdate_vb50ext;             /* CellUpdate_vb50ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions;      /* T_vc50NonCriticalExtensions */
static int hf_rrc_cellUpdate_vc50ext;             /* CellUpdate_vc50ext_IEs */
static int hf_rrc_ve30LaterNonCriticalExtensions;  /* CellUpdate_ve30ext_IEs */
static int hf_rrc_cellUpdateCause_ext2;           /* CellUpdateCause_ext2 */
static int hf_rrc_nonCriticalExtensions_14;       /* T_nonCriticalExtensions_14 */
static int hf_rrc_cellUpdate_v7e0ext;             /* CellUpdate_v7e0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_02;   /* T_v7g0NonCriticalExtensions_02 */
static int hf_rrc_cellUpdate_v7g0ext;             /* CellUpdate_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_15;       /* T_nonCriticalExtensions_15 */
static int hf_rrc_establishmentCause;             /* EstablishmentCause */
static int hf_rrc_cellUpdateCause_ext;            /* CellUpdateCause_ext */
static int hf_rrc_trafficVolumeIndicator;         /* T_trafficVolumeIndicator */
static int hf_rrc_measuredResultsOnRACHinterFreq;  /* MeasuredResultsOnRACHinterFreq */
static int hf_rrc_reconfigurationStatusIndicator;  /* T_reconfigurationStatusIndicator */
static int hf_rrc_mbmsSelectedServices;           /* MBMS_SelectedServicesShort */
static int hf_rrc_csCallType;                     /* T_csCallType */
static int hf_rrc_hspdschReception_CellFach;      /* T_hspdschReception_CellFach */
static int hf_rrc_ueMobilityStateIndicator;       /* High_MobilityDetected */
static int hf_rrc_capabilityChangeIndicator;      /* T_capabilityChangeIndicator */
static int hf_rrc_supportForTwoDRXSchemesInPCH;   /* T_supportForTwoDRXSchemesInPCH */
static int hf_rrc_measuredResultsOnRACH_v7g0ext;  /* MeasuredResultsOnRACH_v7g0ext */
static int hf_rrc_supportOfCommonEDCH;            /* T_supportOfCommonEDCH */
static int hf_rrc_supportOfHS_DSCHDRXOperation;   /* T_supportOfHS_DSCHDRXOperation */
static int hf_rrc_supportOfMACiis;                /* T_supportOfMACiis */
static int hf_rrc_supportOfSPSOperation;          /* T_supportOfSPSOperation */
static int hf_rrc_supportOfControlChannelDRXOperation;  /* T_supportOfControlChannelDRXOperation */
static int hf_rrc_securityRevertStatusIndicator;  /* T_securityRevertStatusIndicator */
static int hf_rrc_loggedMeasAvailable;            /* T_loggedMeasAvailable */
static int hf_rrc_loggedANRResultsAvailable;      /* T_loggedANRResultsAvailable */
static int hf_rrc_trafficVolumeIndicator_01;      /* T_trafficVolumeIndicator_01 */
static int hf_rrc_reconfigurationStatusIndicator_01;  /* T_reconfigurationStatusIndicator_01 */
static int hf_rrc_csCallType_01;                  /* T_csCallType_01 */
static int hf_rrc_hspdschReception_CellFach_01;   /* T_hspdschReception_CellFach_01 */
static int hf_rrc_capabilityChangeIndicator_01;   /* T_capabilityChangeIndicator_01 */
static int hf_rrc_supportOfCommonEDCH_01;         /* T_supportOfCommonEDCH_01 */
static int hf_rrc_supportOfHS_DSCHDRXOperation_01;  /* T_supportOfHS_DSCHDRXOperation_01 */
static int hf_rrc_supportOfMACiis_01;             /* T_supportOfMACiis_01 */
static int hf_rrc_securityRevertStatusIndicator_01;  /* T_securityRevertStatusIndicator_01 */
static int hf_rrc_applicationLayerMeasurementReportAvailable;  /* T_applicationLayerMeasurementReportAvailable */
static int hf_rrc_spare3_01;                      /* T_spare3 */
static int hf_rrc_spare2_01;                      /* T_spare2 */
static int hf_rrc_spare1_01;                      /* T_spare1 */
static int hf_rrc_measuredResultsOnRACH_01;       /* MeasuredResultsOnRACHFDD_r11 */
static int hf_rrc_loggedMeasAvailable_01;         /* T_loggedMeasAvailable_01 */
static int hf_rrc_loggedANRResultsAvailable_01;   /* T_loggedANRResultsAvailable_01 */
static int hf_rrc_measuredResultsOnRACHEUTRAFreq;  /* MeasuredResultsOnRACH_EUTRAFreq */
static int hf_rrc_measuredResultsOnRACH_02;       /* MeasuredResultsOnRACH_vc50ext */
static int hf_rrc_r3_04;                          /* T_r3_04 */
static int hf_rrc_cellUpdateConfirm_r3;           /* CellUpdateConfirm_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_01;   /* T_v3a0NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v3a0ext;      /* CellUpdateConfirm_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_07;  /* T_laterNonCriticalExtensions_07 */
static int hf_rrc_cellUpdateConfirm_r3_add_ext;   /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_02;   /* T_v4b0NonCriticalExtensions_02 */
static int hf_rrc_cellUpdateConfirm_v4b0ext;      /* CellUpdateConfirm_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtenstions;     /* T_v590NonCriticalExtenstions */
static int hf_rrc_cellUpdateConfirm_v590ext;      /* CellUpdateConfirm_v590ext_IEs */
static int hf_rrc_v5d0NonCriticalExtenstions;     /* T_v5d0NonCriticalExtenstions */
static int hf_rrc_cellUpdateConfirm_v5d0ext;      /* CellUpdateConfirm_v5d0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_02;   /* T_v690NonCriticalExtensions_02 */
static int hf_rrc_cellUpdateConfirm_v690ext;      /* CellUpdateConfirm_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_16;       /* T_nonCriticalExtensions_16 */
static int hf_rrc_later_than_r3_03;               /* T_later_than_r3_03 */
static int hf_rrc_criticalExtensions_12;          /* T_criticalExtensions_12 */
static int hf_rrc_r4;                             /* T_r4 */
static int hf_rrc_cellUpdateConfirm_r4;           /* CellUpdateConfirm_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions;      /* T_v4d0NonCriticalExtensions */
static int hf_rrc_cellUpdateConfirm_r4_add_ext;   /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtenstions_01;  /* T_v590NonCriticalExtenstions_01 */
static int hf_rrc_v5d0NonCriticalExtenstions_01;  /* T_v5d0NonCriticalExtenstions_01 */
static int hf_rrc_v690NonCriticalExtensions_03;   /* T_v690NonCriticalExtensions_03 */
static int hf_rrc_nonCriticalExtensions_17;       /* T_nonCriticalExtensions_17 */
static int hf_rrc_criticalExtensions_13;          /* T_criticalExtensions_13 */
static int hf_rrc_r5;                             /* T_r5 */
static int hf_rrc_cellUpdateConfirm_r5;           /* CellUpdateConfirm_r5_IEs */
static int hf_rrc_cellUpdateConfirm_r5_add_ext;   /* BIT_STRING */
static int hf_rrc_v5d0NonCriticalExtenstions_02;  /* T_v5d0NonCriticalExtenstions_02 */
static int hf_rrc_v690NonCriticalExtensions_04;   /* T_v690NonCriticalExtensions_04 */
static int hf_rrc_nonCriticalExtensions_18;       /* T_nonCriticalExtensions_18 */
static int hf_rrc_criticalExtensions_14;          /* T_criticalExtensions_14 */
static int hf_rrc_r6_01;                          /* T_r6_01 */
static int hf_rrc_cellUpdateConfirm_r6;           /* CellUpdateConfirm_r6_IEs */
static int hf_rrc_cellUpdateConfirm_r6_add_ext;   /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_02;   /* T_v6b0NonCriticalExtensions_02 */
static int hf_rrc_cellUpdateConfirm_v6b0ext;      /* CellUpdateConfirm_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_19;       /* T_nonCriticalExtensions_19 */
static int hf_rrc_criticalExtensions_15;          /* T_criticalExtensions_15 */
static int hf_rrc_r7_01;                          /* T_r7_01 */
static int hf_rrc_cellUpdateConfirm_r7;           /* CellUpdateConfirm_r7_IEs */
static int hf_rrc_cellUpdateConfirm_r7_add_ext;   /* T_cellUpdateConfirm_r7_add_ext */
static int hf_rrc_v780NonCriticalExtensions_01;   /* T_v780NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v780ext;      /* CellUpdateConfirm_v780ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_01;   /* T_v860NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v860ext;      /* CellUpdateConfirm_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_20;       /* T_nonCriticalExtensions_20 */
static int hf_rrc_criticalExtensions_16;          /* T_criticalExtensions_16 */
static int hf_rrc_r8_01;                          /* T_r8_01 */
static int hf_rrc_cellUpdateConfirm_r8;           /* CellUpdateConfirm_r8_IEs */
static int hf_rrc_cellUpdateConfirm_r8_add_ext;   /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions;      /* T_v7d0NonCriticalExtensions */
static int hf_rrc_cellUpdateConfirm_v7d0ext;      /* CellUpdateConfirm_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_01;   /* T_v7f0NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v7f0ext;      /* CellUpdateConfirm_v7f0ext_IEs */
static int hf_rrc_v890NonCriticalExtensions_01;   /* T_v890NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v890ext;      /* CellUpdateConfirm_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_03;   /* T_v7g0NonCriticalExtensions_03 */
static int hf_rrc_cellUpdateConfirm_v7g0ext;      /* CellUpdateConfirm_v7g0ext_IEs */
static int hf_rrc_v8a0NonCriticalExtensions;      /* T_v8a0NonCriticalExtensions */
static int hf_rrc_cellUpdateConfirm_v8a0ext;      /* CellUpdateConfirm_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_21;       /* T_nonCriticalExtensions_21 */
static int hf_rrc_criticalExtensions_17;          /* T_criticalExtensions_17 */
static int hf_rrc_r9_01;                          /* T_r9_01 */
static int hf_rrc_cellUpdateConfirm_r9;           /* CellUpdateConfirm_r9_IEs */
static int hf_rrc_cellUpdateConfirm_r9_add_ext;   /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_01;   /* T_v950NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_v950ext;      /* CellUpdateConfirm_v950ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions;      /* T_v9c0NonCriticalExtensions */
static int hf_rrc_cellUpdateConfirm_v9c0ext;      /* CellUpdateConfirm_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_22;       /* T_nonCriticalExtensions_22 */
static int hf_rrc_criticalExtensions_18;          /* T_criticalExtensions_18 */
static int hf_rrc_r10_01;                         /* T_r10_01 */
static int hf_rrc_cellUpdateConfirm_r10;          /* CellUpdateConfirm_r10_IEs */
static int hf_rrc_cellUpdateConfirm_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_01;   /* T_v9c0NonCriticalExtensions_01 */
static int hf_rrc_vb50NonCriticalExtensions_02;   /* T_vb50NonCriticalExtensions_02 */
static int hf_rrc_cellUpdateConfirm_vb50ext;      /* CellUpdateConfirm_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_23;       /* T_nonCriticalExtensions_23 */
static int hf_rrc_criticalExtensions_19;          /* T_criticalExtensions_19 */
static int hf_rrc_r11_01;                         /* T_r11_01 */
static int hf_rrc_cellUpdateConfirm_r11;          /* CellUpdateConfirm_r11_IEs */
static int hf_rrc_cellUpdateConfirm_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_24;       /* T_nonCriticalExtensions_24 */
static int hf_rrc_criticalExtensions_20;          /* T_criticalExtensions_20 */
static int hf_rrc_r12_01;                         /* T_r12_01 */
static int hf_rrc_cellUpdateConfirm_r12;          /* CellUpdateConfirm_r12_IEs */
static int hf_rrc_cellUpdateConfirm_r12_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_25;       /* T_nonCriticalExtensions_25 */
static int hf_rrc_criticalExtensions_21;          /* T_criticalExtensions_21 */
static int hf_rrc_r13_01;                         /* T_r13_01 */
static int hf_rrc_cellUpdateConfirm_r13;          /* CellUpdateConfirm_r13_IEs */
static int hf_rrc_cellUpdateConfirm_r13_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_26;       /* T_nonCriticalExtensions_26 */
static int hf_rrc_criticalExtensions_22;          /* CellUpdateConfirm_CriticalExtension_r14_IEs */
static int hf_rrc_r14;                            /* T_r14 */
static int hf_rrc_cellUpdateConfrim_r14;          /* CellUpdateConfirm_r14_IEs */
static int hf_rrc_cellUpdateConfirm_r14_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_27;       /* T_nonCriticalExtensions_27 */
static int hf_rrc_criticalExtensions_23;          /* T_criticalExtensions_22 */
static int hf_rrc_integrityProtectionModeInfo_01;  /* IntegrityProtectionModeInfo_r7 */
static int hf_rrc_cipheringModeInfo_01;           /* CipheringModeInfo_r7 */
static int hf_rrc_new_U_RNTI;                     /* U_RNTI */
static int hf_rrc_new_C_RNTI;                     /* C_RNTI */
static int hf_rrc_new_DSCH_RNTI;                  /* DSCH_RNTI */
static int hf_rrc_new_H_RNTI;                     /* H_RNTI */
static int hf_rrc_rntiHandlingAtCellReselection;  /* T_rntiHandlingAtCellReselection */
static int hf_rrc_rrc_StateIndicator;             /* RRC_StateIndicator */
static int hf_rrc_utran_DRX_CycleLengthCoeff;     /* UTRAN_DRX_CycleLengthCoefficient_r7 */
static int hf_rrc_waitTime;                       /* WaitTime */
static int hf_rrc_rlc_Re_establishIndicatorRb2_3or4;  /* BOOLEAN */
static int hf_rrc_rlc_Re_establishIndicatorRb5orAbove;  /* BOOLEAN */
static int hf_rrc_ura_Identity;                   /* URA_Identity */
static int hf_rrc_supportForChangeOfUE_Capability;  /* BOOLEAN */
static int hf_rrc_rab_InformationSetup;           /* RAB_InformationSetup_r11 */
static int hf_rrc_rb_InformationReleaseList;      /* RB_InformationReleaseList */
static int hf_rrc_rb_InformationReconfigList;     /* RB_InformationReconfigList_r11 */
static int hf_rrc_rb_InformationAffectedList;     /* RB_InformationAffectedList_r8 */
static int hf_rrc_dl_CounterSynchronisationInfo;  /* DL_CounterSynchronisationInfo_r5 */
static int hf_rrc_pdcp_ROHC_TargetMode;           /* PDCP_ROHC_TargetMode */
static int hf_rrc_retrievableConfigInfo;          /* RetrievableConfigInfo */
static int hf_rrc_otherStateConfig;               /* OtherStateConfig */
static int hf_rrc_ul_CommonTransChInfo;           /* UL_CommonTransChInfo_r12 */
static int hf_rrc_ul_deletedTransChInfoList;      /* UL_DeletedTransChInfoList_r6 */
static int hf_rrc_ul_AddReconfTransChInfoList;    /* UL_AddReconfTransChInfoList_r8 */
static int hf_rrc_dl_CommonTransChInfo;           /* DL_CommonTransChInfo_r4 */
static int hf_rrc_dl_DeletedTransChInfoList;      /* DL_DeletedTransChInfoList_r7 */
static int hf_rrc_dl_AddReconfTransChInfoList;    /* DL_AddReconfTransChInfoList_r13 */
static int hf_rrc_frequencyInfo;                  /* FrequencyInfo */
static int hf_rrc_multi_frequencyInfo;            /* Multi_frequencyInfo_LCR_r7 */
static int hf_rrc_ul_DPCH_Info;                   /* UL_DPCH_Info_r11 */
static int hf_rrc_ul_EDCH_Information;            /* UL_EDCH_Information_r11 */
static int hf_rrc_ul_MulticarrierEDCHInfo_TDD128;  /* UL_MulticarrierEDCHInfo_TDD128 */
static int hf_rrc_ul_OtherTTIConfiguration_Info;  /* UL_OtherTTIConfiguration_Information */
static int hf_rrc_filteredUPHReportInfo;          /* FilteredUEPowerHeadroomReportInfo */
static int hf_rrc_dl_HSPDSCH_Information;         /* DL_HSPDSCH_Information_r12 */
static int hf_rrc_dl_CommonInformation;           /* DL_CommonInformation_r12 */
static int hf_rrc_dl_InformationPerRL_List;       /* DL_InformationPerRL_List_r13 */
static int hf_rrc_commonERGCHInfoFDD;             /* CommonERGCHInfoFDD */
static int hf_rrc_controlChannelDRXInfo_TDD128;   /* ControlChannelDRXInfo_TDD128_r8 */
static int hf_rrc_sps_Information_TDD128;         /* SPS_Information_TDD128_r8 */
static int hf_rrc_mu_MIMO_Info_TDD128;            /* MU_MIMO_Info_TDD128 */
static int hf_rrc_nonrectResAllocInd_TDD128;      /* Non_rectResAllocInd_TDD128 */
static int hf_rrc_nonrectResSpecTSset_TDD128;     /* Non_rectResSpecTSset_TDD128 */
static int hf_rrc_hs_scch_DrxCellfach_info;       /* HS_SCCH_DrxCellfach_info */
static int hf_rrc_mbms_PL_ServiceRestrictInfo;    /* MBMS_PL_ServiceRestrictInfo_r6 */
static int hf_rrc_cellDCHMeasOccasionInfo_TDD128;  /* CellDCHMeasOccasionInfo_TDD128_r9 */
static int hf_rrc_dedicatedWLANOffloadInformation;  /* DedicatedWLANOffloadInformation */
static int hf_rrc_utran_DRX_CycleLengthCoeff_01;  /* UTRAN_DRX_CycleLengthCoefficient */
static int hf_rrc_rb_InformationReconfigList_01;  /* RB_InformationReconfigList */
static int hf_rrc_rb_InformationAffectedList_01;  /* RB_InformationAffectedList */
static int hf_rrc_dl_CounterSynchronisationInfo_01;  /* DL_CounterSynchronisationInfo */
static int hf_rrc_ul_CommonTransChInfo_01;        /* UL_CommonTransChInfo */
static int hf_rrc_ul_deletedTransChInfoList_01;   /* UL_DeletedTransChInfoList */
static int hf_rrc_ul_AddReconfTransChInfoList_01;  /* UL_AddReconfTransChInfoList */
static int hf_rrc_modeSpecificTransChInfo;        /* T_modeSpecificTransChInfo */
static int hf_rrc_fdd;                            /* T_fdd */
static int hf_rrc_cPCH_SetID;                     /* CPCH_SetID */
static int hf_rrc_dRAC_StaticInformationList;     /* DRAC_StaticInformationList */
static int hf_rrc_tdd;                            /* NULL */
static int hf_rrc_dl_CommonTransChInfo_01;        /* DL_CommonTransChInfo */
static int hf_rrc_dl_DeletedTransChInfoList_01;   /* DL_DeletedTransChInfoList */
static int hf_rrc_dl_AddReconfTransChInfoList_01;  /* DL_AddReconfTransChInfoList */
static int hf_rrc_ul_ChannelRequirement;          /* UL_ChannelRequirement */
static int hf_rrc_modeSpecificPhysChInfo;         /* T_modeSpecificPhysChInfo */
static int hf_rrc_fdd_01;                         /* T_fdd_01 */
static int hf_rrc_dL_PDSCH_Informatio;            /* DL_PDSCH_Information */
static int hf_rrc_dl_CommonInformation_01;        /* DL_CommonInformation */
static int hf_rrc_dl_InformationPerRL_List_01;    /* DL_InformationPerRL_List */
static int hf_rrc_rb_InformationReconfigList_02;  /* RB_InformationReconfigList_r4 */
static int hf_rrc_ul_CommonTransChInfo_02;        /* UL_CommonTransChInfo_r4 */
static int hf_rrc_modeSpecificTransChInfo_01;     /* T_modeSpecificTransChInfo_01 */
static int hf_rrc_fdd_02;                         /* T_fdd_02 */
static int hf_rrc_dl_AddReconfTransChInfoList_02;  /* DL_AddReconfTransChInfoList_r4 */
static int hf_rrc_ul_ChannelRequirement_01;       /* UL_ChannelRequirement_r4 */
static int hf_rrc_modeSpecificPhysChInfo_01;      /* T_modeSpecificPhysChInfo_01 */
static int hf_rrc_fdd_03;                         /* T_fdd_03 */
static int hf_rrc_dl_CommonInformation_02;        /* DL_CommonInformation_r4 */
static int hf_rrc_dl_InformationPerRL_List_02;    /* DL_InformationPerRL_List_r4 */
static int hf_rrc_rb_InformationReconfigList_03;  /* RB_InformationReconfigList_r5 */
static int hf_rrc_rb_InformationAffectedList_02;  /* RB_InformationAffectedList_r5 */
static int hf_rrc_modeSpecificTransChInfo_02;     /* T_modeSpecificTransChInfo_02 */
static int hf_rrc_fdd_04;                         /* T_fdd_04 */
static int hf_rrc_dl_DeletedTransChInfoList_02;   /* DL_DeletedTransChInfoList_r5 */
static int hf_rrc_dl_AddReconfTransChInfoList_03;  /* DL_AddReconfTransChInfoList_r5 */
static int hf_rrc_ul_ChannelRequirement_02;       /* UL_ChannelRequirement_r5 */
static int hf_rrc_modeSpecificPhysChInfo_02;      /* T_modeSpecificPhysChInfo_02 */
static int hf_rrc_fdd_05;                         /* T_fdd_05 */
static int hf_rrc_dl_HSPDSCH_Information_01;      /* DL_HSPDSCH_Information */
static int hf_rrc_dl_CommonInformation_03;        /* DL_CommonInformation_r5 */
static int hf_rrc_dl_InformationPerRL_List_03;    /* DL_InformationPerRL_List_r5 */
static int hf_rrc_rb_InformationReconfigList_04;  /* RB_InformationReconfigList_r6 */
static int hf_rrc_rb_InformationAffectedList_03;  /* RB_InformationAffectedList_r6 */
static int hf_rrc_ul_AddReconfTransChInfoList_02;  /* UL_AddReconfTransChInfoList_r6 */
static int hf_rrc_ul_DPCH_Info_01;                /* UL_DPCH_Info_r6 */
static int hf_rrc_ul_EDCH_Information_01;         /* UL_EDCH_Information_r6 */
static int hf_rrc_dl_HSPDSCH_Information_02;      /* DL_HSPDSCH_Information_r6 */
static int hf_rrc_dl_CommonInformation_04;        /* DL_CommonInformation_r6 */
static int hf_rrc_dl_InformationPerRL_List_04;    /* DL_InformationPerRL_List_r6 */
static int hf_rrc_harq_Preamble_Mode;             /* HARQ_Preamble_Mode */
static int hf_rrc_beaconPLEst;                    /* BEACON_PL_Est */
static int hf_rrc_postVerificationPeriod;         /* T_postVerificationPeriod */
static int hf_rrc_dhs_sync;                       /* DHS_Sync */
static int hf_rrc_dl_InformationPerRL_List_v6b0ext;  /* DL_InformationPerRL_List_v6b0ext */
static int hf_rrc_rb_InformationReconfigList_05;  /* RB_InformationReconfigList_r7 */
static int hf_rrc_rb_InformationAffectedList_04;  /* RB_InformationAffectedList_r7 */
static int hf_rrc_ul_AddReconfTransChInfoList_03;  /* UL_AddReconfTransChInfoList_r7 */
static int hf_rrc_dl_AddReconfTransChInfoList_04;  /* DL_AddReconfTransChInfoList_r7 */
static int hf_rrc_ul_DPCH_Info_02;                /* UL_DPCH_Info_r7 */
static int hf_rrc_ul_EDCH_Information_02;         /* UL_EDCH_Information_r7 */
static int hf_rrc_dl_HSPDSCH_Information_03;      /* DL_HSPDSCH_Information_r7 */
static int hf_rrc_dl_CommonInformation_05;        /* DL_CommonInformation_r7 */
static int hf_rrc_dl_InformationPerRL_List_05;    /* DL_InformationPerRL_List_r7 */
static int hf_rrc_v7f0NonCriticalExtensions_02;   /* T_v7f0NonCriticalExtensions_02 */
static int hf_rrc_v7g0NonCriticalExtensions_04;   /* T_v7g0NonCriticalExtensions_04 */
static int hf_rrc_nonCriticalExtensions_28;       /* T_nonCriticalExtensions_28 */
static int hf_rrc_ul_EDCH_Information_03;         /* UL_EDCH_Information_ext */
static int hf_rrc_defaultConfigForCellFACH;       /* DefaultConfigForCellFACH */
static int hf_rrc_rab_InformationSetup_01;        /* RAB_InformationSetup_r8 */
static int hf_rrc_rb_InformationReconfigList_06;  /* RB_InformationReconfigList_r8 */
static int hf_rrc_ul_EDCH_Information_04;         /* UL_EDCH_Information_r8 */
static int hf_rrc_dl_HSPDSCH_Information_04;      /* DL_HSPDSCH_Information_r8 */
static int hf_rrc_dl_CommonInformation_06;        /* DL_CommonInformation_r8 */
static int hf_rrc_dl_InformationPerRL_List_06;    /* DL_InformationPerRL_List_r8 */
static int hf_rrc_rab_InformationSetup_02;        /* T_rab_InformationSetup */
static int hf_rrc_rab_InformationSetup_r7;        /* RAB_InformationSetup_r7 */
static int hf_rrc_rab_InformationSetup_v820ext;   /* RAB_InformationSetup_v820ext */
static int hf_rrc_dl_HSPDSCH_Information_05;      /* DL_HSPDSCH_Information_r8_ext */
static int hf_rrc_dl_HSPDSCH_Information_06;      /* DL_HSPDSCH_Information_r8_ext2 */
static int hf_rrc_dl_AddReconfTransChInfoList_05;  /* DL_AddReconfTransChInfoList_r9 */
static int hf_rrc_ul_EDCH_Information_05;         /* UL_EDCH_Information_r9 */
static int hf_rrc_dl_HSPDSCH_Information_07;      /* DL_HSPDSCH_Information_r9 */
static int hf_rrc_dl_AddReconfTransChInfoList_06;  /* DL_AddReconfTransChInfoList_TDD128_v9c0ext */
static int hf_rrc_sR_VCC_Info;                    /* SR_VCC_Info */
static int hf_rrc_dl_CommonInformation_07;        /* DL_CommonInformation_r10 */
static int hf_rrc_dl_AddReconfTransChInfoList_07;  /* DL_AddReconfTransChInfoList_r11 */
static int hf_rrc_dl_HSPDSCH_Information_08;      /* DL_HSPDSCH_Information_r11 */
static int hf_rrc_dl_CommonInformation_08;        /* DL_CommonInformation_r11 */
static int hf_rrc_dl_InformationPerRL_List_07;    /* DL_InformationPerRL_List_r11 */
static int hf_rrc_dl_InformationPerRL_List_08;    /* DL_InformationPerRL_List_r12 */
static int hf_rrc_rntiHandlingAtCellReselection_01;  /* T_rntiHandlingAtCellReselection_01 */
static int hf_rrc_r3_05;                          /* T_r3_05 */
static int hf_rrc_laterNonCriticalExtensions_08;  /* T_laterNonCriticalExtensions_08 */
static int hf_rrc_cellUpdateConfirm_CCCH_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_03;   /* T_v4b0NonCriticalExtensions_03 */
static int hf_rrc_v590NonCriticalExtensions_03;   /* T_v590NonCriticalExtensions_03 */
static int hf_rrc_v5d0NonCriticalExtenstions_03;  /* T_v5d0NonCriticalExtenstions_03 */
static int hf_rrc_v690NonCriticalExtensions_05;   /* T_v690NonCriticalExtensions_05 */
static int hf_rrc_nonCriticalExtensions_29;       /* T_nonCriticalExtensions_29 */
static int hf_rrc_later_than_r3_04;               /* T_later_than_r3_04 */
static int hf_rrc_criticalExtensions_24;          /* T_criticalExtensions_23 */
static int hf_rrc_r4_01;                          /* T_r4_01 */
static int hf_rrc_v4d0NonCriticalExtensions_01;   /* T_v4d0NonCriticalExtensions_01 */
static int hf_rrc_cellUpdateConfirm_CCCH_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_04;   /* T_v590NonCriticalExtensions_04 */
static int hf_rrc_v5d0NonCriticalExtenstions_04;  /* T_v5d0NonCriticalExtenstions_04 */
static int hf_rrc_v690NonCriticalExtensions_06;   /* T_v690NonCriticalExtensions_06 */
static int hf_rrc_nonCriticalExtensions_30;       /* T_nonCriticalExtensions_30 */
static int hf_rrc_criticalExtensions_25;          /* T_criticalExtensions_24 */
static int hf_rrc_r5_01;                          /* T_r5_01 */
static int hf_rrc_cellUpdateConfirm_CCCH_r5_add_ext;  /* BIT_STRING */
static int hf_rrc_v5d0NonCriticalExtenstions_05;  /* T_v5d0NonCriticalExtenstions_05 */
static int hf_rrc_v690NonCriticalExtensions_07;   /* T_v690NonCriticalExtensions_07 */
static int hf_rrc_nonCriticalExtensions_31;       /* T_nonCriticalExtensions_31 */
static int hf_rrc_criticalExtensions_26;          /* T_criticalExtensions_25 */
static int hf_rrc_r6_02;                          /* T_r6_02 */
static int hf_rrc_v6b0NonCriticalExtensions_03;   /* T_v6b0NonCriticalExtensions_03 */
static int hf_rrc_nonCriticalExtensions_32;       /* T_nonCriticalExtensions_32 */
static int hf_rrc_criticalExtensions_27;          /* T_criticalExtensions_26 */
static int hf_rrc_r7_02;                          /* T_r7_02 */
static int hf_rrc_cellUpdateConfirm_r7_add_ext_01;  /* T_cellUpdateConfirm_r7_add_ext_01 */
static int hf_rrc_v780NonCriticalExtensions_02;   /* T_v780NonCriticalExtensions_02 */
static int hf_rrc_v860NonCriticalExtensions_02;   /* T_v860NonCriticalExtensions_02 */
static int hf_rrc_nonCriticalExtensions_33;       /* T_nonCriticalExtensions_33 */
static int hf_rrc_criticalExtensions_28;          /* T_criticalExtensions_27 */
static int hf_rrc_r8_02;                          /* T_r8_02 */
static int hf_rrc_v7d0NonCriticalExtensions_01;   /* T_v7d0NonCriticalExtensions_01 */
static int hf_rrc_v890NonCriticalExtensions_02;   /* T_v890NonCriticalExtensions_02 */
static int hf_rrc_v8a0NonCriticalExtensions_01;   /* T_v8a0NonCriticalExtensions_01 */
static int hf_rrc_v7f0NonCriticalExtensions_03;   /* T_v7f0NonCriticalExtensions_03 */
static int hf_rrc_v7g0NonCriticalExtensions_05;   /* T_v7g0NonCriticalExtensions_05 */
static int hf_rrc_nonCriticalExtensions_34;       /* T_nonCriticalExtensions_34 */
static int hf_rrc_criticalExtensions_29;          /* T_criticalExtensions_28 */
static int hf_rrc_r9_02;                          /* T_r9_02 */
static int hf_rrc_nonCriticalExtensions_35;       /* T_nonCriticalExtensions_35 */
static int hf_rrc_criticalExtensions_30;          /* T_criticalExtensions_29 */
static int hf_rrc_r10_02;                         /* T_r10_02 */
static int hf_rrc_vb50NonCriticalExtensions_03;   /* T_vb50NonCriticalExtensions_03 */
static int hf_rrc_nonCriticalExtensions_36;       /* T_nonCriticalExtensions_36 */
static int hf_rrc_criticalExtensions_31;          /* T_criticalExtensions_30 */
static int hf_rrc_r11_02;                         /* T_r11_02 */
static int hf_rrc_nonCriticalExtensions_37;       /* T_nonCriticalExtensions_37 */
static int hf_rrc_criticalExtensions_32;          /* T_criticalExtensions_31 */
static int hf_rrc_r12_02;                         /* T_r12_02 */
static int hf_rrc_nonCriticalExtensions_38;       /* T_nonCriticalExtensions_38 */
static int hf_rrc_criticalExtensions_33;          /* T_criticalExtensions_32 */
static int hf_rrc_r13_02;                         /* T_r13_02 */
static int hf_rrc_nonCriticalExtensions_39;       /* T_nonCriticalExtensions_39 */
static int hf_rrc_criticalExtensions_34;          /* T_criticalExtensions_33 */
static int hf_rrc_r3_06;                          /* T_r3_06 */
static int hf_rrc_counterCheck_r3;                /* CounterCheck_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_09;  /* T_laterNonCriticalExtensions_09 */
static int hf_rrc_counterCheck_r3_add_ext;        /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_40;       /* T_nonCriticalExtensions_40 */
static int hf_rrc_later_than_r3_05;               /* T_later_than_r3_05 */
static int hf_rrc_criticalExtensions_35;          /* T_criticalExtensions_34 */
static int hf_rrc_rb_COUNT_C_MSB_InformationList;  /* RB_COUNT_C_MSB_InformationList */
static int hf_rrc_rb_COUNT_C_InformationList;     /* RB_COUNT_C_InformationList */
static int hf_rrc_laterNonCriticalExtensions_10;  /* T_laterNonCriticalExtensions_10 */
static int hf_rrc_counterCheckResponse_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_41;       /* T_nonCriticalExtensions_41 */
static int hf_rrc_r3_07;                          /* T_r3_07 */
static int hf_rrc_downlinkDirectTransfer_r3;      /* DownlinkDirectTransfer_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_11;  /* T_laterNonCriticalExtensions_11 */
static int hf_rrc_downlinkDirectTransfer_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_42;       /* T_nonCriticalExtensions_42 */
static int hf_rrc_later_than_r3_06;               /* T_later_than_r3_06 */
static int hf_rrc_criticalExtensions_36;          /* T_criticalExtensions_35 */
static int hf_rrc_cn_DomainIdentity;              /* CN_DomainIdentity */
static int hf_rrc_nas_Message;                    /* NAS_Message */
static int hf_rrc_etws_Information;               /* ETWS_Information */
static int hf_rrc_eTWS_WarningSecurityInfo;       /* ETWS_WarningSecurityInfo */
static int hf_rrc_nonCriticalExtensions_43;       /* T_nonCriticalExtensions_43 */
static int hf_rrc_r3_08;                          /* T_r3_08 */
static int hf_rrc_handoverToUTRANCommand_r3;      /* HandoverToUTRANCommand_r3_IEs */
static int hf_rrc_nonCriticalExtensions_44;       /* T_nonCriticalExtensions_44 */
static int hf_rrc_criticalExtensions_37;          /* T_criticalExtensions_36 */
static int hf_rrc_r4_02;                          /* T_r4_02 */
static int hf_rrc_handoverToUTRANCommand_r4;      /* HandoverToUTRANCommand_r4_IEs */
static int hf_rrc_nonCriticalExtensions_45;       /* T_nonCriticalExtensions_45 */
static int hf_rrc_criticalExtensions_38;          /* T_criticalExtensions_37 */
static int hf_rrc_r5_02;                          /* T_r5_02 */
static int hf_rrc_handoverToUTRANCommand_r5;      /* HandoverToUTRANCommand_r5_IEs */
static int hf_rrc_nonCriticalExtensions_46;       /* T_nonCriticalExtensions_46 */
static int hf_rrc_criticalExtensions_39;          /* T_criticalExtensions_38 */
static int hf_rrc_r6_03;                          /* T_r6_03 */
static int hf_rrc_handoverToUTRANCommand_r6;      /* HandoverToUTRANCommand_r6_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_04;   /* T_v6b0NonCriticalExtensions_04 */
static int hf_rrc_handoverToUTRANCommand_v6b0ext;  /* HandoverToUTRANCommand_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_47;       /* T_nonCriticalExtensions_47 */
static int hf_rrc_criticalExtensions_40;          /* T_criticalExtensions_39 */
static int hf_rrc_r7_03;                          /* T_r7_03 */
static int hf_rrc_handoverToUTRANCommand_r7;      /* HandoverToUTRANCommand_r7_IEs */
static int hf_rrc_v780NonCriticalExtensions_03;   /* T_v780NonCriticalExtensions_03 */
static int hf_rrc_handoverToUTRANCommand_v780ext;  /* HandoverToUTRANCommand_v780ext_IEs */
static int hf_rrc_v820NonCriticalExtensions;      /* T_v820NonCriticalExtensions */
static int hf_rrc_handoverToUTRANCommand_v820ext;  /* HandoverToUTRANCommand_v820ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_02;   /* T_v7d0NonCriticalExtensions_02 */
static int hf_rrc_handoverToUTRANCommand_v7d0ext;  /* HandoverToUTRANCommand_v7d0ext_IEs */
static int hf_rrc_nonCriticalExtensions_48;       /* T_nonCriticalExtensions_48 */
static int hf_rrc_criticalExtensions_41;          /* T_criticalExtensions_40 */
static int hf_rrc_r8_03;                          /* T_r8_03 */
static int hf_rrc_handoverToUTRANCommand_r8;      /* HandoverToUTRANCommand_r8_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_03;   /* T_v7d0NonCriticalExtensions_03 */
static int hf_rrc_v890NonCriticalExtensions_03;   /* T_v890NonCriticalExtensions_03 */
static int hf_rrc_handoverToUTRANCommand_v890ext;  /* HandoverToUTRANCommand_v890ext_IEs */
static int hf_rrc_v8a0NonCriticalExtensions_02;   /* T_v8a0NonCriticalExtensions_02 */
static int hf_rrc_handoverToUTRANCommand_v8a0ext;  /* HandoverToUTRANCommand_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_49;       /* T_nonCriticalExtensions_49 */
static int hf_rrc_criticalExtensions_42;          /* T_criticalExtensions_41 */
static int hf_rrc_r9_03;                          /* T_r9_03 */
static int hf_rrc_handoverToUTRANCommand_r9;      /* HandoverToUTRANCommand_r9_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_02;   /* T_v9c0NonCriticalExtensions_02 */
static int hf_rrc_handoverToUTRANCommand_v9c0ext;  /* HandoverToUTRANCommand_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_50;       /* T_nonCriticalExtensions_50 */
static int hf_rrc_criticalExtensions_43;          /* HandoverToUTRANCommand_LaterCriticalExtensions */
static int hf_rrc_new_U_RNTI_01;                  /* U_RNTI_Short */
static int hf_rrc_cipheringAlgorithm;             /* CipheringAlgorithm */
static int hf_rrc_specificationMode;              /* T_specificationMode */
static int hf_rrc_complete;                       /* T_complete */
static int hf_rrc_srb_InformationSetupList;       /* SRB_InformationSetupList */
static int hf_rrc_rab_InformationSetupList;       /* RAB_InformationSetupList */
static int hf_rrc_ul_DPCH_Info_03;                /* UL_DPCH_Info */
static int hf_rrc_modeSpecificInfo;               /* T_modeSpecificInfo */
static int hf_rrc_fdd_06;                         /* T_fdd_06 */
static int hf_rrc_dL_PDSCH_Information;           /* DL_PDSCH_Information */
static int hf_rrc_cPCH_SetInfo;                   /* CPCH_SetInfo */
static int hf_rrc_preconfiguration;               /* T_preconfiguration */
static int hf_rrc_preConfigMode;                  /* T_preConfigMode */
static int hf_rrc_predefinedConfigIdentity;       /* PredefinedConfigIdentity */
static int hf_rrc_defaultConfig;                  /* T_defaultConfig */
static int hf_rrc_defaultConfigMode;              /* DefaultConfigMode */
static int hf_rrc_defaultConfigIdentity;          /* DefaultConfigIdentity */
static int hf_rrc_rab_Info;                       /* RAB_Info_Post */
static int hf_rrc_modeSpecificInfo_01;            /* T_modeSpecificInfo_01 */
static int hf_rrc_fdd_07;                         /* T_fdd_07 */
static int hf_rrc_ul_DPCH_Info_04;                /* UL_DPCH_InfoPostFDD */
static int hf_rrc_dl_CommonInformationPost;       /* DL_CommonInformationPost */
static int hf_rrc_dl_InformationPerRL_List_09;    /* DL_InformationPerRL_ListPostFDD */
static int hf_rrc_frequencyInfo_01;               /* FrequencyInfoFDD */
static int hf_rrc_tdd_01;                         /* T_tdd */
static int hf_rrc_ul_DPCH_Info_05;                /* UL_DPCH_InfoPostTDD */
static int hf_rrc_dl_InformationPerRL;            /* DL_InformationPerRL_PostTDD */
static int hf_rrc_frequencyInfo_02;               /* FrequencyInfoTDD */
static int hf_rrc_primaryCCPCH_TX_Power;          /* PrimaryCCPCH_TX_Power */
static int hf_rrc_specificationMode_01;           /* T_specificationMode_01 */
static int hf_rrc_complete_01;                    /* T_complete_01 */
static int hf_rrc_rab_InformationSetupList_01;    /* RAB_InformationSetupList_r4 */
static int hf_rrc_ul_DPCH_Info_06;                /* UL_DPCH_Info_r4 */
static int hf_rrc_modeSpecificInfo_02;            /* T_modeSpecificInfo_02 */
static int hf_rrc_fdd_08;                         /* T_fdd_08 */
static int hf_rrc_preconfiguration_01;            /* T_preconfiguration_01 */
static int hf_rrc_preConfigMode_01;               /* T_preConfigMode_01 */
static int hf_rrc_defaultConfig_01;               /* T_defaultConfig_01 */
static int hf_rrc_defaultConfigIdentity_01;       /* DefaultConfigIdentity_r4 */
static int hf_rrc_modeSpecificInfo_03;            /* T_modeSpecificInfo_03 */
static int hf_rrc_fdd_09;                         /* T_fdd_09 */
static int hf_rrc_tdd_02;                         /* T_tdd_01 */
static int hf_rrc_tdd384;                         /* T_tdd384 */
static int hf_rrc_tdd128;                         /* T_tdd128 */
static int hf_rrc_ul_DPCH_Info_07;                /* UL_DPCH_InfoPostTDD_LCR_r4 */
static int hf_rrc_dl_InformationPerRL_01;         /* DL_InformationPerRL_PostTDD_LCR_r4 */
static int hf_rrc_specificationMode_02;           /* T_specificationMode_02 */
static int hf_rrc_complete_02;                    /* T_complete_02 */
static int hf_rrc_srb_InformationSetupList_01;    /* SRB_InformationSetupList_r5 */
static int hf_rrc_rab_InformationSetupList_02;    /* RAB_InformationSetupList_r5 */
static int hf_rrc_ul_DPCH_Info_08;                /* UL_DPCH_Info_r5 */
static int hf_rrc_modeSpecificInfo_04;            /* T_modeSpecificInfo_04 */
static int hf_rrc_fdd_10;                         /* T_fdd_10 */
static int hf_rrc_preconfiguration_02;            /* T_preconfiguration_02 */
static int hf_rrc_preConfigMode_02;               /* T_preConfigMode_02 */
static int hf_rrc_defaultConfig_02;               /* T_defaultConfig_02 */
static int hf_rrc_defaultConfigIdentity_02;       /* DefaultConfigIdentity_r5 */
static int hf_rrc_modeSpecificInfo_05;            /* T_modeSpecificInfo_05 */
static int hf_rrc_fdd_11;                         /* T_fdd_11 */
static int hf_rrc_tdd_03;                         /* T_tdd_02 */
static int hf_rrc_tdd384_01;                      /* T_tdd384_01 */
static int hf_rrc_tdd128_01;                      /* T_tdd128_01 */
static int hf_rrc_specificationMode_03;           /* T_specificationMode_03 */
static int hf_rrc_complete_03;                    /* T_complete_03 */
static int hf_rrc_srb_InformationSetupList_02;    /* SRB_InformationSetupList_r6 */
static int hf_rrc_rab_InformationSetupList_03;    /* RAB_InformationSetupList_r6 */
static int hf_rrc_preconfiguration_03;            /* T_preconfiguration_03 */
static int hf_rrc_preConfigMode_03;               /* T_preConfigMode_03 */
static int hf_rrc_defaultConfig_03;               /* T_defaultConfig_03 */
static int hf_rrc_defaultConfigIdentity_03;       /* DefaultConfigIdentity_r6 */
static int hf_rrc_modeSpecificInfo_06;            /* T_modeSpecificInfo_06 */
static int hf_rrc_fdd_12;                         /* T_fdd_12 */
static int hf_rrc_tdd_04;                         /* T_tdd_03 */
static int hf_rrc_tdd384_02;                      /* T_tdd384_02 */
static int hf_rrc_tdd128_02;                      /* T_tdd128_02 */
static int hf_rrc_ue_hspa_identities;             /* UE_HSPA_Identities_r6 */
static int hf_rrc_cipheringAlgorithm_01;          /* CipheringAlgorithm_r7 */
static int hf_rrc_specificationMode_04;           /* T_specificationMode_04 */
static int hf_rrc_complete_04;                    /* T_complete_04 */
static int hf_rrc_srb_InformationSetupList_03;    /* SRB_InformationSetupList_r7 */
static int hf_rrc_rab_InformationSetupList_04;    /* RAB_InformationSetupList_r7 */
static int hf_rrc_preconfiguration_04;            /* T_preconfiguration_04 */
static int hf_rrc_preConfigMode_04;               /* T_preConfigMode_04 */
static int hf_rrc_defaultConfig_04;               /* T_defaultConfig_04 */
static int hf_rrc_modeSpecificInfo_07;            /* T_modeSpecificInfo_07 */
static int hf_rrc_fdd_13;                         /* T_fdd_13 */
static int hf_rrc_tdd_05;                         /* T_tdd_04 */
static int hf_rrc_tdd384_03;                      /* T_tdd384_03 */
static int hf_rrc_tdd128_03;                      /* T_tdd128_03 */
static int hf_rrc_tdd768;                         /* T_tdd768 */
static int hf_rrc_dl_InformationPerRL_02;         /* DL_InformationPerRL_List_r7 */
static int hf_rrc_specificationMode_05;           /* T_specificationMode_05 */
static int hf_rrc_complete_05;                    /* T_complete_05 */
static int hf_rrc_srb_InformationSetupList_04;    /* SRB_InformationSetupList_r8 */
static int hf_rrc_rab_InformationSetupList_05;    /* RAB_InformationSetupList_r8 */
static int hf_rrc_preconfiguration_05;            /* T_preconfiguration_05 */
static int hf_rrc_preConfigMode_05;               /* T_preConfigMode_05 */
static int hf_rrc_defaultConfig_05;               /* T_defaultConfig_05 */
static int hf_rrc_dLUL_HSPA_Information_r8;       /* DLUL_HSPA_Information_r8 */
static int hf_rrc_modeSpecificInfo_08;            /* T_modeSpecificInfo_08 */
static int hf_rrc_fdd_14;                         /* T_fdd_14 */
static int hf_rrc_tdd_06;                         /* T_tdd_05 */
static int hf_rrc_tdd384_04;                      /* T_tdd384_04 */
static int hf_rrc_tdd128_04;                      /* T_tdd128_04 */
static int hf_rrc_tdd768_01;                      /* T_tdd768_01 */
static int hf_rrc_rab_InformationSetupList_06;    /* RAB_InformationSetupList_v820ext */
static int hf_rrc_specificationMode_06;           /* T_specificationMode_06 */
static int hf_rrc_complete_06;                    /* T_complete_06 */
static int hf_rrc_preconfiguration_06;            /* T_preconfiguration_06 */
static int hf_rrc_preConfigMode_06;               /* T_preConfigMode_06 */
static int hf_rrc_defaultConfig_06;               /* T_defaultConfig_06 */
static int hf_rrc_dLUL_HSPA_Information_r8_01;    /* DLUL_HSPA_Information_r9 */
static int hf_rrc_modeSpecificInfo_09;            /* T_modeSpecificInfo_09 */
static int hf_rrc_fdd_15;                         /* T_fdd_15 */
static int hf_rrc_tdd_07;                         /* T_tdd_06 */
static int hf_rrc_tdd384_05;                      /* T_tdd384_05 */
static int hf_rrc_tdd128_05;                      /* T_tdd128_05 */
static int hf_rrc_tdd768_02;                      /* T_tdd768_02 */
static int hf_rrc_r10_03;                         /* T_r10_03 */
static int hf_rrc_handoverToUTRANCommand_r10;     /* HandoverToUTRANCommand_r10_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_03;   /* T_v9c0NonCriticalExtensions_03 */
static int hf_rrc_nonCriticalExtensions_51;       /* T_nonCriticalExtensions_51 */
static int hf_rrc_criticalExtensions_44;          /* T_criticalExtensions_42 */
static int hf_rrc_r11_03;                         /* T_r11_03 */
static int hf_rrc_handoverToUTRANCommand_r11;     /* HandoverToUTRANCommand_r11_IEs */
static int hf_rrc_handoverToUTRANCommand_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_vbc0NonCriticalExtensions;      /* T_vbc0NonCriticalExtensions */
static int hf_rrc_handoverToUTRANCommand_vbc0ext;  /* HandoverToUTRANCommand_vbc0ext_IEs */
static int hf_rrc_nonCriticalExtensions_52;       /* T_nonCriticalExtensions_52 */
static int hf_rrc_criticalExtensions_45;          /* T_criticalExtensions_43 */
static int hf_rrc_r12_03;                         /* T_r12_03 */
static int hf_rrc_handoverToUTRANCommand_r12;     /* HandoverToUTRANCommand_r12_IEs */
static int hf_rrc_handoverToUTRANCommand_r12_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_53;       /* T_nonCriticalExtensions_53 */
static int hf_rrc_criticalExtensions_46;          /* T_criticalExtensions_44 */
static int hf_rrc_specificationMode_07;           /* T_specificationMode_07 */
static int hf_rrc_complete_07;                    /* T_complete_07 */
static int hf_rrc_preconfiguration_07;            /* T_preconfiguration_07 */
static int hf_rrc_preConfigMode_07;               /* T_preConfigMode_07 */
static int hf_rrc_defaultConfig_07;               /* T_defaultConfig_07 */
static int hf_rrc_dLUL_HSPA_Information_r8_02;    /* DLUL_HSPA_Information_r10 */
static int hf_rrc_modeSpecificInfo_10;            /* T_modeSpecificInfo_10 */
static int hf_rrc_fdd_16;                         /* T_fdd_16 */
static int hf_rrc_tdd_08;                         /* T_tdd_07 */
static int hf_rrc_tdd384_06;                      /* T_tdd384_06 */
static int hf_rrc_tdd128_06;                      /* T_tdd128_06 */
static int hf_rrc_tdd768_03;                      /* T_tdd768_03 */
static int hf_rrc_specificationMode_08;           /* T_specificationMode_08 */
static int hf_rrc_complete_08;                    /* T_complete_08 */
static int hf_rrc_preconfiguration_08;            /* T_preconfiguration_08 */
static int hf_rrc_preConfigMode_08;               /* T_preConfigMode_08 */
static int hf_rrc_defaultConfig_08;               /* T_defaultConfig_08 */
static int hf_rrc_modeSpecificInfo_11;            /* T_modeSpecificInfo_11 */
static int hf_rrc_fdd_17;                         /* T_fdd_17 */
static int hf_rrc_tdd_09;                         /* T_tdd_08 */
static int hf_rrc_tdd384_07;                      /* T_tdd384_07 */
static int hf_rrc_tdd128_07;                      /* T_tdd128_07 */
static int hf_rrc_tdd768_04;                      /* T_tdd768_04 */
static int hf_rrc_specificationMode_09;           /* T_specificationMode_09 */
static int hf_rrc_complete_09;                    /* T_complete_09 */
static int hf_rrc_dl_SecondaryCellInfoFDD_04;     /* DL_SecondaryCellInfoFDD_HandoverToUtran */
static int hf_rrc_ulSecondaryCellInfoFDD;         /* UL_SecondaryCellInfoFDD */
static int hf_rrc_additionalDLSecCellInfoHandoverToUtranListFDD;  /* AdditionalDLSecCellInfoHandoverToUtranListFDD */
static int hf_rrc_specificationMode_10;           /* T_specificationMode_10 */
static int hf_rrc_complete_10;                    /* T_complete_10 */
static int hf_rrc_preconfiguration_09;            /* T_preconfiguration_09 */
static int hf_rrc_preConfigMode_09;               /* T_preConfigMode_09 */
static int hf_rrc_defaultConfig_09;               /* T_defaultConfig_09 */
static int hf_rrc_modeSpecificInfo_12;            /* T_modeSpecificInfo_12 */
static int hf_rrc_fdd_18;                         /* T_fdd_18 */
static int hf_rrc_tdd_10;                         /* T_tdd_09 */
static int hf_rrc_tdd384_08;                      /* T_tdd384_08 */
static int hf_rrc_tdd128_08;                      /* T_tdd128_08 */
static int hf_rrc_tdd768_05;                      /* T_tdd768_05 */
static int hf_rrc_count_C_ActivationTime;         /* ActivationTime */
static int hf_rrc_laterNonCriticalExtensions_12;  /* T_laterNonCriticalExtensions_12 */
static int hf_rrc_handoverToUTRANComplete_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_va40NonCriticalExtensions_01;   /* T_va40NonCriticalExtensions_01 */
static int hf_rrc_handoverToUTRANComplete_va40ext;  /* HandoverToUTRANComplete_va40ext */
static int hf_rrc_vb50NonCriticalExtensions_04;   /* T_vb50NonCriticalExtensions_04 */
static int hf_rrc_handoverToUTRANComplete_vb50ext;  /* HandoverToUTRANComplete_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_54;       /* T_nonCriticalExtensions_54 */
static int hf_rrc_loggedMeasAvailable_02;         /* T_loggedMeasAvailable_02 */
static int hf_rrc_connEstFailInfoAvailable;       /* T_connEstFailInfoAvailable */
static int hf_rrc_intraDomainNasNodeSelector;     /* IntraDomainNasNodeSelector */
static int hf_rrc_v3a0NonCriticalExtensions_02;   /* T_v3a0NonCriticalExtensions_02 */
static int hf_rrc_initialDirectTransfer_v3a0ext;  /* InitialDirectTransfer_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_13;  /* T_laterNonCriticalExtensions_13 */
static int hf_rrc_initialDirectTransfer_r3_add_ext;  /* T_initialDirectTransfer_r3_add_ext */
static int hf_rrc_v590NonCriticalExtensions_05;   /* T_v590NonCriticalExtensions_05 */
static int hf_rrc_initialDirectTransfer_v590ext;  /* InitialDirectTransfer_v590ext */
static int hf_rrc_v690NonCriticalExtensions_08;   /* T_v690NonCriticalExtensions_08 */
static int hf_rrc_initialDirectTransfer_v690ext;  /* InitialDirectTransfer_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_01;   /* T_v770NonCriticalExtensions_01 */
static int hf_rrc_initialDirectTransfer_v770ext;  /* InitialDirectTransfer_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_03;   /* T_v860NonCriticalExtensions_03 */
static int hf_rrc_initialDirectTransfer_v860ext;  /* InitialDirectTransfer_v860ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_05;   /* T_vb50NonCriticalExtensions_05 */
static int hf_rrc_initialDirectTransfer_vb50ext;  /* InitialDirectTransfer_vb50ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_01;   /* T_vc50NonCriticalExtensions_01 */
static int hf_rrc_initialDirectTransfer_vc50ext;  /* InitialDirectTransfer_vc50ext_IEs */
static int hf_rrc_ve30NonCriticalExtensions;      /* InitialDirectTransfer_ve30ext_IEs */
static int hf_rrc_start_Value;                    /* START_Value */
static int hf_rrc_plmn_Identity;                  /* PLMN_Identity */
static int hf_rrc_mbms_JoinedInformation;         /* MBMS_JoinedInformation_r6 */
static int hf_rrc_csCallType_02;                  /* T_csCallType_02 */
static int hf_rrc_supportOfCSG;                   /* T_supportOfCSG */
static int hf_rrc_initialDirectTransfer_v7g0ext;  /* InitialDirectTransfer_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_55;       /* T_nonCriticalExtensions_55 */
static int hf_rrc_dcnIdentity;                    /* INTEGER_0_65535 */
static int hf_rrc_nonCriticalExtensions_56;       /* T_nonCriticalExtensions_56 */
static int hf_rrc_r3_09;                          /* T_r3_09 */
static int hf_rrc_handoverFromUTRANCommand_GSM_r3;  /* HandoverFromUTRANCommand_GSM_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_14;  /* T_laterNonCriticalExtensions_14 */
static int hf_rrc_handoverFromUTRANCommand_GSM_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_09;   /* T_v690NonCriticalExtensions_09 */
static int hf_rrc_handoverFromUTRANCommand_GSM_v690ext;  /* HandoverFromUTRANCommand_GSM_v690ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_04;   /* T_v860NonCriticalExtensions_04 */
static int hf_rrc_handoverFromUTRANCommand_GSM_v860ext;  /* HandoverFromUTRANCommand_GSM_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_57;       /* T_nonCriticalExtensions_57 */
static int hf_rrc_later_than_r3_07;               /* T_later_than_r3_07 */
static int hf_rrc_criticalExtensions_47;          /* T_criticalExtensions_45 */
static int hf_rrc_r6_04;                          /* T_r6_04 */
static int hf_rrc_handoverFromUTRANCommand_GSM_r6;  /* HandoverFromUTRANCommand_GSM_r6_IEs */
static int hf_rrc_handoverFromUTRANCommand_GSM_r6_add_ext;  /* BIT_STRING */
static int hf_rrc_v860NonCriticalExtensions_05;   /* T_v860NonCriticalExtensions_05 */
static int hf_rrc_nonCriticalExtensions_58;       /* T_nonCriticalExtensions_58 */
static int hf_rrc_criticalExtensions_48;          /* T_criticalExtensions_46 */
static int hf_rrc_toHandoverRAB_Info;             /* RAB_Info */
static int hf_rrc_frequency_band;                 /* Frequency_Band */
static int hf_rrc_gsm_message;                    /* T_gsm_message */
static int hf_rrc_single_GSM_Message_r3;          /* T_single_GSM_Message_r3 */
static int hf_rrc_gsm_MessageList_r3;             /* T_gsm_MessageList_r3 */
static int hf_rrc_gsm_Messages;                   /* GSM_MessageList */
static int hf_rrc_toHandoverRAB_Info_01;          /* RAB_InformationList_r6 */
static int hf_rrc_gsm_message_01;                 /* T_gsm_message_01 */
static int hf_rrc_single_GSM_Message_r6;          /* T_single_GSM_Message_r6 */
static int hf_rrc_gsm_MessageList_r6;             /* T_gsm_MessageList_r6 */
static int hf_rrc_geran_SystemInfoType_01;        /* T_geran_SystemInfoType_01 */
static int hf_rrc_geran_SystemInfoType_02;        /* T_geran_SystemInfoType_02 */
static int hf_rrc_sr_vcc_SecurityRABInfo;         /* SR_VCC_SecurityRABInfo_v860ext */
static int hf_rrc_handoverFromUTRANCommand_GERANIu_01;  /* T_handoverFromUTRANCommand_GERANIu */
static int hf_rrc_r5_03;                          /* T_r5_03 */
static int hf_rrc_handoverFromUTRANCommand_GERANIu_r5;  /* HandoverFromUTRANCommand_GERANIu_r5_IEs */
static int hf_rrc_nonCriticalExtensions_59;       /* T_nonCriticalExtensions_59 */
static int hf_rrc_later_than_r5;                  /* T_later_than_r5 */
static int hf_rrc_criticalExtensions_49;          /* T_criticalExtensions_47 */
static int hf_rrc_frequency_Band;                 /* Frequency_Band */
static int hf_rrc_geranIu_Message;                /* T_geranIu_Message */
static int hf_rrc_single_GERANIu_Message;         /* T_single_GERANIu_Message */
static int hf_rrc_geranIu_MessageList;            /* T_geranIu_MessageList */
static int hf_rrc_geranIu_Messages;               /* GERANIu_MessageList */
static int hf_rrc_r3_10;                          /* T_r3_10 */
static int hf_rrc_handoverFromUTRANCommand_CDMA2000_r3;  /* HandoverFromUTRANCommand_CDMA2000_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_15;  /* T_laterNonCriticalExtensions_15 */
static int hf_rrc_handoverFromUTRANCommand_CDMA2000_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_60;       /* T_nonCriticalExtensions_60 */
static int hf_rrc_later_than_r3_08;               /* T_later_than_r3_08 */
static int hf_rrc_criticalExtensions_50;          /* T_criticalExtensions_48 */
static int hf_rrc_cdma2000_MessageList;           /* CDMA2000_MessageList */
static int hf_rrc_criticalExtensions_51;          /* T_criticalExtensions_49 */
static int hf_rrc_r8_04;                          /* T_r8_04 */
static int hf_rrc_handoverFromUTRANCommand_EUTRA_r8;  /* HandoverFromUTRANCommand_EUTRA_r8_IEs */
static int hf_rrc_handoverFromUTRANCommand_EUTRA_r8_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_61;       /* T_nonCriticalExtensions_61 */
static int hf_rrc_criticalExtensions_52;          /* T_criticalExtensions_50 */
static int hf_rrc_r11_04;                         /* T_r11_04 */
static int hf_rrc_handoverFromUTRANCommand_EUTRA_r11;  /* HandoverFromUTRANCommand_EUTRA_r11_IEs */
static int hf_rrc_handoverFromUTRANCommand_EUTRA_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_62;       /* T_nonCriticalExtensions_62 */
static int hf_rrc_criticalExtensions_53;          /* T_criticalExtensions_51 */
static int hf_rrc_toHandoverRAB_Info_02;          /* RAB_InformationList */
static int hf_rrc_eutra_Message;                  /* T_eutra_Message */
static int hf_rrc_rsr_vcc_Info;                   /* RSR_VCC_Info */
static int hf_rrc_eutra_Message_01;               /* T_eutra_Message_01 */
static int hf_rrc_interRAT_HO_FailureCause;       /* InterRAT_HO_FailureCause */
static int hf_rrc_interRATMessage;                /* T_interRATMessage */
static int hf_rrc_gsm;                            /* T_gsm */
static int hf_rrc_gsm_MessageList_gsm;            /* GSM_MessageList */
static int hf_rrc_cdma2000;                       /* T_cdma2000 */
static int hf_rrc_laterNonCriticalExtensions_16;  /* T_laterNonCriticalExtensions_16 */
static int hf_rrc_handoverFromUTRANFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_06;   /* T_v590NonCriticalExtensions_06 */
static int hf_rrc_handoverFromUTRANFailure_v590ext;  /* HandoverFromUtranFailure_v590ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_06;   /* T_v860NonCriticalExtensions_06 */
static int hf_rrc_handoverFromUTRANFailure_v860ext;  /* HandoverFromUtranFailure_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_63;       /* T_nonCriticalExtensions_63 */
static int hf_rrc_geranIu_MessageList_01;         /* GERANIu_MessageList */
static int hf_rrc_eutra_Message_02;               /* T_eutra_Message_02 */
static int hf_rrc_predefinedConfigStatusList;     /* T_predefinedConfigStatusList */
static int hf_rrc_absent;                         /* NULL */
static int hf_rrc_predefinedConfigStatusList_01;  /* PredefinedConfigStatusList */
static int hf_rrc_uE_SecurityInformation;         /* T_uE_SecurityInformation */
static int hf_rrc_uE_SecurityInformation_01;      /* UE_SecurityInformation */
static int hf_rrc_ue_CapabilityContainer;         /* T_ue_CapabilityContainer */
static int hf_rrc_present;                        /* T_present */
static int hf_rrc_v390NonCriticalExtensions;      /* T_v390NonCriticalExtensions */
static int hf_rrc_present_01;                     /* T_present_01 */
static int hf_rrc_interRATHandoverInfo_v390ext;   /* InterRATHandoverInfo_v390ext_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_03;   /* T_v3a0NonCriticalExtensions_03 */
static int hf_rrc_interRATHandoverInfo_v3a0ext;   /* InterRATHandoverInfo_v3a0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_17;  /* T_laterNonCriticalExtensions_17 */
static int hf_rrc_interRATHandoverInfo_v3d0ext;   /* InterRATHandoverInfo_v3d0ext_IEs */
static int hf_rrc_interRATHandoverInfo_r3_add_ext;  /* T_interRATHandoverInfo_r3_add_ext */
static int hf_rrc_v3g0NonCriticalExtensions;      /* T_v3g0NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v3g0ext;   /* InterRATHandoverInfo_v3g0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_04;   /* T_v4b0NonCriticalExtensions_04 */
static int hf_rrc_interRATHandoverInfo_v4b0ext;   /* InterRATHandoverInfo_v4b0ext_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_02;   /* T_v4d0NonCriticalExtensions_02 */
static int hf_rrc_interRATHandoverInfo_v4d0ext;   /* InterRATHandoverInfo_v4d0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_07;   /* T_v590NonCriticalExtensions_07 */
static int hf_rrc_interRATHandoverInfo_v590ext;   /* InterRATHandoverInfo_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_10;   /* T_v690NonCriticalExtensions_10 */
static int hf_rrc_interRATHandoverInfo_v690ext;   /* InterRATHandoverInfo_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_05;   /* InterRATHandoverInfo_NonCriticalExtension_v6b0_IEs */
static int hf_rrc_ue_RadioAccessCapability_v380ext;  /* UE_RadioAccessCapability_v380ext */
static int hf_rrc_dl_PhysChCapabilityFDD_v380ext;  /* DL_PhysChCapabilityFDD_v380ext */
static int hf_rrc_ue_RadioAccessCapability_v3a0ext;  /* UE_RadioAccessCapability_v3a0ext */
static int hf_rrc_uESpecificBehaviourInformation1interRAT;  /* UESpecificBehaviourInformation1interRAT */
static int hf_rrc_ue_RadioAccessCapability_v3g0ext;  /* UE_RadioAccessCapability_v3g0ext */
static int hf_rrc_interRATHandoverInfo_v690ext1;  /* InterRATHandoverInfo_v690ext1_IEs */
static int hf_rrc_v7e0NonCriticalExtensions;      /* T_v7e0NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v7e0ext;   /* InterRATHandoverInfo_v7e0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_04;   /* T_v7f0NonCriticalExtensions_04 */
static int hf_rrc_interRATHandoverInfo_v7f0ext;   /* InterRATHandoverInfo_v7f0ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_02;   /* T_va40NonCriticalExtensions_02 */
static int hf_rrc_interRATHandoverInfo_va40ext;   /* InterRATHandoverInfoBand_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_64;       /* T_nonCriticalExtensions_64 */
static int hf_rrc_accessStratumReleaseIndicator;  /* AccessStratumReleaseIndicator */
static int hf_rrc_tdd128_RF_Capability;           /* RadioFrequencyBandTDDList */
static int hf_rrc_predefinedConfigStatusListComp;  /* PredefinedConfigStatusListComp */
static int hf_rrc_ue_RadioAccessCapabilityComp;   /* UE_RadioAccessCapabilityComp */
static int hf_rrc_ue_RadioAccessCapability_v650ext;  /* UE_RadioAccessCapability_v650ext */
static int hf_rrc_ue_SecurityInformation2;        /* UE_SecurityInformation2 */
static int hf_rrc_ue_RadioAccessCapabilityComp_01;  /* UE_RadioAccessCapabilityComp_ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2;  /* UE_RadioAccessCapabilityComp2 */
static int hf_rrc_interRATHandoverInfo_v6b0ext;   /* InterRATHandoverInfo_v6b0ext_IEs */
static int hf_rrc_v6e0NonCriticalExtensions;      /* T_v6e0NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v6e0ext;   /* InterRATHandoverInfo_v6e0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_02;   /* T_v770NonCriticalExtensions_02 */
static int hf_rrc_interRATHandoverInfo_v770ext;   /* InterRATHandoverInfo_v770ext_IEs */
static int hf_rrc_v790nonCriticalExtensions;      /* T_v790nonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v790ext;   /* InterRATHandoverInfo_v790ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_07;   /* T_v860NonCriticalExtensions_07 */
static int hf_rrc_interRATHandoverInfo_v860ext;   /* InterRATHandoverInfo_v860ext_IEs */
static int hf_rrc_v880NonCriticalExtensions;      /* T_v880NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v880ext;   /* InterRATHandoverInfo_v880ext_IEs */
static int hf_rrc_v920NonCriticalExtensions;      /* T_v920NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v920ext;   /* InterRATHandoverInfo_v920ext_IEs */
static int hf_rrc_v8b0NonCriticalExtensions;      /* T_v8b0NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_v8b0ext;   /* InterRATHandoverInfo_v8b0ext_IEs */
static int hf_rrc_v950NonCriticalExtensions_02;   /* T_v950NonCriticalExtensions_02 */
static int hf_rrc_interRATHandoverInfo_v950ext;   /* InterRATHandoverInfo_v950ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_03;   /* T_va40NonCriticalExtensions_03 */
static int hf_rrc_interRATHandoverInfo_va40ext_01;  /* InterRATHandoverInfo_va40ext_IEs */
static int hf_rrc_va80NonCriticalExtensions;      /* T_va80NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_va80ext;   /* InterRATHandoverInfo_va80ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_06;   /* T_vb50NonCriticalExtensions_06 */
static int hf_rrc_interRATHandoverInfo_vb50ext;   /* InterRATHandoverInfo_vb50ext_IEs */
static int hf_rrc_vb70NonCriticalExtensions;      /* T_vb70NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_vb70ext;   /* InterRATHandoverInfo_vb70ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_18;  /* InterRATHandoverInfo_LaterNonCriticalExtensions */
static int hf_rrc_supportForSIB11bis;             /* T_supportForSIB11bis */
static int hf_rrc_supportForFDPCH;                /* T_supportForFDPCH */
static int hf_rrc_ue_RadioAccessCapabilityInfo;   /* UE_RadioAccessCapabilityInfo_v770ext */
static int hf_rrc_ue_RadioAccessCapabilityComp_02;  /* UE_RadioAccessCapabilityComp_v770ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_01;  /* UE_RadioAccessCapabilityComp2_v770ext */
static int hf_rrc_supportForEDPCCHPowerBoosting;  /* T_supportForEDPCCHPowerBoosting */
static int hf_rrc_ue_RadioAccessCapability;       /* UE_RadioAccessCapability_v7e0ext */
static int hf_rrc_ue_RadioAccessCapability_01;    /* UE_RadioAccessCapability_v7f0ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_02;  /* UE_RadioAccessCapabilityComp2_v7f0ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_01;  /* UE_RadioAccessCapability_v860ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_03;  /* UE_RadioAccessCapabilityComp2_v860ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_02;  /* UE_RadioAccessCapability_v880ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_TDD128;  /* UE_RadioAccessCapabilityComp_TDD128 */
static int hf_rrc_ue_RadioAccessCapabilityInfo_03;  /* UE_RadioAccessCapability_v920ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_04;  /* UE_RadioAccessCapabilityComp2_v920ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_04;  /* UE_RadioAccessCapabilityInfo_TDD128_v8b0ext */
static int hf_rrc_pdcp_Capability;                /* PDCP_Capability_r4_ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_05;  /* UE_RadioAccessCapability_va40ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_05;  /* UE_RadioAccessCapabilityComp2_va40ext */
static int hf_rrc_ue_RadioAccessCapabBand;        /* UE_RadioAccessCapabBand_va40ext */
static int hf_rrc_rf_CapabilityFDDComp;           /* RF_CapabBandListFDDComp_ext2 */
static int hf_rrc_ue_RadioAccessCapabilityInfo_va80ext;  /* UE_RadioAccessCapability_va80ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_vb50ext;  /* UE_RadioAccessCapability_vb50ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_06;  /* UE_RadioAccessCapabilityComp2_vb50ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_TDD128_01;  /* UE_RadioAccessCapabilityInfo_TDD128_vb50ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_vb70ext;  /* UE_RadioAccessCapability_vb70ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_vbc0ext;  /* UE_RadioAccessCapability_vbc0ext */
static int hf_rrc_interRATHandoverInfo_vbc0ext;   /* InterRATHandoverInfo_vbc0ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_02;   /* T_vc50NonCriticalExtensions_02 */
static int hf_rrc_interRATHandoverInfo_vc50ext;   /* InterRATHandoverInfo_vc50ext_IEs */
static int hf_rrc_vd20NonCriticalExtensions;      /* T_vd20NonCriticalExtensions */
static int hf_rrc_interRATHandoverInfo_vd20ext;   /* InterRATHandoverInfo_vd20ext_IEs */
static int hf_rrc_nonCriticalExtensions_65;       /* T_nonCriticalExtensions_65 */
static int hf_rrc_ue_RadioAccessCapabilityComp2_07;  /* UE_RadioAccessCapabilityComp2_vc50ext */
static int hf_rrc_ue_RadioAccessCapabilityInfo_06;  /* UE_RadioAccessCapability_vd20ext */
static int hf_rrc_ue_RadioAccessCapabilityComp2_08;  /* UE_RadioAccessCapabilityComp2_vd20ext */
static int hf_rrc_r3_11;                          /* T_r3_11 */
static int hf_rrc_measurementControl_r3;          /* MeasurementControl_r3_IEs */
static int hf_rrc_v390nonCriticalExtensions;      /* T_v390nonCriticalExtensions */
static int hf_rrc_measurementControl_v390ext;     /* MeasurementControl_v390ext */
static int hf_rrc_v3a0NonCriticalExtensions_04;   /* T_v3a0NonCriticalExtensions_04 */
static int hf_rrc_measurementControl_v3a0ext;     /* MeasurementControl_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_19;  /* T_laterNonCriticalExtensions_18 */
static int hf_rrc_measurementControl_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_05;   /* T_v4b0NonCriticalExtensions_05 */
static int hf_rrc_v590NonCriticalExtensions_08;   /* T_v590NonCriticalExtensions_08 */
static int hf_rrc_measurementControl_v590ext;     /* MeasurementControl_v590ext_IEs */
static int hf_rrc_v5b0NonCriticalExtensions;      /* T_v5b0NonCriticalExtensions */
static int hf_rrc_measurementControl_v5b0ext;     /* MeasurementControl_v5b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_66;       /* T_nonCriticalExtensions_66 */
static int hf_rrc_later_than_r3_09;               /* T_later_than_r3_09 */
static int hf_rrc_criticalExtensions_54;          /* T_criticalExtensions_52 */
static int hf_rrc_r4_03;                          /* T_r4_03 */
static int hf_rrc_measurementControl_r4;          /* MeasurementControl_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_03;   /* T_v4d0NonCriticalExtensions_03 */
static int hf_rrc_measurementControl_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_09;   /* T_v590NonCriticalExtensions_09 */
static int hf_rrc_v5b0NonCriticalExtensions_01;   /* T_v5b0NonCriticalExtensions_01 */
static int hf_rrc_nonCriticalExtensions_67;       /* T_nonCriticalExtensions_67 */
static int hf_rrc_later_than_r4;                  /* T_later_than_r4 */
static int hf_rrc_rrc_TransactionIdentifier_MSP;  /* RRC_TransactionIdentifier */
static int hf_rrc_criticalExtensions_55;          /* T_criticalExtensions_53 */
static int hf_rrc_r6_05;                          /* T_r6_05 */
static int hf_rrc_measurementControl_r6;          /* MeasurementControl_r6_IEs */
static int hf_rrc_v6a0NonCriticalExtensions;      /* T_v6a0NonCriticalExtensions */
static int hf_rrc_measurementControl_v6a0ext;     /* MeasurementControl_v6a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_68;       /* T_nonCriticalExtensions_68 */
static int hf_rrc_criticalExtensions_56;          /* T_criticalExtensions_54 */
static int hf_rrc_r7_04;                          /* T_r7_04 */
static int hf_rrc_measurementControl_r7;          /* MeasurementControl_r7_IEs */
static int hf_rrc_measurementControl_r7_add_ext;  /* BIT_STRING */
static int hf_rrc_v7b0NonCriticalExtensions;      /* T_v7b0NonCriticalExtensions */
static int hf_rrc_measurementControl_v7b0ext;     /* MeasurementControl_v7b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_69;       /* T_nonCriticalExtensions_69 */
static int hf_rrc_criticalExtensions_57;          /* T_criticalExtensions_55 */
static int hf_rrc_r8_05;                          /* T_r8_05 */
static int hf_rrc_measurementControl_r8;          /* MeasurementControl_r8_IEs */
static int hf_rrc_measurementControl_r8_add_ext;  /* BIT_STRING */
static int hf_rrc_v8a0NonCriticalExtensions_03;   /* T_v8a0NonCriticalExtensions_03 */
static int hf_rrc_measurementControl_v8a0ext;     /* MeasurementControl_v8a0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_07;   /* T_vb50NonCriticalExtensions_07 */
static int hf_rrc_measurementControl_vb50ext;     /* MeasurementControl_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_70;       /* T_nonCriticalExtensions_70 */
static int hf_rrc_criticalExtensions_58;          /* T_criticalExtensions_56 */
static int hf_rrc_r9_04;                          /* T_r9_04 */
static int hf_rrc_measurementControl_r9;          /* MeasurementControl_r9_IEs */
static int hf_rrc_measurementControl_r9_add_ext;  /* BIT_STRING */
static int hf_rrc_v970NonCriticalExtensions;      /* T_v970NonCriticalExtensions */
static int hf_rrc_measurementControl_v970ext;     /* MeasurementControl_v970ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_08;   /* T_vb50NonCriticalExtensions_08 */
static int hf_rrc_nonCriticalExtensions_71;       /* T_nonCriticalExtensions_71 */
static int hf_rrc_criticalExtensions_59;          /* T_criticalExtensions_57 */
static int hf_rrc_r10_04;                         /* T_r10_04 */
static int hf_rrc_measurementControl_r10;         /* MeasurementControl_r10_IEs */
static int hf_rrc_measurementControl_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_vaa0NonCriticalExtensions;      /* T_vaa0NonCriticalExtensions */
static int hf_rrc_measurementControl_vaa0ext;     /* MeasurementControl_vaa0ext_IEs */
static int hf_rrc_vab0NonCriticalExtensions;      /* T_vab0NonCriticalExtensions */
static int hf_rrc_measurementControl_vab0ext;     /* MeasurementControl_vab0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_09;   /* T_vb50NonCriticalExtensions_09 */
static int hf_rrc_nonCriticalExtensions_72;       /* T_nonCriticalExtensions_72 */
static int hf_rrc_criticalExtensions_60;          /* T_criticalExtensions_58 */
static int hf_rrc_r11_05;                         /* T_r11_05 */
static int hf_rrc_measurementControl_r11;         /* MeasurementControl_r11_IEs */
static int hf_rrc_measurementControl_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_73;       /* T_nonCriticalExtensions_73 */
static int hf_rrc_criticalExtensions_61;          /* T_criticalExtensions_59 */
static int hf_rrc_r12_04;                         /* T_r12_04 */
static int hf_rrc_measurementControl_r12;         /* MeasurementControl_r12_IEs */
static int hf_rrc_measurementControl_r12_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_74;       /* T_nonCriticalExtensions_74 */
static int hf_rrc_criticalExtensions_62;          /* T_criticalExtensions_60 */
static int hf_rrc_r13_03;                         /* T_r13_03 */
static int hf_rrc_measurementControl_r13;         /* MeasurementControl_r13_IEs */
static int hf_rrc_measurementControl_r13_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_75;       /* T_nonCriticalExtensions_75 */
static int hf_rrc_criticalExtensions_63;          /* T_criticalExtensions_61 */
static int hf_rrc_r14_01;                         /* T_r14_01 */
static int hf_rrc_measurementControl_r14;         /* MeasurementControl_r14_IEs */
static int hf_rrc_measurementControl_r14_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_76;       /* T_nonCriticalExtensions_76 */
static int hf_rrc_laterCriticalExtensions;        /* MeasurementControl_LaterCriticalExtensions_r14_IEs */
static int hf_rrc_measurementIdentity;            /* MeasurementIdentity */
static int hf_rrc_measurementCommand;             /* MeasurementCommand */
static int hf_rrc_measurementReportingMode;       /* MeasurementReportingMode */
static int hf_rrc_additionalMeasurementList;      /* AdditionalMeasurementID_List */
static int hf_rrc_dpch_CompressedModeStatusInfo;  /* DPCH_CompressedModeStatusInfo */
static int hf_rrc_ue_Positioning_Measurement_v390ext;  /* UE_Positioning_Measurement_v390ext */
static int hf_rrc_measurementCommand_01;          /* MeasurementCommand_r4 */
static int hf_rrc_measurementCommand_v590ext;     /* T_measurementCommand_v590ext */
static int hf_rrc_intra_frequency;                /* Intra_FreqEventCriteriaList_v590ext */
static int hf_rrc_inter_frequency;                /* Inter_FreqEventCriteriaList_v590ext */
static int hf_rrc_intraFreqReportingCriteria_1b_r5;  /* IntraFreqReportingCriteria_1b_r5 */
static int hf_rrc_intraFreqEvent_1d_r5;           /* IntraFreqEvent_1d_r5 */
static int hf_rrc_rrc_TransactionIdentifier_MSP_v590ext;  /* RRC_TransactionIdentifier */
static int hf_rrc_interRATCellInfoIndication;     /* InterRATCellInfoIndication */
static int hf_rrc_measurementCommand_02;          /* MeasurementCommand_r6 */
static int hf_rrc_measurementCommand_03;          /* MeasurementCommand_r7 */
static int hf_rrc_newInterFreqCellList;           /* NewInterFreqCellList_v7b0ext */
static int hf_rrc_measurementCommand_04;          /* MeasurementCommand_r8 */
static int hf_rrc_newIntraFreqCellList;           /* NewIntraFreqCellList_LCR_v8a0ext */
static int hf_rrc_newInterFreqCellList_01;        /* NewInterFreqCellList_LCR_v8a0ext */
static int hf_rrc_measurementCommand_05;          /* MeasurementCommand_r9 */
static int hf_rrc_measurementIdentity_01;         /* MeasurementIdentity_r9 */
static int hf_rrc_additionalMeasurementList_01;   /* AdditionalMeasurementID_List_r9 */
static int hf_rrc_measurementCommand_06;          /* MeasurementCommand_r10 */
static int hf_rrc_dpch_CompressedModeStatusInfo_01;  /* DPCH_CompressedModeStatusInfo_r10 */
static int hf_rrc_periodicalReportingCriteriaOnSecULFreq;  /* PeriodicalWithReportingCellStatusOnSecULFreq */
static int hf_rrc_measurementCommand_07;          /* MeasurementCommand_r11 */
static int hf_rrc_interRATMeasurement;            /* InterRATMeasurement_r11 */
static int hf_rrc_measurementCommand_08;          /* MeasurementCommand_r12 */
static int hf_rrc_measurementScalingFactor;       /* MeasurementScalingFactor */
static int hf_rrc_measurementCommand_09;          /* MeasurementCommand_r13 */
static int hf_rrc_measurementCommand_10;          /* MeasurementCommand_r14 */
static int hf_rrc_criticalExtensions_64;          /* T_criticalExtensions_62 */
static int hf_rrc_r14_02;                         /* T_r14_02 */
static int hf_rrc_nonCriticalExtensions_77;       /* T_nonCriticalExtensions_77 */
static int hf_rrc_measurementControl_LaterCriticalExtensions_r15_IEs;  /* MeasurementControl_LaterCriticalExtensions_r15_IEs */
static int hf_rrc_criticalExtensions_65;          /* T_criticalExtensions_63 */
static int hf_rrc_r15;                            /* T_r15 */
static int hf_rrc_measurementControl_r15;         /* MeasurementControl_r15_IEs */
static int hf_rrc_measurementControl_r15_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_78;       /* T_nonCriticalExtensions_78 */
static int hf_rrc_criticalExtensions_66;          /* T_criticalExtensions_64 */
static int hf_rrc_measurementCommand_11;          /* MeasurementCommand_r15 */
static int hf_rrc_laterNonCriticalExtensions_20;  /* T_laterNonCriticalExtensions_19 */
static int hf_rrc_measurementControlFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_10;   /* T_v590NonCriticalExtensions_10 */
static int hf_rrc_measurementControlFailure_v590ext;  /* MeasurementControlFailure_v590ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_03;   /* T_vc50NonCriticalExtensions_03 */
static int hf_rrc_measurementControlFailure_vc50ext;  /* MeasurementControlFailure_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_79;       /* T_nonCriticalExtensions_79 */
static int hf_rrc_measuredResults;                /* MeasuredResults */
static int hf_rrc_additionalMeasuredResults;      /* MeasuredResultsList */
static int hf_rrc_eventResults;                   /* EventResults */
static int hf_rrc_v390nonCriticalExtensions_01;   /* T_v390nonCriticalExtensions_01 */
static int hf_rrc_measurementReport_v390ext;      /* MeasurementReport_v390ext */
static int hf_rrc_laterNonCriticalExtensions_21;  /* T_laterNonCriticalExtensions_20 */
static int hf_rrc_measurementReport_r3_add_ext;   /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_06;   /* T_v4b0NonCriticalExtensions_06 */
static int hf_rrc_measurementReport_v4b0ext;      /* MeasurementReport_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_11;   /* T_v590NonCriticalExtensions_11 */
static int hf_rrc_measurementReport_v590ext;      /* MeasurementReport_v590ext_IEs */
static int hf_rrc_v5b0NonCriticalExtensions_02;   /* T_v5b0NonCriticalExtensions_02 */
static int hf_rrc_measurementReport_v5b0ext;      /* MeasurementReport_v5b0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_11;   /* T_v690NonCriticalExtensions_11 */
static int hf_rrc_measurementReport_v690ext;      /* MeasurementReport_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_03;   /* T_v770NonCriticalExtensions_03 */
static int hf_rrc_measurementReport_v770ext;      /* MeasurementReport_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_08;   /* T_v860NonCriticalExtensions_08 */
static int hf_rrc_measurementReport_v860ext;      /* MeasurementReport_v860ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_01;   /* T_v920NonCriticalExtensions_01 */
static int hf_rrc_measurementReport_v920ext;      /* MeasurementReport_v920ext_IEs */
static int hf_rrc_v970NonCriticalExtensions_01;   /* T_v970NonCriticalExtensions_01 */
static int hf_rrc_measurementReport_v970ext_IE;   /* MeasurementReport_v970ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_04;   /* T_va40NonCriticalExtensions_04 */
static int hf_rrc_measurementReport_va40ext;      /* MeasurementReport_va40ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_10;   /* T_vb50NonCriticalExtensions_10 */
static int hf_rrc_measurementReport_vb50ext;      /* MeasurementReport_vb50ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_22;  /* MeasurementReport_LaterNonCriticalExtensions */
static int hf_rrc_measuredResults_v390ext;        /* MeasuredResults_v390ext */
static int hf_rrc_interFreqEventResults_LCR;      /* InterFreqEventResults_LCR_r4_ext */
static int hf_rrc_additionalMeasuredResults_LCR;  /* MeasuredResultsList_LCR_r4_ext */
static int hf_rrc_primaryCPICH_Info;              /* PrimaryCPICH_Info */
static int hf_rrc_measuredResults_v590ext;        /* MeasuredResults_v590ext */
static int hf_rrc_measuredResults_01;             /* MeasuredResults_v770ext */
static int hf_rrc_additionalMeasuredResults_01;   /* MeasuredResultsList_v770xet */
static int hf_rrc_eventResults_01;                /* EventResults_v770ext */
static int hf_rrc_ue_Positioning_OTDOA_MeasuredResults;  /* UE_Positioning_OTDOA_MeasuredResultsTDD_ext */
static int hf_rrc_measuredResults_02;             /* MeasuredResults_v860ext */
static int hf_rrc_additionalMeasuredResults_02;   /* MeasuredResultsList_v860ext */
static int hf_rrc_eventResults_02;                /* EventResults_v860ext */
static int hf_rrc_eutra_MeasuredResults;          /* EUTRA_MeasuredResults */
static int hf_rrc_eutra_EventResults;             /* EUTRA_EventResults */
static int hf_rrc_cSGProximityIndication;         /* CSGProximityIndication */
static int hf_rrc_measuredResults_03;             /* MeasuredResults_v920ext */
static int hf_rrc_measuredResultsOnSecUlFreq;     /* MeasuredResultsOnSecUlFreq */
static int hf_rrc_additionalMeasuredResults_03;   /* MeasuredResultsList_v920ext */
static int hf_rrc_additionalMeasuredResultsOnSecUlFreq;  /* MeasuredResultsListOnSecUlFreq */
static int hf_rrc_eventResultsOnSecUlFreq;        /* EventResultsOnSecUlFreq */
static int hf_rrc_eutra_MeasuredResults_01;       /* EUTRA_MeasuredResults_v920ext */
static int hf_rrc_measurementIdentity_02;         /* MeasurementIdentityExt */
static int hf_rrc_eventResults_03;                /* EventResults_va40ext */
static int hf_rrc_loggedMeasAvailable_03;         /* T_loggedMeasAvailable_03 */
static int hf_rrc_loggedANRResultsAvailable_02;   /* T_loggedANRResultsAvailable_02 */
static int hf_rrc_eutra_EventResultsForCELLFACH;  /* EUTRA_EventResultsForCELLFACH */
static int hf_rrc_cSGProximityIndication_01;      /* CSGProximityIndication_vb50ext */
static int hf_rrc_eutra_MeasuredResults_02;       /* EUTRA_MeasuredResults_vb50ext */
static int hf_rrc_eutra_EventResults_01;          /* EUTRA_EventResults_vb50ext */
static int hf_rrc_measurementReport_vc50ext;      /* MeasurementReport_vc50ext_IEs */
static int hf_rrc_vd20NonCriticalExtensions_01;   /* T_vd20NonCriticalExtensions_01 */
static int hf_rrc_measurementReport_vd20ext;      /* MeasurementReport_vd20ext_IEs */
static int hf_rrc_ve30NonCriticalExtensions_01;   /* MeasurementReport_ve30ext_IEs */
static int hf_rrc_measuredResults_04;             /* MeasuredResults_vc50ext */
static int hf_rrc_measuredResultsOnSecUlFreq_01;  /* MeasuredResultsOnSecUlFreq_vc50ext */
static int hf_rrc_additionalMeasuredResults_04;   /* MeasuredResultsList_vc50ext */
static int hf_rrc_additionalMeasuredResultsOnSecUlFreq_01;  /* MeasuredResultsListOnSecUlFreq_vc50ext */
static int hf_rrc_eutra_MeasuredResults_03;       /* EUTRA_MeasuredResults_vc50ext */
static int hf_rrc_eutra_EventResults_02;          /* EUTRA_EventResults_vc50ext */
static int hf_rrc_eutra_EventResultsForCELLFACH_01;  /* EUTRA_EventResultsForCELLFACH_vc50ext */
static int hf_rrc_measuredResults_05;             /* MeasuredResults_vd20ext */
static int hf_rrc_measuredResults_06;             /* MeasuredResults_ve30ext */
static int hf_rrc_applicationLayerMeasurementReporting;  /* ApplicationLayerMeasurementReporting */
static int hf_rrc_measurementReport_vf20ext;      /* MeasurementReport_vf20ext_IEs */
static int hf_rrc_applicationLayerMeasurementReporting_r15;  /* ApplicationLayerMeasurementReporting_r15 */
static int hf_rrc_nonCriticalExtensions_80;       /* T_nonCriticalExtensions_80 */
static int hf_rrc_pagingRecordList;               /* PagingRecordList */
static int hf_rrc_bcch_ModificationInfo;          /* BCCH_ModificationInfo */
static int hf_rrc_laterNonCriticalExtensions_23;  /* T_laterNonCriticalExtensions_21 */
static int hf_rrc_pagingType1_r3_add_ext;         /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_12;   /* T_v590NonCriticalExtensions_12 */
static int hf_rrc_pagingType1_v590ext;            /* PagingType1_v590ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_09;   /* T_v860NonCriticalExtensions_09 */
static int hf_rrc_pagingType1_v860ext;            /* PagingType1_v860ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_04;   /* T_vc50NonCriticalExtensions_04 */
static int hf_rrc_pagingType1_vc50ext;            /* PagingType1_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_81;       /* T_nonCriticalExtensions_81 */
static int hf_rrc_pagingRecord2List;              /* PagingRecord2List_r5 */
static int hf_rrc_bcch_ModificationInfo_vc50ext;  /* BCCH_ModificationInfo_vc50ext */
static int hf_rrc_pagingCause;                    /* PagingCause */
static int hf_rrc_pagingRecordTypeID;             /* PagingRecordTypeID */
static int hf_rrc_laterNonCriticalExtensions_24;  /* T_laterNonCriticalExtensions_22 */
static int hf_rrc_pagingType2_r3_add_ext;         /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_82;       /* T_nonCriticalExtensions_82 */
static int hf_rrc_r3_12;                          /* T_r3_12 */
static int hf_rrc_physicalChannelReconfiguration_r3;  /* PhysicalChannelReconfiguration_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_05;   /* T_v3a0NonCriticalExtensions_05 */
static int hf_rrc_physicalChannelReconfiguration_v3a0ext;  /* PhysicalChannelReconfiguration_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_25;  /* T_laterNonCriticalExtensions_23 */
static int hf_rrc_physicalChannelReconfiguration_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtenstions;     /* T_v4b0NonCriticalExtenstions */
static int hf_rrc_physicalChannelReconfiguration_v4b0ext;  /* PhysicalChannelReconfiguration_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtenstions_02;  /* T_v590NonCriticalExtenstions_02 */
static int hf_rrc_physicalChannelReconfiguration_v590ext;  /* PhysicalChannelReconfiguration_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_12;   /* T_v690NonCriticalExtensions_12 */
static int hf_rrc_physicalChannelReconfiguration_v690ext;  /* PhysicalChannelReconfiguration_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_04;   /* T_v770NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v770ext;  /* PhysicalChannelReconfiguration_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_83;       /* T_nonCriticalExtensions_83 */
static int hf_rrc_later_than_r3_10;               /* T_later_than_r3_10 */
static int hf_rrc_criticalExtensions_67;          /* T_criticalExtensions_65 */
static int hf_rrc_r4_04;                          /* T_r4_04 */
static int hf_rrc_physicalChannelReconfiguration_r4;  /* PhysicalChannelReconfiguration_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_04;   /* T_v4d0NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtenstions_03;  /* T_v590NonCriticalExtenstions_03 */
static int hf_rrc_v690NonCriticalExtensions_13;   /* T_v690NonCriticalExtensions_13 */
static int hf_rrc_v770NonCriticalExtensions_05;   /* T_v770NonCriticalExtensions_05 */
static int hf_rrc_nonCriticalExtensions_84;       /* T_nonCriticalExtensions_84 */
static int hf_rrc_criticalExtensions_68;          /* T_criticalExtensions_66 */
static int hf_rrc_r5_04;                          /* T_r5_04 */
static int hf_rrc_physicalChannelReconfiguration_r5;  /* PhysicalChannelReconfiguration_r5_IEs */
static int hf_rrc_physicalChannelReconfiguration_r5_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_14;   /* T_v690NonCriticalExtensions_14 */
static int hf_rrc_v770NonCriticalExtensions_06;   /* T_v770NonCriticalExtensions_06 */
static int hf_rrc_nonCriticalExtensions_85;       /* T_nonCriticalExtensions_85 */
static int hf_rrc_criticalExtensions_69;          /* T_criticalExtensions_67 */
static int hf_rrc_r6_06;                          /* T_r6_06 */
static int hf_rrc_physicalChannelReconfiguration_r6;  /* PhysicalChannelReconfiguration_r6_IEs */
static int hf_rrc_physicalChannelReconfiguration_r6_add_ext;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_06;   /* T_v6b0NonCriticalExtensions_05 */
static int hf_rrc_physicalChannelReconfiguration_v6b0ext;  /* PhysicalChannelReconfiguration_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_07;   /* T_v770NonCriticalExtensions_07 */
static int hf_rrc_nonCriticalExtensions_86;       /* T_nonCriticalExtensions_86 */
static int hf_rrc_criticalExtensions_70;          /* T_criticalExtensions_68 */
static int hf_rrc_r7_05;                          /* T_r7_05 */
static int hf_rrc_physicalChannelReconfiguration_r7;  /* PhysicalChannelReconfiguration_r7_IEs */
static int hf_rrc_physicalChannelReconfiguration_r7_add_ext;  /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions_04;   /* T_v780NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v780ext;  /* PhysicalChannelReconfiguration_v780ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_04;   /* T_v7d0NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v7d0ext;  /* PhysicalChannelReconfiguration_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_05;   /* T_v7f0NonCriticalExtensions_05 */
static int hf_rrc_physicalChannelReconfiguration_v7f0ext;  /* PhysicalChannelReconfiguration_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_06;   /* T_v7g0NonCriticalExtensions_06 */
static int hf_rrc_physicalChannelReconfiguration_v7g0ext;  /* PhysicalChannelReconfiguration_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_87;       /* T_nonCriticalExtensions_87 */
static int hf_rrc_criticalExtensions_71;          /* T_criticalExtensions_69 */
static int hf_rrc_r8_06;                          /* T_r8_06 */
static int hf_rrc_physicalChannelReconfiguration_r8;  /* PhysicalChannelReconfiguration_r8_IEs */
static int hf_rrc_physicalChannelReconfiguration_r8_add_ext;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_05;   /* T_v7d0NonCriticalExtensions_05 */
static int hf_rrc_v7f0NonCriticalExtensions_06;   /* T_v7f0NonCriticalExtensions_06 */
static int hf_rrc_v890NonCriticalExtensions_04;   /* T_v890NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v890ext;  /* PhysicalChannelReconfiguration_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_07;   /* T_v7g0NonCriticalExtensions_07 */
static int hf_rrc_v8a0NonCriticalExtensions_04;   /* T_v8a0NonCriticalExtensions_04 */
static int hf_rrc_physicalChannelReconfiguration_v8a0ext;  /* PhysicalChannelReconfiguration_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_88;       /* T_nonCriticalExtensions_88 */
static int hf_rrc_criticalExtensions_72;          /* T_criticalExtensions_70 */
static int hf_rrc_r9_05;                          /* T_r9_05 */
static int hf_rrc_physicalChannelReconfiguration_r9;  /* PhysicalChannelReconfiguration_r9_IEs */
static int hf_rrc_physicalChannelReconfiguration_r9_add_ext;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_03;   /* T_v950NonCriticalExtensions_03 */
static int hf_rrc_physicalChannelReconfiguration_v950ext;  /* PhysicalChannelReconfiguration_v950ext_IEs */
static int hf_rrc_nonCriticalExtensions_89;       /* T_nonCriticalExtensions_89 */
static int hf_rrc_criticalExtensions_73;          /* T_criticalExtensions_71 */
static int hf_rrc_r10_05;                         /* T_r10_05 */
static int hf_rrc_physicalChannelReconfiguration_r10;  /* PhysicalChannelReconfiguration_r10_IEs */
static int hf_rrc_physicalChannelReconfiguration_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_vb50NonCriticalExtensions_11;   /* T_vb50NonCriticalExtensions_11 */
static int hf_rrc_physicalChannelReconfiguration_vb50ext;  /* PhysicalChannelReconfiguration_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_90;       /* T_nonCriticalExtensions_90 */
static int hf_rrc_criticalExtensions_74;          /* T_criticalExtensions_72 */
static int hf_rrc_r11_06;                         /* T_r11_06 */
static int hf_rrc_physicalChannelReconfiguration_r11;  /* PhysicalChannelReconfiguration_r11_IEs */
static int hf_rrc_physicalChannelReconfiguration_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_91;       /* T_nonCriticalExtensions_91 */
static int hf_rrc_criticalExtensions_75;          /* T_criticalExtensions_73 */
static int hf_rrc_r12_05;                         /* T_r12_05 */
static int hf_rrc_physicalChannelReconfiguration_r12;  /* PhysicalChannelReconfiguration_r12_IEs */
static int hf_rrc_physicalChannelReconfiguration_r12_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_92;       /* T_nonCriticalExtensions_92 */
static int hf_rrc_criticalExtensions_76;          /* T_criticalExtensions_74 */
static int hf_rrc_r13_04;                         /* T_r13_04 */
static int hf_rrc_physicalChannelReconfiguration_r13;  /* PhysicalChannelReconfiguration_r13_IEs */
static int hf_rrc_physicalChannelReconfiguration_r13_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_93;       /* T_nonCriticalExtensions_93 */
static int hf_rrc_criticalExtensions_77;          /* T_criticalExtensions_75 */
static int hf_rrc_ul_ChannelRequirement_03;       /* UL_ChannelRequirementWithCPCH_SetID */
static int hf_rrc_modeSpecificInfo_13;            /* T_modeSpecificInfo_13 */
static int hf_rrc_fdd_19;                         /* T_fdd_19 */
static int hf_rrc_ul_ChannelRequirement_04;       /* UL_ChannelRequirementWithCPCH_SetID_r4 */
static int hf_rrc_modeSpecificInfo_14;            /* T_modeSpecificInfo_14 */
static int hf_rrc_fdd_20;                         /* T_fdd_20 */
static int hf_rrc_ul_ChannelRequirement_05;       /* UL_ChannelRequirementWithCPCH_SetID_r5 */
static int hf_rrc_modeSpecificInfo_15;            /* T_modeSpecificInfo_15 */
static int hf_rrc_fdd_21;                         /* T_fdd_21 */
static int hf_rrc_delayRestrictionFlag;           /* DelayRestrictionFlag */
static int hf_rrc_postVerificationPeriod_01;      /* T_postVerificationPeriod_01 */
static int hf_rrc_timingMaintainedSynchInd;       /* TimingMaintainedSynchInd */
static int hf_rrc_responseToChangeOfUE_Capability;  /* T_responseToChangeOfUE_Capability */
static int hf_rrc_harqInfo;                       /* HARQ_Info_r7 */
static int hf_rrc_responseToChangeOfUE_Capability_01;  /* T_responseToChangeOfUE_Capability_01 */
static int hf_rrc_responseToChangeOfUE_Capability_02;  /* T_responseToChangeOfUE_Capability_02 */
static int hf_rrc_responseToChangeOfUE_Capability_03;  /* T_responseToChangeOfUE_Capability_03 */
static int hf_rrc_responseToChangeOfUE_Capability_04;  /* T_responseToChangeOfUE_Capability_04 */
static int hf_rrc_harqInfo_01;                    /* HARQ_Info_r11 */
static int hf_rrc_responseToChangeOfUE_Capability_05;  /* T_responseToChangeOfUE_Capability_05 */
static int hf_rrc_responseToChangeOfUE_Capability_06;  /* T_responseToChangeOfUE_Capability_06 */
static int hf_rrc_harqInfo_02;                    /* HARQ_Info_r13 */
static int hf_rrc_ul_IntegProtActivationInfo;     /* IntegrityProtActivationInfo */
static int hf_rrc_ul_TimingAdvance;               /* UL_TimingAdvance */
static int hf_rrc_ul_CounterSynchronisationInfo;  /* UL_CounterSynchronisationInfo */
static int hf_rrc_laterNonCriticalExtensions_26;  /* T_laterNonCriticalExtensions_24 */
static int hf_rrc_physicalChannelReconfigurationComplete_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_08;   /* T_v770NonCriticalExtensions_08 */
static int hf_rrc_physicalChannelReconfigurationComplete_v770ext;  /* PhysicalChannelReconfigurationComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_94;       /* T_nonCriticalExtensions_94 */
static int hf_rrc_ext_UL_TimingAdvance;           /* EXT_UL_TimingAdvance */
static int hf_rrc_deferredMeasurementControlReading;  /* T_deferredMeasurementControlReading */
static int hf_rrc_laterNonCriticalExtensions_27;  /* T_laterNonCriticalExtensions_25 */
static int hf_rrc_physicalChannelReconfigurationFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_95;       /* T_nonCriticalExtensions_95 */
static int hf_rrc_r3_13;                          /* T_r3_13 */
static int hf_rrc_physicalSharedChannelAllocation_r3;  /* PhysicalSharedChannelAllocation_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_28;  /* T_laterNonCriticalExtensions_26 */
static int hf_rrc_physicalSharedChannelAllocation_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_96;       /* T_nonCriticalExtensions_96 */
static int hf_rrc_later_than_r3_11;               /* T_later_than_r3_11 */
static int hf_rrc_dsch_RNTI;                      /* DSCH_RNTI */
static int hf_rrc_criticalExtensions_78;          /* T_criticalExtensions_76 */
static int hf_rrc_r4_05;                          /* T_r4_05 */
static int hf_rrc_physicalSharedChannelAllocation_r4;  /* PhysicalSharedChannelAllocation_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_05;   /* T_v4d0NonCriticalExtensions_05 */
static int hf_rrc_physicalSharedChannelAllocation_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_15;   /* T_v690NonCriticalExtensions_15 */
static int hf_rrc_physicalSharedChannelAllocation_v690ext;  /* PhysicalSharedChannelAllocation_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_09;   /* T_v770NonCriticalExtensions_09 */
static int hf_rrc_physicalSharedChannelAllocation_v770ext;  /* PhysicalSharedChannelAllocation_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_97;       /* T_nonCriticalExtensions_97 */
static int hf_rrc_criticalExtensions_79;          /* T_criticalExtensions_77 */
static int hf_rrc_ul_TimingAdvance_01;            /* UL_TimingAdvanceControl */
static int hf_rrc_pusch_CapacityAllocationInfo;   /* PUSCH_CapacityAllocationInfo */
static int hf_rrc_pdsch_CapacityAllocationInfo;   /* PDSCH_CapacityAllocationInfo */
static int hf_rrc_confirmRequest;                 /* T_confirmRequest */
static int hf_rrc_trafficVolumeReportRequest;     /* INTEGER_0_255 */
static int hf_rrc_iscpTimeslotList;               /* TimeslotList */
static int hf_rrc_requestPCCPCHRSCP;              /* BOOLEAN */
static int hf_rrc_ul_TimingAdvance_02;            /* UL_TimingAdvanceControl_r4 */
static int hf_rrc_pusch_CapacityAllocationInfo_01;  /* PUSCH_CapacityAllocationInfo_r4 */
static int hf_rrc_pdsch_CapacityAllocationInfo_01;  /* PDSCH_CapacityAllocationInfo_r4 */
static int hf_rrc_confirmRequest_01;              /* T_confirmRequest_01 */
static int hf_rrc_iscpTimeslotList_01;            /* TimeslotList_r4 */
static int hf_rrc_ul_TimingAdvance_03;            /* UL_TimingAdvanceControl_r7 */
static int hf_rrc_pusch_CapacityAllocationInfo_02;  /* PUSCH_CapacityAllocationInfo_r7 */
static int hf_rrc_pdsch_CapacityAllocationInfo_02;  /* PDSCH_CapacityAllocationInfo_r7 */
static int hf_rrc_trafficVolume;                  /* TrafficVolumeMeasuredResultsList */
static int hf_rrc_timeslotListWithISCP;           /* TimeslotListWithISCP */
static int hf_rrc_primaryCCPCH_RSCP;              /* PrimaryCCPCH_RSCP */
static int hf_rrc_allocationConfirmation;         /* T_allocationConfirmation */
static int hf_rrc_pdschConfirmation;              /* PDSCH_Identity */
static int hf_rrc_puschConfirmation;              /* PUSCH_Identity */
static int hf_rrc_protocolErrorIndicator;         /* ProtocolErrorIndicatorWithMoreInfo */
static int hf_rrc_laterNonCriticalExtensions_29;  /* T_laterNonCriticalExtensions_27 */
static int hf_rrc_puschCapacityRequest_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_13;   /* T_v590NonCriticalExtensions_13 */
static int hf_rrc_puschCapacityRequest_v590ext;   /* PUSCHCapacityRequest_v590ext */
static int hf_rrc_nonCriticalExtensions_98;       /* T_nonCriticalExtensions_98 */
static int hf_rrc_primaryCCPCH_RSCP_delta;        /* DeltaRSCP */
static int hf_rrc_r3_14;                          /* T_r3_14 */
static int hf_rrc_radioBearerReconfiguration_r3;  /* RadioBearerReconfiguration_r3_IEs */
static int hf_rrc_v3aoNonCriticalExtensions;      /* T_v3aoNonCriticalExtensions */
static int hf_rrc_radioBearerReconfiguration_v3a0ext;  /* RadioBearerReconfiguration_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_30;  /* T_laterNonCriticalExtensions_28 */
static int hf_rrc_radioBearerReconfiguration_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_07;   /* T_v4b0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerReconfiguration_v4b0ext;  /* RadioBearerReconfiguration_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_14;   /* T_v590NonCriticalExtensions_14 */
static int hf_rrc_radioBearerReconfiguration_v590ext;  /* RadioBearerReconfiguration_v590ext_IEs */
static int hf_rrc_v5d0NonCriticalExtenstions_06;  /* T_v5d0NonCriticalExtenstions_06 */
static int hf_rrc_radioBearerReconfiguration_v5d0ext;  /* RadioBearerReconfiguration_v5d0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_16;   /* T_v690NonCriticalExtensions_16 */
static int hf_rrc_radioBearerReconfiguration_v690ext;  /* RadioBearerReconfiguration_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_10;   /* T_v770NonCriticalExtensions_10 */
static int hf_rrc_radioBearerReconfiguration_v770ext;  /* RadioBearerReconfiguration_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_99;       /* T_nonCriticalExtensions_99 */
static int hf_rrc_later_than_r3_12;               /* T_later_than_r3_12 */
static int hf_rrc_criticalExtensions_80;          /* T_criticalExtensions_78 */
static int hf_rrc_r4_06;                          /* T_r4_06 */
static int hf_rrc_radioBearerReconfiguration_r4;  /* RadioBearerReconfiguration_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_06;   /* T_v4d0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerReconfiguration_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_15;   /* T_v590NonCriticalExtensions_15 */
static int hf_rrc_v5d0NonCriticalExtenstions_07;  /* T_v5d0NonCriticalExtenstions_07 */
static int hf_rrc_v690NonCriticalExtensions_17;   /* T_v690NonCriticalExtensions_17 */
static int hf_rrc_v770NonCriticalExtensions_11;   /* T_v770NonCriticalExtensions_11 */
static int hf_rrc_nonCriticalExtensions_100;      /* T_nonCriticalExtensions_100 */
static int hf_rrc_criticalExtensions_81;          /* T_criticalExtensions_79 */
static int hf_rrc_r5_05;                          /* T_r5_05 */
static int hf_rrc_radioBearerReconfiguration_r5;  /* RadioBearerReconfiguration_r5_IEs */
static int hf_rrc_radioBearerReconfiguration_r5_add_ext;  /* BIT_STRING */
static int hf_rrc_v5d0NonCriticalExtenstions_08;  /* T_v5d0NonCriticalExtenstions_08 */
static int hf_rrc_v690NonCriticalExtensions_18;   /* T_v690NonCriticalExtensions_18 */
static int hf_rrc_v770NonCriticalExtensions_12;   /* T_v770NonCriticalExtensions_12 */
static int hf_rrc_nonCriticalExtensions_101;      /* T_nonCriticalExtensions_101 */
static int hf_rrc_criticalExtensions_82;          /* T_criticalExtensions_80 */
static int hf_rrc_r6_07;                          /* T_r6_07 */
static int hf_rrc_radioBearerReconfiguration_r6;  /* RadioBearerReconfiguration_r6_IEs */
static int hf_rrc_radioBearerReconfiguration_r6_add_ext;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_07;   /* T_v6b0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerReconfiguration_v6b0ext;  /* RadioBearerReconfiguration_v6b0ext_IEs */
static int hf_rrc_v6f0NonCriticalExtensions;      /* T_v6f0NonCriticalExtensions */
static int hf_rrc_radioBearerRconfiguration_v6f0ext;  /* RadioBearerReconfiguration_v6f0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_13;   /* T_v770NonCriticalExtensions_13 */
static int hf_rrc_nonCriticalExtensions_102;      /* T_nonCriticalExtensions_102 */
static int hf_rrc_criticalExtensions_83;          /* T_criticalExtensions_81 */
static int hf_rrc_r7_06;                          /* T_r7_06 */
static int hf_rrc_radioBearerReconfiguration_r7;  /* RadioBearerReconfiguration_r7_IEs */
static int hf_rrc_v780NonCriticalExtensions_05;   /* T_v780NonCriticalExtensions_05 */
static int hf_rrc_radioBearerReconfiguration_v780ext;  /* RadioBearerReconfiguration_v780ext_IEs */
static int hf_rrc_v790NonCriticalExtensions;      /* T_v790NonCriticalExtensions */
static int hf_rrc_radioBearerReconfiguration_v790ext;  /* RadioBearerReconfiguration_v790ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_06;   /* T_v7d0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerReconfiguration_v7d0ext;  /* RadioBearerReconfiguration_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_07;   /* T_v7f0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerReconfiguration_v7f0ext;  /* RadioBearerReconfiguration_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_08;   /* T_v7g0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerReconfiguration_v7g0ext;  /* RadioBearerReconfiguration_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_103;      /* T_nonCriticalExtensions_103 */
static int hf_rrc_criticalExtensions_84;          /* T_criticalExtensions_82 */
static int hf_rrc_r8_07;                          /* T_r8_07 */
static int hf_rrc_radioBearerReconfiguration_r8;  /* RadioBearerReconfiguration_r8_IEs */
static int hf_rrc_radioBearerReconfiguration_r8_add_ext;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_07;   /* T_v7d0NonCriticalExtensions_07 */
static int hf_rrc_v7f0NonCriticalExtensions_08;   /* T_v7f0NonCriticalExtensions_08 */
static int hf_rrc_v890NonCriticalExtensions_05;   /* T_v890NonCriticalExtensions_05 */
static int hf_rrc_radioBearerReconfiguration_v890ext;  /* RadioBearerReconfiguration_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_09;   /* T_v7g0NonCriticalExtensions_09 */
static int hf_rrc_v8a0NonCriticalExtensions_05;   /* T_v8a0NonCriticalExtensions_05 */
static int hf_rrc_radioBearerReconfiguration_v8a0ext;  /* RadioBearerReconfiguration_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_104;      /* T_nonCriticalExtensions_104 */
static int hf_rrc_criticalExtensions_85;          /* T_criticalExtensions_83 */
static int hf_rrc_r9_06;                          /* T_r9_06 */
static int hf_rrc_radioBearerReconfiguration_r9;  /* RadioBearerReconfiguration_r9_IEs */
static int hf_rrc_radioBearerReconfiguration_r9_add_ext;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_04;   /* T_v950NonCriticalExtensions_04 */
static int hf_rrc_radioBearerReconfiguration_v950ext;  /* RadioBearerReconfiguration_v950ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_04;   /* T_v9c0NonCriticalExtensions_04 */
static int hf_rrc_radioBearerReconfiguration_v9c0ext;  /* RadioBearerReconfiguration_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_105;      /* T_nonCriticalExtensions_105 */
static int hf_rrc_criticalExtensions_86;          /* T_criticalExtensions_84 */
static int hf_rrc_r10_06;                         /* T_r10_06 */
static int hf_rrc_radioBearerReconfiguration_r10;  /* RadioBearerReconfiguration_r10_IEs */
static int hf_rrc_radioBearerReconfiguration_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_05;   /* T_v9c0NonCriticalExtensions_05 */
static int hf_rrc_vaa0NonCriticalExtensions_01;   /* T_vaa0NonCriticalExtensions_01 */
static int hf_rrc_radioBearerReconfiguration_vaa0ext;  /* RadioBearerReconfiguration_vaa0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_12;   /* T_vb50NonCriticalExtensions_12 */
static int hf_rrc_radioBearerReconfiguration_vb50ext;  /* RadioBearerReconfiguration_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_106;      /* T_nonCriticalExtensions_106 */
static int hf_rrc_criticalExtensions_87;          /* T_criticalExtensions_85 */
static int hf_rrc_r11_07;                         /* T_r11_07 */
static int hf_rrc_radioBearerReconfiguration_r11;  /* RadioBearerReconfiguration_r11_IEs */
static int hf_rrc_radioBearerReconfiguration_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_107;      /* T_nonCriticalExtensions_107 */
static int hf_rrc_criticalExtensions_88;          /* T_criticalExtensions_86 */
static int hf_rrc_r12_06;                         /* T_r12_06 */
static int hf_rrc_radioBearerReconfiguration_r12;  /* RadioBearerReconfiguration_r12_IEs */
static int hf_rrc_radioBearerReconfiguration_r12_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_108;      /* T_nonCriticalExtensions_108 */
static int hf_rrc_criticalExtensions_89;          /* T_criticalExtensions_87 */
static int hf_rrc_r13_05;                         /* T_r13_05 */
static int hf_rrc_radioBearerReconfiguration_r13;  /* RadioBearerReconfiguration_r13_IEs */
static int hf_rrc_radioBearerReconfiguration_r13_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_109;      /* T_nonCriticalExtensions_109 */
static int hf_rrc_criticalExtensions_90;          /* T_criticalExtensions_88 */
static int hf_rrc_r14_03;                         /* T_r14_03 */
static int hf_rrc_radioBearerReconfiguration_r14;  /* RadioBearerReconfiguration_r14_IEs */
static int hf_rrc_radioBearerReconfiguration_r14_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_110;      /* T_nonCriticalExtensions_110 */
static int hf_rrc_laterCriticalExtensions_01;     /* RadioBearerReconfiguration_LaterCriticalExtensions_r15_IEs */
static int hf_rrc_um_RLC_ReEstablishmentRBList;   /* RB_IdentityList */
static int hf_rrc_rab_InformationReconfigList;    /* RAB_InformationReconfigList */
static int hf_rrc_dummy_03;                       /* T_dummy_01 */
static int hf_rrc_fdd_22;                         /* T_fdd_22 */
static int hf_rrc_dl_AddReconfTransChInfoList_08;  /* DL_AddReconfTransChInfo2List */
static int hf_rrc_modeSpecificPhysChInfo_03;      /* T_modeSpecificPhysChInfo_03 */
static int hf_rrc_fdd_23;                         /* T_fdd_23 */
static int hf_rrc_dummy_04;                       /* T_dummy_02 */
static int hf_rrc_fdd_24;                         /* T_fdd_24 */
static int hf_rrc_modeSpecificPhysChInfo_04;      /* T_modeSpecificPhysChInfo_04 */
static int hf_rrc_fdd_25;                         /* T_fdd_25 */
static int hf_rrc_specificationMode_11;           /* T_specificationMode_11 */
static int hf_rrc_complete_11;                    /* T_complete_11 */
static int hf_rrc_rb_PDCPContextRelocationList;   /* RB_PDCPContextRelocationList */
static int hf_rrc_dummy_05;                       /* T_dummy_03 */
static int hf_rrc_fdd_26;                         /* T_fdd_26 */
static int hf_rrc_preconfiguration_10;            /* T_preconfiguration_10 */
static int hf_rrc_preConfigMode_10;               /* T_preConfigMode_10 */
static int hf_rrc_defaultConfig_10;               /* T_defaultConfig_10 */
static int hf_rrc_modeSpecificPhysChInfo_05;      /* T_modeSpecificPhysChInfo_05 */
static int hf_rrc_fdd_27;                         /* T_fdd_27 */
static int hf_rrc_specificationMode_12;           /* T_specificationMode_12 */
static int hf_rrc_complete_12;                    /* T_complete_12 */
static int hf_rrc_preconfiguration_11;            /* T_preconfiguration_11 */
static int hf_rrc_preConfigMode_11;               /* T_preConfigMode_11 */
static int hf_rrc_defaultConfig_11;               /* T_defaultConfig_11 */
static int hf_rrc_postVerificationPeriod_02;      /* T_postVerificationPeriod_02 */
static int hf_rrc_specificationMode_13;           /* T_specificationMode_13 */
static int hf_rrc_complete_13;                    /* T_complete_13 */
static int hf_rrc_rab_InformationMBMSPtpList;     /* RAB_InformationMBMSPtpList */
static int hf_rrc_responseToChangeOfUE_Capability_07;  /* T_responseToChangeOfUE_Capability_07 */
static int hf_rrc_specificationMode_14;           /* T_specificationMode_14 */
static int hf_rrc_complete_14;                    /* T_complete_14 */
static int hf_rrc_preconfiguration_12;            /* T_preconfiguration_12 */
static int hf_rrc_preConfigMode_12;               /* T_preConfigMode_12 */
static int hf_rrc_defaultConfig_12;               /* T_defaultConfig_12 */
static int hf_rrc_radioBearerReconfiguration_r7_add_ext;  /* BIT_STRING */
static int hf_rrc_responseToChangeOfUE_Capability_08;  /* T_responseToChangeOfUE_Capability_08 */
static int hf_rrc_specificationMode_15;           /* T_specificationMode_15 */
static int hf_rrc_complete_15;                    /* T_complete_15 */
static int hf_rrc_rab_InformationReconfigList_01;  /* RAB_InformationReconfigList_r8 */
static int hf_rrc_preconfiguration_13;            /* T_preconfiguration_13 */
static int hf_rrc_preConfigMode_13;               /* T_preConfigMode_13 */
static int hf_rrc_defaultConfig_13;               /* T_defaultConfig_13 */
static int hf_rrc_responseToChangeOfUE_Capability_09;  /* T_responseToChangeOfUE_Capability_09 */
static int hf_rrc_specificationMode_16;           /* T_specificationMode_16 */
static int hf_rrc_complete_16;                    /* T_complete_16 */
static int hf_rrc_preconfiguration_14;            /* T_preconfiguration_14 */
static int hf_rrc_preConfigMode_14;               /* T_preConfigMode_14 */
static int hf_rrc_defaultConfig_14;               /* T_defaultConfig_14 */
static int hf_rrc_responseToChangeOfUE_Capability_10;  /* T_responseToChangeOfUE_Capability_10 */
static int hf_rrc_specificationMode_17;           /* T_specificationMode_17 */
static int hf_rrc_complete_17;                    /* T_complete_17 */
static int hf_rrc_preconfiguration_15;            /* T_preconfiguration_15 */
static int hf_rrc_preConfigMode_15;               /* T_preConfigMode_15 */
static int hf_rrc_defaultConfig_15;               /* T_defaultConfig_15 */
static int hf_rrc_responseToChangeOfUE_Capability_11;  /* T_responseToChangeOfUE_Capability_11 */
static int hf_rrc_specificationMode_18;           /* T_specificationMode_18 */
static int hf_rrc_complete_18;                    /* T_complete_18 */
static int hf_rrc_umRlc_ReEstablishmentRBList;    /* RB_IdentityList */
static int hf_rrc_preconfiguration_16;            /* T_preconfiguration_16 */
static int hf_rrc_preConfigMode_16;               /* T_preConfigMode_16 */
static int hf_rrc_defaultConfig_16;               /* T_defaultConfig_16 */
static int hf_rrc_accessGroupIdentity;            /* AccessGroupIdentity */
static int hf_rrc_responseToChangeOfUE_Capability_12;  /* T_responseToChangeOfUE_Capability_12 */
static int hf_rrc_specificationMode_19;           /* T_specificationMode_19 */
static int hf_rrc_complete_19;                    /* T_complete_19 */
static int hf_rrc_preconfiguration_17;            /* T_preconfiguration_17 */
static int hf_rrc_preConfigMode_17;               /* T_preConfigMode_17 */
static int hf_rrc_defaultConfig_17;               /* T_defaultConfig_17 */
static int hf_rrc_rntiHandlingAtCellReselection_02;  /* T_rntiHandlingAtCellReselection_02 */
static int hf_rrc_responseToChangeOfUE_Capability_13;  /* T_responseToChangeOfUE_Capability_13 */
static int hf_rrc_specificationMode_20;           /* T_specificationMode_20 */
static int hf_rrc_complete_20;                    /* T_complete_20 */
static int hf_rrc_preconfiguration_18;            /* T_preconfiguration_18 */
static int hf_rrc_preConfigMode_18;               /* T_preConfigMode_18 */
static int hf_rrc_defaultConfig_18;               /* T_defaultConfig_18 */
static int hf_rrc_rntiHandlingAtCellReselection_03;  /* T_rntiHandlingAtCellReselection_03 */
static int hf_rrc_signallingConnectionRelIndication;  /* CN_DomainIdentity */
static int hf_rrc_responseToChangeOfUE_Capability_14;  /* T_responseToChangeOfUE_Capability_14 */
static int hf_rrc_specificationMode_21;           /* T_specificationMode_21 */
static int hf_rrc_complete_21;                    /* T_complete_21 */
static int hf_rrc_rab_InformationSetupList_07;    /* RAB_InformationSetupList_r11 */
static int hf_rrc_ul_AddReconfTransChInfoList_04;  /* UL_AddReconfTransChInfoList_r14 */
static int hf_rrc_preconfiguration_19;            /* T_preconfiguration_19 */
static int hf_rrc_preConfigMode_19;               /* T_preConfigMode_19 */
static int hf_rrc_defaultConfig_19;               /* T_defaultConfig_19 */
static int hf_rrc_ul_SecondaryCellInfoFDD_03;     /* UL_SecondaryCellInfoFDD_r14 */
static int hf_rrc_ul_OtherTTIConfigurationInfo_Sec;  /* UL_OtherTTIConfigurationInfo_Sec */
static int hf_rrc_filteredUPHReportInfo_Sec;      /* FilteredUEPowerHeadroomReportInfo */
static int hf_rrc_r15_01;                         /* T_r15_01 */
static int hf_rrc_radioBearerReconfiguration_r15;  /* RadioBearerReconfiguration_r15_IEs */
static int hf_rrc_radioBearerReconfiguration_r15_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_111;      /* T_nonCriticalExtensions_111 */
static int hf_rrc_criticalExtensions_91;          /* T_criticalExtensions_89 */
static int hf_rrc_rntiHandlingAtCellReselection_04;  /* T_rntiHandlingAtCellReselection_04 */
static int hf_rrc_responseToChangeOfUE_Capability_15;  /* T_responseToChangeOfUE_Capability_15 */
static int hf_rrc_specificationMode_22;           /* T_specificationMode_22 */
static int hf_rrc_complete_22;                    /* T_complete_22 */
static int hf_rrc_preconfiguration_20;            /* T_preconfiguration_20 */
static int hf_rrc_preConfigMode_20;               /* T_preConfigMode_20 */
static int hf_rrc_defaultConfig_20;               /* T_defaultConfig_20 */
static int hf_rrc_simplified_HS_SCCH_type1_operation;  /* T_simplified_HS_SCCH_type1_operation */
static int hf_rrc_laterNonCriticalExtensions_31;  /* T_laterNonCriticalExtensions_29 */
static int hf_rrc_radioBearerReconfigurationComplete_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_14;   /* T_v770NonCriticalExtensions_14 */
static int hf_rrc_radioBearerReconfigurationComplete_v770ext;  /* RadioBearerReconfigurationComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_112;      /* T_nonCriticalExtensions_112 */
static int hf_rrc_deferredMeasurementControlReading_01;  /* T_deferredMeasurementControlReading_01 */
static int hf_rrc_potentiallySuccesfulBearerList;  /* RB_IdentityList */
static int hf_rrc_laterNonCriticalExtensions_32;  /* T_laterNonCriticalExtensions_30 */
static int hf_rrc_radioBearerReconfigurationFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_113;      /* T_nonCriticalExtensions_113 */
static int hf_rrc_r3_15;                          /* T_r3_15 */
static int hf_rrc_radioBearerRelease_r3;          /* RadioBearerRelease_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_06;   /* T_v3a0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v3a0ext;     /* RadioBearerRelease_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_33;  /* T_laterNonCriticalExtensions_31 */
static int hf_rrc_radioBearerRelease_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_08;   /* T_v4b0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerRelease_v4b0ext;     /* RadioBearerRelease_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_16;   /* T_v590NonCriticalExtensions_16 */
static int hf_rrc_radioBearerRelease_v590ext;     /* RadioBearerRelease_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_19;   /* T_v690NonCriticalExtensions_19 */
static int hf_rrc_radioBearerRelease_v690ext;     /* RadioBearerRelease_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_15;   /* T_v770NonCriticalExtensions_15 */
static int hf_rrc_radioBearerRelease_v770ext;     /* RadioBearerRelease_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_114;      /* T_nonCriticalExtensions_114 */
static int hf_rrc_later_than_r3_13;               /* T_later_than_r3_13 */
static int hf_rrc_criticalExtensions_92;          /* T_criticalExtensions_90 */
static int hf_rrc_r4_07;                          /* T_r4_07 */
static int hf_rrc_radioBearerRelease_r4;          /* RadioBearerRelease_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_07;   /* T_v4d0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerRelease_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_17;   /* T_v590NonCriticalExtensions_17 */
static int hf_rrc_v690NonCriticalExtensions_20;   /* T_v690NonCriticalExtensions_20 */
static int hf_rrc_v770NonCriticalExtensions_16;   /* T_v770NonCriticalExtensions_16 */
static int hf_rrc_nonCriticalExtensions_115;      /* T_nonCriticalExtensions_115 */
static int hf_rrc_criticalExtensions_93;          /* T_criticalExtensions_91 */
static int hf_rrc_r5_06;                          /* T_r5_06 */
static int hf_rrc_radioBearerRelease_r5;          /* RadioBearerRelease_r5_IEs */
static int hf_rrc_radioBearerRelease_r5_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_21;   /* T_v690NonCriticalExtensions_21 */
static int hf_rrc_v770NonCriticalExtensions_17;   /* T_v770NonCriticalExtensions_17 */
static int hf_rrc_nonCriticalExtensions_116;      /* T_nonCriticalExtensions_116 */
static int hf_rrc_criticalExtensions_94;          /* T_criticalExtensions_92 */
static int hf_rrc_r6_08;                          /* T_r6_08 */
static int hf_rrc_radioBearerRelease_r6;          /* RadioBearerRelease_r6_IEs */
static int hf_rrc_radioBearerRelease_r6_add_ext;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_08;   /* T_v6b0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerRelease_v6b0ext;     /* RadioBearerRelease_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_18;   /* T_v770NonCriticalExtensions_18 */
static int hf_rrc_nonCriticalExtensions_117;      /* T_nonCriticalExtensions_117 */
static int hf_rrc_criticalExtensions_95;          /* T_criticalExtensions_93 */
static int hf_rrc_r7_07;                          /* T_r7_07 */
static int hf_rrc_radioBearerRelease_r7;          /* RadioBearerRelease_r7_IEs */
static int hf_rrc_radioBearerRelease_r7_add_ext;  /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions_06;   /* T_v780NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v780ext;     /* RadioBearerRelease_v780ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_08;   /* T_v7d0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerRelease_v7d0ext;     /* RadioBearerRelease_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_09;   /* T_v7f0NonCriticalExtensions_09 */
static int hf_rrc_radioBearerRelease_v7f0ext;     /* RadioBearerRelease_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_10;   /* T_v7g0NonCriticalExtensions_10 */
static int hf_rrc_radioBearerRelease_v7g0ext;     /* RadioBearerRelease_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_118;      /* T_nonCriticalExtensions_118 */
static int hf_rrc_criticalExtensions_96;          /* T_criticalExtensions_94 */
static int hf_rrc_r8_08;                          /* T_r8_08 */
static int hf_rrc_radioBearerRelease_r8;          /* RadioBearerRelease_r8_IEs */
static int hf_rrc_radioBearerRelease_r8_add_ext;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_09;   /* T_v7d0NonCriticalExtensions_09 */
static int hf_rrc_v7f0NonCriticalExtensions_10;   /* T_v7f0NonCriticalExtensions_10 */
static int hf_rrc_v890NonCriticalExtensions_06;   /* T_v890NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v890ext;     /* RadioBearerRelease_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_11;   /* T_v7g0NonCriticalExtensions_11 */
static int hf_rrc_v8a0NonCriticalExtensions_06;   /* T_v8a0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v8a0ext;     /* RadioBearerRelease_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_119;      /* T_nonCriticalExtensions_119 */
static int hf_rrc_criticalExtensions_97;          /* T_criticalExtensions_95 */
static int hf_rrc_r9_07;                          /* T_r9_07 */
static int hf_rrc_radioBearerRelease_r9;          /* RadioBearerRelease_r9_IEs */
static int hf_rrc_radioBearerRelease_r9_add_ext;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_05;   /* T_v950NonCriticalExtensions_05 */
static int hf_rrc_radioBearerRelease_v950ext;     /* RadioBearerRelease_v950ext_IEs */
static int hf_rrc_v970NonCriticalExtensions_02;   /* T_v970NonCriticalExtensions_02 */
static int hf_rrc_radioBearerRelease_v970ext;     /* RadioBearerRelease_v970ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_06;   /* T_v9c0NonCriticalExtensions_06 */
static int hf_rrc_radioBearerRelease_v9c0ext;     /* RadioBearerRelease_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_120;      /* T_nonCriticalExtensions_120 */
static int hf_rrc_criticalExtensions_98;          /* T_criticalExtensions_96 */
static int hf_rrc_r10_07;                         /* T_r10_07 */
static int hf_rrc_radioBearerRelease_r10;         /* RadioBearerRelease_r10_IEs */
static int hf_rrc_radioBearerRelease_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_07;   /* T_v9c0NonCriticalExtensions_07 */
static int hf_rrc_vb50NonCriticalExtensions_13;   /* T_vb50NonCriticalExtensions_13 */
static int hf_rrc_radioBearerRelease_vb50ext;     /* RadioBearerRelease_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_121;      /* T_nonCriticalExtensions_121 */
static int hf_rrc_criticalExtensions_99;          /* T_criticalExtensions_97 */
static int hf_rrc_r11_08;                         /* T_r11_08 */
static int hf_rrc_radioBearerRelease_r11;         /* RadioBearerRelease_r11_IEs */
static int hf_rrc_radioBearerRelease_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_122;      /* T_nonCriticalExtensions_122 */
static int hf_rrc_criticalExtensions_100;         /* T_criticalExtensions_98 */
static int hf_rrc_r12_07;                         /* T_r12_07 */
static int hf_rrc_radioBearerRelease_r12;         /* RadioBearerRelease_r12_IEs */
static int hf_rrc_nonCriticalExtensions_123;      /* T_nonCriticalExtensions_123 */
static int hf_rrc_criticalExtensions_101;         /* T_criticalExtensions_99 */
static int hf_rrc_r13_06;                         /* T_r13_06 */
static int hf_rrc_radioBearerRelease_r13;         /* RadioBearerRelease_r13_IEs */
static int hf_rrc_radioBearerRelease_r13_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_124;      /* T_nonCriticalExtensions_124 */
static int hf_rrc_laterCriticalExtensions_02;     /* RadioBearerRelease_LaterCriticalExtensions_r15_IEs */
static int hf_rrc_dummy_06;                       /* T_dummy_04 */
static int hf_rrc_fdd_28;                         /* T_fdd_28 */
static int hf_rrc_modeSpecificPhysChInfo_06;      /* T_modeSpecificPhysChInfo_06 */
static int hf_rrc_fdd_29;                         /* T_fdd_29 */
static int hf_rrc_dummy_07;                       /* T_dummy_05 */
static int hf_rrc_fdd_30;                         /* T_fdd_30 */
static int hf_rrc_modeSpecificPhysChInfo_07;      /* T_modeSpecificPhysChInfo_07 */
static int hf_rrc_fdd_31;                         /* T_fdd_31 */
static int hf_rrc_dummy_08;                       /* T_dummy_06 */
static int hf_rrc_fdd_32;                         /* T_fdd_32 */
static int hf_rrc_modeSpecificPhysChInfo_08;      /* T_modeSpecificPhysChInfo_08 */
static int hf_rrc_fdd_33;                         /* T_fdd_33 */
static int hf_rrc_postVerificationPeriod_03;      /* T_postVerificationPeriod_03 */
static int hf_rrc_mbms_RB_ListReleasedToChangeTransferMode;  /* RB_InformationReleaseList */
static int hf_rrc_non_rectResAllocInd_TDD128;     /* Non_rectResAllocInd_TDD128 */
static int hf_rrc_non_rectResSpecTSset_TDD128;    /* Non_rectResSpecTSset_TDD128 */
static int hf_rrc_r15_02;                         /* T_r15_02 */
static int hf_rrc_radioBearerRelease_r15;         /* RadioBearerRelease_r15_IEs */
static int hf_rrc_radioBearerRelease_r15_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_125;      /* T_nonCriticalExtensions_125 */
static int hf_rrc_criticalExtensions_102;         /* T_criticalExtensions_100 */
static int hf_rrc_simplified_HS_SCCH_type1_operation_01;  /* T_simplified_HS_SCCH_type1_operation_01 */
static int hf_rrc_laterNonCriticalExtensions_34;  /* T_laterNonCriticalExtensions_32 */
static int hf_rrc_radioBearerReleaseComplete_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_19;   /* T_v770NonCriticalExtensions_19 */
static int hf_rrc_radioBearerReleaseComplete_v770ext;  /* RadioBearerReleaseComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_126;      /* T_nonCriticalExtensions_126 */
static int hf_rrc_deferredMeasurementControlReading_02;  /* T_deferredMeasurementControlReading_02 */
static int hf_rrc_laterNonCriticalExtensions_35;  /* T_laterNonCriticalExtensions_33 */
static int hf_rrc_radioBearerReleaseFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_127;      /* T_nonCriticalExtensions_127 */
static int hf_rrc_r3_16;                          /* T_r3_16 */
static int hf_rrc_radioBearerSetup_r3;            /* RadioBearerSetup_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_07;   /* T_v3a0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerSetup_v3a0ext;       /* RadioBearerSetup_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_36;  /* T_laterNonCriticalExtensions_34 */
static int hf_rrc_radioBearerSetup_r3_add_ext;    /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_09;   /* T_v4b0NonCriticalExtensions_09 */
static int hf_rrc_radioBearerSetup_v4b0ext;       /* RadioBearerSetup_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_18;   /* T_v590NonCriticalExtensions_18 */
static int hf_rrc_radioBearerSetup_v590ext;       /* RadioBearerSetup_v590ext_IEs */
static int hf_rrc_v5d0NonCriticalExtenstions_09;  /* T_v5d0NonCriticalExtenstions_09 */
static int hf_rrc_radioBearerSetup_v5d0ext;       /* RadioBearerSetup_v5d0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_22;   /* T_v690NonCriticalExtensions_22 */
static int hf_rrc_radioBearerSetup_v690ext;       /* RadioBearerSetup_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_128;      /* T_nonCriticalExtensions_128 */
static int hf_rrc_later_than_r3_14;               /* T_later_than_r3_14 */
static int hf_rrc_criticalExtensions_103;         /* T_criticalExtensions_101 */
static int hf_rrc_r4_08;                          /* T_r4_08 */
static int hf_rrc_radioBearerSetup_r4;            /* RadioBearerSetup_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_08;   /* T_v4d0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerSetup_r4_add_ext;    /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_19;   /* T_v590NonCriticalExtensions_19 */
static int hf_rrc_v5d0NonCriticalExtenstions_10;  /* T_v5d0NonCriticalExtenstions_10 */
static int hf_rrc_v690NonCriticalExtensions_23;   /* T_v690NonCriticalExtensions_23 */
static int hf_rrc_nonCriticalExtensions_129;      /* T_nonCriticalExtensions_129 */
static int hf_rrc_criticalExtensions_104;         /* T_criticalExtensions_102 */
static int hf_rrc_r5_07;                          /* T_r5_07 */
static int hf_rrc_radioBearerSetup_r5;            /* RadioBearerSetup_r5_IEs */
static int hf_rrc_radioBearerSetup_r5_add_ext;    /* BIT_STRING */
static int hf_rrc_v5d0NonCriticalExtenstions_11;  /* T_v5d0NonCriticalExtenstions_11 */
static int hf_rrc_v690NonCriticalExtensions_24;   /* T_v690NonCriticalExtensions_24 */
static int hf_rrc_nonCriticalExtensions_130;      /* T_nonCriticalExtensions_130 */
static int hf_rrc_criticalExtensions_105;         /* T_criticalExtensions_103 */
static int hf_rrc_r6_09;                          /* T_r6_09 */
static int hf_rrc_radioBearerSetup_r6;            /* RadioBearerSetup_r6_IEs */
static int hf_rrc_radioBearerSetup_r6_add_ext;    /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_09;   /* T_v6b0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerSetup_v6b0ext;       /* RadioBearerSetup_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_131;      /* T_nonCriticalExtensions_131 */
static int hf_rrc_criticalExtensions_106;         /* T_criticalExtensions_104 */
static int hf_rrc_r7_08;                          /* T_r7_08 */
static int hf_rrc_radioBearerSetup_r7;            /* RadioBearerSetup_r7_IEs */
static int hf_rrc_radioBearerSetup_r7_add_ext;    /* T_radioBearerSetup_r7_add_ext */
static int hf_rrc_v780NonCriticalExtensions_07;   /* T_v780NonCriticalExtensions_07 */
static int hf_rrc_radioBearerSetup_v780ext;       /* RadioBearerSetup_v780ext_IEs */
static int hf_rrc_v820NonCriticalExtensions_01;   /* T_v820NonCriticalExtensions_01 */
static int hf_rrc_radioBearerSetup_v820ext;       /* RadioBearerSetup_v820ext_IEs */
static int hf_rrc_nonCriticalExtensions_132;      /* T_nonCriticalExtensions_132 */
static int hf_rrc_criticalExtensions_107;         /* T_criticalExtensions_105 */
static int hf_rrc_r8_09;                          /* T_r8_09 */
static int hf_rrc_radioBearerSetup_r8;            /* RadioBearerSetup_r8_IEs */
static int hf_rrc_radioBearerSetup_r8_add_ext;    /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_10;   /* T_v7d0NonCriticalExtensions_10 */
static int hf_rrc_radioBearerSetup_v7d0ext;       /* RadioBearerSetup_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_11;   /* T_v7f0NonCriticalExtensions_11 */
static int hf_rrc_radioBearerSetup_v7f0ext;       /* RadioBearerSetup_v7f0ext_IEs */
static int hf_rrc_v890NonCriticalExtensions_07;   /* T_v890NonCriticalExtensions_07 */
static int hf_rrc_radioBearerSetup_v890ext;       /* RadioBearerSetup_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_12;   /* T_v7g0NonCriticalExtensions_12 */
static int hf_rrc_radioBearerSetup_v7g0ext;       /* RadioBearerSetup_v7g0ext_IEs */
static int hf_rrc_v8a0NonCriticalExtensions_07;   /* T_v8a0NonCriticalExtensions_07 */
static int hf_rrc_radioBearerSetup_v8a0ext;       /* RadioBearerSetup_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_133;      /* T_nonCriticalExtensions_133 */
static int hf_rrc_criticalExtensions_108;         /* T_criticalExtensions_106 */
static int hf_rrc_r9_08;                          /* T_r9_08 */
static int hf_rrc_radioBearerSetup_r9;            /* RadioBearerSetup_r9_IEs */
static int hf_rrc_radioBearerSetup_r9_add_ext;    /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_06;   /* T_v950NonCriticalExtensions_06 */
static int hf_rrc_radioBearerSetup_v950ext;       /* RadioBearerSetup_v950ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_08;   /* T_v9c0NonCriticalExtensions_08 */
static int hf_rrc_radioBearerSetup_v9c0ext;       /* RadioBearerSetup_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_134;      /* T_nonCriticalExtensions_134 */
static int hf_rrc_criticalExtensions_109;         /* T_criticalExtensions_107 */
static int hf_rrc_r10_08;                         /* T_r10_08 */
static int hf_rrc_radioBearerSetup_r10;           /* RadioBearerSetup_r10_IEs */
static int hf_rrc_radioBearerSetup_r10_add_ext;   /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_09;   /* T_v9c0NonCriticalExtensions_09 */
static int hf_rrc_vb50NonCriticalExtensions_14;   /* T_vb50NonCriticalExtensions_14 */
static int hf_rrc_radioBearerSetup_vb50ext;       /* RadioBearerSetup_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_135;      /* T_nonCriticalExtensions_135 */
static int hf_rrc_criticalExtensions_110;         /* T_criticalExtensions_108 */
static int hf_rrc_r11_09;                         /* T_r11_09 */
static int hf_rrc_radioBearerSetup_r11;           /* RadioBearerSetup_r11_IEs */
static int hf_rrc_radioBearerSetup_r11_add_ext;   /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_136;      /* T_nonCriticalExtensions_136 */
static int hf_rrc_criticalExtensions_111;         /* T_criticalExtensions_109 */
static int hf_rrc_r12_08;                         /* T_r12_08 */
static int hf_rrc_radioBearerSetup_r12;           /* RadioBearerSetup_r12_IEs */
static int hf_rrc_radioBearerSetup_r13_add_ext;   /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_137;      /* T_nonCriticalExtensions_137 */
static int hf_rrc_criticalExtensions_112;         /* T_criticalExtensions_110 */
static int hf_rrc_r13_07;                         /* T_r13_07 */
static int hf_rrc_radioBearerSetup_r13;           /* RadioBearerSetup_r13_IEs */
static int hf_rrc_nonCriticalExtensions_138;      /* T_nonCriticalExtensions_138 */
static int hf_rrc_laterCriticalExtensions_03;     /* RadioBearerSetup_LaterCriticalExtensions_r15_IEs */
static int hf_rrc_dummy_09;                       /* T_dummy_07 */
static int hf_rrc_fdd_34;                         /* T_fdd_34 */
static int hf_rrc_modeSpecificPhysChInfo_09;      /* T_modeSpecificPhysChInfo_09 */
static int hf_rrc_fdd_35;                         /* T_fdd_35 */
static int hf_rrc_dummy_10;                       /* T_dummy_08 */
static int hf_rrc_fdd_36;                         /* T_fdd_36 */
static int hf_rrc_modeSpecificPhysChInfo_10;      /* T_modeSpecificPhysChInfo_10 */
static int hf_rrc_fdd_37;                         /* T_fdd_37 */
static int hf_rrc_dummy_11;                       /* T_dummy_09 */
static int hf_rrc_fdd_38;                         /* T_fdd_38 */
static int hf_rrc_modeSpecificPhysChInfo_11;      /* T_modeSpecificPhysChInfo_11 */
static int hf_rrc_fdd_39;                         /* T_fdd_39 */
static int hf_rrc_postVerificationPeriod_04;      /* T_postVerificationPeriod_04 */
static int hf_rrc_rab_InformationSetupList_08;    /* RAB_InformationSetupList_r6_ext */
static int hf_rrc_specificationMode_23;           /* T_specificationMode_23 */
static int hf_rrc_complete_23;                    /* T_complete_23 */
static int hf_rrc_dummy_12;                       /* T_dummy_10 */
static int hf_rrc_rab_Info_01;                    /* RAB_Info_r6 */
static int hf_rrc_rb_InformationChangedList;      /* RB_InformationChangedList_r6 */
static int hf_rrc_powerOffsetInfoShort;           /* PowerOffsetInfoShort */
static int hf_rrc_rab_InformationSetupListExt;    /* RAB_InformationSetupList_v6b0ext */
static int hf_rrc_specificationMode_24;           /* T_specificationMode_24 */
static int hf_rrc_complete_24;                    /* T_complete_24 */
static int hf_rrc_dummy_13;                       /* NULL */
static int hf_rrc_v7f0NonCriticalExtensions_12;   /* T_v7f0NonCriticalExtensions_12 */
static int hf_rrc_v7g0NonCriticalExtensions_13;   /* T_v7g0NonCriticalExtensions_13 */
static int hf_rrc_nonCriticalExtensions_139;      /* T_nonCriticalExtensions_139 */
static int hf_rrc_sr_vcc_Info;                    /* SR_VCC_Info */
static int hf_rrc_srb_InformationSetupList_05;    /* SRB_InformationSetupList_r11 */
static int hf_rrc_r15_03;                         /* T_r15_03 */
static int hf_rrc_radioBearerSetup_r15;           /* RadioBearerSetup_r15_IEs */
static int hf_rrc_radioBearerSetup_r15_add_ext;   /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_140;      /* T_nonCriticalExtensions_140 */
static int hf_rrc_criticalExtensions_113;         /* T_criticalExtensions_111 */
static int hf_rrc_simplified_HS_SCCH_type1_operation_02;  /* T_simplified_HS_SCCH_type1_operation_02 */
static int hf_rrc_laterNonCriticalExtensions_37;  /* T_laterNonCriticalExtensions_35 */
static int hf_rrc_radioBearerSetupComplete_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_20;   /* T_v770NonCriticalExtensions_20 */
static int hf_rrc_radioBearerSetupComplete_v770ext;  /* RadioBearerSetupComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_141;      /* T_nonCriticalExtensions_141 */
static int hf_rrc_deferredMeasurementControlReading_03;  /* T_deferredMeasurementControlReading_03 */
static int hf_rrc_laterNonCriticalExtensions_38;  /* T_laterNonCriticalExtensions_36 */
static int hf_rrc_radioBearerSetupFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_142;      /* T_nonCriticalExtensions_142 */
static int hf_rrc_r3_17;                          /* T_r3_17 */
static int hf_rrc_rrcConnectionReject_r3;         /* RRCConnectionReject_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_39;  /* T_laterNonCriticalExtensions_37 */
static int hf_rrc_rrcConnectionReject_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_25;   /* T_v690NonCriticalExtensions_25 */
static int hf_rrc_rrcConnectionReject_v690ext;    /* RRCConnectionReject_v690ext_IEs */
static int hf_rrc_v6f0NonCriticalExtensions_01;   /* T_v6f0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionReject_v6f0ext;    /* RRCConnectionReject_v6f0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_10;   /* T_v860NonCriticalExtensions_10 */
static int hf_rrc_rrcConnectionReject_v860ext;    /* RRCConnectionReject_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_05;   /* T_va40NonCriticalExtensions_05 */
static int hf_rrc_rrcConnectionReject_va40ext;    /* RRCConnectionReject_va40ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_15;   /* T_vb50NonCriticalExtensions_15 */
static int hf_rrc_rrcConnectionReject_vb50ext;    /* RRCConnectionReject_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_143;      /* T_nonCriticalExtensions_143 */
static int hf_rrc_later_than_r3_15;               /* T_later_than_r3_15 */
static int hf_rrc_initialUE_Identity;             /* InitialUE_Identity */
static int hf_rrc_criticalExtensions_114;         /* T_criticalExtensions_112 */
static int hf_rrc_rejectionCause;                 /* RejectionCause */
static int hf_rrc_redirectionInfo;                /* RedirectionInfo */
static int hf_rrc_redirectionInfo_v690ext;        /* GSM_TargetCellInfoList */
static int hf_rrc_countingCompletion;             /* T_countingCompletion */
static int hf_rrc_redirectionInfo_01;             /* RedirectionInfo_v860ext */
static int hf_rrc_extendedWaitTime;               /* ExtendedWaitTime */
static int hf_rrc_eutra_TargetFreqInfoList;       /* EUTRA_TargetFreqInfoList_vb50ext */
static int hf_rrc_r3_18;                          /* T_r3_18 */
static int hf_rrc_rrcConnectionRelease_r3;        /* RRCConnectionRelease_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_40;  /* T_laterNonCriticalExtensions_38 */
static int hf_rrc_rrcConnectionRelease_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_26;   /* T_v690NonCriticalExtensions_26 */
static int hf_rrc_rrcConnectionRelease_v690ext;   /* RRCConnectionRelease_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_21;   /* T_v770NonCriticalExtensions_21 */
static int hf_rrc_rrcConnectionRelease_v770ext;   /* RRCConnectionRelease_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_11;   /* T_v860NonCriticalExtensions_11 */
static int hf_rrc_rrcConnectionRelease_v860ext;   /* RRCConnectionRelease_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_06;   /* T_va40NonCriticalExtensions_06 */
static int hf_rrc_rrcConnectionRelease_va40ext;   /* RRCConnectionRelease_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_144;      /* T_nonCriticalExtensions_144 */
static int hf_rrc_later_than_r3_16;               /* T_later_than_r3_16 */
static int hf_rrc_criticalExtensions_115;         /* T_criticalExtensions_113 */
static int hf_rrc_r4_09;                          /* T_r4_09 */
static int hf_rrc_rrcConnectionRelease_r4;        /* RRCConnectionRelease_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_09;   /* T_v4d0NonCriticalExtensions_09 */
static int hf_rrc_rrcConnectionRelease_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_27;   /* T_v690NonCriticalExtensions_27 */
static int hf_rrc_v770NonCriticalExtensions_22;   /* T_v770NonCriticalExtensions_22 */
static int hf_rrc_v860NonCriticalExtensions_12;   /* T_v860NonCriticalExtensions_12 */
static int hf_rrc_va40NonCriticalExtensions_07;   /* T_va40NonCriticalExtensions_07 */
static int hf_rrc_vb50NonCriticalExtensions_16;   /* T_vb50NonCriticalExtensions_16 */
static int hf_rrc_rrcConnectionRelease_vb50ext;   /* RRCConnectionRelease_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_145;      /* T_nonCriticalExtensions_145 */
static int hf_rrc_criticalExtensions_116;         /* T_criticalExtensions_114 */
static int hf_rrc_n_308;                          /* N_308 */
static int hf_rrc_releaseCause;                   /* ReleaseCause */
static int hf_rrc_rplmn_information;              /* Rplmn_Information */
static int hf_rrc_rplmn_information_01;           /* Rplmn_Information_r4 */
static int hf_rrc_redirectionInfo_v690ext_01;     /* RedirectionInfo_r6 */
static int hf_rrc_r3_19;                          /* T_r3_19 */
static int hf_rrc_rrcConnectionRelease_CCCH_r3;   /* RRCConnectionRelease_CCCH_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_41;  /* T_laterNonCriticalExtensions_39 */
static int hf_rrc_rrcConnectionRelease_CCCH_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_28;   /* T_v690NonCriticalExtensions_28 */
static int hf_rrc_rrcConnectionRelease_v690ext_01;  /* RRCConnectionRelease_CCCH_v690ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_13;   /* T_v860NonCriticalExtensions_13 */
static int hf_rrc_rrcConnectionRelease_v860ext_01;  /* RRCConnectionRelease_CCCH_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_08;   /* T_va40NonCriticalExtensions_08 */
static int hf_rrc_nonCriticalExtensions_146;      /* T_nonCriticalExtensions_146 */
static int hf_rrc_later_than_r3_17;               /* T_later_than_r3_17 */
static int hf_rrc_criticalExtensions_117;         /* T_criticalExtensions_115 */
static int hf_rrc_r4_10;                          /* T_r4_10 */
static int hf_rrc_rrcConnectionRelease_CCCH_r4;   /* RRCConnectionRelease_CCCH_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_10;   /* T_v4d0NonCriticalExtensions_10 */
static int hf_rrc_rrcConnectionRelease_CCCH_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_29;   /* T_v690NonCriticalExtensions_29 */
static int hf_rrc_v860NonCriticalExtensions_14;   /* T_v860NonCriticalExtensions_14 */
static int hf_rrc_va40NonCriticalExtensions_09;   /* T_va40NonCriticalExtensions_09 */
static int hf_rrc_nonCriticalExtensions_147;      /* T_nonCriticalExtensions_147 */
static int hf_rrc_criticalExtensions_118;         /* T_criticalExtensions_116 */
static int hf_rrc_groupIdentity;                  /* SEQUENCE_SIZE_1_maxURNTI_Group_OF_GroupReleaseInformation */
static int hf_rrc_groupIdentity_item;             /* GroupReleaseInformation */
static int hf_rrc_criticalExtensions_119;         /* T_criticalExtensions_117 */
static int hf_rrc_r5_08;                          /* T_r5_08 */
static int hf_rrc_rrcConnectionRelease_CCCH_r5;   /* RRCConnectionRelease_CCCH_r5_IEs */
static int hf_rrc_rrcConnectionRelease_CCCH_r5_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_30;   /* T_v690NonCriticalExtensions_30 */
static int hf_rrc_v860NonCriticalExtensions_15;   /* T_v860NonCriticalExtensions_15 */
static int hf_rrc_va40NonCriticalExtensions_10;   /* T_va40NonCriticalExtensions_10 */
static int hf_rrc_vd20NonCriticalExtensions_02;   /* T_vd20NonCriticalExtensions_02 */
static int hf_rrc_rrcConnectionRelease_vd20ext;   /* RRCConnectionRelease_CCCH_vd20ext_IEs */
static int hf_rrc_nonCriticalExtensions_148;      /* T_nonCriticalExtensions_148 */
static int hf_rrc_criticalExtensions_120;         /* T_criticalExtensions_118 */
static int hf_rrc_rrcConnectionRelease_02;        /* RRCConnectionRelease_r3_IEs */
static int hf_rrc_rrcConnectionRelease_03;        /* RRCConnectionRelease_r4_IEs */
static int hf_rrc_errorIndication;                /* FailureCauseWithProtErr */
static int hf_rrc_laterNonCriticalExtensions_42;  /* T_laterNonCriticalExtensions_40 */
static int hf_rrc_rrcConnectionReleaseComplete_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_149;      /* T_nonCriticalExtensions_149 */
static int hf_rrc_protocolErrorIndicator_01;      /* ProtocolErrorIndicator */
static int hf_rrc_v3d0NonCriticalExtensions;      /* T_v3d0NonCriticalExtensions */
static int hf_rrc_rRCConnectionRequest_v3d0ext;   /* RRCConnectionRequest_v3d0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_10;   /* T_v4b0NonCriticalExtensions_10 */
static int hf_rrc_rrcConnectionRequest_v4b0ext;   /* RRCConnectionRequest_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_20;   /* T_v590NonCriticalExtensions_20 */
static int hf_rrc_rrcConnectionRequest_v590ext;   /* RRCConnectionRequest_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_31;   /* T_v690NonCriticalExtensions_31 */
static int hf_rrc_rrcConnectionRequest_v690ext;   /* RRCConnectionRequest_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_10;   /* T_v6b0NonCriticalExtensions_09 */
static int hf_rrc_rrcConnectionRequest_v6b0ext;   /* RRCConnectionRequest_v6b0ext_IEs */
static int hf_rrc_v6e0NonCriticalExtensions_01;   /* T_v6e0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionRequest_v6e0ext;   /* RRCConnectionRequest_v6e0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_23;   /* T_v770NonCriticalExtensions_23 */
static int hf_rrc_rrcConnectionRequest_v770ext;   /* RRCConnectionRequest_v770ext_IEs */
static int hf_rrc_v7b0NonCriticalExtensions_01;   /* T_v7b0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionRequest_v7b0ext;   /* RRCConnectionRequest_v7b0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_16;   /* T_v860NonCriticalExtensions_16 */
static int hf_rrc_rrcConnectionRequest_v860ext;   /* RRCConnectionRequest_v860ext_IEs */
static int hf_rrc_v7e0NonCriticalExtensions_01;   /* T_v7e0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionRequest_v7e0ext;   /* RRCConnectionRequest_v7e0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_14;   /* T_v7g0NonCriticalExtensions_14 */
static int hf_rrc_rrcConnectionRequest_v7g0ext;   /* RRCConnectionRequest_v7g0ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_02;   /* T_v920NonCriticalExtensions_02 */
static int hf_rrc_rrcConnectionRequest_v920ext;   /* RRCConnectionRequest_v920ext_IEs */
static int hf_rrc_v940NonCriticalExtensions;      /* T_v940NonCriticalExtensions */
static int hf_rrc_rrcConnectionRequest_v940ext;   /* RRCConnectionRequest_v940ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_11;   /* RRCConnectionRequest_NonCriticalExts_va40_IEs */
static int hf_rrc_uESpecificBehaviourInformation1idle;  /* UESpecificBehaviourInformation1idle */
static int hf_rrc_predefinedConfigStatusInfo;     /* BOOLEAN */
static int hf_rrc_ueCapabilityIndication;         /* T_ueCapabilityIndication */
static int hf_rrc_domainIndicator;                /* T_domainIndicator */
static int hf_rrc_cs_domain;                      /* T_cs_domain */
static int hf_rrc_csCallType_03;                  /* T_csCallType_03 */
static int hf_rrc_ps_domain;                      /* NULL */
static int hf_rrc_supportForFDPCH_01;             /* T_supportForFDPCH_01 */
static int hf_rrc_hspdschReception_CellFach_02;   /* T_hspdschReception_CellFach_02 */
static int hf_rrc_mac_ehsSupport;                 /* T_mac_ehsSupport */
static int hf_rrc_discontinuousDpcchTransmission;  /* T_discontinuousDpcchTransmission */
static int hf_rrc_supportForE_FDPCH;              /* T_supportForE_FDPCH */
static int hf_rrc_supportForCSVoiceoverHSPA;      /* T_supportForCSVoiceoverHSPA */
static int hf_rrc_supportOfCommonEDCH_02;         /* T_supportOfCommonEDCH_02 */
static int hf_rrc_multiCellSupport;               /* T_multiCellSupport */
static int hf_rrc_pre_redirectionInfo;            /* Pre_RedirectionInfo */
static int hf_rrc_supportOfMACiis_02;             /* T_supportOfMACiis_02 */
static int hf_rrc_supportOfSPSOperation_01;       /* T_supportOfSPSOperation_01 */
static int hf_rrc_supportOfDualCellMIMO;          /* T_supportOfDualCellMIMO */
static int hf_rrc_systemInformationContainerStoredIndicator;  /* T_systemInformationContainerStoredIndicator */
static int hf_rrc_cSFBIndication;                 /* T_cSFBIndication */
static int hf_rrc_rrcConnectionRequest_va40ext;   /* RRCConnectionRequest_va40ext_IEs */
static int hf_rrc_v9b0NonCriticalExtensions;      /* T_v9b0NonCriticalExtensions */
static int hf_rrc_rrcConnectionRequest_v9b0ext;   /* RRCConnectionRequest_v9b0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_17;   /* T_vb50NonCriticalExtensions_17 */
static int hf_rrc_rrcConnectionRequest_vb50ext;   /* RRCConnectionRequest_vb50ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_05;   /* T_vc50NonCriticalExtensions_05 */
static int hf_rrc_rrcConnectionRequest_vc50ext;   /* RRCConnectionRequest_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_150;      /* T_nonCriticalExtensions_150 */
static int hf_rrc_supportOfMoreThanTwoCellsOrMIMO4x4;  /* T_supportOfMoreThanTwoCellsOrMIMO4x4 */
static int hf_rrc_supportOf1stFrequencyBand;      /* T_supportOf1stFrequencyBand */
static int hf_rrc_supportOf2ndFrequencyBand;      /* T_supportOf2ndFrequencyBand */
static int hf_rrc_r3_20;                          /* T_r3_20 */
static int hf_rrc_rrcConnectionSetup_r3;          /* RRCConnectionSetup_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_43;  /* T_laterNonCriticalExtensions_41 */
static int hf_rrc_rrcConnectionSetup_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_11;   /* T_v4b0NonCriticalExtensions_11 */
static int hf_rrc_rrcConnectionSetup_v4b0ext;     /* RRCConnectionSetup_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_21;   /* T_v590NonCriticalExtensions_21 */
static int hf_rrc_rrcConnectionSetup_v590ext;     /* RRCConnectionSetup_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_32;   /* T_v690NonCriticalExtensions_32 */
static int hf_rrc_rrcConnectionSetup_v690ext;     /* RRCConnectionSetup_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_151;      /* T_nonCriticalExtensions_151 */
static int hf_rrc_later_than_r3_18;               /* T_later_than_r3_18 */
static int hf_rrc_criticalExtensions_121;         /* T_criticalExtensions_119 */
static int hf_rrc_r4_11;                          /* T_r4_11 */
static int hf_rrc_rrcConnectionSetup_r4;          /* RRCConnectionSetup_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_11;   /* T_v4d0NonCriticalExtensions_11 */
static int hf_rrc_rrcConnectionSetup_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_22;   /* T_v590NonCriticalExtensions_22 */
static int hf_rrc_v690NonCriticalExtensions_33;   /* T_v690NonCriticalExtensions_33 */
static int hf_rrc_nonCriticalExtensions_152;      /* T_nonCriticalExtensions_152 */
static int hf_rrc_criticalExtensions_122;         /* T_criticalExtensions_120 */
static int hf_rrc_r5_09;                          /* T_r5_09 */
static int hf_rrc_rrcConnectionSetup_r5;          /* RRCConnectionSetup_r5_IEs */
static int hf_rrc_rrcConnectionSetup_r5_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_34;   /* T_v690NonCriticalExtensions_34 */
static int hf_rrc_nonCriticalExtensions_153;      /* T_nonCriticalExtensions_153 */
static int hf_rrc_criticalExtensions_123;         /* T_criticalExtensions_121 */
static int hf_rrc_r6_10;                          /* T_r6_10 */
static int hf_rrc_rrcConnectionSetup_r6;          /* RRCConnectionSetup_r6_IEs */
static int hf_rrc_rrcConnectionSetup_r6_add_ext;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_11;   /* T_v6b0NonCriticalExtensions_10 */
static int hf_rrc_rrcConnectionSetup_v6b0ext;     /* RRCConnectionSetup_v6b0ext_IEs */
static int hf_rrc_nonCriticalExtensions_154;      /* T_nonCriticalExtensions_154 */
static int hf_rrc_criticalExtensions_124;         /* T_criticalExtensions_122 */
static int hf_rrc_r7_09;                          /* T_r7_09 */
static int hf_rrc_rrcConnectionSetup_r7;          /* RRCConnectionSetup_r7_IEs */
static int hf_rrc_rrcConnectionSetup_r7_add_ext;  /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions_08;   /* T_v780NonCriticalExtensions_08 */
static int hf_rrc_rrcConnectionSetup_v780ext;     /* RRCConnectionSetup_v780ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_11;   /* T_v7d0NonCriticalExtensions_11 */
static int hf_rrc_rrcConnectionSetup_v7d0ext;     /* RRCConnectionSetup_v7d0ext_IEs */
static int hf_rrc_nonCriticalExtensions_155;      /* T_nonCriticalExtensions_155 */
static int hf_rrc_criticalExtensions_125;         /* T_criticalExtensions_123 */
static int hf_rrc_r8_10;                          /* T_r8_10 */
static int hf_rrc_rrcConnectionSetup_r8;          /* RRCConnectionSetup_r8_IEs */
static int hf_rrc_rrcConnectionSetup_r8_add_ext;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_12;   /* T_v7d0NonCriticalExtensions_12 */
static int hf_rrc_v890NonCriticalExtensions_08;   /* T_v890NonCriticalExtensions_08 */
static int hf_rrc_rrcConnectionSetup_v890ext;     /* RRCConnectionSetup_v890ext_IEs */
static int hf_rrc_v8a0NonCriticalExtensions_08;   /* T_v8a0NonCriticalExtensions_08 */
static int hf_rrc_rrcConnectionSetup_v8a0ext;     /* RRCConnectionSetup_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_156;      /* T_nonCriticalExtensions_156 */
static int hf_rrc_criticalExtensions_126;         /* T_criticalExtensions_124 */
static int hf_rrc_r9_09;                          /* T_r9_09 */
static int hf_rrc_rrcConnectionSetup_r9;          /* RRCConnectionSetup_r9_IEs */
static int hf_rrc_rrcConnectionSetup_r9_add_ext;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_07;   /* T_v950NonCriticalExtensions_07 */
static int hf_rrc_rrcConnectionSetup_v950ext;     /* RRCConnectionSetup_v950ext_IEs */
static int hf_rrc_nonCriticalExtensions_157;      /* T_nonCriticalExtensions_157 */
static int hf_rrc_criticalExtensions_127;         /* T_criticalExtensions_125 */
static int hf_rrc_r10_09;                         /* T_r10_09 */
static int hf_rrc_rrcConnectionSetup_r10;         /* RRCConnectionSetup_r10_IEs */
static int hf_rrc_rrcConnectionSetup_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_vaj0NonCriticalExtensions;      /* T_vaj0NonCriticalExtensions */
static int hf_rrc_rrcConnectionSetup_vaj0ext;     /* RRCConnectionSetup_vaj0ext_IEs */
static int hf_rrc_nonCriticalExtensions_158;      /* T_nonCriticalExtensions_158 */
static int hf_rrc_criticalExtensions_128;         /* T_criticalExtensions_126 */
static int hf_rrc_r11_10;                         /* T_r11_10 */
static int hf_rrc_rrcConnectionSetup_r11;         /* RRCConnectionSetup_r11_IEs */
static int hf_rrc_rrcConnectionSetup_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_vaj0NonCriticalExtensions_01;   /* T_vaj0NonCriticalExtensions_01 */
static int hf_rrc_nonCriticalExtensions_159;      /* T_nonCriticalExtensions_159 */
static int hf_rrc_criticalExtensions_129;         /* T_criticalExtensions_127 */
static int hf_rrc_r12_09;                         /* T_r12_09 */
static int hf_rrc_rrcConnectionSetup_r12;         /* RRCConnectionSetup_r12_IEs */
static int hf_rrc_rrcConnectionSetup_r12_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_160;      /* T_nonCriticalExtensions_160 */
static int hf_rrc_criticalExtensions_130;         /* T_criticalExtensions_128 */
static int hf_rrc_new_c_RNTI;                     /* C_RNTI */
static int hf_rrc_capabilityUpdateRequirement;    /* CapabilityUpdateRequirement */
static int hf_rrc_srb_InformationSetupList_06;    /* SRB_InformationSetupList2 */
static int hf_rrc_capabilityUpdateRequirement_r4_ext;  /* CapabilityUpdateRequirement_r4_ext */
static int hf_rrc_systemSpecificCapUpdateReq;     /* SystemSpecificCapUpdateReq_v590ext */
static int hf_rrc_capabilityUpdateRequirement_01;  /* CapabilityUpdateRequirement_r4 */
static int hf_rrc_capabilityUpdateRequirement_02;  /* CapabilityUpdateRequirement_r5 */
static int hf_rrc_specificationMode_25;           /* T_specificationMode_25 */
static int hf_rrc_complete_25;                    /* T_complete_25 */
static int hf_rrc_preconfiguration_21;            /* T_preconfiguration_21 */
static int hf_rrc_preConfigMode_21;               /* T_preConfigMode_21 */
static int hf_rrc_defaultConfig_21;               /* T_defaultConfig_21 */
static int hf_rrc_dl_InformationPerRL_List_10;    /* DL_InformationPerRL_List_r5bis */
static int hf_rrc_postVerificationPeriod_05;      /* T_postVerificationPeriod_05 */
static int hf_rrc_specificationMode_26;           /* T_specificationMode_26 */
static int hf_rrc_complete_26;                    /* T_complete_26 */
static int hf_rrc_srb_InformationSetupList_07;    /* SRB_InformationSetupList2_r6 */
static int hf_rrc_preconfiguration_22;            /* T_preconfiguration_22 */
static int hf_rrc_preConfigMode_22;               /* T_preConfigMode_22 */
static int hf_rrc_defaultConfig_22;               /* T_defaultConfig_22 */
static int hf_rrc_capabilityUpdateRequirement_03;  /* CapabilityUpdateRequirement_r7 */
static int hf_rrc_specificationMode_27;           /* T_specificationMode_27 */
static int hf_rrc_complete_27;                    /* T_complete_27 */
static int hf_rrc_srb_InformationSetupList_08;    /* SRB_InformationSetupList2_r7 */
static int hf_rrc_preconfiguration_23;            /* T_preconfiguration_23 */
static int hf_rrc_preConfigMode_23;               /* T_preConfigMode_23 */
static int hf_rrc_defaultConfig_23;               /* T_defaultConfig_23 */
static int hf_rrc_capabilityUpdateRequirement_04;  /* CapabilityUpdateRequirement_r8 */
static int hf_rrc_specificationMode_28;           /* T_specificationMode_28 */
static int hf_rrc_complete_28;                    /* T_complete_28 */
static int hf_rrc_srb_InformationSetupList_09;    /* SRB_InformationSetupList2_r8 */
static int hf_rrc_preconfiguration_24;            /* T_preconfiguration_24 */
static int hf_rrc_preConfigMode_24;               /* T_preConfigMode_24 */
static int hf_rrc_defaultConfig_24;               /* T_defaultConfig_24 */
static int hf_rrc_specificationMode_29;           /* T_specificationMode_29 */
static int hf_rrc_complete_29;                    /* T_complete_29 */
static int hf_rrc_preconfiguration_25;            /* T_preconfiguration_25 */
static int hf_rrc_preConfigMode_25;               /* T_preConfigMode_25 */
static int hf_rrc_defaultConfig_25;               /* T_defaultConfig_25 */
static int hf_rrc_specificationMode_30;           /* T_specificationMode_30 */
static int hf_rrc_complete_30;                    /* T_complete_30 */
static int hf_rrc_preconfiguration_26;            /* T_preconfiguration_26 */
static int hf_rrc_preConfigMode_26;               /* T_preConfigMode_26 */
static int hf_rrc_defaultConfig_26;               /* T_defaultConfig_26 */
static int hf_rrc_capabilityUpdateRequirement_05;  /* CapabilityUpdateRequirement_vaj0ext */
static int hf_rrc_specificationMode_31;           /* T_specificationMode_31 */
static int hf_rrc_complete_31;                    /* T_complete_31 */
static int hf_rrc_preconfiguration_27;            /* T_preconfiguration_27 */
static int hf_rrc_preConfigMode_27;               /* T_preConfigMode_27 */
static int hf_rrc_defaultConfig_27;               /* T_defaultConfig_27 */
static int hf_rrc_capabilityUpdateRequirement_06;  /* CapabilityUpdateRequirement_r12 */
static int hf_rrc_specificationMode_32;           /* T_specificationMode_32 */
static int hf_rrc_complete_32;                    /* T_complete_32 */
static int hf_rrc_preconfiguration_28;            /* T_preconfiguration_28 */
static int hf_rrc_preConfigMode_28;               /* T_preConfigMode_28 */
static int hf_rrc_defaultConfig_28;               /* T_defaultConfig_28 */
static int hf_rrc_ue_RadioAccessCapability_02;    /* UE_RadioAccessCapability */
static int hf_rrc_ue_RATSpecificCapability;       /* InterRAT_UE_RadioAccessCapabilityList */
static int hf_rrc_v370NonCriticalExtensions;      /* T_v370NonCriticalExtensions */
static int hf_rrc_rrcConnectionSetupComplete_v370ext;  /* RRCConnectionSetupComplete_v370ext */
static int hf_rrc_v380NonCriticalExtensions;      /* T_v380NonCriticalExtensions */
static int hf_rrc_rrcConnectionSetupComplete_v380ext;  /* RRCConnectionSetupComplete_v380ext_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_08;   /* T_v3a0NonCriticalExtensions_08 */
static int hf_rrc_rrcConnectionSetupComplete_v3a0ext;  /* RRCConnectionSetupComplete_v3a0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_44;  /* T_laterNonCriticalExtensions_42 */
static int hf_rrc_rrcConnectionSetupComplete_r3_add_ext;  /* T_rrcConnectionSetupComplete_r3_add_ext */
static int hf_rrc_v3g0NonCriticalExtensions_01;   /* T_v3g0NonCriticalExtensions_01 */
static int hf_rrc_rrcConnectionSetupComplete_v3g0ext;  /* RRCConnectionSetupComplete_v3g0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_12;   /* T_v4b0NonCriticalExtensions_12 */
static int hf_rrc_rrcConnectionSetupComplete_v4b0ext;  /* RRCConnectionSetupComplete_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_23;   /* T_v590NonCriticalExtensions_23 */
static int hf_rrc_rrcConnectionSetupComplete_v590ext;  /* RRCConnectionSetupComplete_v590ext_IEs */
static int hf_rrc_v5c0NonCriticalExtensions;      /* T_v5c0NonCriticalExtensions */
static int hf_rrc_rrcConnectionSetupComplete_v5c0ext;  /* RRCConnectionSetupComplete_v5c0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_35;   /* T_v690NonCriticalExtensions_35 */
static int hf_rrc_rrcConnectionSetupComplete_v690ext;  /* RRCConnectionSetupComplete_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_24;   /* T_v770NonCriticalExtensions_24 */
static int hf_rrc_rrcConectionSetupComplete_v770ext;  /* RRCConnectionSetupComplete_v770ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_12;   /* T_va40NonCriticalExtensions_11 */
static int hf_rrc_rrcConectionSetupComplete_va40ext;  /* RRCConnectionSetupComplete_va40ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_18;   /* T_vb50NonCriticalExtensions_18 */
static int hf_rrc_rrcConnectionSetupComplete_vb50ext;  /* RRCConnectionSetupComplete_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_161;      /* T_nonCriticalExtensions_161 */
static int hf_rrc_ue_RadioAccessCapability_v370ext;  /* UE_RadioAccessCapability_v370ext */
static int hf_rrc_rrcConnectionSetupComplete_v650ext;  /* RRCConnectionSetupComplete_v650ext_IEs */
static int hf_rrc_v680NonCriticalExtensions;      /* T_v680NonCriticalExtensions */
static int hf_rrc_rrcConnectionSetupComplete_v680ext;  /* RRCConnectionSetupComplete_v680ext_IEs */
static int hf_rrc_v7e0NonCriticalExtensions_02;   /* T_v7e0NonCriticalExtensions_02 */
static int hf_rrc_rrcConnectionSetupComplete_v7e0ext;  /* RRCConnectionSetupComplete_v7e0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_13;   /* T_v7f0NonCriticalExtensions_13 */
static int hf_rrc_rrcConnectionSetupComplete_v7f0ext;  /* RRCConnectionSetupComplete_v7f0ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_13;   /* T_va40NonCriticalExtensions_12 */
static int hf_rrc_rrcConnectionSetupCompleteBand_va40ext;  /* RRCConnectionSetupCompleteBand_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_162;      /* T_nonCriticalExtensions_162 */
static int hf_rrc_ue_RadioAccessCapability_v4b0ext;  /* UE_RadioAccessCapability_v4b0ext */
static int hf_rrc_ue_RadioAccessCapability_v590ext;  /* UE_RadioAccessCapability_v590ext */
static int hf_rrc_ue_RATSpecificCapability_v590ext;  /* InterRAT_UE_RadioAccessCapability_v590ext */
static int hf_rrc_ue_RadioAccessCapability_v5c0ext;  /* UE_RadioAccessCapability_v5c0ext */
static int hf_rrc_ue_RadioAccessCapability_v680ext;  /* UE_RadioAccessCapability_v680ext */
static int hf_rrc_ueCapabilityContainer;          /* T_ueCapabilityContainer */
static int hf_rrc_deferredMeasurementControlReading_04;  /* T_deferredMeasurementControlReading_04 */
static int hf_rrc_loggedMeasAvailable_04;         /* T_loggedMeasAvailable_04 */
static int hf_rrc_loggedANRResultsAvailable_03;   /* T_loggedANRResultsAvailable_03 */
static int hf_rrc_connEstFailInfoAvailable_01;    /* T_connEstFailInfoAvailable_01 */
static int hf_rrc_r3_21;                          /* T_r3_21 */
static int hf_rrc_rRC_FailureInfo_r3;             /* RRC_FailureInfo_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_45;  /* T_laterNonCriticalExtensions_43 */
static int hf_rrc_rrc_FailureInfo_r3_add_ext;     /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_163;      /* T_nonCriticalExtensions_163 */
static int hf_rrc_criticalExtensions_131;         /* T_criticalExtensions_129 */
static int hf_rrc_failureCauseWithProtErr;        /* FailureCauseWithProtErr */
static int hf_rrc_protocolErrorInformation;       /* ProtocolErrorMoreInformation */
static int hf_rrc_laterNonCriticalExtensions_46;  /* T_laterNonCriticalExtensions_44 */
static int hf_rrc_rrcStatus_r3_add_ext;           /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_164;      /* T_nonCriticalExtensions_164 */
static int hf_rrc_r3_22;                          /* T_r3_22 */
static int hf_rrc_securityModeCommand_r3;         /* SecurityModeCommand_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_47;  /* T_laterNonCriticalExtensions_45 */
static int hf_rrc_securityModeCommand_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_165;      /* T_nonCriticalExtensions_165 */
static int hf_rrc_later_than_r3_19;               /* T_later_than_r3_19 */
static int hf_rrc_criticalExtensions_132;         /* T_criticalExtensions_130 */
static int hf_rrc_r7_10;                          /* T_r7_10 */
static int hf_rrc_securityModeCommand_r7;         /* SecurityModeCommand_r7_IEs */
static int hf_rrc_securityModeCommand_r7_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_166;      /* T_nonCriticalExtensions_166 */
static int hf_rrc_criticalExtensions_133;         /* T_criticalExtensions_131 */
static int hf_rrc_securityCapability;             /* SecurityCapability */
static int hf_rrc_ue_SystemSpecificSecurityCap;   /* InterRAT_UE_SecurityCapList */
static int hf_rrc_rb_UL_CiphActivationTimeInfo;   /* RB_ActivationTimeInfoList */
static int hf_rrc_laterNonCriticalExtensions_48;  /* T_laterNonCriticalExtensions_46 */
static int hf_rrc_securityModeComplete_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_167;      /* T_nonCriticalExtensions_167 */
static int hf_rrc_laterNonCriticalExtensions_49;  /* T_laterNonCriticalExtensions_47 */
static int hf_rrc_securityModeFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_168;      /* T_nonCriticalExtensions_168 */
static int hf_rrc_r3_23;                          /* T_r3_23 */
static int hf_rrc_signallingConnectionRelease_r3;  /* SignallingConnectionRelease_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_50;  /* T_laterNonCriticalExtensions_48 */
static int hf_rrc_signallingConnectionRelease_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_va40NonCriticalExtensions_14;   /* T_va40NonCriticalExtensions_13 */
static int hf_rrc_signallingConnectionRelease_va40ext;  /* SignallingConnectionRelease_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_169;      /* T_nonCriticalExtensions_169 */
static int hf_rrc_later_than_r3_20;               /* T_later_than_r3_20 */
static int hf_rrc_criticalExtensions_134;         /* T_criticalExtensions_132 */
static int hf_rrc_laterNonCriticalExtensions_51;  /* T_laterNonCriticalExtensions_49 */
static int hf_rrc_signallingConnectionReleaseIndication_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v860nonCriticalExtentions;      /* T_v860nonCriticalExtentions */
static int hf_rrc_signallingConnectionReleaseIndication_v860ext;  /* SignallingConnectionReleaseIndication_v860ext */
static int hf_rrc_nonCriticalExtensions_170;      /* T_nonCriticalExtensions_170 */
static int hf_rrc_signallingConnectionReleaseIndicationCause;  /* T_signallingConnectionReleaseIndicationCause */
static int hf_rrc_sfn_Prime;                      /* SFN_Prime */
static int hf_rrc_payload;                        /* T_payload */
static int hf_rrc_noSegment;                      /* NULL */
static int hf_rrc_firstSegment;                   /* FirstSegment */
static int hf_rrc_subsequentSegment;              /* SubsequentSegment */
static int hf_rrc_lastSegmentShort;               /* LastSegmentShort */
static int hf_rrc_lastAndFirst;                   /* T_lastAndFirst */
static int hf_rrc_firstSegment_01;                /* FirstSegmentShort */
static int hf_rrc_lastAndComplete;                /* T_lastAndComplete */
static int hf_rrc_completeSIB_List;               /* CompleteSIB_List */
static int hf_rrc_lastAndCompleteAndFirst;        /* T_lastAndCompleteAndFirst */
static int hf_rrc_completeAndFirst;               /* T_completeAndFirst */
static int hf_rrc_completeSIB;                    /* CompleteSIB */
static int hf_rrc_lastSegment;                    /* LastSegment */
static int hf_rrc_segmentCombination;             /* T_segmentCombination */
static int hf_rrc_combination2;                   /* FirstSegment2 */
static int hf_rrc_combination3;                   /* SubsequentSegment2 */
static int hf_rrc_combination4;                   /* LastSegmentShort2 */
static int hf_rrc_combination5;                   /* T_combination5 */
static int hf_rrc_lastSegmentShort_01;            /* LastSegmentShort2 */
static int hf_rrc_firstSegmentShort;              /* FirstSegmentShort2 */
static int hf_rrc_combination6;                   /* T_combination6 */
static int hf_rrc_completeSIB_List_01;            /* CompleteSIB2_List */
static int hf_rrc_combination7;                   /* T_combination7 */
static int hf_rrc_firstSegment_02;                /* FirstSegmentShort2 */
static int hf_rrc_combination8;                   /* CompleteSIB2_List */
static int hf_rrc_combination9;                   /* T_combination9 */
static int hf_rrc_combination10;                  /* CompleteSIB2 */
static int hf_rrc_combination11;                  /* LastSegment2 */
static int hf_rrc_payload_01;                     /* T_payload_01 */
static int hf_rrc_lastAndFirst_01;                /* T_lastAndFirst_01 */
static int hf_rrc_lastAndComplete_01;             /* T_lastAndComplete_01 */
static int hf_rrc_lastAndCompleteAndFirst_01;     /* T_lastAndCompleteAndFirst_01 */
static int hf_rrc_completeAndFirst_01;            /* T_completeAndFirst_01 */
static int hf_rrc_sib_Type;                       /* SIB_Type */
static int hf_rrc_seg_Count;                      /* SegCount */
static int hf_rrc_sib_Data_fixed;                 /* SIB_Data_fixed */
static int hf_rrc_sib_Type_01;                    /* SIB_Type2 */
static int hf_rrc_sib_Data_fixed_01;              /* SIB_Data2_fixed */
static int hf_rrc_sib_Data_variable;              /* SIB_Data_variable */
static int hf_rrc_sib_Data_variable_01;           /* SIB_Data2_variable */
static int hf_rrc_segmentIndex;                   /* SegmentIndex */
static int hf_rrc_CompleteSIB_List_item;          /* CompleteSIBshort */
static int hf_rrc_CompleteSIB2_List_item;         /* CompleteSIBshort2 */
static int hf_rrc_sib_Data_fixed_02;              /* BIT_STRING_SIZE_226 */
static int hf_rrc_sib_Data_fixed_03;              /* BIT_STRING_SIZE_236 */
static int hf_rrc_laterNonCriticalExtensions_52;  /* T_laterNonCriticalExtensions_50 */
static int hf_rrc_systemInformationChangeIndication_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v860NonCriticalExtensions_17;   /* T_v860NonCriticalExtensions_17 */
static int hf_rrc_systemInformationChangeIndication_v860ext;  /* SystemInformationChangeIndication_v860ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_06;   /* T_vc50NonCriticalExtensions_06 */
static int hf_rrc_systemInformationChangeIndication_vc50ext;  /* SystemInformationChangeIndication_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_171;      /* T_nonCriticalExtensions_171 */
static int hf_rrc_r3_24;                          /* T_r3_24 */
static int hf_rrc_transportChannelReconfiguration_r3;  /* TransportChannelReconfiguration_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_09;   /* T_v3a0NonCriticalExtensions_09 */
static int hf_rrc_transportChannelReconfiguration_v3a0ext;  /* TransportChannelReconfiguration_v3a0ext */
static int hf_rrc_laterNonCriticalExtensions_53;  /* T_laterNonCriticalExtensions_51 */
static int hf_rrc_transportChannelReconfiguration_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_13;   /* T_v4b0NonCriticalExtensions_13 */
static int hf_rrc_transportChannelReconfiguration_v4b0ext;  /* TransportChannelReconfiguration_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_24;   /* T_v590NonCriticalExtensions_24 */
static int hf_rrc_transportChannelReconfiguration_v590ext;  /* TransportChannelReconfiguration_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_36;   /* T_v690NonCriticalExtensions_36 */
static int hf_rrc_transportChannelReconfiguration_v690ext;  /* TransportChannelReconfiguration_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_25;   /* T_v770NonCriticalExtensions_25 */
static int hf_rrc_transportChannelReconfiguration_v770ext;  /* TransportChannelReconfiguration_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_172;      /* T_nonCriticalExtensions_172 */
static int hf_rrc_later_than_r3_21;               /* T_later_than_r3_21 */
static int hf_rrc_criticalExtensions_135;         /* T_criticalExtensions_133 */
static int hf_rrc_r4_12;                          /* T_r4_12 */
static int hf_rrc_transportChannelReconfiguration_r4;  /* TransportChannelReconfiguration_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_12;   /* T_v4d0NonCriticalExtensions_12 */
static int hf_rrc_transportChannelReconfiguration_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_25;   /* T_v590NonCriticalExtensions_25 */
static int hf_rrc_v690NonCriticalExtensions_37;   /* T_v690NonCriticalExtensions_37 */
static int hf_rrc_v770NonCriticalExtensions_26;   /* T_v770NonCriticalExtensions_26 */
static int hf_rrc_nonCriticalExtensions_173;      /* T_nonCriticalExtensions_173 */
static int hf_rrc_criticalExtensions_136;         /* T_criticalExtensions_134 */
static int hf_rrc_r5_10;                          /* T_r5_10 */
static int hf_rrc_transportChannelReconfiguration_r5;  /* TransportChannelReconfiguration_r5_IEs */
static int hf_rrc_transportChannelReconfiguration_r5_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_38;   /* T_v690NonCriticalExtensions_38 */
static int hf_rrc_v770NonCriticalExtensions_27;   /* T_v770NonCriticalExtensions_27 */
static int hf_rrc_nonCriticalExtensions_174;      /* T_nonCriticalExtensions_174 */
static int hf_rrc_criticalExtensions_137;         /* T_criticalExtensions_135 */
static int hf_rrc_r6_11;                          /* T_r6_11 */
static int hf_rrc_transportChannelReconfiguration_r6;  /* TransportChannelReconfiguration_r6_IEs */
static int hf_rrc_transportChannelReconfiguration_r6_add_ext;  /* BIT_STRING */
static int hf_rrc_v6b0NonCriticalExtensions_12;   /* T_v6b0NonCriticalExtensions_11 */
static int hf_rrc_transportChannelReconfiguration_v6b0ext;  /* TransportChannelReconfiguration_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_28;   /* T_v770NonCriticalExtensions_28 */
static int hf_rrc_nonCriticalExtensions_175;      /* T_nonCriticalExtensions_175 */
static int hf_rrc_criticalExtensions_138;         /* T_criticalExtensions_136 */
static int hf_rrc_r7_11;                          /* T_r7_11 */
static int hf_rrc_transportChannelReconfiguration_r7;  /* TransportChannelReconfiguration_r7_IEs */
static int hf_rrc_transportChannelReconfiguration_r7_add_ext;  /* BIT_STRING */
static int hf_rrc_v780NonCriticalExtensions_09;   /* T_v780NonCriticalExtensions_09 */
static int hf_rrc_transportChannelReconfiguration_v780ext;  /* TransportChannelReconfiguration_v780ext_IEs */
static int hf_rrc_v7d0NonCriticalExtensions_13;   /* T_v7d0NonCriticalExtensions_13 */
static int hf_rrc_transportChannelReconfiguration_v7d0ext;  /* TransportChannelReconfiguration_v7d0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_14;   /* T_v7f0NonCriticalExtensions_14 */
static int hf_rrc_transportChannelReconfiguration_v7f0ext;  /* TransportChannelReconfiguration_v7f0ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_15;   /* T_v7g0NonCriticalExtensions_15 */
static int hf_rrc_transportChannelReconfiguration_v7g0ext;  /* TransportChannelReconfiguration_v7g0ext_IEs */
static int hf_rrc_nonCriticalExtensions_176;      /* T_nonCriticalExtensions_176 */
static int hf_rrc_criticalExtensions_139;         /* T_criticalExtensions_137 */
static int hf_rrc_r8_11;                          /* T_r8_11 */
static int hf_rrc_transportChannelReconfiguration_r8;  /* TransportChannelReconfiguration_r8_IEs */
static int hf_rrc_transportChannelReconfiguration_r8_add_ext;  /* BIT_STRING */
static int hf_rrc_v7d0NonCriticalExtensions_14;   /* T_v7d0NonCriticalExtensions_14 */
static int hf_rrc_v7f0NonCriticalExtensions_15;   /* T_v7f0NonCriticalExtensions_15 */
static int hf_rrc_v890NonCriticalExtensions_09;   /* T_v890NonCriticalExtensions_09 */
static int hf_rrc_transportChannelReconfiguration_v890ext;  /* TransportChannelReconfiguration_v890ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_16;   /* T_v7g0NonCriticalExtensions_16 */
static int hf_rrc_v8a0NonCriticalExtensions_09;   /* T_v8a0NonCriticalExtensions_09 */
static int hf_rrc_transportChannelReconfiguration_v8a0ext;  /* TransportChannelReconfiguration_v8a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_177;      /* T_nonCriticalExtensions_177 */
static int hf_rrc_criticalExtensions_140;         /* T_criticalExtensions_138 */
static int hf_rrc_r9_10;                          /* T_r9_10 */
static int hf_rrc_transportChannelReconfiguration_r9;  /* TransportChannelReconfiguration_r9_IEs */
static int hf_rrc_transportChannelReconfiguration_r9_add_ext;  /* BIT_STRING */
static int hf_rrc_v950NonCriticalExtensions_08;   /* T_v950NonCriticalExtensions_08 */
static int hf_rrc_transportChannelReconfiguration_v950ext;  /* TransportChannelReconfiguration_v950ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_10;   /* T_v9c0NonCriticalExtensions_10 */
static int hf_rrc_transportChannelReconfiguration_v9c0ext;  /* TransportChannelReconfiguration_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_178;      /* T_nonCriticalExtensions_178 */
static int hf_rrc_criticalExtensions_141;         /* T_criticalExtensions_139 */
static int hf_rrc_r10_10;                         /* T_r10_10 */
static int hf_rrc_transportChannelReconfiguration_r10;  /* TransportChannelReconfiguration_r10_IEs */
static int hf_rrc_transportChannelReconfiguration_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_11;   /* T_v9c0NonCriticalExtensions_11 */
static int hf_rrc_vb50NonCriticalExtensions_19;   /* T_vb50NonCriticalExtensions_19 */
static int hf_rrc_transportChannelReconfiguration_vb50ext;  /* TransportChannelReconfiguration_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_179;      /* T_nonCriticalExtensions_179 */
static int hf_rrc_criticalExtensions_142;         /* T_criticalExtensions_140 */
static int hf_rrc_r11_11;                         /* T_r11_11 */
static int hf_rrc_transportChannelReconfiguration_r11;  /* TransportChannelReconfiguration_r11_IEs */
static int hf_rrc_transportChannelReconfiguration_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_180;      /* T_nonCriticalExtensions_180 */
static int hf_rrc_criticalExtensions_143;         /* T_criticalExtensions_141 */
static int hf_rrc_r12_10;                         /* T_r12_10 */
static int hf_rrc_transportChannelReconfiguration_r12;  /* TransportChannelReconfiguration_r12_IEs */
static int hf_rrc_transportChannelReconfiguration_r12_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_181;      /* T_nonCriticalExtensions_181 */
static int hf_rrc_criticalExtensions_144;         /* T_criticalExtensions_142 */
static int hf_rrc_r13_08;                         /* T_r13_08 */
static int hf_rrc_transportChannelReconfiguration_r13;  /* TransportChannelReconfiguration_r13_IEs */
static int hf_rrc_transportChannelReconfiguration_r13_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_182;      /* T_nonCriticalExtensions_182 */
static int hf_rrc_criticalExtensions_145;         /* T_criticalExtensions_143 */
static int hf_rrc_dummy_14;                       /* T_dummy_11 */
static int hf_rrc_fdd_40;                         /* T_fdd_40 */
static int hf_rrc_modeSpecificPhysChInfo_12;      /* T_modeSpecificPhysChInfo_12 */
static int hf_rrc_fdd_41;                         /* T_fdd_41 */
static int hf_rrc_dummy_15;                       /* T_dummy_12 */
static int hf_rrc_fdd_42;                         /* T_fdd_42 */
static int hf_rrc_modeSpecificPhysChInfo_13;      /* T_modeSpecificPhysChInfo_13 */
static int hf_rrc_fdd_43;                         /* T_fdd_43 */
static int hf_rrc_dummy_16;                       /* T_dummy_13 */
static int hf_rrc_fdd_44;                         /* T_fdd_44 */
static int hf_rrc_modeSpecificPhysChInfo_14;      /* T_modeSpecificPhysChInfo_14 */
static int hf_rrc_fdd_45;                         /* T_fdd_45 */
static int hf_rrc_postVerificationPeriod_06;      /* T_postVerificationPeriod_06 */
static int hf_rrc_responseToChangeOfUE_Capability_16;  /* T_responseToChangeOfUE_Capability_16 */
static int hf_rrc_responseToChangeOfUE_Capability_17;  /* T_responseToChangeOfUE_Capability_17 */
static int hf_rrc_responseToChangeOfUE_Capability_18;  /* T_responseToChangeOfUE_Capability_18 */
static int hf_rrc_responseToChangeOfUE_Capability_19;  /* T_responseToChangeOfUE_Capability_19 */
static int hf_rrc_responseToChangeOfUE_Capability_20;  /* T_responseToChangeOfUE_Capability_20 */
static int hf_rrc_responseToChangeOfUE_Capability_21;  /* T_responseToChangeOfUE_Capability_21 */
static int hf_rrc_responseToChangeOfUE_Capability_22;  /* T_responseToChangeOfUE_Capability_22 */
static int hf_rrc_laterNonCriticalExtensions_54;  /* T_laterNonCriticalExtensions_52 */
static int hf_rrc_transportChannelReconfigurationComplete_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_29;   /* T_v770NonCriticalExtensions_29 */
static int hf_rrc_transportChannelReconfigurationComplete_v770ext;  /* TransportChannelReconfigurationComplete_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_183;      /* T_nonCriticalExtensions_183 */
static int hf_rrc_deferredMeasurementControlReading_05;  /* T_deferredMeasurementControlReading_05 */
static int hf_rrc_laterNonCriticalExtensions_55;  /* T_laterNonCriticalExtensions_53 */
static int hf_rrc_transportChannelReconfigurationFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_184;      /* T_nonCriticalExtensions_184 */
static int hf_rrc_modeSpecificInfo_16;            /* T_modeSpecificInfo_16 */
static int hf_rrc_fdd_46;                         /* NULL */
static int hf_rrc_tdd_11;                         /* T_tdd_10 */
static int hf_rrc_tfcs_ID;                        /* TFCS_Identity */
static int hf_rrc_dpch_TFCS_InUplink;             /* TFC_Subset */
static int hf_rrc_activationTimeForTFCSubset;     /* ActivationTime */
static int hf_rrc_tfc_ControlDuration;            /* TFC_ControlDuration */
static int hf_rrc_laterNonCriticalExtensions_56;  /* T_laterNonCriticalExtensions_54 */
static int hf_rrc_transportFormatCombinationControl_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v820NonCriticalExtensions_02;   /* T_v820NonCriticalExtensions_02 */
static int hf_rrc_transportformatcombinationcontrol_v820ext;  /* TransportFormatCombinationControl_v820ext_IEs */
static int hf_rrc_nonCriticalExtensions_185;      /* T_nonCriticalExtensions_185 */
static int hf_rrc_ul_AMR_Rate;                    /* UL_AMR_Rate */
static int hf_rrc_laterNonCriticalExtensions_57;  /* T_laterNonCriticalExtensions_55 */
static int hf_rrc_transportFormatCombinationControlFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_186;      /* T_nonCriticalExtensions_186 */
static int hf_rrc_r3_25;                          /* T_r3_25 */
static int hf_rrc_ueCapabilityEnquiry_r3;         /* UECapabilityEnquiry_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_58;  /* T_laterNonCriticalExtensions_56 */
static int hf_rrc_ueCapabilityEnquiry_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_14;   /* T_v4b0NonCriticalExtensions_14 */
static int hf_rrc_ueCapabilityEnquiry_v4b0ext;    /* UECapabilityEnquiry_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_26;   /* T_v590NonCriticalExtensions_26 */
static int hf_rrc_ueCapabilityEnquiry_v590ext;    /* UECapabilityEnquiry_v590ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_30;   /* T_v770NonCriticalExtensions_30 */
static int hf_rrc_ueCapabilityEnquiry_v770ext;    /* UECapabilityEnquiry_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_18;   /* T_v860NonCriticalExtensions_18 */
static int hf_rrc_ueCapabilityEnquiry_v860ext;    /* UECapabilityEnquiry_v860ext_IEs */
static int hf_rrc_vaj0NonCriticalExtensions_02;   /* T_vaj0NonCriticalExtensions_02 */
static int hf_rrc_ueCapabilityEnquiry_vaj0ext;    /* UECapabilityEnquiry_vaj0ext_IEs */
static int hf_rrc_nonCriticalExtensions_187;      /* T_nonCriticalExtensions_187 */
static int hf_rrc_later_than_r3_22;               /* T_later_than_r3_22 */
static int hf_rrc_criticalExtensions_146;         /* T_criticalExtensions_144 */
static int hf_rrc_capabilityUpdateRequirement_07;  /* CapabilityUpdateRequirement_v770ext */
static int hf_rrc_capabilityUpdateRequirement_08;  /* CapabilityUpdateRequirement_v860ext */
static int hf_rrc_v370NonCriticalExtensions_01;   /* T_v370NonCriticalExtensions_01 */
static int hf_rrc_ueCapabilityInformation_v370ext;  /* UECapabilityInformation_v370ext */
static int hf_rrc_v380NonCriticalExtensions_01;   /* T_v380NonCriticalExtensions_01 */
static int hf_rrc_ueCapabilityInformation_v380ext;  /* UECapabilityInformation_v380ext_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_10;   /* T_v3a0NonCriticalExtensions_10 */
static int hf_rrc_ueCapabilityInformation_v3a0ext;  /* UECapabilityInformation_v3a0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_59;  /* T_laterNonCriticalExtensions_57 */
static int hf_rrc_ueCapabilityInformation_r3_add_ext;  /* T_ueCapabilityInformation_r3_add_ext */
static int hf_rrc_v4b0NonCriticalExtensions_15;   /* T_v4b0NonCriticalExtensions_15 */
static int hf_rrc_ueCapabilityInformation_v4b0ext;  /* UECapabilityInformation_v4b0ext */
static int hf_rrc_v590NonCriticalExtensions_27;   /* T_v590NonCriticalExtensions_27 */
static int hf_rrc_ueCapabilityInformation_v590ext;  /* UECapabilityInformation_v590ext */
static int hf_rrc_v5c0NonCriticalExtensions_01;   /* T_v5c0NonCriticalExtensions_01 */
static int hf_rrc_ueCapabilityInformation_v5c0ext;  /* UECapabilityInformation_v5c0ext */
static int hf_rrc_v690NonCriticalExtensions_39;   /* T_v690NonCriticalExtensions_39 */
static int hf_rrc_ueCapabilityInformation_v690ext;  /* UECapabilityInformation_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_188;      /* T_nonCriticalExtensions_188 */
static int hf_rrc_ueCapabilityInformation_v650ext;  /* UECapabilityInformation_v650ext_IEs */
static int hf_rrc_v680NonCriticalExtensions_01;   /* T_v680NonCriticalExtensions_01 */
static int hf_rrc_ueCapabilityInformation_v680ext;  /* UECapabilityInformation_v680ext_IEs */
static int hf_rrc_v7e0NonCriticalExtensions_03;   /* T_v7e0NonCriticalExtensions_03 */
static int hf_rrc_ueCapabilityInformation_v7e0ext;  /* UECapabilityInformation_v7e0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_16;   /* T_v7f0NonCriticalExtensions_16 */
static int hf_rrc_ueCapabilityInformation_v7f0ext;  /* UECapabilityInformation_v7f0ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_15;   /* T_va40NonCriticalExtensions_14 */
static int hf_rrc_ueCapabilityInformation_va40ext;  /* UECapabilityInformation_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_189;      /* T_nonCriticalExtensions_189 */
static int hf_rrc_ueCapabilityContainer_01;       /* T_ueCapabilityContainer_01 */
static int hf_rrc_r3_26;                          /* T_r3_26 */
static int hf_rrc_ueCapabilityInformationConfirm_r3;  /* UECapabilityInformationConfirm_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_60;  /* T_laterNonCriticalExtensions_58 */
static int hf_rrc_ueCapabilityInformationConfirm_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtensions_31;   /* T_v770NonCriticalExtensions_31 */
static int hf_rrc_ueCapabilityInformationConfirm_v770ext;  /* UECapabilityInformationConfirm_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_190;      /* T_nonCriticalExtensions_190 */
static int hf_rrc_later_than_r3_23;               /* T_later_than_r3_23 */
static int hf_rrc_criticalExtensions_147;         /* T_criticalExtensions_145 */
static int hf_rrc_acceptanceOfChangeOfCapability;  /* T_acceptanceOfChangeOfCapability */
static int hf_rrc_laterNonCriticalExtensions_61;  /* T_laterNonCriticalExtensions_59 */
static int hf_rrc_uplinkDirectTransfer_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_40;   /* T_v690NonCriticalExtensions_40 */
static int hf_rrc_uplinkDirectTransfer_v690ext;   /* UplinkDirectTransfer_v690ext_IEs */
static int hf_rrc_v7g0NonCriticalExtensions_17;   /* T_v7g0NonCriticalExtensions_17 */
static int hf_rrc_uplinkDirectTransfer_v7g0ext;   /* UplinkDirectTransfer_v7g0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_20;   /* T_vb50NonCriticalExtensions_20 */
static int hf_rrc_uplinkDirectTransfer_vb50ext;   /* UplinkDirectTransfer_vb50ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_07;   /* T_vc50NonCriticalExtensions_07 */
static int hf_rrc_uplinkDirectTransfer_vc50ext;   /* UplinkDirectTransfer_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_191;      /* T_nonCriticalExtensions_191 */
static int hf_rrc_r3_27;                          /* T_r3_27 */
static int hf_rrc_uplinkPhysicalChannelControl_r3;  /* UplinkPhysicalChannelControl_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_62;  /* T_laterNonCriticalExtensions_60 */
static int hf_rrc_uplinkPhysicalChannelControl_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v4b0NonCriticalExtensions_16;   /* T_v4b0NonCriticalExtensions_16 */
static int hf_rrc_uplinkPysicalChannelControl_v4b0ext;  /* UplinkPhysicalChannelControl_v4b0ext_IEs */
static int hf_rrc_noncriticalExtensions;          /* T_noncriticalExtensions */
static int hf_rrc_later_than_r3_24;               /* T_later_than_r3_24 */
static int hf_rrc_criticalExtensions_148;         /* T_criticalExtensions_146 */
static int hf_rrc_r4_13;                          /* T_r4_13 */
static int hf_rrc_uplinkPhysicalChannelControl_r4;  /* UplinkPhysicalChannelControl_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_13;   /* T_v4d0NonCriticalExtensions_13 */
static int hf_rrc_uplinkPhysicalChannelControl_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_41;   /* T_v690NonCriticalExtensions_41 */
static int hf_rrc_uplinkPhysicalChannelControl_v690ext;  /* UplinkPhysicalChannelControl_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_192;      /* T_nonCriticalExtensions_192 */
static int hf_rrc_criticalExtensions_149;         /* T_criticalExtensions_147 */
static int hf_rrc_r5_11;                          /* T_r5_11 */
static int hf_rrc_uplinkPhysicalChannelControl_r5;  /* UplinkPhysicalChannelControl_r5_IEs */
static int hf_rrc_uplinkPhysicalChannelControl_r5_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_42;   /* T_v690NonCriticalExtensions_42 */
static int hf_rrc_v6a0NonCriticalExtensions_01;   /* T_v6a0NonCriticalExtensions_01 */
static int hf_rrc_uplinkPhysicalChannelControl_v6a0ext;  /* UplinkPhysicalChannelControl_v6a0ext_IEs */
static int hf_rrc_nonCriticalExtensions_193;      /* T_nonCriticalExtensions_193 */
static int hf_rrc_criticalExtensions_150;         /* T_criticalExtensions_148 */
static int hf_rrc_r7_12;                          /* T_r7_12 */
static int hf_rrc_uplinkPhysicalChannelControl_r7;  /* UplinkPhysicalChannelControl_r7_IEs */
static int hf_rrc_uplinkPhysicalChannelControl_r7_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_194;      /* T_nonCriticalExtensions_194 */
static int hf_rrc_criticalExtensions_151;         /* T_criticalExtensions_149 */
static int hf_rrc_ccTrCH_PowerControlInfo;        /* CCTrCH_PowerControlInfo */
static int hf_rrc_timingAdvance;                  /* UL_TimingAdvanceControl */
static int hf_rrc_alpha;                          /* Alpha */
static int hf_rrc_specialBurstScheduling;         /* SpecialBurstScheduling */
static int hf_rrc_prach_ConstantValue;            /* ConstantValueTdd */
static int hf_rrc_pusch_ConstantValue;            /* ConstantValueTdd */
static int hf_rrc_openLoopPowerControl_IPDL_TDD;  /* OpenLoopPowerControl_IPDL_TDD_r4 */
static int hf_rrc_ccTrCH_PowerControlInfo_01;     /* CCTrCH_PowerControlInfo_r4 */
static int hf_rrc_tddOption;                      /* T_tddOption */
static int hf_rrc_tdd384_09;                      /* T_tdd384_09 */
static int hf_rrc_timingAdvance_01;               /* UL_TimingAdvanceControl_r4 */
static int hf_rrc_tdd128_09;                      /* T_tdd128_09 */
static int hf_rrc_ul_SynchronisationParameters;   /* UL_SynchronisationParameters_r4 */
static int hf_rrc_ccTrCH_PowerControlInfo_02;     /* CCTrCH_PowerControlInfo_r5 */
static int hf_rrc_tddOption_01;                   /* T_tddOption_01 */
static int hf_rrc_tdd384_10;                      /* T_tdd384_10 */
static int hf_rrc_hs_SICH_PowerControl;           /* HS_SICH_Power_Control_Info_TDD384 */
static int hf_rrc_tdd128_10;                      /* T_tdd128_10 */
static int hf_rrc_desired_HS_SICH_PowerLevel;     /* INTEGER_M120_M58 */
static int hf_rrc_tpc_Step_Size;                  /* T_tpc_Step_Size */
static int hf_rrc_ccTrCH_PowerControlInfo_03;     /* CCTrCH_PowerControlInfo_r7 */
static int hf_rrc_tddOption_02;                   /* T_tddOption_02 */
static int hf_rrc_tdd384_11;                      /* T_tdd384_11 */
static int hf_rrc_tdd768_06;                      /* T_tdd768_06 */
static int hf_rrc_timingAdvance_02;               /* UL_TimingAdvanceControl_r7 */
static int hf_rrc_hs_SICH_PowerControl_01;        /* HS_SICH_Power_Control_Info_TDD768 */
static int hf_rrc_tdd128_11;                      /* T_tdd128_11 */
static int hf_rrc_tpc_Step_Size_01;               /* T_tpc_Step_Size_01 */
static int hf_rrc_ura_UpdateCause;                /* URA_UpdateCause */
static int hf_rrc_laterNonCriticalExtensions_63;  /* T_laterNonCriticalExtensions_61 */
static int hf_rrc_uraUpdate_r3_add_ext;           /* T_uraUpdate_r3_add_ext */
static int hf_rrc_v770NonCriticalExtensions_32;   /* T_v770NonCriticalExtensions_32 */
static int hf_rrc_uraUpdate_v770ext;              /* UraUpdate_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_19;   /* T_v860NonCriticalExtensions_19 */
static int hf_rrc_uraUpdate_v860ext;              /* URAUpdate_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_16;   /* T_va40NonCriticalExtensions_15 */
static int hf_rrc_uraUpdate_va40ext;              /* URAUpdate_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_195;      /* T_nonCriticalExtensions_195 */
static int hf_rrc_uraUpdate_v7e0ext;              /* URAUpdate_v7e0ext_IEs */
static int hf_rrc_nonCriticalExtensions_196;      /* T_nonCriticalExtensions_196 */
static int hf_rrc_support_hsdschReception_CellUraPch;  /* T_support_hsdschReception_CellUraPch */
static int hf_rrc_support_hsdschReception_CellFach;  /* T_support_hsdschReception_CellFach */
static int hf_rrc_supportForTwoDRXSchemesInPCH_01;  /* T_supportForTwoDRXSchemesInPCH_01 */
static int hf_rrc_supportOfHS_DSCHDRXOperation_02;  /* T_supportOfHS_DSCHDRXOperation_02 */
static int hf_rrc_supportOfCommonEDCH_03;         /* T_supportOfCommonEDCH_03 */
static int hf_rrc_supportOfMACiis_03;             /* T_supportOfMACiis_03 */
static int hf_rrc_loggedMeasAvailable_05;         /* T_loggedMeasAvailable_05 */
static int hf_rrc_loggedANRResultsAvailable_04;   /* T_loggedANRResultsAvailable_04 */
static int hf_rrc_r3_28;                          /* T_r3_28 */
static int hf_rrc_uraUpdateConfirm_r3;            /* URAUpdateConfirm_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_64;  /* T_laterNonCriticalExtensions_62 */
static int hf_rrc_uraUpdateConfirm_r3_add_ext;    /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_43;   /* T_v690NonCriticalExtensions_43 */
static int hf_rrc_uraUpdateConfirm_v690ext;       /* URAUpdateConfirm_v690ext_IEs */
static int hf_rrc_nonCriticalExtensions_197;      /* T_nonCriticalExtensions_197 */
static int hf_rrc_later_than_r3_25;               /* T_later_than_r3_25 */
static int hf_rrc_criticalExtensions_152;         /* T_criticalExtensions_150 */
static int hf_rrc_r5_12;                          /* T_r5_12 */
static int hf_rrc_uraUpdateConfirm_r5;            /* URAUpdateConfirm_r5_IEs */
static int hf_rrc_v690NonCriticalExtensions_44;   /* T_v690NonCriticalExtensions_44 */
static int hf_rrc_nonCriticalExtensions_198;      /* T_nonCriticalExtensions_198 */
static int hf_rrc_criticalExtensions_153;         /* T_criticalExtensions_151 */
static int hf_rrc_r7_13;                          /* T_r7_13 */
static int hf_rrc_uraUpdateConfirm_r7;            /* URAUpdateConfirm_r7_IEs */
static int hf_rrc_uraUpdateConfirm_r7_add_ext;    /* BIT_STRING */
static int hf_rrc_v860NonCriticalExtensions_20;   /* T_v860NonCriticalExtensions_20 */
static int hf_rrc_uraUpdateConfirm_v860ext;       /* URAUpdateConfirm_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_199;      /* T_nonCriticalExtensions_199 */
static int hf_rrc_criticalExtensions_154;         /* T_criticalExtensions_152 */
static int hf_rrc_r3_29;                          /* T_r3_29 */
static int hf_rrc_uraUpdateConfirm_CCCH_r3;       /* URAUpdateConfirm_CCCH_r3_IEs */
static int hf_rrc_laterNonCriticalExtensions_65;  /* T_laterNonCriticalExtensions_63 */
static int hf_rrc_uraUpdateConfirm_CCCH_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_45;   /* T_v690NonCriticalExtensions_45 */
static int hf_rrc_v860NonCriticalExtensions_21;   /* T_v860NonCriticalExtensions_21 */
static int hf_rrc_nonCriticalExtensions_200;      /* T_nonCriticalExtensions_200 */
static int hf_rrc_later_than_r3_26;               /* T_later_than_r3_26 */
static int hf_rrc_criticalExtensions_155;         /* T_criticalExtensions_153 */
static int hf_rrc_uraUpdateConfirm_02;            /* URAUpdateConfirm_r3_IEs */
static int hf_rrc_r3_30;                          /* T_r3_30 */
static int hf_rrc_utranMobilityInformation_r3;    /* UTRANMobilityInformation_r3_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_11;   /* T_v3a0NonCriticalExtensions_11 */
static int hf_rrc_utranMobilityInformation_v3a0ext;  /* UTRANMobilityInformation_v3a0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_66;  /* T_laterNonCriticalExtensions_64 */
static int hf_rrc_utranMobilityInformation_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v690NonCriticalExtensions_46;   /* T_v690NonCriticalExtensions_46 */
static int hf_rrc_utranMobilityInformation_v690ext;  /* UtranMobilityInformation_v690ext_IEs */
static int hf_rrc_v860NonCriticalExtentions;      /* T_v860NonCriticalExtentions */
static int hf_rrc_utranMobilityInformation_v860ext;  /* UTRANMobilityInformation_v860ext1_IEs */
static int hf_rrc_nonCriticalExtensions_201;      /* T_nonCriticalExtensions_201 */
static int hf_rrc_later_than_r3_27;               /* T_later_than_r3_27 */
static int hf_rrc_criticalExtensions_156;         /* T_criticalExtensions_154 */
static int hf_rrc_r5_13;                          /* T_r5_13 */
static int hf_rrc_utranMobilityInformation_r5;    /* UTRANMobilityInformation_r5_IEs */
static int hf_rrc_v690NonCriticalExtensions_47;   /* T_v690NonCriticalExtensions_47 */
static int hf_rrc_v860NonCriticalExtentions_01;   /* T_v860NonCriticalExtentions_01 */
static int hf_rrc_nonCriticalExtensions_202;      /* T_nonCriticalExtensions_202 */
static int hf_rrc_criticalExtensions_157;         /* T_criticalExtensions_155 */
static int hf_rrc_r7_14;                          /* T_r7_14 */
static int hf_rrc_utranMobilityInformation_r7;    /* UTRANMobilityInformation_r7_IEs */
static int hf_rrc_utranMobilityInformation_r7_add_ext;  /* BIT_STRING */
static int hf_rrc_v860NonCriticalExtensions_22;   /* T_v860NonCriticalExtensions_22 */
static int hf_rrc_utranMobilityInformation_v860ext_01;  /* UTRANMobilityInformation_v860ext2_IEs */
static int hf_rrc_vb50NonCriticalExtentions;      /* T_vb50NonCriticalExtentions */
static int hf_rrc_utranMobilityInformation_vb50ext;  /* UTRANMobilityInformation_vb50ext_IEs */
static int hf_rrc_nonCriticalExtensions_203;      /* T_nonCriticalExtensions_203 */
static int hf_rrc_criticalExtensions_158;         /* T_criticalExtensions_156 */
static int hf_rrc_r11_12;                         /* T_r11_12 */
static int hf_rrc_utranMobilityInformation_r11;   /* UTRANMobilityInformation_r11_IEs */
static int hf_rrc_utranMobilityInformation_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_204;      /* T_nonCriticalExtensions_204 */
static int hf_rrc_criticalExtensions_159;         /* T_criticalExtensions_157 */
static int hf_rrc_r12_11;                         /* T_r12_11 */
static int hf_rrc_utranMobilityInformation_r12;   /* UTRANMobilityInformation_r12_IEs */
static int hf_rrc_utranMobilityInformation_r12_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_205;      /* T_nonCriticalExtensions_205 */
static int hf_rrc_criticalExtensions_160;         /* T_criticalExtensions_158 */
static int hf_rrc_r13_09;                         /* T_r13_09 */
static int hf_rrc_utranMobilityInformation_r13;   /* UTRANMobilityInformation_r13_IEs */
static int hf_rrc_utranMobilityInformation_r13_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_206;      /* T_nonCriticalExtensions_206 */
static int hf_rrc_criticalExtensions_161;         /* T_criticalExtensions_159 */
static int hf_rrc_ue_ConnTimersAndConstants;      /* UE_ConnTimersAndConstants */
static int hf_rrc_cn_InformationInfo_02;          /* CN_InformationInfoFull */
static int hf_rrc_nonCriticalExtensions_207;      /* T_nonCriticalExtensions_207 */
static int hf_rrc_ue_ConnTimersAndConstants_v3a0ext;  /* UE_ConnTimersAndConstants_v3a0ext */
static int hf_rrc_ue_ConnTimersAndConstants_01;   /* UE_ConnTimersAndConstants_r5 */
static int hf_rrc_ue_ConnTimersAndConstants_02;   /* UE_ConnTimersAndConstants_v860ext */
static int hf_rrc_dedicatedPriorityInformation;   /* DedicatedPriorityInformation */
static int hf_rrc_dedicatedPriorityInformation_01;  /* DedicatedPriorityInformation_r11 */
static int hf_rrc_ue_ConnTimersAndConstants_03;   /* UE_ConnTimersAndConstants_r11 */
static int hf_rrc_measurementReleaseEnhancement;  /* MeasurementReleaseEnhancement */
static int hf_rrc_domainSpecificAccessRestrictionParametersUpdate;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_pagingPermissionWithAccessControlParametersUpdate;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_extendedDedicatedPriorityInformation;  /* DedicatedPriorityInformation_r13 */
static int hf_rrc_laterNonCriticalExtensions_67;  /* T_laterNonCriticalExtensions_65 */
static int hf_rrc_utranMobilityInformationConfirm_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_v770NonCriticalExtension_01;    /* T_v770NonCriticalExtension_01 */
static int hf_rrc_utranMobilityInformationConfirm_v770ext;  /* UTRANMobilityInformationConfirm_v770ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_17;   /* T_va40NonCriticalExtensions_16 */
static int hf_rrc_utranMobilityInformationConfirm_va40ext;  /* UTRANMobilityInformationConfirm_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_208;      /* T_nonCriticalExtensions_208 */
static int hf_rrc_deferredMeasurementControlReading_06;  /* T_deferredMeasurementControlReading_06 */
static int hf_rrc_loggedMeasAvailable_06;         /* T_loggedMeasAvailable_06 */
static int hf_rrc_laterNonCriticalExtensions_68;  /* T_laterNonCriticalExtensions_66 */
static int hf_rrc_utranMobilityInformationFailure_r3_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_209;      /* T_nonCriticalExtensions_209 */
static int hf_rrc_mbms_ServiceAccessInfoList;     /* MBMS_ServiceAccessInfoList_r6 */
static int hf_rrc_nonCriticalExtensions_210;      /* T_nonCriticalExtensions_210 */
static int hf_rrc_mbms_CommonRBInformationList;   /* MBMS_CommonRBInformationList_r6 */
static int hf_rrc_mbms_TranspChInfoForEachTrCh;   /* MBMS_TranspChInfoForEachTrCh_r6 */
static int hf_rrc_mbms_TranspChInfoForEachCCTrCh;  /* MBMS_TranspChInfoForEachCCTrCh_r6 */
static int hf_rrc_mbms_PhyChInformationList;      /* MBMS_PhyChInformationList_r6 */
static int hf_rrc_v770NonCriticalExtensions_33;   /* T_v770NonCriticalExtensions_33 */
static int hf_rrc_mbmsCommonPTMRBInformation_v770ext;  /* MBMSCommonPTMRBInformation_v770ext_IEs */
static int hf_rrc_v780NonCriticalExtensions_10;   /* T_v780NonCriticalExtensions_10 */
static int hf_rrc_mbmsCommonPTMRBInformation_v780ext;  /* MBMSCommonPTMRBInformation_v780ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_23;   /* T_v860NonCriticalExtensions_23 */
static int hf_rrc_mbmsCommonPTMRBInformation_v860ext;  /* MBMSCommonPTMRBInformation_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_211;      /* T_nonCriticalExtensions_211 */
static int hf_rrc_mbms_PhyChInformationList_r7;   /* MBMS_PhyChInformationList_r7 */
static int hf_rrc_mbsfn_TDDInformation_LCR;       /* MBSFN_TDDInformation_LCR */
static int hf_rrc_mbms_PhyChInformationList_01;   /* MBMS_PhyChInformationList_IMB384 */
static int hf_rrc_mbms_CurrentCell_SCCPCHList;    /* MBMS_CurrentCell_SCCPCHList_r6 */
static int hf_rrc_mbms_SIBType5_SCCPCHList;       /* MBMS_SIBType5_SCCPCHList_r6 */
static int hf_rrc_v770NonCriticalExtensions_34;   /* T_v770NonCriticalExtensions_34 */
static int hf_rrc_mbmsCurrentCellPTMRBInfo_v770ext;  /* MBMSCurrentCellPTMRBInfo_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_212;      /* T_nonCriticalExtensions_212 */
static int hf_rrc_mbsfn_TDM_Info_List;            /* MBSFN_TDM_Info_List */
static int hf_rrc_mbms_PreferredFrequencyInfo;    /* MBMS_PreferredFrequencyList_r6 */
static int hf_rrc_mbms_TimersAndCounters;         /* MBMS_TimersAndCounters_r6 */
static int hf_rrc_michConfigurationInfo;          /* MBMS_MICHConfigurationInfo_r6 */
static int hf_rrc_cellGroupIdentity;              /* MBMS_CellGroupIdentity_r6 */
static int hf_rrc_mschDefaultConfigurationInfo;   /* MBMS_MSCH_ConfigurationInfo_r6 */
static int hf_rrc_v6b0NonCriticalExtensions_13;   /* T_v6b0NonCriticalExtensions_12 */
static int hf_rrc_mbmsGeneralInformation_v6b0ext;  /* MBMSGeneralInformation_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_35;   /* T_v770NonCriticalExtensions_35 */
static int hf_rrc_mbmsGeneralInformation_v770ext;  /* MBMSGeneralInformation_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_24;   /* T_v860NonCriticalExtensions_24 */
static int hf_rrc_mbmsGeneralInformation_v860ext;  /* MBMSGeneralInformation_v860ext_IEs */
static int hf_rrc_v890NoncriticalExtensions;      /* T_v890NoncriticalExtensions */
static int hf_rrc_mbmsGeneralInformation_v890ext;  /* MBMSGeneralInformation_v890ext_IEs */
static int hf_rrc_nonCriticalExtensions_213;      /* T_nonCriticalExtensions_213 */
static int hf_rrc_indicateChangeInSelectedServices;  /* BOOLEAN */
static int hf_rrc_mbmsMICHConfiguration;          /* MBMS_MICHConfigurationInfo_v770ext */
static int hf_rrc_mbsfnInterFrequencyNeighbourList;  /* MBSFN_InterFrequencyNeighbourList_r7 */
static int hf_rrc_mbsfnInterFrequencyNeighbourList_01;  /* MBSFN_InterFrequencyNeighbourList_v860ext */
static int hf_rrc_mbmsNetworkStandardTimeInformation_LCR;  /* MBMS_NetworkStandardTimeInformation_LCR_v890ext */
static int hf_rrc_mbmsMICHConfiguration_01;       /* MBMS_MICHConfigurationInfo_v890ext */
static int hf_rrc_mbms_PreferredFreqRequest;      /* MBMS_ServiceIdentity_r6 */
static int hf_rrc_v6b0NonCriticalExtensions_14;   /* T_v6b0NonCriticalExtensions_13 */
static int hf_rrc_mbmsModificationRequest_v6b0ext;  /* MBMSModificationRequest_v6b0ext_IEs */
static int hf_rrc_v6f0NonCriticalExtensions_02;   /* T_v6f0NonCriticalExtensions_02 */
static int hf_rrc_mbmsModificationRequest_v6f0ext;  /* MBMSModificationRequest_v6f0ext_IEs */
static int hf_rrc_nonCriticalExtensions_214;      /* T_nonCriticalExtensions_214 */
static int hf_rrc_mbmsSelectedServiceInfo;        /* MBMS_SelectedServiceInfo */
static int hf_rrc_mbmsSupportOfServiceChangeForAPtpRB;  /* T_mbmsSupportOfServiceChangeForAPtpRB */
static int hf_rrc_modifedServiceList;             /* MBMS_ModifedServiceList_r6 */
static int hf_rrc_mbms_ReacquireMCCH;             /* T_mbms_ReacquireMCCH */
static int hf_rrc_mbms_DynamicPersistenceLevel;   /* DynamicPersistenceLevel */
static int hf_rrc_endOfModifiedMCCHInformation;   /* INTEGER_1_16 */
static int hf_rrc_mbmsNumberOfNeighbourCells;     /* MBMS_NumberOfNeighbourCells_r6 */
static int hf_rrc_mbms_AllUnmodifiedPTMServices;  /* T_mbms_AllUnmodifiedPTMServices */
static int hf_rrc_mbms_PTMActivationTime;         /* MBMS_PTMActivationTime_r6 */
static int hf_rrc_v770NonCriticalExtensions_36;   /* T_v770NonCriticalExtensions_36 */
static int hf_rrc_mbmsModifiedServicesInformation_v770ext;  /* MBMSModifiedServicesInformation_v770ext_IEs */
static int hf_rrc_v7c0NonCriticalExtensions;      /* T_v7c0NonCriticalExtensions */
static int hf_rrc_mbmsModifiedServicesInformation_v7c0ext;  /* MBMSModifiedServicesInformation_v7c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_215;      /* T_nonCriticalExtensions_215 */
static int hf_rrc_modifiedServiceList;            /* MBMS_ModifiedServiceList_v770ext */
static int hf_rrc_mib_ValueTag;                   /* MIB_ValueTag */
static int hf_rrc_modifiedServiceList_01;         /* MBMS_ModifiedServiceList_LCR_v7c0ext */
static int hf_rrc_neighbouringCellIdentity;       /* IntraFreqCellID */
static int hf_rrc_neighbouringCellSCCPCHList;     /* MBMS_NeighbouringCellSCCPCHList_r6 */
static int hf_rrc_v770NonCriticalExtensions_37;   /* T_v770NonCriticalExtensions_37 */
static int hf_rrc_mbmsNeighbouringCellPTMRBInformation_v770ext;  /* MBMSNeighbouringCellPTMRBInformation_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_216;      /* T_nonCriticalExtensions_216 */
static int hf_rrc_neighbouringCellSCCPCHList_01;  /* MBMS_NeighbouringCellSCCPCHList_v770ext */
static int hf_rrc_serviceSchedulingInfoList;      /* MBMS_ServiceSchedulingInfoList_r6 */
static int hf_rrc_nonCriticalExtensions_217;      /* T_nonCriticalExtensions_217 */
static int hf_rrc_unmodifiedServiceList;          /* MBMS_UnmodifiedServiceList_r6 */
static int hf_rrc_v770NonCriticalExtensions_38;   /* T_v770NonCriticalExtensions_38 */
static int hf_rrc_mbmsUnmodifiedServicesInformation_v770ext;  /* MBMSUnmodifiedServicesInformation_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_218;      /* T_nonCriticalExtensions_218 */
static int hf_rrc_unmodifiedServiceList_01;       /* MBMS_UnmodifiedServiceList_v770ext */
static int hf_rrc_mib;                            /* T_mib */
static int hf_rrc_sysInfoTypeSB1_msg;             /* T_sysInfoTypeSB1_msg */
static int hf_rrc_sysInfoTypeSB2_msg;             /* T_sysInfoTypeSB2_msg */
static int hf_rrc_sysInfoType1_msg;               /* T_sysInfoType1_msg */
static int hf_rrc_sysInfoType3_msg;               /* T_sysInfoType3_msg */
static int hf_rrc_sysInfoType5_msg;               /* T_sysInfoType5_msg */
static int hf_rrc_sysInfoType7;                   /* T_sysInfoType7 */
static int hf_rrc_sysInfoType11_msg;              /* T_sysInfoType11_msg */
static int hf_rrc_sysInfoType11bis_msg;           /* T_sysInfoType11bis_msg */
static int hf_rrc_sysInfoType12_msg;              /* T_sysInfoType12_msg */
static int hf_rrc_vb50NonCriticalExtensions_21;   /* T_vb50NonCriticalExtensions_21 */
static int hf_rrc_system_Information_Container_vb50ext;  /* System_Information_Container_vb50ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_08;   /* T_vc50NonCriticalExtensions_08 */
static int hf_rrc_system_Information_Container_vc50ext;  /* System_Information_Container_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_219;      /* T_nonCriticalExtensions_219 */
static int hf_rrc_sysInfoType22_msg;              /* T_sysInfoType22_msg */
static int hf_rrc_sysInfoType11ter;               /* T_sysInfoType11ter */
static int hf_rrc_criticalExtensions_162;         /* T_criticalExtensions_160 */
static int hf_rrc_r10_11;                         /* T_r10_11 */
static int hf_rrc_loggingMeasurementConfiguration_r10_IEs;  /* LoggingMeasurementConfiguration_r10_IEs */
static int hf_rrc_loggingMeasurementConfiguration_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_220;      /* T_nonCriticalExtensions_220 */
static int hf_rrc_criticalExtensions_163;         /* T_criticalExtensions_161 */
static int hf_rrc_r11_13;                         /* T_r11_13 */
static int hf_rrc_loggingMeasurementConfiguration_r11_IEs;  /* LoggingMeasurementConfiguration_r11_IEs */
static int hf_rrc_loggingMeasurementConfiguration_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_221;      /* T_nonCriticalExtensions_221 */
static int hf_rrc_criticalExtensions_164;         /* T_criticalExtensions_162 */
static int hf_rrc_loggedMeasurementsConfigurationInfo;  /* LoggedMeasurementsConfigurationInfo */
static int hf_rrc_loggedANRConfigurationInfo;     /* LoggedANRConfigurationInfo */
static int hf_rrc_loggedMeasurementsConfigurationInfo_01;  /* LoggedMeasurementsConfigurationInfo_r11 */
static int hf_rrc_loggedMeasReport;               /* LoggedMeasReport */
static int hf_rrc_loggedANRReportInfoList;        /* LoggedANRReportInfoList */
static int hf_rrc_vb50NonCriticalExtensions_22;   /* T_vb50NonCriticalExtensions_22 */
static int hf_rrc_ueInformationResponse_vb50ext;  /* UEInformationResponse_vb50ext_IEs */
static int hf_rrc_vbb0NonCriticalExtensions;      /* T_vbb0NonCriticalExtensions */
static int hf_rrc_ueInformationResponse_vbb0ext;  /* UEInformationResponse_vbb0ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_09;   /* T_vc50NonCriticalExtensions_09 */
static int hf_rrc_ueInformationResponse_vc50ext;  /* UEInformationResponse_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_222;      /* T_nonCriticalExtensions_222 */
static int hf_rrc_loggedMeasReport_01;            /* LoggedMeasReport_vb50ext */
static int hf_rrc_connectionEstablishmentFailureReport;  /* ConnectionEstablishmentFailureReport */
static int hf_rrc_loggedANRReportInfoList_01;     /* LoggedANRReportInfoList_vb50ext */
static int hf_rrc_connectionEstablishmentFailureReport_01;  /* ConnectionEstablishmentFailureReport_r11 */
static int hf_rrc_loggedMeasReport_02;            /* LoggedMeasReport_vc50ext */
static int hf_rrc_connectionEstablishmentFailureReport_02;  /* ConnectionEstablishmentFailureReport_vc50ext */
static int hf_rrc_criticalExtensions_165;         /* T_criticalExtensions_163 */
static int hf_rrc_r10_12;                         /* T_r10_12 */
static int hf_rrc_ueInformationRequest_r10;       /* UEInformationRequest_r10_IEs */
static int hf_rrc_ueInformationRequest_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_223;      /* T_nonCriticalExtensions_223 */
static int hf_rrc_criticalExtensions_166;         /* T_criticalExtensions_164 */
static int hf_rrc_r11_14;                         /* T_r11_14 */
static int hf_rrc_ueInformationRequest_r11;       /* UEInformationRequest_r11_IEs */
static int hf_rrc_ueInformationRequest_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_224;      /* T_nonCriticalExtensions_224 */
static int hf_rrc_criticalExtensions_167;         /* T_criticalExtensions_165 */
static int hf_rrc_loggedMeasReportRequest;        /* T_loggedMeasReportRequest */
static int hf_rrc_loggedANRReportRequest;         /* T_loggedANRReportRequest */
static int hf_rrc_loggedMeasReportRequest_01;     /* T_loggedMeasReportRequest_01 */
static int hf_rrc_loggedANRReportRequest_01;      /* T_loggedANRReportRequest_01 */
static int hf_rrc_connectionEstablishmentFailureRequest;  /* T_connectionEstablishmentFailureRequest */
static int hf_rrc_cn_DomainSpecificNAS_Info;      /* NAS_SystemInformationGSM_MAP */
static int hf_rrc_cn_DRX_CycleLengthCoeff;        /* CN_DRX_CycleLengthCoefficient */
static int hf_rrc_CN_DomainInformationList_item;  /* CN_DomainInformation */
static int hf_rrc_CN_DomainInformationListFull_item;  /* CN_DomainInformationFull */
static int hf_rrc_cn_Type;                        /* T_cn_Type */
static int hf_rrc_gsm_MAP;                        /* NAS_SystemInformationGSM_MAP */
static int hf_rrc_ansi_41;                        /* NAS_SystemInformationANSI_41 */
static int hf_rrc_CN_DomainSysInfoList_item;      /* CN_DomainSysInfo */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo;   /* T_cn_CommonGSM_MAP_NAS_SysInfo */
static int hf_rrc_cn_DomainInformationList;       /* CN_DomainInformationList */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo_01;  /* T_cn_CommonGSM_MAP_NAS_SysInfo_01 */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo_02;  /* T_cn_CommonGSM_MAP_NAS_SysInfo_02 */
static int hf_rrc_cn_DomainInformationListFull;   /* CN_DomainInformationListFull */
static int hf_rrc_cs_DomainSpecificEAB_Parameters;  /* EAB_Configuration */
static int hf_rrc_ps_DomainSpecificEAB_Parameters;  /* EAB_Configuration */
static int hf_rrc_commonEAB_Parameters;           /* EAB_Configuration */
static int hf_rrc_EAB_AccessClassBarredList_item;  /* AccessClassBarred */
static int hf_rrc_eab_Category;                   /* T_eab_Category */
static int hf_rrc_eab_AccessClassBarredList;      /* EAB_AccessClassBarredList */
static int hf_rrc_eab_ParametersPerPLMN_List;     /* EAB_ParametersPerPLMN_List */
static int hf_rrc_eab_ParametersForAll;           /* DomainSpecificEAB_Parameters */
static int hf_rrc_domainSpecificEAB_Parameters;   /* DomainSpecificEAB_Parameters */
static int hf_rrc_EAB_ParametersPerPLMN_List_item;  /* EAB_ParametersPerPLMN */
static int hf_rrc_ec_N0;                          /* INTEGER_M24_0 */
static int hf_rrc_routingbasis;                   /* T_routingbasis */
static int hf_rrc_localPTMSI;                     /* T_localPTMSI */
static int hf_rrc_routingparameter;               /* RoutingParameter */
static int hf_rrc_tMSIofsamePLMN;                 /* T_tMSIofsamePLMN */
static int hf_rrc_tMSIofdifferentPLMN;            /* T_tMSIofdifferentPLMN */
static int hf_rrc_iMSIresponsetopaging;           /* T_iMSIresponsetopaging */
static int hf_rrc_iMSIcauseUEinitiatedEvent;      /* T_iMSIcauseUEinitiatedEvent */
static int hf_rrc_iMEI;                           /* T_iMEI */
static int hf_rrc_spare2_02;                      /* T_spare2_01 */
static int hf_rrc_spare1_02;                      /* T_spare1_01 */
static int hf_rrc_dummy_bool;                     /* BOOLEAN */
static int hf_rrc_IMEI_item;                      /* IMEI_Digit */
static int hf_rrc_IMSI_GSM_MAP_item;              /* Digit */
static int hf_rrc_version;                        /* T_version */
static int hf_rrc_release99;                      /* T_release99 */
static int hf_rrc_cn_Type_01;                     /* T_cn_Type_01 */
static int hf_rrc_gsm_Map_IDNNS;                  /* Gsm_map_IDNNS */
static int hf_rrc_ansi_41_IDNNS;                  /* Ansi_41_IDNNS */
static int hf_rrc_later;                          /* T_later */
static int hf_rrc_futurecoding;                   /* BIT_STRING_SIZE_15 */
static int hf_rrc_lac;                            /* BIT_STRING_SIZE_16 */
static int hf_rrc_LocationRegistrationAccessClassBarredList_item;  /* AccessClassBarred */
static int hf_rrc_noRestriction;                  /* NULL */
static int hf_rrc_restriction;                    /* LocationRegistrationAccessClassBarredList */
static int hf_rrc_MCC_item;                       /* Digit */
static int hf_rrc_MNC_item;                       /* Digit */
static int hf_rrc_mibPLMN_Identity;               /* BOOLEAN */
static int hf_rrc_multiplePLMNs;                  /* SEQUENCE_SIZE_1_5_OF_PLMN_IdentityWithOptionalMCC_r6 */
static int hf_rrc_multiplePLMNs_item;             /* PLMN_IdentityWithOptionalMCC_r6 */
static int hf_rrc_pagingPermissionWithAccessControlList;  /* PagingPermissionWithAccessControlList */
static int hf_rrc_pagingPermissionWithAccessControlForAll;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator1;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator2;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator3;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator4;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForOperator5;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingResponseRestrictionIndicator;  /* T_pagingResponseRestrictionIndicator */
static int hf_rrc_locationRegistrationRestrictionIndicator;  /* T_locationRegistrationRestrictionIndicator */
static int hf_rrc_locationRegistration;           /* LocationRegistrationParameters */
static int hf_rrc_mcc;                            /* MCC */
static int hf_rrc_mnc;                            /* MNC */
static int hf_rrc_gsm_MAP_01;                     /* T_gsm_MAP */
static int hf_rrc_ansi_41_01;                     /* T_ansi_41 */
static int hf_rrc_p_REV;                          /* P_REV */
static int hf_rrc_min_P_REV;                      /* Min_P_REV */
static int hf_rrc_sid;                            /* SID */
static int hf_rrc_nid;                            /* NID */
static int hf_rrc_gsm_MAP_and_ANSI_41;            /* T_gsm_MAP_and_ANSI_41 */
static int hf_rrc_gsm_MAP_RAB_Identity;           /* BIT_STRING_SIZE_8 */
static int hf_rrc_ansi_41_RAB_Identity;           /* BIT_STRING_SIZE_8 */
static int hf_rrc_lai;                            /* LAI */
static int hf_rrc_rac;                            /* RoutingAreaCode */
static int hf_rrc_AccessClassBarredList_item;     /* AccessClassBarred */
static int hf_rrc_cellBarred;                     /* CellBarred */
static int hf_rrc_cellReservedForOperatorUse;     /* ReservedIndicator */
static int hf_rrc_cellReservationExtension;       /* ReservedIndicator */
static int hf_rrc_accessClassBarredList;          /* AccessClassBarredList */
static int hf_rrc_cellReservedForCSG;             /* T_cellReservedForCSG */
static int hf_rrc_barred;                         /* T_barred */
static int hf_rrc_intraFreqCellReselectionInd;    /* AllowedIndicator */
static int hf_rrc_t_Barred;                       /* T_Barred */
static int hf_rrc_notBarred;                      /* NULL */
static int hf_rrc_CellIdentity_PerRL_List_item;   /* CellIdentity */
static int hf_rrc_cell_Identity;                  /* CellIdentity */
static int hf_rrc_mappingInfo;                    /* MappingInfo */
static int hf_rrc_cellSelectQualityMeasure;       /* T_cellSelectQualityMeasure */
static int hf_rrc_cpich_Ec_N0;                    /* T_cpich_Ec_N0 */
static int hf_rrc_q_HYST_2_S;                     /* Q_Hyst_S */
static int hf_rrc_cpich_RSCP;                     /* NULL */
static int hf_rrc_modeSpecificInfo_17;            /* T_modeSpecificInfo_17 */
static int hf_rrc_fdd_47;                         /* T_fdd_46 */
static int hf_rrc_s_Intrasearch;                  /* S_SearchQual */
static int hf_rrc_s_Intersearch;                  /* S_SearchQual */
static int hf_rrc_s_SearchHCS;                    /* S_SearchRXLEV */
static int hf_rrc_rat_List;                       /* RAT_FDD_InfoList */
static int hf_rrc_q_QualMin;                      /* Q_QualMin */
static int hf_rrc_q_RxlevMin;                     /* Q_RxlevMin */
static int hf_rrc_tdd_12;                         /* T_tdd_11 */
static int hf_rrc_s_Intrasearch_01;               /* S_SearchRXLEV */
static int hf_rrc_s_Intersearch_01;               /* S_SearchRXLEV */
static int hf_rrc_rat_List_01;                    /* RAT_TDD_InfoList */
static int hf_rrc_q_Hyst_l_S;                     /* Q_Hyst_S */
static int hf_rrc_t_Reselection_S;                /* T_Reselection_S */
static int hf_rrc_hcs_ServingCellInformation;     /* HCS_ServingCellInformation */
static int hf_rrc_CSG_DedicatedFrequencyInfoList_item;  /* FrequencyInfo */
static int hf_rrc_startPSC;                       /* INTEGER_0_63 */
static int hf_rrc_numberOfPSCs;                   /* T_numberOfPSCs */
static int hf_rrc_pscRange2Offset;                /* INTEGER_1_63 */
static int hf_rrc_configurationInfo;              /* T_configurationInfo */
static int hf_rrc_continue;                       /* NULL */
static int hf_rrc_newConfiguration;               /* T_newConfiguration */
static int hf_rrc_t_330;                          /* T_330 */
static int hf_rrc_wlanOffloadInformation;         /* WLANOffloadInformation */
static int hf_rrc_domainSpecificAccessRestictionList;  /* DomainSpecificAccessRestrictionList_v670ext */
static int hf_rrc_domainSpecificAccessRestictionParametersForAll;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator1;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator2;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator3;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator4;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForOperator5;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_cSDomainSpecificAccessRestriction;  /* DomainSpecificAccessRestriction_v670ext */
static int hf_rrc_pSDomainSpecificAccessRestriction;  /* DomainSpecificAccessRestriction_v670ext */
static int hf_rrc_restriction_01;                 /* T_restriction */
static int hf_rrc_domainSpecficAccessClassBarredList;  /* AccessClassBarredList */
static int hf_rrc_rat;                            /* RAT */
static int hf_rrc_mappingFunctionParameterList;   /* MappingFunctionParameterList */
static int hf_rrc_functionType;                   /* MappingFunctionType */
static int hf_rrc_mapParameter1;                  /* MapParameter */
static int hf_rrc_mapParameter2;                  /* MapParameter */
static int hf_rrc_upperLimit;                     /* UpperLimit */
static int hf_rrc_MappingFunctionParameterList_item;  /* MappingFunctionParameter */
static int hf_rrc_MappingInfo_item;               /* Mapping */
static int hf_rrc_action;                         /* T_action */
static int hf_rrc_clearDedicatedPriorities;       /* NULL */
static int hf_rrc_configureDedicatedPriorities;   /* T_configureDedicatedPriorities */
static int hf_rrc_t_322;                          /* T_322 */
static int hf_rrc_priorityLevelList;              /* PriorityLevelList */
static int hf_rrc_eutraDetection;                 /* BOOLEAN */
static int hf_rrc_action_01;                      /* T_action_01 */
static int hf_rrc_configureDedicatedPriorities_01;  /* T_configureDedicatedPriorities_01 */
static int hf_rrc_priorityLevelList_01;           /* PriorityLevelList_r11 */
static int hf_rrc_action_02;                      /* T_action_02 */
static int hf_rrc_configureDedicatedPriorities_02;  /* T_configureDedicatedPriorities_02 */
static int hf_rrc_priorityLevelList_02;           /* PriorityLevelList_r13 */
static int hf_rrc_priority;                       /* INTEGER_0_maxPrio_1 */
static int hf_rrc_radioAccessTechnology;          /* T_radioAccessTechnology */
static int hf_rrc_utraFDD;                        /* T_utraFDD */
static int hf_rrc_utraFDD_item;                   /* T_utraFDD_item */
static int hf_rrc_uarfcn;                         /* UARFCN */
static int hf_rrc_utraTDD;                        /* T_utraTDD */
static int hf_rrc_utraTDD_item;                   /* T_utraTDD_item */
static int hf_rrc_eutra;                          /* T_eutra */
static int hf_rrc_eutra_item;                     /* T_eutra_item */
static int hf_rrc_earfcn;                         /* EARFCN */
static int hf_rrc_gsm_01;                         /* T_gsm_01 */
static int hf_rrc_gsm_CellGroup;                  /* GSM_CellGroup */
static int hf_rrc_radioAccessTechnology_01;       /* T_radioAccessTechnology_01 */
static int hf_rrc_utraFDD_01;                     /* T_utraFDD_01 */
static int hf_rrc_utraFDD_item_01;                /* T_utraFDD_item_01 */
static int hf_rrc_utraTDD_01;                     /* T_utraTDD_01 */
static int hf_rrc_utraTDD_item_01;                /* T_utraTDD_item_01 */
static int hf_rrc_eutra_01;                       /* SEQUENCE_SIZE_1_maxNumEUTRAFreqs_OF_EARFCNRange */
static int hf_rrc_eutra_item_01;                  /* EARFCNRange */
static int hf_rrc_gsm_02;                         /* T_gsm_02 */
static int hf_rrc_subpriority;                    /* T_subpriority */
static int hf_rrc_radioAccessTechnology_02;       /* T_radioAccessTechnology_02 */
static int hf_rrc_utraFDD_02;                     /* T_utraFDD_02 */
static int hf_rrc_utraFDD_item_02;                /* T_utraFDD_item_02 */
static int hf_rrc_utraTDD_02;                     /* T_utraTDD_02 */
static int hf_rrc_utraTDD_item_02;                /* T_utraTDD_item_02 */
static int hf_rrc_gsm_03;                         /* T_gsm_03 */
static int hf_rrc_PriorityLevelList_item;         /* PriorityLevel */
static int hf_rrc_PriorityLevelList_r11_item;     /* PriorityLevel_r11 */
static int hf_rrc_PriorityLevelList_r13_item;     /* PriorityLevel_r13 */
static int hf_rrc_rat_Identifier;                 /* RAT_Identifier */
static int hf_rrc_s_SearchRAT;                    /* S_SearchQual */
static int hf_rrc_s_HCS_RAT;                      /* S_SearchRXLEV */
static int hf_rrc_s_Limit_SearchRAT;              /* S_SearchQual */
static int hf_rrc_RAT_FDD_InfoList_item;          /* RAT_FDD_Info */
static int hf_rrc_s_SearchRAT_01;                 /* S_SearchRXLEV */
static int hf_rrc_s_Limit_SearchRAT_01;           /* S_SearchRXLEV */
static int hf_rrc_RAT_TDD_InfoList_item;          /* RAT_TDD_Info */
static int hf_rrc_URA_IdentityList_item;          /* URA_Identity */
static int hf_rrc_n_AP_RetransMax;                /* N_AP_RetransMax */
static int hf_rrc_n_AccessFails;                  /* N_AccessFails */
static int hf_rrc_nf_BO_NoAICH;                   /* NF_BO_NoAICH */
static int hf_rrc_ns_BO_Busy;                     /* NS_BO_Busy */
static int hf_rrc_nf_BO_AllBusy;                  /* NF_BO_AllBusy */
static int hf_rrc_nf_BO_Mismatch;                 /* NF_BO_Mismatch */
static int hf_rrc_t_CPCH;                         /* T_CPCH */
static int hf_rrc_ue_RadioCapabilityFDDUpdateRequirement;  /* BOOLEAN */
static int hf_rrc_ue_RadioCapabilityTDDUpdateRequirement;  /* BOOLEAN */
static int hf_rrc_systemSpecificCapUpdateReqList;  /* SystemSpecificCapUpdateReqList */
static int hf_rrc_ue_RadioCapabilityUpdateRequirement_TDD128;  /* BOOLEAN */
static int hf_rrc_ue_RadioCapabilityFDDUpdateRequirement_FDD;  /* BOOLEAN */
static int hf_rrc_ue_RadioCapabilityTDDUpdateRequirement_TDD384;  /* BOOLEAN */
static int hf_rrc_ue_RadioCapabilityTDDUpdateRequirement_TDD128;  /* BOOLEAN */
static int hf_rrc_systemSpecificCapUpdateReqList_01;  /* SystemSpecificCapUpdateReqList_r5 */
static int hf_rrc_ue_RadioCapabilityTDDUpdateRequirement_TDD768;  /* BOOLEAN */
static int hf_rrc_systemSpecificCapUpdateReqList_02;  /* SystemSpecificCapUpdateReqList_r8 */
static int hf_rrc_eUTRAbandSpecificCapUpdateReqList;  /* EUTRAbandSpecificCapUpdateReqList */
static int hf_rrc_startRestart;                   /* CipheringAlgorithm */
static int hf_rrc_dummy_null;                     /* NULL */
static int hf_rrc_startRestart_01;                /* CipheringAlgorithm_r7 */
static int hf_rrc_cipheringModeCommand;           /* CipheringModeCommand */
static int hf_rrc_activationTimeForDPCH;          /* ActivationTime */
static int hf_rrc_rb_DL_CiphActivationTimeInfo;   /* RB_ActivationTimeInfoList */
static int hf_rrc_cipheringModeCommand_01;        /* CipheringModeCommand_r7 */
static int hf_rrc_imsi_GSM_MAP;                   /* IMSI_GSM_MAP */
static int hf_rrc_tmsi_GSM_MAP;                   /* TMSI_GSM_MAP */
static int hf_rrc_p_TMSI_GSM_MAP;                 /* P_TMSI_GSM_MAP */
static int hf_rrc_imsi_DS_41;                     /* IMSI_DS_41 */
static int hf_rrc_tmsi_DS_41;                     /* TMSI_DS_41 */
static int hf_rrc_fdd_Measurements;               /* BOOLEAN */
static int hf_rrc_tdd_Measurements;               /* BOOLEAN */
static int hf_rrc_gsm_Measurements;               /* GSM_Measurements */
static int hf_rrc_multiCarrierMeasurements;       /* BOOLEAN */
static int hf_rrc_tdd128_Measurements;            /* BOOLEAN */
static int hf_rrc_adjacentFrequencyMeasurements;  /* T_adjacentFrequencyMeasurements */
static int hf_rrc_interBandMeasurements;          /* T_interBandMeasurements */
static int hf_rrc_enhancedInterFrequencyMeasurements;  /* T_enhancedInterFrequencyMeasurements */
static int hf_rrc_freqSpecificCompressedMode;     /* T_freqSpecificCompressedMode */
static int hf_rrc_radioFrequencyBandEUTRA;        /* RadioFrequencyBandEUTRA */
static int hf_rrc_compressedMode;                 /* BOOLEAN */
static int hf_rrc_radioFrequencyBandEUTRA_01;     /* RadioFrequencyBandEUTRAExt */
static int hf_rrc_radioFrequencyBandEUTRA_02;     /* RadioFrequencyBandEUTRAExt2 */
static int hf_rrc_CompressedModeMeasCapabEUTRAList_item;  /* CompressedModeMeasCapabEUTRA */
static int hf_rrc_CompressedModeMeasCapabEUTRAList2_item;  /* CompressedModeMeasCapabEUTRAExt */
static int hf_rrc_CompressedModeMeasCapabEUTRAList3_item;  /* CompressedModeMeasCapabEUTRAExt2 */
static int hf_rrc_CompressedModeMeasCapabFDDList_item;  /* CompressedModeMeasCapabFDD */
static int hf_rrc_CompressedModeMeasCapabFDDList2_item;  /* CompressedModeMeasCapabFDD2 */
static int hf_rrc_CompressedModeMeasCapabFDDList3_item;  /* CompressedModeMeasCapabFDD3 */
static int hf_rrc_CompressedModeMeasCapabFDDList_ext_item;  /* CompressedModeMeasCapabFDD_ext */
static int hf_rrc_radioFrequencyBandFDD;          /* RadioFrequencyBandFDD */
static int hf_rrc_dl_MeasurementsFDD;             /* BOOLEAN */
static int hf_rrc_ul_MeasurementsFDD;             /* BOOLEAN */
static int hf_rrc_radioFrequencyBandFDD2;         /* RadioFrequencyBandFDD2 */
static int hf_rrc_radioFrequencyBandFDD3;         /* RadioFrequencyBandFDD3 */
static int hf_rrc_CompressedModeMeasCapabTDDList_item;  /* CompressedModeMeasCapabTDD */
static int hf_rrc_radioFrequencyBandTDD;          /* RadioFrequencyBandTDD */
static int hf_rrc_dl_MeasurementsTDD;             /* BOOLEAN */
static int hf_rrc_ul_MeasurementsTDD;             /* BOOLEAN */
static int hf_rrc_CompressedModeMeasCapabGSMList_item;  /* CompressedModeMeasCapabGSM */
static int hf_rrc_radioFrequencyBandGSM;          /* RadioFrequencyBandGSM */
static int hf_rrc_dl_MeasurementsGSM;             /* BOOLEAN */
static int hf_rrc_ul_MeasurementsGSM;             /* BOOLEAN */
static int hf_rrc_dl_MeasurementsMC;              /* BOOLEAN */
static int hf_rrc_ul_MeasurementsMC;              /* BOOLEAN */
static int hf_rrc_initialPriorityDelayList;       /* InitialPriorityDelayList */
static int hf_rrc_backoffControlParams;           /* BackoffControlParams */
static int hf_rrc_powerControlAlgorithm;          /* PowerControlAlgorithm */
static int hf_rrc_dl_DPCCH_BER;                   /* DL_DPCCH_BER */
static int hf_rrc_supportOfIntraFreqProximityIndication;  /* T_supportOfIntraFreqProximityIndication */
static int hf_rrc_supportOfInterFreqProximityIndication;  /* T_supportOfInterFreqProximityIndication */
static int hf_rrc_supportOfE_UtraProximityIndication;  /* T_supportOfE_UtraProximityIndication */
static int hf_rrc_DL_InformationPerSecondaryRL_List_item;  /* DL_InformationPerSecondaryRL */
static int hf_rrc_DL_InformationPerSecondaryRL_List_r12_item;  /* DL_InformationPerSecondaryRL_r12 */
static int hf_rrc_DL_InformationPerSecondaryRL_List_r13_item;  /* DL_InformationPerSecondaryRL_r13 */
static int hf_rrc_cell_id;                        /* CellIdentity */
static int hf_rrc_dl_FDPCHInfoPerRL_SecULFreq;    /* DL_FDPCH_InfoPerRL_r7 */
static int hf_rrc_e_AGCH_Information;             /* E_AGCH_Information */
static int hf_rrc_e_HICH_Information;             /* E_HICH_Information */
static int hf_rrc_e_RGCH_Info;                    /* T_e_RGCH_Info */
static int hf_rrc_e_RGCH_Information;             /* E_RGCH_Information */
static int hf_rrc_releaseIndicator;               /* NULL */
static int hf_rrc_e_RGCH_Info_01;                 /* T_e_RGCH_Info_01 */
static int hf_rrc_secondary_Serving_E_DCHRL_Indicator;  /* T_secondary_Serving_E_DCHRL_Indicator */
static int hf_rrc_radioLinkswithoutDPCHFDPCHIndicator;  /* NULL */
static int hf_rrc_dl_FDPCHInfoPerRL_SecULFreq_01;  /* DL_FDPCH_InfoPerRL_r13 */
static int hf_rrc_e_RGCH_Info_02;                 /* T_e_RGCH_Info_02 */
static int hf_rrc_secondary_Serving_E_DCHRL_Indicator_01;  /* T_secondary_Serving_E_DCHRL_Indicator_01 */
static int hf_rrc_maxNoDPCH_PDSCH_Codes;          /* INTEGER_1_8 */
static int hf_rrc_maxNoPhysChBitsReceived;        /* MaxNoPhysChBitsReceived */
static int hf_rrc_supportForSF_512;               /* BOOLEAN */
static int hf_rrc_simultaneousSCCPCH_DPCH_Reception;  /* SimultaneousSCCPCH_DPCH_Reception */
static int hf_rrc_supportOfDedicatedPilotsForChEstimation;  /* SupportOfDedicatedPilotsForChEstimation */
static int hf_rrc_hsdsch_physical_layer_category_ext;  /* HSDSCH_physical_layer_category_ext */
static int hf_rrc_hsscchlessHsdschOperation;      /* T_hsscchlessHsdschOperation */
static int hf_rrc_enhancedFdpch;                  /* T_enhancedFdpch */
static int hf_rrc_hsdschReception_CellFach;       /* T_hsdschReception_CellFach */
static int hf_rrc_hsdschReception_CellUraPch;     /* T_hsdschReception_CellUraPch */
static int hf_rrc_hsdsch_physical_layer_category_ext2;  /* HSDSCH_physical_layer_category_ext2 */
static int hf_rrc_supportOfTargetCellPreConfig;   /* T_supportOfTargetCellPreConfig */
static int hf_rrc_supportOfHsdschDrxOperation;    /* T_supportOfHsdschDrxOperation */
static int hf_rrc_hsdsch_physical_layer_category_ext3;  /* HSDSCH_physical_layer_category_ext3 */
static int hf_rrc_supportOfMimoOnlySingleStream;  /* T_supportOfMimoOnlySingleStream */
static int hf_rrc_hsdsch_physical_layer_category_ext4;  /* HSDSCH_physical_layer_category_ext4 */
static int hf_rrc_hsdsch_physical_layer_category_ext5;  /* HSDSCH_physical_layer_category_ext5 */
static int hf_rrc_hsdsch_physical_layer_category_ext6;  /* HSDSCH_physical_layer_category_ext6 */
static int hf_rrc_hsdsch_physical_layer_category_ext7;  /* HSDSCH_physical_layer_category_ext7 */
static int hf_rrc_hsdsch_physical_layer_category_ext8;  /* HSDSCH_physical_layer_category_ext8 */
static int hf_rrc_supportOf4x4MimoDualStreamRestriction;  /* T_supportOf4x4MimoDualStreamRestriction */
static int hf_rrc_supportOfHS_DSCHSecondDRXOperation;  /* T_supportOfHS_DSCHSecondDRXOperation */
static int hf_rrc_supportOfNodeBTrigHS_DPCCHTransmission;  /* T_supportOfNodeBTrigHS_DPCCHTransmission */
static int hf_rrc_non_ContiguousMulti_CellWithMIMO;  /* T_non_ContiguousMulti_CellWithMIMO */
static int hf_rrc_supportforDCHEnhancements;      /* T_supportforDCHEnhancements */
static int hf_rrc_simultaneousSupportforDCHEnhancementsAndCM;  /* T_simultaneousSupportforDCHEnhancementsAndCM */
static int hf_rrc_simultaneousSupportforDCHEnhancementsAndDPCCHDiscntTx;  /* T_simultaneousSupportforDCHEnhancementsAndDPCCHDiscntTx */
static int hf_rrc_drx_enhancements;               /* T_drx_enhancements */
static int hf_rrc_hs_dpcchOverheadReduction;      /* T_hs_dpcchOverheadReduction */
static int hf_rrc_supportofEnhancedServingCellChangeForEvent1C;  /* T_supportofEnhancedServingCellChangeForEvent1C */
static int hf_rrc_supportofDPCCH2;                /* T_supportofDPCCH2 */
static int hf_rrc_supportofPowerControlAlgorithm3;  /* T_supportofPowerControlAlgorithm3 */
static int hf_rrc_supportofBlindHarqRetransmissionsforHsdpa;  /* T_supportofBlindHarqRetransmissionsforHsdpa */
static int hf_rrc_supportofHS_SCCHDrxOperation;   /* T_supportofHS_SCCHDrxOperation */
static int hf_rrc_supportofSimplifiedHS_SCCHType1Operation;  /* T_supportofSimplifiedHS_SCCHType1Operation */
static int hf_rrc_maxTS_PerFrame;                 /* MaxTS_PerFrame */
static int hf_rrc_maxPhysChPerFrame;              /* MaxPhysChPerFrame */
static int hf_rrc_minimumSF;                      /* MinimumSF_DL */
static int hf_rrc_supportOfPDSCH;                 /* BOOLEAN */
static int hf_rrc_maxPhysChPerTS;                 /* MaxPhysChPerTS */
static int hf_rrc_maxTS_PerSubFrame;              /* MaxTS_PerSubFrame_r4 */
static int hf_rrc_maxPhysChPerFrame_01;           /* MaxPhysChPerSubFrame_r4 */
static int hf_rrc_supportOf8PSK;                  /* BOOLEAN */
static int hf_rrc_multiCarrier_physical_layer_category;  /* MultiCarrier_HSDSCH_physical_layer_category */
static int hf_rrc_hSDSCH_physical_layer_category_extension;  /* HSDSCH_physical_layer_category_extension */
static int hf_rrc_multiCarrier_physical_layer_category_extension;  /* MultiCarrier_HSDSCH_physical_layer_category_extension */
static int hf_rrc_supportOfSFModeForHSPDSCHDualStream;  /* T_supportOfSFModeForHSPDSCHDualStream */
static int hf_rrc_multiCarrier_physical_layer_category_extension2;  /* MultiCarrier_HSDSCH_physical_layer_category_extension2 */
static int hf_rrc_supportofNon_rectResourceAllocation;  /* T_supportofNon_rectResourceAllocation */
static int hf_rrc_maxPhysChPerFrame_02;           /* MaxPhysChPerFrame_768 */
static int hf_rrc_minimumSF_01;                   /* MinimumSF_DL_768 */
static int hf_rrc_tdd768_hspdsch;                 /* T_tdd768_hspdsch */
static int hf_rrc_supported;                      /* HSDSCH_physical_layer_category */
static int hf_rrc_unsupported;                    /* NULL */
static int hf_rrc_maxPhysChPerTS_01;              /* MaxPhysChPerTS_768 */
static int hf_rrc_maxNoBitsReceived;              /* MaxNoBits */
static int hf_rrc_maxConvCodeBitsReceived;        /* MaxNoBits */
static int hf_rrc_turboDecodingSupport;           /* TurboSupport */
static int hf_rrc_maxSimultaneousTransChs;        /* MaxSimultaneousTransChsDL */
static int hf_rrc_maxSimultaneousCCTrCH_Count;    /* MaxSimultaneousCCTrCH_Count */
static int hf_rrc_maxReceivedTransportBlocks;     /* MaxTransportBlocksDL */
static int hf_rrc_maxNumberOfTFC;                 /* MaxNumberOfTFC_DL */
static int hf_rrc_maxNumberOfTF;                  /* MaxNumberOfTF */
static int hf_rrc_transmissionProbability;        /* TransmissionProbability */
static int hf_rrc_maximumBitRate;                 /* MaximumBitRate */
static int hf_rrc_DRAC_SysInfoList_item;          /* DRAC_SysInfo */
static int hf_rrc_activationOffset;               /* INTEGER_0_15 */
static int hf_rrc_EUTRAbandSpecificCapUpdateReqList_item;  /* RadioFrequencyBandEUTRAExt2 */
static int hf_rrc_configurationUnsupported;       /* NULL */
static int hf_rrc_physicalChannelFailure;         /* NULL */
static int hf_rrc_incompatibleSimultaneousReconfiguration;  /* NULL */
static int hf_rrc_compressedModeRuntimeError;     /* TGPSI */
static int hf_rrc_protocolError;                  /* ProtocolErrorInformation */
static int hf_rrc_cellUpdateOccurred;             /* NULL */
static int hf_rrc_invalidConfiguration;           /* NULL */
static int hf_rrc_configurationIncomplete;        /* NULL */
static int hf_rrc_unsupportedMeasurement;         /* NULL */
static int hf_rrc_mbmsSessionAlreadyReceivedCorrectly;  /* NULL */
static int hf_rrc_lowerPriorityMBMSService;       /* NULL */
static int hf_rrc_modeSpecificInfo_18;            /* T_modeSpecificInfo_18 */
static int hf_rrc_fdd_48;                         /* T_fdd_47 */
static int hf_rrc_frequencyBandsSupportFDD;       /* FrequencyBandsRedirectionFDD */
static int hf_rrc_tdd_13;                         /* T_tdd_12 */
static int hf_rrc_frequencyBandsSupportTDD128;    /* FrequencyBandsIndicatorTDD128 */
static int hf_rrc_FrequencyBandsIndicatorTDD128_item;  /* FrequencyBandsIndicatorSupportTDD128 */
static int hf_rrc_frequencyBandsIndicatorTDD;     /* RadioFrequencyBandTDD_r10 */
static int hf_rrc_FrequencyBandsRedirectionFDD_item;  /* FrequencyBandsIndicatorFDD */
static int hf_rrc_frequencyBandsIndicator1;       /* RadioFrequencyBandFDD */
static int hf_rrc_frequencyBandsIndicator2;       /* RadioFrequencyBandFDD2 */
static int hf_rrc_frequencyBandsIndicator3;       /* RadioFrequencyBandFDD3 */
static int hf_rrc_rrc_ConnectionReleaseInformation;  /* RRC_ConnectionReleaseInformation */
static int hf_rrc_groupReleaseInformation;        /* GroupReleaseInformation */
static int hf_rrc_uRNTI_Group;                    /* U_RNTI_Group */
static int hf_rrc_gsm900;                         /* BOOLEAN */
static int hf_rrc_dcs1800;                        /* BOOLEAN */
static int hf_rrc_gsm1900;                        /* BOOLEAN */
static int hf_rrc_numberOfCellsBandA;             /* INTEGER_1_6 */
static int hf_rrc_numberOfFrequenciesBandA;       /* INTEGER_1_3 */
static int hf_rrc_numberOfCellsBandB;             /* INTEGER_1_6 */
static int hf_rrc_numberOfFrequenciesBandB;       /* INTEGER_1_3 */
static int hf_rrc_MultiflowCapabBandCombList_item;  /* MultiflowCapabBandCombination */
static int hf_rrc_mimoInDifferentBands;           /* MultiflowMIMOCapability */
static int hf_rrc_longerHARQProcessing;           /* T_longerHARQProcessing */
static int hf_rrc_numberOfCells;                  /* INTEGER_2_8 */
static int hf_rrc_numberOfFrequencies;            /* INTEGER_1_4 */
static int hf_rrc_mimo;                           /* MultiflowMIMOCapability */
static int hf_rrc_nonContiguousCapability;        /* MultiflowNonContiguousCapability */
static int hf_rrc_gapSize;                        /* T_gapSize */
static int hf_rrc_idleInterval;                   /* BOOLEAN */
static int hf_rrc_IdleIntervalMeasCapabEUTRAList_item;  /* IdleIntervalMeasCapabEUTRA */
static int hf_rrc_IdleIntervalMeasCapabEUTRAExtensionList_item;  /* IdleIntervalMeasCapabEUTRAExtension */
static int hf_rrc_esn_DS_41;                      /* ESN_DS_41 */
static int hf_rrc_InitialPriorityDelayList_item;  /* NS_IP */
static int hf_rrc_imsi;                           /* IMSI_GSM_MAP */
static int hf_rrc_tmsi_and_LAI;                   /* TMSI_and_LAI_GSM_MAP */
static int hf_rrc_p_TMSI_and_RAI;                 /* P_TMSI_and_RAI_GSM_MAP */
static int hf_rrc_imei;                           /* IMEI */
static int hf_rrc_imsi_and_ESN_DS_41;             /* IMSI_and_ESN_DS_41 */
static int hf_rrc_messageAuthenticationCode;      /* MessageAuthenticationCode */
static int hf_rrc_rrc_MessageSequenceNumber;      /* RRC_MessageSequenceNumber */
static int hf_rrc_rrc_MessageSequenceNumberList;  /* RRC_MessageSequenceNumberList */
static int hf_rrc_startIntegrityProtection;       /* T_startIntegrityProtection */
static int hf_rrc_integrityProtInitNumber;        /* IntegrityProtInitNumber */
static int hf_rrc_modify;                         /* T_modify */
static int hf_rrc_dl_IntegrityProtActivationInfo;  /* IntegrityProtActivationInfo */
static int hf_rrc_integrityProtectionModeCommand;  /* IntegrityProtectionModeCommand */
static int hf_rrc_integrityProtectionAlgorithm;   /* IntegrityProtectionAlgorithm */
static int hf_rrc_integrityProtectionAlgorithm_01;  /* IntegrityProtectionAlgorithm_r7 */
static int hf_rrc_downlinkCompressedMode;         /* CompressedModeMeasCapability */
static int hf_rrc_uplinkCompressedMode;           /* CompressedModeMeasCapability */
static int hf_rrc_compressedModeMeasCapabFDDList;  /* CompressedModeMeasCapabFDDList */
static int hf_rrc_compressedModeMeasCapabTDDList;  /* CompressedModeMeasCapabTDDList */
static int hf_rrc_compressedModeMeasCapabGSMList;  /* CompressedModeMeasCapabGSMList */
static int hf_rrc_compressedModeMeasCapabMC;      /* CompressedModeMeasCapabMC */
static int hf_rrc_compressedModeMeasCapabFDDList_01;  /* CompressedModeMeasCapabFDDList2 */
static int hf_rrc_compressedModeMeasCapabEUTRAList;  /* CompressedModeMeasCapabEUTRAList */
static int hf_rrc_compressedModeMeasCapabFDDList2;  /* CompressedModeMeasCapabFDDList2 */
static int hf_rrc_compressedModeMeasCapabFDDList3;  /* CompressedModeMeasCapabFDDList3 */
static int hf_rrc_compressedModeMeasCapabEUTRAList_01;  /* CompressedModeMeasCapabEUTRAList2 */
static int hf_rrc_compressedModeMeasCapabEUTRAList_02;  /* CompressedModeMeasCapabEUTRAList3 */
static int hf_rrc_downlinkCompressedMode_LCR;     /* CompressedModeMeasCapability_LCR_r4 */
static int hf_rrc_uplinkCompressedMode_LCR;       /* CompressedModeMeasCapability_LCR_r4 */
static int hf_rrc_downlinkCompressedMode_01;      /* CompressedModeMeasCapability_v860ext */
static int hf_rrc_downlinkCompressedMode_02;      /* CompressedModeMeasCapability_v920ext */
static int hf_rrc_interFrequencyDetectedSetMeasurements;  /* T_interFrequencyDetectedSetMeasurements */
static int hf_rrc_downlinkCompressedMode_03;      /* CompressedModeMeasCapability_va40ext */
static int hf_rrc_interFrequencyMeasOnConfigCarriersWithoutCompMode;  /* T_interFrequencyMeasOnConfigCarriersWithoutCompMode */
static int hf_rrc_cellsExcludedFromDetectedSetMeasurements;  /* T_cellsExcludedFromDetectedSetMeasurements */
static int hf_rrc_idleIntervalMeasCapabEUTRAList;  /* IdleIntervalMeasCapabEUTRAList */
static int hf_rrc_idleIntervalMeasCapabEUTRAList_01;  /* IdleIntervalMeasCapabEUTRAExtensionList */
static int hf_rrc_widebandRSRQFDDMeasurements;    /* T_widebandRSRQFDDMeasurements */
static int hf_rrc_widebandRSRQTDDMeasurements;    /* T_widebandRSRQTDDMeasurements */
static int hf_rrc_event2gReportingOnaConfiguredSecDLFrequency;  /* T_event2gReportingOnaConfiguredSecDLFrequency */
static int hf_rrc_extendedRsrqLowerValueRange;    /* T_extendedRsrqLowerValueRange */
static int hf_rrc_rsrqOnAllSymbols;               /* T_rsrqOnAllSymbols */
static int hf_rrc_increasedUECarrierMonitoringUTRA;  /* T_increasedUECarrierMonitoringUTRA */
static int hf_rrc_increasedUECarrierMonitoringE_UTRA;  /* T_increasedUECarrierMonitoringE_UTRA */
static int hf_rrc_enhancedUPHReporting;           /* T_enhancedUPHReporting */
static int hf_rrc_rrcEventsforUPHReporting;       /* T_rrcEventsforUPHReporting */
static int hf_rrc_qoEMeasurementCollectionForStreamingServices;  /* T_qoEMeasurementCollectionForStreamingServices */
static int hf_rrc_qoEMeasurementCollectionForMTSIServices;  /* T_qoEMeasurementCollectionForMTSIServices */
static int hf_rrc_NonContiguousMultiCellCombinationList_item;  /* NonContiguousMultiCell */
static int hf_rrc_aggregatedCells;                /* T_aggregatedCells */
static int hf_rrc_gapSize_01;                     /* T_gapSize_01 */
static int hf_rrc_nonContiguousMultiCellCombination22;  /* T_nonContiguousMultiCellCombination22 */
static int hf_rrc_nonContiguousMultiCellCombination31_13;  /* T_nonContiguousMultiCellCombination31_13 */
static int hf_rrc_supportOfGSM;                   /* BOOLEAN */
static int hf_rrc_supportOfMulticarrier;          /* BOOLEAN */
static int hf_rrc_supportOfUTRAN_ToGERAN_NACC;    /* BOOLEAN */
static int hf_rrc_supportOfHandoverToGAN;         /* T_supportOfHandoverToGAN */
static int hf_rrc_supportOfPSHandoverToGAN;       /* T_supportOfPSHandoverToGAN */
static int hf_rrc_supportOfEUTRAFDD;              /* T_supportOfEUTRAFDD */
static int hf_rrc_supportOfInterRATHOToEUTRAFDD;  /* T_supportOfInterRATHOToEUTRAFDD */
static int hf_rrc_supportOfEUTRATDD;              /* T_supportOfEUTRATDD */
static int hf_rrc_supportOfInterRATHOToEUTRATDD;  /* T_supportOfInterRATHOToEUTRATDD */
static int hf_rrc_eutraFeatureGroupIndicators;    /* T_eutraFeatureGroupIndicators */
static int hf_rrc_eutraSupportOfMFBI;             /* T_eutraSupportOfMFBI */
static int hf_rrc_supportOfEUTRAFDDMeasurementReportingInCELLFACH;  /* T_supportOfEUTRAFDDMeasurementReportingInCELLFACH */
static int hf_rrc_supportOfEUTRATDDMeasurementReportingInCELLFACH;  /* T_supportOfEUTRATDDMeasurementReportingInCELLFACH */
static int hf_rrc_supportOfRAN_AssistedWLAN_Interworking_RAN_Rules;  /* T_supportOfRAN_AssistedWLAN_Interworking_RAN_Rules */
static int hf_rrc_supportOfRAN_AssistedWLAN_Interworking_ANDSF_Policies;  /* T_supportOfRAN_AssistedWLAN_Interworking_ANDSF_Policies */
static int hf_rrc_supportOfExtendedEUTRAFrequencyPriority;  /* T_supportOfExtendedEUTRAFrequencyPriority */
static int hf_rrc_supportOfIntraFreqSIAcquisitionForHO;  /* T_supportOfIntraFreqSIAcquisitionForHO */
static int hf_rrc_supportOfInterFreqSIAcquisitionForHO;  /* T_supportOfInterFreqSIAcquisitionForHO */
static int hf_rrc_supportOfE_UtraSIAcquisitionForHO;  /* T_supportOfE_UtraSIAcquisitionForHO */
static int hf_rrc_NetworkAssistedGANSS_Supported_List_item;  /* NetworkAssistedGANSS_Supported_List_item */
static int hf_rrc_gANSS_Id;                       /* T_gANSS_Id */
static int hf_rrc_gANSS_Mode;                     /* GANSS_Mode */
static int hf_rrc_gANSS_SignalId;                 /* GANSS_Signal_Id */
static int hf_rrc_supportForUE_GANSS_TimingOfCellFrames;  /* BOOLEAN */
static int hf_rrc_supportForUE_GANSS_CarrierPhaseMeasurement;  /* BOOLEAN */
static int hf_rrc_NetworkAssistedGANSS_Supported_List_v860ext_item;  /* NetworkAssistedGANSS_Supported_List_v860ext_item */
static int hf_rrc_sbas_Ids;                       /* BIT_STRING_SIZE_8 */
static int hf_rrc_gANSS_SignalIds;                /* BIT_STRING_SIZE_8 */
static int hf_rrc_non_native_AD_choices_supported;  /* T_non_native_AD_choices_supported */
static int hf_rrc_p_TMSI;                         /* P_TMSI_GSM_MAP */
static int hf_rrc_rai;                            /* RAI */
static int hf_rrc_cn_Identity;                    /* T_cn_Identity */
static int hf_rrc_cn_pagedUE_Identity;            /* CN_PagedUE_Identity */
static int hf_rrc_utran_Identity;                 /* T_utran_Identity */
static int hf_rrc_cn_OriginatedPage_connectedMode_UE;  /* T_cn_OriginatedPage_connectedMode_UE */
static int hf_rrc_utran_SingleUE_Identity;        /* T_utran_SingleUE_Identity */
static int hf_rrc_cn_OriginatedPage_connectedMode_UE_01;  /* T_cn_OriginatedPage_connectedMode_UE_01 */
static int hf_rrc_utran_GroupIdentity;            /* SEQUENCE_SIZE_1_maxURNTI_Group_OF_GroupIdentityWithReleaseInformation */
static int hf_rrc_utran_GroupIdentity_item;       /* GroupIdentityWithReleaseInformation */
static int hf_rrc_PagingRecordList_item;          /* PagingRecord */
static int hf_rrc_PagingRecord2List_r5_item;      /* PagingRecord2_r5 */
static int hf_rrc_losslessSRNS_RelocationSupport;  /* BOOLEAN */
static int hf_rrc_supportForRfc2507;              /* T_supportForRfc2507 */
static int hf_rrc_notSupported;                   /* NULL */
static int hf_rrc_supported_01;                   /* MaxHcContextSpace */
static int hf_rrc_supportForRfc3095;              /* T_supportForRfc3095 */
static int hf_rrc_supported_02;                   /* T_supported */
static int hf_rrc_maxROHC_ContextSessions;        /* MaxROHC_ContextSessions_r4 */
static int hf_rrc_reverseCompressionDepth;        /* INTEGER_0_65535 */
static int hf_rrc_supportForRfc3095ContextRelocation;  /* BOOLEAN */
static int hf_rrc_maxHcContextSpace;              /* MaxHcContextSpace_r5_ext */
static int hf_rrc_losslessDLRLC_PDUSizeChange;    /* T_losslessDLRLC_PDUSizeChange */
static int hf_rrc_supportForCSVoiceoverHSPA_01;   /* T_supportForCSVoiceoverHSPA_01 */
static int hf_rrc_fddPhysChCapability;            /* T_fddPhysChCapability */
static int hf_rrc_downlinkPhysChCapability;       /* DL_PhysChCapabilityFDD */
static int hf_rrc_uplinkPhysChCapability;         /* UL_PhysChCapabilityFDD */
static int hf_rrc_tddPhysChCapability;            /* T_tddPhysChCapability */
static int hf_rrc_downlinkPhysChCapability_01;    /* DL_PhysChCapabilityTDD */
static int hf_rrc_uplinkPhysChCapability_01;      /* UL_PhysChCapabilityTDD */
static int hf_rrc_fddPhysChCapability_01;         /* T_fddPhysChCapability_01 */
static int hf_rrc_downlinkPhysChCapability_02;    /* DL_PhysChCapabilityFDD_v770ext */
static int hf_rrc_uplinkPhysChCapability_02;      /* UL_PhysChCapabilityFDD_v770ext */
static int hf_rrc_tddPhysChCapability_384;        /* T_tddPhysChCapability_384 */
static int hf_rrc_uplinkPhysChCapability_03;      /* UL_PhysChCapabilityTDD_384_v770ext */
static int hf_rrc_tddPhysChCapability_768;        /* T_tddPhysChCapability_768 */
static int hf_rrc_downlinkPhysChCapability_03;    /* DL_PhysChCapabilityTDD_768 */
static int hf_rrc_uplinkPhysChCapability_04;      /* UL_PhysChCapabilityTDD_768 */
static int hf_rrc_tddPhysChCapability_128;        /* T_tddPhysChCapability_128 */
static int hf_rrc_downlinkPhysChCapability_04;    /* DL_PhysChCapabilityTDD_128_v770ext */
static int hf_rrc_uplinkPhysChCapability_05;      /* UL_PhysChCapabilityTDD_128_v770ext */
static int hf_rrc_fddPhysChCapability_02;         /* T_fddPhysChCapability_02 */
static int hf_rrc_downlinkPhysChCapability_05;    /* DL_PhysChCapabilityFDD_v860ext */
static int hf_rrc_tddPhysChCapability_128_01;     /* T_tddPhysChCapability_128_01 */
static int hf_rrc_downlinkPhysChCapability_06;    /* DL_PhysChCapabilityTDD_128_v860ext */
static int hf_rrc_fddPhysChCapability_03;         /* T_fddPhysChCapability_03 */
static int hf_rrc_downlinkPhysChCapability_07;    /* DL_PhysChCapabilityFDD_v920ext */
static int hf_rrc_uplinkPhysChCapability_06;      /* UL_PhysChCapabilityFDD_v920ext */
static int hf_rrc_fddPhysChCapability_04;         /* T_fddPhysChCapability_04 */
static int hf_rrc_downlinkPhysChCapability_08;    /* DL_PhysChCapabilityFDD_va40ext */
static int hf_rrc_tddPhysChCapability_128_02;     /* T_tddPhysChCapability_128_02 */
static int hf_rrc_downlinkPhysChCapability_09;    /* DL_PhysChCapabilityInfoTDD_128_va40ext */
static int hf_rrc_uplinkPhysChCapability_07;      /* UL_PhysChCapabilityInfoTDD_128_va40ext */
static int hf_rrc_fddPhysChCapability_05;         /* T_fddPhysChCapability_05 */
static int hf_rrc_downlinkPhysChCapability_10;    /* DL_PhysChCapabilityFDD_vb50ext */
static int hf_rrc_uplinkPhysChCapability_08;      /* UL_PhysChCapabilityFDD_vb50ext */
static int hf_rrc_fddPhysChCapability_06;         /* T_fddPhysChCapability_06 */
static int hf_rrc_downlinkPhysChCapability_11;    /* DL_PhysChCapabilityFDD_vb80ext */
static int hf_rrc_fddPhysChCapability_07;         /* T_fddPhysChCapability_07 */
static int hf_rrc_downlinkPhysChCapability_12;    /* DL_PhysChCapabilityFDD_vc50ext */
static int hf_rrc_uplinkPhysChCapability_09;      /* UL_PhysChCapabilityFDD_vc50ext */
static int hf_rrc_tddPhysChCapability_01;         /* T_tddPhysChCapability_01 */
static int hf_rrc_downlinkPhysChCapability_13;    /* DL_PhysChCapabilityInfoTDD_128_vc50ext */
static int hf_rrc_fddPhysChCapability_08;         /* T_fddPhysChCapability_08 */
static int hf_rrc_downlinkPhysChCapability_14;    /* DL_PhysChCapabilityFDD_vd20ext */
static int hf_rrc_uplinkPhysChCapability_10;      /* UL_PhysChCapabilityFDD_vd20ext */
static int hf_rrc_fddPhysChCapability_09;         /* T_fddPhysChCapability_09 */
static int hf_rrc_downlinkPhysChCapability_15;    /* DL_PhysChCapabilityFDD_ve30ext */
static int hf_rrc_uplinkPhysChCapability_11;      /* UL_PhysChCapabilityFDD_ve30ext */
static int hf_rrc_tddPhysChCapability_768_01;     /* T_tddPhysChCapability_768_01 */
static int hf_rrc_downlinkPhysChCapability_16;    /* DL_PhysChCapabilityInfoTDD_768 */
static int hf_rrc_tddPhysChCapability_128_03;     /* T_tddPhysChCapability_128_03 */
static int hf_rrc_uplinkPhysChCapability_12;      /* UL_PhysChCapabilityInfoTDD_128_v770ext */
static int hf_rrc_fddPhysChCapability_10;         /* T_fddPhysChCapability_10 */
static int hf_rrc_downlinkPhysChCapability_17;    /* DL_PhysChCapabilityFDD_vf10ext */
static int hf_rrc_tdd128_PhysChCapability;        /* T_tdd128_PhysChCapability */
static int hf_rrc_downlinkPhysChCapability_18;    /* DL_PhysChCapabilityTDD_LCR_r4 */
static int hf_rrc_uplinkPhysChCapability_13;      /* UL_PhysChCapabilityTDD_LCR_r4 */
static int hf_rrc_fdd_hspdsch;                    /* T_fdd_hspdsch */
static int hf_rrc_supported_03;                   /* T_supported_01 */
static int hf_rrc_hsdsch_physical_layer_category;  /* HSDSCH_physical_layer_category */
static int hf_rrc_tdd384_hspdsch;                 /* T_tdd384_hspdsch */
static int hf_rrc_tdd128_hspdsch;                 /* T_tdd128_hspdsch */
static int hf_rrc_numberOfRepetitionsPerSFNPeriod;  /* T_numberOfRepetitionsPerSFNPeriod */
static int hf_rrc_supportEUTRA_FDD;               /* BOOLEAN */
static int hf_rrc_supportEUTRA_TDD;               /* BOOLEAN */
static int hf_rrc_noError;                        /* NULL */
static int hf_rrc_errorOccurred;                  /* T_errorOccurred */
static int hf_rrc_protocolErrorInformation_01;    /* ProtocolErrorInformation */
static int hf_rrc_diagnosticsType;                /* T_diagnosticsType */
static int hf_rrc_type1;                          /* T_type1 */
static int hf_rrc_asn1_ViolationOrEncodingError;  /* NULL */
static int hf_rrc_messageTypeNonexistent;         /* NULL */
static int hf_rrc_messageNotCompatibleWithReceiverState;  /* IdentificationOfReceivedMessage */
static int hf_rrc_ie_ValueNotComprehended;        /* IdentificationOfReceivedMessage */
static int hf_rrc_conditionalInformationElementError;  /* IdentificationOfReceivedMessage */
static int hf_rrc_messageExtensionNotComprehended;  /* IdentificationOfReceivedMessage */
static int hf_rrc_RadioFrequencyBandTDDextList_item;  /* RadioFrequencyBandTDDext */
static int hf_rrc_t314_expired;                   /* BOOLEAN */
static int hf_rrc_t315_expired;                   /* BOOLEAN */
static int hf_rrc_interRATInfo;                   /* InterRATInfo */
static int hf_rrc_interRATInfo_01;                /* InterRATInfo_r6 */
static int hf_rrc_frequencyInfo_03;               /* NULL */
static int hf_rrc_interRATInfo_02;                /* InterRATInfo_v860ext */
static int hf_rrc_fddRF_Capability;               /* T_fddRF_Capability */
static int hf_rrc_ue_PowerClass;                  /* UE_PowerClass */
static int hf_rrc_txRxFrequencySeparation;        /* TxRxFrequencySeparation */
static int hf_rrc_tddRF_Capability;               /* T_tddRF_Capability */
static int hf_rrc_radioFrequencyTDDBandList;      /* RadioFrequencyBandTDDList */
static int hf_rrc_chipRateCapability;             /* ChipRateCapability */
static int hf_rrc_tddRF_Capability_01;            /* T_tddRF_Capability_01 */
static int hf_rrc_radioFrequencyBandTDDList;      /* RadioFrequencyBandTDDList */
static int hf_rrc_tdd384RF_Capability;            /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd768RF_Capability;            /* T_tdd768RF_Capability */
static int hf_rrc_radioFrequencyBandTDDList_01;   /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd128RF_Capability;            /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd128RF_Capability_01;         /* RadioFrequencyBandTDDextList */
static int hf_rrc_tdd384RF_Capability_01;         /* RadioFrequencyBandTDDextList */
static int hf_rrc_tdd768RF_Capability_01;         /* RadioFrequencyBandTDDextList */
static int hf_rrc_supportOfMFBI;                  /* T_supportOfMFBI */
static int hf_rrc_totalRLC_AM_BufferSize;         /* TotalRLC_AM_BufferSize */
static int hf_rrc_maximumRLC_WindowSize;          /* MaximumRLC_WindowSize */
static int hf_rrc_maximumAM_EntityNumber;         /* MaximumAM_EntityNumberRLC_Cap */
static int hf_rrc_totalRLC_AM_BufferSize_01;      /* TotalRLC_AM_BufferSize_r5_ext */
static int hf_rrc_supportOfTwoLogicalChannel;     /* BOOLEAN */
static int hf_rrc_totalRLC_AM_BufferSize_02;      /* TotalRLC_AM_BufferSize_v920ext */
static int hf_rrc_totalRLC_AM_BufferSize_03;      /* TotalRLC_AM_BufferSize_va40ext */
static int hf_rrc_totalRLC_AM_BufferSize_04;      /* TotalRLC_AM_BufferSize_vb50ext */
static int hf_rrc_noRelease;                      /* NULL */
static int hf_rrc_release;                        /* T_release */
static int hf_rrc_RRC_MessageSequenceNumberList_item;  /* RRC_MessageSequenceNumber */
static int hf_rrc_nonce;                          /* BIT_STRING_SIZE_128 */
static int hf_rrc_ims_Information;                /* T_ims_Information */
static int hf_rrc_cipheringAlgorithmCap;          /* T_cipheringAlgorithmCap */
static int hf_rrc_integrityProtectionAlgorithmCap;  /* T_integrityProtectionAlgorithmCap */
static int hf_rrc_primary_E_RNTI;                 /* E_RNTI */
static int hf_rrc_secondary_E_RNTI;               /* E_RNTI */
static int hf_rrc_scramblingCodeType;             /* ScramblingCodeType */
static int hf_rrc_scramblingCodeNumber;           /* UL_ScramblingCode */
static int hf_rrc_ms2_SchedTransmGrantHARQAlloc;  /* BIT_STRING_SIZE_8 */
static int hf_rrc_servingGrant;                   /* T_servingGrant */
static int hf_rrc_primary_Secondary_GrantSelector;  /* T_primary_Secondary_GrantSelector */
static int hf_rrc_minReduced_E_DPDCH_GainFactor;  /* MinReduced_E_DPDCH_GainFactor */
static int hf_rrc_e_DCH_minimumSet_E_TFCI;        /* E_DCH_MinimumSet_E_TFCI */
static int hf_rrc_dpcchPowerOffset_SecondaryULFrequency;  /* INTEGER_0_7 */
static int hf_rrc_pc_Preamble;                    /* PC_Preamble */
static int hf_rrc_servingGrant_01;                /* T_servingGrant_01 */
static int hf_rrc_primary_Secondary_GrantSelector_01;  /* T_primary_Secondary_GrantSelector_01 */
static int hf_rrc_minimumTEBS_threshold;          /* MinimumTEBS_threshold */
static int hf_rrc_implicitGrantHandling;          /* T_implicitGrantHandling */
static int hf_rrc_ue_DPCCHPowerResetAfterDTXOnSecUplink;  /* UE_DPCCHPowerResetAfterDTXOnSecUplink */
static int hf_rrc_servingGrant_02;                /* T_servingGrant_02 */
static int hf_rrc_primary_Secondary_GrantSelector_02;  /* T_primary_Secondary_GrantSelector_02 */
static int hf_rrc_implicitGrantHandling_01;       /* T_implicitGrantHandling_01 */
static int hf_rrc_additionalSecondaryCellInfoForMixedTTIConfiguration;  /* AdditionalSecondaryCellInfoForMixedTTIConfiguration */
static int hf_rrc_deltaACK;                       /* DeltaACK */
static int hf_rrc_deltaNACK;                      /* DeltaNACK */
static int hf_rrc_dl_hspdsch_Information;         /* DL_HSPDSCH_Information */
static int hf_rrc_harqInfo_03;                    /* HARQ_Info */
static int hf_rrc_mac_hsResetIndicator;           /* T_mac_hsResetIndicator */
static int hf_rrc_dl_hspdsch_Information_01;      /* DL_HSPDSCH_Information_r7 */
static int hf_rrc_mac_hsResetIndicator_01;        /* T_mac_hsResetIndicator_01 */
static int hf_rrc_dl_hspdsch_Information_02;      /* DL_HSPDSCH_Information_r8 */
static int hf_rrc_mac_hsResetIndicator_02;        /* T_mac_hsResetIndicator_02 */
static int hf_rrc_dl_hspdsch_Information_03;      /* DL_HSPDSCH_Information_r9 */
static int hf_rrc_mac_hsResetIndicator_03;        /* T_mac_hsResetIndicator_03 */
static int hf_rrc_deltaACK_01;                    /* DeltaACK_r11 */
static int hf_rrc_deltaNACK_01;                   /* DeltaNACK_r11 */
static int hf_rrc_dl_hspdsch_Information_04;      /* DL_HSPDSCH_Information_r11 */
static int hf_rrc_mac_hsResetIndicator_04;        /* T_mac_hsResetIndicator_04 */
static int hf_rrc_mac_hsResetIndicator_assisting;  /* T_mac_hsResetIndicator_assisting */
static int hf_rrc_dl_hspdsch_Information_05;      /* DL_HSPDSCH_Information_r12 */
static int hf_rrc_mac_hsResetIndicator_05;        /* T_mac_hsResetIndicator_05 */
static int hf_rrc_mac_hsResetIndicator_assisting_01;  /* T_mac_hsResetIndicator_assisting_01 */
static int hf_rrc_supported_04;                   /* T_supported_02 */
static int hf_rrc_maxNoSCCPCH_RL;                 /* MaxNoSCCPCH_RL */
static int hf_rrc_simultaneousSCCPCH_DPCH_DPDCH_Reception;  /* BOOLEAN */
static int hf_rrc_rab_InfoReplace;                /* RAB_InfoReplace */
static int hf_rrc_STARTList_item;                 /* STARTSingle */
static int hf_rrc_SystemSpecificCapUpdateReqList_item;  /* SystemSpecificCapUpdateReq */
static int hf_rrc_SystemSpecificCapUpdateReqList_r5_item;  /* SystemSpecificCapUpdateReq_r5 */
static int hf_rrc_SystemSpecificCapUpdateReqList_r8_item;  /* SystemSpecificCapUpdateReq_r8 */
static int hf_rrc_tmsi;                           /* TMSI_GSM_MAP */
static int hf_rrc_dl_TransChCapability;           /* DL_TransChCapability */
static int hf_rrc_ul_TransChCapability;           /* UL_TransChCapability */
static int hf_rrc_supported_05;                   /* MaxNoBits */
static int hf_rrc_srnc_Identity;                  /* SRNC_Identity */
static int hf_rrc_s_RNTI;                         /* S_RNTI */
static int hf_rrc_all;                            /* NULL */
static int hf_rrc_u_RNTI_BitMaskIndex_b1;         /* BIT_STRING_SIZE_31 */
static int hf_rrc_u_RNTI_BitMaskIndex_b2;         /* BIT_STRING_SIZE_30 */
static int hf_rrc_u_RNTI_BitMaskIndex_b3;         /* BIT_STRING_SIZE_29 */
static int hf_rrc_u_RNTI_BitMaskIndex_b4;         /* BIT_STRING_SIZE_28 */
static int hf_rrc_u_RNTI_BitMaskIndex_b5;         /* BIT_STRING_SIZE_27 */
static int hf_rrc_u_RNTI_BitMaskIndex_b6;         /* BIT_STRING_SIZE_26 */
static int hf_rrc_u_RNTI_BitMaskIndex_b7;         /* BIT_STRING_SIZE_25 */
static int hf_rrc_u_RNTI_BitMaskIndex_b8;         /* BIT_STRING_SIZE_24 */
static int hf_rrc_u_RNTI_BitMaskIndex_b9;         /* BIT_STRING_SIZE_23 */
static int hf_rrc_u_RNTI_BitMaskIndex_b10;        /* BIT_STRING_SIZE_22 */
static int hf_rrc_u_RNTI_BitMaskIndex_b11;        /* BIT_STRING_SIZE_21 */
static int hf_rrc_u_RNTI_BitMaskIndex_b12;        /* BIT_STRING_SIZE_20 */
static int hf_rrc_u_RNTI_BitMaskIndex_b13;        /* BIT_STRING_SIZE_19 */
static int hf_rrc_u_RNTI_BitMaskIndex_b14;        /* BIT_STRING_SIZE_18 */
static int hf_rrc_u_RNTI_BitMaskIndex_b15;        /* BIT_STRING_SIZE_17 */
static int hf_rrc_u_RNTI_BitMaskIndex_b16;        /* BIT_STRING_SIZE_16 */
static int hf_rrc_u_RNTI_BitMaskIndex_b17;        /* BIT_STRING_SIZE_15 */
static int hf_rrc_u_RNTI_BitMaskIndex_b18;        /* BIT_STRING_SIZE_14 */
static int hf_rrc_u_RNTI_BitMaskIndex_b19;        /* BIT_STRING_SIZE_13 */
static int hf_rrc_u_RNTI_BitMaskIndex_b20;        /* BIT_STRING_SIZE_12 */
static int hf_rrc_u_RNTI_BitMaskIndex_b21;        /* BIT_STRING_SIZE_11 */
static int hf_rrc_u_RNTI_BitMaskIndex_b22;        /* BIT_STRING_SIZE_10 */
static int hf_rrc_u_RNTI_BitMaskIndex_b23;        /* BIT_STRING_SIZE_9 */
static int hf_rrc_u_RNTI_BitMaskIndex_b24;        /* BIT_STRING_SIZE_8 */
static int hf_rrc_u_RNTI_BitMaskIndex_b25;        /* BIT_STRING_SIZE_7 */
static int hf_rrc_u_RNTI_BitMaskIndex_b26;        /* BIT_STRING_SIZE_6 */
static int hf_rrc_u_RNTI_BitMaskIndex_b27;        /* BIT_STRING_SIZE_5 */
static int hf_rrc_u_RNTI_BitMaskIndex_b28;        /* BIT_STRING_SIZE_4 */
static int hf_rrc_u_RNTI_BitMaskIndex_b29;        /* BIT_STRING_SIZE_3 */
static int hf_rrc_u_RNTI_BitMaskIndex_b30;        /* BIT_STRING_SIZE_2 */
static int hf_rrc_u_RNTI_BitMaskIndex_b31;        /* BIT_STRING_SIZE_1 */
static int hf_rrc_s_RNTI_2;                       /* S_RNTI_2 */
static int hf_rrc_UE_AddPos_Supported_List_item;  /* UE_AddPos_element */
static int hf_rrc_addPos_ID;                      /* T_addPos_ID */
static int hf_rrc_addPos_Mode;                    /* T_addPos_Mode */
static int hf_rrc_supportOfLoggedMeasurementsIdlePCH;  /* T_supportOfLoggedMeasurementsIdlePCH */
static int hf_rrc_ue_RadioAccessCapability_v690ext;  /* UE_RadioAccessCapability_v690ext */
static int hf_rrc_ue_RATSpecificCapability_v690ext;  /* InterRAT_UE_RadioAccessCapability_v690ext */
static int hf_rrc_v6b0NonCriticalExtensions_15;   /* T_v6b0NonCriticalExtensions_14 */
static int hf_rrc_ue_RadioAccessCapability_v6b0ext;  /* UE_RadioAccessCapability_v6b0ext_IEs */
static int hf_rrc_v6e0NonCriticalExtensions_02;   /* T_v6e0NonCriticalExtensions_02 */
static int hf_rrc_ue_RadioAccessCapability_v6e0ext;  /* UE_RadioAccessCapability_v6e0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_39;   /* T_v770NonCriticalExtensions_39 */
static int hf_rrc_ue_RadioAccessCapability_v770ext;  /* UE_RadioAccessCapability_v770ext_IEs */
static int hf_rrc_v790NonCriticalExtensions_01;   /* T_v790NonCriticalExtensions_01 */
static int hf_rrc_ue_RadioAccessCapability_v790ext;  /* UE_RadioAccessCapability_v790ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_25;   /* T_v860NonCriticalExtensions_25 */
static int hf_rrc_ue_RadioAccessCapability_v860ext;  /* UE_RadioAccessCapability_v860ext_IEs */
static int hf_rrc_ue_RATSpecificCapability_v860ext;  /* InterRAT_UE_RadioAccessCapability_v860ext */
static int hf_rrc_v880NonCriticalExtensions_01;   /* T_v880NonCriticalExtensions_01 */
static int hf_rrc_ue_RadioAccessCapability_v880ext;  /* UE_RadioAccessCapability_v880ext_IEs */
static int hf_rrc_v890NonCriticalExtensions_10;   /* T_v890NonCriticalExtensions_10 */
static int hf_rrc_ue_RadioAccessCapability_v890ext;  /* UE_RadioAccessCapability_v890ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_03;   /* T_v920NonCriticalExtensions_03 */
static int hf_rrc_ue_RadioAccessCapability_v920ext;  /* UE_RadioAccessCapability_v920ext_IEs */
static int hf_rrc_v970NonCriticalExtensions_03;   /* T_v970NonCriticalExtensions_03 */
static int hf_rrc_ue_RadioAccessCapability_v970ext;  /* UE_RadioAccessCapability_v970ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_18;   /* T_va40NonCriticalExtensions_17 */
static int hf_rrc_ue_RadioAccessCapability_va40ext;  /* UE_RadioAccessCapability_va40ext_IEs */
static int hf_rrc_va60NonCriticalExtensions;      /* T_va60NonCriticalExtensions */
static int hf_rrc_ue_RadioAccessCapability_va60ext;  /* UE_RadioAccessCapability_va60ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_01;   /* T_va80NonCriticalExtensions_01 */
static int hf_rrc_ue_RadioAccessCapability_va80ext;  /* UE_RadioAccessCapability_va80ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_69;  /* UE_RadioAccessCapability_LaterNonCriticalExtensions */
static int hf_rrc_supportForSIB11bis_01;          /* T_supportForSIB11bis_01 */
static int hf_rrc_supportForFDPCH_02;             /* T_supportForFDPCH_02 */
static int hf_rrc_pdcp_Capability_01;             /* PDCP_Capability_v770ext */
static int hf_rrc_rlc_Capability;                 /* RLC_Capability_v770ext */
static int hf_rrc_rf_Capability;                  /* RF_Capability_v770ext */
static int hf_rrc_physicalChannelCapability;      /* PhysicalChannelCapability_v770ext */
static int hf_rrc_multiModeRAT_Capability;        /* MultiModeRAT_Capability_v770ext */
static int hf_rrc_ue_PositioningCapability;       /* UE_PositioningCapability_v770ext */
static int hf_rrc_mac_ehsSupport_01;              /* T_mac_ehsSupport_01 */
static int hf_rrc_ue_specificCapabilityInformation;  /* UE_SpecificCapabilityInformation_LCRTDD */
static int hf_rrc_supportForEDPCCHPowerBoosting_01;  /* T_supportForEDPCCHPowerBoosting_01 */
static int hf_rrc_rf_Capability_01;               /* RF_Capability_v860ext */
static int hf_rrc_physicalChannelCapability_01;   /* PhysicalChannelCapability_v860ext */
static int hf_rrc_multiModeRAT_Capability_01;     /* MultiModeRAT_Capability_v860ext */
static int hf_rrc_ue_PositioningCapability_01;    /* UE_PositioningCapability_v860ext */
static int hf_rrc_measurementCapability;          /* MeasurementCapability_v860ext */
static int hf_rrc_measurementCapabilityTDD;       /* MeasurementCapabilityTDD */
static int hf_rrc_supportOfCommonEDCH_04;         /* T_supportOfCommonEDCH_04 */
static int hf_rrc_supportOfMACiis_04;             /* T_supportOfMACiis_04 */
static int hf_rrc_supportOfSPSOperation_02;       /* T_supportOfSPSOperation_02 */
static int hf_rrc_supportOfControlChannelDRXOperation_01;  /* T_supportOfControlChannelDRXOperation_01 */
static int hf_rrc_supportOfCSG_01;                /* T_supportOfCSG_01 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList3;  /* UE_RadioAccessCapabBandFDDList3 */
static int hf_rrc_supportForPriorityReselectionInUTRAN;  /* T_supportForPriorityReselectionInUTRAN */
static int hf_rrc_supportCellSpecificTxDiversityinDC_Operation;  /* T_supportCellSpecificTxDiversityinDC_Operation */
static int hf_rrc_ue_RadioAccessCapabBandCombList;  /* UE_RadioAccessCapabBandCombList */
static int hf_rrc_physicalChannelCapability_02;   /* PhysicalChannelCapability_v920ext */
static int hf_rrc_rlc_Capability_01;              /* RLC_Capability_v920ext */
static int hf_rrc_supportOfenhancedTS0;           /* T_supportOfenhancedTS0 */
static int hf_rrc_measurementCapability_01;       /* MeasurementCapability_v920ext */
static int hf_rrc_csgProximityIndicationCapability;  /* CSG_ProximityIndicationCapability */
static int hf_rrc_neighCellSI_AcquisitionCapability;  /* NeighCellSI_AcquisitionCapability */
static int hf_rrc_ue_ExtendedMeasurementSupport;  /* T_ue_ExtendedMeasurementSupport */
static int hf_rrc_voiceOverUTRA_PS_HS_Support;    /* T_voiceOverUTRA_PS_HS_Support */
static int hf_rrc_srvcc_SupportFromUTRA_to_UTRA;  /* T_srvcc_SupportFromUTRA_to_UTRA */
static int hf_rrc_srvcc_SupportFromUTRA_to_GERAN;  /* T_srvcc_SupportFromUTRA_to_GERAN */
static int hf_rrc_ue_supportMac_ehsWindowSizeExtension;  /* T_ue_supportMac_ehsWindowSizeExtension */
static int hf_rrc_v9c0NonCriticalExtensions_12;   /* T_v9c0NonCriticalExtensions_12 */
static int hf_rrc_ue_RadioAccessCapability_v9c0ext;  /* UE_RadioAccessCapability_v9c0ext_IEs */
static int hf_rrc_vaa0NonCriticalExtensions_02;   /* T_vaa0NonCriticalExtensions_02 */
static int hf_rrc_ue_RadioAccessCapability_vaa0ext;  /* UE_RadioAccessCapability_vaa0ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_23;   /* T_vb50NonCriticalExtensions_23 */
static int hf_rrc_ue_RadioAccessCapability_vb50ext;  /* UE_RadioAccessCapability_vb50ext_IEs */
static int hf_rrc_vb70NonCriticalExtensions_01;   /* T_vb70NonCriticalExtensions_01 */
static int hf_rrc_ue_RadioAccessCapability_vb70ext;  /* UE_RadioAccessCapability_vb70ext_IEs */
static int hf_rrc_vae0NonCriticalExtensions;      /* T_vae0NonCriticalExtensions */
static int hf_rrc_ue_RadioAccessCapability_vae0ext;  /* UE_RadioAccessCapability_vae0ext_IEs */
static int hf_rrc_vb80NonCriticalExtensions;      /* T_vb80NonCriticalExtensions */
static int hf_rrc_ue_RadioAccessCapability_vb80ext;  /* UE_RadioAccessCapability_vb80ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_10;   /* T_vc50NonCriticalExtensions_10 */
static int hf_rrc_ue_RadioAccessCapability_vc50ext;  /* UE_RadioAccessCapability_vc50ext_IEs */
static int hf_rrc_vd20NonCriticalExtensions_03;   /* T_vd20NonCriticalExtensions_03 */
static int hf_rrc_ue_RadioAccessCapability_vd20ext;  /* UE_RadioAccessCapability_vd20ext_IEs */
static int hf_rrc_ve30NonCriticalExtensions_02;   /* UE_RadioAccessCapability_ve30ext_IEs */
static int hf_rrc_ue_RadioAccessCapabBandCombList_va40ext;  /* UE_RadioAccessCapabBandCombList_va40ext */
static int hf_rrc_physicalChannelCapability_03;   /* PhysicalChannelCapability_va40ext */
static int hf_rrc_rlc_Capability_02;              /* RLC_Capability_va40ext */
static int hf_rrc_measurementCapability_02;       /* MeasurementCapability_va40ext */
static int hf_rrc_supportOfMUMIMO;                /* T_supportOfMUMIMO */
static int hf_rrc_supportForDualCellMimoInDifferentBands;  /* T_supportForDualCellMimoInDifferentBands */
static int hf_rrc_ue_BasedNetworkPerformanceMeasurementsParameters;  /* UE_BasedNetworkPerformanceMeasurementsParameters */
static int hf_rrc_supportOfUTRANANR;              /* T_supportOfUTRANANR */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4;  /* UE_RadioAccessCapabBandFDDList4 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4_01;  /* UE_RadioAccessCapabBandFDDList4_va60ext */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4_02;  /* UE_RadioAccessCapabBandFDDList4_va80ext */
static int hf_rrc_supportOfUMRLCre_establish_via_reconfig;  /* T_supportOfUMRLCre_establish_via_reconfig */
static int hf_rrc_rf_capability;                  /* RF_Capability_vaa0ext */
static int hf_rrc_multiModeRAT_Capability_02;     /* MultiModeRAT_Capability_vae0ext */
static int hf_rrc_multiModeRAT_Capability_03;     /* MultiModeRAT_Capability_vb50ext */
static int hf_rrc_supportOfCommonERGCHBasedInterferenceControl;  /* T_supportOfCommonERGCHBasedInterferenceControl */
static int hf_rrc_supportOfFallbackToR99PRACH;    /* T_supportOfFallbackToR99PRACH */
static int hf_rrc_supportOfConcurrentDeployment;  /* T_supportOfConcurrentDeployment */
static int hf_rrc_supportOfTTIalignmentAndPerHARQProcess;  /* T_supportOfTTIalignmentAndPerHARQProcess */
static int hf_rrc_ue_RadioAccessCapabBandCombList_vb50ext;  /* UE_RadioAccessCapabBandCombList_vb50ext */
static int hf_rrc_multiflowCapabBandCombList;     /* MultiflowCapabBandCombList */
static int hf_rrc_physicalChannelCapability_04;   /* PhysicalChannelCapability_vb50ext */
static int hf_rrc_rlc_Capability_03;              /* RLC_Capability_vb50ext */
static int hf_rrc_multiflowCapability;            /* MultiflowCapability */
static int hf_rrc_ue_RadioAccessCapabBandFDDList6;  /* UE_RadioAccessCapabBandFDDList6 */
static int hf_rrc_measurementCapability_03;       /* MeasurementCapability_vb50ext */
static int hf_rrc_measurementCapabilityTDD_01;    /* MeasurementCapabilityTDD_vb50ext */
static int hf_rrc_rsrvcc_SupportFromUTRA_CS_to_EUTRA_FDD;  /* T_rsrvcc_SupportFromUTRA_CS_to_EUTRA_FDD */
static int hf_rrc_rsrvcc_SupportFromUTRA_CS_to_EUTRA_TDD;  /* T_rsrvcc_SupportFromUTRA_CS_to_EUTRA_TDD */
static int hf_rrc_supportOfHSDPCCHPowerOffsetExtension;  /* T_supportOfHSDPCCHPowerOffsetExtension */
static int hf_rrc_supportOfSTTDOnDLControlChannelsWhenMultiflowOperationIsActive;  /* T_supportOfSTTDOnDLControlChannelsWhenMultiflowOperationIsActive */
static int hf_rrc_measurementCapability_04;       /* MeasurementCapability_vb70ext */
static int hf_rrc_ue_RadioAccessCapabBandFDDList7;  /* UE_RadioAccessCapabBandFDDList7 */
static int hf_rrc_physicalChannelCapability_05;   /* PhysicalChannelCapability_vb80ext */
static int hf_rrc_measurementCapability_05;       /* MeasurementCapability_vc50ext */
static int hf_rrc_supportofDsacAndPpacInCellDch;  /* T_supportofDsacAndPpacInCellDch */
static int hf_rrc_supportOfMultiflowWithFTPICHFromAssisting;  /* T_supportOfMultiflowWithFTPICHFromAssisting */
static int hf_rrc_multiModeRAT_Capability_04;     /* MultiModeRAT_Capability_vc50ext */
static int hf_rrc_physicalChannelCapability_06;   /* PhysicalChannelCapability_vc50ext */
static int hf_rrc_ue_RadioAccessCapabBandCombList_01;  /* UE_RadioAccessCapabBandCombList_vd20ext */
static int hf_rrc_multiModeRAT_Capability_05;     /* MultiModeRAT_Capability_vd20ext */
static int hf_rrc_physicalChannelCapability_07;   /* PhysicalChannelCapability_vd20ext */
static int hf_rrc_ue_PositioningCapability_02;    /* UE_PositioningCapability_vd20ext */
static int hf_rrc_supportofRetrievableConfigurations;  /* T_supportofRetrievableConfigurations */
static int hf_rrc_supportofURAPCHwithSeamlessTransition;  /* T_supportofURAPCHwithSeamlessTransition */
static int hf_rrc_supportofImprovedSynchronizedRRCProcedures;  /* T_supportofImprovedSynchronizedRRCProcedures */
static int hf_rrc_supportofEnhancedStateTransition;  /* T_supportofEnhancedStateTransition */
static int hf_rrc_measurementCapability_06;       /* MeasurementCapability_ve30ext */
static int hf_rrc_supportofSimultaneousSetupandReleaseofRABsRBs;  /* T_supportofSimultaneousSetupandReleaseofRABsRBs */
static int hf_rrc_physicalChannelCapability_08;   /* PhysicalChannelCapability_ve30ext */
static int hf_rrc_ue_RadioAccessCapability_vf10ext;  /* UE_RadioAccessCapability_vf10ext_IEs */
static int hf_rrc_physicalChannelCapability_09;   /* PhysicalChannelCapability_vf10ext */
static int hf_rrc_ue_RadioAccessCapability_vf20ext_IEs;  /* UE_RadioAccessCapability_vf20ext_IEs */
static int hf_rrc_measurementCapability_07;       /* MeasurementCapability_vf20ext */
static int hf_rrc_nonCriticalExtensions_225;      /* T_nonCriticalExtensions_225 */
static int hf_rrc_t_301;                          /* T_301 */
static int hf_rrc_n_301;                          /* N_301 */
static int hf_rrc_t_302;                          /* T_302 */
static int hf_rrc_n_302;                          /* N_302 */
static int hf_rrc_t_304;                          /* T_304 */
static int hf_rrc_n_304;                          /* N_304 */
static int hf_rrc_t_305;                          /* T_305 */
static int hf_rrc_t_307;                          /* T_307 */
static int hf_rrc_t_308;                          /* T_308 */
static int hf_rrc_t_309;                          /* T_309 */
static int hf_rrc_t_310;                          /* T_310 */
static int hf_rrc_n_310;                          /* N_310 */
static int hf_rrc_t_311;                          /* T_311 */
static int hf_rrc_t_312;                          /* T_312 */
static int hf_rrc_n_312;                          /* N_312 */
static int hf_rrc_t_313;                          /* T_313 */
static int hf_rrc_n_313;                          /* N_313 */
static int hf_rrc_t_314;                          /* T_314 */
static int hf_rrc_t_315;                          /* T_315 */
static int hf_rrc_n_315;                          /* N_315 */
static int hf_rrc_t_316;                          /* T_316 */
static int hf_rrc_t_317;                          /* T_317 */
static int hf_rrc_n_312_01;                       /* N_312ext */
static int hf_rrc_n_315_01;                       /* N_315ext */
static int hf_rrc_n_312_02;                       /* N_312_r5 */
static int hf_rrc_n_315_02;                       /* N_315_r5 */
static int hf_rrc_t_323;                          /* T_323 */
static int hf_rrc_networkAssistedGANSS_supportedList;  /* NetworkAssistedGANSS_Supported_List */
static int hf_rrc_networkAssistedGANSS_supportedList_01;  /* NetworkAssistedGANSS_Supported_List_v860ext */
static int hf_rrc_t_300;                          /* T_300 */
static int hf_rrc_n_300;                          /* N_300 */
static int hf_rrc_multiRAT_CapabilityList;        /* MultiRAT_Capability */
static int hf_rrc_multiModeCapability;            /* MultiModeCapability */
static int hf_rrc_pdcp_Capability_02;             /* PDCP_Capability */
static int hf_rrc_rlc_Capability_04;              /* RLC_Capability */
static int hf_rrc_transportChannelCapability;     /* TransportChannelCapability */
static int hf_rrc_rf_Capability_02;               /* RF_Capability */
static int hf_rrc_physicalChannelCapability_10;   /* PhysicalChannelCapability */
static int hf_rrc_ue_MultiModeRAT_Capability;     /* UE_MultiModeRAT_Capability */
static int hf_rrc_ue_positioning_Capability;      /* UE_Positioning_Capability */
static int hf_rrc_measurementCapability_08;       /* MeasurementCapability */
static int hf_rrc_ue_RadioAccessCapabBandFDDList;  /* UE_RadioAccessCapabBandFDDList */
static int hf_rrc_ue_PositioningCapabilityExt_v380;  /* UE_PositioningCapabilityExt_v380 */
static int hf_rrc_ue_PositioningCapabilityExt_v3a0;  /* UE_PositioningCapabilityExt_v3a0 */
static int hf_rrc_ue_PositioningCapabilityExt_v3g0;  /* UE_PositioningCapabilityExt_v3g0 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList2;  /* UE_RadioAccessCapabBandFDDList2 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList_ext;  /* UE_RadioAccessCapabBandFDDList_ext */
static int hf_rrc_physicalchannelcapability_edch;  /* PhysicalChannelCapability_edch_r6 */
static int hf_rrc_deviceType;                     /* T_deviceType */
static int hf_rrc_supportForTwoDRXSchemesInPCH_02;  /* T_supportForTwoDRXSchemesInPCH_02 */
static int hf_rrc_supportEDPDCHPowerInterpolation;  /* T_supportEDPDCHPowerInterpolation */
static int hf_rrc_supportofTxDivOnNonMIMOChannel;  /* T_supportofTxDivOnNonMIMOChannel */
static int hf_rrc_physicalChannelCapability_LCR;  /* PhysicalChannelCapability_LCR_r4 */
static int hf_rrc_ue_RadioAccessCapabilityComp_TDD128;  /* UE_RadioAccessCapabilityComp_TDD128_v7f0ext */
static int hf_rrc_physicalChannelCapability_11;   /* PhysicalChannelCapabilityInfo_v770ext */
static int hf_rrc_ganssSupportIndication;         /* T_ganssSupportIndication */
static int hf_rrc_mac_ehsSupport_02;              /* T_mac_ehsSupport_02 */
static int hf_rrc_ue_SpecificCapabilityInformation;  /* UE_SpecificCapabilityInformation_LCRTDD */
static int hf_rrc_supportForPriorityReselectionInUTRAN_01;  /* T_supportForPriorityReselectionInUTRAN_01 */
static int hf_rrc_supportOfenhancedTS0_01;        /* T_supportOfenhancedTS0_01 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4_va60ext;  /* UE_RadioAccessCapabBandFDDList4_va60ext */
static int hf_rrc_ue_RadioAccessCapabBandFDDList4_va80ext;  /* UE_RadioAccessCapabBandFDDList4_va80ext */
static int hf_rrc_interRATsupportMultiCellConfiguration;  /* T_interRATsupportMultiCellConfiguration */
static int hf_rrc_ue_RadioAccessCapabBandFDDList5;  /* UE_RadioAccessCapabBandFDDList5 */
static int hf_rrc_ue_RadioAccessCapabBandFDDList_ext2;  /* UE_RadioAccessCapabBandFDDList_ext2 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList2_item;  /* UE_RadioAccessCapabBandFDD2 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList3_item;  /* UE_RadioAccessCapabBandFDD3 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList4_item;  /* UE_RadioAccessCapabBandFDD4 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList4_va60ext_item;  /* UE_RadioAccessCapabBandFDD4_va60ext */
static int hf_rrc_UE_RadioAccessCapabBandFDDList4_va80ext_item;  /* UE_RadioAccessCapabBandFDD4_va80ext */
static int hf_rrc_UE_RadioAccessCapabBandFDDList5_item;  /* UE_RadioAccessCapabBandFDD5 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList6_item;  /* UE_RadioAccessCapabBandFDD6 */
static int hf_rrc_UE_RadioAccessCapabBandFDDList7_item;  /* UE_RadioAccessCapabBandFDD7 */
static int hf_rrc_fddRF_Capability_01;            /* T_fddRF_Capability_01 */
static int hf_rrc_ue_PowerClass_01;               /* UE_PowerClassExt */
static int hf_rrc_measurementCapability2;         /* MeasurementCapabilityExt2 */
static int hf_rrc_measurementCapability3;         /* MeasurementCapabilityExt3 */
static int hf_rrc_additionalSecondaryCells;       /* T_additionalSecondaryCells */
static int hf_rrc_nonContiguousMultiCellCombinationList;  /* NonContiguousMultiCellCombinationList */
static int hf_rrc_supportofULOLTD;                /* T_supportofULOLTD */
static int hf_rrc_additionalSecondaryCells_01;    /* T_additionalSecondaryCells_01 */
static int hf_rrc_supportofULOLTD_01;             /* T_supportofULOLTD_01 */
static int hf_rrc_fddRF_Capability_02;            /* T_fddRF_Capability_02 */
static int hf_rrc_measurementCapability4;         /* MeasurementCapabilityExt4 */
static int hf_rrc_additionalSecondaryCells2;      /* T_additionalSecondaryCells2 */
static int hf_rrc_supportOfULCLTD;                /* T_supportOfULCLTD */
static int hf_rrc_multiflowCapability_01;         /* MultiflowPerBandCapability */
static int hf_rrc_mimo4x4CapabilityBand;          /* T_mimo4x4CapabilityBand */
static int hf_rrc_supportOfULMIMO;                /* T_supportOfULMIMO */
static int hf_rrc_measurementCapability5;         /* MeasurementCapabilityExt5 */
static int hf_rrc_freqSpecificCompressedModeForNonContiguous;  /* T_freqSpecificCompressedModeForNonContiguous */
static int hf_rrc_measurementCapability6;         /* MeasurementCapabilityExt6 */
static int hf_rrc_rx_tx_TimeDifferenceType2Capable;  /* BOOLEAN */
static int hf_rrc_validity_CellPCH_UraPCH;        /* T_validity_CellPCH_UraPCH */
static int hf_rrc_sfn_sfnType2Capability;         /* T_sfn_sfnType2Capability */
static int hf_rrc_ue_GANSSPositioning_Capability;  /* UE_GANSSPositioning_Capability */
static int hf_rrc_ue_GANSSPositioning_Capability_v860ext;  /* UE_GANSSPositioning_Capability_v860ext_IEs */
static int hf_rrc_ue_Positioning_AddPos_Capability;  /* UE_AddPos_Supported_List */
static int hf_rrc_UE_RadioAccessCapabBandCombList_item;  /* BandComb */
static int hf_rrc_UE_RadioAccessCapabBandFDDList_item;  /* UE_RadioAccessCapabBandFDD */
static int hf_rrc_UE_RadioAccessCapabBandFDDList_ext_item;  /* UE_RadioAccessCapabBandFDD_ext */
static int hf_rrc_UE_RadioAccessCapabBandFDDList_ext2_item;  /* UE_RadioAccessCapabBandFDD_ext2 */
static int hf_rrc_fddRF_Capability_03;            /* T_fddRF_Capability_03 */
static int hf_rrc_measurementCapability_09;       /* MeasurementCapabilityExt */
static int hf_rrc_compressedModeMeasCapabFDDList_ext;  /* CompressedModeMeasCapabFDDList_ext */
static int hf_rrc_pdcp_Capability_r4_ext;         /* PDCP_Capability_r4_ext */
static int hf_rrc_tdd_CapabilityExt;              /* T_tdd_CapabilityExt */
static int hf_rrc_rf_Capability_03;               /* RF_Capability_r4_ext */
static int hf_rrc_measurementCapability_r4_ext;   /* MeasurementCapability_r4_ext */
static int hf_rrc_totalAM_RLCMemoryExceeds10kB;   /* BOOLEAN */
static int hf_rrc_rf_CapabilityComp;              /* RF_CapabilityComp */
static int hf_rrc_rf_CapabilityFDDComp_01;        /* RF_CapabBandListFDDComp_ext */
static int hf_rrc_hSDSCH_physical_layer_category;  /* HSDSCH_physical_layer_category */
static int hf_rrc_tdd_edch_PhysicalLayerCategory;  /* INTEGER_1_6 */
static int hf_rrc_dl_CapabilityWithSimultaneousHS_DSCHConfig;  /* DL_CapabilityWithSimultaneousHS_DSCHConfig */
static int hf_rrc_supportForCSVoiceoverHSPA_02;   /* T_supportForCSVoiceoverHSPA_02 */
static int hf_rrc_rf_CapabilityComp_01;           /* RF_CapabilityComp_v770ext */
static int hf_rrc_securityCapabilityIndication;   /* T_securityCapabilityIndication */
static int hf_rrc_ganssSupportIndication_01;      /* T_ganssSupportIndication_01 */
static int hf_rrc_mac_ehsSupport_03;              /* T_mac_ehsSupport_03 */
static int hf_rrc_fddPhysicalChannelCapab_hspdsch_edch;  /* T_fddPhysicalChannelCapab_hspdsch_edch */
static int hf_rrc_physicalChannelCapabComp_hspdsch_r6;  /* HSDSCH_physical_layer_category */
static int hf_rrc_physicalChannelCapability_edch_r6;  /* PhysicalChannelCapability_edch_r6 */
static int hf_rrc_edch_PhysicalLayerCategory_extension;  /* INTEGER_7 */
static int hf_rrc_hsscchlessHsdschOperation_01;   /* T_hsscchlessHsdschOperation_01 */
static int hf_rrc_enhancedFdpch_01;               /* T_enhancedFdpch_01 */
static int hf_rrc_hsdschReception_CellFach_01;    /* T_hsdschReception_CellFach_01 */
static int hf_rrc_hsdschReception_CellUraPch_01;  /* T_hsdschReception_CellUraPch_01 */
static int hf_rrc_discontinuousDpcchTransmission_01;  /* T_discontinuousDpcchTransmission_01 */
static int hf_rrc_slotFormat4;                    /* T_slotFormat4 */
static int hf_rrc_supportofTxDivOnNonMIMOChannel_01;  /* T_supportofTxDivOnNonMIMOChannel_01 */
static int hf_rrc_supportOfMACiis_05;             /* T_supportOfMACiis_05 */
static int hf_rrc_edch_PhysicalLayerCategory_extension2;  /* INTEGER_8_9 */
static int hf_rrc_edch_PhysicalLayerCategory_extension3;  /* INTEGER_10_12 */
static int hf_rrc_supportOfHSDPCCHPowerOffsetExtension_01;  /* T_supportOfHSDPCCHPowerOffsetExtension_01 */
static int hf_rrc_supportofDsacAndPpacInCellDch_01;  /* T_supportofDsacAndPpacInCellDch_01 */
static int hf_rrc_supportforDCHEnhancements_01;   /* T_supportforDCHEnhancements_01 */
static int hf_rrc_simultaneousSupportforDCHEnhancementsAndCM_01;  /* T_simultaneousSupportforDCHEnhancementsAndCM_01 */
static int hf_rrc_simultaneousSupportforDCHEnhancementsAndDPCCHDiscntTx_01;  /* T_simultaneousSupportforDCHEnhancementsAndDPCCHDiscntTx_01 */
static int hf_rrc_supportOfDualCellEDCHwithDPDCH;  /* T_supportOfDualCellEDCHwithDPDCH */
static int hf_rrc_supportOfSFModeForHSPDSCHDualStream_01;  /* T_supportOfSFModeForHSPDSCHDualStream_01 */
static int hf_rrc_supportOfCommonEDCH_05;         /* T_supportOfCommonEDCH_05 */
static int hf_rrc_supportOfMACiis_06;             /* T_supportOfMACiis_06 */
static int hf_rrc_supportOfSPSOperation_03;       /* T_supportOfSPSOperation_03 */
static int hf_rrc_supportOfControlChannelDRXOperation_02;  /* T_supportOfControlChannelDRXOperation_02 */
static int hf_rrc_fdd_49;                         /* T_fdd_48 */
static int hf_rrc_supported_06;                   /* RF_CapabBandListFDDComp */
static int hf_rrc_tdd384_RF_Capability;           /* T_tdd384_RF_Capability */
static int hf_rrc_supported_07;                   /* RadioFrequencyBandTDDList */
static int hf_rrc_tdd128_RF_Capability_01;        /* T_tdd128_RF_Capability */
static int hf_rrc_tdd384_RF_Capability_01;        /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd768_RF_Capability;           /* T_tdd768_RF_Capability */
static int hf_rrc_supported_08;                   /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_tdd128_RF_Capability_02;        /* RadioFrequencyBandTDDList_r7 */
static int hf_rrc_RF_CapabBandListFDDComp_item;   /* RF_CapabBandFDDComp */
static int hf_rrc_RF_CapabBandListFDDComp_ext_item;  /* RF_CapabBandFDDComp */
static int hf_rrc_RF_CapabBandListFDDComp_ext2_item;  /* RF_CapabBandFDDComp */
static int hf_rrc_UE_RadioAccessCapabBandCombList_va40ext_item;  /* SupportedCarrierCombination */
static int hf_rrc_UE_RadioAccessCapabBandCombList_vb50ext_item;  /* SupportedCarrierCombination_ext */
static int hf_rrc_UE_RadioAccessCapabBandCombList_vd20ext_item;  /* SupportDualBandDualCellEdch */
static int hf_rrc_carrierCombination12;           /* BOOLEAN */
static int hf_rrc_carrierCombination21;           /* BOOLEAN */
static int hf_rrc_carrierCombination13;           /* BOOLEAN */
static int hf_rrc_carrierCombination31;           /* BOOLEAN */
static int hf_rrc_carrierCombination22;           /* BOOLEAN */
static int hf_rrc_carrierCombination14;           /* BOOLEAN */
static int hf_rrc_carrierCombination41;           /* BOOLEAN */
static int hf_rrc_carrierCombination15;           /* BOOLEAN */
static int hf_rrc_carrierCombination51;           /* BOOLEAN */
static int hf_rrc_carrierCombination16;           /* BOOLEAN */
static int hf_rrc_carrierCombination61;           /* BOOLEAN */
static int hf_rrc_carrierCombination17;           /* BOOLEAN */
static int hf_rrc_carrierCombination71;           /* BOOLEAN */
static int hf_rrc_carrierCombination23;           /* BOOLEAN */
static int hf_rrc_carrierCombination32;           /* BOOLEAN */
static int hf_rrc_carrierCombination24;           /* BOOLEAN */
static int hf_rrc_carrierCombination42;           /* BOOLEAN */
static int hf_rrc_carrierCombination25;           /* BOOLEAN */
static int hf_rrc_carrierCombination52;           /* BOOLEAN */
static int hf_rrc_carrierCombination26;           /* BOOLEAN */
static int hf_rrc_carrierCombination62;           /* BOOLEAN */
static int hf_rrc_carrierCombination33;           /* BOOLEAN */
static int hf_rrc_carrierCombination34;           /* BOOLEAN */
static int hf_rrc_carrierCombination43;           /* BOOLEAN */
static int hf_rrc_carrierCombination44;           /* BOOLEAN */
static int hf_rrc_carrierCombination35;           /* BOOLEAN */
static int hf_rrc_carrierCombination53;           /* BOOLEAN */
static int hf_rrc_dualBandDualCellEdchIndication;  /* T_dualBandDualCellEdchIndication */
static int hf_rrc_pdcp_Capability_r5_ext;         /* PDCP_Capability_r5_ext */
static int hf_rrc_rlc_Capability_r5_ext;          /* RLC_Capability_r5_ext */
static int hf_rrc_physicalChannelCapability_12;   /* PhysicalChannelCapability_hspdsch_r5 */
static int hf_rrc_multiModeRAT_Capability_v590ext;  /* MultiModeRAT_Capability_v590ext */
static int hf_rrc_pdcp_Capability_r5_ext2;        /* PDCP_Capability_r5_ext2 */
static int hf_rrc_multiModeRAT_Capability_v680ext;  /* MultiModeRAT_Capability_v680ext */
static int hf_rrc_ulOLTDActivation;               /* T_ulOLTDActivation */
static int hf_rrc_maxNoDPDCH_BitsTransmitted;     /* MaxNoDPDCH_BitsTransmitted */
static int hf_rrc_discontinuousDpcchTransmission_02;  /* T_discontinuousDpcchTransmission_02 */
static int hf_rrc_slotFormat4_01;                 /* T_slotFormat4_01 */
static int hf_rrc_supportofCellReselectionIndicationReporting;  /* T_supportofCellReselectionIndicationReporting */
static int hf_rrc_supportofRadioLinkswithoutDPCHFDPCH;  /* T_supportofRadioLinkswithoutDPCHFDPCH */
static int hf_rrc_supportofServingE_DCHCellDecoupling;  /* T_supportofServingE_DCHCellDecoupling */
static int hf_rrc_accessGroupsAccessControl;      /* T_accessGroupsAccessControl */
static int hf_rrc_enhancedTTISwitching;           /* T_enhancedTTISwitching */
static int hf_rrc_implicitGrantHandling_02;       /* T_implicitGrantHandling_02 */
static int hf_rrc_dtx_enhancements;               /* T_dtx_enhancements */
static int hf_rrc_supportOfDualCellEDCHwithDPDCH_01;  /* T_supportOfDualCellEDCHwithDPDCH_01 */
static int hf_rrc_supportOfDualCellEDCHOperationEnhancements;  /* T_supportOfDualCellEDCHOperationEnhancements */
static int hf_rrc_maxPhysChPerTimeslot;           /* MaxPhysChPerTimeslot */
static int hf_rrc_minimumSF_02;                   /* MinimumSF_UL */
static int hf_rrc_supportOfPUSCH;                 /* BOOLEAN */
static int hf_rrc_tdd384_edch;                    /* T_tdd384_edch */
static int hf_rrc_supported_09;                   /* T_supported_03 */
static int hf_rrc_tdd_edch_PhysicalLayerCategory_01;  /* INTEGER_1_16 */
static int hf_rrc_maxPhysChPerTimeslot_01;        /* MaxPhysChPerTimeslot_LCR_r7 */
static int hf_rrc_tdd128_edch;                    /* T_tdd128_edch */
static int hf_rrc_supported_10;                   /* T_supported_04 */
static int hf_rrc_multiCarrier_EdchPhysicalLayerCategory_128;  /* INTEGER_1_8 */
static int hf_rrc_maxNumberCarrierForMCHSUPA_TDD;  /* T_maxNumberCarrierForMCHSUPA_TDD */
static int hf_rrc_tdd384_edch_01;                 /* T_tdd384_edch_01 */
static int hf_rrc_supported_11;                   /* T_supported_05 */
static int hf_rrc_configurationInfo_01;           /* T_configurationInfo_01 */
static int hf_rrc_newConfiguration_01;            /* T_newConfiguration_01 */
static int hf_rrc_activationDelay;                /* ActivationDelay */
static int hf_rrc_configurationInfo_02;           /* T_configurationInfo_02 */
static int hf_rrc_newConfiguration_02;            /* T_newConfiguration_02 */
static int hf_rrc_secondaryEDCH_Info_Common;      /* SecondaryEDCH_Info_Common_r14 */
static int hf_rrc_newConfiguration_03;            /* T_newConfiguration_03 */
static int hf_rrc_secondaryServingEDCHCell_Info;  /* SecondaryServingEDCHCell_Info */
static int hf_rrc_secondaryEDCH_Info_Common_01;   /* SecondaryEDCH_Info_Common */
static int hf_rrc_dl_InformationPerSecondaryRL_List;  /* DL_InformationPerSecondaryRL_List */
static int hf_rrc_newConfiguration_04;            /* T_newConfiguration_04 */
static int hf_rrc_secondaryEDCH_Info_Common_02;   /* SecondaryEDCH_Info_Common_r12 */
static int hf_rrc_dl_InformationPerSecondaryRL_List_01;  /* DL_InformationPerSecondaryRL_List_r12 */
static int hf_rrc_newConfiguration_05;            /* T_newConfiguration_05 */
static int hf_rrc_dl_InformationPerSecondaryRL_List_02;  /* DL_InformationPerSecondaryRL_List_r13 */
static int hf_rrc_newConfiguration_06;            /* T_newConfiguration_06 */
static int hf_rrc_fdd_edch;                       /* T_fdd_edch */
static int hf_rrc_supported_12;                   /* T_supported_06 */
static int hf_rrc_edch_PhysicalLayerCategory;     /* INTEGER_1_16 */
static int hf_rrc_maxNoBitsTransmitted;           /* MaxNoBits */
static int hf_rrc_maxConvCodeBitsTransmitted;     /* MaxNoBits */
static int hf_rrc_turboEncodingSupport;           /* TurboSupport */
static int hf_rrc_maxSimultaneousTransChs_01;     /* MaxSimultaneousTransChsUL */
static int hf_rrc_modeSpecificInfo_19;            /* T_modeSpecificInfo_19 */
static int hf_rrc_tdd_14;                         /* T_tdd_13 */
static int hf_rrc_maxTransmittedBlocks;           /* MaxTransportBlocksUL */
static int hf_rrc_maxNumberOfTFC_01;              /* MaxNumberOfTFC_UL */
static int hf_rrc_standaloneLocMethodsSupported;  /* BOOLEAN */
static int hf_rrc_ue_BasedOTDOA_Supported;        /* BOOLEAN */
static int hf_rrc_networkAssistedGPS_Supported;   /* NetworkAssistedGPS_Supported */
static int hf_rrc_supportForUE_GPS_TimingOfCellFrames;  /* BOOLEAN */
static int hf_rrc_supportForIPDL;                 /* BOOLEAN */
static int hf_rrc_start_CS;                       /* START_Value */
static int hf_rrc_start_PS;                       /* START_Value */
static int hf_rrc_drx_CycleLengthCoefficient;     /* INTEGER_3_9 */
static int hf_rrc_drx_CycleLengthCoefficient2;    /* INTEGER_3_9 */
static int hf_rrc_timeForDRXCycle2;               /* T_319 */
static int hf_rrc_rfc2507_Info;                   /* RFC2507_Info */
static int hf_rrc_rfc3095_Info;                   /* RFC3095_Info_r4 */
static int hf_rrc_logicalChannelIdentity;         /* LogicalChannelIdentity */
static int hf_rrc_mac_ehs_QueueId;                /* MAC_ehs_QueueId */
static int hf_rrc_maxCS_Delay;                    /* MaxCS_Delay */
static int hf_rrc_defaultConfigIdForCellFACH;     /* DefaultConfigIdForCellFACH */
static int hf_rrc_inSequenceDelivery;             /* BOOLEAN */
static int hf_rrc_receivingWindowSize;            /* ReceivingWindowSize */
static int hf_rrc_dl_RLC_StatusInfo;              /* DL_RLC_StatusInfo */
static int hf_rrc_dl_RLC_PDU_size;                /* OctetModeRLC_SizeInfoType1 */
static int hf_rrc_dl_RLC_PDU_size_01;             /* T_dl_RLC_PDU_size */
static int hf_rrc_fixedSize;                      /* OctetModeRLC_SizeInfoType1 */
static int hf_rrc_flexibleSize;                   /* T_flexibleSize */
static int hf_rrc_dl_RLC_PDU_size_02;             /* T_dl_RLC_PDU_size_01 */
static int hf_rrc_flexibleSize_01;                /* T_flexibleSize_01 */
static int hf_rrc_dl_RLC_StatusInfo_01;           /* DL_RLC_StatusInfo_r11 */
static int hf_rrc_rB_WithPDCP_InfoList;           /* RB_WithPDCP_InfoList */
static int hf_rrc_rb_WithPDCP_InfoList;           /* RB_WithPDCP_InfoList */
static int hf_rrc_dl_TransportChannelType;        /* DL_TransportChannelType */
static int hf_rrc_dl_TransportChannelType_01;     /* DL_TransportChannelType_r5 */
static int hf_rrc_dl_TransportChannelType_02;     /* DL_TransportChannelType_r7 */
static int hf_rrc_DL_LogicalChannelMappingList_item;  /* DL_LogicalChannelMapping */
static int hf_rrc_DL_LogicalChannelMappingList_r5_item;  /* DL_LogicalChannelMapping_r5 */
static int hf_rrc_DL_LogicalChannelMappingList_r7_item;  /* DL_LogicalChannelMapping_r7 */
static int hf_rrc_cID_InclusionInfo_r4;           /* CID_InclusionInfo_r4 */
static int hf_rrc_max_CID;                        /* INTEGER_1_16383 */
static int hf_rrc_reverseDecompressionDepth;      /* INTEGER_0_65535 */
static int hf_rrc_dl_AM_RLC_Mode;                 /* DL_AM_RLC_Mode */
static int hf_rrc_dl_UM_RLC_Mode;                 /* NULL */
static int hf_rrc_dl_TM_RLC_Mode;                 /* DL_TM_RLC_Mode */
static int hf_rrc_dl_AM_RLC_Mode_01;              /* DL_AM_RLC_Mode_r5 */
static int hf_rrc_dl_UM_RLC_Mode_01;              /* DL_UM_RLC_Mode_r5 */
static int hf_rrc_dl_UM_RLC_Mode_02;              /* DL_UM_RLC_Mode_r6 */
static int hf_rrc_dl_AM_RLC_Mode_02;              /* DL_AM_RLC_Mode_r7 */
static int hf_rrc_dl_AM_RLC_Mode_03;              /* DL_AM_RLC_Mode_r11 */
static int hf_rrc_timerStatusProhibit;            /* TimerStatusProhibit */
static int hf_rrc_timerEPC;                       /* TimerEPC */
static int hf_rrc_missingPDU_Indicator;           /* BOOLEAN */
static int hf_rrc_timerStatusPeriodic;            /* TimerStatusPeriodic */
static int hf_rrc_timerReordering;                /* TimerReordering */
static int hf_rrc_segmentationIndication;         /* BOOLEAN */
static int hf_rrc_dch;                            /* TransportChannelIdentity */
static int hf_rrc_fach;                           /* NULL */
static int hf_rrc_dsch;                           /* TransportChannelIdentity */
static int hf_rrc_dch_and_dsch;                   /* TransportChannelIdentityDCHandDSCH */
static int hf_rrc_hsdsch;                         /* MAC_d_FlowIdentity */
static int hf_rrc_dch_and_hsdsch;                 /* MAC_d_FlowIdentityDCHandHSDSCH */
static int hf_rrc_hsdsch_01;                      /* T_hsdsch */
static int hf_rrc_mac_hs;                         /* MAC_d_FlowIdentity */
static int hf_rrc_mac_ehs;                        /* MAC_ehs_QueueId */
static int hf_rrc_dch_and_hsdsch_01;              /* T_dch_and_hsdsch */
static int hf_rrc_mac_hs_01;                      /* MAC_d_FlowIdentityDCHandHSDSCH */
static int hf_rrc_mac_ehs_01;                     /* MAC_ehs_QueueIdDCHandHSDSCH */
static int hf_rrc_dl_UM_RLC_LI_size;              /* DL_UM_RLC_LI_size */
static int hf_rrc_dl_Reception_Window_Size;       /* DL_Reception_Window_Size_r6 */
static int hf_rrc_timerMRW;                       /* TimerMRW */
static int hf_rrc_timerDiscard;                   /* TimerDiscard */
static int hf_rrc_maxMRW;                         /* MaxMRW */
static int hf_rrc_algorithmSpecificInfo;          /* AlgorithmSpecificInfo */
static int hf_rrc_HeaderCompressionInfoList_item;  /* HeaderCompressionInfo */
static int hf_rrc_algorithmSpecificInfo_01;       /* AlgorithmSpecificInfo_r4 */
static int hf_rrc_HeaderCompressionInfoList_r4_item;  /* HeaderCompressionInfo_r4 */
static int hf_rrc_hs_scch_DrxCycleFach;           /* T_hs_scch_DrxCycleFach */
static int hf_rrc_hs_scch_RxBurstFach;            /* T_hs_scch_RxBurstFach */
static int hf_rrc_t333;                           /* T_t333 */
static int hf_rrc_supported_13;                   /* MaxPDCP_SN_WindowSize */
static int hf_rrc_maxDAT;                         /* MaxDAT */
static int hf_rrc_losslessSRNS_RelocSupport;      /* LosslessSRNS_RelocSupport */
static int hf_rrc_pdcp_PDU_Header;                /* PDCP_PDU_Header */
static int hf_rrc_headerCompressionInfoList;      /* HeaderCompressionInfoList */
static int hf_rrc_headerCompressionInfoList_01;   /* HeaderCompressionInfoList_r4 */
static int hf_rrc_pdcp_Info;                      /* PDCP_Info */
static int hf_rrc_dummy_int_0_65535;              /* INTEGER_0_65535 */
static int hf_rrc_pdcp_Info_01;                   /* PDCP_Info_r4 */
static int hf_rrc_timerPollProhibit;              /* TimerPollProhibit */
static int hf_rrc_timerPoll;                      /* TimerPoll */
static int hf_rrc_poll_PDU;                       /* Poll_PDU */
static int hf_rrc_poll_SDU;                       /* Poll_SDU */
static int hf_rrc_lastTransmissionPDU_Poll;       /* BOOLEAN */
static int hf_rrc_lastRetransmissionPDU_Poll;     /* BOOLEAN */
static int hf_rrc_pollWindow;                     /* PollWindow */
static int hf_rrc_timerPollPeriodic;              /* TimerPollPeriodic */
static int hf_rrc_re_EstablishmentTimer;          /* Re_EstablishmentTimer */
static int hf_rrc_srb_InformationList;            /* SRB_InformationSetupList */
static int hf_rrc_rb_InformationList;             /* RB_InformationSetupList */
static int hf_rrc_predefinedRB_Configuration;     /* PredefinedRB_Configuration */
static int hf_rrc_preDefTransChConfiguration;     /* PreDefTransChConfiguration */
static int hf_rrc_preDefPhyChConfiguration;       /* PreDefPhyChConfiguration */
static int hf_rrc_preDefPhyChConfiguration_01;    /* PreDefPhyChConfiguration_v770ext */
static int hf_rrc_mac_ehsWindowSize;              /* MAC_hs_WindowSize_r9 */
static int hf_rrc_PredefinedConfigStatusList_item;  /* PredefinedConfigStatusInfo */
static int hf_rrc_storedWithValueTagSameAsPrevius;  /* NULL */
static int hf_rrc_other;                          /* T_other */
static int hf_rrc_notStored;                      /* NULL */
static int hf_rrc_storedWithDifferentValueTag;    /* PredefinedConfigValueTag */
static int hf_rrc_setsWithDifferentValueTag;      /* PredefinedConfigSetsWithDifferentValueTag */
static int hf_rrc_otherEntries;                   /* PredefinedConfigStatusListVarSz */
static int hf_rrc_PredefinedConfigSetsWithDifferentValueTag_item;  /* PredefinedConfigSetWithDifferentValueTag */
static int hf_rrc_startPosition;                  /* INTEGER_0_10 */
static int hf_rrc_valueTagList;                   /* PredefinedConfigValueTagList */
static int hf_rrc_PredefinedConfigValueTagList_item;  /* PredefinedConfigValueTag */
static int hf_rrc_PredefinedConfigStatusListVarSz_item;  /* PredefinedConfigStatusInfo */
static int hf_rrc_rab_Identity;                   /* RAB_Identity */
static int hf_rrc_nas_Synchronisation_Indicator;  /* NAS_Synchronisation_Indicator */
static int hf_rrc_mbms_SessionIdentity;           /* MBMS_SessionIdentity */
static int hf_rrc_mbms_ServiceIdentity;           /* OCTET_STRING_SIZE_3 */
static int hf_rrc_RAB_InformationList_item;       /* RAB_Info */
static int hf_rrc_RAB_InformationList_r6_item;    /* RAB_Info_r6 */
static int hf_rrc_RAB_InformationReconfigList_item;  /* RAB_InformationReconfig */
static int hf_rrc_RAB_InformationReconfigList_r8_item;  /* RAB_InformationReconfig_r8 */
static int hf_rrc_cs_HSPA_Information;            /* CS_HSPA_Information */
static int hf_rrc_rb_Identity;                    /* RB_Identity */
static int hf_rrc_RAB_InformationMBMSPtpList_item;  /* RAB_InformationMBMSPtp */
static int hf_rrc_rab_Info_02;                    /* RAB_Info */
static int hf_rrc_rb_InformationSetupList;        /* RB_InformationSetupList */
static int hf_rrc_rb_InformationSetupList_01;     /* RB_InformationSetupList_r4 */
static int hf_rrc_rb_InformationSetupList_02;     /* RB_InformationSetupList_r5 */
static int hf_rrc_rab_Info_r6_ext;                /* RAB_Info_r6_ext */
static int hf_rrc_rb_InformationSetupList_03;     /* RB_InformationSetupList_r6 */
static int hf_rrc_rab_Info_v6b0ext;               /* RAB_Info_v6b0ext */
static int hf_rrc_rab_Info_03;                    /* RAB_Info_r7 */
static int hf_rrc_rb_InformationSetupList_04;     /* RB_InformationSetupList_r7 */
static int hf_rrc_rb_InformationSetupList_05;     /* RB_InformationSetupList_r8 */
static int hf_rrc_rb_InformationSetupList_06;     /* RB_InformationSetupList_r11 */
static int hf_rrc_RAB_InformationSetupList_item;  /* RAB_InformationSetup */
static int hf_rrc_RAB_InformationSetupList_r4_item;  /* RAB_InformationSetup_r4 */
static int hf_rrc_RAB_InformationSetupList_r5_item;  /* RAB_InformationSetup_r5 */
static int hf_rrc_RAB_InformationSetupList_r6_item;  /* RAB_InformationSetup_r6 */
static int hf_rrc_RAB_InformationSetupList_r6_ext_item;  /* RAB_InformationSetup_r6_ext */
static int hf_rrc_RAB_InformationSetupList_v6b0ext_item;  /* RAB_InformationSetup_v6b0ext */
static int hf_rrc_RAB_InformationSetupList_r7_item;  /* RAB_InformationSetup_r7 */
static int hf_rrc_RAB_InformationSetupList_r8_item;  /* RAB_InformationSetup_r8 */
static int hf_rrc_RAB_InformationSetupList_v820ext_item;  /* RAB_InformationSetup_v820ext */
static int hf_rrc_RAB_InformationSetupList_r11_item;  /* RAB_InformationSetup_r11 */
static int hf_rrc_rlc_SequenceNumber;             /* RLC_SequenceNumber */
static int hf_rrc_RB_ActivationTimeInfoList_item;  /* RB_ActivationTimeInfo */
static int hf_rrc_count_C_UL;                     /* COUNT_C */
static int hf_rrc_count_C_DL;                     /* COUNT_C */
static int hf_rrc_RB_COUNT_C_InformationList_item;  /* RB_COUNT_C_Information */
static int hf_rrc_count_C_MSB_UL;                 /* COUNT_C_MSB */
static int hf_rrc_count_C_MSB_DL;                 /* COUNT_C_MSB */
static int hf_rrc_RB_COUNT_C_MSB_InformationList_item;  /* RB_COUNT_C_MSB_Information */
static int hf_rrc_RB_IdentityList_item;           /* RB_Identity */
static int hf_rrc_rb_MappingInfo;                 /* RB_MappingInfo */
static int hf_rrc_rb_MappingInfo_01;              /* RB_MappingInfo_r5 */
static int hf_rrc_rb_MappingInfo_02;              /* RB_MappingInfo_r6 */
static int hf_rrc_rb_MappingInfo_03;              /* RB_MappingInfo_r7 */
static int hf_rrc_rb_MappingInfo_04;              /* RB_MappingInfo_r8 */
static int hf_rrc_RB_InformationAffectedList_item;  /* RB_InformationAffected */
static int hf_rrc_RB_InformationAffectedList_r5_item;  /* RB_InformationAffected_r5 */
static int hf_rrc_RB_InformationAffectedList_r6_item;  /* RB_InformationAffected_r6 */
static int hf_rrc_RB_InformationAffectedList_r7_item;  /* RB_InformationAffected_r7 */
static int hf_rrc_RB_InformationAffectedList_r8_item;  /* RB_InformationAffected_r8 */
static int hf_rrc_rb_Change;                      /* T_rb_Change */
static int hf_rrc_release_01;                     /* NULL */
static int hf_rrc_re_mapToDefaultRb;              /* RB_Identity */
static int hf_rrc_RB_InformationChangedList_r6_item;  /* RB_InformationChanged_r6 */
static int hf_rrc_pdcp_Info_02;                   /* PDCP_InfoReconfig */
static int hf_rrc_pdcp_SN_Info;                   /* PDCP_SN_Info */
static int hf_rrc_rlc_Info;                       /* RLC_Info */
static int hf_rrc_rb_StopContinue;                /* RB_StopContinue */
static int hf_rrc_pdcp_Info_03;                   /* PDCP_InfoReconfig_r4 */
static int hf_rrc_rlc_Info_01;                    /* RLC_Info_r5 */
static int hf_rrc_rlc_Info_02;                    /* RLC_Info_r6 */
static int hf_rrc_rlc_Info_03;                    /* RLC_Info_r7 */
static int hf_rrc_rlc_Info_04;                    /* RLC_Info_r11 */
static int hf_rrc_RB_InformationReconfigList_item;  /* RB_InformationReconfig */
static int hf_rrc_RB_InformationReconfigList_r4_item;  /* RB_InformationReconfig_r4 */
static int hf_rrc_RB_InformationReconfigList_r5_item;  /* RB_InformationReconfig_r5 */
static int hf_rrc_RB_InformationReconfigList_r6_item;  /* RB_InformationReconfig_r6 */
static int hf_rrc_RB_InformationReconfigList_r7_item;  /* RB_InformationReconfig_r7 */
static int hf_rrc_RB_InformationReconfigList_r8_item;  /* RB_InformationReconfig_r8 */
static int hf_rrc_RB_InformationReconfigList_r11_item;  /* RB_InformationReconfig_r11 */
static int hf_rrc_RB_InformationReleaseList_item;  /* RB_Identity */
static int hf_rrc_rlc_InfoChoice;                 /* RLC_InfoChoice */
static int hf_rrc_rlc_InfoChoice_01;              /* RLC_InfoChoice_r5 */
static int hf_rrc_rlc_InfoChoice_02;              /* RLC_InfoChoice_r6 */
static int hf_rrc_rlc_InfoChoice_03;              /* RLC_InfoChoice_r7 */
static int hf_rrc_rlc_InfoChoice_04;              /* RLC_InfoChoice_r11 */
static int hf_rrc_RB_InformationSetupList_item;   /* RB_InformationSetup */
static int hf_rrc_RB_InformationSetupList_r4_item;  /* RB_InformationSetup_r4 */
static int hf_rrc_RB_InformationSetupList_r5_item;  /* RB_InformationSetup_r5 */
static int hf_rrc_RB_InformationSetupList_r6_item;  /* RB_InformationSetup_r6 */
static int hf_rrc_RB_InformationSetupList_r7_item;  /* RB_InformationSetup_r7 */
static int hf_rrc_RB_InformationSetupList_r8_item;  /* RB_InformationSetup_r8 */
static int hf_rrc_RB_InformationSetupList_r11_item;  /* RB_InformationSetup_r11 */
static int hf_rrc_RB_MappingInfo_item;            /* RB_MappingOption */
static int hf_rrc_RB_MappingInfo_r5_item;         /* RB_MappingOption_r5 */
static int hf_rrc_RB_MappingInfo_r6_item;         /* RB_MappingOption_r6 */
static int hf_rrc_RB_MappingInfo_r7_item;         /* RB_MappingOption_r7 */
static int hf_rrc_RB_MappingInfo_r8_item;         /* RB_MappingOption_r8 */
static int hf_rrc_ul_LogicalChannelMappings;      /* UL_LogicalChannelMappings */
static int hf_rrc_dl_LogicalChannelMappingList;   /* DL_LogicalChannelMappingList */
static int hf_rrc_dl_LogicalChannelMappingList_01;  /* DL_LogicalChannelMappingList_r5 */
static int hf_rrc_ul_LogicalChannelMappings_01;   /* UL_LogicalChannelMappings_r6 */
static int hf_rrc_dl_LogicalChannelMappingList_02;  /* DL_LogicalChannelMappingList_r7 */
static int hf_rrc_ul_LogicalChannelMappings_02;   /* UL_LogicalChannelMappings_r8 */
static int hf_rrc_dl_RFC3095_Context_Relocation;  /* BOOLEAN */
static int hf_rrc_ul_RFC3095_Context_Relocation;  /* BOOLEAN */
static int hf_rrc_RB_PDCPContextRelocationList_item;  /* RB_PDCPContextRelocation */
static int hf_rrc_RB_WithPDCP_InfoList_item;      /* RB_WithPDCP_Info */
static int hf_rrc_retrievableConfigIdentity;      /* RetrievableConfigIdentity */
static int hf_rrc_retrievableConfigData;          /* RetrievableConfigData */
static int hf_rrc_ul_TransChInfoList;             /* UL_AddReconfTransChInfoList_r8 */
static int hf_rrc_dl_TransChInfoList;             /* DL_AddReconfTransChInfoList_r13 */
static int hf_rrc_retrievableConfigToBeInvoked;   /* RetrievableConfigIdentity */
static int hf_rrc_retrievableConfigToBeStored;    /* RetrievableConfigIdentity */
static int hf_rrc_retrievableConfigToBeRemoved;   /* RetrievableConfigListToRemove */
static int hf_rrc_preconfiguredRetrievableConfig;  /* RetrievableConfig_List */
static int hf_rrc_RetrievableConfig_List_item;    /* RetrievableConfig */
static int hf_rrc_RetrievableConfigListToRemove_item;  /* RetrievableConfigIdentity */
static int hf_rrc_f_MAX_PERIOD;                   /* INTEGER_1_65535 */
static int hf_rrc_f_MAX_TIME;                     /* INTEGER_1_255 */
static int hf_rrc_max_HEADER;                     /* INTEGER_60_65535 */
static int hf_rrc_tcp_SPACE;                      /* INTEGER_3_255 */
static int hf_rrc_non_TCP_SPACE;                  /* INTEGER_3_65535 */
static int hf_rrc_expectReordering;               /* ExpectReordering */
static int hf_rrc_rohcProfileList;                /* ROHC_ProfileList_r4 */
static int hf_rrc_ul_RFC3095;                     /* UL_RFC3095_r4 */
static int hf_rrc_dl_RFC3095;                     /* DL_RFC3095_r4 */
static int hf_rrc_ul_RLC_Mode;                    /* UL_RLC_Mode */
static int hf_rrc_dl_RLC_Mode;                    /* DL_RLC_Mode */
static int hf_rrc_dl_RLC_Mode_01;                 /* DL_RLC_Mode_r5 */
static int hf_rrc_rlc_OneSidedReEst;              /* BOOLEAN */
static int hf_rrc_dl_RLC_Mode_02;                 /* DL_RLC_Mode_r6 */
static int hf_rrc_altE_bitInterpretation;         /* T_altE_bitInterpretation */
static int hf_rrc_dl_RLC_Mode_03;                 /* DL_RLC_Mode_r7 */
static int hf_rrc_altE_bitInterpretation_01;      /* T_altE_bitInterpretation_01 */
static int hf_rrc_useSpecialValueOfHEField;       /* T_useSpecialValueOfHEField */
static int hf_rrc_dl_RLC_Mode_04;                 /* DL_RLC_Mode_r11 */
static int hf_rrc_altE_bitInterpretation_02;      /* T_altE_bitInterpretation_02 */
static int hf_rrc_useSpecialValueOfHEField_01;    /* T_useSpecialValueOfHEField_01 */
static int hf_rrc_dl_UM_RLC_OutOSeqDelivery_Info;  /* UM_RLC_OutOSeqDelivery_Info_r6 */
static int hf_rrc_dl_UM_RLC_DuplAvoid_Reord_Info;  /* UM_RLC_DuplAvoid_Reord_Info_r6 */
static int hf_rrc_same_as_RB;                     /* RB_Identity */
static int hf_rrc_lengthIndicatorSize;            /* T_lengthIndicatorSize */
static int hf_rrc_minRLC_PDU_Size;                /* INTEGER_0_1503 */
static int hf_rrc_largestRLC_PDU_Size;            /* INTEGER_0_1503 */
static int hf_rrc_RLC_PDU_SizeList_item;          /* RLC_PDU_Size */
static int hf_rrc_rlc_SizeIndex;                  /* INTEGER_1_maxTF */
static int hf_rrc_RLC_SizeExplicitList_item;      /* RLC_SizeInfo */
static int hf_rrc_ROHC_ProfileList_r4_item;       /* ROHC_Profile_r4 */
static int hf_rrc_ROHC_PacketSizeList_r4_item;    /* ROHC_PacketSize_r4 */
static int hf_rrc_SRB_InformationSetupList_item;  /* SRB_InformationSetup */
static int hf_rrc_SRB_InformationSetupList_r5_item;  /* SRB_InformationSetup_r5 */
static int hf_rrc_SRB_InformationSetupList_r6_item;  /* SRB_InformationSetup_r6 */
static int hf_rrc_SRB_InformationSetupList_r7_item;  /* SRB_InformationSetup_r7 */
static int hf_rrc_SRB_InformationSetupList_r8_item;  /* SRB_InformationSetup_r8 */
static int hf_rrc_SRB_InformationSetupList_r11_item;  /* SRB_InformationSetup_r11 */
static int hf_rrc_SRB_InformationSetupList2_item;  /* SRB_InformationSetup */
static int hf_rrc_SRB_InformationSetupList2_r6_item;  /* SRB_InformationSetup_r6 */
static int hf_rrc_SRB_InformationSetupList2_r7_item;  /* SRB_InformationSetup_r7 */
static int hf_rrc_SRB_InformationSetupList2_r8_item;  /* SRB_InformationSetup_r8 */
static int hf_rrc_timerBasedExplicit;             /* ExplicitDiscard */
static int hf_rrc_timerBasedNoExplicit;           /* NoExplicitDiscard */
static int hf_rrc_maxDAT_Retransmissions;         /* MaxDAT_Retransmissions */
static int hf_rrc_noDiscard;                      /* MaxDAT */
static int hf_rrc_transmissionRLC_Discard;        /* TransmissionRLC_Discard */
static int hf_rrc_transmissionWindowSize;         /* TransmissionWindowSize */
static int hf_rrc_timerRST;                       /* TimerRST */
static int hf_rrc_max_RST;                        /* MaxRST */
static int hf_rrc_pollingInfo;                    /* PollingInfo */
static int hf_rrc_ul_TransportChannelType;        /* UL_TransportChannelType */
static int hf_rrc_rlc_SizeList;                   /* T_rlc_SizeList */
static int hf_rrc_allSizes;                       /* NULL */
static int hf_rrc_configured;                     /* NULL */
static int hf_rrc_explicitList;                   /* RLC_SizeExplicitList */
static int hf_rrc_mac_LogicalChannelPriority;     /* MAC_LogicalChannelPriority */
static int hf_rrc_ul_TrCH_Type;                   /* T_ul_TrCH_Type */
static int hf_rrc_dch_rach_usch;                  /* T_dch_rach_usch */
static int hf_rrc_rlc_SizeList_01;                /* T_rlc_SizeList_01 */
static int hf_rrc_e_dch;                          /* T_e_dch */
static int hf_rrc_e_DCH_MAC_d_FlowIdentity;       /* E_DCH_MAC_d_FlowIdentity */
static int hf_rrc_ddi;                            /* DDI */
static int hf_rrc_rlc_PDU_SizeList;               /* RLC_PDU_SizeList */
static int hf_rrc_includeInSchedulingInfo;        /* BOOLEAN */
static int hf_rrc_ul_TrCH_Type_01;                /* T_ul_TrCH_Type_01 */
static int hf_rrc_dch_rach_usch_01;               /* T_dch_rach_usch_01 */
static int hf_rrc_rlc_SizeList_02;                /* T_rlc_SizeList_02 */
static int hf_rrc_e_dch_01;                       /* T_e_dch_01 */
static int hf_rrc_rlc_PDU_Size;                   /* T_rlc_PDU_Size */
static int hf_rrc_fixedSize_01;                   /* T_fixedSize */
static int hf_rrc_flexibleSize_02;                /* RLC_PDU_SizeConstraint */
static int hf_rrc_rlc_LogicalChannelMappingIndicator;  /* BOOLEAN */
static int hf_rrc_ul_LogicalChannelMapping;       /* SEQUENCE_SIZE_maxLoCHperRLC_OF_UL_LogicalChannelMapping */
static int hf_rrc_ul_LogicalChannelMapping_item;  /* UL_LogicalChannelMapping */
static int hf_rrc_ul_LogicalChannelMapping_01;    /* SEQUENCE_SIZE_maxLoCHperRLC_OF_UL_LogicalChannelMapping_r6 */
static int hf_rrc_ul_LogicalChannelMapping_item_01;  /* UL_LogicalChannelMapping_r6 */
static int hf_rrc_ul_LogicalChannelMapping_02;    /* SEQUENCE_SIZE_maxLoCHperRLC_OF_UL_LogicalChannelMapping_r8 */
static int hf_rrc_ul_LogicalChannelMapping_item_02;  /* UL_LogicalChannelMapping_r8 */
static int hf_rrc_oneLogicalChannel;              /* UL_LogicalChannelMapping */
static int hf_rrc_twoLogicalChannels;             /* UL_LogicalChannelMappingList */
static int hf_rrc_oneLogicalChannel_01;           /* UL_LogicalChannelMapping_r6 */
static int hf_rrc_twoLogicalChannels_01;          /* UL_LogicalChannelMappingList_r6 */
static int hf_rrc_oneLogicalChannel_02;           /* UL_LogicalChannelMapping_r8 */
static int hf_rrc_twoLogicalChannels_02;          /* UL_LogicalChannelMappingList_r8 */
static int hf_rrc_rOHC_PacketSizeList_r4;         /* ROHC_PacketSizeList_r4 */
static int hf_rrc_ul_AM_RLC_Mode;                 /* UL_AM_RLC_Mode */
static int hf_rrc_ul_UM_RLC_Mode;                 /* UL_UM_RLC_Mode */
static int hf_rrc_ul_TM_RLC_Mode;                 /* UL_TM_RLC_Mode */
static int hf_rrc_rach;                           /* NULL */
static int hf_rrc_usch;                           /* TransportChannelIdentity */
static int hf_rrc_timer_DAR;                      /* TimerDAR_r6 */
static int hf_rrc_widowSize_DAR;                  /* WindowSizeDAR_r6 */
static int hf_rrc_timer_OSD;                      /* TimerOSD_r6 */
static int hf_rrc_windowSize_OSD;                 /* WindowSizeOSD_r6 */
static int hf_rrc_mac_hs_AddReconfQueue_List;     /* MAC_hs_AddReconfQueue_List */
static int hf_rrc_mac_hs_DelQueue_List;           /* MAC_hs_DelQueue_List */
static int hf_rrc_mac_ehs_AddReconfQueue_List;    /* MAC_ehs_AddReconfReordQ_List */
static int hf_rrc_mAC_ehs_DelReordQ_List;         /* MAC_ehs_DelReordQ_List */
static int hf_rrc_mac_ehs_AddReconfQueue_List_01;  /* MAC_ehs_AddReconfReordQ_List_r9 */
static int hf_rrc_mac_ehs_AddReconfQueue_List_02;  /* MAC_ehs_AddReconfReordQ_List_TDD128_v9c0ext */
static int hf_rrc_mac_ehs_AddReconfQueue_List_03;  /* MAC_ehs_AddReconfReordQ_List_r11 */
static int hf_rrc_AllowedTFC_List_item;           /* TFC_Value */
static int hf_rrc_AllowedTFI_List_item;           /* INTEGER_0_31 */
static int hf_rrc_sizeType1;                      /* INTEGER_0_127 */
static int hf_rrc_sizeType2;                      /* T_sizeType2 */
static int hf_rrc_part1;                          /* INTEGER_0_15 */
static int hf_rrc_part2;                          /* INTEGER_1_7 */
static int hf_rrc_sizeType3;                      /* T_sizeType3 */
static int hf_rrc_part1_01;                       /* INTEGER_0_47 */
static int hf_rrc_part2_01;                       /* INTEGER_1_15 */
static int hf_rrc_sizeType4;                      /* T_sizeType4 */
static int hf_rrc_part1_02;                       /* INTEGER_0_62 */
static int hf_rrc_part2_02;                       /* INTEGER_1_63 */
static int hf_rrc_noCoding;                       /* NULL */
static int hf_rrc_convolutional;                  /* CodingRate */
static int hf_rrc_turbo;                          /* NULL */
static int hf_rrc_mac_d_FlowIdentity;             /* E_DCH_MAC_d_FlowIdentity */
static int hf_rrc_mac_d_FlowPowerOffset;          /* E_DCH_MAC_d_FlowPowerOffset */
static int hf_rrc_mac_d_FlowMaxRetrans;           /* E_DCH_MAC_d_FlowMaxRetrans */
static int hf_rrc_mac_d_FlowMultiplexingList;     /* E_DCH_MAC_d_FlowMultiplexingList */
static int hf_rrc_e_dch_mac_d_flow_retransmission_timer;  /* E_DCH_MAC_d_FlowRetransTimer */
static int hf_rrc_Common_E_DCH_MAC_d_FlowList_item;  /* Common_E_DCH_MAC_d_Flow */
static int hf_rrc_Common_E_DCH_MAC_d_Flow_Info_List_ConcurrentTTI_item;  /* Common_E_DCH_MAC_d_Flow_Info_ConcurrentTTI */
static int hf_rrc_rlc_Size;                       /* T_rlc_Size */
static int hf_rrc_fdd_50;                         /* T_fdd_49 */
static int hf_rrc_octetModeRLC_SizeInfoType2;     /* OctetModeRLC_SizeInfoType2 */
static int hf_rrc_tdd_15;                         /* T_tdd_14 */
static int hf_rrc_commonTDD_Choice;               /* T_commonTDD_Choice */
static int hf_rrc_bitModeRLC_SizeInfo;            /* BitModeRLC_SizeInfo */
static int hf_rrc_octetModeRLC_SizeInfoType1;     /* OctetModeRLC_SizeInfoType1 */
static int hf_rrc_numberOfTbSizeList;             /* SEQUENCE_SIZE_1_maxTF_OF_NumberOfTransportBlocks */
static int hf_rrc_numberOfTbSizeList_item;        /* NumberOfTransportBlocks */
static int hf_rrc_logicalChannelList;             /* LogicalChannelList */
static int hf_rrc_commonTDD_Choice_01;            /* T_commonTDD_Choice_01 */
static int hf_rrc_numberOfTbSizeAndTTIList;       /* NumberOfTbSizeAndTTIList */
static int hf_rrc_CommonDynamicTF_InfoList_item;  /* CommonDynamicTF_Info */
static int hf_rrc_CommonDynamicTF_InfoList_DynamicTTI_item;  /* CommonDynamicTF_Info_DynamicTTI */
static int hf_rrc_tti;                            /* T_tti */
static int hf_rrc_tti10;                          /* CommonDynamicTF_InfoList */
static int hf_rrc_tti20;                          /* CommonDynamicTF_InfoList */
static int hf_rrc_tti40;                          /* CommonDynamicTF_InfoList */
static int hf_rrc_tti80;                          /* CommonDynamicTF_InfoList */
static int hf_rrc_dynamic;                        /* CommonDynamicTF_InfoList_DynamicTTI */
static int hf_rrc_semistaticTF_Information;       /* SemistaticTF_Information */
static int hf_rrc_tti_01;                         /* T_tti_01 */
static int hf_rrc_tti5;                           /* CommonDynamicTF_InfoList */
static int hf_rrc_t1_ReleaseTimer;                /* T1_ReleaseTimer */
static int hf_rrc_reorderingResetTimer;           /* Treset_ResetTimer */
static int hf_rrc_mac_ehsWindowSize_01;           /* MAC_hs_WindowSize */
static int hf_rrc_Common_MAC_ehs_ReorderingQueueList_item;  /* Common_MAC_ehs_ReorderingQueue */
static int hf_rrc_tti_selection;                  /* T_tti_selection */
static int hf_rrc_fixed;                          /* T_fixed */
static int hf_rrc_fixed_TTI_Selection;            /* T_fixed_TTI_Selection */
static int hf_rrc_threshold_based;                /* T_threshold_based */
static int hf_rrc_common_E_DCH_TTI_Selection_Thresh;  /* INTEGER_0_15 */
static int hf_rrc_concurrent_TTI_Partition_Index;  /* INTEGER_0_maxEDCHs_1 */
static int hf_rrc_commonEDCHSystemInfoParamConcurrentTTI;  /* CommonEDCHSystemInfoParamConcurrentTTI */
static int hf_rrc_rlc_Size_01;                    /* T_rlc_Size_01 */
static int hf_rrc_bitMode;                        /* BitModeRLC_SizeInfo */
static int hf_rrc_octetModeType1;                 /* OctetModeRLC_SizeInfoType1 */
static int hf_rrc_rlc_Size_02;                    /* T_rlc_Size_02 */
static int hf_rrc_DedicatedDynamicTF_InfoList_item;  /* DedicatedDynamicTF_Info */
static int hf_rrc_DedicatedDynamicTF_InfoList_DynamicTTI_item;  /* DedicatedDynamicTF_Info_DynamicTTI */
static int hf_rrc_tti_02;                         /* T_tti_02 */
static int hf_rrc_tti10_01;                       /* DedicatedDynamicTF_InfoList */
static int hf_rrc_tti20_01;                       /* DedicatedDynamicTF_InfoList */
static int hf_rrc_tti40_01;                       /* DedicatedDynamicTF_InfoList */
static int hf_rrc_tti80_01;                       /* DedicatedDynamicTF_InfoList */
static int hf_rrc_dynamic_01;                     /* DedicatedDynamicTF_InfoList_DynamicTTI */
static int hf_rrc_DL_AddReconfTransChInfo2List_item;  /* DL_AddReconfTransChInformation2 */
static int hf_rrc_DL_AddReconfTransChInfoList_item;  /* DL_AddReconfTransChInformation */
static int hf_rrc_DL_AddReconfTransChInfoList_r4_item;  /* DL_AddReconfTransChInformation_r4 */
static int hf_rrc_DL_AddReconfTransChInfoList_r5_item;  /* DL_AddReconfTransChInformation_r5 */
static int hf_rrc_DL_AddReconfTransChInfoList_r7_item;  /* DL_AddReconfTransChInformation_r7 */
static int hf_rrc_DL_AddReconfTransChInfoList_r9_item;  /* DL_AddReconfTransChInformation_r9 */
static int hf_rrc_DL_AddReconfTransChInfoList_r11_item;  /* DL_AddReconfTransChInformation_r11 */
static int hf_rrc_DL_AddReconfTransChInfoList_r13_item;  /* DL_AddReconfTransChInformation_r13 */
static int hf_rrc_DL_AddReconfTransChInfoList_TDD128_v9c0ext_item;  /* DL_AddReconfTransChInformation_TDD128_v9c0ext */
static int hf_rrc_dl_TransportChannelType_03;     /* DL_TrCH_Type */
static int hf_rrc_dl_transportChannelIdentity;    /* TransportChannelIdentity */
static int hf_rrc_tfs_SignallingMode;             /* T_tfs_SignallingMode */
static int hf_rrc_explicit_config;                /* TransportFormatSet */
static int hf_rrc_sameAsULTrCH;                   /* UL_TransportChannelIdentity */
static int hf_rrc_dch_QualityTarget;              /* QualityTarget */
static int hf_rrc_tM_SignallingInfo;              /* TM_SignallingInfo */
static int hf_rrc_tfs_SignallingMode_01;          /* T_tfs_SignallingMode_01 */
static int hf_rrc_dl_TransportChannelType_04;     /* DL_TrCH_TypeId1_r5 */
static int hf_rrc_tfs_SignallingMode_02;          /* T_tfs_SignallingMode_02 */
static int hf_rrc_hsdsch_02;                      /* HSDSCH_Info */
static int hf_rrc_tfs_SignallingMode_03;          /* T_tfs_SignallingMode_03 */
static int hf_rrc_hsdsch_03;                      /* HSDSCH_Info_r7 */
static int hf_rrc_tfs_SignallingMode_04;          /* T_tfs_SignallingMode_04 */
static int hf_rrc_hsdsch_04;                      /* HSDSCH_Info_r9 */
static int hf_rrc_tfs_SignallingMode_05;          /* T_tfs_SignallingMode_05 */
static int hf_rrc_hsdsch_05;                      /* HSDSCH_Info_r11 */
static int hf_rrc_tfs_SignallingMode_06;          /* T_tfs_SignallingMode_06 */
static int hf_rrc_hsdsch_06;                      /* HSDSCH_Info_r13 */
static int hf_rrc_hsdsch_07;                      /* HSDSCH_Info_TDD128_v9c0ext */
static int hf_rrc_transportChannelIdentity;       /* TransportChannelIdentity */
static int hf_rrc_tfs_SignallingMode_07;          /* T_tfs_SignallingMode_07 */
static int hf_rrc_qualityTarget;                  /* QualityTarget */
static int hf_rrc_sccpch_TFCS;                    /* TFCS */
static int hf_rrc_modeSpecificInfo_20;            /* T_modeSpecificInfo_20 */
static int hf_rrc_fdd_51;                         /* T_fdd_50 */
static int hf_rrc_dl_Parameters;                  /* T_dl_Parameters */
static int hf_rrc_dl_DCH_TFCS;                    /* TFCS */
static int hf_rrc_sameAsUL;                       /* NULL */
static int hf_rrc_tdd_16;                         /* T_tdd_15 */
static int hf_rrc_individualDL_CCTrCH_InfoList;   /* IndividualDL_CCTrCH_InfoList */
static int hf_rrc_modeSpecificInfo_21;            /* T_modeSpecificInfo_21 */
static int hf_rrc_fdd_52;                         /* T_fdd_51 */
static int hf_rrc_dl_Parameters_01;               /* T_dl_Parameters_01 */
static int hf_rrc_dl_DCH_TFCS_01;                 /* T_dl_DCH_TFCS */
static int hf_rrc_tfcs;                           /* TFCS */
static int hf_rrc_tdd_17;                         /* T_tdd_16 */
static int hf_rrc_DL_DeletedTransChInfoList_item;  /* DL_TransportChannelIdentity */
static int hf_rrc_DL_DeletedTransChInfoList_r5_item;  /* DL_TransportChannelIdentity_r5 */
static int hf_rrc_DL_DeletedTransChInfoList_r7_item;  /* DL_TransportChannelIdentity_r7 */
static int hf_rrc_dl_TransportChannelIdentity;    /* TransportChannelIdentity */
static int hf_rrc_dl_TransportChannelType_05;     /* DL_TrCH_TypeId2_r5 */
static int hf_rrc_dl_TransportChannelType_06;     /* DL_TrCH_TypeId2_r7 */
static int hf_rrc_hsdsch_08;                      /* NULL */
static int hf_rrc_hsdsch_09;                      /* T_hsdsch_01 */
static int hf_rrc_transmissionTimeValidity;       /* TransmissionTimeValidity */
static int hf_rrc_timeDurationBeforeRetry;        /* TimeDurationBeforeRetry */
static int hf_rrc_drac_ClassIdentity;             /* DRAC_ClassIdentity */
static int hf_rrc_DRAC_StaticInformationList_item;  /* DRAC_StaticInformation */
static int hf_rrc_transmissionGrantType;          /* T_transmissionGrantType */
static int hf_rrc_non_ScheduledTransGrantInfo;    /* T_non_ScheduledTransGrantInfo */
static int hf_rrc_maxMAC_e_PDUContents;           /* INTEGER_1_19982 */
static int hf_rrc_ms2_NonSchedTransmGrantHARQAlloc;  /* BIT_STRING_SIZE_8 */
static int hf_rrc_scheduledTransmissionGrantInfo;  /* NULL */
static int hf_rrc_mac_d_FlowRetransTimer;         /* E_DCH_MAC_d_FlowRetransTimer */
static int hf_rrc_transmissionGrantType_01;       /* T_transmissionGrantType_01 */
static int hf_rrc_non_ScheduledTransGrantInfo_01;  /* T_non_ScheduledTransGrantInfo_01 */
static int hf_rrc_modeSpecificInfo_22;            /* T_modeSpecificInfo_22 */
static int hf_rrc_fdd_53;                         /* T_fdd_52 */
static int hf_rrc_E_DCH_AddReconf_MAC_d_FlowList_item;  /* E_DCH_AddReconf_MAC_d_Flow */
static int hf_rrc_E_DCH_AddReconf_MAC_d_FlowList_r7_item;  /* E_DCH_AddReconf_MAC_d_Flow_r7 */
static int hf_rrc_complete_33;                    /* TFCS_ReconfAdd */
static int hf_rrc_addition;                       /* TFCS_ReconfAdd */
static int hf_rrc_removal;                        /* TFCS_RemovalList */
static int hf_rrc_replacement;                    /* T_replacement */
static int hf_rrc_tfcsRemoval;                    /* TFCS_RemovalList */
static int hf_rrc_tfcsAdd;                        /* TFCS_ReconfAdd */
static int hf_rrc_complete_34;                    /* TFCS_ReconfAdd_r12 */
static int hf_rrc_addition_01;                    /* TFCS_ReconfAdd_r12 */
static int hf_rrc_replacement_01;                 /* T_replacement_01 */
static int hf_rrc_tfcsAdd_01;                     /* TFCS_ReconfAdd_r12 */
static int hf_rrc_signalledGainFactors;           /* SignalledGainFactors */
static int hf_rrc_computedGainFactors;            /* ReferenceTFC_ID */
static int hf_rrc_signalledGainFactors_01;        /* T_signalledGainFactors */
static int hf_rrc_gainFactorBetaC;                /* GainFactor */
static int hf_rrc_gainFactorBetaD;                /* GainFactor */
static int hf_rrc_referenceTFC_ID;                /* ReferenceTFC_ID */
static int hf_rrc_addOrReconfMAC_dFlow;           /* AddOrReconfMAC_dFlow */
static int hf_rrc_dl_MAC_HeaderType;              /* T_dl_MAC_HeaderType */
static int hf_rrc_mac_hs_02;                      /* AddOrReconfMAC_dFlow */
static int hf_rrc_mac_ehs_02;                     /* AddOrReconfMAC_ehs_ReordQ */
static int hf_rrc_dl_MAC_HeaderType_01;           /* T_dl_MAC_HeaderType_01 */
static int hf_rrc_mac_ehs_03;                     /* AddOrReconfMAC_ehs_ReordQ_r9 */
static int hf_rrc_dl_MAC_HeaderType_02;           /* T_dl_MAC_HeaderType_02 */
static int hf_rrc_mac_ehs_04;                     /* AddOrReconfMAC_ehs_ReordQ_r11 */
static int hf_rrc_dl_MAC_HeaderType_03;           /* T_dl_MAC_HeaderType_03 */
static int hf_rrc_mac_ehs_05;                     /* AddOrReconfMAC_ehs_ReordQ_TDD128_v9c0ext */
static int hf_rrc_numberOfProcesses;              /* INTEGER_1_8 */
static int hf_rrc_memoryPartitioning;             /* T_memoryPartitioning */
static int hf_rrc_implicit;                       /* NULL */
static int hf_rrc_explicit;                       /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_explicit_item;                  /* HARQMemorySize */
static int hf_rrc_numberOfProcesses_01;           /* T_numberOfProcesses */
static int hf_rrc_memoryPartitioning_01;          /* T_memoryPartitioning_01 */
static int hf_rrc_explicit_01;                    /* T_explicit */
static int hf_rrc_memorySize;                     /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_memorySize_item;                /* HARQMemorySize */
static int hf_rrc_additionalMemorySizesForMIMO;   /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_additionalMemorySizesForMIMO_item;  /* HARQMemorySize */
static int hf_rrc_numberOfProcesses_02;           /* T_numberOfProcesses_01 */
static int hf_rrc_memoryPartitioning_02;          /* T_memoryPartitioning_02 */
static int hf_rrc_explicit_02;                    /* T_explicit_01 */
static int hf_rrc_additionalMemorySizesThirdMIMOStream;  /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_additionalMemorySizesThirdMIMOStream_item;  /* HARQMemorySize */
static int hf_rrc_additionalMemorySizesFourthMIMOStream;  /* SEQUENCE_SIZE_1_maxHProcesses_OF_HARQMemorySize */
static int hf_rrc_additionalMemorySizesFourthMIMOStream_item;  /* HARQMemorySize */
static int hf_rrc_numberOfProcesses_03;           /* T_numberOfProcesses_02 */
static int hf_rrc_memoryPartitioning_03;          /* T_memoryPartitioning_03 */
static int hf_rrc_explicit_03;                    /* T_explicit_02 */
static int hf_rrc_blindHARQRetransmissionsForHSDPA;  /* T_blindHARQRetransmissionsForHSDPA */
static int hf_rrc_dl_TFCS_Identity;               /* TFCS_Identity */
static int hf_rrc_tfcs_SignallingMode;            /* T_tfcs_SignallingMode */
static int hf_rrc_explicit_config_01;             /* TFCS */
static int hf_rrc_sameAsUL_01;                    /* TFCS_Identity */
static int hf_rrc_IndividualDL_CCTrCH_InfoList_item;  /* IndividualDL_CCTrCH_Info */
static int hf_rrc_ul_TFCS_Identity;               /* TFCS_Identity */
static int hf_rrc_ul_TFCS;                        /* TFCS */
static int hf_rrc_tfc_Subset;                     /* TFC_Subset */
static int hf_rrc_IndividualUL_CCTrCH_InfoList_item;  /* IndividualUL_CCTrCH_Info */
static int hf_rrc_logChOfRb;                      /* INTEGER_0_1 */
static int hf_rrc_explicitList_01;                /* SEQUENCE_SIZE_1_15_OF_LogicalChannelByRB */
static int hf_rrc_explicitList_item;              /* LogicalChannelByRB */
static int hf_rrc_dch_transport_ch_id;            /* TransportChannelIdentity */
static int hf_rrc_hsdsch_mac_d_flow_id;           /* MAC_d_FlowIdentity */
static int hf_rrc_MAC_d_PDU_SizeInfo_List_item;   /* MAC_d_PDUsizeInfo */
static int hf_rrc_mac_d_PDU_Size;                 /* INTEGER_1_5000 */
static int hf_rrc_mac_d_PDU_Index;                /* INTEGER_0_7 */
static int hf_rrc_MAC_hs_AddReconfQueue_List_item;  /* MAC_hs_AddReconfQueue */
static int hf_rrc_mac_hsQueueId;                  /* INTEGER_0_7 */
static int hf_rrc_mac_dFlowId;                    /* MAC_d_FlowIdentity */
static int hf_rrc_reorderingReleaseTimer;         /* T1_ReleaseTimer */
static int hf_rrc_mac_hsWindowSize;               /* MAC_hs_WindowSize */
static int hf_rrc_mac_d_PDU_SizeInfo_List;        /* MAC_d_PDU_SizeInfo_List */
static int hf_rrc_MAC_hs_DelQueue_List_item;      /* MAC_hs_DelQueue */
static int hf_rrc_MAC_ehs_AddReconfReordQ_List_item;  /* MAC_ehs_AddReconfReordQ */
static int hf_rrc_MAC_ehs_AddReconfReordQ_List_r9_item;  /* MAC_ehs_AddReconfReordQ_r9 */
static int hf_rrc_MAC_ehs_AddReconfReordQ_List_TDD128_v9c0ext_item;  /* MAC_ehs_AddReconfReordQ_TDD128_v9c0ext */
static int hf_rrc_MAC_ehs_AddReconfReordQ_List_r11_item;  /* MAC_ehs_AddReconfReordQ_r11 */
static int hf_rrc_mac_ehsWindowSize_extension;    /* MAC_ehs_WindowSize_TDD128_v9c0ext */
static int hf_rrc_mac_ehsWindowSize_02;           /* MAC_hs_WindowSize_r11 */
static int hf_rrc_MAC_ehs_DelReordQ_List_item;    /* MAC_ehs_DelReordQ */
static int hf_rrc_hsdsch_mac_ehs_QueueId;         /* MAC_ehs_QueueId */
static int hf_rrc_NumberOfTbSizeAndTTIList_item;  /* NumberOfTbSizeAndTTIList_item */
static int hf_rrc_numberOfTransportBlocks;        /* NumberOfTransportBlocks */
static int hf_rrc_transmissionTimeInterval;       /* TransmissionTimeInterval */
static int hf_rrc_Non_allowedTFC_List_item;       /* TFC_Value */
static int hf_rrc_zero;                           /* NULL */
static int hf_rrc_one;                            /* NULL */
static int hf_rrc_small;                          /* INTEGER_2_17 */
static int hf_rrc_large;                          /* INTEGER_18_512 */
static int hf_rrc_sizeType1_01;                   /* INTEGER_0_31 */
static int hf_rrc_sizeType2_01;                   /* T_sizeType2_01 */
static int hf_rrc_part1_03;                       /* INTEGER_0_23 */
static int hf_rrc_part2_03;                       /* INTEGER_1_3 */
static int hf_rrc_sizeType3_01;                   /* T_sizeType3_01 */
static int hf_rrc_part1_04;                       /* INTEGER_0_61 */
static int hf_rrc_sizeType2_02;                   /* INTEGER_0_63 */
static int hf_rrc_sizeType3_02;                   /* INTEGER_0_56 */
static int hf_rrc_referenceTFC;                   /* TFC_Value */
static int hf_rrc_modeSpecificInfo_23;            /* T_modeSpecificInfo_23 */
static int hf_rrc_fdd_54;                         /* T_fdd_53 */
static int hf_rrc_gainFactorInformation;          /* GainFactorInformation */
static int hf_rrc_powerOffsetPp_m;                /* PowerOffsetPp_m */
static int hf_rrc_gainFactorInformation_01;       /* GainFactorInformation_10msMode */
static int hf_rrc_ul_AddReconfTrChInfoList;       /* UL_AddReconfTransChInfoList */
static int hf_rrc_dl_TrChInfoList;                /* DL_AddReconfTransChInfoList */
static int hf_rrc_bler_QualityValue;              /* BLER_QualityValue */
static int hf_rrc_ul_TransportChannelType_01;     /* UL_TrCH_Type */
static int hf_rrc_restrictedTrChIdentity;         /* TransportChannelIdentity */
static int hf_rrc_allowedTFI_List;                /* AllowedTFI_List */
static int hf_rrc_RestrictedTrChInfoList_item;    /* RestrictedTrChInfo */
static int hf_rrc_channelCodingType;              /* ChannelCodingType */
static int hf_rrc_rateMatchingAttribute;          /* RateMatchingAttribute */
static int hf_rrc_crc_Size;                       /* CRC_Size */
static int hf_rrc_modeSpecificInfo_24;            /* T_modeSpecificInfo_24 */
static int hf_rrc_fdd_55;                         /* T_fdd_54 */
static int hf_rrc_splitType;                      /* SplitType */
static int hf_rrc_tfci_Field2_Length;             /* INTEGER_1_10 */
static int hf_rrc_tfci_Field1_Information;        /* ExplicitTFCS_Configuration */
static int hf_rrc_tfci_Field2_Information;        /* TFCI_Field2_Information */
static int hf_rrc_minimumAllowedTFC_Number;       /* TFC_Value */
static int hf_rrc_allowedTFC_List;                /* AllowedTFC_List */
static int hf_rrc_non_allowedTFC_List;            /* Non_allowedTFC_List */
static int hf_rrc_restrictedTrChInfoList;         /* RestrictedTrChInfoList */
static int hf_rrc_fullTFCS;                       /* NULL */
static int hf_rrc_TFC_SubsetList_item;            /* TFC_SubsetList_item */
static int hf_rrc_modeSpecificInfo_25;            /* T_modeSpecificInfo_25 */
static int hf_rrc_tdd_18;                         /* T_tdd_17 */
static int hf_rrc_tfci_Range;                     /* TFCI_RangeList */
static int hf_rrc_explicit_config_02;             /* ExplicitTFCS_Configuration */
static int hf_rrc_maxTFCIField2Value;             /* INTEGER_1_1023 */
static int hf_rrc_tfcs_InfoForDSCH;               /* TFCS_InfoForDSCH */
static int hf_rrc_TFCI_RangeList_item;            /* TFCI_Range */
static int hf_rrc_normalTFCI_Signalling;          /* ExplicitTFCS_Configuration */
static int hf_rrc_splitTFCI_Signalling;           /* SplitTFCI_Signalling */
static int hf_rrc_normalTFCI_Signalling_01;       /* ExplicitTFCS_Configuration_r12 */
static int hf_rrc_tfcs_ID_01;                     /* TFCS_IdentityPlain */
static int hf_rrc_sharedChannelIndicator;         /* BOOLEAN */
static int hf_rrc_ctfc2bit;                       /* INTEGER_0_3 */
static int hf_rrc_ctfc4bit;                       /* INTEGER_0_15 */
static int hf_rrc_ctfc6bit;                       /* INTEGER_0_63 */
static int hf_rrc_ctfc8bit;                       /* INTEGER_0_255 */
static int hf_rrc_ctfc12bit;                      /* INTEGER_0_4095 */
static int hf_rrc_ctfc16bit;                      /* INTEGER_0_65535 */
static int hf_rrc_ctfc24bit;                      /* INTEGER_0_16777215 */
static int hf_rrc_ctfcSize;                       /* T_ctfcSize */
static int hf_rrc_ctfc2Bit;                       /* T_ctfc2Bit */
static int hf_rrc_ctfc2Bit_item;                  /* T_ctfc2Bit_item */
static int hf_rrc_ctfc2;                          /* INTEGER_0_3 */
static int hf_rrc_powerOffsetInformation;         /* PowerOffsetInformation */
static int hf_rrc_ctfc4Bit;                       /* T_ctfc4Bit */
static int hf_rrc_ctfc4Bit_item;                  /* T_ctfc4Bit_item */
static int hf_rrc_ctfc4;                          /* INTEGER_0_15 */
static int hf_rrc_ctfc6Bit;                       /* T_ctfc6Bit */
static int hf_rrc_ctfc6Bit_item;                  /* T_ctfc6Bit_item */
static int hf_rrc_ctfc6;                          /* INTEGER_0_63 */
static int hf_rrc_ctfc8Bit;                       /* T_ctfc8Bit */
static int hf_rrc_ctfc8Bit_item;                  /* T_ctfc8Bit_item */
static int hf_rrc_ctfc8;                          /* INTEGER_0_255 */
static int hf_rrc_ctfc12Bit;                      /* T_ctfc12Bit */
static int hf_rrc_ctfc12Bit_item;                 /* T_ctfc12Bit_item */
static int hf_rrc_ctfc12;                         /* INTEGER_0_4095 */
static int hf_rrc_ctfc16Bit;                      /* T_ctfc16Bit */
static int hf_rrc_ctfc16Bit_item;                 /* T_ctfc16Bit_item */
static int hf_rrc_ctfc16;                         /* INTEGER_0_65535 */
static int hf_rrc_ctfc24Bit;                      /* T_ctfc24Bit */
static int hf_rrc_ctfc24Bit_item;                 /* T_ctfc24Bit_item */
static int hf_rrc_ctfc24;                         /* INTEGER_0_16777215 */
static int hf_rrc_ctfcSize_01;                    /* T_ctfcSize_01 */
static int hf_rrc_ctfc2Bit_01;                    /* T_ctfc2Bit_01 */
static int hf_rrc_ctfc2Bit_item_01;               /* T_ctfc2Bit_item_01 */
static int hf_rrc_powerOffsetInformation_10msMode;  /* PowerOffsetInformation_10msMode */
static int hf_rrc_ctfc4Bit_01;                    /* T_ctfc4Bit_01 */
static int hf_rrc_ctfc4Bit_item_01;               /* T_ctfc4Bit_item_01 */
static int hf_rrc_ctfc6Bit_01;                    /* T_ctfc6Bit_01 */
static int hf_rrc_ctfc6Bit_item_01;               /* T_ctfc6Bit_item_01 */
static int hf_rrc_ctfc8Bit_01;                    /* T_ctfc8Bit_01 */
static int hf_rrc_ctfc8Bit_item_01;               /* T_ctfc8Bit_item_01 */
static int hf_rrc_ctfc12Bit_01;                   /* T_ctfc12Bit_01 */
static int hf_rrc_ctfc12Bit_item_01;              /* T_ctfc12Bit_item_01 */
static int hf_rrc_ctfc16Bit_01;                   /* T_ctfc16Bit_01 */
static int hf_rrc_ctfc16Bit_item_01;              /* T_ctfc16Bit_item_01 */
static int hf_rrc_ctfc24Bit_01;                   /* T_ctfc24Bit_01 */
static int hf_rrc_ctfc24Bit_item_01;              /* T_ctfc24Bit_item_01 */
static int hf_rrc_tfci;                           /* INTEGER_0_1023 */
static int hf_rrc_TFCS_RemovalList_item;          /* TFCS_Removal */
static int hf_rrc_messType;                       /* MessType */
static int hf_rrc_tm_SignallingMode;              /* T_tm_SignallingMode */
static int hf_rrc_mode1;                          /* NULL */
static int hf_rrc_mode2;                          /* T_mode2 */
static int hf_rrc_ul_controlledTrChList;          /* UL_ControlledTrChList */
static int hf_rrc_TransportChannelConcatInfo_item;  /* TransportChannelIdentity */
static int hf_rrc_dsch_transport_ch_id;           /* TransportChannelIdentity */
static int hf_rrc_dedicatedTransChTFS;            /* DedicatedTransChTFS */
static int hf_rrc_commonTransChTFS;               /* CommonTransChTFS */
static int hf_rrc_commonTransChTFS_LCR;           /* CommonTransChTFS_LCR */
static int hf_rrc_UL_AddReconfTransChInfoList_item;  /* UL_AddReconfTransChInformation */
static int hf_rrc_UL_AddReconfTransChInfoList_r6_item;  /* UL_AddReconfTransChInformation_r6 */
static int hf_rrc_UL_AddReconfTransChInfoList_r7_item;  /* UL_AddReconfTransChInformation_r7 */
static int hf_rrc_UL_AddReconfTransChInfoList_r8_item;  /* UL_AddReconfTransChInformation_r8 */
static int hf_rrc_UL_AddReconfTransChInfoList_r14_item;  /* UL_AddReconfTransChInformation_r14 */
static int hf_rrc_transportFormatSet;             /* TransportFormatSet */
static int hf_rrc_dch_usch;                       /* T_dch_usch */
static int hf_rrc_e_dch_02;                       /* T_e_dch_02 */
static int hf_rrc_tti_03;                         /* E_DCH_TTI */
static int hf_rrc_harq_Info;                      /* T_harq_Info */
static int hf_rrc_addReconf_MAC_d_FlowList;       /* E_DCH_AddReconf_MAC_d_FlowList */
static int hf_rrc_dch_usch_01;                    /* T_dch_usch_01 */
static int hf_rrc_e_dch_03;                       /* T_e_dch_03 */
static int hf_rrc_modeSpecific;                   /* T_modeSpecific */
static int hf_rrc_fdd_56;                         /* T_fdd_55 */
static int hf_rrc_harq_Info_01;                   /* T_harq_Info_01 */
static int hf_rrc_addReconf_MAC_d_FlowList_01;    /* E_DCH_AddReconf_MAC_d_FlowList_r7 */
static int hf_rrc_dch_usch_02;                    /* T_dch_usch_02 */
static int hf_rrc_e_dch_04;                       /* T_e_dch_04 */
static int hf_rrc_ul_MAC_HeaderType;              /* T_ul_MAC_HeaderType */
static int hf_rrc_modeSpecific_01;                /* T_modeSpecific_01 */
static int hf_rrc_fdd_57;                         /* T_fdd_56 */
static int hf_rrc_harq_Info_02;                   /* T_harq_Info_02 */
static int hf_rrc_dch_usch_03;                    /* T_dch_usch_03 */
static int hf_rrc_e_dch_05;                       /* T_e_dch_05 */
static int hf_rrc_ul_MAC_HeaderType_01;           /* T_ul_MAC_HeaderType_01 */
static int hf_rrc_modeSpecific_02;                /* T_modeSpecific_02 */
static int hf_rrc_fdd_58;                         /* T_fdd_57 */
static int hf_rrc_secondaryTTI;                   /* E_DCH_TTI */
static int hf_rrc_harq_Info_03;                   /* T_harq_Info_03 */
static int hf_rrc_prach_TFCS;                     /* TFCS */
static int hf_rrc_modeSpecificInfo_26;            /* T_modeSpecificInfo_26 */
static int hf_rrc_fdd_59;                         /* T_fdd_58 */
static int hf_rrc_tdd_19;                         /* T_tdd_18 */
static int hf_rrc_individualUL_CCTrCH_InfoList;   /* IndividualUL_CCTrCH_InfoList */
static int hf_rrc_modeSpecificInfo_27;            /* T_modeSpecificInfo_27 */
static int hf_rrc_fdd_60;                         /* T_fdd_59 */
static int hf_rrc_tdd_20;                         /* T_tdd_19 */
static int hf_rrc_tfc_SubsetList;                 /* TFC_SubsetList */
static int hf_rrc_modeSpecificInfo_28;            /* T_modeSpecificInfo_28 */
static int hf_rrc_fdd_61;                         /* T_fdd_60 */
static int hf_rrc_ul_TFCS_01;                     /* TFCS_r12 */
static int hf_rrc_tdd_21;                         /* T_tdd_20 */
static int hf_rrc_UL_ControlledTrChList_item;     /* TransportChannelIdentity */
static int hf_rrc_UL_DeletedTransChInfoList_item;  /* UL_TransportChannelIdentity */
static int hf_rrc_UL_DeletedTransChInfoList_r6_item;  /* UL_TransportChannelIdentity_r6 */
static int hf_rrc_ul_TransportChannelIdentity;    /* TransportChannelIdentity */
static int hf_rrc_dch_usch_04;                    /* T_dch_usch_04 */
static int hf_rrc_e_dch_06;                       /* E_DCH_MAC_d_FlowIdentity */
static int hf_rrc_USCH_TransportChannelsInfo_item;  /* USCH_TransportChannelsInfo_item */
static int hf_rrc_usch_TransportChannelIdentity;  /* TransportChannelIdentity */
static int hf_rrc_usch_TFS;                       /* TransportFormatSet */
static int hf_rrc_AC_To_ASC_MappingTable_item;    /* AC_To_ASC_Mapping */
static int hf_rrc_availableSignatureStartIndex;   /* INTEGER_0_15 */
static int hf_rrc_availableSignatureEndIndex;     /* INTEGER_0_15 */
static int hf_rrc_assignedSubChannelNumber;       /* T_assignedSubChannelNumber */
static int hf_rrc_channelisationCodeIndices;      /* T_channelisationCodeIndices */
static int hf_rrc_subchannelSize;                 /* T_subchannelSize */
static int hf_rrc_size1;                          /* NULL */
static int hf_rrc_size2;                          /* T_size2 */
static int hf_rrc_subchannels_size2;              /* T_subchannels_size2 */
static int hf_rrc_size4;                          /* T_size4 */
static int hf_rrc_subchannels_size4;              /* T_subchannels_size4 */
static int hf_rrc_size8;                          /* T_size8 */
static int hf_rrc_subchannels_size8;              /* T_subchannels_size8 */
static int hf_rrc_channelisationCodeIndices_01;   /* T_channelisationCodeIndices_01 */
static int hf_rrc_subchannelSize_01;              /* T_subchannelSize_01 */
static int hf_rrc_size2_01;                       /* T_size2_01 */
static int hf_rrc_subchannels_size2_01;           /* T_subchannels_size2_01 */
static int hf_rrc_size4_01;                       /* T_size4_01 */
static int hf_rrc_subchannels_size4_01;           /* T_subchannels_size4_01 */
static int hf_rrc_size8_01;                       /* T_size8_01 */
static int hf_rrc_subchannels_size8_01;           /* T_subchannels_size8_01 */
static int hf_rrc_size16;                         /* T_size16 */
static int hf_rrc_subchannels_size16;             /* T_subchannels_size16 */
static int hf_rrc_availableSYNC_UlCodesIndics;    /* T_availableSYNC_UlCodesIndics */
static int hf_rrc_subchannelSize_02;              /* T_subchannelSize_02 */
static int hf_rrc_size2_02;                       /* T_size2_02 */
static int hf_rrc_subchannels_size2_02;           /* T_subchannels_size2_02 */
static int hf_rrc_size4_02;                       /* T_size4_02 */
static int hf_rrc_subchannels_size4_02;           /* T_subchannels_size4_02 */
static int hf_rrc_size8_02;                       /* T_size8_02 */
static int hf_rrc_subchannels_size8_02;           /* T_subchannels_size8_02 */
static int hf_rrc_dynamicTFInformationCCCH;       /* DynamicTFInformationCCCH */
static int hf_rrc_additionalPRACH_TF_and_TFCS_CCCH_IEs;  /* AdditionalPRACH_TF_and_TFCS_CCCH_IEs */
static int hf_rrc_AdditionalPRACH_TF_and_TFCS_CCCH_List_item;  /* AdditionalPRACH_TF_and_TFCS_CCCH */
static int hf_rrc_AdditionalDLSecCellInfoListFDD_item;  /* AdditionalDLSecCellInfoFDD */
static int hf_rrc_AdditionalDLSecCellInfoListFDD_r11_item;  /* AdditionalDLSecCellInfoFDD_r11 */
static int hf_rrc_AdditionalDLSecCellInfoListFDD2_item;  /* AdditionalDLSecCellInfoFDD_r11 */
static int hf_rrc_AdditionalDLSecCellInfoHandoverToUtranListFDD_item;  /* AdditionalDLSecCellInfoFDD_HandoverToUtran */
static int hf_rrc_eDPCCH_DPCCH_PowerOffset;       /* E_DPCCH_DPCCH_PowerOffset */
static int hf_rrc_happyBit_DelayCondition;        /* HappyBit_DelayCondition */
static int hf_rrc_e_TFCI_TableIndex;              /* E_TFCI_TableIndex */
static int hf_rrc_reference_E_TFCIs;              /* E_DPDCH_Reference_E_TFCIList_r7 */
static int hf_rrc_maxChannelisationCodes;         /* E_DPDCH_MaxChannelisationCodes */
static int hf_rrc_schedulingInfoConfiguration;    /* E_DPDCH_SchedulingInfoConfiguration */
static int hf_rrc_channelisationCode256;          /* ChannelisationCode256 */
static int hf_rrc_sttd_Indicator;                 /* BOOLEAN */
static int hf_rrc_aich_TransmissionTiming;        /* AICH_TransmissionTiming */
static int hf_rrc_allocationActivationTime;       /* INTEGER_0_255 */
static int hf_rrc_allocationDuration;             /* INTEGER_1_256 */
static int hf_rrc_antenna3And4_S_CPICH;           /* Antenna3And4_S_CPICH */
static int hf_rrc_antenna3And4_D_CPICH;           /* Antenna3And4_D_CPICH */
static int hf_rrc_antenna3_S_CPICH;               /* Antenna3_S_CPICH */
static int hf_rrc_antenna4_S_CPICH;               /* Antenna4_S_CPICH */
static int hf_rrc_s_cpich_PowerOffset_Mimo;       /* S_CPICH_PowerOffset_4x4MIMO */
static int hf_rrc_antenna3_D_CPICH;               /* Antenna3_D_CPICH */
static int hf_rrc_antenna4_D_CPICH;               /* Antenna4_D_CPICH */
static int hf_rrc_d_cpich_PowerOffset_Mimo;       /* D_CPICH_PowerOffset_4x4MIMO */
static int hf_rrc_initialD_CPICHStatus;           /* T_initialD_CPICHStatus */
static int hf_rrc_channelisationCode;             /* ChannelisationCode256 */
static int hf_rrc_ap_Signature;                   /* AP_Signature */
static int hf_rrc_availableAP_SubchannelList;     /* AvailableAP_SubchannelList */
static int hf_rrc_accessServiceClass_FDD;         /* AccessServiceClass_FDD */
static int hf_rrc_accessServiceClass_TDD;         /* AccessServiceClass_TDD */
static int hf_rrc_accessServiceClass_TDD_01;      /* AccessServiceClass_TDD_r7 */
static int hf_rrc_accessServiceClass_TDD_LCR;     /* AccessServiceClass_TDD_LCR_r4 */
static int hf_rrc_AvailableAP_Signature_VCAMList_item;  /* AP_Signature_VCAM */
static int hf_rrc_AvailableAP_SignatureList_item;  /* AP_Signature */
static int hf_rrc_AvailableAP_SubchannelList_item;  /* AP_Subchannel */
static int hf_rrc_AvailableMinimumSF_ListVCAM_item;  /* AvailableMinimumSF_VCAM */
static int hf_rrc_minimumSpreadingFactor;         /* MinimumSpreadingFactor */
static int hf_rrc_nf_Max;                         /* NF_Max */
static int hf_rrc_maxAvailablePCPCH_Number;       /* MaxAvailablePCPCH_Number */
static int hf_rrc_availableAP_Signature_VCAMList;  /* AvailableAP_Signature_VCAMList */
static int hf_rrc_tfcs_Identity;                  /* TFCS_Identity */
static int hf_rrc_ul_DPCH_PowerControlInfo;       /* UL_DPCH_PowerControlInfo */
static int hf_rrc_ul_DPCH_PowerControlInfo_01;    /* UL_DPCH_PowerControlInfo_r4 */
static int hf_rrc_ul_DPCH_PowerControlInfo_02;    /* UL_DPCH_PowerControlInfo_r5 */
static int hf_rrc_ul_DPCH_PowerControlInfo_03;    /* UL_DPCH_PowerControlInfo_r7 */
static int hf_rrc_CD_AccessSlotSubchannelList_item;  /* CD_AccessSlotSubchannel */
static int hf_rrc_CD_SignatureCodeList_item;      /* CD_SignatureCode */
static int hf_rrc_burstType;                      /* BurstType */
static int hf_rrc_midambleShift;                  /* MidambleShiftLong */
static int hf_rrc_timeslot;                       /* TimeslotNumber */
static int hf_rrc_cellParametersID;               /* CellParametersID */
static int hf_rrc_notActive;                      /* NULL */
static int hf_rrc_isActive;                       /* AvailableMinimumSF_ListVCAM */
static int hf_rrc_availableAP_SignatureList;      /* AvailableAP_SignatureList */
static int hf_rrc_pdsch_CodeMapList;              /* PDSCH_CodeMapList */
static int hf_rrc_start_code;                     /* HS_ChannelisationCode_LCR */
static int hf_rrc_stop_code;                      /* HS_ChannelisationCode_LCR */
static int hf_rrc_s_offset;                       /* INTEGER_0_9 */
static int hf_rrc_f_dpch_ChannelisationCodeNumber;  /* INTEGER_0_255 */
static int hf_rrc_e_RGCH_Information_01;          /* E_RGCH_Information_CommonEdch */
static int hf_rrc_e_hich_Info;                    /* E_HICH_Information_CommonEdch */
static int hf_rrc_ul_DPCH_CodeInfoForCommonEDCH;  /* UL_DPCH_CodeInfoForCommonEDCH */
static int hf_rrc_twoMsHarqConfiguration;         /* TwoMsHarqConfiguration */
static int hf_rrc_Common_E_RNTI_Info_item;        /* Common_E_RNTI_Info_item */
static int hf_rrc_starting_E_RNTI;                /* E_RNTI */
static int hf_rrc_number_of_group;                /* INTEGER_1_maxERNTIgroup */
static int hf_rrc_number_of_ENRTI_per_group;      /* INTEGER_1_maxERNTIperGroup */
static int hf_rrc_scheduledTransmissionConfiguration;  /* ScheduledTransmissionConfiguration */
static int hf_rrc_cOffset;                        /* INTEGER_0_29 */
static int hf_rrc_ul_InterferenceForCommonEDCH;   /* UL_Interference */
static int hf_rrc_common_E_DCH_MAC_d_FlowList;    /* Common_E_DCH_MAC_d_FlowList */
static int hf_rrc_modeSpecificInfo_29;            /* T_modeSpecificInfo_29 */
static int hf_rrc_dummy_17;                       /* T_dummy_14 */
static int hf_rrc_tdd_22;                         /* T_tdd_21 */
static int hf_rrc_tdd768_07;                      /* NULL */
static int hf_rrc_tdd384_12;                      /* NULL */
static int hf_rrc_tdd128_12;                      /* T_tdd128_12 */
static int hf_rrc_e_RUCCH_Info;                   /* E_RUCCH_Info_TDD128 */
static int hf_rrc_e_PUCH_Info;                    /* E_PUCH_Info_TDD128 */
static int hf_rrc_e_hich_Information;             /* E_HICH_Information_TDD128 */
static int hf_rrc_e_agch_Information;             /* E_AGCH_Information_TDD128 */
static int hf_rrc_harq_Info_04;                   /* T_harq_Info_04 */
static int hf_rrc_ccch_transmission_Info;         /* T_ccch_transmission_Info */
static int hf_rrc_common_e_rnti_Info;             /* Common_E_RNTI_Info */
static int hf_rrc_harq_MaximumNumberOfRetransmissions;  /* INTEGER_0_7 */
static int hf_rrc_harq_retransmission_timer;      /* T_harq_retransmission_timer */
static int hf_rrc_harq_power_offset;              /* INTEGER_0_6 */
static int hf_rrc_prach_PreambleForEnhancedUplink;  /* PRACH_PreambleForEnhancedUplink */
static int hf_rrc_initialServingGrantValue;       /* INTEGER_0_37 */
static int hf_rrc_e_dch_TTI;                      /* E_DCH_TTI */
static int hf_rrc_e_agch_Information_01;          /* E_AGCH_Information */
static int hf_rrc_harq_Info_05;                   /* T_harq_Info_05 */
static int hf_rrc_ul_DPCHpowerControlInfoForCommonEDCH;  /* UL_DPCHpowerControlInfoForCommonEDCH */
static int hf_rrc_e_dpcch_Info;                   /* E_DPCCH_Info_r7 */
static int hf_rrc_e_dpdch_Info;                   /* E_DPDCH_Info_r8 */
static int hf_rrc_dl_FDPCH_TPCcommandErrorRate;   /* INTEGER_1_10 */
static int hf_rrc_additional_E_DCH_TransmitBackoff;  /* INTEGER_0_15 */
static int hf_rrc_max_CCCH_ResourceAllocation;    /* T_max_CCCH_ResourceAllocation */
static int hf_rrc_max_PeriodForCollisionResolution;  /* INTEGER_8_24 */
static int hf_rrc_e_dch_TransmitContinuationOffset;  /* T_e_dch_TransmitContinuationOffset */
static int hf_rrc_ack_nack_support_on_HS_DPCCH;   /* BOOLEAN */
static int hf_rrc_measurement_Feedback_Info;      /* Measurement_Feedback_Info_r7 */
static int hf_rrc_common_E_DCH_ResourceInfoList;  /* SEQUENCE_SIZE_1_maxEDCHs_OF_Common_E_DCH_ResourceInfoList */
static int hf_rrc_common_E_DCH_ResourceInfoList_item;  /* Common_E_DCH_ResourceInfoList */
static int hf_rrc_common_E_DCH_MAC_d_Flow_Info_List_ConcurrentTTI;  /* Common_E_DCH_MAC_d_Flow_Info_List_ConcurrentTTI */
static int hf_rrc_ul_DPCHpowerControlInfoConcurrentTTI;  /* UL_DPCHpowerControlInfoConcurrentTTI */
static int hf_rrc_e_DPCCH_DPCCH_PowerOffset;      /* E_DPCCH_DPCCH_PowerOffset */
static int hf_rrc_max_CCCH_ResourceAllocation_01;  /* T_max_CCCH_ResourceAllocation_01 */
static int hf_rrc_e_dch_TransmitContinuationOffset_01;  /* T_e_dch_TransmitContinuationOffset_01 */
static int hf_rrc_measurement_Feedback_Info_ConcurrentTTI;  /* Measurement_Feedback_Info_ConcurrentTTI */
static int hf_rrc_channelisationCode_01;          /* INTEGER_0_127 */
static int hf_rrc_signatureSequence;              /* INTEGER_0_39 */
static int hf_rrc_configurationInfo_03;           /* T_configurationInfo_03 */
static int hf_rrc_newConfiguration_07;            /* T_newConfiguration_07 */
static int hf_rrc_eRGCHNeighbourCellList;         /* BIT_STRING_SIZE_maxCellMeas */
static int hf_rrc_commonERGCHChannelConfigList;   /* SEQUENCE_SIZE_1_maxCellMeas_OF_CommonERGCHChannelConfig */
static int hf_rrc_commonERGCHChannelConfigList_item;  /* CommonERGCHChannelConfig */
static int hf_rrc_minimumServingGrantValue;       /* INTEGER_0_37 */
static int hf_rrc_reportingRange;                 /* ReportingRange */
static int hf_rrc_filterCoefficient;              /* FilterCoefficient */
static int hf_rrc_secondInterleavingMode;         /* SecondInterleavingMode */
static int hf_rrc_tfci_Coding;                    /* TFCI_Coding */
static int hf_rrc_puncturingLimit;                /* PuncturingLimit */
static int hf_rrc_repetitionPeriodAndLength;      /* RepetitionPeriodAndLength */
static int hf_rrc_repetitionPeriodLengthAndOffset;  /* RepetitionPeriodLengthAndOffset */
static int hf_rrc_controlChannelDrxOperation;     /* T_controlChannelDrxOperation */
static int hf_rrc_continue_01;                    /* T_continue */
static int hf_rrc_enablingDelay;                  /* EnablingDelay_TDD128 */
static int hf_rrc_newOperation;                   /* T_newOperation */
static int hf_rrc_hS_SCCH_Drx_Info;               /* HS_SCCH_DRX_Info_TDD128 */
static int hf_rrc_e_AGCH_Drx_Info;                /* E_AGCH_DRX_Info_TDD128 */
static int hf_rrc_cpch_SetID;                     /* CPCH_SetID */
static int hf_rrc_dynamicPersistenceLevelTF_List;  /* DynamicPersistenceLevelTF_List */
static int hf_rrc_CPCH_PersistenceLevelsList_item;  /* CPCH_PersistenceLevels */
static int hf_rrc_ap_PreambleScramblingCode;      /* AP_PreambleScramblingCode */
static int hf_rrc_ap_AICH_ChannelisationCode;     /* AP_AICH_ChannelisationCode */
static int hf_rrc_cd_PreambleScramblingCode;      /* CD_PreambleScramblingCode */
static int hf_rrc_cd_CA_ICH_ChannelisationCode;   /* CD_CA_ICH_ChannelisationCode */
static int hf_rrc_cd_AccessSlotSubchannelList;    /* CD_AccessSlotSubchannelList */
static int hf_rrc_cd_SignatureCodeList;           /* CD_SignatureCodeList */
static int hf_rrc_deltaPp_m;                      /* DeltaPp_m */
static int hf_rrc_ul_DPCCH_SlotFormat;            /* UL_DPCCH_SlotFormat */
static int hf_rrc_n_StartMessage;                 /* N_StartMessage */
static int hf_rrc_n_EOT;                          /* N_EOT */
static int hf_rrc_channelAssignmentActive;        /* ChannelAssignmentActive */
static int hf_rrc_cpch_StatusIndicationMode;      /* CPCH_StatusIndicationMode */
static int hf_rrc_pcpch_ChannelInfoList;          /* PCPCH_ChannelInfoList */
static int hf_rrc_CPCH_SetInfoList_item;          /* CPCH_SetInfo */
static int hf_rrc_configurationInfo_04;           /* T_configurationInfo_04 */
static int hf_rrc_newConfiguration_08;            /* T_newConfiguration_08 */
static int hf_rrc_ulTransmissionMode;             /* T_ulTransmissionMode */
static int hf_rrc_tenMSOnly;                      /* NULL */
static int hf_rrc_twentyMSOnly;                   /* NULL */
static int hf_rrc_tenORtwentyMS;                  /* T_tenORtwentyMS */
static int hf_rrc_ul_TransModeSwitchingParam;     /* UL_TransModeSwitchingParam */
static int hf_rrc_dlFETMode;                      /* T_dlFETMode */
static int hf_rrc_basic;                          /* NULL */
static int hf_rrc_full;                           /* T_full */
static int hf_rrc_early_dch_QualityTarget;        /* QualityTarget */
static int hf_rrc_early_dch_TargetSlot;           /* INTEGER_11_28 */
static int hf_rrc_trChConcatInfo;                 /* TransportChannelConcatInfo */
static int hf_rrc_timeInfo;                       /* TimeInfo */
static int hf_rrc_commonTimeslotInfo;             /* CommonTimeslotInfo */
static int hf_rrc_dl_CCTrCH_TimeslotsCodes;       /* DownlinkTimeslotsCodes */
static int hf_rrc_ul_CCTrChTPCList;               /* UL_CCTrChTPCList */
static int hf_rrc_tddOption_03;                   /* T_tddOption_03 */
static int hf_rrc_tdd384_13;                      /* T_tdd384_12 */
static int hf_rrc_tdd128_13;                      /* T_tdd128_13 */
static int hf_rrc_dl_CCTrCH_TimeslotsCodes_01;    /* DownlinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_tddOption_04;                   /* T_tddOption_04 */
static int hf_rrc_tdd384_14;                      /* T_tdd384_13 */
static int hf_rrc_dl_CCTrCH_TimeslotsCodes_02;    /* DownlinkTimeslotsCodes_r7 */
static int hf_rrc_tdd768_08;                      /* T_tdd768_07 */
static int hf_rrc_dl_CCTrCH_TimeslotsCodes_03;    /* DownlinkTimeslotsCodes_VHCR */
static int hf_rrc_tdd128_14;                      /* T_tdd128_14 */
static int hf_rrc_DL_CCTrChList_item;             /* DL_CCTrCh */
static int hf_rrc_DL_CCTrChList_r7_item;          /* DL_CCTrCh_r7 */
static int hf_rrc_DL_CCTrChList_r4_item;          /* DL_CCTrCh_r4 */
static int hf_rrc_DL_CCTrChListToRemove_item;     /* TFCS_IdentityPlain */
static int hf_rrc_secondaryScramblingCode;        /* SecondaryScramblingCode */
static int hf_rrc_sf_AndCodeNumber;               /* SF512_AndCodeNumber */
static int hf_rrc_scramblingCodeChange;           /* ScramblingCodeChange */
static int hf_rrc_DL_ChannelisationCodeList_item;  /* DL_ChannelisationCode */
static int hf_rrc_dl_DPCH_InfoCommon;             /* DL_DPCH_InfoCommon */
static int hf_rrc_modeSpecificInfo_30;            /* T_modeSpecificInfo_30 */
static int hf_rrc_fdd_62;                         /* T_fdd_61 */
static int hf_rrc_defaultDPCH_OffsetValue;        /* DefaultDPCH_OffsetValueFDD */
static int hf_rrc_dpch_CompressedModeInfo;        /* DPCH_CompressedModeInfo */
static int hf_rrc_tdd_23;                         /* T_tdd_22 */
static int hf_rrc_defaultDPCH_OffsetValue_01;     /* DefaultDPCH_OffsetValueTDD */
static int hf_rrc_dl_DPCH_InfoCommon_01;          /* DL_DPCH_InfoCommon_r4 */
static int hf_rrc_modeSpecificInfo_31;            /* T_modeSpecificInfo_31 */
static int hf_rrc_fdd_63;                         /* T_fdd_62 */
static int hf_rrc_sSDT_Information_01;            /* SSDT_Information_r4 */
static int hf_rrc_tdd_24;                         /* T_tdd_23 */
static int hf_rrc_tddOption_05;                   /* T_tddOption_05 */
static int hf_rrc_tdd128_15;                      /* T_tdd128_15 */
static int hf_rrc_tstd_Indicator;                 /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_32;            /* T_modeSpecificInfo_32 */
static int hf_rrc_fdd_64;                         /* T_fdd_63 */
static int hf_rrc_tdd_25;                         /* T_tdd_24 */
static int hf_rrc_tddOption_06;                   /* T_tddOption_06 */
static int hf_rrc_tdd128_16;                      /* T_tdd128_16 */
static int hf_rrc_mac_hsResetIndicator_06;        /* T_mac_hsResetIndicator_06 */
static int hf_rrc_dl_dpchInfoCommon;              /* T_dl_dpchInfoCommon */
static int hf_rrc_dl_DPCH_InfoCommon_02;          /* DL_DPCH_InfoCommon_r6 */
static int hf_rrc_dl_FDPCH_InfoCommon;            /* DL_FDPCH_InfoCommon_r6 */
static int hf_rrc_modeSpecificInfo_33;            /* T_modeSpecificInfo_33 */
static int hf_rrc_fdd_65;                         /* T_fdd_64 */
static int hf_rrc_tdd_26;                         /* T_tdd_25 */
static int hf_rrc_tddOption_07;                   /* T_tddOption_07 */
static int hf_rrc_tdd128_17;                      /* T_tdd128_17 */
static int hf_rrc_mac_hsResetIndicator_07;        /* T_mac_hsResetIndicator_07 */
static int hf_rrc_postVerificationPeriod_07;      /* T_postVerificationPeriod_07 */
static int hf_rrc_dl_dpchInfoCommon_01;           /* T_dl_dpchInfoCommon_01 */
static int hf_rrc_modeSpecificInfo_34;            /* T_modeSpecificInfo_34 */
static int hf_rrc_fdd_66;                         /* T_fdd_65 */
static int hf_rrc_tdd_27;                         /* T_tdd_26 */
static int hf_rrc_tddOption_08;                   /* T_tddOption_08 */
static int hf_rrc_tdd128_18;                      /* T_tdd128_18 */
static int hf_rrc_mac_hsResetIndicator_08;        /* T_mac_hsResetIndicator_08 */
static int hf_rrc_postVerificationPeriod_08;      /* T_postVerificationPeriod_08 */
static int hf_rrc_dl_dpchInfoCommon_02;           /* T_dl_dpchInfoCommon_02 */
static int hf_rrc_modeSpecificInfo_35;            /* T_modeSpecificInfo_35 */
static int hf_rrc_fdd_67;                         /* T_fdd_66 */
static int hf_rrc_dpch_CompressedModeInfo_01;     /* DPCH_CompressedModeInfo_r8 */
static int hf_rrc_tdd_28;                         /* T_tdd_27 */
static int hf_rrc_tddOption_09;                   /* T_tddOption_09 */
static int hf_rrc_tdd128_19;                      /* T_tdd128_19 */
static int hf_rrc_mac_hsResetIndicator_09;        /* T_mac_hsResetIndicator_09 */
static int hf_rrc_postVerificationPeriod_09;      /* T_postVerificationPeriod_09 */
static int hf_rrc_dl_dpchInfoCommon_03;           /* T_dl_dpchInfoCommon_03 */
static int hf_rrc_modeSpecificInfo_36;            /* T_modeSpecificInfo_36 */
static int hf_rrc_fdd_68;                         /* T_fdd_67 */
static int hf_rrc_dpch_CompressedModeInfo_02;     /* DPCH_CompressedModeInfo_r10 */
static int hf_rrc_tdd_29;                         /* T_tdd_28 */
static int hf_rrc_tddOption_10;                   /* T_tddOption_10 */
static int hf_rrc_tdd128_20;                      /* T_tdd128_20 */
static int hf_rrc_mac_hsResetIndicator_10;        /* T_mac_hsResetIndicator_10 */
static int hf_rrc_postVerificationPeriod_10;      /* T_postVerificationPeriod_10 */
static int hf_rrc_dl_dpchInfoCommon_04;           /* T_dl_dpchInfoCommon_04 */
static int hf_rrc_modeSpecificInfo_37;            /* T_modeSpecificInfo_37 */
static int hf_rrc_fdd_69;                         /* T_fdd_68 */
static int hf_rrc_tdd_30;                         /* T_tdd_29 */
static int hf_rrc_tddOption_11;                   /* T_tddOption_11 */
static int hf_rrc_tdd128_21;                      /* T_tdd128_21 */
static int hf_rrc_mac_hsResetIndicator_11;        /* T_mac_hsResetIndicator_11 */
static int hf_rrc_postVerificationPeriod_11;      /* T_postVerificationPeriod_11 */
static int hf_rrc_mac_hsResetIndicator_assisting_02;  /* T_mac_hsResetIndicator_assisting_02 */
static int hf_rrc_dl_dpchInfoCommon_05;           /* T_dl_dpchInfoCommon_05 */
static int hf_rrc_dl_DPCH_InfoCommon_03;          /* DL_DPCH_InfoCommon_r12 */
static int hf_rrc_modeSpecificInfo_38;            /* T_modeSpecificInfo_38 */
static int hf_rrc_fdd_70;                         /* T_fdd_69 */
static int hf_rrc_tdd_31;                         /* T_tdd_30 */
static int hf_rrc_tddOption_12;                   /* T_tddOption_12 */
static int hf_rrc_tdd128_22;                      /* T_tdd128_22 */
static int hf_rrc_mac_hsResetIndicator_12;        /* T_mac_hsResetIndicator_12 */
static int hf_rrc_postVerificationPeriod_12;      /* T_postVerificationPeriod_12 */
static int hf_rrc_mac_hsResetIndicator_assisting_03;  /* T_mac_hsResetIndicator_assisting_03 */
static int hf_rrc_dl_DPCH_InfoCommon_04;          /* DL_DPCH_InfoCommonPost */
static int hf_rrc_dl_DPCH_InfoCommon_05;          /* DL_DPCH_InfoCommonPredef */
static int hf_rrc_cfnHandling;                    /* T_cfnHandling */
static int hf_rrc_maintain;                       /* NULL */
static int hf_rrc_initialise;                     /* T_initialise */
static int hf_rrc_cfntargetsfnframeoffset;        /* Cfntargetsfnframeoffset */
static int hf_rrc_modeSpecificInfo_39;            /* T_modeSpecificInfo_39 */
static int hf_rrc_fdd_71;                         /* T_fdd_70 */
static int hf_rrc_dl_DPCH_PowerControlInfo;       /* DL_DPCH_PowerControlInfo */
static int hf_rrc_powerOffsetPilot_pdpdch;        /* PowerOffsetPilot_pdpdch */
static int hf_rrc_dl_rate_matching_restriction;   /* Dl_rate_matching_restriction */
static int hf_rrc_spreadingFactorAndPilot;        /* SF512_AndPilot */
static int hf_rrc_positionFixedOrFlexible;        /* PositionFixedOrFlexible */
static int hf_rrc_tfci_Existence;                 /* BOOLEAN */
static int hf_rrc_tdd_32;                         /* T_tdd_31 */
static int hf_rrc_cfnHandling_01;                 /* T_cfnHandling_01 */
static int hf_rrc_initialise_01;                  /* T_initialise_01 */
static int hf_rrc_modeSpecificInfo_40;            /* T_modeSpecificInfo_40 */
static int hf_rrc_fdd_72;                         /* T_fdd_71 */
static int hf_rrc_tdd_33;                         /* T_tdd_32 */
static int hf_rrc_mac_d_HFN_initial_value;        /* MAC_d_HFN_initial_value */
static int hf_rrc_cfnHandling_02;                 /* T_cfnHandling_02 */
static int hf_rrc_maintain_01;                    /* T_maintain */
static int hf_rrc_timingmaintainedsynchind;       /* TimingMaintainedSynchInd */
static int hf_rrc_initialise_02;                  /* NULL */
static int hf_rrc_modeSpecificInfo_41;            /* T_modeSpecificInfo_41 */
static int hf_rrc_fdd_73;                         /* T_fdd_72 */
static int hf_rrc_tdd_34;                         /* T_tdd_33 */
static int hf_rrc_cfnHandling_03;                 /* T_cfnHandling_03 */
static int hf_rrc_maintain_02;                    /* T_maintain_01 */
static int hf_rrc_modeSpecificInfo_42;            /* T_modeSpecificInfo_42 */
static int hf_rrc_fdd_74;                         /* T_fdd_73 */
static int hf_rrc_spreadingFactorAndPilot_01;     /* SF512_AndPilot_r12 */
static int hf_rrc_tdd_35;                         /* T_tdd_34 */
static int hf_rrc_modeSpecificInfo_43;            /* T_modeSpecificInfo_43 */
static int hf_rrc_fdd_75;                         /* T_fdd_74 */
static int hf_rrc_tdd_36;                         /* T_tdd_35 */
static int hf_rrc_fdd_76;                         /* T_fdd_75 */
static int hf_rrc_pCPICH_UsageForChannelEst;      /* PCPICH_UsageForChannelEst */
static int hf_rrc_dpch_FrameOffset;               /* DPCH_FrameOffset */
static int hf_rrc_secondaryCPICH_Info;            /* SecondaryCPICH_Info */
static int hf_rrc_dl_ChannelisationCodeList;      /* DL_ChannelisationCodeList */
static int hf_rrc_tpc_CombinationIndex;           /* TPC_CombinationIndex */
static int hf_rrc_sSDT_CellIdentity;              /* SSDT_CellIdentity */
static int hf_rrc_closedLoopTimingAdjMode;        /* ClosedLoopTimingAdjMode */
static int hf_rrc_tdd_37;                         /* T_tdd_36 */
static int hf_rrc_dl_CCTrChListToEstablish;       /* DL_CCTrChList */
static int hf_rrc_dl_CCTrChListToRemove;          /* DL_CCTrChListToRemove */
static int hf_rrc_fdd_77;                         /* T_fdd_76 */
static int hf_rrc_tdd_38;                         /* T_tdd_37 */
static int hf_rrc_dl_CCTrChListToEstablish_01;    /* DL_CCTrChList_r4 */
static int hf_rrc_fdd_78;                         /* T_fdd_77 */
static int hf_rrc_powerOffsetTPC_pdpdch;          /* PowerOffsetTPC_pdpdch */
static int hf_rrc_tdd_39;                         /* T_tdd_38 */
static int hf_rrc_fdd_79;                         /* T_fdd_78 */
static int hf_rrc_tdd_40;                         /* T_tdd_39 */
static int hf_rrc_fdd_80;                         /* T_fdd_79 */
static int hf_rrc_tdd_41;                         /* T_tdd_40 */
static int hf_rrc_dl_CCTrChListToEstablish_02;    /* DL_CCTrChList_r7 */
static int hf_rrc_fdd_81;                         /* T_fdd_80 */
static int hf_rrc_powerOffsetPO_SRB;              /* PowerOffsetPO_SRB */
static int hf_rrc_tdd_42;                         /* T_tdd_41 */
static int hf_rrc_fdd_82;                         /* T_fdd_81 */
static int hf_rrc_tdd_43;                         /* T_tdd_42 */
static int hf_rrc_fdpch_FrameOffset;              /* DPCH_FrameOffset */
static int hf_rrc_dl_ChannelisationCode;          /* INTEGER_0_255 */
static int hf_rrc_fdpch_SlotFormat;               /* FDPCH_SlotFormat */
static int hf_rrc_sttdIndication;                 /* STTDIndication */
static int hf_rrc_powerControlAlgorithm3_Config;  /* PowerControlAlgorithm3_Config */
static int hf_rrc_dl_ChannelisationCode_01;       /* DL_ChannelisationCode */
static int hf_rrc_dl_DPCH_TimeslotsCodes;         /* DownlinkTimeslotsCodes */
static int hf_rrc_modeSpecificInfo_44;            /* T_modeSpecificInfo_44 */
static int hf_rrc_fdd_83;                         /* T_fdd_82 */
static int hf_rrc_tdd_44;                         /* T_tdd_43 */
static int hf_rrc_tpc_StepSizeTDD;                /* TPC_StepSizeTDD */
static int hf_rrc_cfnHandling_04;                 /* T_cfnHandling_04 */
static int hf_rrc_maintain_03;                    /* T_maintain_02 */
static int hf_rrc_dl_FDPCH_PowerControlInfo;      /* DL_DPCH_PowerControlInfo */
static int hf_rrc_dl_FDPCH_TPCcommandErrorRate_01;  /* INTEGER_1_16 */
static int hf_rrc_hs_scch_Info;                   /* HS_SCCH_Info */
static int hf_rrc_measurement_feedback_Info;      /* Measurement_Feedback_Info */
static int hf_rrc_modeSpecificInfo_45;            /* T_modeSpecificInfo_45 */
static int hf_rrc_tdd_45;                         /* T_tdd_44 */
static int hf_rrc_tdd384_15;                      /* T_tdd384_14 */
static int hf_rrc_dl_HSPDSCH_TS_Configuration;    /* DL_HSPDSCH_TS_Configuration */
static int hf_rrc_tdd128_23;                      /* T_tdd128_23 */
static int hf_rrc_hs_PDSCH_Midamble_Configuration_tdd128;  /* HS_PDSCH_Midamble_Configuration_TDD128 */
static int hf_rrc_hs_scch_Info_01;                /* HS_SCCH_Info_r6 */
static int hf_rrc_modeSpecificInfo_46;            /* T_modeSpecificInfo_46 */
static int hf_rrc_tdd_46;                         /* T_tdd_45 */
static int hf_rrc_tdd384_16;                      /* T_tdd384_15 */
static int hf_rrc_tdd128_24;                      /* T_tdd128_24 */
static int hf_rrc_hs_scch_Info_02;                /* HS_SCCH_Info_r7 */
static int hf_rrc_measurement_feedback_Info_01;   /* Measurement_Feedback_Info_r7 */
static int hf_rrc_modeSpecificInfo_47;            /* T_modeSpecificInfo_47 */
static int hf_rrc_tdd_47;                         /* T_tdd_46 */
static int hf_rrc_tdd384_17;                      /* T_tdd384_16 */
static int hf_rrc_tdd768_09;                      /* T_tdd768_08 */
static int hf_rrc_dl_HSPDSCH_TS_Configuration_01;  /* DL_HSPDSCH_TS_Configuration_VHCR */
static int hf_rrc_tdd128_25;                      /* T_tdd128_25 */
static int hf_rrc_dl_MultiCarrier_Information;    /* DL_MultiCarrier_Information */
static int hf_rrc_fdd_84;                         /* T_fdd_83 */
static int hf_rrc_dl_64QAM_Configured;            /* T_dl_64QAM_Configured */
static int hf_rrc_modeSpecificInfo_48;            /* T_modeSpecificInfo_48 */
static int hf_rrc_tdd_48;                         /* T_tdd_47 */
static int hf_rrc_tdd384_18;                      /* T_tdd384_17 */
static int hf_rrc_tdd768_10;                      /* T_tdd768_09 */
static int hf_rrc_tdd128_26;                      /* T_tdd128_26 */
static int hf_rrc_fdd_85;                         /* T_fdd_84 */
static int hf_rrc_dl_64QAM_Configured_01;         /* T_dl_64QAM_Configured_01 */
static int hf_rrc_modeSpecificInfo_49;            /* T_modeSpecificInfo_49 */
static int hf_rrc_tdd_49;                         /* T_tdd_48 */
static int hf_rrc_tdd128_27;                      /* T_tdd128_27 */
static int hf_rrc_outofSyncWindow;                /* OutofSyncWindow */
static int hf_rrc_hs_scch_Info_03;                /* HS_SCCH_Info_r8_ext */
static int hf_rrc_hs_scch_Info_04;                /* HS_SCCH_Info_r9 */
static int hf_rrc_modeSpecificInfo_50;            /* T_modeSpecificInfo_50 */
static int hf_rrc_tdd_50;                         /* T_tdd_49 */
static int hf_rrc_tdd384_19;                      /* T_tdd384_18 */
static int hf_rrc_tdd768_11;                      /* T_tdd768_10 */
static int hf_rrc_tdd128_28;                      /* T_tdd128_28 */
static int hf_rrc_tS0_Indicator;                  /* T_tS0_Indicator */
static int hf_rrc_fdd_86;                         /* T_fdd_85 */
static int hf_rrc_dl_64QAM_Configured_02;         /* T_dl_64QAM_Configured_02 */
static int hf_rrc_measurement_feedback_Info_02;   /* Measurement_Feedback_Info_r11 */
static int hf_rrc_modeSpecificInfo_51;            /* T_modeSpecificInfo_51 */
static int hf_rrc_tdd_51;                         /* T_tdd_50 */
static int hf_rrc_tdd384_20;                      /* T_tdd384_19 */
static int hf_rrc_tdd768_12;                      /* T_tdd768_11 */
static int hf_rrc_tdd128_29;                      /* T_tdd128_29 */
static int hf_rrc_tS0_Indicator_01;               /* T_tS0_Indicator_01 */
static int hf_rrc_fdd_87;                         /* T_fdd_86 */
static int hf_rrc_dl_64QAM_Configured_03;         /* T_dl_64QAM_Configured_03 */
static int hf_rrc_measurement_feedback_Info_03;   /* Measurement_Feedback_Info_r12 */
static int hf_rrc_modeSpecificInfo_52;            /* T_modeSpecificInfo_52 */
static int hf_rrc_tdd_52;                         /* T_tdd_51 */
static int hf_rrc_tdd384_21;                      /* T_tdd384_20 */
static int hf_rrc_tdd768_13;                      /* T_tdd768_12 */
static int hf_rrc_tdd128_30;                      /* T_tdd128_30 */
static int hf_rrc_tS0_Indicator_02;               /* T_tS0_Indicator_02 */
static int hf_rrc_ts0ChannelizationCodes;         /* DL_TS_ChannelisationCodesShort */
static int hf_rrc_fdd_88;                         /* T_fdd_87 */
static int hf_rrc_dl_64QAM_Configured_04;         /* T_dl_64QAM_Configured_04 */
static int hf_rrc_DL_HSPDSCH_MultiCarrier_Information_item;  /* DL_HSPDSCH_MultiCarrier_Information_item */
static int hf_rrc_uarfcn_Carrier;                 /* UARFCN */
static int hf_rrc_hs_PDSCH_Midamble_Configuration;  /* HS_PDSCH_Midamble_Configuration_TDD128 */
static int hf_rrc_hs_SCCH_TDD128_MultiCarrier;    /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128_MultiCarrier */
static int hf_rrc_hs_SCCH_TDD128_MultiCarrier_item;  /* HS_SCCH_TDD128_MultiCarrier */
static int hf_rrc_DL_HSPDSCH_TS_Configuration_item;  /* DL_HSPDSCH_TS_Configuration_item */
static int hf_rrc_midambleShiftAndBurstType;      /* MidambleShiftAndBurstType_DL */
static int hf_rrc_DL_HSPDSCH_TS_Configuration_VHCR_item;  /* DL_HSPDSCH_TS_Configuration_VHCR_item */
static int hf_rrc_midambleShiftAndBurstType_01;   /* MidambleShiftAndBurstType_DL_VHCR */
static int hf_rrc_modeSpecificInfo_53;            /* T_modeSpecificInfo_53 */
static int hf_rrc_fdd_89;                         /* T_fdd_88 */
static int hf_rrc_pDSCH_SHO_DCH_Info;             /* PDSCH_SHO_DCH_Info */
static int hf_rrc_pDSCH_CodeMapping;              /* PDSCH_CodeMapping */
static int hf_rrc_tdd_53;                         /* PrimaryCCPCH_Info */
static int hf_rrc_dl_DPCH_InfoPerRL;              /* DL_DPCH_InfoPerRL */
static int hf_rrc_sCCPCH_InfoForFACH;             /* SCCPCH_InfoForFACH */
static int hf_rrc_modeSpecificInfo_54;            /* T_modeSpecificInfo_54 */
static int hf_rrc_fdd_90;                         /* T_fdd_89 */
static int hf_rrc_tdd_54;                         /* PrimaryCCPCH_Info_r4 */
static int hf_rrc_dl_DPCH_InfoPerRL_01;           /* DL_DPCH_InfoPerRL_r4 */
static int hf_rrc_sCCPCH_InfoForFACH_01;          /* SCCPCH_InfoForFACH_r4 */
static int hf_rrc_modeSpecificInfo_55;            /* T_modeSpecificInfo_55 */
static int hf_rrc_fdd_91;                         /* T_fdd_90 */
static int hf_rrc_servingHSDSCH_RL_indicator;     /* BOOLEAN */
static int hf_rrc_dl_DPCH_InfoPerRL_02;           /* DL_DPCH_InfoPerRL_r5 */
static int hf_rrc_modeSpecificInfo_56;            /* T_modeSpecificInfo_56 */
static int hf_rrc_fdd_92;                         /* T_fdd_91 */
static int hf_rrc_modeSpecificInfo_57;            /* T_modeSpecificInfo_57 */
static int hf_rrc_fdd_93;                         /* T_fdd_92 */
static int hf_rrc_servingEDCH_RL_indicator;       /* BOOLEAN */
static int hf_rrc_dl_dpchInfo;                    /* T_dl_dpchInfo */
static int hf_rrc_dl_DPCH_InfoPerRL_03;           /* DL_DPCH_InfoPerRL_r6 */
static int hf_rrc_dl_FDPCH_InfoPerRL;             /* DL_FDPCH_InfoPerRL_r6 */
static int hf_rrc_e_HICH_Info;                    /* T_e_HICH_Info */
static int hf_rrc_e_RGCH_Info_03;                 /* T_e_RGCH_Info_03 */
static int hf_rrc_modeSpecificInfo_58;            /* T_modeSpecificInfo_58 */
static int hf_rrc_fdd_94;                         /* T_fdd_93 */
static int hf_rrc_dl_dpchInfo_01;                 /* T_dl_dpchInfo_01 */
static int hf_rrc_dl_DPCH_InfoPerRL_04;           /* DL_DPCH_InfoPerRL_r7 */
static int hf_rrc_dl_FDPCH_InfoPerRL_01;          /* DL_FDPCH_InfoPerRL_r7 */
static int hf_rrc_e_AGCH_Information_01;          /* E_AGCH_Information_r7 */
static int hf_rrc_modeSpecificInfo2;              /* T_modeSpecificInfo2 */
static int hf_rrc_fdd_95;                         /* T_fdd_94 */
static int hf_rrc_e_HICH_Info_01;                 /* T_e_HICH_Info_01 */
static int hf_rrc_e_RGCH_Info_04;                 /* T_e_RGCH_Info_04 */
static int hf_rrc_tdd_55;                         /* T_tdd_52 */
static int hf_rrc_tdd384_tdd768;                  /* T_tdd384_tdd768 */
static int hf_rrc_e_HICH_Info_02;                 /* E_HICH_Information_TDD384_768 */
static int hf_rrc_tdd128_31;                      /* T_tdd128_31 */
static int hf_rrc_e_HICH_Info_03;                 /* E_HICH_Information_TDD128 */
static int hf_rrc_modeSpecificInfo_59;            /* T_modeSpecificInfo_59 */
static int hf_rrc_fdd_96;                         /* T_fdd_95 */
static int hf_rrc_dl_dpchInfo_02;                 /* T_dl_dpchInfo_02 */
static int hf_rrc_e_AGCH_Information_02;          /* E_AGCH_Information_r8 */
static int hf_rrc_modeSpecificInfo2_01;           /* T_modeSpecificInfo2_01 */
static int hf_rrc_fdd_97;                         /* T_fdd_96 */
static int hf_rrc_e_HICH_Info_04;                 /* T_e_HICH_Info_02 */
static int hf_rrc_e_RGCH_Info_05;                 /* T_e_RGCH_Info_05 */
static int hf_rrc_tdd_56;                         /* T_tdd_53 */
static int hf_rrc_tdd384_tdd768_01;               /* T_tdd384_tdd768_01 */
static int hf_rrc_tdd128_32;                      /* T_tdd128_32 */
static int hf_rrc_modeSpecificInfo_60;            /* T_modeSpecificInfo_60 */
static int hf_rrc_fdd_98;                         /* T_fdd_97 */
static int hf_rrc_dl_dpchInfo_03;                 /* T_dl_dpchInfo_03 */
static int hf_rrc_e_ROCH_Information;             /* E_ROCH_Information */
static int hf_rrc_modeSpecificInfo2_02;           /* T_modeSpecificInfo2_02 */
static int hf_rrc_fdd_99;                         /* T_fdd_98 */
static int hf_rrc_e_HICH_Info_05;                 /* T_e_HICH_Info_03 */
static int hf_rrc_e_HICH_Information_01;          /* E_HICH_Information_r11 */
static int hf_rrc_secondaryReleaseIndicator;      /* NULL */
static int hf_rrc_e_RGCH_Info_06;                 /* T_e_RGCH_Info_06 */
static int hf_rrc_f_TPICH_Info;                   /* T_f_TPICH_Info */
static int hf_rrc_f_TPICH_Information;            /* F_TPICH_Information */
static int hf_rrc_tdd_57;                         /* T_tdd_54 */
static int hf_rrc_tdd384_tdd768_02;               /* T_tdd384_tdd768_02 */
static int hf_rrc_tdd128_33;                      /* T_tdd128_33 */
static int hf_rrc_modeSpecificInfo_61;            /* T_modeSpecificInfo_61 */
static int hf_rrc_fdd_100;                        /* T_fdd_99 */
static int hf_rrc_dl_dpchInfo_04;                 /* T_dl_dpchInfo_04 */
static int hf_rrc_dl_DPCH_InfoPerRL_05;           /* DL_DPCH_InfoPerRL_r12 */
static int hf_rrc_radioLinkswithoutDPCHFDPCHInfo;  /* RadioLinkswithoutDPCHFDPCHInfo */
static int hf_rrc_modeSpecificInfo2_03;           /* T_modeSpecificInfo2_03 */
static int hf_rrc_fdd_101;                        /* T_fdd_100 */
static int hf_rrc_e_HICH_Info_06;                 /* T_e_HICH_Info_04 */
static int hf_rrc_e_RGCH_Info_07;                 /* T_e_RGCH_Info_07 */
static int hf_rrc_f_TPICH_Info_01;                /* T_f_TPICH_Info_01 */
static int hf_rrc_tdd_58;                         /* T_tdd_55 */
static int hf_rrc_tdd384_tdd768_03;               /* T_tdd384_tdd768_03 */
static int hf_rrc_tdd128_34;                      /* T_tdd128_34 */
static int hf_rrc_modeSpecificInfo_62;            /* T_modeSpecificInfo_62 */
static int hf_rrc_fdd_102;                        /* T_fdd_101 */
static int hf_rrc_dl_dpchInfo_05;                 /* T_dl_dpchInfo_05 */
static int hf_rrc_dl_FDPCH_InfoPerRL_02;          /* DL_FDPCH_InfoPerRL_r13 */
static int hf_rrc_modeSpecificInfo2_04;           /* T_modeSpecificInfo2_04 */
static int hf_rrc_fdd_103;                        /* T_fdd_102 */
static int hf_rrc_e_HICH_Info_07;                 /* T_e_HICH_Info_05 */
static int hf_rrc_e_RGCH_Info_08;                 /* T_e_RGCH_Info_08 */
static int hf_rrc_f_TPICH_Info_02;                /* T_f_TPICH_Info_02 */
static int hf_rrc_tdd_59;                         /* T_tdd_56 */
static int hf_rrc_tdd384_tdd768_04;               /* T_tdd384_tdd768_04 */
static int hf_rrc_tdd128_35;                      /* T_tdd128_35 */
static int hf_rrc_DL_InformationPerRL_List_item;  /* DL_InformationPerRL */
static int hf_rrc_DL_InformationPerRL_List_r4_item;  /* DL_InformationPerRL_r4 */
static int hf_rrc_DL_InformationPerRL_List_r5_item;  /* DL_InformationPerRL_r5 */
static int hf_rrc_DL_InformationPerRL_List_r6_item;  /* DL_InformationPerRL_r6 */
static int hf_rrc_DL_InformationPerRL_List_v6b0ext_item;  /* DL_InformationPerRL_v6b0ext */
static int hf_rrc_DL_InformationPerRL_List_r5bis_item;  /* DL_InformationPerRL_r5bis */
static int hf_rrc_DL_InformationPerRL_List_r7_item;  /* DL_InformationPerRL_r7 */
static int hf_rrc_DL_InformationPerRL_List_r8_item;  /* DL_InformationPerRL_r8 */
static int hf_rrc_DL_InformationPerRL_List_r11_item;  /* DL_InformationPerRL_r11 */
static int hf_rrc_DL_InformationPerRL_List_r12_item;  /* DL_InformationPerRL_r12 */
static int hf_rrc_DL_InformationPerRL_List_r13_item;  /* DL_InformationPerRL_r13 */
static int hf_rrc_DL_InformationPerRL_ListPostFDD_item;  /* DL_InformationPerRL_PostFDD */
static int hf_rrc_dl_DPCH_InfoPerRL_06;           /* DL_DPCH_InfoPerRL_PostFDD */
static int hf_rrc_primaryCCPCH_Info;              /* PrimaryCCPCH_InfoPost */
static int hf_rrc_dl_DPCH_InfoPerRL_07;           /* DL_DPCH_InfoPerRL_PostTDD */
static int hf_rrc_primaryCCPCH_Info_01;           /* PrimaryCCPCH_InfoPostTDD_LCR_r4 */
static int hf_rrc_dl_DPCH_InfoPerRL_08;           /* DL_DPCH_InfoPerRL_PostTDD_LCR_r4 */
static int hf_rrc_tsn_Length;                     /* T_tsn_Length */
static int hf_rrc_multiCarrierNumber;             /* INTEGER_1_maxTDD128Carrier */
static int hf_rrc_dl_HSPDSCH_MultiCarrier_Information;  /* DL_HSPDSCH_MultiCarrier_Information */
static int hf_rrc_restrictedTrCH_InfoList;        /* RestrictedTrCH_InfoList */
static int hf_rrc_newConfiguration_09;            /* T_newConfiguration_09 */
static int hf_rrc_dl_64QAM_Configured_05;         /* T_dl_64QAM_Configured_05 */
static int hf_rrc_dl_ScramblingCode;              /* SecondaryScramblingCode */
static int hf_rrc_hS_SCCHChannelisationCodeInfo;  /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_Codes */
static int hf_rrc_hS_SCCHChannelisationCodeInfo_item;  /* HS_SCCH_Codes */
static int hf_rrc_measurementPowerOffset;         /* MeasurementPowerOffset */
static int hf_rrc_uarfcn_DL;                      /* UARFCN */
static int hf_rrc_differentTxModeFromServingHS_DSCHCell;  /* T_differentTxModeFromServingHS_DSCHCell */
static int hf_rrc_configurationInfo_05;           /* T_configurationInfo_05 */
static int hf_rrc_newConfiguration_10;            /* T_newConfiguration_10 */
static int hf_rrc_dl_64QAM_Configured_06;         /* T_dl_64QAM_Configured_06 */
static int hf_rrc_differentTxModeFromServingHS_DSCHCell_01;  /* T_differentTxModeFromServingHS_DSCHCell_01 */
static int hf_rrc_secondaryCellMIMOparameters;    /* SecondaryCellMIMOparametersFDD */
static int hf_rrc_configurationInfo_06;           /* T_configurationInfo_06 */
static int hf_rrc_newConfiguration_11;            /* T_newConfiguration_11 */
static int hf_rrc_dl_64QAM_Configured_07;         /* T_dl_64QAM_Configured_07 */
static int hf_rrc_differentTxModeFromServingHS_DSCHCell_02;  /* T_differentTxModeFromServingHS_DSCHCell_02 */
static int hf_rrc_secondaryCellMIMOparameters_01;  /* SecondaryCellMIMOparametersFDD_r10 */
static int hf_rrc_configurationInfo_07;           /* T_configurationInfo_07 */
static int hf_rrc_newConfiguration_12;            /* T_newConfiguration_12 */
static int hf_rrc_dl_64QAM_Configured_08;         /* T_dl_64QAM_Configured_08 */
static int hf_rrc_measurementPowerOffset1;        /* MeasurementPowerOffset */
static int hf_rrc_differentTxModeFromServingHS_DSCHCell_03;  /* T_differentTxModeFromServingHS_DSCHCell_03 */
static int hf_rrc_multiflowConfigurationInfo;     /* MultiflowConfigurationInfo */
static int hf_rrc_secondaryCell4x4MIMOparameters;  /* SecondaryCell4x4MIMOparametersFDD */
static int hf_rrc_configurationInfo_08;           /* T_configurationInfo_08 */
static int hf_rrc_newConfiguration_13;            /* T_newConfiguration_13 */
static int hf_rrc_differentTxModeFromServingHS_DSCHCell_04;  /* T_differentTxModeFromServingHS_DSCHCell_04 */
static int hf_rrc_DL_TPC_PowerOffsetPerRL_List_item;  /* DL_TPC_PowerOffsetPerRL */
static int hf_rrc_codesRepresentation;            /* T_codesRepresentation */
static int hf_rrc_consecutive;                    /* T_consecutive */
static int hf_rrc_firstChannelisationCode;        /* DL_TS_ChannelisationCode */
static int hf_rrc_lastChannelisationCode;         /* DL_TS_ChannelisationCode */
static int hf_rrc_bitmap;                         /* T_bitmap */
static int hf_rrc_codesRepresentation_01;         /* T_codesRepresentation_01 */
static int hf_rrc_consecutive_01;                 /* T_consecutive_01 */
static int hf_rrc_firstChannelisationCode_01;     /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_lastChannelisationCode_01;      /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_bitmap_01;                      /* T_bitmap_01 */
static int hf_rrc_firstChannelisationCode_02;     /* INTEGER_1_15 */
static int hf_rrc_lastChannelisationCode_02;      /* INTEGER_1_15 */
static int hf_rrc_parameters;                     /* T_parameters */
static int hf_rrc_sameAsLast;                     /* T_sameAsLast */
static int hf_rrc_timeslotNumber;                 /* TimeslotNumber */
static int hf_rrc_newParameters;                  /* T_newParameters */
static int hf_rrc_individualTimeslotInfo;         /* IndividualTimeslotInfo */
static int hf_rrc_dl_TS_ChannelisationCodesShort;  /* DL_TS_ChannelisationCodesShort */
static int hf_rrc_parameters_01;                  /* T_parameters_01 */
static int hf_rrc_sameAsLast_01;                  /* T_sameAsLast_01 */
static int hf_rrc_newParameters_01;               /* T_newParameters_01 */
static int hf_rrc_individualTimeslotInfo_01;      /* IndividualTimeslotInfo_VHCR */
static int hf_rrc_dl_TS_ChannelisationCodesShort_01;  /* DL_TS_ChannelisationCodesShort_VHCR */
static int hf_rrc_parameters_02;                  /* T_parameters_02 */
static int hf_rrc_sameAsLast_02;                  /* T_sameAsLast_02 */
static int hf_rrc_timeslotNumber_01;              /* TimeslotNumber_LCR_r4 */
static int hf_rrc_newParameters_02;               /* T_newParameters_02 */
static int hf_rrc_individualTimeslotInfo_02;      /* IndividualTimeslotInfo_LCR_r4 */
static int hf_rrc_parameters_03;                  /* T_parameters_03 */
static int hf_rrc_sameAsLast_03;                  /* T_sameAsLast_03 */
static int hf_rrc_newParameters_03;               /* T_newParameters_03 */
static int hf_rrc_individualTimeslotInfo_03;      /* IndividualTimeslotInfo_r7 */
static int hf_rrc_firstIndividualTimeslotInfo;    /* IndividualTimeslotInfo */
static int hf_rrc_moreTimeslots;                  /* T_moreTimeslots */
static int hf_rrc_noMore;                         /* NULL */
static int hf_rrc_additionalTimeslots;            /* T_additionalTimeslots */
static int hf_rrc_consecutive_02;                 /* INTEGER_1_maxTS_1 */
static int hf_rrc_timeslotList;                   /* SEQUENCE_SIZE_1_maxTS_1_OF_DownlinkAdditionalTimeslots */
static int hf_rrc_timeslotList_item;              /* DownlinkAdditionalTimeslots */
static int hf_rrc_firstIndividualTimeslotInfo_01;  /* IndividualTimeslotInfo_VHCR */
static int hf_rrc_moreTimeslots_01;               /* T_moreTimeslots_01 */
static int hf_rrc_additionalTimeslots_01;         /* T_additionalTimeslots_01 */
static int hf_rrc_timeslotList_01;                /* SEQUENCE_SIZE_1_maxTS_1_OF_DownlinkAdditionalTimeslots_VHCR */
static int hf_rrc_timeslotList_item_01;           /* DownlinkAdditionalTimeslots_VHCR */
static int hf_rrc_firstIndividualTimeslotInfo_02;  /* IndividualTimeslotInfo_LCR_r4 */
static int hf_rrc_moreTimeslots_02;               /* T_moreTimeslots_02 */
static int hf_rrc_additionalTimeslots_02;         /* T_additionalTimeslots_02 */
static int hf_rrc_consecutive_03;                 /* INTEGER_1_maxTS_LCR_1 */
static int hf_rrc_timeslotList_02;                /* SEQUENCE_SIZE_1_maxTS_LCR_1_OF_DownlinkAdditionalTimeslots_LCR_r4 */
static int hf_rrc_timeslotList_item_02;           /* DownlinkAdditionalTimeslots_LCR_r4 */
static int hf_rrc_firstIndividualTimeslotInfo_03;  /* IndividualTimeslotInfo_r7 */
static int hf_rrc_moreTimeslots_03;               /* T_moreTimeslots_03 */
static int hf_rrc_additionalTimeslots_03;         /* T_additionalTimeslots_03 */
static int hf_rrc_timeslotList_03;                /* SEQUENCE_SIZE_1_maxTS_1_OF_DownlinkAdditionalTimeslots_r7 */
static int hf_rrc_timeslotList_item_03;           /* DownlinkAdditionalTimeslots_r7 */
static int hf_rrc_dpcch2TxPowerOffset;            /* Dpcch2TxPowerOffset */
static int hf_rrc_configurationInfo_09;           /* T_configurationInfo_09 */
static int hf_rrc_newConfiguration_14;            /* T_newConfiguration_14 */
static int hf_rrc_dpcch2Info;                     /* DPCCH2Info */
static int hf_rrc_f_dpchInfo;                     /* F_DPCHInfo */
static int hf_rrc_extended_E_DPCCH_DPCCHPO;       /* Extended_E_DPCCH_DPCCH_PowerOffset */
static int hf_rrc_designatedNonServingHS_DSCHCellInfo;  /* DesignatedNonServingHS_DSCHCellInfo */
static int hf_rrc_tgp_SequenceList;               /* TGP_SequenceList */
static int hf_rrc_tgp_SequenceList_01;            /* TGP_SequenceList_r8 */
static int hf_rrc_tgp_SequenceList_02;            /* TGP_SequenceList_r10 */
static int hf_rrc_tgps_Reconfiguration_CFN;       /* TGPS_Reconfiguration_CFN */
static int hf_rrc_tgp_SequenceShortList;          /* SEQUENCE_SIZE_1_maxTGPS_OF_TGP_SequenceShort */
static int hf_rrc_tgp_SequenceShortList_item;     /* TGP_SequenceShort */
static int hf_rrc_tgp_SequenceShortList_01;       /* SEQUENCE_SIZE_1_maxTGPS_OF_TGP_SequenceShort_r10 */
static int hf_rrc_tgp_SequenceShortList_item_01;  /* TGP_SequenceShort_r10 */
static int hf_rrc_ue_drx_Cycle;                   /* UE_DRX_Cycle */
static int hf_rrc_ue_drx_Cycle_InactivityThreshold;  /* UE_DRX_Cycle_InactivityThreshold */
static int hf_rrc_ue_GrantMonitoring_InactivityThreshold;  /* UE_GrantMonitoring_InactivityThreshold */
static int hf_rrc_ue_drx_GrantMonitoring;         /* BOOLEAN */
static int hf_rrc_ue_drx_Cycle2;                  /* UE_DRX_Cycle2 */
static int hf_rrc_ue_drx_Cycle2_InactivityThreshold;  /* UE_DRX_Cycle_InactivityThreshold */
static int hf_rrc_maxTFCI_Field2Value;            /* MaxTFCI_Field2Value */
static int hf_rrc_spreadingFactor;                /* SF_PDSCH */
static int hf_rrc_codeNumber;                     /* CodeNumberDSCH */
static int hf_rrc_multiCodeInfo;                  /* MultiCodeInfo */
static int hf_rrc_DSCH_MappingList_item;          /* DSCH_Mapping */
static int hf_rrc_DSCH_TransportChannelsInfo_item;  /* DSCH_TransportChannelsInfo_item */
static int hf_rrc_dsch_transport_channel_identity;  /* TransportChannelIdentity */
static int hf_rrc_dsch_TFS;                       /* TransportFormatSet */
static int hf_rrc_dtx_Info;                       /* DTX_Info */
static int hf_rrc_drx_Info;                       /* DRX_Info */
static int hf_rrc_uplink_DPCCHSlotFormatInformation;  /* Uplink_DPCCH_Slot_Format_Information */
static int hf_rrc_dtx_Info_SecondaryUplinkFrequency;  /* DTX_Info_SecondaryUplinkFrequency */
static int hf_rrc_drx_Info_01;                    /* DRX_Info_r12 */
static int hf_rrc_ue_dtx_Cycle1_10ms;             /* UE_DTX_Cycle1_10ms */
static int hf_rrc_ue_dtx_Cycle2_10ms;             /* UE_DTX_Cycle2_10ms */
static int hf_rrc_mac_dtx_Cycle_10ms;             /* MAC_DTX_Cycle_10ms */
static int hf_rrc_ue_dtx_Cycle1_2ms;              /* UE_DTX_Cycle1_2ms */
static int hf_rrc_ue_dtx_Cycle2_2ms;              /* UE_DTX_Cycle2_2ms */
static int hf_rrc_mac_dtx_Cycle_2ms;              /* MAC_DTX_Cycle_2ms */
static int hf_rrc_e_dch_TTI_Length;               /* T_e_dch_TTI_Length */
static int hf_rrc_dtx_e_dch_TTI_10ms;             /* DTX_E_DCH_TTI_10ms */
static int hf_rrc_dtx_e_dch_TTI_2ms;              /* DTX_E_DCH_TTI_2ms */
static int hf_rrc_ue_dtx_cycle2InactivityThreshold;  /* UE_DTX_Cycle2InactivityThreshold */
static int hf_rrc_ue_dtx_cycle2DefaultSG;         /* INTEGER_0_38 */
static int hf_rrc_ue_dtx_long_preamble_length;    /* UE_DTX_long_preamble_length */
static int hf_rrc_mac_InactivityThreshold;        /* MAC_InactivityThreshold */
static int hf_rrc_cqi_dtx_Timer;                  /* CQI_DTX_Timer */
static int hf_rrc_ue_dpcch_Burst1;                /* UE_DPCCH_Burst */
static int hf_rrc_ue_dpcch_Burst2;                /* UE_DPCCH_Burst */
static int hf_rrc_e_dch_TTI_Length_01;            /* T_e_dch_TTI_Length_01 */
static int hf_rrc_dtx_e_dch_TTI_10ms_01;          /* NULL */
static int hf_rrc_dtx_e_dch_TTI_2ms_01;           /* T_dtx_e_dch_TTI_2ms */
static int hf_rrc_ue_dtx_Cycle1_2ms_Secondary;    /* UE_DTX_Cycle1_2ms */
static int hf_rrc_ue_dtx_Cycle2_2ms_Secondary;    /* UE_DTX_Cycle2_2ms_Secondary */
static int hf_rrc_ue_dtx_cycle2InactivityThreshold_Secondary;  /* UE_DTX_Cycle2InactivityThreshold */
static int hf_rrc_ue_dtx_long_preamble_length_Secondary;  /* UE_DTX_long_preamble_length */
static int hf_rrc_ue_dpcch_Burst1_Secondary;      /* UE_DPCCH_Burst */
static int hf_rrc_ue_dpcch_Burst2_Secondary;      /* UE_DPCCH_Burst */
static int hf_rrc_DynamicPersistenceLevelList_item;  /* DynamicPersistenceLevel */
static int hf_rrc_DynamicPersistenceLevelTF_List_item;  /* DynamicPersistenceLevel */
static int hf_rrc_e_AGCH_DRX_InfoType;            /* T_e_AGCH_DRX_InfoType */
static int hf_rrc_sameAsHS_SCCH;                  /* NULL */
static int hf_rrc_e_AGCH_DRX_Parameters;          /* T_e_AGCH_DRX_Parameters */
static int hf_rrc_e_AGCH_DRX_Cycle;               /* ControlChannelDRXCycle_TDD128 */
static int hf_rrc_e_AGCH_InactivityMonitorThreshold;  /* E_AGCH_InactivityMonitorThreshold_TDD128 */
static int hf_rrc_e_AGCH_DRX_Offset;              /* INTEGER_0_63 */
static int hf_rrc_tS_number;                      /* INTEGER_0_14 */
static int hf_rrc_channelisation_code;            /* DL_TS_ChannelisationCode */
static int hf_rrc_midambleShiftAndBurstType_02;   /* MidambleShiftAndBurstType_EDCH */
static int hf_rrc_channelisation_code_01;         /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_firstChannelisationCode_03;     /* HS_ChannelisationCode_LCR */
static int hf_rrc_secondChannelisationCode;       /* HS_ChannelisationCode_LCR */
static int hf_rrc_midambleAllocationMode;         /* T_midambleAllocationMode */
static int hf_rrc_defaultMidamble;                /* NULL */
static int hf_rrc_commonMidamble;                 /* NULL */
static int hf_rrc_ueSpecificMidamble;             /* INTEGER_0_15 */
static int hf_rrc_midambleConfiguration;          /* INTEGER_1_8 */
static int hf_rrc_e_AGCH_ChannelisationCode;      /* E_AGCH_ChannelisationCode */
static int hf_rrc_modeSpecific_03;                /* T_modeSpecific_03 */
static int hf_rrc_fdd_104;                        /* T_fdd_103 */
static int hf_rrc_tdd_60;                         /* T_tdd_57 */
static int hf_rrc_tdd384_22;                      /* T_tdd384_21 */
static int hf_rrc_long_Term_Grant_Indicator;      /* BOOLEAN */
static int hf_rrc_length_of_TTRI_field;           /* INTEGER_1_12 */
static int hf_rrc_e_AGCH_Set_Config;              /* E_AGCH_Set_Config */
static int hf_rrc_e_AGCH_BLER_Target;             /* Bler_Target */
static int hf_rrc_tdd768_14;                      /* T_tdd768_13 */
static int hf_rrc_e_AGCH_Set_Config_01;           /* E_AGCH_Set_Config_VHCR */
static int hf_rrc_tdd128_36;                      /* T_tdd128_36 */
static int hf_rrc_rdi_Indicator;                  /* BOOLEAN */
static int hf_rrc_tpc_StepSize;                   /* TPC_StepSizeTDD */
static int hf_rrc_e_AGCH_Set_Config_02;           /* E_AGCH_Set_Config_LCR */
static int hf_rrc_modeSpecific_04;                /* T_modeSpecific_04 */
static int hf_rrc_fdd_105;                        /* T_fdd_104 */
static int hf_rrc_tdd_61;                         /* T_tdd_58 */
static int hf_rrc_tdd384_23;                      /* T_tdd384_22 */
static int hf_rrc_tdd768_15;                      /* T_tdd768_14 */
static int hf_rrc_tdd128_37;                      /* T_tdd128_37 */
static int hf_rrc_E_AGCH_Set_Config_item;         /* E_AGCH_Individual */
static int hf_rrc_E_AGCH_Set_Config_VHCR_item;    /* E_AGCH_Individual_VHCR */
static int hf_rrc_E_AGCH_Set_Config_LCR_item;     /* E_AGCH_Individual_LCR */
static int hf_rrc_e_ROCH_ChannelisationCode;      /* E_ROCH_ChannelisationCode */
static int hf_rrc_e_roch_e_rnti;                  /* E_RNTI */
static int hf_rrc_e_DCH_RL_InfoNewServingCell;    /* E_DCH_RL_InfoNewServingCell */
static int hf_rrc_e_DCH_RL_InfoOtherCellList;     /* SEQUENCE_SIZE_1_maxEDCHRL_OF_E_DCH_RL_InfoOtherCell */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_item;  /* E_DCH_RL_InfoOtherCell */
static int hf_rrc_e_DCH_RL_InfoNewServingCell_01;  /* E_DCH_RL_InfoNewServingCell_r7 */
static int hf_rrc_e_DCH_RL_InfoNewServingCell_02;  /* E_DCH_RL_InfoNewServingCell_r11 */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_01;  /* SEQUENCE_SIZE_1_maxEDCHRL_OF_E_DCH_RL_InfoOtherCell_r11 */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_item_01;  /* E_DCH_RL_InfoOtherCell_r11 */
static int hf_rrc_e_DCH_RL_InfoNewSecServingCell;  /* E_DCH_RL_InfoNewSecServingCell */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_SecULFreq;  /* SEQUENCE_SIZE_1_maxEDCHRL_OF_E_DCH_RL_InfoOtherCell_SecULFreq */
static int hf_rrc_e_DCH_RL_InfoOtherCellList_SecULFreq_item;  /* E_DCH_RL_InfoOtherCell_SecULFreq */
static int hf_rrc_servingGrant_03;                /* T_servingGrant_03 */
static int hf_rrc_value;                          /* INTEGER_0_38 */
static int hf_rrc_primary_Secondary_GrantSelector_03;  /* T_primary_Secondary_GrantSelector_03 */
static int hf_rrc_reference_E_TFCIs_01;           /* E_DPDCH_Reference_E_TFCIList */
static int hf_rrc_powerOffsetForSchedInfo;        /* INTEGER_0_6 */
static int hf_rrc_threeIndexStepThreshold;        /* INTEGER_0_37 */
static int hf_rrc_twoIndexStepThreshold;          /* INTEGER_0_37 */
static int hf_rrc_e_RGCH_Info_09;                 /* T_e_RGCH_Info_09 */
static int hf_rrc_servingGrant_04;                /* T_servingGrant_04 */
static int hf_rrc_primary_Secondary_GrantSelector_04;  /* T_primary_Secondary_GrantSelector_04 */
static int hf_rrc_e_RGCH_Info_10;                 /* T_e_RGCH_Info_10 */
static int hf_rrc_servingGrant_05;                /* T_servingGrant_05 */
static int hf_rrc_primary_Secondary_GrantSelector_05;  /* T_primary_Secondary_GrantSelector_05 */
static int hf_rrc_e_RGCH_Info_11;                 /* T_e_RGCH_Info_11 */
static int hf_rrc_e_RGCH_Info_12;                 /* T_e_RGCH_Info_12 */
static int hf_rrc_e_HICH_Info_08;                 /* T_e_HICH_Info_06 */
static int hf_rrc_e_RGCH_Info_13;                 /* T_e_RGCH_Info_13 */
static int hf_rrc_e_HICH_Info_09;                 /* T_e_HICH_Info_07 */
static int hf_rrc_e_RGCH_Info_14;                 /* T_e_RGCH_Info_14 */
static int hf_rrc_e_RGCH_Info_15;                 /* T_e_RGCH_Info_15 */
static int hf_rrc_e_dch_SPS_Operation;            /* T_e_dch_SPS_Operation */
static int hf_rrc_newOperation_01;                /* E_DCH_SPS_NewOperation_TDD128 */
static int hf_rrc_e_hich_Info_01;                 /* E_HICH_Information_For_SPS_TDD128 */
static int hf_rrc_e_dch_TxPattern;                /* E_DCH_TxPatternList_TDD128 */
static int hf_rrc_initialSPSInfoForEDCH;          /* T_initialSPSInfoForEDCH */
static int hf_rrc_n_E_UCCH;                       /* INTEGER_1_8 */
static int hf_rrc_codeResourceInfo;               /* UL_TS_ChannelisationCode */
static int hf_rrc_timeslotResourceRelatedInfo;    /* BIT_STRING_SIZE_5 */
static int hf_rrc_powerResourceRelatedInfo;       /* INTEGER_1_32 */
static int hf_rrc_subframeNum;                    /* INTEGER_0_1 */
static int hf_rrc_initialTxPatternIndex;          /* INTEGER_0_maxEDCHTxPattern_TDD128_1 */
static int hf_rrc_E_DCH_TxPatternList_TDD128_item;  /* E_DCH_TxPatternList_TDD128_item */
static int hf_rrc_repetitionPeriodAndLength_01;   /* RepetitionPeriodAndLengthForSPS */
static int hf_rrc_e_DCH_MinimumSet_E_TFCI;        /* E_DCH_MinimumSet_E_TFCI */
static int hf_rrc_pl_NonMax;                      /* E_DPDCH_PL_NonMax */
static int hf_rrc_reference_E_TFCI;               /* INTEGER_0_127 */
static int hf_rrc_reference_E_TFCI_PO;            /* INTEGER_0_29 */
static int hf_rrc_reference_E_TFCI_PO_r7;         /* INTEGER_0_31 */
static int hf_rrc_E_DPDCH_Reference_E_TFCIList_item;  /* E_DPDCH_Reference_E_TFCI */
static int hf_rrc_E_DPDCH_Reference_E_TFCIList_r7_item;  /* E_DPDCH_Reference_E_TFCI_r7 */
static int hf_rrc_periodicityOfSchedInfo_NoGrant;  /* E_DPDCH_PeriodicyOfSchedInfo */
static int hf_rrc_periodicityOfSchedInfo_Grant;   /* E_DPDCH_PeriodicyOfSchedInfo */
static int hf_rrc_servingGrant_06;                /* T_servingGrant_06 */
static int hf_rrc_primary_Secondary_GrantSelector_06;  /* T_primary_Secondary_GrantSelector_06 */
static int hf_rrc_channelisationCode_02;          /* E_HICH_ChannelisationCode */
static int hf_rrc_signatureSequence_01;           /* E_HICH_RGCH_SignatureSequence */
static int hf_rrc_secondarySignatureSequence;     /* E_HICH_RGCH_SignatureSequence */
static int hf_rrc_n_E_HICH;                       /* INTEGER_4_44 */
static int hf_rrc_tS_Number;                      /* INTEGER_0_14 */
static int hf_rrc_modeSpecificInfo_63;            /* T_modeSpecificInfo_63 */
static int hf_rrc_tdd384_24;                      /* DL_TS_ChannelisationCode */
static int hf_rrc_tdd768_16;                      /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_burst_Type;                     /* T_burst_Type */
static int hf_rrc_midamble_Allocation_Mode;       /* T_midamble_Allocation_Mode */
static int hf_rrc_ei;                             /* INTEGER_0_3 */
static int hf_rrc_channelisation_Code;            /* HS_ChannelisationCode_LCR */
static int hf_rrc_midambleAllocationMode_01;      /* T_midambleAllocationMode_01 */
static int hf_rrc_n_E_HICH_01;                    /* INTEGER_4_15 */
static int hf_rrc_e_HICH_InfoList;                /* E_HICH_Information_LCR_List */
static int hf_rrc_E_HICH_Information_LCR_List_item;  /* E_HICH_Information_LCR */
static int hf_rrc_configurationmode;              /* T_configurationmode */
static int hf_rrc_implicit_01;                    /* T_implicit */
static int hf_rrc_explicit_04;                    /* T_explicit_03 */
static int hf_rrc_midambleAllocationMode_02;      /* T_midambleAllocationMode_02 */
static int hf_rrc_signatureSequenceGroupIndex;    /* INTEGER_0_19 */
static int hf_rrc_e_TFCS_Info;                    /* E_TFCS_Info */
static int hf_rrc_modeSpecificInfo_64;            /* T_modeSpecificInfo_64 */
static int hf_rrc_tdd348_tdd768;                  /* T_tdd348_tdd768 */
static int hf_rrc_noSlotsForTFCIandTPC;           /* INTEGER_1_12 */
static int hf_rrc_e_PUCH_ContantValue;            /* INTEGER_M35_10 */
static int hf_rrc_e_PUCH_TS_ConfigurationList;    /* SEQUENCE_SIZE_1_maxTS_2_OF_E_PUCH_TS_Slots */
static int hf_rrc_e_PUCH_TS_ConfigurationList_item;  /* E_PUCH_TS_Slots */
static int hf_rrc_e_PUCH_CodeHopping;             /* BOOLEAN */
static int hf_rrc_e_PUCH_TPC_Step_Size;           /* INTEGER_1_3 */
static int hf_rrc_minimum_Allowed_Code_Rate;      /* INTEGER_0_63 */
static int hf_rrc_maximum_Allowed_Code_Rate;      /* INTEGER_0_63 */
static int hf_rrc_tdd128_38;                      /* T_tdd128_38 */
static int hf_rrc_snpl_ReportType;                /* T_snpl_ReportType */
static int hf_rrc_prxdes_base;                    /* INTEGER_M112_M50 */
static int hf_rrc_beaconPLEst_bool;               /* BOOLEAN */
static int hf_rrc_pebase_PowerControlGAP;         /* PowerControlGAP */
static int hf_rrc_e_PUCH_TS_ConfigurationList_01;  /* SEQUENCE_SIZE_1_maxTS_LCR_1_OF_E_PUCH_TS_Slots_LCR */
static int hf_rrc_e_PUCH_TS_ConfigurationList_item_01;  /* E_PUCH_TS_Slots_LCR */
static int hf_rrc_maximumNumOfRetransSchedInfo;   /* INTEGER_0_15 */
static int hf_rrc_retransTimerForSchedInfo;       /* T_retransTimerForSchedInfo */
static int hf_rrc_snpl_ReportType_01;             /* T_snpl_ReportType_01 */
static int hf_rrc_pebase_PowerControlGAP_01;      /* INTEGER_1_255 */
static int hf_rrc_retransTimerForSchedInfo_01;    /* T_retransTimerForSchedInfo_01 */
static int hf_rrc_dummy_int_0_6;                  /* INTEGER_0_6 */
static int hf_rrc_ts_Number;                      /* INTEGER_0_14 */
static int hf_rrc_midambleAllocationMode_03;      /* T_midambleAllocationMode_03 */
static int hf_rrc_rg_CombinationIndex;            /* E_RGCH_CombinationIndex */
static int hf_rrc_modeSpecificInfo_65;            /* T_modeSpecificInfo_65 */
static int hf_rrc_tdd384_tdd768_05;               /* T_tdd384_tdd768_05 */
static int hf_rrc_e_RUCCH_ConstantValue;          /* INTEGER_M35_10 */
static int hf_rrc_e_RUCCH_PersistenceScalingFactor;  /* PersistenceScalingFactor */
static int hf_rrc_t_RUCCH;                        /* T_t_RUCCH */
static int hf_rrc_e_RUCCH_TS_Number;              /* INTEGER_0_14 */
static int hf_rrc_e_RUCCH_Midamble;               /* T_e_RUCCH_Midamble */
static int hf_rrc_t_adv;                          /* T_t_adv */
static int hf_rrc_t_SCHED;                        /* T_t_SCHED */
static int hf_rrc_modeSpecificInfo_66;            /* T_modeSpecificInfo_66 */
static int hf_rrc_tdd384_25;                      /* T_tdd384_23 */
static int hf_rrc_sF16;                           /* SEQUENCE_SIZE_1_8_OF_SF16Codes */
static int hf_rrc_sF16_item;                      /* SF16Codes */
static int hf_rrc_sF8;                            /* SEQUENCE_SIZE_1_8_OF_SF8Codes */
static int hf_rrc_sF8_item;                       /* SF8Codes */
static int hf_rrc_tdd768_17;                      /* T_tdd768_15 */
static int hf_rrc_sF32;                           /* SEQUENCE_SIZE_1_16_OF_SF32Codes */
static int hf_rrc_sF32_item;                      /* SF32Codes */
static int hf_rrc_sF816;                          /* SEQUENCE_SIZE_1_16_OF_SF16Codes2 */
static int hf_rrc_sF816_item;                     /* SF16Codes2 */
static int hf_rrc_tdd128_39;                      /* T_tdd128_39 */
static int hf_rrc_t_RUCCH_01;                     /* T_t_RUCCH_01 */
static int hf_rrc_n_RUCCH;                        /* INTEGER_0_7 */
static int hf_rrc_t_WAIT;                         /* T_t_WAIT */
static int hf_rrc_t_SI;                           /* T_t_SI */
static int hf_rrc_extendedEstimationWindow;       /* INTEGER_2_5 */
static int hf_rrc_e_RUCCH_AccessServiceClass;     /* E_RUCCH_AccessServiceClass */
static int hf_rrc_e_RUCCH_PersistenceScalingFactor_01;  /* PersistenceScalingFactorList */
static int hf_rrc_sync_UL_InfoForE_RUCCH;         /* SYNC_UL_InfoForE_RUCCH */
static int hf_rrc_prach_information;              /* PRACH_Information_LCR_List */
static int hf_rrc_t_RUCCH_02;                     /* T_t_RUCCH_02 */
static int hf_rrc_t_WAIT_01;                      /* T_t_WAIT_01 */
static int hf_rrc_t_SI_01;                        /* T_t_SI_01 */
static int hf_rrc_e_TFCI_Boost;                   /* INTEGER_0_127 */
static int hf_rrc_delta_T2TP;                     /* INTEGER_0_6 */
static int hf_rrc_reference_Beta_QPSK_List;       /* SEQUENCE_SIZE_1_8_OF_Reference_Beta_QPSK */
static int hf_rrc_reference_Beta_QPSK_List_item;  /* Reference_Beta_QPSK */
static int hf_rrc_reference_Beta_16QAM_List;      /* SEQUENCE_SIZE_1_8_OF_Reference_Beta_16QAM */
static int hf_rrc_reference_Beta_16QAM_List_item;  /* Reference_Beta_16QAM */
static int hf_rrc_earfcnExt;                      /* EARFCNExtension */
static int hf_rrc_modeSpecificInfo_67;            /* T_modeSpecificInfo_67 */
static int hf_rrc_tdd384_26;                      /* T_tdd384_24 */
static int hf_rrc_ex_ul_TimingAdvance;            /* INTEGER_0_255 */
static int hf_rrc_tdd768_18;                      /* T_tdd768_16 */
static int hf_rrc_ex_ul_TimingAdvance_01;         /* INTEGER_0_511 */
static int hf_rrc_fdpch_SlotFormat_01;            /* INTEGER_0_9 */
static int hf_rrc_codeNumber_01;                  /* INTEGER_0_255 */
static int hf_rrc_ctch_Indicator;                 /* BOOLEAN */
static int hf_rrc_FACH_PCH_InformationList_item;  /* FACH_PCH_Information */
static int hf_rrc_cCCH_Fallback;                  /* BOOLEAN */
static int hf_rrc_dCCH_Fallback;                  /* BOOLEAN */
static int hf_rrc_timeslot_01;                    /* TimeslotNumber_LCR_r4 */
static int hf_rrc_channelisationCode_03;          /* TDD_FPACH_CCode16_r4 */
static int hf_rrc_midambleShiftAndBurstType_03;   /* MidambleShiftAndBurstType_LCR_r4 */
static int hf_rrc_wi;                             /* Wi_LCR */
static int hf_rrc_f_tpich_Information;            /* F_TPICH_Information */
static int hf_rrc_f_tpich_Info;                   /* T_f_tpich_Info */
static int hf_rrc_ftpich_SlotFormat;              /* FTPICH_SlotFormat */
static int hf_rrc_ftpich_CodeNumber;              /* INTEGER_0_255 */
static int hf_rrc_ftpich_FrameOffset;             /* FTPICH_FrameOffset */
static int hf_rrc_f_tpich_InfoNewServingCell;     /* F_TPICH_InfoNewServingCell */
static int hf_rrc_f_tpich_InfoOtherCellList;      /* SEQUENCE_SIZE_1_maxRL_OF_F_TPICH_InfoOtherCell */
static int hf_rrc_f_tpich_InfoOtherCellList_item;  /* F_TPICH_InfoOtherCell */
static int hf_rrc_FreqIndexListForEnhancedMeas_item;  /* FrequencyIndexForEnhancedMeas */
static int hf_rrc_FreqIndexListForEnhancedMeas_r12_item;  /* FrequencyIndexForEnhancedMeas_r12 */
static int hf_rrc_modeSpecificInfo_68;            /* T_modeSpecificInfo_68 */
static int hf_rrc_fdd_106;                        /* FrequencyInfoFDD */
static int hf_rrc_tdd_62;                         /* FrequencyInfoTDD */
static int hf_rrc_uarfcn_UL;                      /* UARFCN */
static int hf_rrc_uarfcn_Nt;                      /* UARFCN */
static int hf_rrc_startCode;                      /* HS_ChannelisationCode_LCR */
static int hf_rrc_stopCode;                       /* HS_ChannelisationCode_LCR */
static int hf_rrc_ccch_MappingInfo;               /* CommonRBMappingInfo */
static int hf_rrc_srb1_MappingInfo;               /* CommonRBMappingInfo */
static int hf_rrc_common_MAC_ehs_ReorderingQueueList;  /* Common_MAC_ehs_ReorderingQueueList */
static int hf_rrc_hs_scch_SystemInfo;             /* HS_SCCH_SystemInfo */
static int hf_rrc_harq_SystemInfo;                /* HARQ_Info */
static int hf_rrc_common_H_RNTI_information;      /* SEQUENCE_SIZE_1_maxCommonHRNTI_OF_H_RNTI */
static int hf_rrc_common_H_RNTI_information_item;  /* H_RNTI */
static int hf_rrc_bcchSpecific_H_RNTI;            /* H_RNTI */
static int hf_rrc_hs_scch_SystemInfo_tdd128;      /* HS_SCCH_SystemInfo_TDD128 */
static int hf_rrc_hs_pdsch_MidambleConfiguration;  /* HS_PDSCH_Midamble_Configuration_TDD128 */
static int hf_rrc_t_321;                          /* T_321 */
static int hf_rrc_hs_dsch_DrxCycleFach;           /* HS_DSCH_DrxCycleFach */
static int hf_rrc_hs_dsch_DrxBurstFach;           /* HS_DSCH_DrxBurstFach */
static int hf_rrc_drxInterruption_hs_dsch;        /* BOOLEAN */
static int hf_rrc_hs_dsch_SecondDrx_CycleFach;    /* HS_DSCH_SecondDrx_CycleFach */
static int hf_rrc_drx_level;                      /* T_drx_level */
static int hf_rrc_one_level_DRX;                  /* T_one_level_DRX */
static int hf_rrc_hs_dsch_Second_Rx_BurstFach;    /* HS_DSCH_Second_Rx_BurstFach */
static int hf_rrc_t329;                           /* T_329 */
static int hf_rrc_two_level_DRX;                  /* T_two_level_DRX */
static int hf_rrc_t328;                           /* T_328 */
static int hf_rrc_hs_dsch_First_Rx_BurstFach;     /* HS_DSCH_First_Rx_BurstFach */
static int hf_rrc_hs_dsch_First_Drx_CycleFach;    /* HS_DSCH_First_Drx_CycleFach */
static int hf_rrc_dlScramblingCode;               /* SecondaryScramblingCode */
static int hf_rrc_pich_ForHSDPASupportedPagingList;  /* SEQUENCE_SIZE_1_maxSCCPCH_OF_PICH_ForHSDPASupportedPaging */
static int hf_rrc_pich_ForHSDPASupportedPagingList_item;  /* PICH_ForHSDPASupportedPaging */
static int hf_rrc_numberOfPcchTransmissions;      /* INTEGER_1_5 */
static int hf_rrc_transportBlockSizeList;         /* SEQUENCE_SIZE_1_2_OF_TransportBlockSizeIndex */
static int hf_rrc_transportBlockSizeList_item;    /* TransportBlockSizeIndex */
static int hf_rrc_pich_ForHsdschList;             /* SEQUENCE_SIZE_1_maxSCCPCH_OF_PICH_ForHSDPASupportedPaging_TDD128 */
static int hf_rrc_pich_ForHsdschList_item;        /* PICH_ForHSDPASupportedPaging_TDD128 */
static int hf_rrc_dtch_DCCH_reception_window_size;  /* INTEGER_1_16 */
static int hf_rrc_pcch_InformationList;           /* PCCH_InformationList */
static int hf_rrc_HS_DSCH_RxPatternList_TDD128_item;  /* HS_DSCH_RxPatternList_TDD128_item */
static int hf_rrc_HS_DSCH_TbsList_TDD128_item;    /* HS_DSCH_TbsList_TDD128_item */
static int hf_rrc_hs_dsch_TBSizeIndex;            /* INTEGER_1_63 */
static int hf_rrc_hs_dsch_SPS_Operation;          /* T_hs_dsch_SPS_Operation */
static int hf_rrc_newOperation_02;                /* HS_DSCH_SPS_NewOperation_TDD128 */
static int hf_rrc_hs_dsch_TbsList;                /* HS_DSCH_TbsList_TDD128 */
static int hf_rrc_hs_dsch_RxPatternList;          /* HS_DSCH_RxPatternList_TDD128 */
static int hf_rrc_hARQInfoForSPS;                 /* T_hARQInfoForSPS */
static int hf_rrc_memorySize_01;                  /* HARQMemorySize */
static int hf_rrc_hs_sich_List;                   /* HS_SICH_List_TDD128 */
static int hf_rrc_initialSPSInfoForHSDSCH;        /* T_initialSPSInfoForHSDSCH */
static int hf_rrc_timeslotInfo;                   /* BIT_STRING_SIZE_5 */
static int hf_rrc_codeResourceInfo_01;            /* HS_ChannelisationCodeSetInfo_LCR */
static int hf_rrc_sfnNum;                         /* INTEGER_0_1 */
static int hf_rrc_initialRxPatternIndex;          /* INTEGER_0_maxRxPatternForHSDSCH_TDD128_1 */
static int hf_rrc_initialTfsIndex;                /* INTEGER_0_maxTbsForHSDSCH_TDD128_1 */
static int hf_rrc_modulation;                     /* T_modulation */
static int hf_rrc_hs_sich_Index;                  /* INTEGER_0_maxHSSICH_TDD128_1 */
static int hf_rrc_hs_dpcch_ReductionType;         /* T_hs_dpcch_ReductionType */
static int hf_rrc_feedback_cycle2;                /* Feedback_cycle2 */
static int hf_rrc_cqi_CycleSwitchTimer;           /* CQI_CycleSwitchTimer */
static int hf_rrc_midambleAllocationMode_04;      /* T_midambleAllocationMode_04 */
static int hf_rrc_modeSpecificInfo_69;            /* T_modeSpecificInfo_69 */
static int hf_rrc_fdd_107;                        /* T_fdd_105 */
static int hf_rrc_tdd_63;                         /* T_tdd_59 */
static int hf_rrc_tdd384_27;                      /* T_tdd384_25 */
static int hf_rrc_nack_ack_power_offset;          /* INTEGER_M7_8 */
static int hf_rrc_hs_SICH_PowerControl_Info;      /* HS_SICH_Power_Control_Info_TDD384 */
static int hf_rrc_hS_SCCH_SetConfiguration;       /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD384 */
static int hf_rrc_hS_SCCH_SetConfiguration_item;  /* HS_SCCH_TDD384 */
static int hf_rrc_tdd128_40;                      /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128 */
static int hf_rrc_tdd128_item;                    /* HS_SCCH_TDD128 */
static int hf_rrc_modeSpecificInfo_70;            /* T_modeSpecificInfo_70 */
static int hf_rrc_fdd_108;                        /* T_fdd_106 */
static int hf_rrc_tdd_64;                         /* T_tdd_60 */
static int hf_rrc_tdd384_28;                      /* T_tdd384_26 */
static int hf_rrc_bler_target;                    /* Bler_Target */
static int hf_rrc_hS_SCCH_SetConfiguration_01;    /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD384_r6 */
static int hf_rrc_hS_SCCH_SetConfiguration_item_01;  /* HS_SCCH_TDD384_r6 */
static int hf_rrc_tdd128_41;                      /* T_tdd128_40 */
static int hf_rrc_power_level_HSSICH;             /* INTEGER_M120_M58 */
static int hf_rrc_tpc_step_size;                  /* T_tpc_step_size */
static int hf_rrc_hS_SCCH_SetConfiguration_02;    /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128_r6 */
static int hf_rrc_hS_SCCH_SetConfiguration_item_02;  /* HS_SCCH_TDD128_r6 */
static int hf_rrc_modeSpecificInfo_71;            /* T_modeSpecificInfo_71 */
static int hf_rrc_fdd_109;                        /* T_fdd_107 */
static int hf_rrc_tdd_65;                         /* T_tdd_61 */
static int hf_rrc_tdd384_29;                      /* T_tdd384_27 */
static int hf_rrc_tdd768_19;                      /* T_tdd768_17 */
static int hf_rrc_hs_SICH_PowerControl_Info_01;   /* HS_SICH_Power_Control_Info_TDD768 */
static int hf_rrc_hS_SCCH_SetConfiguration_03;    /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD768 */
static int hf_rrc_hS_SCCH_SetConfiguration_item_03;  /* HS_SCCH_TDD768 */
static int hf_rrc_tdd128_42;                      /* T_tdd128_41 */
static int hf_rrc_tpc_step_size_01;               /* T_tpc_step_size_01 */
static int hf_rrc_powerControlGAP;                /* PowerControlGAP */
static int hf_rrc_pathlossCompensationSwitch;     /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_72;            /* T_modeSpecificInfo_72 */
static int hf_rrc_tdd_66;                         /* T_tdd_62 */
static int hf_rrc_tdd128_43;                      /* T_tdd128_42 */
static int hf_rrc_hS_SCCH_tpc_step_size;          /* T_hS_SCCH_tpc_step_size */
static int hf_rrc_modeSpecificInfo_73;            /* T_modeSpecificInfo_73 */
static int hf_rrc_fdd_110;                        /* T_fdd_108 */
static int hf_rrc_tdd_67;                         /* T_tdd_63 */
static int hf_rrc_tdd384_30;                      /* T_tdd384_28 */
static int hf_rrc_tdd768_20;                      /* T_tdd768_18 */
static int hf_rrc_tdd128_44;                      /* T_tdd128_43 */
static int hf_rrc_tpc_step_size_02;               /* T_tpc_step_size_02 */
static int hf_rrc_hS_SCCH_tpc_step_size_01;       /* T_hS_SCCH_tpc_step_size_01 */
static int hf_rrc_hS_SCCH_DRX_Cycle;              /* ControlChannelDRXCycle_TDD128 */
static int hf_rrc_hS_SCCH_DRX_InactivityThreshold;  /* HS_SCCH_DRX_InactivityThreshold_TDD128 */
static int hf_rrc_hS_SCCH_DRX_Offset;             /* INTEGER_0_63 */
static int hf_rrc_hs_pdsch_CodeIndex;             /* INTEGER_1_15 */
static int hf_rrc_hs_scch_LessTFS;                /* HS_SCCH_LessTFSList */
static int hf_rrc_hs_scchLessOperation;           /* T_hs_scchLessOperation */
static int hf_rrc_newOperation_03;                /* HS_SCCH_Less_NewOperation */
static int hf_rrc_HS_SCCH_LessTFSList_item;       /* HS_SCCH_LessTFSList_item */
static int hf_rrc_hs_scch_LessTFSI;               /* INTEGER_1_90 */
static int hf_rrc_hs_scch_LessSecondCodeSupport;  /* BOOLEAN */
static int hf_rrc_hs_SCCH_SetConfiguration;       /* SEQUENCE_SIZE_1_maxHSSCCHs_OF_HS_SCCH_TDD128_r6 */
static int hf_rrc_hs_SCCH_SetConfiguration_item;  /* HS_SCCH_TDD128_r6 */
static int hf_rrc_tpc_step_size_03;               /* T_tpc_step_size_03 */
static int hf_rrc_power_control_gap;              /* INTEGER_1_255 */
static int hf_rrc_pathloss_compensation_switch;   /* BOOLEAN */
static int hf_rrc_midambleAllocationMode_05;      /* T_midambleAllocationMode_05 */
static int hf_rrc_hs_sich_configuration;          /* HS_SICH_Configuration_TDD128 */
static int hf_rrc_midambleAllocationMode_06;      /* T_midambleAllocationMode_06 */
static int hf_rrc_hs_sich_configuration_01;       /* HS_SICH_Configuration_TDD128_r6 */
static int hf_rrc_uarfcn_HS_SCCH_Rx;              /* UARFCN */
static int hf_rrc_midambleAllocationMode_07;      /* T_midambleAllocationMode_07 */
static int hf_rrc_channelisationCode_04;          /* HS_ChannelisationCode_LCR */
static int hf_rrc_midambleAllocationMode_08;      /* T_midambleAllocationMode_08 */
static int hf_rrc_ueSpecificMidamble_01;          /* T_ueSpecificMidamble */
static int hf_rrc_tpc_step_size_04;               /* T_tpc_step_size_04 */
static int hf_rrc_midambleAllocationMode_09;      /* T_midambleAllocationMode_09 */
static int hf_rrc_ueSpecificMidamble_02;          /* T_ueSpecificMidamble_01 */
static int hf_rrc_HS_SICH_List_TDD128_item;       /* HS_SICH_List_TDD128_item */
static int hf_rrc_implicit_02;                    /* T_implicit_01 */
static int hf_rrc_hS_SCCH_Index;                  /* INTEGER_0_maxHSSCCHs_1 */
static int hf_rrc_explicit_05;                    /* T_explicit_04 */
static int hf_rrc_hS_SICH_Info;                   /* HS_SICH_Configuration_TDD128_r6 */
static int hf_rrc_HS_SICH_ReferenceSignalInfoList_item;  /* HS_SICH_ReferenceSignalInfoList_item */
static int hf_rrc_midambleShift_01;               /* INTEGER_0_15 */
static int hf_rrc_timeSlot;                       /* INTEGER_1_5 */
static int hf_rrc_channelisationCode_05;          /* DL_TS_ChannelisationCode */
static int hf_rrc_midambleAllocationMode_10;      /* T_midambleAllocationMode_10 */
static int hf_rrc_ueSpecificMidamble_03;          /* T_ueSpecificMidamble_02 */
static int hf_rrc_midambleconfiguration;          /* MidambleConfigurationBurstType1and3 */
static int hf_rrc_hs_sich_configuration_02;       /* HS_SICH_Configuration_TDD384 */
static int hf_rrc_midambleAllocationMode_11;      /* T_midambleAllocationMode_11 */
static int hf_rrc_ueSpecificMidamble_04;          /* T_ueSpecificMidamble_03 */
static int hf_rrc_channelisationCode_06;          /* DL_TS_ChannelisationCode_VHCR */
static int hf_rrc_midambleAllocationMode_12;      /* T_midambleAllocationMode_12 */
static int hf_rrc_ueSpecificMidamble_05;          /* T_ueSpecificMidamble_04 */
static int hf_rrc_hs_sich_configuration_03;       /* HS_SICH_Configuration_TDD768 */
static int hf_rrc_midambleAllocationMode_13;      /* T_midambleAllocationMode_13 */
static int hf_rrc_ueSpecificMidamble_06;          /* T_ueSpecificMidamble_05 */
static int hf_rrc_midambleAllocationMode_14;      /* T_midambleAllocationMode_14 */
static int hf_rrc_ueSpecificMidamble_07;          /* T_ueSpecificMidamble_06 */
static int hf_rrc_ul_target_SIR;                  /* INTEGER_M22_40 */
static int hf_rrc_hs_sich_ConstantValue;          /* ConstantValue */
static int hf_rrc_midambleShiftAndBurstType_04;   /* MidambleShiftAndBurstType */
static int hf_rrc_midambleShiftAndBurstType_VHCR;  /* MidambleShiftAndBurstType_VHCR */
static int hf_rrc_modulation_01;                  /* T_modulation_01 */
static int hf_rrc_ss_TPC_Symbols;                 /* T_ss_TPC_Symbols */
static int hf_rrc_additionalSS_TPC_Symbols;       /* INTEGER_1_15 */
static int hf_rrc_modulation_02;                  /* T_modulation_02 */
static int hf_rrc_ss_TPC_Symbols_01;              /* T_ss_TPC_Symbols_01 */
static int hf_rrc_midambleShiftAndBurstType_05;   /* MidambleShiftAndBurstType_r7 */
static int hf_rrc_ul_TimeslotInterference;        /* TDD_UL_Interference */
static int hf_rrc_IndividualTS_InterferenceList_item;  /* IndividualTS_Interference */
static int hf_rrc_modeSpecificInfo_74;            /* T_modeSpecificInfo_74 */
static int hf_rrc_fdd_111;                        /* T_fdd_109 */
static int hf_rrc_feedback_cycle;                 /* Feedback_cycle */
static int hf_rrc_cqi_RepetitionFactor;           /* CQI_RepetitionFactor */
static int hf_rrc_deltaCQI;                       /* DeltaCQI */
static int hf_rrc_modeSpecificInfo_75;            /* T_modeSpecificInfo_75 */
static int hf_rrc_fdd_112;                        /* T_fdd_110 */
static int hf_rrc_feedback_cycle_01;              /* Feedback_cycle_r7 */
static int hf_rrc_modeSpecificInfo_76;            /* T_modeSpecificInfo_76 */
static int hf_rrc_fdd_113;                        /* T_fdd_111 */
static int hf_rrc_cqi_RepetitionFactor_Assisting;  /* CQI_RepetitionFactor */
static int hf_rrc_deltaCQI_01;                    /* DeltaCQI_r11 */
static int hf_rrc_modeSpecificInfo_77;            /* T_modeSpecificInfo_77 */
static int hf_rrc_fdd_114;                        /* T_fdd_112 */
static int hf_rrc_hs_DPCCHOverheadReduction;      /* HS_DPCCHOverheadReduction */
static int hf_rrc_burstType_01;                   /* T_burstType */
static int hf_rrc_type1_01;                       /* T_type1_01 */
static int hf_rrc_midambleConfigurationBurstType1and3;  /* MidambleConfigurationBurstType1and3 */
static int hf_rrc_midambleAllocationMode_15;      /* T_midambleAllocationMode_15 */
static int hf_rrc_ueSpecificMidamble_08;          /* T_ueSpecificMidamble_07 */
static int hf_rrc_type2;                          /* T_type2 */
static int hf_rrc_midambleConfigurationBurstType2;  /* MidambleConfigurationBurstType2 */
static int hf_rrc_midambleAllocationMode_16;      /* T_midambleAllocationMode_16 */
static int hf_rrc_ueSpecificMidamble_09;          /* T_ueSpecificMidamble_08 */
static int hf_rrc_midambleShift_02;               /* MidambleShiftShort */
static int hf_rrc_type3;                          /* T_type3 */
static int hf_rrc_midambleAllocationMode_17;      /* T_midambleAllocationMode_17 */
static int hf_rrc_ueSpecificMidamble_10;          /* T_ueSpecificMidamble_09 */
static int hf_rrc_burstType_02;                   /* T_burstType_01 */
static int hf_rrc_type1_02;                       /* T_type1_02 */
static int hf_rrc_midambleAllocationMode_18;      /* T_midambleAllocationMode_18 */
static int hf_rrc_ueSpecificMidamble_11;          /* T_ueSpecificMidamble_10 */
static int hf_rrc_type2_01;                       /* T_type2_01 */
static int hf_rrc_midambleConfigurationBurstType2_01;  /* MidambleConfigurationBurstType2_VHCR */
static int hf_rrc_midambleAllocationMode_19;      /* T_midambleAllocationMode_19 */
static int hf_rrc_ueSpecificMidamble_12;          /* T_ueSpecificMidamble_11 */
static int hf_rrc_midambleShift_03;               /* MidambleShiftShort_VHCR */
static int hf_rrc_type3_01;                       /* T_type3_01 */
static int hf_rrc_midambleAllocationMode_20;      /* T_midambleAllocationMode_20 */
static int hf_rrc_ueSpecificMidamble_13;          /* T_ueSpecificMidamble_12 */
static int hf_rrc_mbsfnBurstType4;                /* NULL */
static int hf_rrc_burstType_03;                   /* T_burstType_02 */
static int hf_rrc_type1_03;                       /* T_type1_03 */
static int hf_rrc_midambleAllocationMode_21;      /* T_midambleAllocationMode_21 */
static int hf_rrc_ueSpecificMidamble_14;          /* T_ueSpecificMidamble_13 */
static int hf_rrc_type2_02;                       /* T_type2_02 */
static int hf_rrc_midambleAllocationMode_22;      /* T_midambleAllocationMode_22 */
static int hf_rrc_ueSpecificMidamble_15;          /* T_ueSpecificMidamble_14 */
static int hf_rrc_type3_02;                       /* T_type3_02 */
static int hf_rrc_midambleAllocationMode_23;      /* T_midambleAllocationMode_23 */
static int hf_rrc_ueSpecificMidamble_16;          /* T_ueSpecificMidamble_15 */
static int hf_rrc_burstType_04;                   /* T_burstType_03 */
static int hf_rrc_type1_04;                       /* T_type1_04 */
static int hf_rrc_midambleAllocationMode_24;      /* T_midambleAllocationMode_24 */
static int hf_rrc_ueSpecificMidamble_17;          /* T_ueSpecificMidamble_16 */
static int hf_rrc_type2_03;                       /* T_type2_03 */
static int hf_rrc_midambleAllocationMode_25;      /* T_midambleAllocationMode_25 */
static int hf_rrc_ueSpecificMidamble_18;          /* T_ueSpecificMidamble_17 */
static int hf_rrc_burstType_05;                   /* T_burstType_04 */
static int hf_rrc_type1_05;                       /* T_type1_05 */
static int hf_rrc_midambleAllocationMode_26;      /* T_midambleAllocationMode_26 */
static int hf_rrc_ueSpecificMidamble_19;          /* T_ueSpecificMidamble_18 */
static int hf_rrc_type2_04;                       /* T_type2_04 */
static int hf_rrc_midambleAllocationMode_27;      /* T_midambleAllocationMode_27 */
static int hf_rrc_ueSpecificMidamble_20;          /* T_ueSpecificMidamble_19 */
static int hf_rrc_midambleAllocationMode_28;      /* T_midambleAllocationMode_28 */
static int hf_rrc_ueSpecificMidamble_21;          /* T_ueSpecificMidamble_20 */
static int hf_rrc_burstType_06;                   /* T_burstType_05 */
static int hf_rrc_type1_06;                       /* T_type1_06 */
static int hf_rrc_midambleConfigurationBurstType1;  /* MidambleConfigurationBurstType1 */
static int hf_rrc_midambleAllocationMode_29;      /* T_midambleAllocationMode_29 */
static int hf_rrc_ueSpecificMidamble_22;          /* T_ueSpecificMidamble_21 */
static int hf_rrc_type2_05;                       /* T_type2_05 */
static int hf_rrc_midambleAllocationMode_30;      /* T_midambleAllocationMode_30 */
static int hf_rrc_ueSpecificMidamble_23;          /* T_ueSpecificMidamble_22 */
static int hf_rrc_mimoOperation;                  /* MIMO_Operation */
static int hf_rrc_mimoN_M_Ratio;                  /* MIMO_N_M_Ratio */
static int hf_rrc_mimoPilotConfiguration;         /* MIMO_PilotConfiguration */
static int hf_rrc_configurationInfo_10;           /* T_configurationInfo_10 */
static int hf_rrc_newConfiguration_15;            /* T_newConfiguration_15 */
static int hf_rrc_mimo4x4N_M_Ratio;               /* MIMO_N_M_Ratio */
static int hf_rrc_mimo4x4PilotConfiguration;      /* MIMO4x4_PilotConfiguration */
static int hf_rrc_precodingWeightSetRestriction_bit_string;  /* BIT_STRING_SIZE_64 */
static int hf_rrc_precodingWeightSetRestriction_enum;  /* T_precodingWeightSetRestriction_enum */
static int hf_rrc_modeSpecificInfo_78;            /* T_modeSpecificInfo_78 */
static int hf_rrc_fdd_115;                        /* T_fdd_113 */
static int hf_rrc_tdd_68;                         /* T_tdd_64 */
static int hf_rrc_tdd128_45;                      /* T_tdd128_44 */
static int hf_rrc_mimoSFModeForHSPDSCHDualStream;  /* T_mimoSFModeForHSPDSCHDualStream */
static int hf_rrc_hs_sich_ReferenceSignalInfoList;  /* HS_SICH_ReferenceSignalInfoList */
static int hf_rrc_tdd384_tdd768_06;               /* NULL */
static int hf_rrc_modeSpecificInfo_79;            /* T_modeSpecificInfo_79 */
static int hf_rrc_fdd_116;                        /* T_fdd_114 */
static int hf_rrc_mimoPilotConfiguration_01;      /* MIMO_PilotConfiguration_r9 */
static int hf_rrc_precodingWeightSetRestriction_enum_01;  /* T_precodingWeightSetRestriction_enum_01 */
static int hf_rrc_tdd_69;                         /* T_tdd_65 */
static int hf_rrc_tdd128_46;                      /* T_tdd128_45 */
static int hf_rrc_mimoSFModeForHSPDSCHDualStream_01;  /* T_mimoSFModeForHSPDSCHDualStream_01 */
static int hf_rrc_secondCPICH_Pattern;            /* T_secondCPICH_Pattern */
static int hf_rrc_normalPattern;                  /* NULL */
static int hf_rrc_diversityPattern;               /* T_diversityPattern */
static int hf_rrc_s_cpich_PowerOffset_Mimo_01;    /* S_CPICH_PowerOffset_MIMO */
static int hf_rrc_secondCPICH_Pattern_01;         /* T_secondCPICH_Pattern_01 */
static int hf_rrc_diversityPattern_01;            /* T_diversityPattern_01 */
static int hf_rrc_antenna2;                       /* MIMO_PilotConfiguration_r9 */
static int hf_rrc_antenna3And4;                   /* Antenna3And4 */
static int hf_rrc_secondFrequencyInfo;            /* FrequencyInfoTDD */
static int hf_rrc_fPachFrequencyInfo;             /* FrequencyInfoTDD */
static int hf_rrc_upPCHpositionInfo;              /* UpPCHposition_LCR */
static int hf_rrc_cellType;                       /* MultiflowCellType */
static int hf_rrc_timeReferenceCell;              /* T_timeReferenceCell */
static int hf_rrc_newConfiguration_16;            /* T_newConfiguration_16 */
static int hf_rrc_mu_MIMO_Operation;              /* MU_MIMO_Operation */
static int hf_rrc_standaloneMidambleInfo;         /* StandaloneMidambleInfo_TDD128 */
static int hf_rrc_enablingDelay_01;               /* EnablingDelay */
static int hf_rrc_ue_dtx_drx_Offset;              /* UE_DTX_DRX_Offset */
static int hf_rrc_hs_dpcch_TransmitContinuationOffset;  /* T_hs_dpcch_TransmitContinuationOffset */
static int hf_rrc_tdd384_768;                     /* T_tdd384_768 */
static int hf_rrc_timeslotResourceRelatedInfo_01;  /* BIT_STRING_SIZE_13 */
static int hf_rrc_tdd128_47;                      /* T_tdd128_46 */
static int hf_rrc_e_HICH_Info_10;                 /* T_e_HICH_Info_08 */
static int hf_rrc_midambleAllocationMode_31;      /* T_midambleAllocationMode_31 */
static int hf_rrc_tdd384_768_01;                  /* NULL */
static int hf_rrc_tdd128_48;                      /* T_tdd128_47 */
static int hf_rrc_t_SI_nst;                       /* T_t_SI_nst */
static int hf_rrc_tdd384_768_02;                  /* T_tdd384_768_01 */
static int hf_rrc_tdd128_49;                      /* T_tdd128_48 */
static int hf_rrc_e_HICH_Info_11;                 /* T_e_HICH_Info_09 */
static int hf_rrc_midambleAllocationMode_32;      /* T_midambleAllocationMode_32 */
static int hf_rrc_t_SI_nst_01;                    /* T_t_SI_nst_01 */
static int hf_rrc_dpch_ConstantValue;             /* ConstantValueTdd */
static int hf_rrc_ipdl_alpha;                     /* Alpha */
static int hf_rrc_maxPowerIncrease;               /* MaxPowerIncrease_r4 */
static int hf_rrc_otherStateConfigList;           /* OtherStateConfigList */
static int hf_rrc_otherStateRemoveList;           /* OtherStateRemoveList */
static int hf_rrc_OtherStateConfigList_item;      /* OtherStateConfigData */
static int hf_rrc_otherStateConfigIdentity;       /* OtherStateConfigIdentity */
static int hf_rrc_source_rrc_StateIndicator;      /* RRC_StateIndicator */
static int hf_rrc_target_rrc_StateIndicator;      /* RRC_StateIndicator */
static int hf_rrc_rntis;                          /* T_rntis */
static int hf_rrc_clear;                          /* NULL */
static int hf_rrc_new;                            /* T_new */
static int hf_rrc_configuration;                  /* T_configuration */
static int hf_rrc_id;                             /* INTEGER_0_maxRetrievConfig_1 */
static int hf_rrc_full_01;                        /* RetrievableConfigData */
static int hf_rrc_OtherStateRemoveList_item;      /* OtherStateConfigIdentity */
static int hf_rrc_paging_associatedHspdschInfo;   /* T_paging_associatedHspdschInfo */
static int hf_rrc_paging_associatedHspdschInfo_item;  /* T_paging_associatedHspdschInfo_item */
static int hf_rrc_timeslotResourceRelatedInfo_02;  /* BIT_STRING_SIZE_6 */
static int hf_rrc_codeResourceInformation;        /* CodeResourceInformation_TDD128 */
static int hf_rrc_paging_sub_Channel_size;        /* INTEGER_1_3 */
static int hf_rrc_pcpch_UL_ScramblingCode;        /* INTEGER_0_79 */
static int hf_rrc_pcpch_DL_ChannelisationCode;    /* INTEGER_0_511 */
static int hf_rrc_pcpch_DL_ScramblingCode;        /* SecondaryScramblingCode */
static int hf_rrc_pcp_Length;                     /* PCP_Length */
static int hf_rrc_ucsm_Info;                      /* UCSM_Info */
static int hf_rrc_PCPCH_ChannelInfoList_item;     /* PCPCH_ChannelInfo */
static int hf_rrc_pdsch_PowerControlInfo;         /* PDSCH_PowerControlInfo */
static int hf_rrc_pdsch_AllocationPeriodInfo;     /* AllocationPeriodInfo */
static int hf_rrc_configuration_01;               /* T_configuration_01 */
static int hf_rrc_old_Configuration;              /* T_old_Configuration */
static int hf_rrc_pdsch_Identity;                 /* PDSCH_Identity */
static int hf_rrc_new_Configuration;              /* T_new_Configuration */
static int hf_rrc_pdsch_Info;                     /* PDSCH_Info */
static int hf_rrc_configuration_02;               /* T_configuration_02 */
static int hf_rrc_old_Configuration_01;           /* T_old_Configuration_01 */
static int hf_rrc_new_Configuration_01;           /* T_new_Configuration_01 */
static int hf_rrc_pdsch_Info_01;                  /* PDSCH_Info_r4 */
static int hf_rrc_configuration_03;               /* T_configuration_03 */
static int hf_rrc_old_Configuration_02;           /* T_old_Configuration_02 */
static int hf_rrc_new_Configuration_02;           /* T_new_Configuration_02 */
static int hf_rrc_pdsch_Info_02;                  /* PDSCH_Info_r7 */
static int hf_rrc_PDSCH_CodeInfoList_item;        /* PDSCH_CodeInfo */
static int hf_rrc_codeNumberStart;                /* CodeNumberDSCH */
static int hf_rrc_codeNumberStop;                 /* CodeNumberDSCH */
static int hf_rrc_PDSCH_CodeMapList_item;         /* PDSCH_CodeMap */
static int hf_rrc_signallingMethod;               /* T_signallingMethod */
static int hf_rrc_codeRange;                      /* CodeRange */
static int hf_rrc_tfci_Range_01;                  /* DSCH_MappingList */
static int hf_rrc_explicit_config_03;             /* PDSCH_CodeInfoList */
static int hf_rrc_replace;                        /* ReplacedPDSCH_CodeInfoList */
static int hf_rrc_pdsch_TimeslotsCodes;           /* DownlinkTimeslotsCodes */
static int hf_rrc_tddOption_13;                   /* T_tddOption_13 */
static int hf_rrc_tdd384_31;                      /* T_tdd384_29 */
static int hf_rrc_tdd128_50;                      /* T_tdd128_49 */
static int hf_rrc_pdsch_TimeslotsCodes_01;        /* DownlinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_tddOption_14;                   /* T_tddOption_14 */
static int hf_rrc_tdd384_32;                      /* T_tdd384_30 */
static int hf_rrc_tdd768_21;                      /* T_tdd768_19 */
static int hf_rrc_pdsch_TimeslotsCodes_02;        /* DownlinkTimeslotsCodes_VHCR */
static int hf_rrc_tdd128_51;                      /* T_tdd128_50 */
static int hf_rrc_dsch_RadioLinkIdentifier;       /* DSCH_RadioLinkIdentifier */
static int hf_rrc_rl_IdentifierList;              /* RL_IdentifierList */
static int hf_rrc_dsch_TFCS;                      /* TFCS */
static int hf_rrc_dsch_TransportChannelsInfo;     /* DSCH_TransportChannelsInfo */
static int hf_rrc_pdsch_Info_03;                  /* PDSCH_Info_LCR_r4 */
static int hf_rrc_PDSCH_SysInfoList_item;         /* PDSCH_SysInfo */
static int hf_rrc_PDSCH_SysInfoList_VHCR_r7_item;  /* PDSCH_SysInfo_VHCR_r7 */
static int hf_rrc_PDSCH_SysInfoList_HCR_r5_item;  /* PDSCH_SysInfo_HCR_r5 */
static int hf_rrc_PDSCH_SysInfoList_LCR_r4_item;  /* PDSCH_SysInfo_LCR_r4 */
static int hf_rrc_PDSCH_SysInfoList_SFN_item;     /* PDSCH_SysInfoList_SFN_item */
static int hf_rrc_pdsch_SysInfo;                  /* PDSCH_SysInfo */
static int hf_rrc_sfn_TimeInfo;                   /* SFN_TimeInfo */
static int hf_rrc_PDSCH_SysInfoList_SFN_HCR_r5_item;  /* PDSCH_SysInfoList_SFN_HCR_r5_item */
static int hf_rrc_pdsch_SysInfo_01;               /* PDSCH_SysInfo_HCR_r5 */
static int hf_rrc_PDSCH_SysInfoList_SFN_LCR_r4_item;  /* PDSCH_SysInfoList_SFN_LCR_r4_item */
static int hf_rrc_pdsch_SysInfo_02;               /* PDSCH_SysInfo_LCR_r4 */
static int hf_rrc_PersistenceScalingFactorList_item;  /* PersistenceScalingFactor */
static int hf_rrc_PichChannelisationCodeList_LCR_r4_item;  /* DL_TS_ChannelisationCode */
static int hf_rrc_hsdpa_AssociatedPichInfo;       /* PICH_Info */
static int hf_rrc_hs_pdschChannelisationCode;     /* INTEGER_1_15 */
static int hf_rrc_implicit_03;                    /* T_implicit_02 */
static int hf_rrc_occurrenceSequenceNumberOfPICH;  /* OccurrenceSequenceNumberOfPICH */
static int hf_rrc_explicit_06;                    /* PICH_Info_LCR_r4 */
static int hf_rrc_fdd_117;                        /* T_fdd_115 */
static int hf_rrc_pi_CountPerFrame;               /* PI_CountPerFrame */
static int hf_rrc_tdd_70;                         /* T_tdd_66 */
static int hf_rrc_channelisationCode_07;          /* TDD_PICH_CCode */
static int hf_rrc_repetitionPeriodLengthOffset;   /* RepPerLengthOffset_PICH */
static int hf_rrc_pagingIndicatorLength;          /* PagingIndicatorLength */
static int hf_rrc_n_GAP;                          /* N_GAP */
static int hf_rrc_n_PCH;                          /* N_PCH */
static int hf_rrc_channelisationCode_08;          /* T_channelisationCode */
static int hf_rrc_tdd384_33;                      /* TDD_PICH_CCode */
static int hf_rrc_tdd768_22;                      /* TDD768_PICH_CCode */
static int hf_rrc_pichChannelisationCodeList_LCR_r4;  /* PichChannelisationCodeList_LCR_r4 */
static int hf_rrc_plcchSequenceNumber;            /* INTEGER_1_14 */
static int hf_rrc_tpcCommandTargetRate;           /* TPC_CommandTargetRate */
static int hf_rrc_algorithm1;                     /* TPC_StepSizeFDD */
static int hf_rrc_algorithm2;                     /* NULL */
static int hf_rrc_tpcSlotPosition;                /* INTEGER_0_4 */
static int hf_rrc_tpcStepSize;                    /* TPC_StepSizeFDD */
static int hf_rrc_decimationFactor;               /* T_decimationFactor */
static int hf_rrc_PRACH_ChanCodes_LCR_r4_item;    /* TDD_PRACH_CCode_LCR_r4 */
static int hf_rrc_PRACH_ChanCodes_List_LCR_item;  /* TDD_PRACH_CCode_LCR_r4 */
static int hf_rrc_timeslot_02;                    /* TimeslotNumber_PRACH_LCR_r4 */
static int hf_rrc_prach_ChanCodes_LCR;            /* PRACH_ChanCodes_LCR_r4 */
static int hf_rrc_fpach_Info;                     /* FPACH_Info_r4 */
static int hf_rrc_prach_ChanCodes_list_LCR;       /* PRACH_ChanCodes_List_LCR */
static int hf_rrc_PRACH_Information_LCR_List_item;  /* PRACH_Information_LCR */
static int hf_rrc_fdd_118;                        /* SEQUENCE_SIZE_1_maxASC_OF_ASCSetting_FDD */
static int hf_rrc_fdd_item;                       /* ASCSetting_FDD */
static int hf_rrc_tdd_71;                         /* SEQUENCE_SIZE_1_maxASC_OF_ASCSetting_TDD */
static int hf_rrc_tdd_item;                       /* ASCSetting_TDD */
static int hf_rrc_tdd_72;                         /* SEQUENCE_SIZE_1_maxASC_OF_ASCSetting_TDD_r7 */
static int hf_rrc_tdd_item_01;                    /* ASCSetting_TDD_r7 */
static int hf_rrc_PRACH_Partitioning_LCR_r4_item;  /* ASCSetting_TDD_LCR_r4 */
static int hf_rrc_powerRampStep;                  /* PowerRampStep */
static int hf_rrc_preambleRetransMax;             /* PreambleRetransMax */
static int hf_rrc_availableSignatures;            /* AvailableSignatures */
static int hf_rrc_e_ai_Indication;                /* BOOLEAN */
static int hf_rrc_preambleScramblingCodeWordNumber;  /* PreambleScramblingCodeWordNumber */
static int hf_rrc_availableSubChannelNumbers;     /* AvailableSubChannelNumbers */
static int hf_rrc_prach_Partitioning;             /* PRACH_Partitioning_r7 */
static int hf_rrc_persistenceScalingFactorList;   /* PersistenceScalingFactorList */
static int hf_rrc_ac_To_ASC_MappingTable;         /* AC_To_ASC_MappingTable */
static int hf_rrc_primaryCPICH_TX_Power;          /* PrimaryCPICH_TX_Power */
static int hf_rrc_constantValue;                  /* ConstantValue */
static int hf_rrc_prach_PowerOffset;              /* PRACH_PowerOffset */
static int hf_rrc_rach_TransmissionParameters;    /* RACH_TransmissionParameters */
static int hf_rrc_aich_Info;                      /* AICH_Info */
static int hf_rrc_powerOffsetPp_e;                /* INTEGER_M5_10 */
static int hf_rrc_aich_Info_01;                   /* AICH_Info_Compressed */
static int hf_rrc_PRACH_PreambleForEnhancedUplinkExtList_item;  /* PRACH_PreambleForEnhancedUplinkExtWithWeight */
static int hf_rrc_prach_PreambleForEnhancedUplinkExt;  /* PRACH_PreambleForEnhancedUplinkExt */
static int hf_rrc_weight;                         /* INTEGER_1_5 */
static int hf_rrc_modeSpecificInfo_80;            /* T_modeSpecificInfo_80 */
static int hf_rrc_fdd_119;                        /* T_fdd_116 */
static int hf_rrc_availableSF;                    /* SF_PRACH */
static int hf_rrc_tdd_73;                         /* T_tdd_67 */
static int hf_rrc_channelisationCodeList;         /* TDD_PRACH_CCodeList */
static int hf_rrc_prach_Midamble;                 /* PRACH_Midamble */
static int hf_rrc_channelisationCodeList_01;      /* TDD768_PRACH_CCodeList */
static int hf_rrc_e_RUCCH_Sync_UL_Codes_Bitmap;   /* Sync_UL_Codes_Bitmap */
static int hf_rrc_sync_UL_Info;                   /* SYNC_UL_Info_r4 */
static int hf_rrc_prach_DefinitionList;           /* SEQUENCE_SIZE_1_maxPRACH_FPACH_OF_PRACH_Definition_LCR_r4 */
static int hf_rrc_prach_DefinitionList_item;      /* PRACH_Definition_LCR_r4 */
static int hf_rrc_prach_RACH_Info;                /* PRACH_RACH_Info */
static int hf_rrc_rach_TransportFormatSet;        /* TransportFormatSet */
static int hf_rrc_rach_TFCS;                      /* TFCS */
static int hf_rrc_prach_Partitioning_01;          /* PRACH_Partitioning */
static int hf_rrc_modeSpecificInfo_81;            /* T_modeSpecificInfo_81 */
static int hf_rrc_fdd_120;                        /* T_fdd_117 */
static int hf_rrc_prach_RACH_Info_01;             /* PRACH_RACH_Info_VHCR_r7 */
static int hf_rrc_prach_RACH_Info_LCR;            /* PRACH_RACH_Info_LCR_r4 */
static int hf_rrc_rach_TransportFormatSet_LCR;    /* TransportFormatSet_LCR */
static int hf_rrc_prach_Partitioning_LCR;         /* PRACH_Partitioning_LCR_r4 */
static int hf_rrc_prach_RACH_Info_LCR_01;         /* PRACH_RACH_Info_LCR_v770ext */
static int hf_rrc_PRACH_SystemInformationList_item;  /* PRACH_SystemInformation */
static int hf_rrc_PRACH_SystemInformationList_VHCR_r7_item;  /* PRACH_SystemInformation_VHCR_r7 */
static int hf_rrc_PRACH_SystemInformationList_LCR_r4_item;  /* PRACH_SystemInformation_LCR_r4 */
static int hf_rrc_PRACH_SystemInformationList_LCR_v770ext_item;  /* PRACH_SystemInformation_LCR_v770ext */
static int hf_rrc_ul_DPCH_InfoPredef;             /* UL_DPCH_InfoPredef */
static int hf_rrc_dl_CommonInformationPredef;     /* DL_CommonInformationPredef */
static int hf_rrc_ul_DPCH_InfoPredef_01;          /* UL_DPCH_InfoPredef_v770ext */
static int hf_rrc_fdd_121;                        /* T_fdd_118 */
static int hf_rrc_tx_DiversityIndicator;          /* BOOLEAN */
static int hf_rrc_tdd_74;                         /* T_tdd_68 */
static int hf_rrc_syncCase;                       /* T_syncCase */
static int hf_rrc_syncCase1;                      /* T_syncCase1 */
static int hf_rrc_syncCase2;                      /* T_syncCase2 */
static int hf_rrc_timeslotSync2;                  /* TimeslotSync2 */
static int hf_rrc_sctd_Indicator;                 /* BOOLEAN */
static int hf_rrc_fdd_122;                        /* T_fdd_119 */
static int hf_rrc_tdd_75;                         /* T_tdd_69 */
static int hf_rrc_tddOption_15;                   /* T_tddOption_15 */
static int hf_rrc_tdd384_tdd768_07;               /* T_tdd384_tdd768_06 */
static int hf_rrc_syncCase_01;                    /* T_syncCase_01 */
static int hf_rrc_syncCase1_01;                   /* T_syncCase1_01 */
static int hf_rrc_syncCase2_01;                   /* T_syncCase2_01 */
static int hf_rrc_tdd128_52;                      /* T_tdd128_51 */
static int hf_rrc_syncCase_02;                    /* T_syncCase_02 */
static int hf_rrc_syncCase1_02;                   /* T_syncCase1_02 */
static int hf_rrc_syncCase2_02;                   /* T_syncCase2_02 */
static int hf_rrc_primaryScramblingCode;          /* PrimaryScramblingCode */
static int hf_rrc_pusch_Allocation;               /* T_pusch_Allocation */
static int hf_rrc_pusch_AllocationPending;        /* NULL */
static int hf_rrc_pusch_AllocationAssignment;     /* T_pusch_AllocationAssignment */
static int hf_rrc_pusch_AllocationPeriodInfo;     /* AllocationPeriodInfo */
static int hf_rrc_pusch_PowerControlInfo;         /* UL_TargetSIR */
static int hf_rrc_configuration_04;               /* T_configuration_04 */
static int hf_rrc_old_Configuration_03;           /* T_old_Configuration_03 */
static int hf_rrc_pusch_Identity;                 /* PUSCH_Identity */
static int hf_rrc_new_Configuration_03;           /* T_new_Configuration_03 */
static int hf_rrc_pusch_Info;                     /* PUSCH_Info */
static int hf_rrc_pusch_Allocation_01;            /* T_pusch_Allocation_01 */
static int hf_rrc_pusch_AllocationAssignment_01;  /* T_pusch_AllocationAssignment_01 */
static int hf_rrc_pusch_PowerControlInfo_01;      /* PUSCH_PowerControlInfo_r4 */
static int hf_rrc_configuration_05;               /* T_configuration_05 */
static int hf_rrc_old_Configuration_04;           /* T_old_Configuration_04 */
static int hf_rrc_new_Configuration_04;           /* T_new_Configuration_04 */
static int hf_rrc_pusch_Info_01;                  /* PUSCH_Info_r4 */
static int hf_rrc_pusch_Allocation_02;            /* T_pusch_Allocation_02 */
static int hf_rrc_pusch_AllocationAssignment_02;  /* T_pusch_AllocationAssignment_02 */
static int hf_rrc_pusch_PowerControlInfo_02;      /* PUSCH_PowerControlInfo_r7 */
static int hf_rrc_configuration_06;               /* T_configuration_06 */
static int hf_rrc_old_Configuration_05;           /* T_old_Configuration_05 */
static int hf_rrc_new_Configuration_05;           /* T_new_Configuration_05 */
static int hf_rrc_pusch_Info_02;                  /* PUSCH_Info_VHCR */
static int hf_rrc_pusch_TimeslotsCodes;           /* UplinkTimeslotsCodes */
static int hf_rrc_tddOption_16;                   /* T_tddOption_16 */
static int hf_rrc_tdd384_34;                      /* T_tdd384_31 */
static int hf_rrc_tdd128_53;                      /* T_tdd128_52 */
static int hf_rrc_pusch_TimeslotsCodes_01;        /* UplinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_pusch_TimeslotsCodes_VHCR;      /* UplinkTimeslotsCodes_VHCR */
static int hf_rrc_ul_TargetSIR;                   /* UL_TargetSIR */
static int hf_rrc_tddOption_17;                   /* T_tddOption_17 */
static int hf_rrc_tdd128_54;                      /* T_tdd128_53 */
static int hf_rrc_tddOption_18;                   /* T_tddOption_18 */
static int hf_rrc_tdd128_55;                      /* T_tdd128_54 */
static int hf_rrc_usch_TFCS;                      /* TFCS */
static int hf_rrc_pusch_Info_VHCR;                /* PUSCH_Info_VHCR */
static int hf_rrc_usch_TransportChannelsInfo;     /* USCH_TransportChannelsInfo */
static int hf_rrc_pusch_Info_03;                  /* PUSCH_Info_LCR_r4 */
static int hf_rrc_PUSCH_SysInfoList_item;         /* PUSCH_SysInfo */
static int hf_rrc_PUSCH_SysInfoList_HCR_r5_item;  /* PUSCH_SysInfo_HCR_r5 */
static int hf_rrc_PUSCH_SysInfoList_LCR_r4_item;  /* PUSCH_SysInfo_LCR_r4 */
static int hf_rrc_PUSCH_SysInfoList_SFN_item;     /* PUSCH_SysInfoList_SFN_item */
static int hf_rrc_pusch_SysInfo;                  /* PUSCH_SysInfo */
static int hf_rrc_PUSCH_SysInfoList_SFN_HCR_r5_item;  /* PUSCH_SysInfoList_SFN_HCR_r5_item */
static int hf_rrc_pusch_SysInfo_01;               /* PUSCH_SysInfo_HCR_r5 */
static int hf_rrc_PUSCH_SysInfoList_SFN_LCR_r4_item;  /* PUSCH_SysInfoList_SFN_LCR_r4_item */
static int hf_rrc_pusch_SysInfo_02;               /* PUSCH_SysInfo_LCR_r4 */
static int hf_rrc_PUSCH_SysInfoList_SFN_VHCR_item;  /* PUSCH_SysInfoList_SFN_VHCR_item */
static int hf_rrc_pusch_SysInfo_VHCR;             /* PUSCH_SysInfo_VHCR */
static int hf_rrc_mmax;                           /* INTEGER_1_32 */
static int hf_rrc_nb01Min;                        /* NB01 */
static int hf_rrc_nb01Max;                        /* NB01 */
static int hf_rrc_frameOffset;                    /* DPCH_FrameOffset */
static int hf_rrc_reference_Code_Rate;            /* INTEGER_0_10 */
static int hf_rrc_reference_Beta;                 /* INTEGER_M15_16 */
static int hf_rrc_repetitionPeriod1;              /* NULL */
static int hf_rrc_repetitionPeriod2;              /* INTEGER_1_1 */
static int hf_rrc_repetitionPeriod4;              /* INTEGER_1_3 */
static int hf_rrc_repetitionPeriod8;              /* INTEGER_1_7 */
static int hf_rrc_repetitionPeriod16;             /* INTEGER_1_15 */
static int hf_rrc_repetitionPeriod32;             /* INTEGER_1_31 */
static int hf_rrc_repetitionPeriod64;             /* INTEGER_1_63 */
static int hf_rrc_repetitionPeriod2_01;           /* T_repetitionPeriod2 */
static int hf_rrc_length;                         /* NULL */
static int hf_rrc_offset;                         /* INTEGER_0_1 */
static int hf_rrc_repetitionPeriod4_01;           /* T_repetitionPeriod4 */
static int hf_rrc_length_01;                      /* INTEGER_1_3 */
static int hf_rrc_offset_01;                      /* INTEGER_0_3 */
static int hf_rrc_repetitionPeriod8_01;           /* T_repetitionPeriod8 */
static int hf_rrc_length_02;                      /* INTEGER_1_7 */
static int hf_rrc_offset_02;                      /* INTEGER_0_7 */
static int hf_rrc_repetitionPeriod16_01;          /* T_repetitionPeriod16 */
static int hf_rrc_length_03;                      /* INTEGER_1_15 */
static int hf_rrc_offset_03;                      /* INTEGER_0_15 */
static int hf_rrc_repetitionPeriod32_01;          /* T_repetitionPeriod32 */
static int hf_rrc_length_04;                      /* INTEGER_1_31 */
static int hf_rrc_offset_04;                      /* INTEGER_0_31 */
static int hf_rrc_repetitionPeriod64_01;          /* T_repetitionPeriod64 */
static int hf_rrc_length_05;                      /* INTEGER_1_63 */
static int hf_rrc_offset_05;                      /* INTEGER_0_63 */
static int hf_rrc_tfci_Field2;                    /* MaxTFCI_Field2Value */
static int hf_rrc_ReplacedPDSCH_CodeInfoList_item;  /* ReplacedPDSCH_CodeInfo */
static int hf_rrc_rpp4_2;                         /* INTEGER_0_3 */
static int hf_rrc_rpp8_2;                         /* INTEGER_0_7 */
static int hf_rrc_rpp8_4;                         /* INTEGER_0_7 */
static int hf_rrc_rpp16_2;                        /* INTEGER_0_15 */
static int hf_rrc_rpp16_4;                        /* INTEGER_0_15 */
static int hf_rrc_rpp32_2;                        /* INTEGER_0_31 */
static int hf_rrc_rpp32_4;                        /* INTEGER_0_31 */
static int hf_rrc_rpp64_2;                        /* INTEGER_0_63 */
static int hf_rrc_rpp64_4;                        /* INTEGER_0_63 */
static int hf_rrc_dl_restrictedTrCh_Type;         /* DL_TrCH_Type */
static int hf_rrc_restrictedDL_TrCH_Identity;     /* TransportChannelIdentity */
static int hf_rrc_allowedTFIList;                 /* AllowedTFI_List */
static int hf_rrc_RestrictedTrCH_InfoList_item;   /* RestrictedTrCH */
static int hf_rrc_cell_Id;                        /* CellIdentity */
static int hf_rrc_dl_dpchInfo_06;                 /* T_dl_dpchInfo_06 */
static int hf_rrc_dl_dpchInfo_07;                 /* T_dl_dpchInfo_07 */
static int hf_rrc_dl_dpchInfo_08;                 /* T_dl_dpchInfo_08 */
static int hf_rrc_targetCellPreconfigInfo;        /* TargetCellPreconfigInfo */
static int hf_rrc_dl_dpchInfo_09;                 /* T_dl_dpchInfo_09 */
static int hf_rrc_targetCellPreconfigInfo_01;     /* TargetCellPreconfigInfo_r9 */
static int hf_rrc_dl_dpchInfo_10;                 /* T_dl_dpchInfo_10 */
static int hf_rrc_targetCellPreconfigInfo_02;     /* TargetCellPreconfigInfo_r10 */
static int hf_rrc_targetCellPreconfigInfo_03;     /* TargetCellPreconfigInfo_vb50ext */
static int hf_rrc_dl_dpchInfo_11;                 /* T_dl_dpchInfo_11 */
static int hf_rrc_targetCellPreconfigInfo_04;     /* TargetCellPreconfigInfo_r11 */
static int hf_rrc_dl_dpchInfo_12;                 /* T_dl_dpchInfo_12 */
static int hf_rrc_dl_DPCH_InfoPerRL_09;           /* DL_DPCH_InfoPerRL_ASU */
static int hf_rrc_targetCellPreconfigInfo_05;     /* TargetCellPreconfigInfo_r12 */
static int hf_rrc_dl_dpchInfo_13;                 /* T_dl_dpchInfo_13 */
static int hf_rrc_targetCellPreconfigInfo_06;     /* TargetCellPreconfigInfo_r13 */
static int hf_rrc_targetCellPreconfigInfo_07;     /* TargetCellPreconfigInfo_v890ext */
static int hf_rrc_targetCellPreconfigInfo_08;     /* TargetCellPreconfigInfo_v950ext */
static int hf_rrc_RL_AdditionInformationList_item;  /* RL_AdditionInformation */
static int hf_rrc_RL_AdditionInformationList_r6_item;  /* RL_AdditionInformation_r6 */
static int hf_rrc_RL_AdditionInformationList_r7_item;  /* RL_AdditionInformation_r7 */
static int hf_rrc_RL_AdditionInformation_list_v6b0ext_item;  /* RL_AdditionInformation_v6b0ext */
static int hf_rrc_RL_AdditionInformationList_r8_item;  /* RL_AdditionInformation_r8 */
static int hf_rrc_RL_AdditionInformationList_v890ext_item;  /* RL_AdditionInformation_v890ext */
static int hf_rrc_RL_AdditionInformationList_r9_item;  /* RL_AdditionInformation_r9 */
static int hf_rrc_RL_AdditionInformationList_v950ext_item;  /* RL_AdditionInformation_v950ext */
static int hf_rrc_RL_AdditionInformationList_r10_item;  /* RL_AdditionInformation_r10 */
static int hf_rrc_RL_AdditionInformationList_vb50ext_item;  /* RL_AdditionInformation_vb50ext */
static int hf_rrc_RL_AdditionInformationList_r11_item;  /* RL_AdditionInformation_r11 */
static int hf_rrc_RL_AdditionInformationList_r12_item;  /* RL_AdditionInformation_r12 */
static int hf_rrc_RL_AdditionInformationList_r13_item;  /* RL_AdditionInformation_r13 */
static int hf_rrc_RL_AdditionInformationList_SecULFreq_item;  /* RL_AdditionInformation_SecULFreq */
static int hf_rrc_RL_AdditionInformationList_SecULFreq_r12_item;  /* RL_AdditionInformation_SecULFreq_r12 */
static int hf_rrc_RL_AdditionInformationList_SecULFreq_r13_item;  /* RL_AdditionInformation_SecULFreq_r13 */
static int hf_rrc_RL_IdentifierList_item;         /* PrimaryCPICH_Info */
static int hf_rrc_RL_RemovalInformationList_item;  /* PrimaryCPICH_Info */
static int hf_rrc_RL_RemovalInformationList_SecULFreq_item;  /* PrimaryCPICH_Info */
static int hf_rrc_SCCPCH_ChannelisationCodeList_item;  /* SCCPCH_ChannelisationCode */
static int hf_rrc_SCCPCH_ChannelisationCodeList_VHCR_item;  /* SCCPCH_ChannelisationCode_VHCR */
static int hf_rrc_secondaryCCPCH_Info;            /* SecondaryCCPCH_Info */
static int hf_rrc_modeSpecificInfo_82;            /* T_modeSpecificInfo_82 */
static int hf_rrc_fdd_123;                        /* T_fdd_120 */
static int hf_rrc_fach_PCH_InformationList;       /* FACH_PCH_InformationList */
static int hf_rrc_sib_ReferenceListFACH;          /* SIB_ReferenceListFACH */
static int hf_rrc_tdd_76;                         /* T_tdd_70 */
static int hf_rrc_secondaryCCPCH_Info_01;         /* SecondaryCCPCH_Info_r4 */
static int hf_rrc_modeSpecificInfo_83;            /* T_modeSpecificInfo_83 */
static int hf_rrc_fdd_124;                        /* T_fdd_121 */
static int hf_rrc_pich_Info;                      /* PICH_Info */
static int hf_rrc_secondaryCCPCH_LCR_Extensions;  /* SecondaryCCPCH_Info_LCR_r4_ext */
static int hf_rrc_pich_Info_01;                   /* PICH_Info_LCR_r4 */
static int hf_rrc_secondaryCCPCH_Info_02;         /* SecondaryCCPCH_Info_HCR_VHCR_r7 */
static int hf_rrc_pich_Info_02;                   /* PICH_Info_HCR_VHCR_r7 */
static int hf_rrc_SCCPCH_SystemInformationList_item;  /* SCCPCH_SystemInformation */
static int hf_rrc_SCCPCH_SystemInformationList_HCR_VHCR_r7_item;  /* SCCPCH_SystemInformation_HCR_VHCR_r7 */
static int hf_rrc_SCCPCH_SystemInformationList_LCR_r4_ext_item;  /* SCCPCH_SystemInformation_LCR_r4_ext */
static int hf_rrc_secondaryCCPCHInfo_MBMS;        /* SecondaryCCPCHInfo_MBMS_r6 */
static int hf_rrc_transportFormatCombinationSet;  /* TFCS */
static int hf_rrc_fachCarryingMCCH;               /* T_fachCarryingMCCH */
static int hf_rrc_mcch_transportFormatSet;        /* TransportFormatSet */
static int hf_rrc_mcch_ConfigurationInfo;         /* MBMS_MCCH_ConfigurationInfo_r6 */
static int hf_rrc_fachCarryingMTCH_List;          /* MBMS_FACHCarryingMTCH_List */
static int hf_rrc_fachCarryingMSCH;               /* T_fachCarryingMSCH */
static int hf_rrc_msch_transportFormatSet;        /* TransportFormatSet */
static int hf_rrc_mBMS_MSCH_ConfigurationInfo_r6;  /* MBMS_MSCH_ConfigurationInfo_r6 */
static int hf_rrc_secondaryCCPCHInfo_MBMS_01;     /* SecondaryCCPCHInfo_MBMS_r7 */
static int hf_rrc_fachCarryingMCCH_01;            /* T_fachCarryingMCCH_01 */
static int hf_rrc_fachCarryingMSCH_01;            /* T_fachCarryingMSCH_01 */
static int hf_rrc_common_E_DCH_ResourceInfoListExt;  /* SEQUENCE_SIZE_1_maxEDCHs_OF_Common_E_DCH_ResourceInfoListExt */
static int hf_rrc_common_E_DCH_ResourceInfoListExt_item;  /* Common_E_DCH_ResourceInfoListExt */
static int hf_rrc_modeSpecificInfo_84;            /* T_modeSpecificInfo_84 */
static int hf_rrc_fdd_125;                        /* T_fdd_122 */
static int hf_rrc_sf_AndCodeNumber_01;            /* SF256_AndCodeNumber */
static int hf_rrc_pilotSymbolExistence;           /* BOOLEAN */
static int hf_rrc_timingOffset;                   /* TimingOffset */
static int hf_rrc_tdd_77;                         /* T_tdd_71 */
static int hf_rrc_commonTimeslotInfo_01;          /* CommonTimeslotInfoSCCPCH */
static int hf_rrc_channelisationCode_09;          /* SCCPCH_ChannelisationCodeList */
static int hf_rrc_modeSpecificInfo_85;            /* T_modeSpecificInfo_85 */
static int hf_rrc_fdd_126;                        /* T_fdd_123 */
static int hf_rrc_tdd_78;                         /* T_tdd_72 */
static int hf_rrc_tddOption_19;                   /* T_tddOption_19 */
static int hf_rrc_tdd384_35;                      /* T_tdd384_32 */
static int hf_rrc_tdd128_56;                      /* T_tdd128_55 */
static int hf_rrc_modeSpecificInfo_86;            /* T_modeSpecificInfo_86 */
static int hf_rrc_tdd384_36;                      /* T_tdd384_33 */
static int hf_rrc_tdd768_23;                      /* T_tdd768_20 */
static int hf_rrc_channelisationCode_10;          /* SCCPCH_ChannelisationCodeList_VHCR */
static int hf_rrc_individualTimeslotLCR_Ext;      /* IndividualTimeslotInfo_LCR_r4_ext */
static int hf_rrc_subFrameNumber;                 /* INTEGER_0_4 */
static int hf_rrc_dl_ChannelisationCodes;         /* DL_ChannelCodes_MBSFN_IMB384 */
static int hf_rrc_modulation_03;                  /* T_modulation_03 */
static int hf_rrc_modQPSK;                        /* NULL */
static int hf_rrc_mod16QAM;                       /* T_mod16QAM */
static int hf_rrc_cpich_SecCCPCH_PowerOffset;     /* INTEGER_M11_4 */
static int hf_rrc_modeSpecificInfo_87;            /* T_modeSpecificInfo_87 */
static int hf_rrc_fdd_127;                        /* T_fdd_124 */
static int hf_rrc_tdd384_37;                      /* T_tdd384_34 */
static int hf_rrc_commonTimeslotInfoMBMS;         /* CommonTimeslotInfoMBMS */
static int hf_rrc_downlinkTimeslotsCodes;         /* DownlinkTimeslotsCodes */
static int hf_rrc_tdd128_57;                      /* T_tdd128_56 */
static int hf_rrc_downlinkTimeslotsCodes_01;      /* DownlinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_modeSpecificInfo_88;            /* T_modeSpecificInfo_88 */
static int hf_rrc_fdd_128;                        /* T_fdd_125 */
static int hf_rrc_modulation_04;                  /* T_modulation_04 */
static int hf_rrc_mod16QAM_01;                    /* INTEGER_M11_4 */
static int hf_rrc_tdd384_38;                      /* T_tdd384_35 */
static int hf_rrc_downlinkTimeslotsCodes_02;      /* DownlinkTimeslotsCodes_r7 */
static int hf_rrc_modulation_05;                  /* T_modulation_05 */
static int hf_rrc_tdd768_24;                      /* T_tdd768_21 */
static int hf_rrc_downlinkTimeslotsCodes_03;      /* DownlinkTimeslotsCodes_VHCR */
static int hf_rrc_modulation_06;                  /* T_modulation_06 */
static int hf_rrc_tdd128_58;                      /* T_tdd128_57 */
static int hf_rrc_mbsfnSpecialTimeSlot;           /* TimeSlotLCR_ext */
static int hf_rrc_modulation_07;                  /* T_modulation_07 */
static int hf_rrc_secondaryDL_ScramblingCode;     /* SecondaryScramblingCode */
static int hf_rrc_newConfiguration_17;            /* T_newConfiguration_17 */
static int hf_rrc_precodingWeightSetRestriction_enum_02;  /* T_precodingWeightSetRestriction_enum_02 */
static int hf_rrc_newConfiguration_18;            /* T_newConfiguration_18 */
static int hf_rrc_precodingWeightSetRestriction;  /* T_precodingWeightSetRestriction */
static int hf_rrc_configurationInfo_11;           /* T_configurationInfo_11 */
static int hf_rrc_newConfiguration_19;            /* T_newConfiguration_19 */
static int hf_rrc_mimoPilotConfiguration_02;      /* MIMO4x4_PilotConfiguration */
static int hf_rrc_servingCellChangeMACreset;      /* ServingCellChangeMACreset */
static int hf_rrc_servingCellChangeMsgType;       /* ServingCellChangeMsgType */
static int hf_rrc_servingCellChangeTrId;          /* ServingCellChangeTrId */
static int hf_rrc_enhancedServingCellChangeforEvent1CsupportIndicator;  /* T_enhancedServingCellChangeforEvent1CsupportIndicator */
static int hf_rrc_sf4;                            /* INTEGER_0_3 */
static int hf_rrc_sf8;                            /* INTEGER_0_7 */
static int hf_rrc_sf16;                           /* INTEGER_0_15 */
static int hf_rrc_sf32;                           /* INTEGER_0_31 */
static int hf_rrc_sf64;                           /* INTEGER_0_63 */
static int hf_rrc_sf128;                          /* INTEGER_0_127 */
static int hf_rrc_sf256;                          /* INTEGER_0_255 */
static int hf_rrc_sf512;                          /* INTEGER_0_511 */
static int hf_rrc_sfd4;                           /* NULL */
static int hf_rrc_sfd8;                           /* NULL */
static int hf_rrc_sfd16;                          /* NULL */
static int hf_rrc_sfd32;                          /* NULL */
static int hf_rrc_sfd64;                          /* NULL */
static int hf_rrc_sfd128;                         /* PilotBits128 */
static int hf_rrc_sfd256;                         /* PilotBits256 */
static int hf_rrc_sfd512;                         /* NULL */
static int hf_rrc_sfd128_01;                      /* PilotBits128_r12 */
static int hf_rrc_sfd256_01;                      /* PilotBits256_r12 */
static int hf_rrc_activationTimeSFN;              /* INTEGER_0_4095 */
static int hf_rrc_physChDuration;                 /* DurationTimeInfo */
static int hf_rrc_e_dch_SPS_Info;                 /* E_DCH_SPS_Information_TDD128 */
static int hf_rrc_hs_dsch_SPS_Info;               /* HS_DSCH_SPS_Information_TDD128 */
static int hf_rrc_s_Field;                        /* S_Field */
static int hf_rrc_codeWordSet;                    /* CodeWordSet */
static int hf_rrc_ssdt_UL_r4;                     /* SSDT_UL */
static int hf_rrc_timeSlotInformation;            /* BIT_STRING_SIZE_5 */
static int hf_rrc_repetitionPeriod;               /* T_repetitionPeriod */
static int hf_rrc_referenceBeta;                  /* INTEGER_M15_16 */
static int hf_rrc_sync_UL_CodesBitmap;            /* T_sync_UL_CodesBitmap */
static int hf_rrc_prxUpPCHdes;                    /* INTEGER_0_62 */
static int hf_rrc_sync_UL_Procedure;              /* SYNC_UL_Procedure_r4 */
static int hf_rrc_max_SYNC_UL_Transmissions;      /* T_max_SYNC_UL_Transmissions */
static int hf_rrc_powerRampStep_01;               /* INTEGER_0_3 */
static int hf_rrc_sync_UL_Codes_Bitmap;           /* Sync_UL_Codes_Bitmap */
static int hf_rrc_max_SYNC_UL_Transmissions_01;   /* T_max_SYNC_UL_Transmissions_01 */
static int hf_rrc_max_SYNC_UL_Transmissions_02;   /* T_max_SYNC_UL_Transmissions_02 */
static int hf_rrc_activationTimeOffset;           /* ActivationTimeOffset */
static int hf_rrc_uL_OLTD_InfoFDD;                /* UL_OLTD_InfoFDD */
static int hf_rrc_ul_MIMO_Info;                   /* UL_MIMO_InfoFDD */
static int hf_rrc_TDD_MBSFNInformation_item;      /* TDD_MBSFNTSlotInfo */
static int hf_rrc_timeSlotNumber;                 /* TimeslotNumber */
static int hf_rrc_sf8_01;                         /* SEQUENCE_SIZE_1_8_OF_TDD_PRACH_CCode8 */
static int hf_rrc_sf8_item;                       /* TDD_PRACH_CCode8 */
static int hf_rrc_sf16_01;                        /* SEQUENCE_SIZE_1_8_OF_TDD_PRACH_CCode16 */
static int hf_rrc_sf16_item;                      /* TDD_PRACH_CCode16 */
static int hf_rrc_sf32_01;                        /* SEQUENCE_SIZE_1_16_OF_TDD768_PRACH_CCode32 */
static int hf_rrc_sf32_item;                      /* TDD768_PRACH_CCode32 */
static int hf_rrc_sf16_02;                        /* SEQUENCE_SIZE_1_16_OF_TDD768_PRACH_CCode16 */
static int hf_rrc_sf16_item_01;                   /* TDD768_PRACH_CCode16 */
static int hf_rrc_tgpsi;                          /* TGPSI */
static int hf_rrc_tgps_Status;                    /* T_tgps_Status */
static int hf_rrc_activate;                       /* T_activate */
static int hf_rrc_tgcfn;                          /* TGCFN */
static int hf_rrc_deactivate;                     /* NULL */
static int hf_rrc_tgps_ConfigurationParams;       /* TGPS_ConfigurationParams */
static int hf_rrc_tgps_Status_01;                 /* T_tgps_Status_01 */
static int hf_rrc_activate_01;                    /* T_activate_01 */
static int hf_rrc_tgps_ConfigurationParams_01;    /* TGPS_ConfigurationParams_r8 */
static int hf_rrc_tgps_Status_02;                 /* T_tgps_Status_02 */
static int hf_rrc_activate_02;                    /* T_activate_02 */
static int hf_rrc_tgps_ConfigurationParams_02;    /* TGPS_ConfigurationParams_r10 */
static int hf_rrc_TGP_SequenceList_item;          /* TGP_Sequence */
static int hf_rrc_TGP_SequenceList_r8_item;       /* TGP_Sequence_r8 */
static int hf_rrc_TGP_SequenceList_r10_item;      /* TGP_Sequence_r10 */
static int hf_rrc_tgps_Status_03;                 /* T_tgps_Status_03 */
static int hf_rrc_activate_03;                    /* T_activate_03 */
static int hf_rrc_tgps_Status_04;                 /* T_tgps_Status_04 */
static int hf_rrc_activate_04;                    /* T_activate_04 */
static int hf_rrc_freqSpecificCompressedMode_01;  /* T_freqSpecificCompressedMode_01 */
static int hf_rrc_tgmp;                           /* TGMP */
static int hf_rrc_tgprc;                          /* TGPRC */
static int hf_rrc_tgsn;                           /* TGSN */
static int hf_rrc_tgl1;                           /* TGL */
static int hf_rrc_tgl2;                           /* TGL */
static int hf_rrc_tgd;                            /* TGD */
static int hf_rrc_tgpl1;                          /* TGPL */
static int hf_rrc_tGPL;                           /* TGPL */
static int hf_rrc_rpp;                            /* RPP */
static int hf_rrc_itp;                            /* ITP */
static int hf_rrc_ul_DL_Mode;                     /* UL_DL_Mode */
static int hf_rrc_dl_FrameType;                   /* DL_FrameType */
static int hf_rrc_deltaSIR1;                      /* DeltaSIR */
static int hf_rrc_deltaSIRAfter1;                 /* DeltaSIR */
static int hf_rrc_deltaSIR2;                      /* DeltaSIR */
static int hf_rrc_deltaSIRAfter2;                 /* DeltaSIR */
static int hf_rrc_nidentifyAbort;                 /* NidentifyAbort */
static int hf_rrc_treconfirmAbort;                /* TreconfirmAbort */
static int hf_rrc_tgmp_01;                        /* TGMP_r8 */
static int hf_rrc_freqSpecificCompressedMode_02;  /* T_freqSpecificCompressedMode_02 */
static int hf_rrc_durationTimeInfo;               /* DurationTimeInfo */
static int hf_rrc_TimeslotList_item;              /* TimeslotNumber */
static int hf_rrc_tdd384_39;                      /* SEQUENCE_SIZE_1_maxTS_OF_TimeslotNumber */
static int hf_rrc_tdd384_item;                    /* TimeslotNumber */
static int hf_rrc_tdd128_59;                      /* SEQUENCE_SIZE_1_maxTS_LCR_OF_TimeslotNumber_LCR_r4 */
static int hf_rrc_tdd128_item_01;                 /* TimeslotNumber_LCR_r4 */
static int hf_rrc_timing;                         /* T_timing */
static int hf_rrc_newTiming;                      /* NewTiming */
static int hf_rrc_harqProcessAllocation;          /* BIT_STRING_SIZE_8 */
static int hf_rrc_channelReqParamsForUCSM;        /* ChannelReqParamsForUCSM */
static int hf_rrc_filterCoefficient_01;           /* INTEGER_0_5 */
static int hf_rrc_powerOffset;                    /* INTEGER_M8_20 */
static int hf_rrc_inactivityThresholdForResetPower;  /* T_inactivityThresholdForResetPower */
static int hf_rrc_ul_16QAM_Settings;              /* UL_16QAM_Settings */
static int hf_rrc_mac_es_e_resetIndicator;        /* T_mac_es_e_resetIndicator */
static int hf_rrc_beta_Ed_Gain_E_AGCH_Table_Selection;  /* INTEGER_0_1 */
static int hf_rrc_ul_64QAM_Settings;              /* UL_64QAM_Settings */
static int hf_rrc_mac_is_i_resetIndicator;        /* T_mac_is_i_resetIndicator */
static int hf_rrc_ul_CCTrCH_TimeslotsCodes;       /* UplinkTimeslotsCodes */
static int hf_rrc_tddOption_20;                   /* T_tddOption_20 */
static int hf_rrc_tdd384_40;                      /* T_tdd384_36 */
static int hf_rrc_tdd128_60;                      /* T_tdd128_58 */
static int hf_rrc_ul_CCTrCH_TimeslotsCodes_01;    /* UplinkTimeslotsCodes_LCR_r4 */
static int hf_rrc_tddOption_21;                   /* T_tddOption_21 */
static int hf_rrc_tdd384_41;                      /* T_tdd384_37 */
static int hf_rrc_tdd768_25;                      /* T_tdd768_22 */
static int hf_rrc_ul_CCTrCH_TimeslotsCodes_02;    /* UplinkTimeslotsCodes_VHCR */
static int hf_rrc_tdd128_61;                      /* T_tdd128_59 */
static int hf_rrc_ul_CCTrCH_TimeslotsCodes_03;    /* UplinkTimeslotsCodes_LCR_r7 */
static int hf_rrc_UL_CCTrCHList_item;             /* UL_CCTrCH */
static int hf_rrc_UL_CCTrCHList_r4_item;          /* UL_CCTrCH_r4 */
static int hf_rrc_UL_CCTrCHList_r7_item;          /* UL_CCTrCH_r7 */
static int hf_rrc_UL_CCTrCHListToRemove_item;     /* TFCS_IdentityPlain */
static int hf_rrc_UL_CCTrChTPCList_item;          /* TFCS_Identity */
static int hf_rrc_vPCH_SetInfo;                   /* CPCH_SetInfo */
static int hf_rrc_configurationInfo_12;           /* T_configurationInfo_12 */
static int hf_rrc_newConfiguration_20;            /* T_newConfiguration_20 */
static int hf_rrc_s_dpcch_Info;                   /* S_DPCCH_Information */
static int hf_rrc_initial_CLTD_ActivationState;   /* T_initial_CLTD_ActivationState */
static int hf_rrc_ul;                             /* UL_CompressedModeMethod */
static int hf_rrc_dl;                             /* DL_CompressedModeMethod */
static int hf_rrc_ul_and_dl;                      /* T_ul_and_dl */
static int hf_rrc_ul_DPCCHscramblingCodeType;     /* ScramblingCodeType */
static int hf_rrc_ul_DPCCHscramblingCode;         /* UL_ScramblingCode */
static int hf_rrc_modeSpecificInfo_89;            /* T_modeSpecificInfo_89 */
static int hf_rrc_fdd_129;                        /* T_fdd_126 */
static int hf_rrc_scramblingCode;                 /* UL_ScramblingCode */
static int hf_rrc_numberOfDPDCH;                  /* NumberOfDPDCH */
static int hf_rrc_spreadingFactor_01;             /* SpreadingFactor */
static int hf_rrc_numberOfFBI_Bits;               /* NumberOfFBI_Bits */
static int hf_rrc_tdd_79;                         /* T_tdd_73 */
static int hf_rrc_ul_CCTrCHList;                  /* UL_CCTrCHList */
static int hf_rrc_ul_CCTrCHListToRemove;          /* UL_CCTrCHListToRemove */
static int hf_rrc_modeSpecificInfo_90;            /* T_modeSpecificInfo_90 */
static int hf_rrc_fdd_130;                        /* T_fdd_127 */
static int hf_rrc_tdd_80;                         /* T_tdd_74 */
static int hf_rrc_ul_CCTrCHList_01;               /* UL_CCTrCHList_r4 */
static int hf_rrc_modeSpecificInfo_91;            /* T_modeSpecificInfo_91 */
static int hf_rrc_fdd_131;                        /* T_fdd_128 */
static int hf_rrc_tdd_81;                         /* T_tdd_75 */
static int hf_rrc_ul_DPCH_PowerControlInfo_04;    /* UL_DPCH_PowerControlInfo_r6 */
static int hf_rrc_modeSpecificInfo_92;            /* T_modeSpecificInfo_92 */
static int hf_rrc_fdd_132;                        /* T_fdd_129 */
static int hf_rrc_dpdchPresence;                  /* T_dpdchPresence */
static int hf_rrc_present_02;                     /* T_present_02 */
static int hf_rrc_notPresent;                     /* T_notPresent */
static int hf_rrc_tdd_82;                         /* T_tdd_76 */
static int hf_rrc_modeSpecificInfo_93;            /* T_modeSpecificInfo_93 */
static int hf_rrc_fdd_133;                        /* T_fdd_130 */
static int hf_rrc_dpdchPresence_01;               /* T_dpdchPresence_01 */
static int hf_rrc_present_03;                     /* T_present_03 */
static int hf_rrc_numberOfTPC_Bits;               /* NumberOfTPC_Bits */
static int hf_rrc_notPresent_01;                  /* T_notPresent_01 */
static int hf_rrc_tdd_83;                         /* T_tdd_77 */
static int hf_rrc_ul_CCTrCHList_02;               /* UL_CCTrCHList_r7 */
static int hf_rrc_ul_DPCH_PowerControlInfo_05;    /* UL_DPCH_PowerControlInfo_r11 */
static int hf_rrc_modeSpecificInfo_94;            /* T_modeSpecificInfo_94 */
static int hf_rrc_fdd_134;                        /* T_fdd_131 */
static int hf_rrc_dpdchPresence_02;               /* T_dpdchPresence_02 */
static int hf_rrc_present_04;                     /* T_present_04 */
static int hf_rrc_notPresent_02;                  /* T_notPresent_02 */
static int hf_rrc_tdd_84;                         /* T_tdd_78 */
static int hf_rrc_ul_DPCH_PowerControlInfo_06;    /* UL_DPCH_PowerControlInfoPostFDD */
static int hf_rrc_reducedScramblingCodeNumber;    /* ReducedScramblingCodeNumber */
static int hf_rrc_ul_DPCH_PowerControlInfo_07;    /* UL_DPCH_PowerControlInfoPostTDD */
static int hf_rrc_ul_DPCH_PowerControlInfo_08;    /* UL_DPCH_PowerControlInfoPostTDD_LCR_r4 */
static int hf_rrc_ul_TimingAdvance_04;            /* UL_TimingAdvanceControl_LCR_r4 */
static int hf_rrc_ul_DPCH_PowerControlInfo_09;    /* UL_DPCH_PowerControlInfoPredef */
static int hf_rrc_modeSpecificInfo_95;            /* T_modeSpecificInfo_95 */
static int hf_rrc_fdd_135;                        /* T_fdd_132 */
static int hf_rrc_tdd_85;                         /* T_tdd_79 */
static int hf_rrc_modeSpecificInfo_96;            /* T_modeSpecificInfo_96 */
static int hf_rrc_fdd_136;                        /* T_fdd_133 */
static int hf_rrc_fdd_137;                        /* T_fdd_134 */
static int hf_rrc_dpcch_PowerOffset;              /* DPCCH_PowerOffset */
static int hf_rrc_sRB_delay;                      /* SRB_delay */
static int hf_rrc_tdd_86;                         /* T_tdd_80 */
static int hf_rrc_ul_OL_PC_Signalling;            /* T_ul_OL_PC_Signalling */
static int hf_rrc_broadcast_UL_OL_PC_info;        /* NULL */
static int hf_rrc_individuallySignalled;          /* T_individuallySignalled */
static int hf_rrc_individualTS_InterferenceList;  /* IndividualTS_InterferenceList */
static int hf_rrc_fdd_138;                        /* T_fdd_135 */
static int hf_rrc_tdd_87;                         /* T_tdd_81 */
static int hf_rrc_ul_OL_PC_Signalling_01;         /* T_ul_OL_PC_Signalling_01 */
static int hf_rrc_individuallySignalled_01;       /* T_individuallySignalled_01 */
static int hf_rrc_tddOption_22;                   /* T_tddOption_22 */
static int hf_rrc_tdd384_42;                      /* T_tdd384_38 */
static int hf_rrc_dpch_ConstantValue_01;          /* ConstantValue */
static int hf_rrc_tdd128_62;                      /* T_tdd128_60 */
static int hf_rrc_fdd_139;                        /* T_fdd_136 */
static int hf_rrc_ack_NACK_repetition_factor;     /* ACK_NACK_repetitionFactor */
static int hf_rrc_tdd_88;                         /* T_tdd_82 */
static int hf_rrc_ul_OL_PC_Signalling_02;         /* T_ul_OL_PC_Signalling_02 */
static int hf_rrc_individuallySignalled_02;       /* T_individuallySignalled_02 */
static int hf_rrc_tddOption_23;                   /* T_tddOption_23 */
static int hf_rrc_tdd384_43;                      /* T_tdd384_39 */
static int hf_rrc_tdd128_63;                      /* T_tdd128_61 */
static int hf_rrc_fdd_140;                        /* T_fdd_137 */
static int hf_rrc_tdd_89;                         /* T_tdd_83 */
static int hf_rrc_ul_OL_PC_Signalling_03;         /* T_ul_OL_PC_Signalling_03 */
static int hf_rrc_individuallySignalled_03;       /* T_individuallySignalled_03 */
static int hf_rrc_tddOption_24;                   /* T_tddOption_24 */
static int hf_rrc_tdd384_44;                      /* T_tdd384_40 */
static int hf_rrc_tdd128_64;                      /* T_tdd128_62 */
static int hf_rrc_fdd_141;                        /* T_fdd_138 */
static int hf_rrc_tdd_90;                         /* T_tdd_84 */
static int hf_rrc_ul_OL_PC_Signalling_04;         /* T_ul_OL_PC_Signalling_04 */
static int hf_rrc_individuallySignalled_04;       /* T_individuallySignalled_04 */
static int hf_rrc_tddOption_25;                   /* T_tddOption_25 */
static int hf_rrc_tdd384_45;                      /* T_tdd384_41 */
static int hf_rrc_tdd768_26;                      /* T_tdd768_23 */
static int hf_rrc_tdd128_65;                      /* T_tdd128_63 */
static int hf_rrc_fdd_142;                        /* T_fdd_139 */
static int hf_rrc_ack_NACK_repetition_factor_assisting;  /* ACK_NACK_repetitionFactor */
static int hf_rrc_tdd_91;                         /* T_tdd_85 */
static int hf_rrc_ul_OL_PC_Signalling_05;         /* T_ul_OL_PC_Signalling_05 */
static int hf_rrc_individuallySignalled_05;       /* T_individuallySignalled_05 */
static int hf_rrc_tddOption_26;                   /* T_tddOption_26 */
static int hf_rrc_tdd384_46;                      /* T_tdd384_42 */
static int hf_rrc_tdd768_27;                      /* T_tdd768_24 */
static int hf_rrc_tdd128_66;                      /* T_tdd128_64 */
static int hf_rrc_dpcch_PowerOffset_01;           /* DPCCH_PowerOffset2 */
static int hf_rrc_fdd_143;                        /* T_fdd_140 */
static int hf_rrc_tdd_92;                         /* T_tdd_86 */
static int hf_rrc_tdd_93;                         /* T_tdd_87 */
static int hf_rrc_non_ScheduledTransGrantInfo_02;  /* Non_ScheduledTransGrantInfoTDD_ext */
static int hf_rrc_mac_es_e_resetIndicator_01;     /* T_mac_es_e_resetIndicator_01 */
static int hf_rrc_e_DPCCH_Info;                   /* E_DPCCH_Info */
static int hf_rrc_e_DPDCH_Info;                   /* E_DPDCH_Info */
static int hf_rrc_schedulingTransmConfiguration;  /* E_DPDCH_SchedulingTransmConfiguration */
static int hf_rrc_mac_es_e_resetIndicator_02;     /* T_mac_es_e_resetIndicator_02 */
static int hf_rrc_modeSpecificInfo_97;            /* T_modeSpecificInfo_97 */
static int hf_rrc_fdd_144;                        /* T_fdd_141 */
static int hf_rrc_e_DPCCH_Info_01;                /* E_DPCCH_Info_r7 */
static int hf_rrc_e_DPDCH_Info_01;                /* E_DPDCH_Info_r7 */
static int hf_rrc_tdd_94;                         /* T_tdd_88 */
static int hf_rrc_e_RUCCH_Info_01;                /* E_RUCCH_Info */
static int hf_rrc_e_PUCH_Info_01;                 /* E_PUCH_Info */
static int hf_rrc_non_ScheduledTransGrantInfo_03;  /* Non_ScheduledTransGrantInfoTDD */
static int hf_rrc_mac_es_e_resetIndicator_03;     /* T_mac_es_e_resetIndicator_03 */
static int hf_rrc_modeSpecificInfo_98;            /* T_modeSpecificInfo_98 */
static int hf_rrc_fdd_145;                        /* T_fdd_142 */
static int hf_rrc_e_DPDCH_Info_02;                /* E_DPDCH_Info_r8 */
static int hf_rrc_tdd_95;                         /* T_tdd_89 */
static int hf_rrc_mac_es_e_resetIndicator_04;     /* T_mac_es_e_resetIndicator_04 */
static int hf_rrc_modeSpecificInfo_99;            /* T_modeSpecificInfo_99 */
static int hf_rrc_fdd_146;                        /* T_fdd_143 */
static int hf_rrc_tdd_96;                         /* T_tdd_90 */
static int hf_rrc_non_ScheduledTransGrantInfo_04;  /* Non_ScheduledTransGrantInfoTDD_r9 */
static int hf_rrc_mac_es_e_resetIndicator_05;     /* T_mac_es_e_resetIndicator_05 */
static int hf_rrc_modeSpecificInfo_100;           /* T_modeSpecificInfo_100 */
static int hf_rrc_fdd_147;                        /* T_fdd_144 */
static int hf_rrc_tdd_97;                         /* T_tdd_91 */
static int hf_rrc_configurationInfo_13;           /* T_configurationInfo_13 */
static int hf_rrc_newConfiguration_21;            /* T_newConfiguration_21 */
static int hf_rrc_s_e_dpcch_power_offset;         /* INTEGER_0_17 */
static int hf_rrc_rank2_minimum_E_TFCI;           /* E_DCH_MinimumSet_E_TFCI */
static int hf_rrc_inter_stream_compensation;      /* INTEGER_0_15 */
static int hf_rrc_e_PUCH_info;                    /* E_PUCH_Info_MulticarrierEDCH_TDD128 */
static int hf_rrc_e_AGCH_info;                    /* E_AGCH_Information_TDD128 */
static int hf_rrc_e_HICH_info;                    /* E_HICH_Information_TDD128 */
static int hf_rrc_UL_MulticarrierEDCH_Infolist_TDD128_item;  /* UL_MulticarrierEDCH_InfolistItem_TDD128 */
static int hf_rrc_UL_MulticarrierEDCH_Deletelist_TDD128_item;  /* UARFCN */
static int hf_rrc_configuration_info;             /* T_configuration_info */
static int hf_rrc_newConfiguration_22;            /* UL_MulticarrierEDCH_NewConfigurationInfo_TDD128 */
static int hf_rrc_tsn_Length_01;                  /* T_tsn_Length_01 */
static int hf_rrc_ul_MulticarrierEDCH_Infolist;   /* UL_MulticarrierEDCH_Infolist_TDD128 */
static int hf_rrc_ul_MulticarrierEDCH_Deletelist;  /* UL_MulticarrierEDCH_Deletelist_TDD128 */
static int hf_rrc_stepSize;                       /* INTEGER_1_8 */
static int hf_rrc_frequency;                      /* INTEGER_1_8 */
static int hf_rrc_disabled;                       /* NULL */
static int hf_rrc_enabled;                        /* T_enabled */
static int hf_rrc_enabled_01;                     /* T_enabled_01 */
static int hf_rrc_tddOption_27;                   /* T_tddOption_27 */
static int hf_rrc_tdd384_47;                      /* T_tdd384_43 */
static int hf_rrc_tdd128_67;                      /* T_tdd128_65 */
static int hf_rrc_synchronisationParameters;      /* SynchronisationParameters_r4 */
static int hf_rrc_enabled_02;                     /* T_enabled_02 */
static int hf_rrc_tddOption_28;                   /* T_tddOption_28 */
static int hf_rrc_tdd384_48;                      /* T_tdd384_44 */
static int hf_rrc_tdd768_28;                      /* T_tdd768_25 */
static int hf_rrc_tdd128_68;                      /* T_tdd128_66 */
static int hf_rrc_enabled_03;                     /* T_enabled_03 */
static int hf_rrc_k;                              /* INTEGER_1_32 */
static int hf_rrc_l;                              /* INTEGER_1_32 */
static int hf_rrc_m;                              /* INTEGER_1_32 */
static int hf_rrc_UL_TS_ChannelisationCodeList_item;  /* UL_TS_ChannelisationCode */
static int hf_rrc_UL_TS_ChannelisationCodeList_r7_item;  /* UL_TS_ChannelisationCodeList_r7_item */
static int hf_rrc_ul_TS_Channelisation_Code;      /* UL_TS_ChannelisationCode */
static int hf_rrc_plcch_info;                     /* PLCCH_Info */
static int hf_rrc_UL_TS_ChannelisationCodeList_VHCR_item;  /* UL_TS_ChannelisationCode_VHCR */
static int hf_rrc_parameters_04;                  /* T_parameters_04 */
static int hf_rrc_sameAsLast_04;                  /* T_sameAsLast_04 */
static int hf_rrc_newParameters_04;               /* T_newParameters_04 */
static int hf_rrc_ul_TS_ChannelisationCodeList;   /* UL_TS_ChannelisationCodeList */
static int hf_rrc_parameters_05;                  /* T_parameters_05 */
static int hf_rrc_sameAsLast_05;                  /* T_sameAsLast_05 */
static int hf_rrc_newParameters_05;               /* T_newParameters_05 */
static int hf_rrc_parameters_06;                  /* T_parameters_06 */
static int hf_rrc_sameAsLast_06;                  /* T_sameAsLast_06 */
static int hf_rrc_newParameters_06;               /* T_newParameters_06 */
static int hf_rrc_ul_TS_ChannelisationCodeList_01;  /* UL_TS_ChannelisationCodeList_r7 */
static int hf_rrc_parameters_07;                  /* T_parameters_07 */
static int hf_rrc_sameAsLast_07;                  /* T_sameAsLast_07 */
static int hf_rrc_newParameters_07;               /* T_newParameters_07 */
static int hf_rrc_dynamicSFusage;                 /* BOOLEAN */
static int hf_rrc_moreTimeslots_04;               /* T_moreTimeslots_04 */
static int hf_rrc_additionalTimeslots_04;         /* T_additionalTimeslots_04 */
static int hf_rrc_consecutive_04;                 /* T_consecutive_02 */
static int hf_rrc_numAdditionalTimeslots;         /* INTEGER_1_maxTS_1 */
static int hf_rrc_timeslotList_04;                /* SEQUENCE_SIZE_1_maxTS_1_OF_UplinkAdditionalTimeslots */
static int hf_rrc_timeslotList_item_04;           /* UplinkAdditionalTimeslots */
static int hf_rrc_ul_TS_ChannelisationCodeList_02;  /* UL_TS_ChannelisationCodeList_VHCR */
static int hf_rrc_moreTimeslots_05;               /* T_moreTimeslots_05 */
static int hf_rrc_additionalTimeslots_05;         /* T_additionalTimeslots_05 */
static int hf_rrc_consecutive_05;                 /* T_consecutive_03 */
static int hf_rrc_timeslotList_05;                /* SEQUENCE_SIZE_1_maxTS_1_OF_UplinkAdditionalTimeslots_VHCR */
static int hf_rrc_timeslotList_item_05;           /* UplinkAdditionalTimeslots_VHCR */
static int hf_rrc_moreTimeslots_06;               /* T_moreTimeslots_06 */
static int hf_rrc_additionalTimeslots_06;         /* T_additionalTimeslots_06 */
static int hf_rrc_consecutive_06;                 /* T_consecutive_04 */
static int hf_rrc_numAdditionalTimeslots_01;      /* INTEGER_1_maxTS_LCR_1 */
static int hf_rrc_timeslotList_06;                /* SEQUENCE_SIZE_1_maxTS_LCR_1_OF_UplinkAdditionalTimeslots_LCR_r4 */
static int hf_rrc_timeslotList_item_06;           /* UplinkAdditionalTimeslots_LCR_r4 */
static int hf_rrc_moreTimeslots_07;               /* T_moreTimeslots_07 */
static int hf_rrc_additionalTimeslots_07;         /* T_additionalTimeslots_07 */
static int hf_rrc_consecutive_07;                 /* T_consecutive_05 */
static int hf_rrc_timeslotList_07;                /* SEQUENCE_SIZE_1_maxTS_LCR_1_OF_UplinkAdditionalTimeslots_LCR_r7 */
static int hf_rrc_timeslotList_item_07;           /* UplinkAdditionalTimeslots_LCR_r7 */
static int hf_rrc_satID;                          /* SatID */
static int hf_rrc_doppler0thOrder;                /* INTEGER_M2048_2047 */
static int hf_rrc_extraDopplerInfo;               /* ExtraDopplerInfo */
static int hf_rrc_codePhase;                      /* INTEGER_0_1022 */
static int hf_rrc_integerCodePhase;               /* INTEGER_0_19 */
static int hf_rrc_gps_BitNumber;                  /* INTEGER_0_3 */
static int hf_rrc_codePhaseSearchWindow;          /* CodePhaseSearchWindow */
static int hf_rrc_azimuthAndElevation;            /* AzimuthAndElevation */
static int hf_rrc_azimuthAndElevation_01;         /* AzimuthAndElevation_va40ext */
static int hf_rrc_azimuthAndElevation_02;         /* AzimuthAndElevation_r10 */
static int hf_rrc_extraDopplerInfoExtension;      /* ExtraDopplerInfoExtension */
static int hf_rrc_AcquisitionSatInfoList_item;    /* AcquisitionSatInfo */
static int hf_rrc_AcquisitionSatInfoList_va40ext_item;  /* AcquisitionSatInfo_va40ext */
static int hf_rrc_AcquisitionSatInfoList_r10_item;  /* AcquisitionSatInfo_r10 */
static int hf_rrc_AcquisitionSatInfoList_vc50ext_item;  /* AcquisitionSatInfo_vc50ext */
static int hf_rrc_AcquisitionSatInfoList_r12_item;  /* AcquisitionSatInfo_r12 */
static int hf_rrc_AdditionalMeasurementID_List_item;  /* MeasurementIdentity */
static int hf_rrc_AdditionalMeasurementID_List_r9_item;  /* MeasurementIdentity_r9 */
static int hf_rrc_dataID;                         /* INTEGER_0_3 */
static int hf_rrc_e;                              /* BIT_STRING_SIZE_16 */
static int hf_rrc_almanacSatInfo_t_oa;            /* BIT_STRING_SIZE_8 */
static int hf_rrc_deltaI;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_omegaDot;                       /* BIT_STRING_SIZE_16 */
static int hf_rrc_satHealth;                      /* BIT_STRING_SIZE_8 */
static int hf_rrc_a_Sqrt;                         /* BIT_STRING_SIZE_24 */
static int hf_rrc_omega0;                         /* BIT_STRING_SIZE_24 */
static int hf_rrc_m0;                             /* BIT_STRING_SIZE_24 */
static int hf_rrc_omega;                          /* BIT_STRING_SIZE_24 */
static int hf_rrc_af0;                            /* BIT_STRING_SIZE_11 */
static int hf_rrc_af1;                            /* BIT_STRING_SIZE_11 */
static int hf_rrc_AlmanacSatInfoList_item;        /* AlmanacSatInfo */
static int hf_rrc_sat_info_BDSkpList;             /* GANSS_SAT_Info_Almanac_BDSkpList */
static int hf_rrc_sat_info_SBASecefList;          /* GANSS_SAT_Info_Almanac_SBASecefList */
static int hf_rrc_sat_info_GLOkpList;             /* GANSS_SAT_Info_Almanac_GLOkpList */
static int hf_rrc_t_oa_0_1023;                    /* INTEGER_0_1023 */
static int hf_rrc_iod_a;                          /* INTEGER_0_15 */
static int hf_rrc_sat_info_kpList;                /* GANSS_SAT_Info_Almanac_KpList */
static int hf_rrc_t_oa;                           /* INTEGER_0_147 */
static int hf_rrc_sat_info_MIDIkpList;            /* GANSS_SAT_Info_Almanac_MIDIkpList */
static int hf_rrc_sat_info_NAVkpList;             /* GANSS_SAT_Info_Almanac_NAVkpList */
static int hf_rrc_sat_info_REDkpList;             /* GANSS_SAT_Info_Almanac_REDkpList */
static int hf_rrc_AuxInfoGANSS_ID1_item;          /* AuxInfoGANSS_ID1_element */
static int hf_rrc_svID;                           /* INTEGER_0_63 */
static int hf_rrc_signalsAvailable;               /* BIT_STRING_SIZE_8 */
static int hf_rrc_AuxInfoGANSS_ID3_item;          /* AuxInfoGANSS_ID3_element */
static int hf_rrc_channelNumber;                  /* INTEGER_M7_13 */
static int hf_rrc_azimuth;                        /* INTEGER_0_31 */
static int hf_rrc_elevation;                      /* INTEGER_0_7 */
static int hf_rrc_azimuthLSB;                     /* INTEGER_0_15 */
static int hf_rrc_elevationLSB;                   /* INTEGER_0_15 */
static int hf_rrc_BadSatList_item;                /* INTEGER_0_63 */
static int hf_rrc_bdsAODC;                        /* BIT_STRING_SIZE_5 */
static int hf_rrc_bdsToc;                         /* BIT_STRING_SIZE_17 */
static int hf_rrc_bdsa0;                          /* BIT_STRING_SIZE_24 */
static int hf_rrc_bdsa1;                          /* BIT_STRING_SIZE_22 */
static int hf_rrc_bdsa2;                          /* BIT_STRING_SIZE_11 */
static int hf_rrc_bdsTgd1;                        /* BIT_STRING_SIZE_10 */
static int hf_rrc_BDS_IGPInfoList_item;           /* BDS_IGPInfoList_item */
static int hf_rrc_bds_IGPNumber;                  /* INTEGER_1_320 */
static int hf_rrc_bds_VerticalDelay;              /* BIT_STRING_SIZE_9 */
static int hf_rrc_bds_GIVEI;                      /* BIT_STRING_SIZE_4 */
static int hf_rrc_DBDS_InfoList_item;             /* DBDS_Info */
static int hf_rrc_bds_SignalID;                   /* GANSS_Signal_Id */
static int hf_rrc_dbds_SignalInfoList;            /* DBDS_SignalInfoList */
static int hf_rrc_DBDS_SignalInfoList_item;       /* DBDS_SignalInfo */
static int hf_rrc_bds_UDREI;                      /* INTEGER_0_15 */
static int hf_rrc_bds_RURAI;                      /* INTEGER_0_15 */
static int hf_rrc_bds_ECC_DeltaT;                 /* BIT_STRING_SIZE_13 */
static int hf_rrc_dl_TransportChannelBLER;        /* DL_TransportChannelBLER */
static int hf_rrc_BLER_MeasurementResultsList_item;  /* BLER_MeasurementResults */
static int hf_rrc_BLER_TransChIdList_item;        /* TransportChannelIdentity */
static int hf_rrc_verifiedBSIC;                   /* INTEGER_0_maxCellMeas */
static int hf_rrc_nonVerifiedBSIC;                /* BCCH_ARFCN */
static int hf_rrc_burstStart;                     /* INTEGER_0_15 */
static int hf_rrc_burstLength;                    /* INTEGER_10_25 */
static int hf_rrc_burstFreq;                      /* INTEGER_1_16 */
static int hf_rrc_intraFreqReportingCriteria;     /* IntraFreqReportingCriteria */
static int hf_rrc_periodicalReportingCriteria;    /* PeriodicalReportingCriteria */
static int hf_rrc_intraFreqReportingCriteria_01;  /* IntraFreqReportingCriteria_LCR_r4 */
static int hf_rrc_patternIdentifier;              /* INTEGER_0_maxMeasOccasionPattern_1 */
static int hf_rrc_statusFlag;                     /* T_statusFlag */
static int hf_rrc_measurementPurpose;             /* BIT_STRING_SIZE_5 */
static int hf_rrc_measurementOccasionPatternParameter;  /* MeasurementOccasionPatternParameter */
static int hf_rrc_cellDCHMeasOccasionSequenceList;  /* SEQUENCE_SIZE_1_maxMeasOccasionPattern_OF_CellDCHMeasOccasionPattern_LCR */
static int hf_rrc_cellDCHMeasOccasionSequenceList_item;  /* CellDCHMeasOccasionPattern_LCR */
static int hf_rrc_cellIndividualOffset;           /* CellIndividualOffset */
static int hf_rrc_referenceTimeDifferenceToCell;  /* ReferenceTimeDifferenceToCell */
static int hf_rrc_modeSpecificInfo_101;           /* T_modeSpecificInfo_101 */
static int hf_rrc_fdd_148;                        /* T_fdd_145 */
static int hf_rrc_readSFN_Indicator;              /* BOOLEAN */
static int hf_rrc_tdd_98;                         /* T_tdd_92 */
static int hf_rrc_primaryCCPCH_Info_02;           /* PrimaryCCPCH_Info */
static int hf_rrc_timeslotInfoList;               /* TimeslotInfoList */
static int hf_rrc_modeSpecificInfo_102;           /* T_modeSpecificInfo_102 */
static int hf_rrc_fdd_149;                        /* T_fdd_146 */
static int hf_rrc_tdd_99;                         /* T_tdd_93 */
static int hf_rrc_primaryCCPCH_Info_03;           /* PrimaryCCPCH_Info_r4 */
static int hf_rrc_timeslotInfoList_01;            /* TimeslotInfoList_r4 */
static int hf_rrc_cellSelectionReselectionInfo;   /* CellSelectReselectInfoMC_RSCP */
static int hf_rrc_modeSpecificInfo_103;           /* T_modeSpecificInfo_103 */
static int hf_rrc_fdd_150;                        /* T_fdd_147 */
static int hf_rrc_tdd_100;                        /* T_tdd_94 */
static int hf_rrc_CellInfoListToBeExcluded_item;  /* PrimaryCPICH_Info */
static int hf_rrc_modeSpecificInfo_104;           /* T_modeSpecificInfo_104 */
static int hf_rrc_fdd_151;                        /* T_fdd_148 */
static int hf_rrc_tdd_101;                        /* T_tdd_95 */
static int hf_rrc_cellSelectionReselectionInfo_01;  /* CellSelectReselectInfoSIB_11_12_RSCP */
static int hf_rrc_primaryCCPCH_Info_04;           /* PrimaryCCPCH_Info_LCR_r4 */
static int hf_rrc_timeslotInfoList_02;            /* TimeslotInfoList_LCR_r4 */
static int hf_rrc_modeSpecificInfo_105;           /* T_modeSpecificInfo_105 */
static int hf_rrc_fdd_152;                        /* T_fdd_149 */
static int hf_rrc_tdd_102;                        /* T_tdd_96 */
static int hf_rrc_cellSelectionReselectionInfo_02;  /* CellSelectReselectInfoSIB_11_12_ECN0 */
static int hf_rrc_modeSpecificInfo_106;           /* T_modeSpecificInfo_106 */
static int hf_rrc_fdd_153;                        /* T_fdd_150 */
static int hf_rrc_tdd_103;                        /* T_tdd_97 */
static int hf_rrc_cellSelectionReselectionInfo_03;  /* CellSelectReselectInfoSIB_11_12_HCS_RSCP */
static int hf_rrc_modeSpecificInfo_107;           /* T_modeSpecificInfo_107 */
static int hf_rrc_fdd_154;                        /* T_fdd_151 */
static int hf_rrc_tdd_104;                        /* T_tdd_98 */
static int hf_rrc_cellSelectionReselectionInfo_04;  /* CellSelectReselectInfoSIB_11_12_HCS_ECN0 */
static int hf_rrc_cellIdentity;                   /* CellIdentity */
static int hf_rrc_sFN_SFN_ObsTimeDifference;      /* SFN_SFN_ObsTimeDifference */
static int hf_rrc_cellSynchronisationInfo;        /* CellSynchronisationInfo */
static int hf_rrc_modeSpecificInfo_108;           /* T_modeSpecificInfo_108 */
static int hf_rrc_fdd_155;                        /* T_fdd_152 */
static int hf_rrc_cpich_Ec_N0_01;                 /* CPICH_Ec_N0 */
static int hf_rrc_cpich_RSCP_01;                  /* CPICH_RSCP */
static int hf_rrc_pathloss;                       /* Pathloss */
static int hf_rrc_tdd_105;                        /* T_tdd_99 */
static int hf_rrc_proposedTGSN;                   /* TGSN */
static int hf_rrc_timeslotISCP_List;              /* TimeslotISCP_List */
static int hf_rrc_modeSpecificInfo_109;           /* T_modeSpecificInfo_109 */
static int hf_rrc_fdd_156;                        /* T_fdd_153 */
static int hf_rrc_deltaRSCPPerCell;               /* DeltaRSCPPerCell */
static int hf_rrc_tdd_106;                        /* T_tdd_100 */
static int hf_rrc_csgIdentity;                    /* CSG_Identity */
static int hf_rrc_csgMemberIndication;            /* T_csgMemberIndication */
static int hf_rrc_csg_MemberPLMNList;             /* CSG_MemberPLMNList */
static int hf_rrc_fdd_157;                        /* SEQUENCE_SIZE_1_maxCellMeas_OF_PrimaryCPICH_Info */
static int hf_rrc_fdd_item_01;                    /* PrimaryCPICH_Info */
static int hf_rrc_tdd_107;                        /* SEQUENCE_SIZE_1_maxCellMeas_OF_PrimaryCCPCH_Info */
static int hf_rrc_tdd_item_02;                    /* PrimaryCCPCH_Info */
static int hf_rrc_fdd_158;                        /* SEQUENCE_SIZE_1_maxCellMeasOnSecULFreq_OF_PrimaryCPICH_Info */
static int hf_rrc_CellMeasurementEventResults_LCR_r4_item;  /* PrimaryCCPCH_Info_LCR_r4 */
static int hf_rrc_sFN_SFN_OTD_Type;               /* SFN_SFN_OTD_Type */
static int hf_rrc_cellIdentity_reportingIndicator;  /* BOOLEAN */
static int hf_rrc_cellSynchronisationInfoReportingIndicator;  /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_110;           /* T_modeSpecificInfo_110 */
static int hf_rrc_fdd_159;                        /* T_fdd_154 */
static int hf_rrc_cpich_Ec_N0_reportingIndicator;  /* BOOLEAN */
static int hf_rrc_cpich_RSCP_reportingIndicator;  /* BOOLEAN */
static int hf_rrc_pathloss_reportingIndicator;    /* BOOLEAN */
static int hf_rrc_tdd_108;                        /* T_tdd_101 */
static int hf_rrc_timeslotISCP_reportingIndicator;  /* BOOLEAN */
static int hf_rrc_proposedTGSN_ReportingRequired;  /* BOOLEAN */
static int hf_rrc_primaryCCPCH_RSCP_reportingIndicator;  /* BOOLEAN */
static int hf_rrc_q_OffsetS_N;                    /* Q_OffsetS_N */
static int hf_rrc_hcs_NeighbouringCellInformation_RSCP;  /* HCS_NeighbouringCellInformation_RSCP */
static int hf_rrc_modeSpecificInfo_111;           /* T_modeSpecificInfo_111 */
static int hf_rrc_fdd_160;                        /* T_fdd_155 */
static int hf_rrc_tdd_109;                        /* T_tdd_102 */
static int hf_rrc_gsm_04;                         /* T_gsm_04 */
static int hf_rrc_q_Offset1S_N;                   /* Q_OffsetS_N */
static int hf_rrc_q_Offset2S_N;                   /* Q_OffsetS_N */
static int hf_rrc_modeSpecificInfo_112;           /* T_modeSpecificInfo_112 */
static int hf_rrc_fdd_161;                        /* T_fdd_156 */
static int hf_rrc_tdd_110;                        /* T_tdd_103 */
static int hf_rrc_gsm_05;                         /* T_gsm_05 */
static int hf_rrc_modeSpecificInfo_113;           /* T_modeSpecificInfo_113 */
static int hf_rrc_fdd_162;                        /* T_fdd_157 */
static int hf_rrc_tdd_111;                        /* T_tdd_104 */
static int hf_rrc_gsm_06;                         /* T_gsm_06 */
static int hf_rrc_modeSpecificInfo_114;           /* T_modeSpecificInfo_114 */
static int hf_rrc_fdd_163;                        /* T_fdd_158 */
static int hf_rrc_tdd_112;                        /* T_tdd_105 */
static int hf_rrc_gsm_07;                         /* T_gsm_07 */
static int hf_rrc_modeSpecificInfo_115;           /* T_modeSpecificInfo_115 */
static int hf_rrc_fdd_164;                        /* T_fdd_159 */
static int hf_rrc_tdd_113;                        /* T_tdd_106 */
static int hf_rrc_gsm_08;                         /* T_gsm_08 */
static int hf_rrc_hcs_NeighbouringCellInformation_ECN0;  /* HCS_NeighbouringCellInformation_ECN0 */
static int hf_rrc_modeSpecificInfo_116;           /* T_modeSpecificInfo_116 */
static int hf_rrc_fdd_165;                        /* T_fdd_160 */
static int hf_rrc_tdd_114;                        /* T_tdd_107 */
static int hf_rrc_gsm_09;                         /* T_gsm_09 */
static int hf_rrc_deltaQrxlevmin;                 /* DeltaQrxlevmin */
static int hf_rrc_deltaQhcs;                      /* DeltaRSCP */
static int hf_rrc_q_Hyst_l_S_PCH;                 /* Q_Hyst_S_Fine */
static int hf_rrc_q_Hyst_l_S_FACH;                /* Q_Hyst_S_Fine */
static int hf_rrc_q_Hyst_2_S_PCH;                 /* Q_Hyst_S_Fine */
static int hf_rrc_q_Hyst_2_S_FACH;                /* Q_Hyst_S_Fine */
static int hf_rrc_t_Reselection_S_PCH;            /* T_Reselection_S */
static int hf_rrc_t_Reselection_S_FACH;           /* T_Reselection_S_Fine */
static int hf_rrc_non_HCS_t_CR_Max;               /* T_CRMax */
static int hf_rrc_speedDependentScalingFactor;    /* SpeedDependentScalingFactor */
static int hf_rrc_interFrequencyTreselectionScalingFactor;  /* TreselectionScalingFactor */
static int hf_rrc_interRATTreselectionScalingFactor;  /* TreselectionScalingFactor */
static int hf_rrc_CellsForInterFreqMeasList_item;  /* InterFreqCellID */
static int hf_rrc_CellsForInterFreqMeasList_r12_item;  /* InterFreqCellID_r12 */
static int hf_rrc_CellsForInterRATMeasList_item;  /* InterRATCellID */
static int hf_rrc_CellsForIntraFreqMeasList_item;  /* IntraFreqCellID */
static int hf_rrc_CellsForIntraFreqMeasListOnSecULFreq_item;  /* IntraFreqCellIDOnSecULFreq */
static int hf_rrc_modeSpecificInfo_117;           /* T_modeSpecificInfo_117 */
static int hf_rrc_fdd_166;                        /* T_fdd_161 */
static int hf_rrc_countC_SFN_Frame_difference;    /* CountC_SFN_Frame_difference */
static int hf_rrc_tm;                             /* INTEGER_0_38399 */
static int hf_rrc_tdd_115;                        /* T_tdd_108 */
static int hf_rrc_bsicReported;                   /* BSICReported */
static int hf_rrc_CellToReportList_item;          /* CellToReport */
static int hf_rrc_cnavToc;                        /* BIT_STRING_SIZE_11 */
static int hf_rrc_cnavTop;                        /* BIT_STRING_SIZE_11 */
static int hf_rrc_cnavURA0;                       /* BIT_STRING_SIZE_5 */
static int hf_rrc_cnavURA1;                       /* BIT_STRING_SIZE_3 */
static int hf_rrc_cnavURA2;                       /* BIT_STRING_SIZE_3 */
static int hf_rrc_cnavAf2;                        /* BIT_STRING_SIZE_10 */
static int hf_rrc_cnavAf1;                        /* BIT_STRING_SIZE_20 */
static int hf_rrc_cnavAf0;                        /* BIT_STRING_SIZE_26 */
static int hf_rrc_cnavTgd;                        /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl1cp;                    /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl1cd;                    /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl1ca;                    /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl2c;                     /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl5i5;                    /* BIT_STRING_SIZE_13 */
static int hf_rrc_cnavISCl5q5;                    /* BIT_STRING_SIZE_13 */
static int hf_rrc_countC_SFN_High;                /* INTEGER_0_15 */
static int hf_rrc_off;                            /* INTEGER_0_255 */
static int hf_rrc_CSG_MemberPLMNList_item;        /* PLMN_Identity */
static int hf_rrc_modeSpecificInfo_118;           /* T_modeSpecificInfo_118 */
static int hf_rrc_fdd_167;                        /* T_fdd_162 */
static int hf_rrc_startPSC_01;                    /* PrimaryCPICH_Info */
static int hf_rrc_numberOfPSCs_01;                /* INTEGER_1_512 */
static int hf_rrc_CSGCellInfoList_item;           /* CSGCellInfo */
static int hf_rrc_cSGInterFreqCellInfoListperFreq;  /* CSGCellInfoList */
static int hf_rrc_CSGInterFreqCellInfoList_item;  /* CSGInterFreqCellInfo */
static int hf_rrc_uTRACSGProximityDetec;          /* T_uTRACSGProximityDetec */
static int hf_rrc_e_UTRACSGProximityDetec;        /* T_e_UTRACSGProximityDetec */
static int hf_rrc_cSGproximityInd;                /* T_cSGproximityInd */
static int hf_rrc_radioAccessTechnology_03;       /* T_radioAccessTechnology_03 */
static int hf_rrc_uTRA;                           /* T_uTRA */
static int hf_rrc_cSGFrequencyInfoUTRA;           /* FrequencyInfo */
static int hf_rrc_e_UTRA;                         /* T_e_UTRA */
static int hf_rrc_cSGFrequencyInfoEUTRA;          /* EARFCN */
static int hf_rrc_cSGFrequencyInfoEUTRA_01;       /* EARFCNExtension */
static int hf_rrc_ganss_signal_id;                /* GANSS_Signal_Id */
static int hf_rrc_data_bits;                      /* BIT_STRING_SIZE_1_1024 */
static int hf_rrc_DataBitAssistanceList_item;     /* DataBitAssistanceSat */
static int hf_rrc_satID_01;                       /* INTEGER_0_63 */
static int hf_rrc_dataBitAssistanceSgnList;       /* DataBitAssistanceSgnList */
static int hf_rrc_DataBitAssistanceSgnList_item;  /* DataBitAssistance */
static int hf_rrc_deltaRSCP;                      /* DeltaRSCP */
static int hf_rrc_b1;                             /* BIT_STRING_SIZE_11 */
static int hf_rrc_b2;                             /* BIT_STRING_SIZE_10 */
static int hf_rrc_ganssSignalId;                  /* GANSS_Signal_Id */
static int hf_rrc_ganssStatusHealth;              /* GANSS_Status_Health */
static int hf_rrc_dgansssignalInformationList;    /* DGANSSSignalInformationList */
static int hf_rrc_dgansssignalInformationList_01;  /* DGANSSSignalInformationList_r9 */
static int hf_rrc_dgansssignalInformationList_02;  /* DGANSSSignalInformationList_v920ext */
static int hf_rrc_DGANSSInfoList_item;            /* DGANSSInfo */
static int hf_rrc_DGANSSInfoList_r9_item;         /* DGANSSInfo_r9 */
static int hf_rrc_DGANSSInfoList_v920ext_item;    /* DGANSSInfo_v920ext */
static int hf_rrc_satId;                          /* INTEGER_0_63 */
static int hf_rrc_iode_dganss;                    /* BIT_STRING_SIZE_10 */
static int hf_rrc_udre;                           /* UDRE */
static int hf_rrc_ganss_prc;                      /* INTEGER_M2047_2047 */
static int hf_rrc_ganss_rrc;                      /* INTEGER_M127_127 */
static int hf_rrc_udreGrowthRate;                 /* UDREGrowthRate */
static int hf_rrc_udreValidityTime;               /* UDREValidityTime */
static int hf_rrc_DGANSSSignalInformationList_item;  /* DGANSSSignalInformation */
static int hf_rrc_DGANSSSignalInformationList_r9_item;  /* DGANSSSignalInformation_r9 */
static int hf_rrc_DGANSSSignalInformationList_v920ext_item;  /* DGANSSSignalInformation_v920ext */
static int hf_rrc_iode;                           /* IODE */
static int hf_rrc_prc;                            /* PRC */
static int hf_rrc_rrc;                            /* RRC */
static int hf_rrc_deltaPRC;                       /* DeltaPRC */
static int hf_rrc_deltaPRC_01;                    /* DeltaRRC */
static int hf_rrc_DGPS_CorrectionSatInfoList_item;  /* DGPS_CorrectionSatInfo */
static int hf_rrc_DGPS_CorrectionSatInfoList_r9_item;  /* DGPS_CorrectionSatInfo_r9 */
static int hf_rrc_DGPS_CorrectionSatInfoList_v920ext_item;  /* DGPS_CorrectionSatInfo_v920ext */
static int hf_rrc_latitudeSign;                   /* T_latitudeSign */
static int hf_rrc_latitude;                       /* INTEGER_0_8388607 */
static int hf_rrc_longitude;                      /* INTEGER_M8388608_8388607 */
static int hf_rrc_latitudeSign_01;                /* T_latitudeSign_01 */
static int hf_rrc_altitudeDirection;              /* T_altitudeDirection */
static int hf_rrc_altitude;                       /* INTEGER_0_32767 */
static int hf_rrc_latitudeSign_02;                /* T_latitudeSign_02 */
static int hf_rrc_altitudeDirection_01;           /* T_altitudeDirection_01 */
static int hf_rrc_uncertaintySemiMajor;           /* INTEGER_0_127 */
static int hf_rrc_uncertaintySemiMinor;           /* INTEGER_0_127 */
static int hf_rrc_orientationMajorAxis;           /* INTEGER_0_89 */
static int hf_rrc_uncertaintyAltitude;            /* INTEGER_0_127 */
static int hf_rrc_confidence;                     /* INTEGER_0_100 */
static int hf_rrc_latitudeSign_03;                /* T_latitudeSign_03 */
static int hf_rrc_uncertaintyCode;                /* INTEGER_0_127 */
static int hf_rrc_latitudeSign_04;                /* T_latitudeSign_04 */
static int hf_rrc_EUTRA_CSGMemberPLMNList_item;   /* PLMN_Identity */
static int hf_rrc_reportedCells;                  /* SEQUENCE_SIZE_1_maxReportedEUTRACellPerFreq_OF_EUTRA_PhysicalCellIdentity */
static int hf_rrc_reportedCells_item;             /* EUTRA_PhysicalCellIdentity */
static int hf_rrc_earfcn_01;                      /* EARFCNExtension */
static int hf_rrc_earfcn_02;                      /* EARFCNExtension2 */
static int hf_rrc_Eutra_EventResultList_item;     /* Eutra_EventResult */
static int hf_rrc_EUTRA_EventResultList_vb50ext_item;  /* EUTRA_EventResult_vb50ext */
static int hf_rrc_EUTRA_EventResultList_vc50ext_item;  /* EUTRA_EventResult_vc50ext */
static int hf_rrc_eventID;                        /* EventIDInterRAT */
static int hf_rrc_eutra_EventResultsList;         /* Eutra_EventResultList */
static int hf_rrc_eutra_EventResultsList_01;      /* EUTRA_EventResultList_vb50ext */
static int hf_rrc_eutra_EventResultsList_02;      /* EUTRA_EventResultList_vc50ext */
static int hf_rrc_eutraFrequencyIndicator;        /* BIT_STRING_SIZE_maxNumEUTRAFreqs_FACH */
static int hf_rrc_measurementBandwidth;           /* EUTRA_MeasurementBandwidth */
static int hf_rrc_qRxLevMinEUTRA;                 /* INTEGER_M70_M22 */
static int hf_rrc_threshXhigh;                    /* INTEGER_0_31 */
static int hf_rrc_threshXlow;                     /* INTEGER_0_31 */
static int hf_rrc_eutra_exclude_ListedCellList;   /* EUTRA_Exclude_listedCellPerFreqList */
static int hf_rrc_qqualMinEUTRA;                  /* INTEGER_M34_M3 */
static int hf_rrc_threshXhigh2;                   /* INTEGER_0_31 */
static int hf_rrc_threshXlow2;                    /* INTEGER_0_31 */
static int hf_rrc_qqualMinEUTRA_WB;               /* INTEGER_M34_M3 */
static int hf_rrc_qqualMinRSRQ_OnAllSymbols;      /* INTEGER_M34_M3 */
static int hf_rrc_reducedMeasurementPerformance;  /* T_reducedMeasurementPerformance */
static int hf_rrc_subpriority_01;                 /* T_subpriority_01 */
static int hf_rrc_eutra_exclude_listedCellList;   /* EUTRA_Exclude_listedCellPerFreqList */
static int hf_rrc_reducedMeasurementPerformance_01;  /* T_reducedMeasurementPerformance_01 */
static int hf_rrc_subpriority_02;                 /* T_subpriority_02 */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoExtensionList_item;  /* EUTRA_FrequencyAndPriorityInfoExtension_vb50ext */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoExtensionList_vb80ext_item;  /* EUTRA_FrequencyAndPriorityInfoExtension_vb80ext */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoExtensionList_vc50ext_item;  /* EUTRA_FrequencyAndPriorityInfoExtension_vc50ext */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoExtensionList_vd20ext_item;  /* EUTRA_FrequencyAndPriorityInfoExtension_vd20ext */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoList_item;  /* EUTRA_FrequencyAndPriorityInfo */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoList_v920ext_item;  /* EUTRA_FrequencyAndPriorityInfo_v920ext */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoList_vb50ext_item;  /* EUTRA_FrequencyAndPriorityInfo_vb50ext */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoList_vc50ext_item;  /* EUTRA_FrequencyAndPriorityInfo_vc50ext */
static int hf_rrc_EUTRA_FrequencyAndPriorityInfoList_vd20ext_item;  /* EUTRA_FrequencyAndPriorityInfo_vd20ext */
static int hf_rrc_eutraFrequencyRemoval;          /* EUTRA_FrequencyRemoval */
static int hf_rrc_eutraNewFrequencies;            /* EUTRA_FrequencyInfoList */
static int hf_rrc_eutraSIAcquisition;             /* EUTRA_SIAcquisition */
static int hf_rrc_eutraFrequencyRemoval_01;       /* EUTRA_FrequencyRemoval_r11 */
static int hf_rrc_eutraNewFrequencies_01;         /* EUTRA_FrequencyInfoList_r11 */
static int hf_rrc_eutraSIAcquisition_01;          /* EUTRA_SIAcquisition_r11 */
static int hf_rrc_eutraNewFrequencies_02;         /* EUTRA_FrequencyInfoList_r12 */
static int hf_rrc_rsrqMeasOnAllSymbols;           /* BOOLEAN */
static int hf_rrc_physicalCellIdentity;           /* EUTRA_PhysicalCellIdentity */
static int hf_rrc_rSRP;                           /* INTEGER_0_97 */
static int hf_rrc_rSRQ;                           /* INTEGER_0_33 */
static int hf_rrc_measuredEUTRACells;             /* SEQUENCE_SIZE_1_maxReportedEUTRACellPerFreq_OF_EUTRA_MeasuredCells */
static int hf_rrc_measuredEUTRACells_item;        /* EUTRA_MeasuredCells */
static int hf_rrc_Eutra_MeasuredResultList_item;  /* Eutra_MeasuredResult */
static int hf_rrc_EUTRA_MeasuredResultList_vb50ext_item;  /* EUTRA_MeasuredResult_vb50ext */
static int hf_rrc_eutraMeasuredResultList;        /* Eutra_MeasuredResultList */
static int hf_rrc_eutraMeasuredResultList_01;     /* EUTRA_MeasuredResultList_vb50ext */
static int hf_rrc_eutraSIacquisitionResults;      /* EUTRA_SIacquisitionResults */
static int hf_rrc_eutraSIacquisitionResults_01;   /* EUTRA_SIacquisitionResults_vc50ext */
static int hf_rrc_rsrqExtension;                  /* INTEGER_M30_46 */
static int hf_rrc_measuredEUTRACells_v920ext;     /* SEQUENCE_SIZE_1_maxReportedEUTRACellPerFreq_OF_EUTRA_MeasuredCells_v920ext */
static int hf_rrc_measuredEUTRACells_v920ext_item;  /* EUTRA_MeasuredCells_v920ext */
static int hf_rrc_measuredEUTRACells_vc50ext;     /* SEQUENCE_SIZE_1_maxReportedEUTRACellPerFreq_OF_EUTRA_MeasuredCells_vc50ext */
static int hf_rrc_measuredEUTRACells_vc50ext_item;  /* EUTRA_MeasuredCells_vc50ext */
static int hf_rrc_Eutra_MeasuredResultList_v920ext_item;  /* Eutra_MeasuredResult_v920ext */
static int hf_rrc_Eutra_MeasuredResultList_vc50ext_item;  /* Eutra_MeasuredResult_vc50ext */
static int hf_rrc_eutraMeasuredResultList_v920ext;  /* Eutra_MeasuredResultList_v920ext */
static int hf_rrc_eutraMeasuredResultList_vc50ext;  /* Eutra_MeasuredResultList_vc50ext */
static int hf_rrc_cgiInfo;                        /* T_cgiInfo */
static int hf_rrc_cellIdentity_01;                /* BIT_STRING_SIZE_28 */
static int hf_rrc_trackingAreaCode;               /* BIT_STRING_SIZE_16 */
static int hf_rrc_csgMemberIndication_01;         /* T_csgMemberIndication_01 */
static int hf_rrc_cgiInfo_01;                     /* CGI_Info */
static int hf_rrc_csgMemberIndication_02;         /* T_csgMemberIndication_02 */
static int hf_rrc_csgMemberPLMN;                  /* EUTRA_CSGMemberPLMNList */
static int hf_rrc_primaryPLMNSuitable;            /* T_primaryPLMNSuitable */
static int hf_rrc_removeAllFrequencies;           /* NULL */
static int hf_rrc_removeSomeFrequencies;          /* SEQUENCE_SIZE_1_maxNumEUTRAFreqs_OF_EARFCN */
static int hf_rrc_removeSomeFrequencies_item;     /* EARFCN */
static int hf_rrc_removeNoFrequencies;            /* NULL */
static int hf_rrc_removeSomeFrequencies_01;       /* FrequenciesToRemove */
static int hf_rrc_EUTRA_FrequencyInfoList_item;   /* EUTRA_FrequencyInfo */
static int hf_rrc_EUTRA_FrequencyInfoList_r11_item;  /* EUTRA_FrequencyInfo_r11 */
static int hf_rrc_EUTRA_FrequencyInfoList_r12_item;  /* EUTRA_FrequencyInfo_r12 */
static int hf_rrc_widebandRSRQMeasurements;       /* T_widebandRSRQMeasurements */
static int hf_rrc_reducedMeasurementPerformance_02;  /* T_reducedMeasurementPerformance_02 */
static int hf_rrc_widebandRSRQMeasurements_01;    /* T_widebandRSRQMeasurements_01 */
static int hf_rrc_eutra_FrequencyListIndicator;   /* BIT_STRING_SIZE_maxNumEUTRAFreqs */
static int hf_rrc_eutra_FrequencyRepQuantityRACH;  /* T_eutra_FrequencyRepQuantityRACH */
static int hf_rrc_eutra_FrequencyRACHReportingThreshold;  /* INTEGER_0_97 */
static int hf_rrc_rachReportingPriority;          /* T_rachReportingPriority */
static int hf_rrc_eutra_FrequencyRACHReportingThresholdExtension;  /* INTEGER_M30_M1 */
static int hf_rrc_eutraFrequenciesForMeasurement;  /* SEQUENCE_SIZE_1_maxNumEUTRAFreqs_FACH_OF_EARFCNRange */
static int hf_rrc_eutraFrequenciesForMeasurement_item;  /* EARFCNRange */
static int hf_rrc_reportCriteria;                 /* T_reportCriteria */
static int hf_rrc_measurementQuantity;            /* T_measurementQuantity */
static int hf_rrc_reportingThreshold;             /* INTEGER_0_97 */
static int hf_rrc_eutraFrequenciesForMeasurement_01;  /* SEQUENCE_SIZE_1_maxNumEUTRAFreqs_FACH_ext_OF_EARFCNRange */
static int hf_rrc_reportCriteria_01;              /* T_reportCriteria_01 */
static int hf_rrc_measurementQuantity_01;         /* T_measurementQuantity_01 */
static int hf_rrc_reportingThreshold_01;          /* INTEGER_M30_97 */
static int hf_rrc_FrequenciesToRemove_item;       /* EARFCNRange */
static int hf_rrc_triggeringCondition;            /* TriggeringCondition2 */
static int hf_rrc_forbiddenAffectCellList;        /* ForbiddenAffectCellList */
static int hf_rrc_w;                              /* W */
static int hf_rrc_reportDeactivationThreshold;    /* ReportDeactivationThreshold */
static int hf_rrc_reportingAmount;                /* ReportingAmount */
static int hf_rrc_reportingInterval;              /* ReportingInterval */
static int hf_rrc_forbiddenAffectCellList_01;     /* ForbiddenAffectCellList_r4 */
static int hf_rrc_forbiddenAffectCellListOnSecULFreq;  /* ForbiddenAffectCellListOnSecULFreq */
static int hf_rrc_forbiddenAffectCellList_02;     /* ForbiddenAffectCellList_LCR_r4 */
static int hf_rrc_triggeringCondition_01;         /* TriggeringCondition1 */
static int hf_rrc_periodicReportingInfo_1b;       /* PeriodicReportingInfo_1b */
static int hf_rrc_replacementActivationThreshold;  /* ReplacementActivationThreshold */
static int hf_rrc_useCIO;                         /* BOOLEAN */
static int hf_rrc_thresholdUsedFrequency;         /* ThresholdUsedFrequency */
static int hf_rrc_thresholdUsedFrequency_01;      /* ThresholdUsedFrequency_r6 */
static int hf_rrc_threshold;                      /* Threshold */
static int hf_rrc_usedFreqW;                      /* W */
static int hf_rrc_hysteresis;                     /* HysteresisInterFreq */
static int hf_rrc_timeToTrigger;                  /* TimeToTrigger */
static int hf_rrc_reportingCellStatus;            /* ReportingCellStatus */
static int hf_rrc_nonUsedFreqParameterList;       /* NonUsedFreqParameterList */
static int hf_rrc_nonUsedFreqParameterList_01;    /* NonUsedFreqWList_r6 */
static int hf_rrc_reportingCellStatus_01;         /* ReportingCellStatus_r10 */
static int hf_rrc_nonUsedFreqParameterList_02;    /* NonUsedFreq2aParameterList_r10 */
static int hf_rrc_nonUsedFreqParameterList_03;    /* NonUsedFreq2aParameterList_r11 */
static int hf_rrc_usedFreqThreshold;              /* Threshold */
static int hf_rrc_usedFreqThreshold_01;           /* Threshold_r6 */
static int hf_rrc_nonUsedFreqParameterList_04;    /* NonUsedFreqParameterList_r6 */
static int hf_rrc_nonUsedFreqParameterList_05;    /* NonUsedFreqParameterList_r10 */
static int hf_rrc_nonUsedFreqParameterList_06;    /* NonUsedFreqParameterList_r11 */
static int hf_rrc_useCIO_enum;                    /* T_useCIO_enum */
static int hf_rrc_thresholdOwnSystem;             /* Threshold */
static int hf_rrc_thresholdOtherSystem;           /* Threshold */
static int hf_rrc_hysteresis_01;                  /* Hysteresis */
static int hf_rrc_thresholdOtherSystem_01;        /* Threshold_r12 */
static int hf_rrc_intraFreqEventResults;          /* IntraFreqEventResults */
static int hf_rrc_interFreqEventResults;          /* InterFreqEventResults */
static int hf_rrc_interRATEventResults;           /* InterRATEventResults */
static int hf_rrc_trafficVolumeEventResults;      /* TrafficVolumeEventResults */
static int hf_rrc_qualityEventResults;            /* QualityEventResults */
static int hf_rrc_ue_InternalEventResults;        /* UE_InternalEventResults */
static int hf_rrc_ue_positioning_MeasurementEventResults;  /* UE_Positioning_MeasurementEventResults */
static int hf_rrc_ue_positioning_MeasurementEventResults_01;  /* UE_Positioning_MeasurementEventResults_v770ext */
static int hf_rrc_ue_positioning_MeasurementEventResults_02;  /* UE_Positioning_MeasurementEventResults_v860ext */
static int hf_rrc_interFreqEventResults_01;       /* InterFreqEventResults_va40ext */
static int hf_rrc_intraFreqEventResults_01;       /* IntraFreqEventResultsOnSecUlFreq */
static int hf_rrc_dopplerFirstOrder;              /* INTEGER_M42_21 */
static int hf_rrc_dopplerUncertainty;             /* T_dopplerUncertainty */
static int hf_rrc_dopplerUncertaintyExt;          /* T_dopplerUncertaintyExt */
static int hf_rrc_doppler1stOrder;                /* INTEGER_M42_21 */
static int hf_rrc_dopplerUncertainty_01;          /* DopplerUncertainty */
static int hf_rrc_dopplerUncertaintyExt_01;       /* DopplerUncertaintyExt */
static int hf_rrc_fACH_meas_occasion_coeff;       /* INTEGER_1_12 */
static int hf_rrc_inter_freq_FDD_meas_ind;        /* BOOLEAN */
static int hf_rrc_inter_freq_TDD_meas_ind;        /* BOOLEAN */
static int hf_rrc_inter_RAT_meas_ind;             /* SEQUENCE_SIZE_1_maxOtherRAT_OF_RAT_Type */
static int hf_rrc_inter_RAT_meas_ind_item;        /* RAT_Type */
static int hf_rrc_inter_freq_TDD128_meas_ind;     /* BOOLEAN */
static int hf_rrc_hysteresis1;                    /* Hysteresis */
static int hf_rrc_hysteresis2;                    /* Hysteresis */
static int hf_rrc_uePowerHeadroomThreshold1;      /* UE_PowerHeadroomThreshold */
static int hf_rrc_uePowerHeadroomThreshold2;      /* UE_PowerHeadroomThreshold */
static int hf_rrc_fdd_168;                        /* PrimaryCPICH_Info */
static int hf_rrc_tdd_116;                        /* PrimaryCCPCH_Info_LCR_r4 */
static int hf_rrc_ForbiddenAffectCellList_item;   /* ForbiddenAffectCell */
static int hf_rrc_ForbiddenAffectCellList_r4_item;  /* ForbiddenAffectCell_r4 */
static int hf_rrc_ForbiddenAffectCellList_LCR_r4_item;  /* ForbiddenAffectCell_LCR_r4 */
static int hf_rrc_ForbiddenAffectCellListOnSecULFreq_item;  /* ForbiddenAffectCellOnSecULFreq */
static int hf_rrc_primaryCPICH;                   /* PrimaryCPICH_Info */
static int hf_rrc_ganssTod;                       /* INTEGER_0_86399 */
static int hf_rrc_dataBitAssistance;              /* ReqDataBitAssistance */
static int hf_rrc_ganssId;                        /* INTEGER_0_7 */
static int hf_rrc_ganssTimeModelsList;            /* GANSSTimeModelsList */
static int hf_rrc_uePositioningDGANSSCorrections;  /* UE_Positioning_DGANSSCorrections */
static int hf_rrc_uePositioningGANSSNavigationModel;  /* UE_Positioning_GANSS_NavigationModel */
static int hf_rrc_uePositioningGANSSRealTimeIntegrity;  /* UE_Positioning_GANSS_RealTimeIntegrity */
static int hf_rrc_uePositioningGANSSDataBitAssistance;  /* UE_Positioning_GANSS_Data_Bit_Assistance */
static int hf_rrc_uePositioningGANSSReferenceMeasurementInfo;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo */
static int hf_rrc_uePositioningGANSSAlmanac;      /* UE_Positioning_GANSS_Almanac */
static int hf_rrc_uePositioningGANSSUTCModel;     /* UE_Positioning_GANSS_UTCModel */
static int hf_rrc_uePositiningGANSSsbasID;        /* UE_Positioning_GANSS_SBAS_ID */
static int hf_rrc_uePositioningGANSSAddNavigationModels;  /* UE_Positioning_GANSS_AddNavigationModels */
static int hf_rrc_uePositioningGANSSAlmanac_01;   /* UE_Positioning_GANSS_Almanac_v860ext */
static int hf_rrc_uePositioningGANSSAddUTCModels;  /* UE_Positioning_GANSS_AddUTCModels */
static int hf_rrc_uePositioningGANSSAuxiliaryInfo;  /* UE_Positioning_GANSS_AuxiliaryInfo */
static int hf_rrc_uePositioningGANSSAlmanac_02;   /* UE_Positioning_GANSS_Almanac_r8 */
static int hf_rrc_uePositioningDGANSSCorrections_01;  /* UE_Positioning_DGANSSCorrections_r9 */
static int hf_rrc_uePositioningDGANSSCorrections_02;  /* UE_Positioning_DGANSSCorrections_v920ext */
static int hf_rrc_ganssTimeModelsList_01;         /* GANSSTimeModelsList_va40ext */
static int hf_rrc_uePositioningGANSSReferenceMeasurementInfo_01;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo_va40ext */
static int hf_rrc_uePositioningGANSSAlmanac_03;   /* UE_Positioning_GANSS_Almanac_va40ext */
static int hf_rrc_uePositioningDBDSCorrections;   /* UE_Positioning_DBDSCorrections */
static int hf_rrc_uePositioningBDSIonoGridModel;  /* UE_Positioning_BDS_IonoGridModel */
static int hf_rrc_ue_positioning_GANSS_AddNavigationModels;  /* UE_Positioning_GANSS_AddNavigationModels_vc50ext */
static int hf_rrc_uePositioningGANSSReferenceMeasurementInfo_02;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo_vc50ext */
static int hf_rrc_ue_Positioning_GANSS_Almanac;   /* UE_Positioning_GANSS_Almanac_vc50ext */
static int hf_rrc_ue_Positioning_GANSS_AddUTCModels;  /* UE_Positioning_GANSS_AddUTCModels_vc50ext */
static int hf_rrc_ganssTimeModelsList_02;         /* GANSSTimeModelsList_r10 */
static int hf_rrc_uePositioningGANSSReferenceMeasurementInfo_03;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo_r10 */
static int hf_rrc_uePositioningGANSSAlmanac_04;   /* UE_Positioning_GANSS_Almanac_r10 */
static int hf_rrc_uePositioningGANSSAddNavigationModels_01;  /* UE_Positioning_GANSS_AddNavigationModels_r12 */
static int hf_rrc_uePositioningGANSSReferenceMeasurementInfo_04;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo_r12 */
static int hf_rrc_uePositioningGANSSAlmanac_05;   /* UE_Positioning_GANSS_Almanac_r12 */
static int hf_rrc_uePositioningGANSSAddUTCModels_01;  /* UE_Positioning_GANSS_AddUTCModels_r12 */
static int hf_rrc_GANSSGenericDataList_item;      /* GANSSGenericData */
static int hf_rrc_GANSSGenericDataList_v860ext_item;  /* GANSSGenericData_v860ext */
static int hf_rrc_GANSSGenericDataList_r8_item;   /* GANSSGenericData_r8 */
static int hf_rrc_GANSSGenericDataList_r9_item;   /* GANSSGenericData_r9 */
static int hf_rrc_GANSSGenericDataList_v920ext_item;  /* GANSSGenericData_v920ext */
static int hf_rrc_GANSSGenericDataList_va40ext_item;  /* GANSSGenericData_va40ext */
static int hf_rrc_GANSSGenericDataList_vc50ext_item;  /* GANSSGenericData_vc50ext */
static int hf_rrc_GANSSGenericDataList_r10_item;  /* GANSSGenericData_r10 */
static int hf_rrc_GANSSGenericDataList_r12_item;  /* GANSSGenericData_r12 */
static int hf_rrc_GANSSGenericMeasurementInfo_item;  /* GANSSGenericMeasurementInfo_item */
static int hf_rrc_ganssMeasurementSignalList;     /* GANSSMeasurementSignalList */
static int hf_rrc_GANSSGenericMeasurementInfo_v860ext_item;  /* GANSSGenericMeasurementInfo_v860ext_item */
static int hf_rrc_ganssMeasurementSignalList_01;  /* GANSSMeasurementSignalList_v860ext */
static int hf_rrc_GANSSMeasurementParameters_item;  /* GANSSMeasurementParameters_item */
static int hf_rrc_cSurNzero;                      /* INTEGER_0_63 */
static int hf_rrc_multipathIndicator;             /* T_multipathIndicator */
static int hf_rrc_carrierQualityIndication;       /* BIT_STRING_SIZE_2 */
static int hf_rrc_ganssCodePhase;                 /* INTEGER_0_2097151 */
static int hf_rrc_ganssIntegerCodePhase;          /* INTEGER_0_63 */
static int hf_rrc_codePhaseRmsError;              /* INTEGER_0_63 */
static int hf_rrc_doppler;                        /* INTEGER_M32768_32767 */
static int hf_rrc_adr;                            /* INTEGER_0_33554431 */
static int hf_rrc_GANSSMeasurementParameters_v860ext_item;  /* GANSSMeasurementParameters_v860ext_item */
static int hf_rrc_ganssIntegerCodePhaseExt;       /* INTEGER_64_127 */
static int hf_rrc_GANSSMeasurementSignalList_item;  /* GANSSMeasurementSignalList_item */
static int hf_rrc_ganssCodePhaseAmbiguity;        /* INTEGER_0_31 */
static int hf_rrc_ganssMeasurementParameters;     /* GANSSMeasurementParameters */
static int hf_rrc_GANSSMeasurementSignalList_v860ext_item;  /* GANSSMeasurementSignalList_v860ext_item */
static int hf_rrc_ganssCodePhaseAmbiguityExt;     /* INTEGER_32_127 */
static int hf_rrc_ganssMeasurementParameters_01;  /* GANSSMeasurementParameters_v860ext */
static int hf_rrc_ganssWeek;                      /* INTEGER_0_4095 */
static int hf_rrc_ganssToe;                       /* INTEGER_0_167 */
static int hf_rrc_t_toeLimit;                     /* INTEGER_0_10 */
static int hf_rrc_satellitesListRelatedDataList;  /* SatellitesListRelatedDataList */
static int hf_rrc_gANSS_tod;                      /* INTEGER_0_3599999 */
static int hf_rrc_gANSS_timeId;                   /* INTEGER_0_7 */
static int hf_rrc_gANSS_tod_uncertainty;          /* INTEGER_0_127 */
static int hf_rrc_ganssRealTimeIntegrity;         /* BOOLEAN */
static int hf_rrc_ganssDifferentialCorrection;    /* DGANSS_Sig_Id_Req */
static int hf_rrc_ganssAlmanac;                   /* BOOLEAN */
static int hf_rrc_ganssNavigationModel;           /* BOOLEAN */
static int hf_rrc_ganssTimeModelGNSS_GNSS;        /* BIT_STRING_SIZE_8 */
static int hf_rrc_ganssReferenceMeasurementInfo;  /* BOOLEAN */
static int hf_rrc_ganssDataBits;                  /* GanssDataBits */
static int hf_rrc_ganssUTCModel;                  /* BOOLEAN */
static int hf_rrc_ganssNavigationModelAdditionalData;  /* GanssNavigationModelAdditionalData */
static int hf_rrc_sbasId;                         /* UE_Positioning_GANSS_SBAS_ID */
static int hf_rrc_ganssAddNavigationModel;        /* T_ganssAddNavigationModel */
static int hf_rrc_ganssAddUTCmodel;               /* T_ganssAddUTCmodel */
static int hf_rrc_ganssAuxInfo;                   /* T_ganssAuxInfo */
static int hf_rrc_ganssAddADchoices;              /* T_ganssAddADchoices */
static int hf_rrc_orbitModelID;                   /* INTEGER_0_7 */
static int hf_rrc_clockModelID;                   /* INTEGER_0_7 */
static int hf_rrc_utcModelID;                     /* INTEGER_0_7 */
static int hf_rrc_almanacModelID;                 /* INTEGER_0_7 */
static int hf_rrc_bdsIonoGridModelReq;            /* T_bdsIonoGridModelReq */
static int hf_rrc_bdsCorrectionsReq;              /* DGANSS_Sig_Id_Req */
static int hf_rrc_GanssRequestedGenericAssistanceDataList_item;  /* GanssReqGenericData */
static int hf_rrc_GanssRequestedGenericAssistanceDataList_v860ext_item;  /* GanssReqGenericData_v860ext */
static int hf_rrc_GanssRequestedGenericAssistanceDataList_vc50ext_item;  /* GanssReqGenericData_vc50ext */
static int hf_rrc_ganssSatId;                     /* INTEGER_0_63 */
static int hf_rrc_dopplerZeroOrder;               /* INTEGER_M2048_2047 */
static int hf_rrc_extraDoppler;                   /* ExtraDoppler */
static int hf_rrc_codePhase_01;                   /* INTEGER_0_1023 */
static int hf_rrc_integerCodePhase_01;            /* INTEGER_0_127 */
static int hf_rrc_codePhaseSearchWindow_bit_string;  /* BIT_STRING_SIZE_5 */
static int hf_rrc_azimuthandElevation;            /* AzimuthAndElevation */
static int hf_rrc_azimuthandElevation_01;         /* AzimuthAndElevation_r10 */
static int hf_rrc_extraDopplerExtension;          /* ExtraDopplerExtension */
static int hf_rrc_GANSSSatelliteInformationList_item;  /* GANSSSatelliteInformation */
static int hf_rrc_GANSSSatelliteInformationList_va40ext_item;  /* GANSSSatelliteInformation_va40ext */
static int hf_rrc_GANSSSatelliteInformationList_r10_item;  /* GANSSSatelliteInformation_r10 */
static int hf_rrc_GANSSSatelliteInformationList_vc50ext_item;  /* GANSSSatelliteInformation_vc50ext */
static int hf_rrc_GANSSSatelliteInformationList_r12_item;  /* GANSSSatelliteInformation_r12 */
static int hf_rrc_GANSSTimeModelsList_item;       /* UE_Positioning_GANSS_TimeModel */
static int hf_rrc_GANSSTimeModelsList_va40ext_item;  /* UE_Positioning_GANSS_TimeModel_va40ext */
static int hf_rrc_GANSSTimeModelsList_r10_item;   /* UE_Positioning_GANSS_TimeModel_r10 */
static int hf_rrc_bdsAlmToa;                      /* BIT_STRING_SIZE_8 */
static int hf_rrc_bdsAlmSqrtA;                    /* BIT_STRING_SIZE_24 */
static int hf_rrc_bdsAlmE;                        /* BIT_STRING_SIZE_17 */
static int hf_rrc_bdsAlmW;                        /* BIT_STRING_SIZE_24 */
static int hf_rrc_bdsAlmM0;                       /* BIT_STRING_SIZE_24 */
static int hf_rrc_bdsAlmOmega0;                   /* BIT_STRING_SIZE_24 */
static int hf_rrc_bdsAlmOmegaDot;                 /* BIT_STRING_SIZE_17 */
static int hf_rrc_bdsAlmDeltaI;                   /* BIT_STRING_SIZE_16 */
static int hf_rrc_bdsAlmA0;                       /* BIT_STRING_SIZE_11 */
static int hf_rrc_bdsAlmA1;                       /* BIT_STRING_SIZE_11 */
static int hf_rrc_bdsSvHealth;                    /* BIT_STRING_SIZE_9 */
static int hf_rrc_gloAlmNA;                       /* BIT_STRING_SIZE_11 */
static int hf_rrc_gloAlmnA;                       /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloAlmHA;                       /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloAlmLambdaA;                  /* BIT_STRING_SIZE_21 */
static int hf_rrc_gloAlmTlambdaA;                 /* BIT_STRING_SIZE_21 */
static int hf_rrc_gloAlmDeltaIA;                  /* BIT_STRING_SIZE_18 */
static int hf_rrc_gloAkmDeltaTA;                  /* BIT_STRING_SIZE_22 */
static int hf_rrc_gloAlmDeltaTdotA;               /* BIT_STRING_SIZE_7 */
static int hf_rrc_gloAlmEpsilonA;                 /* BIT_STRING_SIZE_15 */
static int hf_rrc_gloAlmOmegaA;                   /* BIT_STRING_SIZE_16 */
static int hf_rrc_gloAlmTauA;                     /* BIT_STRING_SIZE_10 */
static int hf_rrc_gloAlmCA;                       /* BIT_STRING_SIZE_1 */
static int hf_rrc_gloAlmMA;                       /* BIT_STRING_SIZE_2 */
static int hf_rrc_svId;                           /* INTEGER_0_63 */
static int hf_rrc_ganss_alm_e;                    /* BIT_STRING_SIZE_11 */
static int hf_rrc_ganss_delta_I_alm;              /* BIT_STRING_SIZE_11 */
static int hf_rrc_ganss_omegadot_alm;             /* BIT_STRING_SIZE_11 */
static int hf_rrc_ganss_svstatusINAV_alm;         /* BIT_STRING_SIZE_4 */
static int hf_rrc_ganss_svstatusFNAV_alm;         /* BIT_STRING_SIZE_2 */
static int hf_rrc_ganss_delta_a_sqrt_alm;         /* BIT_STRING_SIZE_13 */
static int hf_rrc_ganss_omegazero_alm;            /* BIT_STRING_SIZE_16 */
static int hf_rrc_ganss_m_zero_alm;               /* BIT_STRING_SIZE_16 */
static int hf_rrc_ganss_omega_alm;                /* BIT_STRING_SIZE_16 */
static int hf_rrc_ganss_af_zero_alm;              /* BIT_STRING_SIZE_16 */
static int hf_rrc_ganss_af_one_alm;               /* BIT_STRING_SIZE_13 */
static int hf_rrc_midiAlmE;                       /* BIT_STRING_SIZE_11 */
static int hf_rrc_midiAlmDeltaI;                  /* BIT_STRING_SIZE_11 */
static int hf_rrc_midiAlmOmegaDot;                /* BIT_STRING_SIZE_11 */
static int hf_rrc_midiAlmSqrtA;                   /* BIT_STRING_SIZE_17 */
static int hf_rrc_midiAlmOmega0;                  /* BIT_STRING_SIZE_16 */
static int hf_rrc_midiAlmOmega;                   /* BIT_STRING_SIZE_16 */
static int hf_rrc_midiAlmMo;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_midiAlmaf0;                     /* BIT_STRING_SIZE_11 */
static int hf_rrc_midiAlmaf1;                     /* BIT_STRING_SIZE_10 */
static int hf_rrc_midiAlmL1Health;                /* BIT_STRING_SIZE_1 */
static int hf_rrc_midiAlmL2Health;                /* BIT_STRING_SIZE_1 */
static int hf_rrc_midiAlmL5Health;                /* BIT_STRING_SIZE_1 */
static int hf_rrc_navAlmE;                        /* BIT_STRING_SIZE_16 */
static int hf_rrc_navAlmDeltaI;                   /* BIT_STRING_SIZE_16 */
static int hf_rrc_navAlmOMEGADOT;                 /* BIT_STRING_SIZE_16 */
static int hf_rrc_navAlmSVHealth;                 /* BIT_STRING_SIZE_8 */
static int hf_rrc_navAlmSqrtA;                    /* BIT_STRING_SIZE_24 */
static int hf_rrc_navAlmOMEGAo;                   /* BIT_STRING_SIZE_24 */
static int hf_rrc_navAlmOmega;                    /* BIT_STRING_SIZE_24 */
static int hf_rrc_navAlmMo;                       /* BIT_STRING_SIZE_24 */
static int hf_rrc_navAlmaf0;                      /* BIT_STRING_SIZE_11 */
static int hf_rrc_navAlmaf1;                      /* BIT_STRING_SIZE_11 */
static int hf_rrc_redAlmDeltaA;                   /* BIT_STRING_SIZE_8 */
static int hf_rrc_redAlmOmega0;                   /* BIT_STRING_SIZE_7 */
static int hf_rrc_redAlmPhi0;                     /* BIT_STRING_SIZE_7 */
static int hf_rrc_redAlmL1Health;                 /* BIT_STRING_SIZE_1 */
static int hf_rrc_redAlmL2Health;                 /* BIT_STRING_SIZE_1 */
static int hf_rrc_redAlmL5Health;                 /* BIT_STRING_SIZE_1 */
static int hf_rrc_sbasAlmDataID;                  /* BIT_STRING_SIZE_2 */
static int hf_rrc_sbasAlmHealth;                  /* BIT_STRING_SIZE_8 */
static int hf_rrc_sbasAlmXg;                      /* BIT_STRING_SIZE_15 */
static int hf_rrc_sbasAlmYg;                      /* BIT_STRING_SIZE_15 */
static int hf_rrc_sbasAlmZg;                      /* BIT_STRING_SIZE_9 */
static int hf_rrc_sbasAlmXgdot;                   /* BIT_STRING_SIZE_3 */
static int hf_rrc_sbasAlmYgDot;                   /* BIT_STRING_SIZE_3 */
static int hf_rrc_sbasAlmZgDot;                   /* BIT_STRING_SIZE_4 */
static int hf_rrc_sbasAlmTo;                      /* BIT_STRING_SIZE_11 */
static int hf_rrc_GANSS_SAT_Info_Almanac_BDSkpList_item;  /* GANSS_SAT_Info_Almanac_BDSkp */
static int hf_rrc_GANSS_SAT_Info_Almanac_GLOkpList_item;  /* GANSS_SAT_Info_Almanac_GLOkp */
static int hf_rrc_GANSS_SAT_Info_Almanac_KpList_item;  /* GANSS_SAT_Info_Almanac_Kp */
static int hf_rrc_GANSS_SAT_Info_Almanac_MIDIkpList_item;  /* GANSS_SAT_Info_Almanac_MIDIkp */
static int hf_rrc_GANSS_SAT_Info_Almanac_NAVkpList_item;  /* GANSS_SAT_Info_Almanac_NAVkp */
static int hf_rrc_GANSS_SAT_Info_Almanac_REDkpList_item;  /* GANSS_SAT_Info_Almanac_REDkp */
static int hf_rrc_GANSS_SAT_Info_Almanac_SBASecefList_item;  /* GANSS_SAT_Info_Almanac_SBASecef */
static int hf_rrc_svHealth;                       /* BIT_STRING_SIZE_6 */
static int hf_rrc_iod;                            /* BIT_STRING_SIZE_11 */
static int hf_rrc_ganssClockModel;                /* UE_Positioning_GANSS_AddClockModels */
static int hf_rrc_ganssOrbitModel;                /* UE_Positioning_GANSS_AddOrbitModels */
static int hf_rrc_ganssClockModel_01;             /* UE_Positioning_GANSS_AddClockModels_r12 */
static int hf_rrc_ganssOrbitModel_01;             /* UE_Positioning_GANSS_AddOrbitModels_r12 */
static int hf_rrc_ganssClockModel_02;             /* UE_Positioning_GANSS_AddClockModels_vc50ext */
static int hf_rrc_ganssOrbitModel_02;             /* UE_Positioning_GANSS_AddOrbitModels_vc50ext */
static int hf_rrc_svHealth_01;                    /* BIT_STRING_SIZE_9 */
static int hf_rrc_iod_01;                         /* BIT_STRING_SIZE_10 */
static int hf_rrc_ganssClockModel_03;             /* UE_Positioning_GANSS_ClockModel */
static int hf_rrc_ganssOrbitModel_03;             /* UE_Positioning_GANSS_OrbitModel */
static int hf_rrc_Ganss_Sat_Info_AddNavList_item;  /* Ganss_Sat_Info_AddNav */
static int hf_rrc_Ganss_Sat_Info_AddNavList_r12_item;  /* Ganss_Sat_Info_AddNav_r12 */
static int hf_rrc_Ganss_Sat_Info_AddNavList_vc50ext_item;  /* Ganss_Sat_Info_AddNav_vc50ext */
static int hf_rrc_Ganss_Sat_Info_NavList_item;    /* Ganss_Sat_Info_Nav */
static int hf_rrc_storm_flag_one;                 /* BOOLEAN */
static int hf_rrc_storm_flag_two;                 /* BOOLEAN */
static int hf_rrc_storm_flag_three;               /* BOOLEAN */
static int hf_rrc_storm_flag_four;                /* BOOLEAN */
static int hf_rrc_storm_flag_five;                /* BOOLEAN */
static int hf_rrc_gloTau;                         /* BIT_STRING_SIZE_22 */
static int hf_rrc_gloGamma;                       /* BIT_STRING_SIZE_11 */
static int hf_rrc_gloDeltaTau;                    /* BIT_STRING_SIZE_5 */
static int hf_rrc_satelliteID;                    /* INTEGER_0_63 */
static int hf_rrc_c_N0;                           /* INTEGER_0_63 */
static int hf_rrc_doppler_01;                     /* INTEGER_M32768_32768 */
static int hf_rrc_wholeGPS_Chips;                 /* INTEGER_0_1022 */
static int hf_rrc_fractionalGPS_Chips;            /* INTEGER_0_1023 */
static int hf_rrc_multipathIndicator_01;          /* MultipathIndicator */
static int hf_rrc_pseudorangeRMS_Error;           /* INTEGER_0_63 */
static int hf_rrc_GPS_MeasurementParamList_item;  /* GPS_MeasurementParam */
static int hf_rrc_startingARFCN;                  /* BCCH_ARFCN */
static int hf_rrc_bandIndicator;                  /* T_bandIndicator */
static int hf_rrc_followingARFCNs;                /* T_followingARFCNs */
static int hf_rrc_explicitListOfARFCNs;           /* SEQUENCE_SIZE_0_31_OF_BCCH_ARFCN */
static int hf_rrc_explicitListOfARFCNs_item;      /* BCCH_ARFCN */
static int hf_rrc_equallySpacedARFCNs;            /* T_equallySpacedARFCNs */
static int hf_rrc_arfcn_Spacing;                  /* INTEGER_1_8 */
static int hf_rrc_numberOfFollowingARFCNs;        /* INTEGER_0_31 */
static int hf_rrc_variableBitMapOfARFCNs;         /* OCTET_STRING_SIZE_1_16 */
static int hf_rrc_continuousRangeOfARFCNs;        /* T_continuousRangeOfARFCNs */
static int hf_rrc_endingARFCN;                    /* BCCH_ARFCN */
static int hf_rrc_gsm_CarrierRSSI;                /* GSM_CarrierRSSI */
static int hf_rrc_dummy_int_46_173SIBb_TypeAnd;   /* INTEGER_46_173 */
static int hf_rrc_observedTimeDifferenceToGSM;    /* ObservedTimeDifferenceToGSM */
static int hf_rrc_GSM_MeasuredResultsList_item;   /* GSM_MeasuredResults */
static int hf_rrc_tlm_Message;                    /* BIT_STRING_SIZE_14 */
static int hf_rrc_tlm_Reserved;                   /* BIT_STRING_SIZE_2 */
static int hf_rrc_alert;                          /* BOOLEAN */
static int hf_rrc_antiSpoof;                      /* BOOLEAN */
static int hf_rrc_GPS_TOW_AssistList_item;        /* GPS_TOW_Assist */
static int hf_rrc_gsmCellGroup;                   /* GSM_CellGroup */
static int hf_rrc_qRxLevMinGSM;                   /* INTEGER_M58_M13 */
static int hf_rrc_GSM_PriorityInfoList_item;      /* GSM_PriorityInfo */
static int hf_rrc_penaltyTime;                    /* PenaltyTime_RSCP */
static int hf_rrc_penaltyTime_01;                 /* PenaltyTime_ECN0 */
static int hf_rrc_hcs_PRIO;                       /* HCS_PRIO */
static int hf_rrc_q_HCS;                          /* Q_HCS */
static int hf_rrc_hcs_CellReselectInformation;    /* HCS_CellReselectInformation_RSCP */
static int hf_rrc_hcs_CellReselectInformation_01;  /* HCS_CellReselectInformation_ECN0 */
static int hf_rrc_t_CR_Max;                       /* T_CRMax */
static int hf_rrc_bearing;                        /* INTEGER_0_359 */
static int hf_rrc_horizontalSpeed;                /* INTEGER_0_2047 */
static int hf_rrc_verticalSpeedDirection;         /* T_verticalSpeedDirection */
static int hf_rrc_verticalSpeed;                  /* INTEGER_0_255 */
static int hf_rrc_horizontalSpeedUncertainty;     /* INTEGER_0_255 */
static int hf_rrc_verticalSpeedDirection_01;      /* T_verticalSpeedDirection_01 */
static int hf_rrc_horizontalUncertaintySpeed;     /* INTEGER_0_255 */
static int hf_rrc_verticalUncertaintySpeed;       /* INTEGER_0_255 */
static int hf_rrc_k_01;                           /* INTEGER_2_3 */
static int hf_rrc_nonFreqRelatedEventResults;     /* CellMeasurementEventResults */
static int hf_rrc_nonFreqRelatedEventResults_01;  /* CellMeasurementEventResults_LCR_r4 */
static int hf_rrc_removedInterFreqCellList;       /* RemovedInterFreqCellList */
static int hf_rrc_newInterFreqCellList_02;        /* NewInterFreqCellList */
static int hf_rrc_cellsForInterFreqMeasList;      /* CellsForInterFreqMeasList */
static int hf_rrc_newInterFreqCellList_03;        /* NewInterFreqCellList_r4 */
static int hf_rrc_newInterFreqCellList_04;        /* NewInterFreqCellList_r8 */
static int hf_rrc_newInterFreqCellList_05;        /* NewInterFreqCellList_r9 */
static int hf_rrc_cSGInterFreqCellInfoList;       /* CSGInterFreqCellInfoList */
static int hf_rrc_interFreqSIAcquisition;         /* InterFreqSIAcquisition */
static int hf_rrc_newInterFreqCellList_06;        /* NewInterFreqCellList_r10 */
static int hf_rrc_removedInterFreqCellList_01;    /* RemovedInterFreqCellList_r12 */
static int hf_rrc_newInterFreqCellList_07;        /* NewInterFreqCellList_r12 */
static int hf_rrc_cellsForInterFreqMeasList_01;   /* CellsForInterFreqMeasList_r12 */
static int hf_rrc_rmp_Frequency_List;             /* RMP_Frequency_List */
static int hf_rrc_modeSpecificInfo_119;           /* T_modeSpecificInfo_119 */
static int hf_rrc_fdd_169;                        /* T_fdd_163 */
static int hf_rrc_primaryScramblingCode_01;       /* PrimaryCPICH_Info */
static int hf_rrc_newInterFreqCellList_08;        /* NewInterFreqCellSI_List_RSCP */
static int hf_rrc_newInterFreqCellList_09;        /* NewInterFreqCellSI_List_ECN0 */
static int hf_rrc_newInterFreqCellList_10;        /* NewInterFreqCellSI_List_HCS_RSCP */
static int hf_rrc_newInterFreqCellList_11;        /* NewInterFreqCellSI_List_HCS_ECN0 */
static int hf_rrc_newInterFreqCellList_12;        /* NewInterFreqCellSI_List_RSCP_LCR_r4 */
static int hf_rrc_newInterFreqCellList_13;        /* NewInterFreqCellSI_List_ECN0_LCR_r4 */
static int hf_rrc_newInterFreqCellList_14;        /* NewInterFreqCellSI_List_HCS_RSCP_LCR_r4 */
static int hf_rrc_newInterFreqCellList_15;        /* NewInterFreqCellSI_List_HCS_ECN0_LCR_r4 */
static int hf_rrc_InterFreqCellList_item;         /* InterFreqCell */
static int hf_rrc_InterFreqCellList_LCR_r4_ext_item;  /* InterFreqCell_LCR_r4 */
static int hf_rrc_InterFreqCellMeasuredResultsList_item;  /* CellMeasuredResults */
static int hf_rrc_InterFreqCellMeasuredResultsList_v920ext_item;  /* CellMeasuredResults_v920ext */
static int hf_rrc_InterFreqCellMeasuredResultsList_vc50ext_item;  /* CellMeasuredResults_vc50ext */
static int hf_rrc_event2a;                        /* Event2a */
static int hf_rrc_event2b;                        /* Event2b */
static int hf_rrc_event2c;                        /* Event2c */
static int hf_rrc_event2d;                        /* Event2d */
static int hf_rrc_event2e;                        /* Event2e */
static int hf_rrc_event2f;                        /* Event2f */
static int hf_rrc_event2a_01;                     /* Event2a_r6 */
static int hf_rrc_event2b_01;                     /* Event2b_r6 */
static int hf_rrc_event2c_01;                     /* Event2c_r6 */
static int hf_rrc_event2d_01;                     /* Event2d_r6 */
static int hf_rrc_event2e_01;                     /* Event2e_r6 */
static int hf_rrc_event2f_01;                     /* Event2f_r6 */
static int hf_rrc_event2a_02;                     /* Event2a_r10 */
static int hf_rrc_event2b_02;                     /* Event2b_r10 */
static int hf_rrc_event2c_02;                     /* Event2c_r10 */
static int hf_rrc_event2d_02;                     /* Event2d_r10 */
static int hf_rrc_event2e_02;                     /* Event2e_r10 */
static int hf_rrc_event2f_02;                     /* Event2f_r10 */
static int hf_rrc_event2a_03;                     /* Event2a_r11 */
static int hf_rrc_event2b_03;                     /* Event2b_r11 */
static int hf_rrc_event2c_03;                     /* Event2c_r11 */
static int hf_rrc_event2e_03;                     /* Event2e_r11 */
static int hf_rrc_event2g;                        /* Event2g */
static int hf_rrc_InterFreqEventList_item;        /* InterFreqEvent */
static int hf_rrc_InterFreqEventList_r6_item;     /* InterFreqEvent_r6 */
static int hf_rrc_InterFreqEventList_r10_item;    /* InterFreqEvent_r10 */
static int hf_rrc_InterFreqEventList_r11_item;    /* InterFreqEvent_r11 */
static int hf_rrc_InterFreqEventList_r12_item;    /* InterFreqEvent_r12 */
static int hf_rrc_InterFrequencyMeasuredResultsList_v590ext_item;  /* DeltaRSCPPerCell */
static int hf_rrc_threholdUsedFrequency_delta;    /* DeltaRSCP */
static int hf_rrc_threholdNonUsedFrequency_deltaList;  /* ThreholdNonUsedFrequency_deltaList */
static int hf_rrc_Inter_FreqEventCriteriaList_v590ext_item;  /* Inter_FreqEventCriteria_v590ext */
static int hf_rrc_Intra_FreqEventCriteriaList_v590ext_item;  /* DeltaRSCP */
static int hf_rrc_IntraFrequencyMeasuredResultsList_v590ext_item;  /* DeltaRSCPPerCell */
static int hf_rrc_eventID_01;                     /* EventIDInterFreq */
static int hf_rrc_interFreqCellList;              /* InterFreqCellList */
static int hf_rrc_detectedSetTrigger;             /* T_detectedSetTrigger */
static int hf_rrc_interFreqCellList_01;           /* InterFreqCellList_LCR_r4_ext */
static int hf_rrc_reportingCriteria;              /* T_reportingCriteria */
static int hf_rrc_intraFreqReportingCriteria_02;  /* T_intraFreqReportingCriteria */
static int hf_rrc_intraFreqMeasQuantity;          /* IntraFreqMeasQuantity */
static int hf_rrc_interFreqReportingCriteria;     /* T_interFreqReportingCriteria */
static int hf_rrc_modeSpecificInfo_120;           /* T_modeSpecificInfo_120 */
static int hf_rrc_fdd_170;                        /* T_fdd_164 */
static int hf_rrc_freqQualityEstimateQuantity_FDD;  /* FreqQualityEstimateQuantity_FDD */
static int hf_rrc_tdd_117;                        /* T_tdd_109 */
static int hf_rrc_freqQualityEstimateQuantity_TDD;  /* FreqQualityEstimateQuantity_TDD */
static int hf_rrc_utra_CarrierRSSI;               /* UTRA_CarrierRSSI */
static int hf_rrc_interFreqCellMeasuredResultsList;  /* InterFreqCellMeasuredResultsList */
static int hf_rrc_interFreqCellMeasuredResultsList_01;  /* InterFreqCellMeasuredResultsList_v920ext */
static int hf_rrc_interFreqCellMeasuredResultsList_02;  /* InterFreqCellMeasuredResultsList_vc50ext */
static int hf_rrc_InterFreqMeasuredResultsList_item;  /* InterFreqMeasuredResults */
static int hf_rrc_InterFreqMeasuredResultsList_v920ext_item;  /* InterFreqMeasuredResults_v920ext */
static int hf_rrc_InterFreqMeasuredResultsList_vc50ext_item;  /* InterFreqMeasuredResults_vc50ext */
static int hf_rrc_interFreqCellInfoSI_List;       /* InterFreqCellInfoSI_List_RSCP */
static int hf_rrc_interFreqCellInfoSI_List_01;    /* InterFreqCellInfoSI_List_ECN0 */
static int hf_rrc_interFreqCellInfoSI_List_02;    /* InterFreqCellInfoSI_List_HCS_RSCP */
static int hf_rrc_interFreqCellInfoSI_List_03;    /* InterFreqCellInfoSI_List_HCS_ECN0 */
static int hf_rrc_interFreqCellInfoSI_List_04;    /* InterFreqCellInfoSI_List_RSCP_LCR */
static int hf_rrc_interFreqCellInfoSI_List_05;    /* InterFreqCellInfoSI_List_ECN0_LCR */
static int hf_rrc_interFreqCellInfoSI_List_06;    /* InterFreqCellInfoSI_List_HCS_RSCP_LCR */
static int hf_rrc_interFreqCellInfoSI_List_07;    /* InterFreqCellInfoSI_List_HCS_ECN0_LCR */
static int hf_rrc_InterFreqRACHRepCellsList_item;  /* InterFreqCellID */
static int hf_rrc_InterFreqRACHRepCellsList_r12_item;  /* InterFreqCellID_r12 */
static int hf_rrc_modeSpecificInfo_121;           /* T_modeSpecificInfo_121 */
static int hf_rrc_fdd_171;                        /* T_fdd_165 */
static int hf_rrc_interFreqRepQuantityRACH_FDD;   /* InterFreqRepQuantityRACH_FDD */
static int hf_rrc_tdd_118;                        /* T_tdd_110 */
static int hf_rrc_interFreqRepQuantityRACH_TDDList;  /* InterFreqRepQuantityRACH_TDDList */
static int hf_rrc_interFreqRACHReportingThreshold;  /* Threshold */
static int hf_rrc_maxReportedCellsOnRACHinterFreq;  /* MaxReportedCellsOnRACHinterFreq */
static int hf_rrc_modeSpecificInfo_122;           /* T_modeSpecificInfo_122 */
static int hf_rrc_fdd_172;                        /* T_fdd_166 */
static int hf_rrc_tdd_119;                        /* T_tdd_111 */
static int hf_rrc_InterFreqExclude_listedCellsList_r12_item;  /* InterFreqExclude_listedCells_r12 */
static int hf_rrc_excludedCellInfoList;           /* CellInfoListToBeExcluded */
static int hf_rrc_interFreqReportingCriteria_01;  /* InterFreqReportingCriteria */
static int hf_rrc_periodicalReportingCriteria_01;  /* PeriodicalWithReportingCellStatus */
static int hf_rrc_noReporting;                    /* ReportingCellStatusOpt */
static int hf_rrc_intraFreqReportingCriteria_03;  /* IntraFreqReportingCriteria_r4 */
static int hf_rrc_intraFreqReportingCriteria_04;  /* IntraFreqReportingCriteria_r6 */
static int hf_rrc_interFreqReportingCriteria_02;  /* InterFreqReportingCriteria_r6 */
static int hf_rrc_intraFreqReportingCriteria_05;  /* IntraFreqReportingCriteria_r7 */
static int hf_rrc_intraFreqReportingCriteria_06;  /* IntraFreqReportingCriteria_r9 */
static int hf_rrc_interFreqReportingCriteria_03;  /* InterFreqReportingCriteria_r10 */
static int hf_rrc_periodicalReportingCriteria_02;  /* PeriodicalWithReportingCellStatus_r10 */
static int hf_rrc_noReporting_01;                 /* ReportingCellStatusOpt_r10 */
static int hf_rrc_intraFreqReportingCriteria_07;  /* IntraFreqReportingCriteria_r11 */
static int hf_rrc_interFreqReportingCriteria_04;  /* InterFreqReportingCriteria_r11 */
static int hf_rrc_interFreqReportingCriteria_05;  /* InterFreqReportingCriteria_r12 */
static int hf_rrc_interFreqEventList;             /* InterFreqEventList */
static int hf_rrc_interFreqEventList_01;          /* InterFreqEventList_r6 */
static int hf_rrc_interFreqEventList_02;          /* InterFreqEventList_r10 */
static int hf_rrc_interFreqEventList_03;          /* InterFreqEventList_r11 */
static int hf_rrc_interFreqEventList_04;          /* InterFreqEventList_r12 */
static int hf_rrc_interFreqExclude_listedCellsList;  /* InterFreqExclude_listedCellsList_r12 */
static int hf_rrc_utra_Carrier_RSSI;              /* BOOLEAN */
static int hf_rrc_frequencyQualityEstimate;       /* BOOLEAN */
static int hf_rrc_nonFreqRelatedQuantities;       /* CellReportingQuantities */
static int hf_rrc_InterFreqRepQuantityRACH_TDDList_item;  /* InterFreqRepQuantityRACH_TDD */
static int hf_rrc_interFreqCellInfoList;          /* InterFreqCellInfoList */
static int hf_rrc_interFreqMeasQuantity;          /* InterFreqMeasQuantity */
static int hf_rrc_interFreqReportingQuantity;     /* InterFreqReportingQuantity */
static int hf_rrc_measurementValidity;            /* MeasurementValidity */
static int hf_rrc_interFreqSetUpdate;             /* UE_AutonomousUpdateMode */
static int hf_rrc_reportCriteria_02;              /* InterFreqReportCriteria */
static int hf_rrc_interFreqCellInfoList_01;       /* InterFreqCellInfoList_r4 */
static int hf_rrc_reportCriteria_03;              /* InterFreqReportCriteria_r4 */
static int hf_rrc_reportCriteria_04;              /* InterFreqReportCriteria_r6 */
static int hf_rrc_reportCriteria_05;              /* InterFreqReportCriteria_r7 */
static int hf_rrc_interFreqCellInfoList_02;       /* InterFreqCellInfoList_r8 */
static int hf_rrc_adjacentFrequencyIndex;         /* INTEGER_0_31 */
static int hf_rrc_interFreqCellInfoList_03;       /* InterFreqCellInfoList_r9 */
static int hf_rrc_interBandFrequencyIndex;        /* INTEGER_0_31 */
static int hf_rrc_reportCriteria_06;              /* InterFreqReportCriteria_r9 */
static int hf_rrc_interFreqCellInfoList_04;       /* InterFreqCellInfoList_r10 */
static int hf_rrc_freqIndexListForEnhancedMeas;   /* FreqIndexListForEnhancedMeas */
static int hf_rrc_reportCriteria_07;              /* InterFreqReportCriteria_r10 */
static int hf_rrc_reportCriteria_08;              /* InterFreqReportCriteria_r11 */
static int hf_rrc_interFreqCellInfoList_05;       /* InterFreqCellInfoList_r12 */
static int hf_rrc_adjacentFrequencyIndex_01;      /* INTEGER_0_79 */
static int hf_rrc_interBandFrequencyIndex_01;     /* INTEGER_0_79 */
static int hf_rrc_freqIndexListForEnhancedMeas_01;  /* FreqIndexListForEnhancedMeas_r12 */
static int hf_rrc_reportCriteria_09;              /* InterFreqReportCriteria_r12 */
static int hf_rrc_technologySpecificInfo;         /* T_technologySpecificInfo */
static int hf_rrc_gsm_10;                         /* T_gsm_10 */
static int hf_rrc_bsic;                           /* BSIC */
static int hf_rrc_bcch_ARFCN;                     /* BCCH_ARFCN */
static int hf_rrc_ncMode;                         /* NC_Mode */
static int hf_rrc_is_2000;                        /* NULL */
static int hf_rrc_removedInterRATCellList;        /* RemovedInterRATCellList */
static int hf_rrc_newInterRATCellList;            /* NewInterRATCellList */
static int hf_rrc_cellsForInterRATMeasList;       /* CellsForInterRATMeasList */
static int hf_rrc_newInterRATCellList_01;         /* NewInterRATCellList_B */
static int hf_rrc_interRATCellInfoIndication_r6;  /* InterRATCellInfoIndication */
static int hf_rrc_event3a;                        /* Event3a */
static int hf_rrc_event3b;                        /* Event3b */
static int hf_rrc_event3c;                        /* Event3c */
static int hf_rrc_event3d;                        /* Event3d */
static int hf_rrc_event3a_01;                     /* Event3a_r12 */
static int hf_rrc_event3b_01;                     /* Event3b_r12 */
static int hf_rrc_event3c_01;                     /* Event3c_r12 */
static int hf_rrc_InterRATEventList_item;         /* InterRATEvent */
static int hf_rrc_InterRATEventList_r12_item;     /* InterRATEvent_r12 */
static int hf_rrc_cellToReportList;               /* CellToReportList */
static int hf_rrc_rat_01;                         /* InterRATInfo */
static int hf_rrc_gsm_TargetCellInfoList;         /* GSM_TargetCellInfoList */
static int hf_rrc_gsm_11;                         /* NULL */
static int hf_rrc_eutra_02;                       /* T_eutra_01 */
static int hf_rrc_eutra_TargetFreqInfoList_01;    /* EUTRA_TargetFreqInfoList */
static int hf_rrc_measQuantityUTRAN_QualityEstimate;  /* IntraFreqMeasQuantity */
static int hf_rrc_ratSpecificInfo;                /* T_ratSpecificInfo */
static int hf_rrc_gsm_12;                         /* T_gsm_11 */
static int hf_rrc_measurementQuantity_02;         /* MeasurementQuantityGSM */
static int hf_rrc_bsic_VerificationRequired;      /* BSIC_VerificationRequired */
static int hf_rrc_is_2000_01;                     /* T_is_2000 */
static int hf_rrc_tadd_EcIo;                      /* INTEGER_0_63 */
static int hf_rrc_tcomp_EcIo;                     /* INTEGER_0_15 */
static int hf_rrc_softSlope;                      /* INTEGER_0_63 */
static int hf_rrc_addIntercept;                   /* INTEGER_0_63 */
static int hf_rrc_ratSpecificInfo_01;             /* T_ratSpecificInfo_01 */
static int hf_rrc_gsm_13;                         /* T_gsm_12 */
static int hf_rrc_is_2000_02;                     /* T_is_2000_01 */
static int hf_rrc_e_UTRA_01;                      /* T_e_UTRA_01 */
static int hf_rrc_measurementQuantity_03;         /* MeasurementQuantityEUTRA */
static int hf_rrc_gsm_14;                         /* GSM_MeasuredResultsList */
static int hf_rrc_InterRATMeasuredResultsList_item;  /* InterRATMeasuredResults */
static int hf_rrc_interRATCellInfoList;           /* InterRATCellInfoList */
static int hf_rrc_interRATMeasQuantity;           /* InterRATMeasQuantity */
static int hf_rrc_interRATReportingQuantity;      /* InterRATReportingQuantity */
static int hf_rrc_reportCriteria_10;              /* InterRATReportCriteria */
static int hf_rrc_interRATCellInfoList_01;        /* InterRATCellInfoList_r4 */
static int hf_rrc_interRATCellInfoList_02;        /* InterRATCellInfoList_r6 */
static int hf_rrc_interRATMeasurementObjects;     /* T_interRATMeasurementObjects */
static int hf_rrc_eutra_FrequencyList;            /* EUTRA_FrequencyList */
static int hf_rrc_interRATMeasQuantity_01;        /* InterRATMeasQuantity_r8 */
static int hf_rrc_interRATReportingQuantity_01;   /* InterRATReportingQuantity_r8 */
static int hf_rrc_idleIntervalInfo;               /* IdleIntervalInfo */
static int hf_rrc_interRATMeasurementObjects_01;  /* T_interRATMeasurementObjects_01 */
static int hf_rrc_eutra_FrequencyList_01;         /* EUTRA_FrequencyList_r9 */
static int hf_rrc_interRATMeasurementObjects_02;  /* T_interRATMeasurementObjects_02 */
static int hf_rrc_eutra_FrequencyList_02;         /* EUTRA_FrequencyList_r11 */
static int hf_rrc_interRATMeasurementObjects_03;  /* T_interRATMeasurementObjects_03 */
static int hf_rrc_eutra_FrequencyList_03;         /* EUTRA_FrequencyList_r12 */
static int hf_rrc_reportCriteria_11;              /* InterRATReportCriteria_r12 */
static int hf_rrc_interRATCellInfoList_03;        /* InterRATCellInfoList_B */
static int hf_rrc_interRATReportingCriteria;      /* InterRATReportingCriteria */
static int hf_rrc_interRATReportingCriteria_01;   /* InterRATReportingCriteria_r12 */
static int hf_rrc_interRATEventList;              /* InterRATEventList */
static int hf_rrc_interRATEventList_01;           /* InterRATEventList_r12 */
static int hf_rrc_utran_EstimatedQuality;         /* BOOLEAN */
static int hf_rrc_ratSpecificInfo_02;             /* T_ratSpecificInfo_02 */
static int hf_rrc_gsm_15;                         /* T_gsm_13 */
static int hf_rrc_gsm_Carrier_RSSI;               /* BOOLEAN */
static int hf_rrc_ratSpecificInfo_03;             /* T_ratSpecificInfo_03 */
static int hf_rrc_gsm_16;                         /* T_gsm_14 */
static int hf_rrc_eutra_03;                       /* T_eutra_02 */
static int hf_rrc_reportingQuantity;              /* T_reportingQuantity */
static int hf_rrc_removedIntraFreqCellList;       /* RemovedIntraFreqCellList */
static int hf_rrc_newIntraFreqCellList_01;        /* NewIntraFreqCellList */
static int hf_rrc_cellsForIntraFreqMeasList;      /* CellsForIntraFreqMeasList */
static int hf_rrc_newIntraFreqCellList_02;        /* NewIntraFreqCellList_r4 */
static int hf_rrc_removedIntraFreqCellList_01;    /* RemovedIntraFreqCellListOnSecULFreq */
static int hf_rrc_newIntraFreqCellList_03;        /* NewIntraFreqCellListOnSecULFreq */
static int hf_rrc_cellsForIntraFreqMeasList_01;   /* CellsForIntraFreqMeasListOnSecULFreq */
static int hf_rrc_intraFreqCellInfoListOnSecULFreq;  /* IntraFreqCellInfoListInfoOnSecULFreq */
static int hf_rrc_newIntraFreqCellList_04;        /* NewIntraFreqCellList_r9 */
static int hf_rrc_cSGIntraFreqCellInfoList;       /* CSGIntraFreqCellInfoList */
static int hf_rrc_intraFreqSIAcquisition;         /* IntraFreqSIAcquisition */
static int hf_rrc_newIntraFreqCellList_05;        /* NewIntraFreqCellList_r10 */
static int hf_rrc_IntraFreqSIAcquisitionInfo_item;  /* PrimaryCPICH_Info */
static int hf_rrc_modeSpecificInfo_123;           /* T_modeSpecificInfo_123 */
static int hf_rrc_fdd_173;                        /* T_fdd_167 */
static int hf_rrc_intraFreqSIAcquisitionInfo;     /* IntraFreqSIAcquisitionInfo */
static int hf_rrc_newIntraFreqCellList_06;        /* NewIntraFreqCellSI_List_RSCP */
static int hf_rrc_newIntraFreqCellList_07;        /* NewIntraFreqCellSI_List_ECN0 */
static int hf_rrc_newIntraFreqCellList_08;        /* NewIntraFreqCellSI_List_HCS_RSCP */
static int hf_rrc_newIntraFreqCellList_09;        /* NewIntraFreqCellSI_List_HCS_ECN0 */
static int hf_rrc_newIntraFreqCellList_10;        /* NewIntraFreqCellSI_List_RSCP_LCR_r4 */
static int hf_rrc_newIntraFreqCellList_11;        /* NewIntraFreqCellSI_List_ECN0_LCR_r4 */
static int hf_rrc_newIntraFreqCellList_12;        /* NewIntraFreqCellSI_List_HCS_RSCP_LCR_r4 */
static int hf_rrc_newIntraFreqCellList_13;        /* NewIntraFreqCellSI_List_HCS_ECN0_LCR_r4 */
static int hf_rrc_e1a;                            /* Event1a */
static int hf_rrc_e1b;                            /* Event1b */
static int hf_rrc_e1c;                            /* Event1c */
static int hf_rrc_e1d;                            /* NULL */
static int hf_rrc_e1e;                            /* Event1e */
static int hf_rrc_e1f;                            /* Event1f */
static int hf_rrc_e1g;                            /* NULL */
static int hf_rrc_e1h;                            /* ThresholdUsedFrequency */
static int hf_rrc_e1i;                            /* ThresholdUsedFrequency */
static int hf_rrc_e1a_01;                         /* Event1a_r4 */
static int hf_rrc_e1b_01;                         /* Event1b_r4 */
static int hf_rrc_e1a_02;                         /* Event1a_LCR_r4 */
static int hf_rrc_e1b_02;                         /* Event1b_LCR_r4 */
static int hf_rrc_e1d_01;                         /* Event1d */
static int hf_rrc_e1e_01;                         /* Event1e_r6 */
static int hf_rrc_e1f_01;                         /* Event1f_r6 */
static int hf_rrc_e1h_01;                         /* ThresholdUsedFrequency_r6 */
static int hf_rrc_e1i_01;                         /* ThresholdUsedFrequency_r6 */
static int hf_rrc_e1j;                            /* Event1j_r6 */
static int hf_rrc_e1b_03;                         /* Event1b_r7 */
static int hf_rrc_e1a_03;                         /* Event1a_OnSecUlFreq_r9 */
static int hf_rrc_e1b_04;                         /* Event1b_OnSecUlFreq_r9 */
static int hf_rrc_event;                          /* IntraFreqEvent */
static int hf_rrc_event_01;                       /* IntraFreqEvent_r4 */
static int hf_rrc_event_02;                       /* IntraFreqEvent_LCR_r4 */
static int hf_rrc_event_03;                       /* IntraFreqEvent_r6 */
static int hf_rrc_event_04;                       /* IntraFreqEvent_r7 */
static int hf_rrc_event_05;                       /* IntraFreqEventOnSecULFreq */
static int hf_rrc_IntraFreqEventCriteriaList_item;  /* IntraFreqEventCriteria */
static int hf_rrc_IntraFreqEventCriteriaList_r4_item;  /* IntraFreqEventCriteria_r4 */
static int hf_rrc_IntraFreqEventCriteriaList_LCR_r4_item;  /* IntraFreqEventCriteria_LCR_r4 */
static int hf_rrc_IntraFreqEventCriteriaList_r6_item;  /* IntraFreqEventCriteria_r6 */
static int hf_rrc_IntraFreqEventCriteriaList_r7_item;  /* IntraFreqEventCriteria_r7 */
static int hf_rrc_intraFreqEventCriteria;         /* SEQUENCE_SIZE_1_maxMeasEventOnSecULFreq_OF_IntraFreqEventCriteriaOnSecULFreq */
static int hf_rrc_intraFreqEventCriteria_item;    /* IntraFreqEventCriteriaOnSecULFreq */
static int hf_rrc_eventID_02;                     /* EventIDIntraFreq */
static int hf_rrc_cellMeasurementEventResults;    /* CellMeasurementEventResults */
static int hf_rrc_cellMeasurementEventResultsOnSecUlFreq;  /* CellMeasurementEventResultsOnSecUlFreq */
static int hf_rrc_modeSpecificInfo_124;           /* T_modeSpecificInfo_124 */
static int hf_rrc_fdd_174;                        /* T_fdd_168 */
static int hf_rrc_intraFreqMeasQuantity_FDD;      /* IntraFreqMeasQuantity_FDD */
static int hf_rrc_tdd_120;                        /* T_tdd_112 */
static int hf_rrc_intraFreqMeasQuantity_TDDList;  /* IntraFreqMeasQuantity_TDDList */
static int hf_rrc_IntraFreqMeasQuantity_TDDList_item;  /* IntraFreqMeasQuantity_TDD */
static int hf_rrc_IntraFreqMeasQuantity_TDD_sib3List_item;  /* IntraFreqMeasQuantity_TDD_sib3List_item */
static int hf_rrc_IntraFreqMeasuredResultsList_item;  /* CellMeasuredResults */
static int hf_rrc_IntraFreqMeasuredResultsList_v920ext_item;  /* CellMeasuredResults_v920ext */
static int hf_rrc_IntraFreqMeasuredResultsList_vc50ext_item;  /* CellMeasuredResults_vc50ext */
static int hf_rrc_intraFreqMeasurementID;         /* MeasurementIdentity */
static int hf_rrc_intraFreqCellInfoSI_List;       /* IntraFreqCellInfoSI_List_RSCP */
static int hf_rrc_intraFreqReportingQuantityForRACH;  /* IntraFreqReportingQuantityForRACH */
static int hf_rrc_maxReportedCellsOnRACH;         /* MaxReportedCellsOnRACH */
static int hf_rrc_reportingInfoForCellDCH;        /* ReportingInfoForCellDCH */
static int hf_rrc_intraFreqCellInfoSI_List_01;    /* IntraFreqCellInfoSI_List_ECN0 */
static int hf_rrc_intraFreqCellInfoSI_List_02;    /* IntraFreqCellInfoSI_List_HCS_RSCP */
static int hf_rrc_intraFreqCellInfoSI_List_03;    /* IntraFreqCellInfoSI_List_HCS_ECN0 */
static int hf_rrc_intraFreqCellInfoSI_List_04;    /* IntraFreqCellInfoSI_List_RSCP_LCR_r4 */
static int hf_rrc_reportingInfoForCellDCH_01;     /* ReportingInfoForCellDCH_LCR_r4 */
static int hf_rrc_intraFreqCellInfoSI_List_05;    /* IntraFreqCellInfoSI_List_ECN0_LCR_r4 */
static int hf_rrc_intraFreqCellInfoSI_List_06;    /* IntraFreqCellInfoSI_List_HCS_RSCP_LCR_r4 */
static int hf_rrc_intraFreqCellInfoSI_List_07;    /* IntraFreqCellInfoSI_List_HCS_ECN0_LCR_r4 */
static int hf_rrc_eventCriteriaList;              /* IntraFreqEventCriteriaList */
static int hf_rrc_eventCriteriaList_01;           /* IntraFreqEventCriteriaList_r4 */
static int hf_rrc_eventCriteriaList_02;           /* IntraFreqEventCriteriaList_LCR_r4 */
static int hf_rrc_eventCriteriaList_03;           /* IntraFreqEventCriteriaList_r6 */
static int hf_rrc_eventCriteriaList_04;           /* IntraFreqEventCriteriaList_r7 */
static int hf_rrc_eventCriteriaListOnSecULFreq;   /* IntraFreqEventCriteriaListOnSecULFreq */
static int hf_rrc_activeSetReportingQuantities;   /* CellReportingQuantities */
static int hf_rrc_monitoredSetReportingQuantities;  /* CellReportingQuantities */
static int hf_rrc_detectedSetReportingQuantities;  /* CellReportingQuantities */
static int hf_rrc_sfn_SFN_OTD_Type;               /* SFN_SFN_OTD_Type */
static int hf_rrc_modeSpecificInfo_125;           /* T_modeSpecificInfo_125 */
static int hf_rrc_fdd_175;                        /* T_fdd_169 */
static int hf_rrc_intraFreqRepQuantityRACH_FDD;   /* IntraFreqRepQuantityRACH_FDD */
static int hf_rrc_tdd_121;                        /* T_tdd_113 */
static int hf_rrc_intraFreqRepQuantityRACH_TDDList;  /* IntraFreqRepQuantityRACH_TDDList */
static int hf_rrc_intraFreqRepQuantityRACH_FDD_01;  /* T_intraFreqRepQuantityRACH_FDD */
static int hf_rrc_IntraFreqRepQuantityRACH_TDDList_item;  /* IntraFreqRepQuantityRACH_TDD */
static int hf_rrc_intraFreqCellInfoList;          /* IntraFreqCellInfoList */
static int hf_rrc_intraFreqReportingQuantity;     /* IntraFreqReportingQuantity */
static int hf_rrc_reportCriteria_12;              /* IntraFreqReportCriteria */
static int hf_rrc_intraFreqCellInfoList_01;       /* IntraFreqCellInfoList_r4 */
static int hf_rrc_reportCriteria_13;              /* IntraFreqReportCriteria_r4 */
static int hf_rrc_reportCriteria_14;              /* IntraFreqReportCriteria_r6 */
static int hf_rrc_reportCriteria_15;              /* IntraFreqReportCriteria_r7 */
static int hf_rrc_intraFreqCellInfoList_02;       /* IntraFreqCellInfoList_r9 */
static int hf_rrc_intraFreqCellInfoListOnSecULFreq_01;  /* IntraFreqCellInfoListOnSecULFreq */
static int hf_rrc_reportCriteria_16;              /* IntraFreqReportCriteria_r9 */
static int hf_rrc_intraFreqCellInfoList_03;       /* IntraFreqCellInfoList_r10 */
static int hf_rrc_reportCriteria_17;              /* IntraFreqReportCriteria_r11 */
static int hf_rrc_IntraFrequencyMeasuredResultsListOnSecULFreq_item;  /* CellMeasuredResults_r9 */
static int hf_rrc_IntraFrequencyMeasuredResultsListOnSecULFreq_vc50ext_item;  /* CellMeasuredResults_vc50ext */
static int hf_rrc_loggingAbsoluteThreshold;       /* LoggingAbsoluteThreshold */
static int hf_rrc_loggingRelativeThreshold;       /* LoggingRelativeThreshold */
static int hf_rrc_loggingDuration;                /* T_loggingDuration */
static int hf_rrc_intraUTRAANR;                   /* IntraUTRAANR */
static int hf_rrc_interRATANRforEUTRAIndicator;   /* T_interRATANRforEUTRAIndicator */
static int hf_rrc_interRATANRforGSMIndicator;     /* T_interRATANRforGSMIndicator */
static int hf_rrc_LoggedANRReportInfoList_item;   /* LoggedANRReportInfo */
static int hf_rrc_LoggedANRReportInfoList_vb50ext_item;  /* LoggedANRReportInfo_vb50ext */
static int hf_rrc_servingCell;                    /* CellIdentity */
static int hf_rrc_loggedCellInfo;                 /* LoggedCellInfo */
static int hf_rrc_loggedCellInfo_01;              /* LoggedCellInfo_vb50ext */
static int hf_rrc_loggedUTRACellInfo;             /* LoggedUTRACellInfo */
static int hf_rrc_loggedEUTRACellInfo;            /* LoggedEUTRACellInfo */
static int hf_rrc_loggedGSMCellInfo;              /* LoggedGSMCellInfo */
static int hf_rrc_loggedEUTRACellInfo_01;         /* LoggedEUTRACellInfo_vb50ext */
static int hf_rrc_loggedConnectionEstablishmentFailureAccessInfo_FDD;  /* LoggedConnectionEstablishmentFailureAccessInfo_FDD */
static int hf_rrc_loggedMeasFailedCellMeas;       /* LoggedMeasServingCellMeas_FDD */
static int hf_rrc_loggedMeasIntrafreqNeighbourList;  /* LoggedMeasIntrafreqNeighbourList_FDD */
static int hf_rrc_loggedMeasInterfreqList;        /* LoggedMeasInterfreqList_FDD */
static int hf_rrc_loggedMeasInterRATNeighbourMeas;  /* LoggedMeasInterRATNeighbourMeas_vb50ext */
static int hf_rrc_loggedConnectionEstablishmentFailureLocationInfo;  /* LoggedConnectionEstablishmentFailureLocationInfo */
static int hf_rrc_loggedMeasInterRATNeighbourMeas_01;  /* LoggedMeasInterRATNeighbourMeas_vc50ext */
static int hf_rrc_loggedMeasInterRATNeighbourMeas_02;  /* LoggedMeasInterRATNeighbourMeas_r11 */
static int hf_rrc_loggedConnectionEstablishmentFailureAccessInfo_TDD;  /* LoggedConnectionEstablishmentFailureAccessInfo_TDD */
static int hf_rrc_loggedMeasFailedCellMeas_01;    /* LoggedMeasServingCellMeas_TDD128 */
static int hf_rrc_loggedMeasIntrafreqNeighbourList_01;  /* LoggedMeasIntrafreqNeighbourMeasList_TDD128 */
static int hf_rrc_loggedMeasInterfreqList_01;     /* LoggedMeasInterfreqList_TDD128 */
static int hf_rrc_numberOfRRCMsgTransmitted;      /* INTEGER_0_8 */
static int hf_rrc_fpachReceived;                  /* BOOLEAN */
static int hf_rrc_e_RUCCHFailure;                 /* BOOLEAN */
static int hf_rrc_location;                       /* T_location */
static int hf_rrc_ellipsoidPoint;                 /* EllipsoidPoint */
static int hf_rrc_ellipsoidPointUncertCircle;     /* EllipsoidPointUncertCircle */
static int hf_rrc_ellipsoidPointUncertEllipse;    /* EllipsoidPointUncertEllipse */
static int hf_rrc_ellipsoidPointAltitude;         /* EllipsoidPointAltitude */
static int hf_rrc_ellipsoidPointAltitudeEllipse;  /* EllipsoidPointAltitudeEllipsoide */
static int hf_rrc_horizontalVelocity;             /* HorizontalVelocity */
static int hf_rrc_timeSinceFailure;               /* INTEGER_0_172800 */
static int hf_rrc_modeSpecificInfo_126;           /* T_modeSpecificInfo_126 */
static int hf_rrc_fdd_176;                        /* T_fdd_170 */
static int hf_rrc_loggedConnectionEstablishmentFailureInfo;  /* LoggedConnectionEstablishmentFailureInfo_FDD */
static int hf_rrc_tdd_122;                        /* T_tdd_114 */
static int hf_rrc_loggedConnectionEstablishmentFailureInfo_01;  /* LoggedConnectionEstablishmentFailureInfo_TDD128 */
static int hf_rrc_modeSpecificInfo_127;           /* T_modeSpecificInfo_127 */
static int hf_rrc_fdd_177;                        /* T_fdd_171 */
static int hf_rrc_loggedConnectionEstablishmentFailureInfo_02;  /* LoggedConnectionEstablishmentFailureInfo_FDD_r11 */
static int hf_rrc_tdd_123;                        /* T_tdd_115 */
static int hf_rrc_loggedConnectionEstablishmentFailureInfo_03;  /* LoggedConnectionEstablishmentFailureInfo_TDD128_r11 */
static int hf_rrc_modeSpecificInfo_128;           /* T_modeSpecificInfo_128 */
static int hf_rrc_fdd_178;                        /* T_fdd_172 */
static int hf_rrc_loggedConnectionEstablishmentFailureInfo_04;  /* LoggedConnectionEstablishmentFailureInfo_FDD_vc50ext */
static int hf_rrc_tdd_124;                        /* T_tdd_116 */
static int hf_rrc_loggedConnectionEstablishmentFailureInfo_05;  /* LoggedConnectionEstablishmentFailureInfo_TDD128_vc50ext */
static int hf_rrc_eutraCellIdentity;              /* BIT_STRING_SIZE_28 */
static int hf_rrc_gsmCellIdentity;                /* BIT_STRING_SIZE_16 */
static int hf_rrc_bandIndicator_01;               /* Frequency_Band */
static int hf_rrc_absoluteTimeInfo;               /* BIT_STRING_SIZE_48 */
static int hf_rrc_loggingDuration_01;             /* T_loggingDuration_01 */
static int hf_rrc_loggingInterval;                /* T_loggingInterval */
static int hf_rrc_traceReference;                 /* TraceReference */
static int hf_rrc_traceRecordingSession;          /* TraceRecordingSession */
static int hf_rrc_tce_Id;                         /* TCE_Id */
static int hf_rrc_areaConfiguration;              /* T_areaConfiguration */
static int hf_rrc_cellIDList;                     /* SEQUENCE_SIZE_1_32_OF_CellIdentity */
static int hf_rrc_cellIDList_item;                /* CellIdentity */
static int hf_rrc_locationAreaList;               /* SEQUENCE_SIZE_1_8_OF_LAI */
static int hf_rrc_locationAreaList_item;          /* LAI */
static int hf_rrc_routingAreaList;                /* SEQUENCE_SIZE_1_8_OF_RAI */
static int hf_rrc_routingAreaList_item;           /* RAI */
static int hf_rrc_loggingDuration_02;             /* T_loggingDuration_02 */
static int hf_rrc_loggingInterval_01;             /* T_loggingInterval_01 */
static int hf_rrc_plmnList;                       /* PlmnList */
static int hf_rrc_areaConfiguration_01;           /* T_areaConfiguration_01 */
static int hf_rrc_cellIDList_01;                  /* SEQUENCE_SIZE_1_32_OF_CellIDListItem */
static int hf_rrc_cellIDList_item_01;             /* CellIDListItem */
static int hf_rrc_LoggedMeasInterfreqList_FDD_item;  /* LoggedMeasInterfreqInfo_FDD */
static int hf_rrc_loggedMeasInterfreqNeighbourList;  /* SEQUENCE_SIZE_1_maxnumLoggedMeas_OF_LoggedMeasNeighbourInfo_FDD */
static int hf_rrc_loggedMeasInterfreqNeighbourList_item;  /* LoggedMeasNeighbourInfo_FDD */
static int hf_rrc_loggedMeasInterfreqNeighbourList_01;  /* LoggedMeasInterfreqNeighbourList_TDD128 */
static int hf_rrc_loggedMeasEUTRAFreqList;        /* LoggedMeasEUTRAFreqList */
static int hf_rrc_loggedMeasGSMNeighbourCellsList;  /* LoggedMeasGSMNeighbourCellsList */
static int hf_rrc_loggedMeasEUTRAFreqList_01;     /* LoggedMeasEUTRAFreqList_vb50ext */
static int hf_rrc_loggedMeasEUTRAFreqList_02;     /* LoggedMeasEUTRAFreqList_vc50ext */
static int hf_rrc_loggedMeasEUTRAFreqList_03;     /* LoggedMeasEUTRAFreqList_r11 */
static int hf_rrc_LoggedMeasIntrafreqNeighbourList_FDD_item;  /* LoggedMeasNeighbourInfo_FDD */
static int hf_rrc_LoggedMeasIntrafreqNeighbourMeasList_TDD128_item;  /* LoggedMeasNeighbourMeas_TDD128 */
static int hf_rrc_LoggedMeasGSMNeighbourCellsList_item;  /* LoggedMeasGSMNeighbourCellsinfo */
static int hf_rrc_LoggedMeasEUTRAFreqList_item;   /* LoggedMeasEUTRAFreqInfo */
static int hf_rrc_LoggedMeasEUTRAFreqList_vb50ext_item;  /* LoggedMeasEUTRAFreqInfo_vb50ext */
static int hf_rrc_LoggedMeasEUTRAFreqList_r11_item;  /* LoggedMeasEUTRAFreqInfo_r11 */
static int hf_rrc_LoggedMeasEUTRAFreqList_vc50ext_item;  /* LoggedMeasEUTRAFreqInfo_vc50ext */
static int hf_rrc_loggedMeasEUTRAFreqNeighbourInfoList;  /* SEQUENCE_SIZE_1_maxnumLoggedMeas_OF_LoggedMeasEUTRAFreqNeighbourInfo */
static int hf_rrc_loggedMeasEUTRAFreqNeighbourInfoList_item;  /* LoggedMeasEUTRAFreqNeighbourInfo */
static int hf_rrc_earfcn_03;                      /* EARFCNRange */
static int hf_rrc_rSRQType;                       /* RsrqType */
static int hf_rrc_loggedMeasEUTRAFreqNeighbourInfoList_01;  /* SEQUENCE_SIZE_1_maxnumLoggedMeas_OF_LoggedMeasEUTRAFreqNeighbourInfo_vc50ext */
static int hf_rrc_loggedMeasEUTRAFreqNeighbourInfoList_item_01;  /* LoggedMeasEUTRAFreqNeighbourInfo_vc50ext */
static int hf_rrc_rSRQExtension;                  /* INTEGER_M30_46 */
static int hf_rrc_relativeTimeStamp;              /* INTEGER_0_7200 */
static int hf_rrc_loggedMeasServingCellMeas;      /* LoggedMeasServingCellMeas_FDD */
static int hf_rrc_loggedMeasInterRATNeighbourMeas_03;  /* LoggedMeasInterRATNeighbourMeas */
static int hf_rrc_loggedMeasLocationInfo;         /* LoggedMeasLocationInfo */
static int hf_rrc_loggedMeasServingCellMeas_01;   /* LoggedMeasServingCellMeas_FDD_vb50ext */
static int hf_rrc_loggedMeasLocationInfo_01;      /* LoggedMeasLocationInfo_vb50ext */
static int hf_rrc_loggedMeasServingCellMeas_02;   /* LoggedMeasServingCellMeas_TDD128 */
static int hf_rrc_loggedMeasServingCellMeas_03;   /* LoggedMeasServingCellMeas_TDD128_vb50ext */
static int hf_rrc_LoggedMeasInfoList_FDD_item;    /* LoggedMeasInfo_FDD */
static int hf_rrc_LoggedMeasInfoList_FDD_vb50ext_item;  /* LoggedMeasInfo_FDD_vb50ext */
static int hf_rrc_LoggedMeasInfoList_FDD_vc50ext_item;  /* LoggedMeasInfo_FDD_vc50ext */
static int hf_rrc_LoggedMeasInfoList_TDD128_item;  /* LoggedMeasInfo_TDD128 */
static int hf_rrc_LoggedMeasInfoList_TDD128_vb50ext_item;  /* LoggedMeasInfo_TDD128_vb50ext */
static int hf_rrc_LoggedMeasInfoList_TDD128_vc50ext_item;  /* LoggedMeasInfo_TDD128_vc50ext */
static int hf_rrc_modeSpecificInfo_129;           /* T_modeSpecificInfo_129 */
static int hf_rrc_fdd_179;                        /* T_fdd_173 */
static int hf_rrc_loggedMeasInfoList;             /* LoggedMeasInfoList_FDD */
static int hf_rrc_tdd_125;                        /* T_tdd_117 */
static int hf_rrc_loggedMeasInfoList_01;          /* LoggedMeasInfoList_TDD128 */
static int hf_rrc_modeSpecificInfo_130;           /* T_modeSpecificInfo_130 */
static int hf_rrc_fdd_180;                        /* T_fdd_174 */
static int hf_rrc_loggedMeasInfoList_02;          /* LoggedMeasInfoList_FDD_vb50ext */
static int hf_rrc_tdd_126;                        /* T_tdd_118 */
static int hf_rrc_loggedMeasInfoList_03;          /* LoggedMeasInfoList_TDD128_vb50ext */
static int hf_rrc_modeSpecificInfo_131;           /* T_modeSpecificInfo_131 */
static int hf_rrc_fdd_181;                        /* T_fdd_175 */
static int hf_rrc_loggedMeasInfoList_04;          /* LoggedMeasInfoList_FDD_vc50ext */
static int hf_rrc_tdd_127;                        /* T_tdd_119 */
static int hf_rrc_loggedMeasInfoList_05;          /* LoggedMeasInfoList_TDD128_vc50ext */
static int hf_rrc_LoggedMeasInterfreqList_TDD128_item;  /* LoggedMeasInterfreqInfo_TDD128 */
static int hf_rrc_LoggedMeasInterfreqNeighbourList_TDD128_item;  /* LoggedMeasNeighbourMeas_TDD128 */
static int hf_rrc_loggedMeasInfoList_06;          /* LoggedMeasInfoList */
static int hf_rrc_loggedMeasAvailable_07;         /* T_loggedMeasAvailable_07 */
static int hf_rrc_loggedMeasInfoList_07;          /* LoggedMeasInfoList_vb50ext */
static int hf_rrc_loggedMeasInfoList_08;          /* LoggedMeasInfoList_vc50ext */
static int hf_rrc_plmnIdentity;                   /* PLMN_Identity */
static int hf_rrc_rscpforANR;                     /* RSCPforANR */
static int hf_rrc_ec_N0forANR;                    /* Ec_N0forANR */
static int hf_rrc_toe_nav;                        /* BIT_STRING_SIZE_14 */
static int hf_rrc_ganss_omega_nav;                /* BIT_STRING_SIZE_32 */
static int hf_rrc_delta_n_nav;                    /* BIT_STRING_SIZE_16 */
static int hf_rrc_m_zero_nav;                     /* BIT_STRING_SIZE_32 */
static int hf_rrc_omegadot_nav;                   /* BIT_STRING_SIZE_24 */
static int hf_rrc_ganss_e_nav;                    /* BIT_STRING_SIZE_32 */
static int hf_rrc_idot_nav;                       /* BIT_STRING_SIZE_14 */
static int hf_rrc_a_sqrt_nav;                     /* BIT_STRING_SIZE_32 */
static int hf_rrc_i_zero_nav;                     /* BIT_STRING_SIZE_32 */
static int hf_rrc_omega_zero_nav;                 /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_rs_nav;                       /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_is_nav;                       /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_us_nav;                       /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_rc_nav;                       /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_ic_nav;                       /* BIT_STRING_SIZE_16 */
static int hf_rrc_c_uc_nav;                       /* BIT_STRING_SIZE_16 */
static int hf_rrc_intraFreqMeasuredResultsList;   /* IntraFreqMeasuredResultsList */
static int hf_rrc_interFreqMeasuredResultsList;   /* InterFreqMeasuredResultsList */
static int hf_rrc_interRATMeasuredResultsList;    /* InterRATMeasuredResultsList */
static int hf_rrc_trafficVolumeMeasuredResultsList;  /* TrafficVolumeMeasuredResultsList */
static int hf_rrc_qualityMeasuredResults;         /* QualityMeasuredResults */
static int hf_rrc_ue_InternalMeasuredResults;     /* UE_InternalMeasuredResults */
static int hf_rrc_ue_positioning_MeasuredResults;  /* UE_Positioning_MeasuredResults */
static int hf_rrc_intraFreqMeasuredResultsList_01;  /* IntraFrequencyMeasuredResultsListOnSecULFreq */
static int hf_rrc_intraFreqMeasuredResultsList_02;  /* IntraFrequencyMeasuredResultsListOnSecULFreq_vc50ext */
static int hf_rrc_ue_positioning_MeasuredResults_v390ext;  /* UE_Positioning_MeasuredResults_v390ext */
static int hf_rrc_intraFrequencyMeasuredResultsList;  /* IntraFrequencyMeasuredResultsList_v590ext */
static int hf_rrc_interFrequencyMeasuredResultsList;  /* InterFrequencyMeasuredResultsList_v590ext */
static int hf_rrc_ueInternalMeasuredResults;      /* UE_InternalMeasuredResults_v770ext */
static int hf_rrc_ue_positioning_MeasuredResults_01;  /* UE_Positioning_MeasuredResults_v770ext */
static int hf_rrc_ue_positioning_MeasuredResults_02;  /* UE_Positioning_MeasuredResults_v860ext */
static int hf_rrc_ue_positioning_MeasuredResults_03;  /* UE_Positioning_MeasuredResults_vd20ext */
static int hf_rrc_ueInternalMeasuredResults_01;   /* UE_InternalMeasuredResults_ve30ext */
static int hf_rrc_MeasuredResultsList_v920ext_item;  /* MeasuredResults_v920ext */
static int hf_rrc_MeasuredResultsList_vc50ext_item;  /* MeasuredResults_vc50ext */
static int hf_rrc_MeasuredResultsListOnSecUlFreq_item;  /* MeasuredResultsOnSecUlFreq */
static int hf_rrc_MeasuredResultsListOnSecUlFreq_vc50ext_item;  /* MeasuredResultsOnSecUlFreq_vc50ext */
static int hf_rrc_intraFreqMeasuredResultsList_03;  /* IntraFreqMeasuredResultsList_v920ext */
static int hf_rrc_interFreqMeasuredResultsList_01;  /* InterFreqMeasuredResultsList_v920ext */
static int hf_rrc_intraFreqMeasuredResultsList_04;  /* IntraFreqMeasuredResultsList_vc50ext */
static int hf_rrc_interFreqMeasuredResultsList_02;  /* InterFreqMeasuredResultsList_vc50ext */
static int hf_rrc_ue_positioning_MeasuredResults_04;  /* UE_Positioning_MeasuredResults_vc50ext */
static int hf_rrc_ue_InternalMeasuredResults_01;  /* UE_InternalMeasuredResults_LCR_r4 */
static int hf_rrc_ue_positioniing_MeasuredResults;  /* UE_Positioning_MeasuredResults */
static int hf_rrc_MeasuredResultsList_item;       /* MeasuredResults */
static int hf_rrc_MeasuredResultsList_LCR_r4_ext_item;  /* MeasuredResults_LCR_r4 */
static int hf_rrc_MeasuredResultsList_v770xet_item;  /* MeasuredResultsList_v770xet_item */
static int hf_rrc_MeasuredResultsList_v860ext_item;  /* MeasuredResultsList_v860ext_item */
static int hf_rrc_currentCell;                    /* T_currentCell */
static int hf_rrc_modeSpecificInfo_132;           /* T_modeSpecificInfo_132 */
static int hf_rrc_fdd_182;                        /* T_fdd_176 */
static int hf_rrc_measurementQuantity_04;         /* T_measurementQuantity_02 */
static int hf_rrc_cpich_Ec_N0_RSCP;               /* CPICH_Ec_N0_RSCP */
static int hf_rrc_tdd_128;                        /* T_tdd_120 */
static int hf_rrc_timeslotISCP;                   /* TimeslotISCP_List */
static int hf_rrc_monitoredCells;                 /* MonitoredCellRACH_List */
static int hf_rrc_currentCell_DeltaRSCP;          /* DeltaRSCPPerCell */
static int hf_rrc_monitoredCellRACH_List_v7g0ext;  /* MonitoredCellRACH_List_v7g0ext */
static int hf_rrc_MonitoredCellRACH_List_v7g0ext_item;  /* DeltaRSCPPerCell */
static int hf_rrc_currentCell_01;                 /* T_currentCell_01 */
static int hf_rrc_measurementQuantity_05;         /* T_measurementQuantity_03 */
static int hf_rrc_measuredResultsUsedFreq;        /* MonitoredCellRACH_ListFDD_r11 */
static int hf_rrc_measuredResultsNonUsedFreq;     /* MeasuredResultsOnRACHinterFreq */
static int hf_rrc_measuredResultsEUTRAFreq;       /* MeasuredResultsOnRACH_EUTRAFreq */
static int hf_rrc_interFreqCellIndication_SIB11;  /* INTEGER_0_1 */
static int hf_rrc_interFreqCellIndication_SIB12;  /* INTEGER_0_1 */
static int hf_rrc_interFreqRACHRepCellsList;      /* InterFreqRACHRepCellsList */
static int hf_rrc_interFreqRACHRepCellsList_01;   /* InterFreqRACHRepCellsList_r12 */
static int hf_rrc_measuredResultsNonUsedFreq_01;  /* MeasuredResultsOnRACHinterFreq_vc50ext */
static int hf_rrc_measuredResultsEUTRAFreq_01;    /* MeasuredResultsOnRACH_EUTRAFreq_vc50ext */
static int hf_rrc_eutraFrequencyIndication_SIB19;  /* INTEGER_0_1 */
static int hf_rrc_setup;                          /* MeasurementType */
static int hf_rrc_modify_01;                      /* T_modify_01 */
static int hf_rrc_measurementType;                /* MeasurementType */
static int hf_rrc_setup_01;                       /* MeasurementType_r4 */
static int hf_rrc_modify_02;                      /* T_modify_02 */
static int hf_rrc_measurementType_01;             /* MeasurementType_r4 */
static int hf_rrc_setup_02;                       /* MeasurementType_r6 */
static int hf_rrc_modify_03;                      /* T_modify_03 */
static int hf_rrc_measurementType_02;             /* MeasurementType_r6 */
static int hf_rrc_setup_03;                       /* MeasurementType_r7 */
static int hf_rrc_modify_04;                      /* T_modify_04 */
static int hf_rrc_measurementType_03;             /* MeasurementType_r7 */
static int hf_rrc_setup_04;                       /* MeasurementType_r8 */
static int hf_rrc_modify_05;                      /* T_modify_05 */
static int hf_rrc_measurementType_04;             /* MeasurementType_r8 */
static int hf_rrc_setup_05;                       /* MeasurementType_r9 */
static int hf_rrc_modify_06;                      /* T_modify_06 */
static int hf_rrc_measurementType_05;             /* MeasurementType_r9 */
static int hf_rrc_setup_06;                       /* MeasurementType_r10 */
static int hf_rrc_modify_07;                      /* T_modify_07 */
static int hf_rrc_measurementType_06;             /* MeasurementType_r10 */
static int hf_rrc_setup_07;                       /* MeasurementType_r11 */
static int hf_rrc_modify_08;                      /* T_modify_08 */
static int hf_rrc_measurementType_07;             /* MeasurementType_r11 */
static int hf_rrc_setup_08;                       /* MeasurementType_r12 */
static int hf_rrc_modify_09;                      /* T_modify_09 */
static int hf_rrc_measurementType_08;             /* MeasurementType_r12 */
static int hf_rrc_releaseAll;                     /* NULL */
static int hf_rrc_releaseSome;                    /* MeasurementsToRelease */
static int hf_rrc_setup_09;                       /* MeasurementType_r13 */
static int hf_rrc_modify_10;                      /* T_modify_10 */
static int hf_rrc_measurementType_09;             /* MeasurementType_r13 */
static int hf_rrc_setup_10;                       /* MeasurementType_r14 */
static int hf_rrc_modify_11;                      /* T_modify_11 */
static int hf_rrc_measurementType_10;             /* MeasurementType_r14 */
static int hf_rrc_setup_11;                       /* MeasurementType_r15 */
static int hf_rrc_modify_12;                      /* T_modify_12 */
static int hf_rrc_measurementType_11;             /* MeasurementType_r15 */
static int hf_rrc_use_of_HCS;                     /* T_use_of_HCS */
static int hf_rrc_hcs_not_used;                   /* T_hcs_not_used */
static int hf_rrc_cellSelectQualityMeasure_01;    /* T_cellSelectQualityMeasure_01 */
static int hf_rrc_cpich_RSCP_02;                  /* T_cpich_RSCP */
static int hf_rrc_intraFreqMeasurementSysInfo;    /* IntraFreqMeasurementSysInfo_RSCP */
static int hf_rrc_interFreqMeasurementSysInfo;    /* InterFreqMeasurementSysInfo_RSCP */
static int hf_rrc_cpich_Ec_N0_02;                 /* T_cpich_Ec_N0_01 */
static int hf_rrc_intraFreqMeasurementSysInfo_01;  /* IntraFreqMeasurementSysInfo_ECN0 */
static int hf_rrc_interFreqMeasurementSysInfo_01;  /* InterFreqMeasurementSysInfo_ECN0 */
static int hf_rrc_interRATMeasurementSysInfo;     /* InterRATMeasurementSysInfo_B */
static int hf_rrc_hcs_used;                       /* T_hcs_used */
static int hf_rrc_cellSelectQualityMeasure_02;    /* T_cellSelectQualityMeasure_02 */
static int hf_rrc_cpich_RSCP_03;                  /* T_cpich_RSCP_01 */
static int hf_rrc_intraFreqMeasurementSysInfo_02;  /* IntraFreqMeasurementSysInfo_HCS_RSCP */
static int hf_rrc_interFreqMeasurementSysInfo_02;  /* InterFreqMeasurementSysInfo_HCS_RSCP */
static int hf_rrc_cpich_Ec_N0_03;                 /* T_cpich_Ec_N0_02 */
static int hf_rrc_intraFreqMeasurementSysInfo_03;  /* IntraFreqMeasurementSysInfo_HCS_ECN0 */
static int hf_rrc_interFreqMeasurementSysInfo_03;  /* InterFreqMeasurementSysInfo_HCS_ECN0 */
static int hf_rrc_interRATMeasurementSysInfo_01;  /* InterRATMeasurementSysInfo */
static int hf_rrc_trafficVolumeMeasSysInfo;       /* TrafficVolumeMeasSysInfo */
static int hf_rrc_uE_InternalMeasurementSysInfo;  /* UE_InternalMeasurementSysInfo */
static int hf_rrc_intraFreqReportingQuantityForRACH_01;  /* IntraFreqReportingQuantityForRACH_vc50ext */
static int hf_rrc_use_of_HCS_01;                  /* T_use_of_HCS_01 */
static int hf_rrc_hcs_not_used_01;                /* T_hcs_not_used_01 */
static int hf_rrc_cellSelectQualityMeasure_03;    /* T_cellSelectQualityMeasure_03 */
static int hf_rrc_cpich_RSCP_04;                  /* T_cpich_RSCP_02 */
static int hf_rrc_cpich_Ec_N0_04;                 /* T_cpich_Ec_N0_03 */
static int hf_rrc_hcs_used_01;                    /* T_hcs_used_01 */
static int hf_rrc_cellSelectQualityMeasure_04;    /* T_cellSelectQualityMeasure_04 */
static int hf_rrc_cpich_RSCP_05;                  /* T_cpich_RSCP_03 */
static int hf_rrc_cpich_Ec_N0_05;                 /* T_cpich_Ec_N0_04 */
static int hf_rrc_newIntraFrequencyCellInfoListAddon_r5;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newIntraFrequencyCellInfoListAddon_r5_item;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterFrequencyCellInfoListAddon_r5;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterFrequencyCellInfoListAddon_r5_item;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterRATCellInfoListAddon_r5;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterRATCellInfoListAddon_r5_item;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_use_of_HCS_02;                  /* T_use_of_HCS_02 */
static int hf_rrc_hcs_not_used_02;                /* T_hcs_not_used_02 */
static int hf_rrc_cellSelectQualityMeasure_05;    /* T_cellSelectQualityMeasure_05 */
static int hf_rrc_cpich_RSCP_06;                  /* T_cpich_RSCP_04 */
static int hf_rrc_newInterFreqCellList_16;        /* NewInterFreqCellSI_List_RSCP_ext */
static int hf_rrc_cpich_Ec_N0_06;                 /* T_cpich_Ec_N0_05 */
static int hf_rrc_newInterFreqCellList_17;        /* NewInterFreqCellSI_List_ECN0_ext */
static int hf_rrc_hcs_used_02;                    /* T_hcs_used_02 */
static int hf_rrc_cellSelectQualityMeasure_06;    /* T_cellSelectQualityMeasure_06 */
static int hf_rrc_cpich_RSCP_07;                  /* T_cpich_RSCP_05 */
static int hf_rrc_newInterFreqCellList_18;        /* NewInterFreqCellSI_List_HCS_RSCP_ext */
static int hf_rrc_cpich_Ec_N0_07;                 /* T_cpich_Ec_N0_06 */
static int hf_rrc_newInterFreqCellList_19;        /* NewInterFreqCellSI_List_HCS_ECN0_ext */
static int hf_rrc_use_of_HCS_03;                  /* T_use_of_HCS_03 */
static int hf_rrc_hcs_not_used_03;                /* T_hcs_not_used_03 */
static int hf_rrc_cellSelectQualityMeasure_07;    /* T_cellSelectQualityMeasure_07 */
static int hf_rrc_cpich_RSCP_08;                  /* T_cpich_RSCP_06 */
static int hf_rrc_cpich_Ec_N0_08;                 /* T_cpich_Ec_N0_07 */
static int hf_rrc_hcs_used_03;                    /* T_hcs_used_03 */
static int hf_rrc_cellSelectQualityMeasure_08;    /* T_cellSelectQualityMeasure_08 */
static int hf_rrc_cpich_RSCP_09;                  /* T_cpich_RSCP_07 */
static int hf_rrc_cpich_Ec_N0_09;                 /* T_cpich_Ec_N0_08 */
static int hf_rrc_use_of_HCS_04;                  /* T_use_of_HCS_04 */
static int hf_rrc_hcs_not_used_04;                /* T_hcs_not_used_04 */
static int hf_rrc_cellSelectQualityMeasure_09;    /* T_cellSelectQualityMeasure_09 */
static int hf_rrc_cpich_RSCP_10;                  /* T_cpich_RSCP_08 */
static int hf_rrc_intraFreqMeasurementSysInfo_04;  /* IntraFreqMeasurementSysInfo_RSCP_LCR_r4 */
static int hf_rrc_interFreqMeasurementSysInfo_04;  /* InterFreqMeasurementSysInfo_RSCP_LCR_r4 */
static int hf_rrc_cpich_Ec_N0_10;                 /* T_cpich_Ec_N0_09 */
static int hf_rrc_intraFreqMeasurementSysInfo_05;  /* IntraFreqMeasurementSysInfo_ECN0_LCR_r4 */
static int hf_rrc_interFreqMeasurementSysInfo_05;  /* InterFreqMeasurementSysInfo_ECN0_LCR_r4 */
static int hf_rrc_hcs_used_04;                    /* T_hcs_used_04 */
static int hf_rrc_cellSelectQualityMeasure_10;    /* T_cellSelectQualityMeasure_10 */
static int hf_rrc_cpich_RSCP_11;                  /* T_cpich_RSCP_09 */
static int hf_rrc_intraFreqMeasurementSysInfo_06;  /* IntraFreqMeasurementSysInfo_HCS_RSCP_LCR_r4 */
static int hf_rrc_interFreqMeasurementSysInfo_06;  /* InterFreqMeasurementSysInfo_HCS_RSCP_LCR_r4 */
static int hf_rrc_cpich_Ec_N0_11;                 /* T_cpich_Ec_N0_10 */
static int hf_rrc_intraFreqMeasurementSysInfo_07;  /* IntraFreqMeasurementSysInfo_HCS_ECN0_LCR_r4 */
static int hf_rrc_interFreqMeasurementSysInfo_07;  /* InterFreqMeasurementSysInfo_HCS_ECN0_LCR_r4 */
static int hf_rrc_measurement_Occasion_Coeff;     /* INTEGER_1_9 */
static int hf_rrc_measurement_Occasion_Offset;    /* INTEGER_0_511 */
static int hf_rrc_measurement_Occasion_Length;    /* INTEGER_1_512 */
static int hf_rrc_timeslotBitmap;                 /* BIT_STRING_SIZE_7 */
static int hf_rrc_releaseAllMeasurements;         /* NULL */
static int hf_rrc_releaseSomeMeasurements;        /* MeasurementsToRelease */
static int hf_rrc_MeasurementsToRelease_item;     /* MeasurementIdentity_r9 */
static int hf_rrc_measurementReportTransferMode;  /* TransferMode */
static int hf_rrc_periodicalOrEventTrigger;       /* PeriodicalOrEventTrigger */
static int hf_rrc_intraFrequencyMeasurement;      /* IntraFrequencyMeasurement */
static int hf_rrc_interFrequencyMeasurement;      /* InterFrequencyMeasurement */
static int hf_rrc_interRATMeasurement_01;         /* InterRATMeasurement */
static int hf_rrc_ue_positioning_Measurement;     /* UE_Positioning_Measurement */
static int hf_rrc_trafficVolumeMeasurement;       /* TrafficVolumeMeasurement */
static int hf_rrc_qualityMeasurement;             /* QualityMeasurement */
static int hf_rrc_ue_InternalMeasurement;         /* UE_InternalMeasurement */
static int hf_rrc_intraFrequencyMeasurement_01;   /* IntraFrequencyMeasurement_r4 */
static int hf_rrc_interFrequencyMeasurement_01;   /* InterFrequencyMeasurement_r4 */
static int hf_rrc_interRATMeasurement_02;         /* InterRATMeasurement_r4 */
static int hf_rrc_up_Measurement;                 /* UE_Positioning_Measurement_r4 */
static int hf_rrc_ue_InternalMeasurement_01;      /* UE_InternalMeasurement_r4 */
static int hf_rrc_intraFrequencyMeasurement_02;   /* IntraFrequencyMeasurement_r6 */
static int hf_rrc_interFrequencyMeasurement_02;   /* InterFrequencyMeasurement_r6 */
static int hf_rrc_interRATMeasurement_03;         /* InterRATMeasurement_r6 */
static int hf_rrc_intraFrequencyMeasurement_03;   /* IntraFrequencyMeasurement_r7 */
static int hf_rrc_interFrequencyMeasurement_03;   /* InterFrequencyMeasurement_r7 */
static int hf_rrc_up_Measurement_01;              /* UE_Positioning_Measurement_r7 */
static int hf_rrc_interFrequencyMeasurement_04;   /* InterFrequencyMeasurement_r8 */
static int hf_rrc_interRATMeasurement_04;         /* InterRATMeasurement_r8 */
static int hf_rrc_up_Measurement_02;              /* UE_Positioning_Measurement_r8 */
static int hf_rrc_intraFrequencyMeasurement_04;   /* IntraFrequencyMeasurement_r9 */
static int hf_rrc_interFrequencyMeasurement_05;   /* InterFrequencyMeasurement_r9 */
static int hf_rrc_interRATMeasurement_05;         /* InterRATMeasurement_r9 */
static int hf_rrc_up_Measurement_03;              /* UE_Positioning_Measurement_r9 */
static int hf_rrc_csgProximityDetection;          /* CSGProximityDetection */
static int hf_rrc_intraFrequencyMeasurement_05;   /* IntraFrequencyMeasurement_r10 */
static int hf_rrc_interFrequencyMeasurement_06;   /* InterFrequencyMeasurement_r10 */
static int hf_rrc_up_Measurement_04;              /* UE_Positioning_Measurement_r10 */
static int hf_rrc_intraFrequencyMeasurement_06;   /* IntraFrequencyMeasurement_r11 */
static int hf_rrc_interFrequencyMeasurement_07;   /* InterFrequencyMeasurement_r11 */
static int hf_rrc_eutraMeasurementForCELLFACH;    /* EUTRA_MeasurementForCELLFACH */
static int hf_rrc_interFrequencyMeasurement_08;   /* InterFrequencyMeasurement_r12 */
static int hf_rrc_interRATMeasurement_06;         /* InterRATMeasurement_r12 */
static int hf_rrc_up_Measurement_05;              /* UE_Positioning_Measurement_r12 */
static int hf_rrc_eutraMeasurementForCELLFACH_01;  /* EUTRA_MeasurementForCELLFACH_r12 */
static int hf_rrc_up_Measurement_06;              /* UE_Positioning_Measurement_r13 */
static int hf_rrc_ue_InternalMeasurement_02;      /* UE_InternalMeasurement_r14 */
static int hf_rrc_applicationLayerMeasurementConfiguration;  /* ApplicationLayerMeasurementConfiguration */
static int hf_rrc_applicationLayerMeasurementConfiguration_r15;  /* ApplicationLayerMeasurementConfiguration_r15 */
static int hf_rrc_applicationLayerMeasurement;    /* NULL */
static int hf_rrc_applicationLayerMeasurement_r15;  /* NULL */
static int hf_rrc_ue_State;                       /* T_ue_State */
static int hf_rrc_MonitoredCellRACH_List_item;    /* MonitoredCellRACH_Result */
static int hf_rrc_sfn_SFN_ObsTimeDifference;      /* SFN_SFN_ObsTimeDifference */
static int hf_rrc_modeSpecificInfo_133;           /* T_modeSpecificInfo_133 */
static int hf_rrc_fdd_183;                        /* T_fdd_177 */
static int hf_rrc_measurementQuantity_06;         /* T_measurementQuantity_04 */
static int hf_rrc_tdd_129;                        /* T_tdd_121 */
static int hf_rrc_MonitoredCellRACH_ListFDD_r11_item;  /* MonitoredCellRACH_ResultFDD_r11 */
static int hf_rrc_measurementQuantity_07;         /* T_measurementQuantity_05 */
static int hf_rrc_MultipleEUTRAFrequencyBandIndicatorList_item;  /* RadioFrequencyBandEUTRA */
static int hf_rrc_MultipleEUTRAFrequencyBandIndicatorExtensionList_item;  /* RadioFrequencyBandEUTRAExt */
static int hf_rrc_multipleEUTRAFrequencyBandIndicatorlist;  /* MultipleEUTRAFrequencyBandIndicatorList */
static int hf_rrc_multipleEUTRAFrequencyBandIndicatorlist_01;  /* MultipleEUTRAFrequencyBandIndicatorExtensionList */
static int hf_rrc_MultipleEUTRAFrequencyInfoList_item;  /* MultipleEUTRAFrequencyBandInfo */
static int hf_rrc_MultipleEUTRAFrequencyInfoExtensionList_item;  /* MultipleEUTRAFrequencyBandExtensionInfo */
static int hf_rrc_MultipleFrequencyBandIndicatorListFDD_item;  /* FrequencyBandsIndicatorFDD */
static int hf_rrc_multipleFrequencyBandIndicatorListFDD;  /* MultipleFrequencyBandIndicatorListFDD */
static int hf_rrc_MultipleFrequencyInfoListFDD_item;  /* MultipleFrequencyBandInfo */
static int hf_rrc_n_CR;                           /* INTEGER_1_16 */
static int hf_rrc_t_CRMaxHyst;                    /* T_CRMaxHyst */
static int hf_rrc_navToc;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_navaf2;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_navaf1;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_navaf0;                         /* BIT_STRING_SIZE_22 */
static int hf_rrc_navTgd;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_satelliteStatus;                /* SatelliteStatus */
static int hf_rrc_ephemerisParameter;             /* EphemerisParameter */
static int hf_rrc_NavigationModelSatInfoList_item;  /* NavigationModelSatInfo */
static int hf_rrc_bdsAODE;                        /* BIT_STRING_SIZE_5 */
static int hf_rrc_bdsURAI;                        /* BIT_STRING_SIZE_4 */
static int hf_rrc_bdsToe;                         /* BIT_STRING_SIZE_17 */
static int hf_rrc_bdsAPowerHalf;                  /* BIT_STRING_SIZE_32 */
static int hf_rrc_bdsE;                           /* BIT_STRING_SIZE_32 */
static int hf_rrc_bdsW;                           /* BIT_STRING_SIZE_32 */
static int hf_rrc_bdsDeltaN;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_bdsM0;                          /* BIT_STRING_SIZE_32 */
static int hf_rrc_bdsOmega0;                      /* BIT_STRING_SIZE_32 */
static int hf_rrc_bdsOmegaDot;                    /* BIT_STRING_SIZE_24 */
static int hf_rrc_bdsI0;                          /* BIT_STRING_SIZE_32 */
static int hf_rrc_bdsIDot;                        /* BIT_STRING_SIZE_14 */
static int hf_rrc_bdsCuc;                         /* BIT_STRING_SIZE_18 */
static int hf_rrc_bdsCus;                         /* BIT_STRING_SIZE_18 */
static int hf_rrc_bdsCrc;                         /* BIT_STRING_SIZE_18 */
static int hf_rrc_bdsCrs;                         /* BIT_STRING_SIZE_18 */
static int hf_rrc_bdsCic;                         /* BIT_STRING_SIZE_18 */
static int hf_rrc_bdsCis;                         /* BIT_STRING_SIZE_18 */
static int hf_rrc_cnavURAindex;                   /* BIT_STRING_SIZE_5 */
static int hf_rrc_cnavDeltaA;                     /* BIT_STRING_SIZE_26 */
static int hf_rrc_cnavAdot;                       /* BIT_STRING_SIZE_25 */
static int hf_rrc_cnavDeltaNo;                    /* BIT_STRING_SIZE_17 */
static int hf_rrc_cnavDeltaNoDot;                 /* BIT_STRING_SIZE_23 */
static int hf_rrc_cnavMo;                         /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavE;                          /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavOmega;                      /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavOMEGA0;                     /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavDeltaOmegaDot;              /* BIT_STRING_SIZE_17 */
static int hf_rrc_cnavIo;                         /* BIT_STRING_SIZE_33 */
static int hf_rrc_cnavIoDot;                      /* BIT_STRING_SIZE_15 */
static int hf_rrc_cnavCis;                        /* BIT_STRING_SIZE_16 */
static int hf_rrc_cnavCic;                        /* BIT_STRING_SIZE_16 */
static int hf_rrc_cnavCrs;                        /* BIT_STRING_SIZE_24 */
static int hf_rrc_cnavCrc;                        /* BIT_STRING_SIZE_24 */
static int hf_rrc_cnavCus;                        /* BIT_STRING_SIZE_21 */
static int hf_rrc_cnavCuc;                        /* BIT_STRING_SIZE_21 */
static int hf_rrc_gloEn;                          /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloP1;                          /* BIT_STRING_SIZE_2 */
static int hf_rrc_gloP2;                          /* BIT_STRING_SIZE_1 */
static int hf_rrc_gloM;                           /* BIT_STRING_SIZE_2 */
static int hf_rrc_gloX;                           /* BIT_STRING_SIZE_27 */
static int hf_rrc_gloXdot;                        /* BIT_STRING_SIZE_24 */
static int hf_rrc_gloXdotdot;                     /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloY;                           /* BIT_STRING_SIZE_27 */
static int hf_rrc_gloYdot;                        /* BIT_STRING_SIZE_24 */
static int hf_rrc_gloYdotdot;                     /* BIT_STRING_SIZE_5 */
static int hf_rrc_gloZ;                           /* BIT_STRING_SIZE_27 */
static int hf_rrc_gloZdot;                        /* BIT_STRING_SIZE_24 */
static int hf_rrc_gloZdotdot;                     /* BIT_STRING_SIZE_5 */
static int hf_rrc_navURA;                         /* BIT_STRING_SIZE_4 */
static int hf_rrc_navFitFlag;                     /* BIT_STRING_SIZE_1 */
static int hf_rrc_navToe;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_navOmega;                       /* BIT_STRING_SIZE_32 */
static int hf_rrc_navDeltaN;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_navM0;                          /* BIT_STRING_SIZE_32 */
static int hf_rrc_navOmegaADot;                   /* BIT_STRING_SIZE_24 */
static int hf_rrc_navE;                           /* BIT_STRING_SIZE_32 */
static int hf_rrc_navIDot;                        /* BIT_STRING_SIZE_14 */
static int hf_rrc_navAPowerHalf;                  /* BIT_STRING_SIZE_32 */
static int hf_rrc_navI0;                          /* BIT_STRING_SIZE_32 */
static int hf_rrc_navOmegaA0;                     /* BIT_STRING_SIZE_32 */
static int hf_rrc_navCrs;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCis;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCus;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCrc;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCic;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_navCuc;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_sbasTo;                         /* BIT_STRING_SIZE_13 */
static int hf_rrc_sbasAccuracy;                   /* BIT_STRING_SIZE_4 */
static int hf_rrc_sbasXg;                         /* BIT_STRING_SIZE_30 */
static int hf_rrc_sbasYg;                         /* BIT_STRING_SIZE_30 */
static int hf_rrc_sbasZg;                         /* BIT_STRING_SIZE_25 */
static int hf_rrc_sbasXgDot;                      /* BIT_STRING_SIZE_17 */
static int hf_rrc_sbasYgDot;                      /* BIT_STRING_SIZE_17 */
static int hf_rrc_sbasZgDot;                      /* BIT_STRING_SIZE_18 */
static int hf_rrc_sbasXgDotDot;                   /* BIT_STRING_SIZE_10 */
static int hf_rrc_sbagYgDotDot;                   /* BIT_STRING_SIZE_10 */
static int hf_rrc_sbasZgDotDot;                   /* BIT_STRING_SIZE_10 */
static int hf_rrc_codeOnL2;                       /* BIT_STRING_SIZE_2 */
static int hf_rrc_uraIndex;                       /* BIT_STRING_SIZE_4 */
static int hf_rrc_satHealth_01;                   /* BIT_STRING_SIZE_6 */
static int hf_rrc_iodc;                           /* BIT_STRING_SIZE_10 */
static int hf_rrc_l2Pflag;                        /* BIT_STRING_SIZE_1 */
static int hf_rrc_sf1Revd;                        /* SubFrame1Reserved */
static int hf_rrc_t_GD;                           /* BIT_STRING_SIZE_8 */
static int hf_rrc_t_oc;                           /* BIT_STRING_SIZE_16 */
static int hf_rrc_af2;                            /* BIT_STRING_SIZE_8 */
static int hf_rrc_af1_01;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_af0_01;                         /* BIT_STRING_SIZE_22 */
static int hf_rrc_c_rs;                           /* BIT_STRING_SIZE_16 */
static int hf_rrc_delta_n;                        /* BIT_STRING_SIZE_16 */
static int hf_rrc_m0_01;                          /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_uc;                           /* BIT_STRING_SIZE_16 */
static int hf_rrc_e_01;                           /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_us;                           /* BIT_STRING_SIZE_16 */
static int hf_rrc_a_Sqrt_01;                      /* BIT_STRING_SIZE_32 */
static int hf_rrc_t_oe;                           /* BIT_STRING_SIZE_16 */
static int hf_rrc_fitInterval;                    /* BIT_STRING_SIZE_1 */
static int hf_rrc_aodo;                           /* BIT_STRING_SIZE_5 */
static int hf_rrc_c_ic;                           /* BIT_STRING_SIZE_16 */
static int hf_rrc_omega0_01;                      /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_is;                           /* BIT_STRING_SIZE_16 */
static int hf_rrc_i0;                             /* BIT_STRING_SIZE_32 */
static int hf_rrc_c_rc;                           /* BIT_STRING_SIZE_16 */
static int hf_rrc_omega_01;                       /* BIT_STRING_SIZE_32 */
static int hf_rrc_omegaDot_01;                    /* BIT_STRING_SIZE_24 */
static int hf_rrc_iDot;                           /* BIT_STRING_SIZE_14 */
static int hf_rrc_modeSpecificInfo_134;           /* T_modeSpecificInfo_134 */
static int hf_rrc_fdd_184;                        /* T_fdd_178 */
static int hf_rrc_neighbourIdentity;              /* PrimaryCPICH_Info */
static int hf_rrc_uE_RX_TX_TimeDifferenceType2Info;  /* UE_RX_TX_TimeDifferenceType2Info */
static int hf_rrc_tdd_130;                        /* T_tdd_122 */
static int hf_rrc_neighbourAndChannelIdentity;    /* CellAndChannelIdentity */
static int hf_rrc_neighbourQuality;               /* NeighbourQuality */
static int hf_rrc_sfn_SFN_ObsTimeDifference2;     /* SFN_SFN_ObsTimeDifference2 */
static int hf_rrc_modeSpecificInfo_135;           /* T_modeSpecificInfo_135 */
static int hf_rrc_fdd_185;                        /* T_fdd_179 */
static int hf_rrc_NeighbourList_item;             /* Neighbour */
static int hf_rrc_NeighbourList_TDD_r7_item;      /* Neighbour_TDD_r7 */
static int hf_rrc_NeighbourList_v390ext_item;     /* Neighbour_v390ext */
static int hf_rrc_ue_Positioning_OTDOA_Quality;   /* UE_Positioning_OTDOA_Quality */
static int hf_rrc_interFreqCellID;                /* InterFreqCellID */
static int hf_rrc_cellInfo;                       /* CellInfo */
static int hf_rrc_cellInfo_01;                    /* CellInfo_r4 */
static int hf_rrc_intraSecondaryFreqIndicator;    /* BOOLEAN */
static int hf_rrc_cellInfo_LCR_r8;                /* CellInfo_LCR_r8_ext */
static int hf_rrc_modeSpecificInfo_136;           /* T_modeSpecificInfo_136 */
static int hf_rrc_noInfo;                         /* NULL */
static int hf_rrc_tdd128_69;                      /* T_tdd128_67 */
static int hf_rrc_cellInfo_02;                    /* CellInfo_r9 */
static int hf_rrc_modeSpecificInfo_137;           /* T_modeSpecificInfo_137 */
static int hf_rrc_tdd128_70;                      /* T_tdd128_68 */
static int hf_rrc_modeSpecificInfo_138;           /* T_modeSpecificInfo_138 */
static int hf_rrc_tdd128_71;                      /* T_tdd128_69 */
static int hf_rrc_sNPLMonitorSetIndicator_TDD128;  /* BIT_STRING_SIZE_5 */
static int hf_rrc_interFreqCellID_01;             /* InterFreqCellID_r12 */
static int hf_rrc_modeSpecificInfo_139;           /* T_modeSpecificInfo_139 */
static int hf_rrc_tdd128_72;                      /* T_tdd128_70 */
static int hf_rrc_NewInterFreqCellList_item;      /* NewInterFreqCell */
static int hf_rrc_NewInterFreqCellList_r4_item;   /* NewInterFreqCell_r4 */
static int hf_rrc_NewInterFreqCellList_r12_item;  /* NewInterFreqCell_r12 */
static int hf_rrc_NewInterFreqCellList_v7b0ext_item;  /* NewInterFreqCell_v7b0ext */
static int hf_rrc_NewInterFreqCellList_LCR_v8a0ext_item;  /* NewInterFreqCell_LCR_v8a0ext */
static int hf_rrc_NewInterFreqCellList_r8_item;   /* NewInterFreqCell_r8 */
static int hf_rrc_NewInterFreqCellList_r9_item;   /* NewInterFreqCell_r9 */
static int hf_rrc_NewInterFreqCellList_r10_item;  /* NewInterFreqCell_r10 */
static int hf_rrc_cellInfo_03;                    /* CellInfoSI_RSCP */
static int hf_rrc_cellInfo_04;                    /* CellInfoSI_ECN0 */
static int hf_rrc_cellInfo_05;                    /* CellInfoSI_HCS_RSCP */
static int hf_rrc_cellInfo_06;                    /* CellInfoSI_HCS_ECN0 */
static int hf_rrc_cellInfo_07;                    /* CellInfoSI_RSCP_LCR_r4 */
static int hf_rrc_cellInfo_08;                    /* CellInfoSI_ECN0_LCR_r4 */
static int hf_rrc_cellInfo_09;                    /* CellInfoSI_HCS_RSCP_LCR_r4 */
static int hf_rrc_cellInfo_10;                    /* CellInfoSI_HCS_ECN0_LCR_r4 */
static int hf_rrc_NewInterFreqCellSI_List_ECN0_item;  /* NewInterFreqCellSI_ECN0 */
static int hf_rrc_NewInterFreqCellSI_List_ECN0_ext_item;  /* NewInterFreqCellSI_ECN0_ext */
static int hf_rrc_NewInterFreqCellSI_List_HCS_RSCP_item;  /* NewInterFreqCellSI_HCS_RSCP */
static int hf_rrc_NewInterFreqCellSI_List_HCS_RSCP_ext_item;  /* NewInterFreqCellSI_HCS_RSCP_ext */
static int hf_rrc_NewInterFreqCellSI_List_HCS_ECN0_item;  /* NewInterFreqCellSI_HCS_ECN0 */
static int hf_rrc_NewInterFreqCellSI_List_HCS_ECN0_ext_item;  /* NewInterFreqCellSI_HCS_ECN0_ext */
static int hf_rrc_NewInterFreqCellSI_List_RSCP_item;  /* NewInterFreqCellSI_RSCP */
static int hf_rrc_NewInterFreqCellSI_List_RSCP_ext_item;  /* NewInterFreqCellSI_RSCP_ext */
static int hf_rrc_NewInterFreqCellSI_List_ECN0_LCR_r4_item;  /* NewInterFreqCellSI_ECN0_LCR_r4 */
static int hf_rrc_NewInterFreqCellSI_List_HCS_RSCP_LCR_r4_item;  /* NewInterFreqCellSI_HCS_RSCP_LCR_r4 */
static int hf_rrc_NewInterFreqCellSI_List_HCS_ECN0_LCR_r4_item;  /* NewInterFreqCellSI_HCS_ECN0_LCR_r4 */
static int hf_rrc_NewInterFreqCellSI_List_RSCP_LCR_r4_item;  /* NewInterFreqCellSI_RSCP_LCR_r4 */
static int hf_rrc_interRATCellID;                 /* InterRATCellID */
static int hf_rrc_technologySpecificInfo_01;      /* T_technologySpecificInfo_01 */
static int hf_rrc_gsm_17;                         /* T_gsm_15 */
static int hf_rrc_cellSelectionReselectionInfo_05;  /* CellSelectReselectInfoSIB_11_12 */
static int hf_rrc_interRATCellIndividualOffset;   /* InterRATCellIndividualOffset */
static int hf_rrc_is_2000_03;                     /* T_is_2000_02 */
static int hf_rrc_is_2000SpecificMeasInfo;        /* IS_2000SpecificMeasInfo */
static int hf_rrc_technologySpecificInfo_02;      /* T_technologySpecificInfo_02 */
static int hf_rrc_gsm_18;                         /* T_gsm_16 */
static int hf_rrc_is_2000_04;                     /* T_is_2000_03 */
static int hf_rrc_NewInterRATCellList_item;       /* NewInterRATCell */
static int hf_rrc_NewInterRATCellList_B_item;     /* NewInterRATCell_B */
static int hf_rrc_intraFreqCellID;                /* IntraFreqCellID */
static int hf_rrc_modeSpecificInfo_140;           /* T_modeSpecificInfo_140 */
static int hf_rrc_tdd128_73;                      /* T_tdd128_71 */
static int hf_rrc_intraFreqCellIDOnSecULFreq;     /* IntraFreqCellIDOnSecULFreq */
static int hf_rrc_NewIntraFreqCellList_item;      /* NewIntraFreqCell */
static int hf_rrc_NewIntraFreqCellList_r4_item;   /* NewIntraFreqCell_r4 */
static int hf_rrc_NewIntraFreqCellList_r9_item;   /* NewIntraFreqCell_r9 */
static int hf_rrc_NewIntraFreqCellList_r10_item;  /* NewIntraFreqCell_r10 */
static int hf_rrc_NewIntraFreqCellList_LCR_v8a0ext_item;  /* NewIntraFreqCell_LCR_v8a0ext */
static int hf_rrc_NewIntraFreqCellListOnSecULFreq_item;  /* NewIntraFreqCellOnSecULFreq */
static int hf_rrc_NewIntraFreqCellSI_List_RSCP_item;  /* NewIntraFreqCellSI_RSCP */
static int hf_rrc_NewIntraFreqCellSI_List_ECN0_item;  /* NewIntraFreqCellSI_ECN0 */
static int hf_rrc_NewIntraFreqCellSI_List_HCS_RSCP_item;  /* NewIntraFreqCellSI_HCS_RSCP */
static int hf_rrc_NewIntraFreqCellSI_List_HCS_ECN0_item;  /* NewIntraFreqCellSI_HCS_ECN0 */
static int hf_rrc_NewIntraFreqCellSI_List_RSCP_LCR_r4_item;  /* NewIntraFreqCellSI_RSCP_LCR_r4 */
static int hf_rrc_NewIntraFreqCellSI_List_ECN0_LCR_r4_item;  /* NewIntraFreqCellSI_ECN0_LCR_r4 */
static int hf_rrc_NewIntraFreqCellSI_List_HCS_RSCP_LCR_r4_item;  /* NewIntraFreqCellSI_HCS_RSCP_LCR_r4 */
static int hf_rrc_NewIntraFreqCellSI_List_HCS_ECN0_LCR_r4_item;  /* NewIntraFreqCellSI_HCS_ECN0_LCR_r4 */
static int hf_rrc_nonUsedFreqThreshold;           /* Threshold */
static int hf_rrc_nonUsedFreqW;                   /* W */
static int hf_rrc_nonUsedFreqThreshold_01;        /* Threshold_r6 */
static int hf_rrc_nonUsedFreqTriggeringConditionDetectedCells;  /* T_nonUsedFreqTriggeringConditionDetectedCells */
static int hf_rrc_nonUsedFreqTriggeringConditionDetectedCells_01;  /* T_nonUsedFreqTriggeringConditionDetectedCells_01 */
static int hf_rrc_cellInfoListToBeExcluded;       /* CellInfoListToBeExcluded */
static int hf_rrc_nonUsedFreqTriggeringConditionDetectedCells_02;  /* T_nonUsedFreqTriggeringConditionDetectedCells_02 */
static int hf_rrc_nonUsedFreqTriggeringConditionDetectedCells_03;  /* T_nonUsedFreqTriggeringConditionDetectedCells_03 */
static int hf_rrc_NonUsedFreqParameterList_item;  /* NonUsedFreqParameter */
static int hf_rrc_NonUsedFreqParameterList_r6_item;  /* NonUsedFreqParameter_r6 */
static int hf_rrc_NonUsedFreqParameterList_r10_item;  /* NonUsedFreqParameter_r10 */
static int hf_rrc_NonUsedFreqParameterList_r11_item;  /* NonUsedFreqParameter_r11 */
static int hf_rrc_NonUsedFreq2aParameterList_r10_item;  /* NonUsedFreq2aParameter_r10 */
static int hf_rrc_NonUsedFreq2aParameterList_r11_item;  /* NonUsedFreq2aParameter_r11 */
static int hf_rrc_NonUsedFreqWList_r6_item;       /* W */
static int hf_rrc_containerForApplicationLayerMeasurementConfiguration;  /* OCTET_STRING_SIZE_1_1000 */
static int hf_rrc_serviceType;                    /* T_serviceType */
static int hf_rrc_containerForApplicationLayerMeasurementReporting;  /* OCTET_STRING_SIZE_1_8000 */
static int hf_rrc_serviceType_01;                 /* T_serviceType_01 */
static int hf_rrc_notUsed;                        /* NULL */
static int hf_rrc_pt10;                           /* TemporaryOffset1 */
static int hf_rrc_pt20;                           /* TemporaryOffset1 */
static int hf_rrc_pt30;                           /* TemporaryOffset1 */
static int hf_rrc_pt40;                           /* TemporaryOffset1 */
static int hf_rrc_pt50;                           /* TemporaryOffset1 */
static int hf_rrc_pt60;                           /* TemporaryOffset1 */
static int hf_rrc_pt10_01;                        /* TemporaryOffsetList */
static int hf_rrc_pt20_01;                        /* TemporaryOffsetList */
static int hf_rrc_pt30_01;                        /* TemporaryOffsetList */
static int hf_rrc_pt40_01;                        /* TemporaryOffsetList */
static int hf_rrc_pt50_01;                        /* TemporaryOffsetList */
static int hf_rrc_pt60_01;                        /* TemporaryOffsetList */
static int hf_rrc_reportingInterval_01;           /* ReportingIntervalLong */
static int hf_rrc_periodicalWithReportingCellStatus;  /* PeriodicalWithReportingCellStatus_r10 */
static int hf_rrc_plmnsOfIntraFreqCellsList;      /* PLMNsOfIntraFreqCellsList */
static int hf_rrc_plmnsOfInterFreqCellsList;      /* PLMNsOfInterFreqCellsList */
static int hf_rrc_plmnsOfInterRATCellsList;       /* PLMNsOfInterRATCellsList */
static int hf_rrc_multipleplmnsOfIntraFreqCellsList;  /* MultiplePLMNsOfIntraFreqCellsList */
static int hf_rrc_multipleplmnsOfInterFreqCellsList;  /* MultiplePLMNsOfInterFreqCellsList */
static int hf_rrc_plmnsOfInterFreqCellsList_01;   /* PLMNsOfInterFreqCellsList_vc50ext */
static int hf_rrc_multipleplmnsOfInterFreqCellsList_01;  /* MultiplePLMNsOfInterFreqCellsList_vc50ext */
static int hf_rrc_PlmnList_item;                  /* PLMN_Identity */
static int hf_rrc_PLMNsOfInterFreqCellsList_item;  /* PLMNsOfInterFreqCellsList_item */
static int hf_rrc_PLMNsOfInterFreqCellsList_vc50ext_item;  /* InterFreqCellPLMN */
static int hf_rrc_MultiplePLMNsOfInterFreqCellsList_item;  /* MultiplePLMNsOfInterFreqCellsList_item */
static int hf_rrc_multiplePLMN_list;              /* SEQUENCE_SIZE_1_6_OF_PLMN_IdentityWithOptionalMCC_r6 */
static int hf_rrc_multiplePLMN_list_item;         /* PLMN_IdentityWithOptionalMCC_r6 */
static int hf_rrc_MultiplePLMNsOfInterFreqCellsList_vc50ext_item;  /* MultiplePLMNInfo */
static int hf_rrc_multiplePLMN_list_01;           /* MultiplePLMN_List */
static int hf_rrc_MultiplePLMN_List_item;         /* PLMN_IdentityWithOptionalMCC_r6 */
static int hf_rrc_PLMNsOfIntraFreqCellsList_item;  /* PLMNsOfIntraFreqCellsList_item */
static int hf_rrc_MultiplePLMNsOfIntraFreqCellsList_item;  /* MultiplePLMNsOfIntraFreqCellsList_item */
static int hf_rrc_PLMNsOfInterRATCellsList_item;  /* PLMNsOfInterRATCellsList_item */
static int hf_rrc_QualityEventResults_item;       /* TransportChannelIdentity */
static int hf_rrc_blerMeasurementResultsList;     /* BLER_MeasurementResultsList */
static int hf_rrc_modeSpecificInfo_141;           /* T_modeSpecificInfo_141 */
static int hf_rrc_tdd_131;                        /* T_tdd_123 */
static int hf_rrc_sir_MeasurementResults;         /* SIR_MeasurementList */
static int hf_rrc_qualityReportingQuantity;       /* QualityReportingQuantity */
static int hf_rrc_reportCriteria_18;              /* QualityReportCriteria */
static int hf_rrc_qualityReportingCriteria;       /* QualityReportingCriteria */
static int hf_rrc_noReporting_02;                 /* NULL */
static int hf_rrc_QualityReportingCriteria_item;  /* QualityReportingCriteriaSingle */
static int hf_rrc_totalCRC;                       /* INTEGER_1_512 */
static int hf_rrc_badCRC;                         /* INTEGER_1_512 */
static int hf_rrc_pendingAfterTrigger;            /* INTEGER_1_512 */
static int hf_rrc_dl_TransChBLER;                 /* BOOLEAN */
static int hf_rrc_bler_dl_TransChIdList;          /* BLER_TransChIdList */
static int hf_rrc_modeSpecificInfo_142;           /* T_modeSpecificInfo_142 */
static int hf_rrc_tdd_132;                        /* T_tdd_124 */
static int hf_rrc_sir_TFCS_List;                  /* SIR_TFCS_List */
static int hf_rrc_ellipsoidPointWithAltitude;     /* EllipsoidPointAltitude */
static int hf_rrc_ellipsoidPointAltitudeEllipsoide;  /* EllipsoidPointAltitudeEllipsoide */
static int hf_rrc_accuracy40;                     /* INTEGER_0_960 */
static int hf_rrc_accuracy256;                    /* INTEGER_0_150 */
static int hf_rrc_accuracy2560;                   /* INTEGER_0_15 */
static int hf_rrc_removeAllInterFreqCells;        /* NULL */
static int hf_rrc_removeSomeInterFreqCells;       /* SEQUENCE_SIZE_1_maxCellMeas_OF_InterFreqCellID */
static int hf_rrc_removeSomeInterFreqCells_item;  /* InterFreqCellID */
static int hf_rrc_removeNoInterFreqCells;         /* NULL */
static int hf_rrc_removeSomeInterFreqCells_01;    /* SEQUENCE_SIZE_1_maxCellMeas_ext_OF_InterFreqCellID_r12 */
static int hf_rrc_removeSomeInterFreqCells_item_01;  /* InterFreqCellID_r12 */
static int hf_rrc_removeAllInterRATCells;         /* NULL */
static int hf_rrc_removeSomeInterRATCells;        /* SEQUENCE_SIZE_1_maxCellMeas_OF_InterRATCellID */
static int hf_rrc_removeSomeInterRATCells_item;   /* InterRATCellID */
static int hf_rrc_removeNoInterRATCells;          /* NULL */
static int hf_rrc_removeAllIntraFreqCells;        /* NULL */
static int hf_rrc_removeSomeIntraFreqCells;       /* SEQUENCE_SIZE_1_maxCellMeas_OF_IntraFreqCellID */
static int hf_rrc_removeSomeIntraFreqCells_item;  /* IntraFreqCellID */
static int hf_rrc_removeNoIntraFreqCells;         /* NULL */
static int hf_rrc_removeSomeIntraFreqCells_01;    /* SEQUENCE_SIZE_1_maxCellMeasOnSecULFreq_OF_IntraFreqCellIDOnSecULFreq */
static int hf_rrc_removeSomeIntraFreqCells_item_01;  /* IntraFreqCellIDOnSecULFreq */
static int hf_rrc_withinActiveSet;                /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinMonitoredSetUsedFreq;     /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinActiveAndOrMonitoredUsedFreq;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinDetectedSetUsedFreq;      /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinMonitoredAndOrDetectedUsedFreq;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_allActiveplusMonitoredSet;      /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_allActivePlusDetectedSet;       /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_allActivePlusMonitoredAndOrDetectedSet;  /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_withinVirtualActSet;            /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinMonitoredSetNonUsedFreq;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_withinMonitoredAndOrVirtualActiveSetNonUsedFreq;  /* MaxNumberOfReportingCellsType1 */
static int hf_rrc_allVirtualActSetplusMonitoredSetNonUsedFreq;  /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_withinActSetOrVirtualActSet_InterRATcells;  /* MaxNumberOfReportingCellsType2 */
static int hf_rrc_withinActSetAndOrMonitoredUsedFreqOrVirtualActSetAndOrMonitoredNonUsedFreq;  /* MaxNumberOfReportingCellsType2 */
static int hf_rrc_allVirtualActSetplusMonitoredSetplusDetectedSetNonUsedFreq;  /* MaxNumberOfReportingCellsType3 */
static int hf_rrc_reportCriteria_19;              /* CellDCH_ReportCriteria */
static int hf_rrc_reportCriteria_20;              /* CellDCH_ReportCriteria_LCR_r4 */
static int hf_rrc_ganssSignalID;                  /* DGANSS_Sig_Id_Req */
static int hf_rrc_ganssDataBitInterval;           /* INTEGER_0_15 */
static int hf_rrc_ganssSatelliteInfo;             /* T_ganssSatelliteInfo */
static int hf_rrc_ganssSatelliteInfo_item;        /* INTEGER_0_63 */
static int hf_rrc_RL_AdditionInfoList_item;       /* PrimaryCPICH_Info */
static int hf_rrc_rl_AdditionInfoList;            /* RL_AdditionInfoList */
static int hf_rrc_rL_RemovalInformationList;      /* RL_RemovalInformationList */
static int hf_rrc_RMP_Frequency_List_item;        /* BOOLEAN */
static int hf_rrc_rSCP;                           /* INTEGER_M120_M25 */
static int hf_rrc_allSymbols;                     /* BOOLEAN */
static int hf_rrc_wideBand;                       /* BOOLEAN */
static int hf_rrc_SatDataList_item;               /* SatData */
static int hf_rrc_iod_int_0_1023;                 /* INTEGER_0_1023 */
static int hf_rrc_SatellitesListRelatedDataList_item;  /* SatellitesListRelatedData */
static int hf_rrc_t_oc_01;                        /* BIT_STRING_SIZE_14 */
static int hf_rrc_af2_01;                         /* BIT_STRING_SIZE_6 */
static int hf_rrc_af1_02;                         /* BIT_STRING_SIZE_21 */
static int hf_rrc_af0_02;                         /* BIT_STRING_SIZE_31 */
static int hf_rrc_tgd_bit_string;                 /* BIT_STRING_SIZE_10 */
static int hf_rrc_sisa;                           /* BIT_STRING_SIZE_8 */
static int hf_rrc_model_id;                       /* INTEGER_0_1 */
static int hf_rrc_Satellite_clock_modelList_item;  /* Satellite_clock_model */
static int hf_rrc_sbasAgfo;                       /* BIT_STRING_SIZE_12 */
static int hf_rrc_sbasAgf1;                       /* BIT_STRING_SIZE_8 */
static int hf_rrc_s_DPCCH_DPCCH_PowerOffset;      /* S_DPCCH_DPCCH_PowerOffset */
static int hf_rrc_type1_07;                       /* SFN_SFN_ObsTimeDifference1 */
static int hf_rrc_type2_06;                       /* SFN_SFN_ObsTimeDifference2 */
static int hf_rrc_sfn_Offset;                     /* INTEGER_0_4095 */
static int hf_rrc_sfn_sfn_Reltimedifference;      /* INTEGER_0_38399 */
static int hf_rrc_SIR_MeasurementList_item;       /* SIR_MeasurementResults */
static int hf_rrc_sir_TimeslotList;               /* SIR_TimeslotList */
static int hf_rrc_SIR_TFCS_List_item;             /* SIR_TFCS */
static int hf_rrc_SIR_TimeslotList_item;          /* SIR */
static int hf_rrc_reserved1;                      /* BIT_STRING_SIZE_23 */
static int hf_rrc_reserved2;                      /* BIT_STRING_SIZE_24 */
static int hf_rrc_reserved3;                      /* BIT_STRING_SIZE_24 */
static int hf_rrc_reserved4;                      /* BIT_STRING_SIZE_16 */
static int hf_rrc_t_ADV;                          /* INTEGER_0_2047 */
static int hf_rrc_sfn;                            /* INTEGER_0_4095 */
static int hf_rrc_t_ADV_01;                       /* INTEGER_0_8191 */
static int hf_rrc_t30;                            /* N_CR_T_CRMaxHyst */
static int hf_rrc_t60;                            /* N_CR_T_CRMaxHyst */
static int hf_rrc_t120;                           /* N_CR_T_CRMaxHyst */
static int hf_rrc_t180;                           /* N_CR_T_CRMaxHyst */
static int hf_rrc_t240;                           /* N_CR_T_CRMaxHyst */
static int hf_rrc_tce_Id_01;                      /* OCTET_STRING_SIZE_1 */
static int hf_rrc_temporaryOffset1;               /* TemporaryOffset1 */
static int hf_rrc_temporaryOffset2;               /* TemporaryOffset2 */
static int hf_rrc_ThreholdNonUsedFrequency_deltaList_item;  /* DeltaRSCPPerCell */
static int hf_rrc_TimeslotInfoList_item;          /* TimeslotInfo */
static int hf_rrc_TimeslotInfoList_LCR_r4_item;   /* TimeslotInfo_LCR_r4 */
static int hf_rrc_tdd384_49;                      /* SEQUENCE_SIZE_1_maxTS_OF_TimeslotInfo */
static int hf_rrc_tdd384_item_01;                 /* TimeslotInfo */
static int hf_rrc_tdd128_74;                      /* SEQUENCE_SIZE_1_maxTS_LCR_OF_TimeslotInfo_LCR_r4 */
static int hf_rrc_tdd128_item_02;                 /* TimeslotInfo_LCR_r4 */
static int hf_rrc_TimeslotISCP_List_item;         /* TimeslotISCP */
static int hf_rrc_TimeslotListWithISCP_item;      /* TimeslotWithISCP */
static int hf_rrc_timeslotISCP_01;                /* TimeslotISCP */
static int hf_rrc_traceId;                        /* OCTET_STRING_SIZE_3 */
static int hf_rrc_traceRecordingSession_01;       /* OCTET_STRING_SIZE_2 */
static int hf_rrc_eventID_03;                     /* TrafficVolumeEventType */
static int hf_rrc_reportingThreshold_02;          /* TrafficVolumeThreshold */
static int hf_rrc_pendingTimeAfterTrigger;        /* PendingTimeAfterTrigger */
static int hf_rrc_tx_InterruptionAfterTrigger;    /* TX_InterruptionAfterTrigger */
static int hf_rrc_ul_transportChannelCausingEvent;  /* UL_TrCH_Identity */
static int hf_rrc_trafficVolumeEventIdentity;     /* TrafficVolumeEventType */
static int hf_rrc_rlc_BufferPayload;              /* NULL */
static int hf_rrc_averageRLC_BufferPayload;       /* TimeInterval */
static int hf_rrc_varianceOfRLC_BufferPayload;    /* TimeInterval */
static int hf_rrc_trafficVolumeMeasurementID;     /* MeasurementIdentity */
static int hf_rrc_trafficVolumeMeasurementObjectList;  /* TrafficVolumeMeasurementObjectList */
static int hf_rrc_trafficVolumeMeasQuantity;      /* TrafficVolumeMeasQuantity */
static int hf_rrc_trafficVolumeReportingQuantity;  /* TrafficVolumeReportingQuantity */
static int hf_rrc_measurementValidity_01;         /* TrafficVolumeReportingCriteria */
static int hf_rrc_reportCriteriaSysInf;           /* TrafficVolumeReportCriteriaSysInfo */
static int hf_rrc_rlc_BuffersPayload;             /* RLC_BuffersPayload */
static int hf_rrc_averageRLC_BufferPayload_01;    /* AverageRLC_BufferPayload */
static int hf_rrc_varianceOfRLC_BufferPayload_01;  /* VarianceOfRLC_BufferPayload */
static int hf_rrc_TrafficVolumeMeasuredResultsList_item;  /* TrafficVolumeMeasuredResults */
static int hf_rrc_reportCriteria_21;              /* TrafficVolumeReportCriteria */
static int hf_rrc_TrafficVolumeMeasurementObjectList_item;  /* UL_TrCH_Identity */
static int hf_rrc_trafficVolumeReportingCriteria;  /* TrafficVolumeReportingCriteria */
static int hf_rrc_transChCriteriaList;            /* TransChCriteriaList */
static int hf_rrc_rlc_RB_BufferPayload;           /* BOOLEAN */
static int hf_rrc_rlc_RB_BufferPayloadAverage;    /* BOOLEAN */
static int hf_rrc_rlc_RB_BufferPayloadVariance;   /* BOOLEAN */
static int hf_rrc_ul_transportChannelID;          /* UL_TrCH_Identity */
static int hf_rrc_eventSpecificParameters;        /* SEQUENCE_SIZE_1_maxMeasParEvent_OF_TrafficVolumeEventParam */
static int hf_rrc_eventSpecificParameters_item;   /* TrafficVolumeEventParam */
static int hf_rrc_TransChCriteriaList_item;       /* TransChCriteria */
static int hf_rrc_transmittedPowerThreshold;      /* TransmittedPowerThreshold */
static int hf_rrc_ue_RX_TX_TimeDifferenceThreshold;  /* UE_RX_TX_TimeDifferenceThreshold */
static int hf_rrc_ue_powerheadroomthreshold;      /* UE_PowerHeadroomThreshold */
static int hf_rrc_filtercoefficient;              /* FilterCoefficient */
static int hf_rrc_pendingtimeaftertrigger;        /* PendingTimeAfterTrigger */
static int hf_rrc_onWithNoReporting;              /* NULL */
static int hf_rrc_rL_InformationLists;            /* RL_InformationLists */
static int hf_rrc_event6a;                        /* UE_6AB_Event */
static int hf_rrc_event6b;                        /* UE_6AB_Event */
static int hf_rrc_event6c;                        /* TimeToTrigger */
static int hf_rrc_event6d;                        /* TimeToTrigger */
static int hf_rrc_event6e;                        /* TimeToTrigger */
static int hf_rrc_event6f;                        /* UE_6FG_Event */
static int hf_rrc_event6g;                        /* UE_6FG_Event */
static int hf_rrc_event6h;                        /* UE_6HI_Event */
static int hf_rrc_event6i;                        /* UE_6HI_Event */
static int hf_rrc_UE_InternalEventParamList_item;  /* UE_InternalEventParam */
static int hf_rrc_UE_InternalEventParamList_r14_item;  /* UE_InternalEventParam_r14 */
static int hf_rrc_event6a_01;                     /* NULL */
static int hf_rrc_event6b_01;                     /* NULL */
static int hf_rrc_event6c_01;                     /* NULL */
static int hf_rrc_event6d_01;                     /* NULL */
static int hf_rrc_event6e_01;                     /* NULL */
static int hf_rrc_event6f_01;                     /* PrimaryCPICH_Info */
static int hf_rrc_event6g_01;                     /* PrimaryCPICH_Info */
static int hf_rrc_ue_InternalEventResults_v30ext;  /* UE_InternalEventResults_v30ext_IEs */
static int hf_rrc_event6h_01;                     /* NULL */
static int hf_rrc_event6i_01;                     /* NULL */
static int hf_rrc_measurementQuantity_08;         /* UE_MeasurementQuantity */
static int hf_rrc_measurementQuantity_09;         /* UE_MeasurementQuantity_r14 */
static int hf_rrc_modeSpecificInfo_143;           /* T_modeSpecificInfo_143 */
static int hf_rrc_fdd_186;                        /* T_fdd_180 */
static int hf_rrc_ue_TransmittedPowerFDD;         /* UE_TransmittedPower */
static int hf_rrc_ue_RX_TX_ReportEntryList;       /* UE_RX_TX_ReportEntryList */
static int hf_rrc_tdd_133;                        /* T_tdd_125 */
static int hf_rrc_ue_TransmittedPowerTDD_List;    /* UE_TransmittedPowerTDD_List */
static int hf_rrc_appliedTA;                      /* UL_TimingAdvance */
static int hf_rrc_modeSpecificInfo_144;           /* T_modeSpecificInfo_144 */
static int hf_rrc_fdd_187;                        /* T_fdd_181 */
static int hf_rrc_ue_powerheadroom;               /* UE_PowerHeadroom */
static int hf_rrc_t_ADVinfo;                      /* T_ADVinfo */
static int hf_rrc_modeSpecificInfo_145;           /* T_modeSpecificInfo_145 */
static int hf_rrc_tdd384_768_03;                  /* T_tdd384_768_02 */
static int hf_rrc_appliedTA_01;                   /* EXT_UL_TimingAdvance */
static int hf_rrc_tdd128_75;                      /* T_tdd128_72 */
static int hf_rrc_t_ADVinfo_01;                   /* T_ADVinfo_ext */
static int hf_rrc_ue_InternalMeasQuantity;        /* UE_InternalMeasQuantity */
static int hf_rrc_ue_InternalReportingQuantity;   /* UE_InternalReportingQuantity */
static int hf_rrc_reportCriteria_22;              /* UE_InternalReportCriteria */
static int hf_rrc_ue_InternalReportingQuantity_01;  /* UE_InternalReportingQuantity_r4 */
static int hf_rrc_ue_InternalMeasQuantity_01;     /* UE_InternalMeasQuantity_r14 */
static int hf_rrc_ue_InternalReportingQuantity_02;  /* UE_InternalReportingQuantity_r14 */
static int hf_rrc_reportCriteria_23;              /* UE_InternalReportCriteria_r14 */
static int hf_rrc_ue_InternalMeasurementID;       /* MeasurementIdentity */
static int hf_rrc_ue_InternalReportingCriteria;   /* UE_InternalReportingCriteria */
static int hf_rrc_ue_InternalReportingCriteria_01;  /* UE_InternalReportingCriteria_r14 */
static int hf_rrc_ue_InternalEventParamList;      /* UE_InternalEventParamList */
static int hf_rrc_ue_InternalEventParamList_01;   /* UE_InternalEventParamList_r14 */
static int hf_rrc_ue_TransmittedPower;            /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_146;           /* T_modeSpecificInfo_146 */
static int hf_rrc_fdd_188;                        /* T_fdd_182 */
static int hf_rrc_ue_RX_TX_TimeDifference;        /* BOOLEAN */
static int hf_rrc_tdd_134;                        /* T_tdd_126 */
static int hf_rrc_appliedTA_bool;                 /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_147;           /* T_modeSpecificInfo_147 */
static int hf_rrc_fdd_189;                        /* T_fdd_183 */
static int hf_rrc_tdd_135;                        /* T_tdd_127 */
static int hf_rrc_tddOption_29;                   /* T_tddOption_29 */
static int hf_rrc_tdd384_50;                      /* T_tdd384_45 */
static int hf_rrc_tdd128_76;                      /* T_tdd128_73 */
static int hf_rrc_t_ADVinfo_02;                   /* BOOLEAN */
static int hf_rrc_modeSpecificInfo_148;           /* T_modeSpecificInfo_148 */
static int hf_rrc_fdd_190;                        /* T_fdd_184 */
static int hf_rrc_ue_powerheadroom_bool;          /* BOOLEAN */
static int hf_rrc_tdd_136;                        /* T_tdd_128 */
static int hf_rrc_tddOption_30;                   /* T_tddOption_30 */
static int hf_rrc_tdd384_51;                      /* T_tdd384_46 */
static int hf_rrc_tdd128_77;                      /* T_tdd128_74 */
static int hf_rrc_ue_RX_TX_TimeDifferenceType1;   /* UE_RX_TX_TimeDifferenceType1 */
static int hf_rrc_UE_RX_TX_ReportEntryList_item;  /* UE_RX_TX_ReportEntry */
static int hf_rrc_ue_RX_TX_TimeDifferenceType2;   /* UE_RX_TX_TimeDifferenceType2 */
static int hf_rrc_UE_TransmittedPowerTDD_List_item;  /* UE_TransmittedPower */
static int hf_rrc_rachorcpch;                     /* NULL */
static int hf_rrc_bds_RefTime;                    /* INTEGER_0_119 */
static int hf_rrc_bds_DBDS_InfoList;              /* DBDS_InfoList */
static int hf_rrc_cipheringKeyFlag;               /* BIT_STRING_SIZE_1 */
static int hf_rrc_cipheringSerialNumber;          /* INTEGER_0_65535 */
static int hf_rrc_dganssreferencetime;            /* INTEGER_0_119 */
static int hf_rrc_dganssInfoList;                 /* DGANSSInfoList */
static int hf_rrc_dganssInfoList_01;              /* DGANSSInfoList_r9 */
static int hf_rrc_dganssInfoList_02;              /* DGANSSInfoList_v920ext */
static int hf_rrc_errorReason;                    /* UE_Positioning_ErrorCause */
static int hf_rrc_ue_positioning_GPS_additionalAssistanceDataRequest;  /* UE_Positioning_GPS_AdditionalAssistanceDataRequest */
static int hf_rrc_errorReason_01;                 /* UE_Positioning_ErrorCause_r7 */
static int hf_rrc_ue_positioning_GANSS_additionalAssistanceDataRequest;  /* UE_Positioning_GANSS_AdditionalAssistanceDataRequest */
static int hf_rrc_ue_positioning_GANSS_additionalAssistanceDataRequest_01;  /* UE_Positioning_GANSS_AdditionalAssistanceDataRequest_v860ext */
static int hf_rrc_ue_positioning_GANSS_additionalAssistanceDataRequest_02;  /* UE_Positioning_GANSS_AdditionalAssistanceDataRequest_vc50ext */
static int hf_rrc_reportFirstFix;                 /* BOOLEAN */
static int hf_rrc_measurementInterval;            /* UE_Positioning_MeasurementInterval */
static int hf_rrc_eventSpecificInfo;              /* UE_Positioning_EventSpecificInfo */
static int hf_rrc_eventSpecificInfo_01;           /* UE_Positioning_EventSpecificInfo_r7 */
static int hf_rrc_UE_Positioning_EventParamList_item;  /* UE_Positioning_EventParam */
static int hf_rrc_UE_Positioning_EventParamList_r7_item;  /* UE_Positioning_EventParam_r7 */
static int hf_rrc_e7a;                            /* ThresholdPositionChange */
static int hf_rrc_e7b;                            /* ThresholdSFN_SFN_Change */
static int hf_rrc_e7c;                            /* ThresholdSFN_GPS_TOW */
static int hf_rrc_e7c_01;                         /* ThresholdSFN_GPS_TOW_us */
static int hf_rrc_e7d;                            /* ThresholdSFN_GANSS_TOW */
static int hf_rrc_utcModel1;                      /* UTCmodelSet1 */
static int hf_rrc_utcModel2;                      /* UTCmodelSet2 */
static int hf_rrc_utcModel3;                      /* UTCmodelSet3 */
static int hf_rrc_utcModel4;                      /* UTCmodelSet4 */
static int hf_rrc_ganss_wk_number;                /* INTEGER_0_255 */
static int hf_rrc_alm_keplerianParameters;        /* ALM_keplerianParameters */
static int hf_rrc_alm_keplerianNAVAlmanac;        /* ALM_NAVKeplerianSet */
static int hf_rrc_alm_keplerianReducedAlmanac;    /* ALM_ReducedKeplerianSet */
static int hf_rrc_alm_keplerianMidiAlmanac;       /* ALM_MidiAlmanacSet */
static int hf_rrc_alm_keplerianGLONASS;           /* ALM_GlonassAlmanacSet */
static int hf_rrc_alm_ecefSBASAlmanac;            /* ALM_ECEFsbasAlmanacSet */
static int hf_rrc_complete_Almanac_Provided;      /* BOOLEAN */
static int hf_rrc_alm_keplerianBDSAlmanac;        /* ALM_BDSKeplerianSet */
static int hf_rrc_ganssReferenceTime;             /* BOOLEAN */
static int hf_rrc_ganssreferenceLocation;         /* BOOLEAN */
static int hf_rrc_ganssIonosphericModel;          /* BOOLEAN */
static int hf_rrc_ganssRequestedGenericAssistanceDataList;  /* GanssRequestedGenericAssistanceDataList */
static int hf_rrc_ganssAddIonoModelReq;           /* BIT_STRING_SIZE_2 */
static int hf_rrc_ganssEOPreq;                    /* T_ganssEOPreq */
static int hf_rrc_ganssRequestedGenericAssistanceDataList_01;  /* GanssRequestedGenericAssistanceDataList_v860ext */
static int hf_rrc_ganssRequestedGenericAssistanceDataList_02;  /* GanssRequestedGenericAssistanceDataList_vc50ext */
static int hf_rrc_dataID_bit_string;              /* BIT_STRING_SIZE_2 */
static int hf_rrc_alpha_beta_parameters;          /* UE_Positioning_GPS_IonosphericModel */
static int hf_rrc_non_broadcastIndication;        /* T_non_broadcastIndication */
static int hf_rrc_ganssSatInfoNavList;            /* Ganss_Sat_Info_AddNavList */
static int hf_rrc_non_broadcastIndication_01;     /* T_non_broadcastIndication_01 */
static int hf_rrc_ganssSatInfoNavList_01;         /* Ganss_Sat_Info_AddNavList_r12 */
static int hf_rrc_ganssSatInfoNavList_02;         /* Ganss_Sat_Info_AddNavList_vc50ext */
static int hf_rrc_ue_positioning_GANSS_ReferenceTime;  /* UE_Positioning_GANSS_ReferenceTime */
static int hf_rrc_uePositioningGanssReferencePosition;  /* ReferenceLocationGANSS */
static int hf_rrc_uePositioningGanssIonosphericModel;  /* UE_Positioning_GANSS_IonosphericModel */
static int hf_rrc_ganssGenericDataList;           /* GANSSGenericDataList */
static int hf_rrc_uePositioningGanssAddIonoModel;  /* UE_Positioning_GANSS_AddIonoModel */
static int hf_rrc_uePositioningGanssEarthOrientationPara;  /* UE_Positioning_GANSS_EarthOrientPara */
static int hf_rrc_ganssGenericDataList_01;        /* GANSSGenericDataList_v860ext */
static int hf_rrc_ganssGenericDataList_02;        /* GANSSGenericDataList_r8 */
static int hf_rrc_ganssGenericDataList_03;        /* GANSSGenericDataList_r9 */
static int hf_rrc_ganssGenericDataList_04;        /* GANSSGenericDataList_v920ext */
static int hf_rrc_ue_positioning_GANSS_ReferenceTime_01;  /* UE_Positioning_GANSS_ReferenceTime_va40ext */
static int hf_rrc_ganssGenericDataList_05;        /* GANSSGenericDataList_va40ext */
static int hf_rrc_ganssGenericDataList_06;        /* GANSSGenericDataList_vc50ext */
static int hf_rrc_ue_positioning_GANSS_ReferenceTime_02;  /* UE_Positioning_GANSS_ReferenceTime_r10 */
static int hf_rrc_ganssGenericDataList_07;        /* GANSSGenericDataList_r10 */
static int hf_rrc_ganssGenericDataList_08;        /* GANSSGenericDataList_r12 */
static int hf_rrc_ganssID1;                       /* AuxInfoGANSS_ID1 */
static int hf_rrc_ganssID3;                       /* AuxInfoGANSS_ID3 */
static int hf_rrc_satellite_clock_modelList;      /* Satellite_clock_modelList */
static int hf_rrc_navClockModel;                  /* NAVclockModel */
static int hf_rrc_cnavClockModel;                 /* CNAVclockModel */
static int hf_rrc_glonassClockModel;              /* GLONASSclockModel */
static int hf_rrc_sbasClockModel;                 /* SBASclockModel */
static int hf_rrc_bdsClockModel;                  /* BDSclockModel */
static int hf_rrc_navKeplerianSet;                /* NavModel_NAVKeplerianSet */
static int hf_rrc_cnavKeplerianSet;               /* NavModel_CNAVKeplerianSet */
static int hf_rrc_glonassECEF;                    /* NavModel_GLONASSecef */
static int hf_rrc_sbasECEF;                       /* NavModel_SBASecef */
static int hf_rrc_bdsKeplerianSet;                /* NavModel_BDSKeplerianSet */
static int hf_rrc_ganss_tod;                      /* INTEGER_0_59 */
static int hf_rrc_dataBitAssistanceList;          /* DataBitAssistanceList */
static int hf_rrc_teop;                           /* BIT_STRING_SIZE_16 */
static int hf_rrc_pmX;                            /* BIT_STRING_SIZE_21 */
static int hf_rrc_pmXdot;                         /* BIT_STRING_SIZE_15 */
static int hf_rrc_pmY;                            /* BIT_STRING_SIZE_21 */
static int hf_rrc_pmYdot;                         /* BIT_STRING_SIZE_15 */
static int hf_rrc_deltaUT1;                       /* BIT_STRING_SIZE_31 */
static int hf_rrc_deltaUT1dot;                    /* BIT_STRING_SIZE_19 */
static int hf_rrc_alpha_zero_ionos;               /* BIT_STRING_SIZE_11 */
static int hf_rrc_alpha_one_ionos;                /* BIT_STRING_SIZE_11 */
static int hf_rrc_alpha_two_ionos;                /* BIT_STRING_SIZE_14 */
static int hf_rrc_gANSS_storm_flags;              /* GANSS_Storm_Flag */
static int hf_rrc_bds_IGPInfoList;                /* BDS_IGPInfoList */
static int hf_rrc_referenceTime;                  /* T_referenceTime */
static int hf_rrc_utran_GANSSReferenceTimeResult;  /* UTRAN_GANSSReferenceTime */
static int hf_rrc_ganssReferenceTimeOnly;         /* GANSSReferenceTimeOnly */
static int hf_rrc_ganssGenericMeasurementInfo;    /* GANSSGenericMeasurementInfo */
static int hf_rrc_ganssGenericMeasurementInfo_01;  /* GANSSGenericMeasurementInfo_v860ext */
static int hf_rrc_non_broadcastIndication_02;     /* T_non_broadcastIndication_02 */
static int hf_rrc_ganssSatInfoNavList_03;         /* Ganss_Sat_Info_NavList */
static int hf_rrc_keplerianParameters;            /* KeplerianParameters */
static int hf_rrc_UE_Positioning_GANSS_RealTimeIntegrity_item;  /* UE_Positioning_GANSS_RealTimeIntegrity_item */
static int hf_rrc_bad_ganss_satId;                /* INTEGER_0_63 */
static int hf_rrc_bad_ganss_signalId;             /* BIT_STRING_SIZE_8 */
static int hf_rrc_satelliteInformationList;       /* GANSSSatelliteInformationList */
static int hf_rrc_satelliteInformationList_01;    /* GANSSSatelliteInformationList_va40ext */
static int hf_rrc_satelliteInformationList_02;    /* GANSSSatelliteInformationList_r10 */
static int hf_rrc_satelliteInformationList_03;    /* GANSSSatelliteInformationList_vc50ext */
static int hf_rrc_satelliteInformationList_04;    /* GANSSSatelliteInformationList_r12 */
static int hf_rrc_ganssDay;                       /* INTEGER_0_8191 */
static int hf_rrc_ganssTodUncertainty;            /* INTEGER_0_127 */
static int hf_rrc_ganssTimeId;                    /* INTEGER_0_7 */
static int hf_rrc_utran_ganssreferenceTime;       /* T_utran_ganssreferenceTime */
static int hf_rrc_timingOfCellFrames;             /* INTEGER_0_3999999 */
static int hf_rrc_mode;                           /* T_mode */
static int hf_rrc_fdd_191;                        /* T_fdd_185 */
static int hf_rrc_primary_CPICH_Info;             /* PrimaryCPICH_Info */
static int hf_rrc_tdd_137;                        /* T_tdd_129 */
static int hf_rrc_cellParameters;                 /* CellParametersID */
static int hf_rrc_referenceSfn;                   /* INTEGER_0_4095 */
static int hf_rrc_tutran_ganss_driftRate;         /* Tutran_Ganss_DriftRate */
static int hf_rrc_ganss_Day_Cycle_Number;         /* INTEGER_0_7 */
static int hf_rrc_utran_ganssreferenceTime_01;    /* T_utran_ganssreferenceTime_01 */
static int hf_rrc_mode_01;                        /* T_mode_01 */
static int hf_rrc_fdd_192;                        /* T_fdd_186 */
static int hf_rrc_tdd_138;                        /* T_tdd_130 */
static int hf_rrc_ganss_timeModelreferenceTime;   /* INTEGER_0_37799 */
static int hf_rrc_ganss_t_a0;                     /* INTEGER_M2147483648_2147483647 */
static int hf_rrc_ganss_t_a1;                     /* INTEGER_M8388608_8388607 */
static int hf_rrc_ganss_t_a2;                     /* INTEGER_M64_63 */
static int hf_rrc_gnss_to_id;                     /* T_gnss_to_id */
static int hf_rrc_ganss_wk_number_01;             /* INTEGER_0_8191 */
static int hf_rrc_deltaT;                         /* INTEGER_M128_127 */
static int hf_rrc_gnss_to_id_01;                  /* T_gnss_to_id_01 */
static int hf_rrc_UE_Positioning_GANSS_TimeModels_item;  /* UE_Positioning_GANSS_TimeModel */
static int hf_rrc_UE_Positioning_GANSS_TimeModels_va40ext_item;  /* UE_Positioning_GANSS_TimeModel_va40ext */
static int hf_rrc_a_one_utc;                      /* BIT_STRING_SIZE_24 */
static int hf_rrc_a_zero_utc;                     /* BIT_STRING_SIZE_32 */
static int hf_rrc_t_ot_utc;                       /* BIT_STRING_SIZE_8 */
static int hf_rrc_delta_t_ls_utc;                 /* BIT_STRING_SIZE_8 */
static int hf_rrc_w_n_t_utc;                      /* BIT_STRING_SIZE_8 */
static int hf_rrc_w_n_lsf_utc;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_dn_utc;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_delta_t_lsf_utc;                /* BIT_STRING_SIZE_8 */
static int hf_rrc_gps_ReferenceTime;              /* GPS_TOW_1msec */
static int hf_rrc_utran_GPSReferenceTime;         /* UTRAN_GPSReferenceTime */
static int hf_rrc_satelliteInformationList_05;    /* AcquisitionSatInfoList */
static int hf_rrc_ue_Positioning_GPS_ReferenceTimeUncertainty;  /* UE_Positioning_GPS_ReferenceTimeUncertainty */
static int hf_rrc_satelliteInformationList_06;    /* AcquisitionSatInfoList_va40ext */
static int hf_rrc_satelliteInformationList_07;    /* AcquisitionSatInfoList_r10 */
static int hf_rrc_satelliteInformationList_08;    /* AcquisitionSatInfoList_vc50ext */
static int hf_rrc_satelliteInformationList_09;    /* AcquisitionSatInfoList_r12 */
static int hf_rrc_almanacRequest;                 /* BOOLEAN */
static int hf_rrc_utcModelRequest;                /* BOOLEAN */
static int hf_rrc_ionosphericModelRequest;        /* BOOLEAN */
static int hf_rrc_navigationModelRequest;         /* BOOLEAN */
static int hf_rrc_dgpsCorrectionsRequest;         /* BOOLEAN */
static int hf_rrc_referenceLocationRequest;       /* BOOLEAN */
static int hf_rrc_referenceTimeRequest;           /* BOOLEAN */
static int hf_rrc_aquisitionAssistanceRequest;    /* BOOLEAN */
static int hf_rrc_realTimeIntegrityRequest;       /* BOOLEAN */
static int hf_rrc_navModelAddDataRequest;         /* UE_Positioning_GPS_NavModelAddDataReq */
static int hf_rrc_wn_a;                           /* BIT_STRING_SIZE_8 */
static int hf_rrc_almanacSatInfoList;             /* AlmanacSatInfoList */
static int hf_rrc_sv_GlobalHealth;                /* BIT_STRING_SIZE_364 */
static int hf_rrc_ue_positioning_GPS_ReferenceTime;  /* UE_Positioning_GPS_ReferenceTime */
static int hf_rrc_ue_positioning_GPS_ReferenceLocation;  /* ReferenceLocation */
static int hf_rrc_ue_positioning_GPS_DGPS_Corrections;  /* UE_Positioning_GPS_DGPS_Corrections */
static int hf_rrc_ue_positioning_GPS_NavigationModel;  /* UE_Positioning_GPS_NavigationModel */
static int hf_rrc_ue_positioning_GPS_IonosphericModel;  /* UE_Positioning_GPS_IonosphericModel */
static int hf_rrc_ue_positioning_GPS_UTC_Model;   /* UE_Positioning_GPS_UTC_Model */
static int hf_rrc_ue_positioning_GPS_Almanac;     /* UE_Positioning_GPS_Almanac */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance;  /* UE_Positioning_GPS_AcquisitionAssistance */
static int hf_rrc_ue_positioning_GPS_Real_timeIntegrity;  /* BadSatList */
static int hf_rrc_uE_Positioning_GPS_ReferenceCellInfo;  /* UE_Positioning_GPS_ReferenceCellInfo */
static int hf_rrc_ue_positioning_GPS_ReferenceTime_01;  /* UE_Positioning_GPS_ReferenceTime_v770ext */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_01;  /* UE_Positioning_GPS_AcquisitionAssistance_v770ext */
static int hf_rrc_ue_positioning_GPS_ReferenceTime_02;  /* UE_Positioning_GPS_ReferenceTime_r7 */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_02;  /* UE_Positioning_GPS_AcquisitionAssistance_r7 */
static int hf_rrc_ue_positioning_GPS_DGPS_Corrections_01;  /* UE_Positioning_GPS_DGPS_Corrections_r9 */
static int hf_rrc_ue_positioning_GPS_DGPS_Corrections_02;  /* UE_Positioning_GPS_DGPS_Corrections_v920ext */
static int hf_rrc_ue_positioning_GPS_ReferenceTime_03;  /* UE_Positioning_GPS_ReferenceTime_va40ext */
static int hf_rrc_ue_positioning_GPS_Almanac_01;  /* UE_Positioning_GPS_Almanac_va40ext */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_03;  /* UE_Positioning_GPS_AcquisitionAssistance_va40ext */
static int hf_rrc_ue_positioning_GPS_ReferenceTime_04;  /* UE_Positioning_GPS_ReferenceTime_r10 */
static int hf_rrc_ue_positioning_GPS_Almanac_02;  /* UE_Positioning_GPS_Almanac_r10 */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_04;  /* UE_Positioning_GPS_AcquisitionAssistance_r10 */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_05;  /* UE_Positioning_GPS_AcquisitionAssistance_vc50ext */
static int hf_rrc_ue_positioning_GPS_AcquisitionAssistance_06;  /* UE_Positioning_GPS_AcquisitionAssistance_r12 */
static int hf_rrc_gps_TOW;                        /* GPS_TOW_1sec */
static int hf_rrc_statusHealth;                   /* DiffCorrectionStatus */
static int hf_rrc_dgps_CorrectionSatInfoList;     /* DGPS_CorrectionSatInfoList */
static int hf_rrc_dgps_CorrectionSatInfoList_01;  /* DGPS_CorrectionSatInfoList_r9 */
static int hf_rrc_dgps_CorrectionSatInfoList_02;  /* DGPS_CorrectionSatInfoList_v920ext */
static int hf_rrc_alpha0;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_alpha1;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_alpha2;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_alpha3;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_beta0;                          /* BIT_STRING_SIZE_8 */
static int hf_rrc_beta1;                          /* BIT_STRING_SIZE_8 */
static int hf_rrc_beta2;                          /* BIT_STRING_SIZE_8 */
static int hf_rrc_beta3;                          /* BIT_STRING_SIZE_8 */
static int hf_rrc_referenceTime_01;               /* T_referenceTime_01 */
static int hf_rrc_utran_GPSReferenceTimeResult;   /* UTRAN_GPSReferenceTimeResult */
static int hf_rrc_gps_ReferenceTimeOnly;          /* GPS_TOW_1msec */
static int hf_rrc_gps_MeasurementParamList;       /* GPS_MeasurementParamList */
static int hf_rrc_navigationModelSatInfoList;     /* NavigationModelSatInfoList */
static int hf_rrc_gps_Week;                       /* INTEGER_0_1023 */
static int hf_rrc_gps_Toe;                        /* INTEGER_0_255 */
static int hf_rrc_tToeLimit;                      /* INTEGER_0_15 */
static int hf_rrc_satDataList;                    /* SatDataList */
static int hf_rrc_modeSpecificInfo_149;           /* T_modeSpecificInfo_149 */
static int hf_rrc_fdd_193;                        /* T_fdd_187 */
static int hf_rrc_referenceIdentity;              /* PrimaryCPICH_Info */
static int hf_rrc_tdd_139;                        /* T_tdd_131 */
static int hf_rrc_referenceIdentity_01;           /* CellParametersID */
static int hf_rrc_gps_tow_1msec;                  /* GPS_TOW_1msec */
static int hf_rrc_sfn_tow_Uncertainty;            /* SFN_TOW_Uncertainty */
static int hf_rrc_utran_GPS_DriftRate;            /* UTRAN_GPS_DriftRate */
static int hf_rrc_gps_TOW_AssistList;             /* GPS_TOW_AssistList */
static int hf_rrc_gps_Week_Cycle_Number;          /* INTEGER_0_7 */
static int hf_rrc_a1;                             /* BIT_STRING_SIZE_24 */
static int hf_rrc_a0;                             /* BIT_STRING_SIZE_32 */
static int hf_rrc_t_ot;                           /* BIT_STRING_SIZE_8 */
static int hf_rrc_wn_t;                           /* BIT_STRING_SIZE_8 */
static int hf_rrc_delta_t_LS;                     /* BIT_STRING_SIZE_8 */
static int hf_rrc_wn_lsf;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_dn;                             /* BIT_STRING_SIZE_8 */
static int hf_rrc_delta_t_LSF;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_ip_Spacing;                     /* IP_Spacing */
static int hf_rrc_ip_Length;                      /* IP_Length */
static int hf_rrc_ip_Offset;                      /* INTEGER_0_9 */
static int hf_rrc_seed;                           /* INTEGER_0_63 */
static int hf_rrc_burstModeParameters;            /* BurstModeParameters */
static int hf_rrc_modeSpecificInfo_150;           /* T_modeSpecificInfo_150 */
static int hf_rrc_fdd_194;                        /* T_fdd_188 */
static int hf_rrc_tdd_140;                        /* T_tdd_132 */
static int hf_rrc_ip_Spacing_TDD;                 /* IP_Spacing_TDD */
static int hf_rrc_ip_slot;                        /* INTEGER_0_14 */
static int hf_rrc_ip_Start;                       /* INTEGER_0_4095 */
static int hf_rrc_ip_PCCPCG;                      /* IP_PCCPCH_r4 */
static int hf_rrc_ip_Spacing_01;                  /* IP_Spacing_TDD */
static int hf_rrc_ue_positioning_OTDOA_Measurement;  /* UE_Positioning_OTDOA_Measurement */
static int hf_rrc_ue_positioning_PositionEstimateInfo;  /* UE_Positioning_PositionEstimateInfo */
static int hf_rrc_ue_positioning_GPS_Measurement;  /* UE_Positioning_GPS_MeasurementResults */
static int hf_rrc_ue_positioning_Error;           /* UE_Positioning_Error */
static int hf_rrc_ue_positioning_PositionEstimateInfo_01;  /* UE_Positioning_PositionEstimateInfo_v770ext */
static int hf_rrc_ue_positioning_GPS_Measurement_01;  /* UE_Positioning_GPS_MeasurementResults_v770ext */
static int hf_rrc_ue_positioning_Error_01;        /* UE_Positioning_Error_r7 */
static int hf_rrc_ue_positioning_Ganss_MeasuredResults;  /* UE_Positioning_GANSS_MeasuredResults */
static int hf_rrc_ue_Positioning_OTDOA_Measurement_v390ext;  /* UE_Positioning_OTDOA_Measurement_v390ext */
static int hf_rrc_ue_positioning_Error_02;        /* UE_Positioning_Error_v860ext */
static int hf_rrc_ue_positioning_Ganss_MeasurementResults;  /* UE_Positioning_GANSS_MeasuredResults_v860ext */
static int hf_rrc_ue_positioning_Error_03;        /* UE_Positioning_Error_vc50ext */
static int hf_rrc_ue_positioning_AddPos_MeasurementResults;  /* UE_Positioning_AddPos_MeasuredResults */
static int hf_rrc_ue_positioning_PositionEstimateInfo_02;  /* UE_Positioning_PositionEstimateInfo_vd20ext */
static int hf_rrc_ue_positioning_ReportingQuantity;  /* UE_Positioning_ReportingQuantity */
static int hf_rrc_reportCriteria_24;              /* UE_Positioning_ReportCriteria */
static int hf_rrc_ue_positioning_OTDOA_AssistanceData;  /* UE_Positioning_OTDOA_AssistanceData */
static int hf_rrc_ue_positioning_ReportingQuantity_v390ext;  /* UE_Positioning_ReportingQuantity_v390ext */
static int hf_rrc_ue_positioning_ReportingQuantity_01;  /* UE_Positioning_ReportingQuantity_r4 */
static int hf_rrc_ue_positioning_OTDOA_AssistanceData_01;  /* UE_Positioning_OTDOA_AssistanceData_r4 */
static int hf_rrc_ue_positioning_ReportingQuantity_02;  /* UE_Positioning_ReportingQuantity_r7 */
static int hf_rrc_reportCriteria_25;              /* UE_Positioning_ReportCriteria_r7 */
static int hf_rrc_ue_positioning_OTDOA_AssistanceData_02;  /* UE_Positioning_OTDOA_AssistanceData_r7 */
static int hf_rrc_ue_positioning_GPS_AssistanceData_01;  /* UE_Positioning_GPS_AssistanceData_r7 */
static int hf_rrc_ue_positioning_ReportingQuantity_03;  /* UE_Positioning_ReportingQuantity_r8 */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_01;  /* UE_Positioning_GANSS_AssistanceData_r8 */
static int hf_rrc_ue_positioning_GPS_AssistanceData_02;  /* UE_Positioning_GPS_AssistanceData_r9 */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_02;  /* UE_Positioning_GANSS_AssistanceData_r9 */
static int hf_rrc_ue_positioning_GPS_AssistanceData_03;  /* UE_Positioning_GPS_AssistanceData_r10 */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_03;  /* UE_Positioning_GANSS_AssistanceData_r10 */
static int hf_rrc_ue_positioning_GPS_AssistanceData_04;  /* UE_Positioning_GPS_AssistanceData_r12 */
static int hf_rrc_ue_positioning_GANSS_AssistanceData_04;  /* UE_Positioning_GANSS_AssistanceData_r12 */
static int hf_rrc_ue_positioning_ReportingQuantity_04;  /* UE_Positioning_ReportingQuantity_r13 */
static int hf_rrc_event7a;                        /* UE_Positioning_PositionEstimateInfo */
static int hf_rrc_event7b;                        /* UE_Positioning_OTDOA_Measurement */
static int hf_rrc_event7c;                        /* UE_Positioning_GPS_MeasurementResults */
static int hf_rrc_additionalOrReplacedPosMeasEvent;  /* NULL */
static int hf_rrc_event7a_01;                     /* UE_Positioning_PositionEstimateInfo_v770ext */
static int hf_rrc_event7c_01;                     /* UE_Positioning_GPS_MeasurementResults_v770ext */
static int hf_rrc_event7d;                        /* UE_Positioning_GANSS_MeasuredResults */
static int hf_rrc_event7d_01;                     /* UE_Positioning_GANSS_MeasuredResults_v860ext */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo;  /* UE_Positioning_OTDOA_ReferenceCellInfo */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList;  /* UE_Positioning_OTDOA_NeighbourCellList */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo_01;  /* UE_Positioning_OTDOA_ReferenceCellInfo_r4 */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList_01;  /* UE_Positioning_OTDOA_NeighbourCellList_r4 */
static int hf_rrc_ue_Positioning_IPDL_Parameters_TDD_r4_ext;  /* UE_Positioning_IPDL_Parameters_TDD_r4_ext */
static int hf_rrc_ue_Positioning_IPDL_Parameters_TDDList_r4_ext;  /* UE_Positioning_IPDL_Parameters_TDDList_r4_ext */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo_UEB;  /* UE_Positioning_OTDOA_ReferenceCellInfo_UEB */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList_UEB;  /* UE_Positioning_OTDOA_NeighbourCellList_UEB */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo_UEB_ext;  /* UE_Positioning_OTDOA_ReferenceCellInfo_UEB_ext */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList_UEB_ext;  /* UE_Positioning_OTDOA_NeighbourCellList_UEB_ext */
static int hf_rrc_ue_positioning_OTDOA_ReferenceCellInfo_02;  /* UE_Positioning_OTDOA_ReferenceCellInfo_r7 */
static int hf_rrc_ue_positioning_OTDOA_NeighbourCellList_02;  /* UE_Positioning_OTDOA_NeighbourCellList_r7 */
static int hf_rrc_UE_Positioning_IPDL_Parameters_TDDList_r4_ext_item;  /* UE_Positioning_IPDL_Parameters_TDD_r4_ext */
static int hf_rrc_neighbourList;                  /* NeighbourList_TDD_r7 */
static int hf_rrc_modeSpecificInfo_151;           /* T_modeSpecificInfo_151 */
static int hf_rrc_fdd_195;                        /* T_fdd_189 */
static int hf_rrc_referenceCellIDentity;          /* PrimaryCPICH_Info */
static int hf_rrc_ue_RX_TX_TimeDifferenceType2Info;  /* UE_RX_TX_TimeDifferenceType2Info */
static int hf_rrc_tdd_141;                        /* T_tdd_133 */
static int hf_rrc_referenceCellIdentity;          /* CellParametersID */
static int hf_rrc_neighbourList_01;               /* NeighbourList */
static int hf_rrc_neighbourList_v390ext;          /* NeighbourList_v390ext */
static int hf_rrc_modeSpecificInfo_152;           /* T_modeSpecificInfo_152 */
static int hf_rrc_fdd_196;                        /* T_fdd_190 */
static int hf_rrc_tdd_142;                        /* T_tdd_134 */
static int hf_rrc_cellAndChannelIdentity;         /* CellAndChannelIdentity */
static int hf_rrc_ue_positioning_IPDL_Paremeters;  /* UE_Positioning_IPDL_Parameters */
static int hf_rrc_sfn_SFN_RelTimeDifference;      /* SFN_SFN_RelTimeDifference1 */
static int hf_rrc_sfn_SFN_Drift;                  /* SFN_SFN_Drift */
static int hf_rrc_searchWindowSize;               /* OTDOA_SearchWindowSize */
static int hf_rrc_positioningMode;                /* T_positioningMode */
static int hf_rrc_ueBased;                        /* T_ueBased */
static int hf_rrc_ueAssisted;                     /* T_ueAssisted */
static int hf_rrc_modeSpecificInfo_153;           /* T_modeSpecificInfo_153 */
static int hf_rrc_fdd_197;                        /* T_fdd_191 */
static int hf_rrc_tdd_143;                        /* T_tdd_135 */
static int hf_rrc_ue_positioning_IPDL_Paremeters_01;  /* UE_Positioning_IPDL_Parameters_r4 */
static int hf_rrc_positioningMode_01;             /* T_positioningMode_01 */
static int hf_rrc_ueBased_01;                     /* T_ueBased_01 */
static int hf_rrc_relativeNorth;                  /* INTEGER_M20000_20000 */
static int hf_rrc_relativeEast;                   /* INTEGER_M20000_20000 */
static int hf_rrc_relativeAltitude;               /* INTEGER_M4000_4000 */
static int hf_rrc_fineSFN_SFN;                    /* FineSFN_SFN */
static int hf_rrc_roundTripTime;                  /* INTEGER_0_32766 */
static int hf_rrc_ueAssisted_01;                  /* T_ueAssisted_01 */
static int hf_rrc_modeSpecificInfo_154;           /* T_modeSpecificInfo_154 */
static int hf_rrc_fdd_198;                        /* T_fdd_192 */
static int hf_rrc_tdd_144;                        /* T_tdd_136 */
static int hf_rrc_roundTripTimeExtension;         /* INTEGER_0_70274 */
static int hf_rrc_modeSpecificInfo_155;           /* T_modeSpecificInfo_155 */
static int hf_rrc_fdd_199;                        /* T_fdd_193 */
static int hf_rrc_tdd_145;                        /* T_tdd_137 */
static int hf_rrc_positioningMode_02;             /* T_positioningMode_02 */
static int hf_rrc_ueBased_02;                     /* T_ueBased_02 */
static int hf_rrc_ueAssisted_02;                  /* T_ueAssisted_02 */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_item;  /* UE_Positioning_OTDOA_NeighbourCellInfo */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_r4_item;  /* UE_Positioning_OTDOA_NeighbourCellInfo_r4 */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_UEB_item;  /* UE_Positioning_OTDOA_NeighbourCellInfo_UEB */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_UEB_ext_item;  /* UE_Positioning_OTDOA_NeighbourCellInfo_UEB_ext */
static int hf_rrc_UE_Positioning_OTDOA_NeighbourCellList_r7_item;  /* UE_Positioning_OTDOA_NeighbourCellInfo_r7 */
static int hf_rrc_stdResolution;                  /* BIT_STRING_SIZE_2 */
static int hf_rrc_numberOfOTDOA_Measurements;     /* BIT_STRING_SIZE_3 */
static int hf_rrc_stdOfOTDOA_Measurements;        /* BIT_STRING_SIZE_5 */
static int hf_rrc_modeSpecificInfo_156;           /* T_modeSpecificInfo_156 */
static int hf_rrc_fdd_200;                        /* T_fdd_194 */
static int hf_rrc_tdd_146;                        /* T_tdd_138 */
static int hf_rrc_positioningMode_03;             /* T_positioningMode_03 */
static int hf_rrc_ueBased_03;                     /* T_ueBased_03 */
static int hf_rrc_ueAssisted_03;                  /* T_ueAssisted_03 */
static int hf_rrc_modeSpecificInfo_157;           /* T_modeSpecificInfo_157 */
static int hf_rrc_fdd_201;                        /* T_fdd_195 */
static int hf_rrc_tdd_147;                        /* T_tdd_139 */
static int hf_rrc_positioningMode_04;             /* T_positioningMode_04 */
static int hf_rrc_ueBased_04;                     /* T_ueBased_04 */
static int hf_rrc_cellPosition;                   /* ReferenceCellPosition */
static int hf_rrc_ueAssisted_04;                  /* T_ueAssisted_04 */
static int hf_rrc_modeSpecificInfo_158;           /* T_modeSpecificInfo_158 */
static int hf_rrc_fdd_202;                        /* T_fdd_196 */
static int hf_rrc_tdd_148;                        /* T_tdd_140 */
static int hf_rrc_modeSpecificInfo_159;           /* T_modeSpecificInfo_159 */
static int hf_rrc_fdd_203;                        /* T_fdd_197 */
static int hf_rrc_tdd_149;                        /* T_tdd_141 */
static int hf_rrc_positioningMode_05;             /* T_positioningMode_05 */
static int hf_rrc_ueBased_05;                     /* T_ueBased_05 */
static int hf_rrc_ueAssisted_05;                  /* T_ueAssisted_05 */
static int hf_rrc_referenceTime_02;               /* T_referenceTime_02 */
static int hf_rrc_cell_Timing;                    /* T_cell_Timing */
static int hf_rrc_modeSpecificInfo_160;           /* T_modeSpecificInfo_160 */
static int hf_rrc_fdd_204;                        /* T_fdd_198 */
static int hf_rrc_tdd_150;                        /* T_tdd_142 */
static int hf_rrc_positionEstimate;               /* PositionEstimate */
static int hf_rrc_referenceTimeOptions;           /* T_referenceTimeOptions */
static int hf_rrc_earlier_than_r7;                /* NULL */
static int hf_rrc_r7_15;                          /* T_r7_15 */
static int hf_rrc_referenceTime_03;               /* T_referenceTime_03 */
static int hf_rrc_positionData;                   /* BIT_STRING_SIZE_16 */
static int hf_rrc_velocityEstimate;               /* VelocityEstimate */
static int hf_rrc_locationTimeStamp;              /* UTCTime */
static int hf_rrc_ue_positioning_ReportingCriteria;  /* UE_Positioning_EventParamList */
static int hf_rrc_ue_positioning_ReportingCriteria_01;  /* UE_Positioning_EventParamList_r7 */
static int hf_rrc_methodType;                     /* UE_Positioning_MethodType */
static int hf_rrc_positioningMethod;              /* PositioningMethod */
static int hf_rrc_uE_Positioning_ResponseTime;    /* UE_Positioning_ResponseTime */
static int hf_rrc_horizontal_Accuracy;            /* UE_Positioning_Accuracy */
static int hf_rrc_gps_TimingOfCellWanted;         /* BOOLEAN */
static int hf_rrc_additionalAssistanceDataRequest;  /* BOOLEAN */
static int hf_rrc_environmentCharacterisation;    /* EnvironmentCharacterisation */
static int hf_rrc_vertical_Accuracy;              /* UE_Positioning_Accuracy */
static int hf_rrc_horizontalAccuracy;             /* UE_Positioning_Accuracy */
static int hf_rrc_verticalAccuracy;               /* UE_Positioning_Accuracy */
static int hf_rrc_additionalAssistanceDataReq;    /* BOOLEAN */
static int hf_rrc_velocityRequested;              /* T_velocityRequested */
static int hf_rrc_gANSSPositioningMethods;        /* BIT_STRING_SIZE_16 */
static int hf_rrc_gANSSTimingOfCellWanted;        /* BIT_STRING_SIZE_8 */
static int hf_rrc_gANSSCarrierPhaseMeasurementRequested;  /* BIT_STRING_SIZE_8 */
static int hf_rrc_velocityRequested_01;           /* T_velocityRequested_01 */
static int hf_rrc_gANSSMultiFreqMeasurementRequested;  /* BIT_STRING_SIZE_8 */
static int hf_rrc_velocityRequested_02;           /* T_velocityRequested_02 */
static int hf_rrc_additionalPositioningMethods;   /* BIT_STRING_SIZE_8 */
static int hf_rrc_UE_Positioning_AddPos_MeasuredResults_item;  /* UE_Positioning_AddPos_MeasuredResults_element */
static int hf_rrc_timestamp;                      /* UTCTime */
static int hf_rrc_addPos_ID_01;                   /* T_addPos_ID_01 */
static int hf_rrc_barometricPressure;             /* UE_Positioning_BarometricPressureMeasurement */
static int hf_rrc_wlan;                           /* UE_Positioning_WLANMeasurementList */
static int hf_rrc_bt;                             /* UE_Positioning_BTMeasurementList */
static int hf_rrc_mbs;                            /* UE_Positioning_MBSMeasurementList */
static int hf_rrc_ubpMeasurement;                 /* INTEGER_30000_115000 */
static int hf_rrc_UE_Positioning_WLANMeasurementList_item;  /* UE_Positioning_WLANMeasurementList_element */
static int hf_rrc_wlanBSSID;                      /* OCTET_STRING_SIZE_6 */
static int hf_rrc_wlanSSID;                       /* OCTET_STRING_SIZE_1_32 */
static int hf_rrc_wlanRSSI;                       /* INTEGER_M127_128 */
static int hf_rrc_wlanRTTvalue;                   /* INTEGER_0_16777215 */
static int hf_rrc_wlanRTTunits;                   /* T_wlanRTTunits */
static int hf_rrc_wlanRTTaccuracy;                /* INTEGER_0_255 */
static int hf_rrc_wlanAPChannelFrequency;         /* INTEGER_0_256 */
static int hf_rrc_wlanServingFlag;                /* BOOLEAN */
static int hf_rrc_UE_Positioning_BTMeasurementList_item;  /* UE_Positioning_BTMeasurementList_element */
static int hf_rrc_btAddr;                         /* OCTET_STRING_SIZE_6 */
static int hf_rrc_btRSSI;                         /* INTEGER_M127_128 */
static int hf_rrc_UE_Positioning_MBSMeasurementList_item;  /* UE_Positioning_MBSMeasurementList_element */
static int hf_rrc_transmitterId;                  /* INTEGER_0_32767 */
static int hf_rrc_codePhase_02;                   /* INTEGER_0_2097151 */
static int hf_rrc_utcA0;                          /* BIT_STRING_SIZE_16 */
static int hf_rrc_utcA1;                          /* BIT_STRING_SIZE_13 */
static int hf_rrc_utcA2;                          /* BIT_STRING_SIZE_7 */
static int hf_rrc_utcDeltaTls;                    /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcTot;                         /* BIT_STRING_SIZE_16 */
static int hf_rrc_utcWNot;                        /* BIT_STRING_SIZE_13 */
static int hf_rrc_utcWNlsf;                       /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcDN;                          /* BIT_STRING_SIZE_4 */
static int hf_rrc_utcDeltaTlsf;                   /* BIT_STRING_SIZE_8 */
static int hf_rrc_nA;                             /* BIT_STRING_SIZE_11 */
static int hf_rrc_tauC;                           /* BIT_STRING_SIZE_32 */
static int hf_rrc_deltaUT1_01;                    /* DeltaUT1 */
static int hf_rrc_kp;                             /* BIT_STRING_SIZE_2 */
static int hf_rrc_utcA1wnt;                       /* BIT_STRING_SIZE_24 */
static int hf_rrc_utcA0wnt;                       /* BIT_STRING_SIZE_32 */
static int hf_rrc_utcTot_01;                      /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcWNt;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcDN_01;                       /* BIT_STRING_SIZE_8 */
static int hf_rrc_utcStandardID;                  /* BIT_STRING_SIZE_3 */
static int hf_rrc_utcA0_01;                       /* BIT_STRING_SIZE_32 */
static int hf_rrc_utcA1_01;                       /* BIT_STRING_SIZE_24 */
static int hf_rrc_ue_GANSSTimingOfCellFrames;     /* T_ue_GANSSTimingOfCellFrames */
static int hf_rrc_ms_Part;                        /* INTEGER_0_80 */
static int hf_rrc_ls_Part;                        /* INTEGER_0_4294967295 */
static int hf_rrc_gANSS_TimeId;                   /* INTEGER_0_7 */
static int hf_rrc_gANSS_TimeUncertainty;          /* INTEGER_0_127 */
static int hf_rrc_mode_02;                        /* T_mode_02 */
static int hf_rrc_fdd_205;                        /* T_fdd_199 */
static int hf_rrc_tdd_151;                        /* T_tdd_143 */
static int hf_rrc_UTRAN_FDD_FrequencyList_item;   /* UTRAN_FDD_Frequency */
static int hf_rrc_qQualMinFDD;                    /* INTEGER_M24_0 */
static int hf_rrc_qRxLevMinFDD;                   /* INTEGER_M60_M13 */
static int hf_rrc_UTRAN_TDD_FrequencyList_item;   /* UTRAN_TDD_Frequency */
static int hf_rrc_qRxLevMinTDD;                   /* INTEGER_M60_M13 */
static int hf_rrc_utran_GPSTimingOfCell;          /* T_utran_GPSTimingOfCell */
static int hf_rrc_ms_part;                        /* INTEGER_0_1023 */
static int hf_rrc_ls_part;                        /* INTEGER_0_4294967295 */
static int hf_rrc_modeSpecificInfo_161;           /* T_modeSpecificInfo_161 */
static int hf_rrc_fdd_206;                        /* T_fdd_200 */
static int hf_rrc_tdd_152;                        /* T_tdd_144 */
static int hf_rrc_ue_GPSTimingOfCell;             /* T_ue_GPSTimingOfCell */
static int hf_rrc_ms_part_01;                     /* INTEGER_0_16383 */
static int hf_rrc_modeSpecificInfo_162;           /* T_modeSpecificInfo_162 */
static int hf_rrc_fdd_207;                        /* T_fdd_201 */
static int hf_rrc_tdd_153;                        /* T_tdd_145 */
static int hf_rrc_utra_ServingCell;               /* T_utra_ServingCell */
static int hf_rrc_s_PrioritySearch1;              /* INTEGER_0_31 */
static int hf_rrc_s_PrioritySearch2;              /* INTEGER_0_7 */
static int hf_rrc_threshServingLow;               /* INTEGER_0_31 */
static int hf_rrc_utran_FDD_FrequencyList;        /* UTRAN_FDD_FrequencyList */
static int hf_rrc_utran_TDD_FrequencyList;        /* UTRAN_TDD_FrequencyList */
static int hf_rrc_threshServingLow2;              /* INTEGER_0_31 */
static int hf_rrc_horizontalWithVerticalVelocity;  /* HorizontalWithVerticalVelocity */
static int hf_rrc_horizontalVelocityWithUncertainty;  /* HorizontalVelocityWithUncertainty */
static int hf_rrc_horizontalWithVerticalVelocityAndUncertainty;  /* HorizontalWithVerticalVelocityAndUncertainty */
static int hf_rrc_acdc_Barred;                    /* T_acdc_Barred */
static int hf_rrc_acdc_acb_barringBitmap;         /* BIT_STRING_SIZE_10 */
static int hf_rrc_barringRepresentation;          /* T_barringRepresentation */
static int hf_rrc_acdc_ParametersPerPLMN_List;    /* ACDC_ParametersPerPLMN_List */
static int hf_rrc_acdc_ParametersForAll;          /* ACDC_ParametersForAll */
static int hf_rrc_acdc_Information;               /* SpecificACDC_BarringInformation */
static int hf_rrc_acdcApplicableForRoamer;        /* T_acdcApplicableForRoamer */
static int hf_rrc_ACDC_ParametersPerPLMN_List_item;  /* ACDC_ParametersPerPLMN_List_item */
static int hf_rrc_plmnSpecificACDC_Parameters;    /* SpecificACDC_BarringInformation */
static int hf_rrc_acdcApplicableForRoamer_01;     /* T_acdcApplicableForRoamer_01 */
static int hf_rrc_bcch_ModificationTime;          /* BCCH_ModificationTime */
static int hf_rrc_mib_ValueTagExt;                /* MIB_ValueTagExt */
static int hf_rrc_sb3_ValueTag;                   /* CellValueTag2 */
static int hf_rrc_ncc;                            /* NCC */
static int hf_rrc_bcc;                            /* BCC */
static int hf_rrc_ctch_AllocationPeriod;          /* INTEGER_1_256 */
static int hf_rrc_cbs_FrameOffset;                /* INTEGER_0_255 */
static int hf_rrc_msg_Type;                       /* BIT_STRING_SIZE_8 */
static int hf_rrc_payload_bit_string;             /* BIT_STRING_SIZE_1_512 */
static int hf_rrc_CDMA2000_MessageList_item;      /* CDMA2000_Message */
static int hf_rrc_CDMA2000_UMTS_Frequency_List_item;  /* FrequencyInfoCDMA2000 */
static int hf_rrc_cellValueTag;                   /* CellValueTag */
static int hf_rrc_cellValueTagExt;                /* CellValueTagExt */
static int hf_rrc_dataTransmFreqGranularity;      /* T_dataTransmFreqGranularity */
static int hf_rrc_numberOfDataTransmOcc;          /* INTEGER_1_610 */
static int hf_rrc_dataVolumeMontoringWindow;      /* INTEGER_1_120 */
static int hf_rrc_dataTransmFrequency;            /* DataTransmFrequency */
static int hf_rrc_dataVolumePerRB;                /* DataVolumePerRB_List */
static int hf_rrc_dataVolume;                     /* INTEGER_0_4294967295 */
static int hf_rrc_DataVolumePerRB_List_item;      /* DataVolumePerRB */
static int hf_rrc_modeSpecificInfo_163;           /* T_modeSpecificInfo_163 */
static int hf_rrc_fdd_208;                        /* T_fdd_202 */
static int hf_rrc_intraFreqMeasQuantity_FDD_01;   /* IntraFreqMeasQuantity_FDD_sib3 */
static int hf_rrc_tdd_154;                        /* T_tdd_146 */
static int hf_rrc_intraFreqMeasQuantity_TDDList_01;  /* IntraFreqMeasQuantity_TDD_sib3List */
static int hf_rrc_warningType;                    /* OCTET_STRING_SIZE_1_2 */
static int hf_rrc_messageIdentifier;              /* OCTET_STRING_SIZE_2 */
static int hf_rrc_serialNumber;                   /* OCTET_STRING_SIZE_2 */
static int hf_rrc_EUTRA_Exclude_listedCellPerFreqList_item;  /* EUTRA_Exclude_listedCell */
static int hf_rrc_ue_EUTRA_Capability;            /* T_ue_EUTRA_Capability */
static int hf_rrc_EUTRA_TargetFreqInfoList_item;  /* EUTRA_TargetFreqInfo */
static int hf_rrc_EUTRA_TargetFreqInfoList_vb50ext_item;  /* EUTRA_TargetFreqInfo_vb50ext */
static int hf_rrc_dlEUTRACarrierFreq;             /* EARFCN */
static int hf_rrc_eutraExclude_listedCellPerFreqList;  /* EUTRA_Exclude_listedCellPerFreqList */
static int hf_rrc_extensionGANSS_SIBType;         /* SIB_TypeExtGANSS */
static int hf_rrc_schedulingInfo;                 /* SchedulingInformation */
static int hf_rrc_valueTagInfo;                   /* ValueTagInfo */
static int hf_rrc_ExtGANSS_SIBTypeInfoSchedulingInfoList_item;  /* ExtGANSS_SIBTypeInfoSchedulingInfo */
static int hf_rrc_ganssID;                        /* INTEGER_0_7 */
static int hf_rrc_sbasID;                         /* UE_Positioning_GANSS_SBAS_ID */
static int hf_rrc_ganssScheduling;                /* SEQUENCE_SIZE_1_maxSIB_OF_ExtGANSS_SchedulingInfo */
static int hf_rrc_ganssScheduling_item;           /* ExtGANSS_SchedulingInfo */
static int hf_rrc_ExtSIBTypeInfoSchedulingInfo_List_item;  /* ExtSIBTypeInfoSchedulingInfo */
static int hf_rrc_extensionSIB_Type;              /* SIB_TypeExt */
static int hf_rrc_ExtSIBTypeInfoSchedulingInfo_List2_item;  /* ExtSIBTypeInfoSchedulingInfo2 */
static int hf_rrc_ExtSIBTypeInfoSchedulingInfo_List3_item;  /* ExtSIBTypeInfoSchedulingInfo3 */
static int hf_rrc_extensionSIB_Type2;             /* SIB_TypeExt2 */
static int hf_rrc_extensionSIB_Type3;             /* SIB_TypeExt3 */
static int hf_rrc_schedulingInfo_01;              /* SchedulingInformation2 */
static int hf_rrc_valueTagInfo_01;                /* ValueTagInfoExtValueTag */
static int hf_rrc_FDD_UMTS_Frequency_List_item;   /* FrequencyInfoFDD */
static int hf_rrc_band_Class;                     /* BIT_STRING_SIZE_5 */
static int hf_rrc_cdma_Freq;                      /* BIT_STRING_SIZE_11 */
static int hf_rrc_GERAN_SystemInformation_item;   /* GERAN_SystemInfoBlock */
static int hf_rrc_gsmLowRangeUARFCN;              /* UARFCN */
static int hf_rrc_gsmUpRangeUARFCN;               /* UARFCN */
static int hf_rrc_GSM_BA_Range_List_item;         /* GSM_BA_Range */
static int hf_rrc_GSM_MessageList_item;           /* GSM_MessageList_item */
static int hf_rrc_GSM_TargetCellInfoList_item;    /* GSM_TargetCellInfo */
static int hf_rrc_receivedMessageType;            /* ReceivedMessageType */
static int hf_rrc_configurationUnacceptable;      /* NULL */
static int hf_rrc_unspecified;                    /* NULL */
static int hf_rrc_GERANIu_MessageList_item;       /* BIT_STRING_SIZE_1_32768 */
static int hf_rrc_gsm_19;                         /* T_gsm_17 */
static int hf_rrc_gsm_Classmark2;                 /* GSM_Classmark2 */
static int hf_rrc_gsm_Classmark3;                 /* GSM_Classmark3 */
static int hf_rrc_cdma2000_01;                    /* T_cdma2000_01 */
static int hf_rrc_InterRAT_UE_RadioAccessCapabilityList_item;  /* InterRAT_UE_RadioAccessCapability */
static int hf_rrc_geranIu_RadioAccessCapability;  /* GERANIu_RadioAccessCapability */
static int hf_rrc_supportOfInter_RAT_PS_Handover;  /* T_supportOfInter_RAT_PS_Handover */
static int hf_rrc_gsm_MS_RadioAccessCapability;   /* GSM_MS_RadioAccessCapability */
static int hf_rrc_eutra_RadioAccessCapability;    /* EUTRA_RadioAccessCapability */
static int hf_rrc_gsm_20;                         /* T_gsm_18 */
static int hf_rrc_gsmSecurityCapability;          /* GsmSecurityCapability */
static int hf_rrc_InterRAT_UE_SecurityCapList_item;  /* InterRAT_UE_SecurityCapability */
static int hf_rrc_interRAT_ProtocolError;         /* NULL */
static int hf_rrc_plmn_Type;                      /* PLMN_Type */
static int hf_rrc_sibSb_ReferenceList;            /* SIBSb_ReferenceList */
static int hf_rrc_v690NonCriticalExtensions_48;   /* T_v690NonCriticalExtensions_48 */
static int hf_rrc_masterInformationBlock_v690ext;  /* MasterInformationBlock_v690ext */
static int hf_rrc_v6b0NonCriticalExtensions_16;   /* T_v6b0NonCriticalExtensions_15 */
static int hf_rrc_masterInformationBlock_v6b0ext;  /* MasterInformationBlock_v6b0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_26;   /* T_v860NonCriticalExtensions_26 */
static int hf_rrc_masterInformationBlock_v860ext;  /* MasterInformationBlock_v860ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_11;   /* T_vc50NonCriticalExtensions_11 */
static int hf_rrc_masterInformationBlock_vc50ext;  /* MasterInformationBlock_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_226;      /* T_nonCriticalExtensions_226 */
static int hf_rrc_multiplePLMN_List;              /* MultiplePLMN_List_r6 */
static int hf_rrc_extSIBTypeInfoSchedulingInfo_List;  /* ExtSIBTypeInfoSchedulingInfo_List */
static int hf_rrc_extSIBTypeInfoSchedulingInfo_List_01;  /* ExtSIBTypeInfoSchedulingInfo_List2 */
static int hf_rrc_extGANSS_SIBTypeInfoSchedulingInfoList;  /* ExtGANSS_SIBTypeInfoSchedulingInfoList */
static int hf_rrc_csg_Indicator;                  /* T_csg_Indicator */
static int hf_rrc_sibSb_ReferenceList_01;         /* SIBSb_ReferenceList2 */
static int hf_rrc_extSIBTypeInfoSchedulingInfo_List_02;  /* ExtSIBTypeInfoSchedulingInfo_List3 */
static int hf_rrc_sb3_Information;                /* SB3_Information */
static int hf_rrc_sb3_SegCount;                   /* SegCount */
static int hf_rrc_sb3_Sib_Rep;                    /* SIB_Rep */
static int hf_rrc_second_BCH_Channelizationcode;  /* BCH_Channelizationcode */
static int hf_rrc_predefinedConfigValueTag;       /* PredefinedConfigValueTag */
static int hf_rrc_diagnosticsType_01;             /* T_diagnosticsType_01 */
static int hf_rrc_type1_08;                       /* T_type1_07 */
static int hf_rrc_protocolErrorCause;             /* ProtocolErrorCause */
static int hf_rrc_gsm_BA_Range_List;              /* GSM_BA_Range_List */
static int hf_rrc_fdd_UMTS_Frequency_List;        /* FDD_UMTS_Frequency_List */
static int hf_rrc_tdd_UMTS_Frequency_List;        /* TDD_UMTS_Frequency_List */
static int hf_rrc_cdma2000_UMTS_Frequency_List;   /* CDMA2000_UMTS_Frequency_List */
static int hf_rrc_tdd384_UMTS_Frequency_List;     /* TDD_UMTS_Frequency_List */
static int hf_rrc_tdd128_UMTS_Frequency_List;     /* TDD_UMTS_Frequency_List */
static int hf_rrc_scheduling;                     /* T_scheduling */
static int hf_rrc_segCount;                       /* SegCount */
static int hf_rrc_sib_Pos;                        /* T_sib_Pos */
static int hf_rrc_rep4;                           /* INTEGER_0_1 */
static int hf_rrc_rep8;                           /* INTEGER_0_3 */
static int hf_rrc_rep16;                          /* INTEGER_0_7 */
static int hf_rrc_rep32;                          /* INTEGER_0_15 */
static int hf_rrc_rep64;                          /* INTEGER_0_31 */
static int hf_rrc_rep128;                         /* INTEGER_0_63 */
static int hf_rrc_rep256;                         /* INTEGER_0_127 */
static int hf_rrc_rep512;                         /* INTEGER_0_255 */
static int hf_rrc_rep1024;                        /* INTEGER_0_511 */
static int hf_rrc_rep2048;                        /* INTEGER_0_1023 */
static int hf_rrc_rep4096;                        /* INTEGER_0_2047 */
static int hf_rrc_sib_PosOffsetInfo;              /* SibOFF_List */
static int hf_rrc_scheduling_01;                  /* T_scheduling_01 */
static int hf_rrc_sib_Pos_01;                     /* T_sib_Pos_01 */
static int hf_rrc_sib_PosOffsetInfo_01;           /* SibOFF_List2 */
static int hf_rrc_sib_Type_02;                    /* SIB_TypeAndTag */
static int hf_rrc_scheduling_02;                  /* SchedulingInformation */
static int hf_rrc_sib_Type_03;                    /* SIB_TypeAndTag2 */
static int hf_rrc_scheduling_03;                  /* SchedulingInformation2 */
static int hf_rrc_sibSb_Type;                     /* SIBSb_TypeAndTag */
static int hf_rrc_sibSb_Type_01;                  /* SIBSb_TypeAndTagExtValueTag */
static int hf_rrc_sibOccurIdentity;               /* SIBOccurIdentity */
static int hf_rrc_sibOccurValueTag;               /* SIBOccurValueTag */
static int hf_rrc_SIB_ReferenceList_item;         /* SchedulingInformationSIB */
static int hf_rrc_SIB_ReferenceList2_item;        /* SchedulingInformationSIB2 */
static int hf_rrc_SIBSb_ReferenceList_item;       /* SchedulingInformationSIBSb */
static int hf_rrc_SIBSb_ReferenceList2_item;      /* SchedulingInformationSIBSb2 */
static int hf_rrc_SIB_ReferenceListFACH_item;     /* SchedulingInformationSIB */
static int hf_rrc_sysInfoType1;                   /* PLMN_ValueTag */
static int hf_rrc_sysInfoType2;                   /* CellValueTag */
static int hf_rrc_sysInfoType3;                   /* CellValueTag */
static int hf_rrc_sysInfoType4;                   /* CellValueTag */
static int hf_rrc_sysInfoType5;                   /* CellValueTag */
static int hf_rrc_sysInfoType6;                   /* CellValueTag */
static int hf_rrc_sysInfoType7_01;                /* NULL */
static int hf_rrc_sysInfoType11;                  /* CellValueTag */
static int hf_rrc_sysInfoType13;                  /* CellValueTag */
static int hf_rrc_sysInfoType13_1;                /* CellValueTag */
static int hf_rrc_sysInfoType13_2;                /* CellValueTag */
static int hf_rrc_sysInfoType13_3;                /* CellValueTag */
static int hf_rrc_sysInfoType13_4;                /* CellValueTag */
static int hf_rrc_sysInfoType14;                  /* NULL */
static int hf_rrc_sysInfoType15;                  /* CellValueTag */
static int hf_rrc_sysInfoType16;                  /* PredefinedConfigIdentityAndValueTag */
static int hf_rrc_sysInfoType17;                  /* NULL */
static int hf_rrc_sysInfoType15_1;                /* CellValueTag */
static int hf_rrc_sysInfoType15_2;                /* SIBOccurrenceIdentityAndValueTag */
static int hf_rrc_sysInfoType15_3;                /* SIBOccurrenceIdentityAndValueTag */
static int hf_rrc_sysInfoType15_4;                /* CellValueTag */
static int hf_rrc_sysInfoType18;                  /* CellValueTag */
static int hf_rrc_sysInfoType15_5;                /* CellValueTag */
static int hf_rrc_sysInfoType5bis;                /* CellValueTag */
static int hf_rrc_sysInfoType3_01;                /* CellValueTag3 */
static int hf_rrc_sysInfoType5_01;                /* CellValueTag3 */
static int hf_rrc_sysInfoType5bis_01;             /* CellValueTag3 */
static int hf_rrc_sysInfoType11bis;               /* CellValueTag */
static int hf_rrc_sysInfoType12;                  /* CellValueTag */
static int hf_rrc_sysInfoType15bis;               /* CellValueTag */
static int hf_rrc_sysInfoType15_1bis;             /* CellValueTag */
static int hf_rrc_sysInfoType15_1ter;             /* CellValueTag */
static int hf_rrc_sysInfoType15_2bis;             /* SIBOccurrenceIdentityAndValueTag */
static int hf_rrc_sysInfoType15_2ter;             /* SIBOccurrenceIdentityAndValueTag */
static int hf_rrc_sysInfoType15_3bis;             /* SIBOccurrenceIdentityAndValueTag */
static int hf_rrc_sysInfoType15_6;                /* CellValueTag */
static int hf_rrc_sysInfoType15_7;                /* CellValueTag */
static int hf_rrc_sysInfoType15_8;                /* CellValueTag */
static int hf_rrc_sysInfoType19;                  /* CellValueTag */
static int hf_rrc_sysInfoType20;                  /* CellValueTag */
static int hf_rrc_sysInfoType21;                  /* CellValueTag3 */
static int hf_rrc_sysInfoType22;                  /* CellValueTag3 */
static int hf_rrc_sysInfoType23;                  /* CellValueTag */
static int hf_rrc_sysInfoType24;                  /* NULL */
static int hf_rrc_sysInfoType11ter_01;            /* CellValueTag3 */
static int hf_rrc_sysInfoType25;                  /* NULL */
static int hf_rrc_spare21;                        /* NULL */
static int hf_rrc_spare20;                        /* NULL */
static int hf_rrc_spare19;                        /* NULL */
static int hf_rrc_spare18;                        /* NULL */
static int hf_rrc_spare17;                        /* NULL */
static int hf_rrc_spare16;                        /* NULL */
static int hf_rrc_sysInfoTypeSB1;                 /* CellValueTag */
static int hf_rrc_sysInfoTypeSB2;                 /* CellValueTag */
static int hf_rrc_sysInfoType3_02;                /* CellValueTagExt */
static int hf_rrc_sysInfoType5_02;                /* CellValueTagExt */
static int hf_rrc_sysInfoType5bis_02;             /* CellValueTagExt */
static int hf_rrc_sysInfoType21_01;               /* CellValueTagExt */
static int hf_rrc_sysInfoType22_01;               /* CellValueTagExt */
static int hf_rrc_systemInfoType11bis;            /* NULL */
static int hf_rrc_systemInfoType15bis;            /* NULL */
static int hf_rrc_systemInfoType15_1bis;          /* NULL */
static int hf_rrc_systemInfoType15_2bis;          /* NULL */
static int hf_rrc_systemInfoType15_3bis;          /* NULL */
static int hf_rrc_systemInfoType15_6;             /* NULL */
static int hf_rrc_systemInfoType15_7;             /* NULL */
static int hf_rrc_systemInfoType15_8;             /* NULL */
static int hf_rrc_systemInfoType19;               /* NULL */
static int hf_rrc_systemInfoType15_2ter;          /* NULL */
static int hf_rrc_systemInfoType20;               /* NULL */
static int hf_rrc_systemInfoType21;               /* NULL */
static int hf_rrc_systemInfoType22;               /* NULL */
static int hf_rrc_systemInfoType15_1ter;          /* NULL */
static int hf_rrc_systemInfoType23;               /* NULL */
static int hf_rrc_systemInfoType24;               /* NULL */
static int hf_rrc_systemInfoType11ter;            /* NULL */
static int hf_rrc_systemInfoType25;               /* NULL */
static int hf_rrc_sibOFF;                         /* SibOFF */
static int hf_rrc_SibOFF_List_item;               /* SibOFF */
static int hf_rrc_SibOFF_List2_item;              /* SibOFF_vc50ext */
static int hf_rrc_SpecificACDC_BarringInformation_item;  /* SpecificACDC_BarringInformation_item */
static int hf_rrc_acdc_Barring;                   /* ACDC_Barring */
static int hf_rrc_expirationTimeFactor;           /* ExpirationTimeFactor2 */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo_03;  /* T_cn_CommonGSM_MAP_NAS_SysInfo_03 */
static int hf_rrc_cn_DomainSysInfoList;           /* CN_DomainSysInfoList */
static int hf_rrc_ue_IdleTimersAndConstants;      /* UE_IdleTimersAndConstants */
static int hf_rrc_v3a0NonCriticalExtensions_12;   /* T_v3a0NonCriticalExtensions_12 */
static int hf_rrc_sysInfoType1_v3a0ext;           /* SysInfoType1_v3a0ext_IEs */
static int hf_rrc_v860NonCriticalExtentions_02;   /* T_v860NonCriticalExtentions_02 */
static int hf_rrc_sysInfoType1_v860ext;           /* SysInfoType1_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_227;      /* T_nonCriticalExtensions_227 */
static int hf_rrc_ue_IdleTimersAndConstants_v3a0ext;  /* UE_IdleTimersAndConstants_v3a0ext */
static int hf_rrc_ura_IdentityList;               /* URA_IdentityList */
static int hf_rrc_nonCriticalExtensions_228;      /* T_nonCriticalExtensions_228 */
static int hf_rrc_sib4indicator;                  /* BOOLEAN */
static int hf_rrc_cellSelectReselectInfo;         /* CellSelectReselectInfoSIB_3_4 */
static int hf_rrc_cellAccessRestriction;          /* CellAccessRestriction */
static int hf_rrc_v4b0NonCriticalExtensions_17;   /* T_v4b0NonCriticalExtensions_17 */
static int hf_rrc_sysInfoType3_v4b0ext;           /* SysInfoType3_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtension;       /* T_v590NonCriticalExtension */
static int hf_rrc_sysInfoType3_v590ext;           /* SysInfoType3_v590ext */
static int hf_rrc_v5c0NoncriticalExtension;       /* T_v5c0NoncriticalExtension */
static int hf_rrc_sysInfoType3_v5c0ext;           /* SysInfoType3_v5c0ext_IEs */
static int hf_rrc_v670NonCriticalExtension;       /* T_v670NonCriticalExtension */
static int hf_rrc_sysInfoType3_v670ext;           /* SysInfoType3_v670ext */
static int hf_rrc_v770NonCriticalExtension_02;    /* T_v770NonCriticalExtension_02 */
static int hf_rrc_sysInfoType3_v770ext;           /* SysInfoType3_v770ext_IEs */
static int hf_rrc_v830NonCriticalExtension;       /* T_v830NonCriticalExtension */
static int hf_rrc_sysInfoType3_v830ext;           /* SysInfoType3_v830ext_IEs */
static int hf_rrc_v860NonCriticalExtension_01;    /* T_v860NonCriticalExtension_01 */
static int hf_rrc_sysInfoType3_v860ext;           /* SysInfoType3_v860ext_IEs */
static int hf_rrc_v870NonCriticalExtension;       /* T_v870NonCriticalExtension */
static int hf_rrc_sysInfoType3_v870ext;           /* SysInfoType3_v870ext_IEs */
static int hf_rrc_v900NonCriticalExtension;       /* T_v900NonCriticalExtension */
static int hf_rrc_sysInfoType3_v920ext;           /* SysInfoType3_v920ext_IEs */
static int hf_rrc_vc50NonCriticalExtension_01;    /* T_vc50NonCriticalExtension_01 */
static int hf_rrc_sysInfoType3_vc50ext;           /* SysInfoType3_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_229;      /* T_nonCriticalExtensions_229 */
static int hf_rrc_mapping_LCR;                    /* Mapping_LCR_r4 */
static int hf_rrc_cellSelectReselectInfo_v590ext;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_cellSelectReselectInfoTreselectionScaling_v5c0ext;  /* CellSelectReselectInfoTreselectionScaling_v5c0ext */
static int hf_rrc_domainSpecificAccessRestrictionParametersForPLMNOfMIB;  /* DomainSpecificAccessRestrictionParam_v670ext */
static int hf_rrc_domainSpecificAccessRestictionForSharedNetwork;  /* DomainSpecificAccessRestrictionForSharedNetwork_v670ext */
static int hf_rrc_deferredMeasurementControlReadingSupport;  /* DeferredMeasurementControlReadingSupport */
static int hf_rrc_q_QualMin_Offset;               /* Q_QualMin_Offset */
static int hf_rrc_q_RxlevMin_Offset;              /* Q_RxlevMin_Offset */
static int hf_rrc_mbsfnOnlyService;               /* MBSFNOnlyService */
static int hf_rrc_pagingPermissionWithAccessControlParametersForPLMNOfMIB;  /* PagingPermissionWithAccessControlParameters */
static int hf_rrc_pagingPermissionWithAccessControlParametersForSharedNetwork;  /* PagingPermissionWithAccessControlForSharedNetwork */
static int hf_rrc_csg_PSCSplitInfo;               /* CSG_PSCSplitInfo */
static int hf_rrc_cellAccessRestriction_01;       /* CellAccessRestriction_v870ext */
static int hf_rrc_imsEmergencySupportIndicator;   /* T_imsEmergencySupportIndicator */
static int hf_rrc_txFailParams;                   /* TxFailParams */
static int hf_rrc_v4b0NonCriticalExtensions_18;   /* T_v4b0NonCriticalExtensions_18 */
static int hf_rrc_sysInfoType4_v4b0ext;           /* SysInfoType4_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtension_01;    /* T_v590NonCriticalExtension_01 */
static int hf_rrc_sysInfoType4_v590ext;           /* SysInfoType4_v590ext */
static int hf_rrc_v5b0NonCriticalExtension;       /* T_v5b0NonCriticalExtension */
static int hf_rrc_sysInfoType4_v5b0ext;           /* SysInfoType4_v5b0ext_IEs */
static int hf_rrc_v5c0NonCriticalExtension;       /* T_v5c0NonCriticalExtension */
static int hf_rrc_sysInfoType4_v5c0ext;           /* SysInfoType4_v5c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_230;      /* T_nonCriticalExtensions_230 */
static int hf_rrc_cellSelectReselectInfoPCHFACH_v5b0ext;  /* CellSelectReselectInfoPCHFACH_v5b0ext */
static int hf_rrc_sib6indicator;                  /* BOOLEAN */
static int hf_rrc_pich_PowerOffset;               /* PICH_PowerOffset */
static int hf_rrc_modeSpecificInfo_164;           /* T_modeSpecificInfo_164 */
static int hf_rrc_fdd_209;                        /* T_fdd_203 */
static int hf_rrc_aich_PowerOffset;               /* AICH_PowerOffset */
static int hf_rrc_tdd_155;                        /* T_tdd_147 */
static int hf_rrc_pusch_SysInfoList_SFN;          /* PUSCH_SysInfoList_SFN */
static int hf_rrc_pdsch_SysInfoList_SFN;          /* PDSCH_SysInfoList_SFN */
static int hf_rrc_openLoopPowerControl_TDD;       /* OpenLoopPowerControl_TDD */
static int hf_rrc_prach_SystemInformationList;    /* PRACH_SystemInformationList */
static int hf_rrc_sCCPCH_SystemInformationList;   /* SCCPCH_SystemInformationList */
static int hf_rrc_cbs_DRX_Level1Information;      /* CBS_DRX_Level1Information */
static int hf_rrc_v4b0NonCriticalExtensions_19;   /* T_v4b0NonCriticalExtensions_19 */
static int hf_rrc_sysInfoType5_v4b0ext;           /* SysInfoType5_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_28;   /* T_v590NonCriticalExtensions_28 */
static int hf_rrc_sysInfoType5_v590ext;           /* SysInfoType5_v590ext_IEs */
static int hf_rrc_v650NonCriticalExtensions;      /* T_v650NonCriticalExtensions */
static int hf_rrc_sysInfoType5_v650ext;           /* SysInfoType5_v650ext_IEs */
static int hf_rrc_v680NonCriticalExtensions_02;   /* T_v680NonCriticalExtensions_02 */
static int hf_rrc_sysInfoType5_v680ext;           /* SysInfoType5_v680ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_49;   /* T_v690NonCriticalExtensions_49 */
static int hf_rrc_sysInfoType5_v690ext;           /* SysInfoType5_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_40;   /* T_v770NonCriticalExtensions_40 */
static int hf_rrc_sysInfoType5_v770ext;           /* SysInfoType5_v770ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_27;   /* T_v860NonCriticalExtensions_27 */
static int hf_rrc_sysInfoType5_v860ext;           /* SysInfoType5_v860ext_IEs */
static int hf_rrc_v890NonCriticalExtensions_11;   /* T_v890NonCriticalExtensions_11 */
static int hf_rrc_sysInfoType5_v890ext;           /* SysInfoType5_v890ext_IEs */
static int hf_rrc_v8b0NonCriticalExtensions_01;   /* T_v8b0NonCriticalExtensions_01 */
static int hf_rrc_sysInfoType5_v8b0ext;           /* SysInfoType5_v8b0ext_IEs */
static int hf_rrc_v8d0NonCriticalExtensions;      /* T_v8d0NonCriticalExtensions */
static int hf_rrc_sysInfoType5_v8d0ext;           /* SysInfoType5_v8d0ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_19;   /* T_va40NonCriticalExtensions_18 */
static int hf_rrc_sysInfoType5_va40ext;           /* SysInfoType5_va40ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_02;   /* T_va80NonCriticalExtensions_02 */
static int hf_rrc_sysInfoType5_va80ext;           /* SysInfoType5_va80ext_IEs */
static int hf_rrc_vb50NonCriticalExtensions_24;   /* SysInfoType5_NonCriticalExtensions_vb50_IEs */
static int hf_rrc_pNBSCH_Allocation_r4;           /* PNBSCH_Allocation_r4 */
static int hf_rrc_prach_SystemInformationList_LCR_r4;  /* PRACH_SystemInformationList_LCR_r4 */
static int hf_rrc_tdd128SpecificInfo;             /* T_tdd128SpecificInfo */
static int hf_rrc_pusch_SysInfoList_SFN_01;       /* PUSCH_SysInfoList_SFN_LCR_r4 */
static int hf_rrc_pdsch_SysInfoList_SFN_01;       /* PDSCH_SysInfoList_SFN_LCR_r4 */
static int hf_rrc_pCCPCH_LCR_Extensions;          /* PrimaryCCPCH_Info_LCR_r4_ext */
static int hf_rrc_sCCPCH_LCR_ExtensionsList;      /* SCCPCH_SystemInformationList_LCR_r4_ext */
static int hf_rrc_frequencyBandIndicator;         /* RadioFrequencyBandFDD */
static int hf_rrc_hcr_r5_SpecificInfo;            /* T_hcr_r5_SpecificInfo */
static int hf_rrc_pusch_SysInfoList_SFN_02;       /* PUSCH_SysInfoList_SFN_HCR_r5 */
static int hf_rrc_pdsch_SysInfoList_SFN_02;       /* PDSCH_SysInfoList_SFN_HCR_r5 */
static int hf_rrc_frequencyBandIndicator2;        /* RadioFrequencyBandFDD2 */
static int hf_rrc_hsdpa_CellIndicator;            /* T_hsdpa_CellIndicator */
static int hf_rrc_edch_CellIndicator;             /* T_edch_CellIndicator */
static int hf_rrc_sccpch_SystemInformation_MBMS;  /* T_sccpch_SystemInformation_MBMS */
static int hf_rrc_mcchOnSCCPCHusedForNonMBMS;     /* MBMS_MCCH_ConfigurationInfo_r6 */
static int hf_rrc_mcchOnSCCPCHusedOnlyForMBMS;    /* SCCPCH_SystemInformation_MBMS_r6 */
static int hf_rrc_additionalPRACH_TF_and_TFCS_CCCH_List;  /* AdditionalPRACH_TF_and_TFCS_CCCH_List */
static int hf_rrc_cBS_DRX_Level1Information_extension;  /* CBS_DRX_Level1Information_extension_r6 */
static int hf_rrc_modeSpecificInfo_165;           /* T_modeSpecificInfo_165 */
static int hf_rrc_fdd_210;                        /* T_fdd_204 */
static int hf_rrc_hs_dsch_CommonSystemInformation;  /* HS_DSCH_CommonSystemInformation */
static int hf_rrc_hs_dsch_PagingSystemInformation;  /* HS_DSCH_PagingSystemInformation */
static int hf_rrc_tdd768_29;                      /* T_tdd768_26 */
static int hf_rrc_pusch_SysInfoList_SFN_03;       /* PUSCH_SysInfoList_SFN_VHCR */
static int hf_rrc_pdsch_SysInfoList_SFN_03;       /* PDSCH_SysInfoList_VHCR_r7 */
static int hf_rrc_prach_SystemInformationList_01;  /* PRACH_SystemInformationList_VHCR_r7 */
static int hf_rrc_tdd128_78;                      /* T_tdd128_75 */
static int hf_rrc_prach_SystemInformationList_02;  /* PRACH_SystemInformationList_LCR_v770ext */
static int hf_rrc_sccpch_SystemInformationList;   /* SCCPCH_SystemInformationList_HCR_VHCR_r7 */
static int hf_rrc_sccpch_SystemInformation_MBMS_01;  /* T_sccpch_SystemInformation_MBMS_01 */
static int hf_rrc_mcchOnSCCPCHusedOnlyForMBMS_01;  /* SCCPCH_SystemInformation_MBMS_r7 */
static int hf_rrc_tDD_MBSFNInformation;           /* TDD_MBSFNInformation */
static int hf_rrc_dummy_seq;                      /* T_dummy_seq */
static int hf_rrc_modeSpecificInfo_166;           /* T_modeSpecificInfo_166 */
static int hf_rrc_fdd_211;                        /* T_fdd_205 */
static int hf_rrc_hs_dsch_DrxCellfach_info;       /* HS_DSCH_DrxCellfach_info */
static int hf_rrc_tdd128_79;                      /* T_tdd128_76 */
static int hf_rrc_hs_dsch_CommonSysInfo;          /* T_hs_dsch_CommonSysInfo */
static int hf_rrc_hs_dsch_CommonSystemInformation_01;  /* HS_DSCH_CommonSystemInformation_TDD128 */
static int hf_rrc_hs_dsch_PagingSystemInformation_01;  /* HS_DSCH_PagingSystemInformation_TDD128 */
static int hf_rrc_hs_dsch_DrxCellfach_info_01;    /* HS_DSCH_DrxCellfach_info_TDD128 */
static int hf_rrc_commonEDCHSystemInfo;           /* CommonEDCHSystemInfo */
static int hf_rrc_tresetUsageIndicator;           /* T_tresetUsageIndicator */
static int hf_rrc_commonEDCHSystemInfoFDD;        /* CommonEDCHSystemInfoFDD */
static int hf_rrc_frequencyBandsIndicatorSupport;  /* FrequencyBandsIndicatorSupport */
static int hf_rrc_frequencyBandIndicator3;        /* RadioFrequencyBandFDD3 */
static int hf_rrc_sysInfoType5_vb50ext;           /* SysInfoType5_vb50ext_IEs */
static int hf_rrc_ve30NonCriticalExtensions_03;   /* SysInfoType5_NonCriticalExtensions_ve30_IEs */
static int hf_rrc_sysInfoType5_ve30ext;           /* SysInfoType5_ve30ext_IEs */
static int hf_rrc_nonCriticalExtensions_231;      /* T_nonCriticalExtensions_231 */
static int hf_rrc_adjacentchannelinterferencelevel;  /* T_adjacentchannelinterferencelevel */
static int hf_rrc_sib22indicator;                 /* BOOLEAN */
static int hf_rrc_cellUpdateMessageOptimisedEncoding;  /* T_cellUpdateMessageOptimisedEncoding */
static int hf_rrc_modeSpecificInfo_167;           /* T_modeSpecificInfo_167 */
static int hf_rrc_fdd_212;                        /* T_fdd_206 */
static int hf_rrc_cSICH_PowerOffset;              /* CSICH_PowerOffset */
static int hf_rrc_tdd_156;                        /* T_tdd_148 */
static int hf_rrc_v4b0NonCriticalExtensions_20;   /* T_v4b0NonCriticalExtensions_20 */
static int hf_rrc_sysInfoType6_v4b0ext;           /* SysInfoType6_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_29;   /* T_v590NonCriticalExtensions_29 */
static int hf_rrc_sysInfoType6_v590ext;           /* SysInfoType6_v590ext_IEs */
static int hf_rrc_v650nonCriticalExtensions;      /* T_v650nonCriticalExtensions */
static int hf_rrc_sysInfoType6_v650ext;           /* SysInfoType6_v650ext_IEs */
static int hf_rrc_v690nonCriticalExtensions;      /* T_v690nonCriticalExtensions */
static int hf_rrc_sysInfoType6_v690ext;           /* SysInfoType6_v690ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_41;   /* T_v770NonCriticalExtensions_41 */
static int hf_rrc_sysInfoType6_v770ext;           /* SysInfoType6_v770ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_20;   /* T_va40NonCriticalExtensions_19 */
static int hf_rrc_sysInfoType6_va40ext;           /* SysInfoType6_va40ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_03;   /* T_va80NonCriticalExtensions_03 */
static int hf_rrc_sysInfoType6_va80ext;           /* SysInfoType6_va80ext_IEs */
static int hf_rrc_ve30NonCriticalExtensions_04;   /* SysInfoType6_NonCriticalExtensions_ve30_IEs */
static int hf_rrc_sysInfoType6_ve30ext;           /* SysInfoType6_ve30ext_IEs */
static int hf_rrc_nonCriticalExtensions_232;      /* T_nonCriticalExtensions_232 */
static int hf_rrc_adjacentchannelinterferencelevel_01;  /* T_adjacentchannelinterferencelevel_01 */
static int hf_rrc_tdd128SpecificInfo_01;          /* T_tdd128SpecificInfo_01 */
static int hf_rrc_hcr_r5_SpecificInfo_01;         /* T_hcr_r5_SpecificInfo_01 */
static int hf_rrc_tdd768SpecificInfo;             /* T_tdd768SpecificInfo */
static int hf_rrc_modeSpecificInfo_168;           /* T_modeSpecificInfo_168 */
static int hf_rrc_fdd_213;                        /* T_fdd_207 */
static int hf_rrc_ul_Interference;                /* UL_Interference */
static int hf_rrc_prach_Information_SIB5_List;    /* DynamicPersistenceLevelList */
static int hf_rrc_prach_Information_SIB6_List;    /* DynamicPersistenceLevelList */
static int hf_rrc_expirationTimeFactor_01;        /* ExpirationTimeFactor */
static int hf_rrc_nonCriticalExtensions_233;      /* T_nonCriticalExtensions_233 */
static int hf_rrc_cPCH_Parameters;                /* CPCH_Parameters */
static int hf_rrc_cPCH_SetInfoList;               /* CPCH_SetInfoList */
static int hf_rrc_nonCriticalExtensions_234;      /* T_nonCriticalExtensions_234 */
static int hf_rrc_cPCH_PersistenceLevelsList;     /* CPCH_PersistenceLevelsList */
static int hf_rrc_nonCriticalExtensions_235;      /* T_nonCriticalExtensions_235 */
static int hf_rrc_dRAC_SysInfoList;               /* DRAC_SysInfoList */
static int hf_rrc_nonCriticalExtensions_236;      /* T_nonCriticalExtensions_236 */
static int hf_rrc_sib12indicator;                 /* BOOLEAN */
static int hf_rrc_fach_MeasurementOccasionInfo;   /* FACH_MeasurementOccasionInfo */
static int hf_rrc_measurementControlSysInfo;      /* MeasurementControlSysInfo */
static int hf_rrc_v4b0NonCriticalExtensions_21;   /* T_v4b0NonCriticalExtensions_21 */
static int hf_rrc_sysInfoType11_v4b0ext;          /* SysInfoType11_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtension_02;    /* T_v590NonCriticalExtension_02 */
static int hf_rrc_sysInfoType11_v590ext;          /* SysInfoType11_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_50;   /* T_v690NonCriticalExtensions_50 */
static int hf_rrc_sysInfoType11_v690ext;          /* SysInfoType11_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_17;   /* T_v6b0NonCriticalExtensions_16 */
static int hf_rrc_sysInfoType11_v6b0ext;          /* SysInfoType11_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_42;   /* T_v770NonCriticalExtensions_42 */
static int hf_rrc_sysInfoType11_v770ext;          /* SysInfoType11_v770ext_IEs */
static int hf_rrc_v7b0NonCriticalExtensions_02;   /* T_v7b0NonCriticalExtensions_02 */
static int hf_rrc_sysInfoType11_v7b0ext;          /* SysInfoType11_v7b0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_28;   /* T_v860NonCriticalExtensions_28 */
static int hf_rrc_sysInfoType11_v860ext;          /* SysInfoType11_v860ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_04;   /* T_va80NonCriticalExtensions_04 */
static int hf_rrc_sysInfoType11_va80ext;          /* SysInfoType11_va80ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_12;   /* T_vc50NonCriticalExtensions_12 */
static int hf_rrc_sysInfoType11_vc50ext;          /* SysInfoType11_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_237;      /* T_nonCriticalExtensions_237 */
static int hf_rrc_fach_MeasurementOccasionInfo_LCR_Ext;  /* FACH_MeasurementOccasionInfo_LCR_r4_ext */
static int hf_rrc_measurementControlSysInfo_LCR;  /* MeasurementControlSysInfo_LCR_r4_ext */
static int hf_rrc_newIntraFrequencyCellInfoList_v590ext;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newIntraFrequencyCellInfoList_v590ext_item;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterFrequencyCellInfoList_v590ext;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterFrequencyCellInfoList_v590ext_item;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterRATCellInfoList_v590ext;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_CellSelectReselectInfo_v590ext */
static int hf_rrc_newInterRATCellInfoList_v590ext_item;  /* CellSelectReselectInfo_v590ext */
static int hf_rrc_intraFreqEventCriteriaList_v590ext;  /* Intra_FreqEventCriteriaList_v590ext */
static int hf_rrc_dummy_InterFreqRACHReportingInfo;  /* Dummy_InterFreqRACHReportingInfo */
static int hf_rrc_interFreqRACHReportingInfo;     /* InterFreqRACHReportingInfo */
static int hf_rrc_mbsfnFrequencyList;             /* MBSFNFrequencyList */
static int hf_rrc_mbsfnFrequencyList_01;          /* MBSFNFrequencyList_v860ext */
static int hf_rrc_multipleFrequencyInfoListFDD;   /* MultipleFrequencyInfoListFDD */
static int hf_rrc_measurementControlSysInfo_01;   /* MeasurementControlSysInfo_vc50ext */
static int hf_rrc_measurementControlSysInfo_02;   /* MeasurementControlSysInfoExtension */
static int hf_rrc_measurementControlSysInfo_LCR_01;  /* MeasurementControlSysInfoExtension_LCR_r4 */
static int hf_rrc_measurementControlSysInfoExtensionAddon_r5;  /* MeasurementControlSysInfoExtensionAddon_r5 */
static int hf_rrc_v7b0NonCriticalExtensions_03;   /* T_v7b0NonCriticalExtensions_03 */
static int hf_rrc_sysInfoType11bis_v7b0ext;       /* SysInfoType11bis_v7b0ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_29;   /* T_v860NonCriticalExtensions_29 */
static int hf_rrc_sysInfoType11bis_v860ext;       /* SysInfoType11bis_v860ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_05;   /* T_va80NonCriticalExtensions_05 */
static int hf_rrc_sysInfoType11bis_va80ext;       /* SysInfoType11bis_va80ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_13;   /* T_vc50NonCriticalExtensions_13 */
static int hf_rrc_sysInfoType11bis_vc50ext;       /* SysInfoType11bis_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_238;      /* T_nonCriticalExtensions_238 */
static int hf_rrc_csg_DedicatedFrequencyInfoList;  /* CSG_DedicatedFrequencyInfoList */
static int hf_rrc_measureControlSysInfoInterFreqExt;  /* MeasureControlSysInfoInterFreqExt */
static int hf_rrc_nonCriticalExtensions_239;      /* T_nonCriticalExtensions_239 */
static int hf_rrc_v4b0NonCriticalExtensions_22;   /* T_v4b0NonCriticalExtensions_22 */
static int hf_rrc_sysInfoType12_v4b0ext;          /* SysInfoType12_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtension_03;    /* T_v590NonCriticalExtension_03 */
static int hf_rrc_sysInfoType12_v590ext;          /* SysInfoType12_v590ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_51;   /* T_v690NonCriticalExtensions_51 */
static int hf_rrc_sysInfoType12_v690ext;          /* SysInfoType12_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_18;   /* T_v6b0NonCriticalExtensions_17 */
static int hf_rrc_sysInfoType12_v6b0ext;          /* SysInfoType12_v6b0ext_IEs */
static int hf_rrc_v7b0NonCriticalExtensions_04;   /* T_v7b0NonCriticalExtensions_04 */
static int hf_rrc_sysInfoType12_v7b0ext;          /* SysInfoType12_v7b0ext_IEs */
static int hf_rrc_va80NonCriticalExtensions_06;   /* T_va80NonCriticalExtensions_06 */
static int hf_rrc_sysInfoType12_va80ext;          /* SysInfoType12_va80ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_14;   /* T_vc50NonCriticalExtensions_14 */
static int hf_rrc_sysInfoType12_vc50ext;          /* SysInfoType12_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_240;      /* T_nonCriticalExtensions_240 */
static int hf_rrc_v3a0NonCriticalExtensions_13;   /* T_v3a0NonCriticalExtensions_13 */
static int hf_rrc_sysInfoType13_v3a0ext;          /* SysInfoType13_v3a0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_23;   /* T_v4b0NonCriticalExtensions_23 */
static int hf_rrc_sysInfoType13_v4b0ext;          /* SysInfoType13_v4b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_43;   /* T_v770NonCriticalExtensions_43 */
static int hf_rrc_sysInfoType13_v770ext;          /* SysInfoType13_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_241;      /* T_nonCriticalExtensions_241 */
static int hf_rrc_capabilityUpdateRequirement_r4Ext;  /* CapabilityUpdateRequirement_r4_ext */
static int hf_rrc_ansi_41_RAND_Information;       /* ANSI_41_RAND_Information */
static int hf_rrc_nonCriticalExtensions_242;      /* T_nonCriticalExtensions_242 */
static int hf_rrc_ansi_41_UserZoneID_Information;  /* ANSI_41_UserZoneID_Information */
static int hf_rrc_nonCriticalExtensions_243;      /* T_nonCriticalExtensions_243 */
static int hf_rrc_ansi_41_PrivateNeighbourListInfo;  /* ANSI_41_PrivateNeighbourListInfo */
static int hf_rrc_nonCriticalExtensions_244;      /* T_nonCriticalExtensions_244 */
static int hf_rrc_ansi_41_GlobalServiceRedirectInfo;  /* ANSI_41_GlobalServiceRedirectInfo */
static int hf_rrc_nonCriticalExtensions_245;      /* T_nonCriticalExtensions_245 */
static int hf_rrc_nonCriticalExtensions_246;      /* T_nonCriticalExtensions_246 */
static int hf_rrc_ue_positioning_GPS_CipherParameters;  /* UE_Positioning_CipherParameters */
static int hf_rrc_v4b0NonCriticalExtensions_24;   /* T_v4b0NonCriticalExtensions_24 */
static int hf_rrc_sysInfoType15_v4b0ext;          /* SysInfoType15_v4b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_44;   /* T_v770NonCriticalExtensions_44 */
static int hf_rrc_sysInfoType15_v770ext;          /* SysInfoType15_v770ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_21;   /* T_va40NonCriticalExtensions_20 */
static int hf_rrc_sysInfoType15_va40ext;          /* SysInfoType15_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_247;      /* T_nonCriticalExtensions_247 */
static int hf_rrc_up_Ipdl_Parameters_TDD;         /* UE_Positioning_IPDL_Parameters_TDD_r4_ext */
static int hf_rrc_ue_Positioning_GPS_ReferenceTime;  /* UE_Positioning_GPS_ReferenceTime_v770ext */
static int hf_rrc_ue_Positioning_GPS_ReferenceTime_01;  /* UE_Positioning_GPS_ReferenceTime_va40ext */
static int hf_rrc_ue_positioning_GANSS_ReferencePosition;  /* ReferenceLocationGANSS */
static int hf_rrc_ue_positioning_GANSS_IonosphericModel;  /* UE_Positioning_GANSS_IonosphericModel */
static int hf_rrc_v860NonCriticalExtensions_30;   /* T_v860NonCriticalExtensions_30 */
static int hf_rrc_sysInfoType15bis_v860ext;       /* SysInfoType15bis_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_22;   /* T_va40NonCriticalExtensions_21 */
static int hf_rrc_sysInfoType15bis_va40ext;       /* SysInfoType15bis_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_248;      /* T_nonCriticalExtensions_248 */
static int hf_rrc_ue_Positioning_GANSS_AddIonoModel;  /* UE_Positioning_GANSS_AddIonoModel */
static int hf_rrc_ue_Positioning_GANSS_EarthOrientationPara;  /* UE_Positioning_GANSS_EarthOrientPara */
static int hf_rrc_v920NonCriticalExtensions_04;   /* T_v920NonCriticalExtensions_04 */
static int hf_rrc_sysInfoType15_1_v920ext;        /* SysInfoType15_1_v920ext_IEs */
static int hf_rrc_nonCriticalExtensions_249;      /* T_nonCriticalExtensions_249 */
static int hf_rrc_ue_positioning_GANSS_DGANSS_Corrections;  /* UE_Positioning_DGANSSCorrections */
static int hf_rrc_v920NonCriticalExtensions_05;   /* T_v920NonCriticalExtensions_05 */
static int hf_rrc_sysInfoType15_1bis_v920ext;     /* SysInfoType15_1bis_v920ext_IEs */
static int hf_rrc_nonCriticalExtensions_250;      /* T_nonCriticalExtensions_250 */
static int hf_rrc_ue_positioning_GANSS_DGANSS_Corrections_01;  /* UE_Positioning_DGANSSCorrections_v920ext */
static int hf_rrc_uePositioning_BDSCorrections;   /* UE_Positioning_DBDSCorrections */
static int hf_rrc_nonCriticalExtensions_251;      /* T_nonCriticalExtensions_251 */
static int hf_rrc_transmissionTOW;                /* GPS_TOW_1sec */
static int hf_rrc_nonCriticalExtensions_252;      /* T_nonCriticalExtensions_252 */
static int hf_rrc_ue_positioning_GANSS_navigationModel;  /* UE_Positioning_GANSS_NavigationModel */
static int hf_rrc_nonCriticalExtensions_253;      /* T_nonCriticalExtensions_253 */
static int hf_rrc_ue_positioning_GANSS_AddNavigationModels_01;  /* UE_Positioning_GANSS_AddNavigationModels */
static int hf_rrc_vc50NonCriticalExtensions_15;   /* T_vc50NonCriticalExtensions_15 */
static int hf_rrc_sysInfoType15_2ter_vc50ext;     /* SysInfoType15_2ter_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_254;      /* T_nonCriticalExtensions_254 */
static int hf_rrc_satMask;                        /* BIT_STRING_SIZE_1_32 */
static int hf_rrc_lsbTOW;                         /* BIT_STRING_SIZE_8 */
static int hf_rrc_va40NonCriticalExtensions_23;   /* T_va40NonCriticalExtensions_22 */
static int hf_rrc_sysInfoType15_3_va40ext;        /* SysInfoType15_3_va40ext_IEs */
static int hf_rrc_nonCriticalExtensions_255;      /* T_nonCriticalExtensions_255 */
static int hf_rrc_ue_positioning_GANSS_Almanac;   /* UE_Positioning_GANSS_Almanac */
static int hf_rrc_ue_positioning_GANSS_TimeModels;  /* UE_Positioning_GANSS_TimeModels */
static int hf_rrc_ue_positioning_GANSS_UTC_Model;  /* UE_Positioning_GANSS_UTCModel */
static int hf_rrc_v860NonCriticalExtensions_31;   /* T_v860NonCriticalExtensions_31 */
static int hf_rrc_sysInfoType15_3bis_v860ext;     /* SysInfoType15_3bis_v860ext_IEs */
static int hf_rrc_va40NonCriticalExtensions_24;   /* T_va40NonCriticalExtensions_23 */
static int hf_rrc_sysInfoType15_3bis_va40ext;     /* SysInfoType15_3bis_va40ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_16;   /* T_vc50NonCriticalExtensions_16 */
static int hf_rrc_sysInfoType15_3bis_vc50ext;     /* SysInfoType15_3bis_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_256;      /* T_nonCriticalExtensions_256 */
static int hf_rrc_ue_Positioning_GANSS_Almanac_01;  /* UE_Positioning_GANSS_Almanac_v860ext */
static int hf_rrc_ue_Positioning_GANSS_AddUTCModels_01;  /* UE_Positioning_GANSS_AddUTCModels */
static int hf_rrc_ue_Positioning_GANSS_AuxiliaryInfo;  /* UE_Positioning_GANSS_AuxiliaryInfo */
static int hf_rrc_ue_Positioning_GANSS_Almanac_02;  /* UE_Positioning_GANSS_Almanac_va40ext */
static int hf_rrc_ue_positioning_GANSS_TimeModels_01;  /* UE_Positioning_GANSS_TimeModels_va40ext */
static int hf_rrc_ue_positioning_OTDOA_CipherParameters;  /* UE_Positioning_CipherParameters */
static int hf_rrc_v3a0NonCriticalExtensions_14;   /* T_v3a0NonCriticalExtensions_14 */
static int hf_rrc_sysInfoType15_4_v3a0ext;        /* SysInfoType15_4_v3a0ext */
static int hf_rrc_v4b0NonCriticalExtensions_25;   /* T_v4b0NonCriticalExtensions_25 */
static int hf_rrc_sysInfoType15_4_v4b0ext;        /* SysInfoType15_4_v4b0ext */
static int hf_rrc_nonCriticalExtensions_257;      /* T_nonCriticalExtensions_257 */
static int hf_rrc_v3a0NonCriticalExtensions_15;   /* T_v3a0NonCriticalExtensions_15 */
static int hf_rrc_sysInfoType15_5_v3a0ext;        /* SysInfoType15_5_v3a0ext */
static int hf_rrc_v770NonCriticalExtensions_45;   /* T_v770NonCriticalExtensions_45 */
static int hf_rrc_sysInfoType15_5_v770ext;        /* SysInfoType15_5_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_258;      /* T_nonCriticalExtensions_258 */
static int hf_rrc_ue_positioning_GANSS_TOD;       /* INTEGER_0_86399 */
static int hf_rrc_ue_positioning_GANSS_ReferenceMeasurementInformation;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo */
static int hf_rrc_va40NonCriticalExtensions_25;   /* T_va40NonCriticalExtensions_24 */
static int hf_rrc_sysInfoType15_6_va40ext;        /* SysInfoType15_6_va40ext_IEs */
static int hf_rrc_vc50NonCriticalExtensions_17;   /* T_vc50NonCriticalExtensions_17 */
static int hf_rrc_sysInfoType15_6_vc50ext;        /* SysInfoType15_6_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_259;      /* T_nonCriticalExtensions_259 */
static int hf_rrc_ue_positioning_GANSS_ReferenceMeasurementInformation_01;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo_va40ext */
static int hf_rrc_ue_positioning_GANSS_ReferenceMeasurementInformation_02;  /* UE_Positioning_GANSS_ReferenceMeasurementInfo_vc50ext */
static int hf_rrc_ue_positioning_GANSS_DataBitAssistance;  /* UE_Positioning_GANSS_Data_Bit_Assistance */
static int hf_rrc_nonCriticalExtensions_260;      /* T_nonCriticalExtensions_260 */
static int hf_rrc_ue_positioning_GANSS_DataCipheringInfo;  /* UE_Positioning_CipherParameters */
static int hf_rrc_ue_positioning_GANSS_realTimeIntegrity;  /* UE_Positioning_GANSS_RealTimeIntegrity */
static int hf_rrc_nonCriticalExtensions_261;      /* T_nonCriticalExtensions_261 */
static int hf_rrc_preDefinedRadioConfiguration;   /* PreDefRadioConfiguration */
static int hf_rrc_v770NonCriticalExtensions_46;   /* T_v770NonCriticalExtensions_46 */
static int hf_rrc_sysInfoType16_v770ext;          /* SysInfoType16_v770ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_06;   /* T_v920NonCriticalExtensions_06 */
static int hf_rrc_sysInfoType16_v920ext;          /* SysInfoType16_v920ext_IEs */
static int hf_rrc_nonCriticalExtensions_262;      /* T_nonCriticalExtensions_262 */
static int hf_rrc_preDefinedRadioConfiguration_01;  /* PreDefRadioConfiguration_v770ext */
static int hf_rrc_preDefinedRadioConfiguration_02;  /* PreDefRadioConfiguration_v920ext */
static int hf_rrc_pusch_SysInfoList;              /* PUSCH_SysInfoList */
static int hf_rrc_pdsch_SysInfoList;              /* PDSCH_SysInfoList */
static int hf_rrc_v4b0NonCriticalExtensions_26;   /* T_v4b0NonCriticalExtensions_26 */
static int hf_rrc_sysInfoType17_v4b0ext;          /* SysInfoType17_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_30;   /* T_v590NonCriticalExtensions_30 */
static int hf_rrc_sysInfoType17_v590ext;          /* SysInfoType17_v590ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_47;   /* T_v770NonCriticalExtensions_47 */
static int hf_rrc_sysInfoType17_v770ext;          /* SysInfoType17_v770ext_IEs */
static int hf_rrc_nonCriticalExtensions_263;      /* T_nonCriticalExtensions_263 */
static int hf_rrc_tdd128SpecificInfo_02;          /* T_tdd128SpecificInfo_02 */
static int hf_rrc_pusch_SysInfoList_01;           /* PUSCH_SysInfoList_LCR_r4 */
static int hf_rrc_pdsch_SysInfoList_01;           /* PDSCH_SysInfoList_LCR_r4 */
static int hf_rrc_hcr_r5_SpecificInfo_02;         /* T_hcr_r5_SpecificInfo_02 */
static int hf_rrc_pusch_SysInfoList_02;           /* PUSCH_SysInfoList_HCR_r5 */
static int hf_rrc_pdsch_SysInfoList_02;           /* PDSCH_SysInfoList_HCR_r5 */
static int hf_rrc_tdd768SpecificInfo_01;          /* T_tdd768SpecificInfo_01 */
static int hf_rrc_idleModePLMNIdentities;         /* PLMNIdentitiesOfNeighbourCells */
static int hf_rrc_connectedModePLMNIdentities;    /* PLMNIdentitiesOfNeighbourCells */
static int hf_rrc_v6b0NonCriticalExtensions_19;   /* T_v6b0NonCriticalExtensions_18 */
static int hf_rrc_sysInfoType18_v6b0ext;          /* SysInfoType18_v6b0ext */
static int hf_rrc_v860NonCriticalExtensions_32;   /* T_v860NonCriticalExtensions_32 */
static int hf_rrc_sysInfoType18_v860ext;          /* SysInfoType18_v860ext */
static int hf_rrc_vc50NonCriticalExtensions_18;   /* T_vc50NonCriticalExtensions_18 */
static int hf_rrc_sysInfoType18_vc50ext;          /* SysInfoType18_vc50ext */
static int hf_rrc_nonCriticalExtensions_264;      /* T_nonCriticalExtensions_264 */
static int hf_rrc_idleModePLMNIdentitiesSIB11bis;  /* PLMNIdentitiesOfNeighbourCells */
static int hf_rrc_connectedModePLMNIdentitiesSIB11bis;  /* PLMNIdentitiesOfNeighbourCells */
static int hf_rrc_idleModePLMNIdentities_01;      /* PLMNIdentitiesOfNeighbourCells_v860ext */
static int hf_rrc_connectedModePLMNIdentities_01;  /* PLMNIdentitiesOfNeighbourCells_v860ext */
static int hf_rrc_idleModePLMNIdentitiesSIB11ter;  /* PLMNIdentitiesOfNeighbourCells_vc50ext */
static int hf_rrc_connectedModePLMNIdentitiesSIB11ter;  /* PLMNIdentitiesOfNeighbourCells_vc50ext */
static int hf_rrc_utra_PriorityInfoList;          /* UTRA_PriorityInfoList */
static int hf_rrc_gsm_PriorityInfoList;           /* GSM_PriorityInfoList */
static int hf_rrc_eutra_FrequencyAndPriorityInfoList;  /* EUTRA_FrequencyAndPriorityInfoList */
static int hf_rrc_v920NonCriticalExtensions_07;   /* T_v920NonCriticalExtensions_07 */
static int hf_rrc_sysInfoType19_v920ext;          /* SysInfoType19_v920ext */
static int hf_rrc_va80NonCriticalExtensions_07;   /* T_va80NonCriticalExtensions_07 */
static int hf_rrc_sysInfoType19_va80ext;          /* SysInfoType19_va80ext */
static int hf_rrc_vb30NonCriticalExtensions;      /* T_vb30NonCriticalExtensions */
static int hf_rrc_sysInfoType19_vb30ext;          /* SysInfoType19_vb30ext */
static int hf_rrc_vb50NonCriticalExtensions_25;   /* T_vb50NonCriticalExtensions_24 */
static int hf_rrc_sysInfoType19_vb50ext;          /* SysInfoType19_vb50ext */
static int hf_rrc_vb80NonCriticalExtensions_01;   /* T_vb80NonCriticalExtensions_01 */
static int hf_rrc_sysInfoType19_vb80ext;          /* SysInfoType19_vb80ext */
static int hf_rrc_vc50NonCriticalExtensions_19;   /* T_vc50NonCriticalExtensions_19 */
static int hf_rrc_sysInfoType19_vc50ext;          /* SysInfoType19_vc50ext */
static int hf_rrc_vd20NonCriticalExtensions_04;   /* T_vd20NonCriticalExtensions_04 */
static int hf_rrc_sysInfoType19_vd20ext;          /* SysInfoType19_vd20ext */
static int hf_rrc_nonCriticalExtensions_265;      /* T_nonCriticalExtensions_265 */
static int hf_rrc_utra_PriorityInfoList_v920ext;  /* UTRA_PriorityInfoList_v920ext */
static int hf_rrc_eutra_FrequencyAndPriorityInfoList_v920ext;  /* EUTRA_FrequencyAndPriorityInfoList_v920ext */
static int hf_rrc_multipleEutraFrequencyInfoList;  /* MultipleEUTRAFrequencyInfoList */
static int hf_rrc_cell_fach_meas_ind;             /* T_cell_fach_meas_ind */
static int hf_rrc_gsmTreselectionScalingFactor;   /* TreselectionScalingFactor2 */
static int hf_rrc_eutraTreselectionScalingFactor;  /* TreselectionScalingFactor2 */
static int hf_rrc_numberOfApplicableEARFCN;       /* INTEGER_0_7 */
static int hf_rrc_eutra_FrequencyAndPriorityInfoList_vb50ext;  /* EUTRA_FrequencyAndPriorityInfoList_vb50ext */
static int hf_rrc_eutra_FrequencyAndPriorityInfoExtensionList;  /* EUTRA_FrequencyAndPriorityInfoExtensionList */
static int hf_rrc_multipleEutraFrequencyInfoExtensionList;  /* MultipleEUTRAFrequencyInfoExtensionList */
static int hf_rrc_eutra_FrequencyRACHReportingInfo;  /* EUTRA_FrequencyRACHReportingInfo */
static int hf_rrc_eutra_FrequencyAndPriorityInfoExtensionList_vb80ext;  /* EUTRA_FrequencyAndPriorityInfoExtensionList_vb80ext */
static int hf_rrc_eutra_FrequencyRACHReportingInfo_vc50ext;  /* EUTRA_FrequencyRACHReportingInfo_vc50ext */
static int hf_rrc_eutra_FrequencyAndPriorityInfoList_vc50ext;  /* EUTRA_FrequencyAndPriorityInfoList_vc50ext */
static int hf_rrc_eutra_FrequencyAndPriorityInfoExtensionList_vc50ext;  /* EUTRA_FrequencyAndPriorityInfoExtensionList_vc50ext */
static int hf_rrc_eutra_FrequencyAndPriorityInfoList_vd20ext;  /* EUTRA_FrequencyAndPriorityInfoList_vd20ext */
static int hf_rrc_eutra_FrequencyAndPriorityInfoExtensionList_vd20ext;  /* EUTRA_FrequencyAndPriorityInfoExtensionList_vd20ext */
static int hf_rrc_hNBName;                        /* HNBName */
static int hf_rrc_nonCriticalExtensions_266;      /* T_nonCriticalExtensions_266 */
static int hf_rrc_eab_Parameters;                 /* EAB_Parameters */
static int hf_rrc_nonCriticalExtensions_267;      /* T_nonCriticalExtensions_267 */
static int hf_rrc_prach_PreambleForEnhancedUplinkListType1Ext;  /* PRACH_PreambleForEnhancedUplinkExtList */
static int hf_rrc_prach_PreambleForEnhancedUplinkListType2Ext;  /* PRACH_PreambleForEnhancedUplinkExtList */
static int hf_rrc_prach_PreambleForEnhancedUplinkListType3Ext;  /* PRACH_PreambleForEnhancedUplinkExtList */
static int hf_rrc_concurrent_Deployment_2ms_10ms_TTI;  /* Concurrent_Deployment_2ms_10ms_TTI */
static int hf_rrc_nodeB_Trigger_HS_DPCCH_Transmission;  /* NodeB_Trigger_HS_DPCCH_Transmission */
static int hf_rrc_fallback_R99_PRACH_info;        /* Fallback_R99_PRACH_info_IEs */
static int hf_rrc_commonEDCHResourceConfigInfoListExt;  /* CommonEDCHResourceConfigInfoListExt */
static int hf_rrc_hs_dsch_DrxCellfach_SecondDrx_info;  /* HS_DSCH_DrxCellfach_SecondDrx_info */
static int hf_rrc_vc50NonCriticalExtensions_20;   /* T_vc50NonCriticalExtensions_20 */
static int hf_rrc_sysInfoType22_vc50ext;          /* SysInfoType22_vc50ext_IEs */
static int hf_rrc_nonCriticalExtensions_268;      /* T_nonCriticalExtensions_268 */
static int hf_rrc_cell_Reselection_indication_reporting;  /* T_cell_Reselection_indication_reporting */
static int hf_rrc_wlanRepresentation;             /* T_wlanRepresentation */
static int hf_rrc_wlanOffloadInformationPerPLMN_List;  /* WLANOffloadInformationPerPLMN_List */
static int hf_rrc_wlanOffloadInformationForAll;   /* WLANOffloadInformation */
static int hf_rrc_nonCriticalExtensions_269;      /* T_nonCriticalExtensions_269 */
static int hf_rrc_dtchTransmissionBlocked;        /* BIT_STRING_SIZE_maxNumAccessGroups */
static int hf_rrc_nonCriticalExtensions_270;      /* T_nonCriticalExtensions_270 */
static int hf_rrc_acdc_Parameters;                /* ACDC_Parameters */
static int hf_rrc_nonCriticalExtensions_271;      /* T_nonCriticalExtensions_271 */
static int hf_rrc_sib_ReferenceList;              /* SIB_ReferenceList */
static int hf_rrc_v6b0NonCriticalExtensions_20;   /* T_v6b0NonCriticalExtensions_19 */
static int hf_rrc_sysInfoTypeSB1_v6b0ext;         /* SysInfoTypeSB1_v6b0ext */
static int hf_rrc_v860NonCriticalExtensions_33;   /* T_v860NonCriticalExtensions_33 */
static int hf_rrc_sysInfoTypeSB1_v860ext;         /* SysInfoTypeSB1_v860ext */
static int hf_rrc_vc50NonCriticalExtensions_21;   /* T_vc50NonCriticalExtensions_21 */
static int hf_rrc_sysInfoTypeSB1_vc50ext;         /* SysInfoTypeSB1_vc50ext */
static int hf_rrc_nonCriticalExtensions_272;      /* T_nonCriticalExtensions_272 */
static int hf_rrc_sib_ReferenceList_01;           /* SIBSb_ReferenceList2 */
static int hf_rrc_v6b0NonCriticalExtensions_21;   /* T_v6b0NonCriticalExtensions_20 */
static int hf_rrc_sysInfoTypeSB2_v6b0ext;         /* SysInfoTypeSB2_v6b0ext */
static int hf_rrc_v860NonCriticalExtensions_34;   /* T_v860NonCriticalExtensions_34 */
static int hf_rrc_sysInfoTypeSB2_v860ext;         /* SysInfoTypeSB2_v860ext */
static int hf_rrc_vc50NonCriticalExtensions_22;   /* T_vc50NonCriticalExtensions_22 */
static int hf_rrc_sysInfoTypeSB2_vc50ext;         /* SysInfoTypeSB2_vc50ext */
static int hf_rrc_nonCriticalExtensions_273;      /* T_nonCriticalExtensions_273 */
static int hf_rrc_sib_ReferenceList_02;           /* SIB_ReferenceList2 */
static int hf_rrc_nonCriticalExtensions_274;      /* T_nonCriticalExtensions_274 */
static int hf_rrc_TDD_UMTS_Frequency_List_item;   /* FrequencyInfoTDD */
static int hf_rrc_modeSpecificInfo_169;           /* T_modeSpecificInfo_169 */
static int hf_rrc_fdd_214;                        /* T_fdd_208 */
static int hf_rrc_connEstFailCount;               /* T_connEstFailCount */
static int hf_rrc_offsetValidity;                 /* T_offsetValidity */
static int hf_rrc_connEstFailTempQoffset;         /* INTEGER_0_15 */
static int hf_rrc_ue_InactivityPeriod;            /* INTEGER_1_120 */
static int hf_rrc_ul_dataVolumeHistory;           /* DataVolumeHistory */
static int hf_rrc_dl_dataVolumeHistory;           /* DataVolumeHistory */
static int hf_rrc_none;                           /* NULL */
static int hf_rrc_plmn_ValueTag;                  /* PLMN_ValueTag */
static int hf_rrc_sIBOccurrenceIdentityAndValueTag;  /* SIBOccurrenceIdentityAndValueTag */
static int hf_rrc_cellValueTag_01;                /* CellValueTag2 */
static int hf_rrc_commonRBIdentity;               /* MBMS_CommonRBIdentity */
static int hf_rrc_rlc_Info_05;                    /* RLC_Info_MTCH_r6 */
static int hf_rrc_MBMS_CommonRBInformationList_r6_item;  /* MBMS_CommonRBInformation_r6 */
static int hf_rrc_countingForUraPCH;              /* BOOLEAN */
static int hf_rrc_countingForCellPCH;             /* BOOLEAN */
static int hf_rrc_countingForCellFACH;            /* BOOLEAN */
static int hf_rrc_sccpchIdentity;                 /* MBMS_SCCPCHIdentity */
static int hf_rrc_secondaryCCPCH_Info_03;         /* MBMS_CommonPhyChIdentity */
static int hf_rrc_softComb_TimingOffset;          /* MBMS_SoftComb_TimingOffset */
static int hf_rrc_transpCh_InfoCommonForAllTrCh;  /* MBMS_CommonCCTrChIdentity */
static int hf_rrc_transpCHInformation;            /* MBMS_TrCHInformation_CurrList */
static int hf_rrc_MBMS_CurrentCell_SCCPCHList_r6_item;  /* MBMS_CurrentCell_SCCPCH_r6 */
static int hf_rrc_MBMS_FACHCarryingMTCH_List_item;  /* TransportFormatSet */
static int hf_rrc_cycleOffset;                    /* INTEGER_0_7 */
static int hf_rrc_mtch_L1CombiningPeriodList;     /* T_mtch_L1CombiningPeriodList */
static int hf_rrc_mtch_L1CombiningPeriodList_item;  /* T_mtch_L1CombiningPeriodList_item */
static int hf_rrc_periodStart;                    /* INTEGER_0_7 */
static int hf_rrc_periodDuration;                 /* INTEGER_1_8 */
static int hf_rrc_cycleOffset_01;                 /* INTEGER_0_15 */
static int hf_rrc_mtch_L1CombiningPeriodList_01;  /* T_mtch_L1CombiningPeriodList_01 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_01;  /* T_mtch_L1CombiningPeriodList_item_01 */
static int hf_rrc_periodStart_01;                 /* INTEGER_0_15 */
static int hf_rrc_periodDuration_01;              /* INTEGER_1_16 */
static int hf_rrc_cycleOffset_02;                 /* INTEGER_0_31 */
static int hf_rrc_mtch_L1CombiningPeriodList_02;  /* T_mtch_L1CombiningPeriodList_02 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_02;  /* T_mtch_L1CombiningPeriodList_item_02 */
static int hf_rrc_periodStart_02;                 /* INTEGER_0_31 */
static int hf_rrc_periodDuration_02;              /* INTEGER_1_32 */
static int hf_rrc_cycleOffset_03;                 /* INTEGER_0_63 */
static int hf_rrc_mtch_L1CombiningPeriodList_03;  /* T_mtch_L1CombiningPeriodList_03 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_03;  /* T_mtch_L1CombiningPeriodList_item_03 */
static int hf_rrc_periodStart_03;                 /* INTEGER_0_63 */
static int hf_rrc_periodDuration_03;              /* INTEGER_1_64 */
static int hf_rrc_cycleOffset_04;                 /* INTEGER_0_127 */
static int hf_rrc_mtch_L1CombiningPeriodList_04;  /* T_mtch_L1CombiningPeriodList_04 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_04;  /* T_mtch_L1CombiningPeriodList_item_04 */
static int hf_rrc_periodStart_04;                 /* INTEGER_0_127 */
static int hf_rrc_periodDuration_04;              /* INTEGER_1_128 */
static int hf_rrc_cycleOffset_05;                 /* INTEGER_0_255 */
static int hf_rrc_mtch_L1CombiningPeriodList_05;  /* T_mtch_L1CombiningPeriodList_05 */
static int hf_rrc_mtch_L1CombiningPeriodList_item_05;  /* T_mtch_L1CombiningPeriodList_item_05 */
static int hf_rrc_periodStart_05;                 /* INTEGER_0_255 */
static int hf_rrc_periodDuration_05;              /* INTEGER_1_256 */
static int hf_rrc_cycleLength_32;                 /* MBMS_L1CombiningSchedule_32 */
static int hf_rrc_cycleLength_64;                 /* MBMS_L1CombiningSchedule_64 */
static int hf_rrc_cycleLength_128;                /* MBMS_L1CombiningSchedule_128 */
static int hf_rrc_cycleLength_256;                /* MBMS_L1CombiningSchedule_256 */
static int hf_rrc_cycleLength_512;                /* MBMS_L1CombiningSchedule_512 */
static int hf_rrc_cycleLength_1024;               /* MBMS_L1CombiningSchedule_1024 */
static int hf_rrc_sameAsCurrent;                  /* T_sameAsCurrent */
static int hf_rrc_currentCell_SCCPCH;             /* MBMS_SCCPCHIdentity */
static int hf_rrc_msch_ConfigurationInfo;         /* MBMS_MSCH_ConfigurationInfo_r6 */
static int hf_rrc_different;                      /* T_different */
static int hf_rrc_transpCHInformation_01;         /* MBMS_TrCHInformation_NeighbList */
static int hf_rrc_accessInfoPeriodCoefficient;    /* INTEGER_0_3 */
static int hf_rrc_repetitionPeriodCoefficient;    /* INTEGER_0_3 */
static int hf_rrc_modificationPeriodCoefficient;  /* INTEGER_7_10 */
static int hf_rrc_rlc_Info_06;                    /* RLC_Info_MCCH_r6 */
static int hf_rrc_tctf_Presence;                  /* MBMS_TCTF_Presence */
static int hf_rrc_michPowerOffset;                /* MBMS_MICHPowerOffset */
static int hf_rrc_mode_03;                        /* T_mode_03 */
static int hf_rrc_fdd_215;                        /* T_fdd_209 */
static int hf_rrc_ni_CountPerFrame;               /* MBMS_NI_CountPerFrame */
static int hf_rrc_tdd384_52;                      /* T_tdd384_47 */
static int hf_rrc_repetitionPeriodLengthOffset_01;  /* RepPerLengthOffset_MICH */
static int hf_rrc_mbmsNotificationIndLength;      /* MBMS_MICHNotificationIndLength */
static int hf_rrc_tdd128_80;                      /* T_tdd128_77 */
static int hf_rrc_channelisationCodeList_02;      /* SEQUENCE_SIZE_1_2_OF_DL_TS_ChannelisationCode */
static int hf_rrc_channelisationCodeList_item;    /* DL_TS_ChannelisationCode */
static int hf_rrc_mode_04;                        /* T_mode_04 */
static int hf_rrc_tdd384_53;                      /* T_tdd384_48 */
static int hf_rrc_tdd768_30;                      /* T_tdd768_27 */
static int hf_rrc_midambleShiftAndBurstType_06;   /* MidambleShiftAndBurstType_VHCR */
static int hf_rrc_tdd128_81;                      /* T_tdd128_78 */
static int hf_rrc_mode_05;                        /* T_mode_05 */
static int hf_rrc_imb384;                         /* T_imb384 */
static int hf_rrc_ni_CountPerFrame_01;            /* MBMS_NI_CountPerFrame_IMB384 */
static int hf_rrc_mbms_TransmissionIdentity;      /* MBMS_TransmissionIdentity */
static int hf_rrc_mbms_RequiredUEAction;          /* MBMS_RequiredUEAction_Mod */
static int hf_rrc_mbms_PreferredFrequency;        /* T_mbms_PreferredFrequency */
static int hf_rrc_mcch;                           /* MBMS_PFLIndex */
static int hf_rrc_dcch;                           /* MBMS_PFLInfo */
static int hf_rrc_dummy_enum;                     /* T_dummy_enum */
static int hf_rrc_continueMCCHReading;            /* BOOLEAN */
static int hf_rrc_MBMS_ModifedServiceList_r6_item;  /* MBMS_ModifedService_r6 */
static int hf_rrc_mbsfnClusterFrequency;          /* MBSFN_ClusterFrequency_r7 */
static int hf_rrc_rbReleaseCause;                 /* MBMS_PTM_RBReleaseCause_LCR_r7 */
static int hf_rrc_MBMS_ModifiedServiceList_v770ext_item;  /* MBMS_ModifiedService_v770ext */
static int hf_rrc_MBMS_ModifiedServiceList_LCR_v7c0ext_item;  /* MBMS_ModifiedService_LCR_v7c0ext */
static int hf_rrc_mschShedulingInfo;              /* MBMS_MSCHSchedulingInfo */
static int hf_rrc_rlc_Info_07;                    /* RLC_Info_MSCH_r6 */
static int hf_rrc_schedulingPeriod_32_Offset;     /* INTEGER_0_31 */
static int hf_rrc_schedulingPeriod_64_Offset;     /* INTEGER_0_63 */
static int hf_rrc_schedulingPeriod_128_Offset;    /* INTEGER_0_127 */
static int hf_rrc_schedulingPeriod_256_Offset;    /* INTEGER_0_255 */
static int hf_rrc_schedulingPeriod_512_Offset;    /* INTEGER_0_511 */
static int hf_rrc_schedulingPeriod_1024_Offset;   /* INTEGER_0_1023 */
static int hf_rrc_secondaryCCPCHPwrOffsetDiff;    /* MBMS_SCCPCHPwrOffsetDiff */
static int hf_rrc_layer1Combining;                /* T_layer1Combining */
static int hf_rrc_fdd_216;                        /* T_fdd_210 */
static int hf_rrc_mbms_L1CombiningTransmTimeDiff;  /* MBMS_L1CombiningTransmTimeDiff */
static int hf_rrc_mbms_L1CombiningSchedule;       /* MBMS_L1CombiningSchedule */
static int hf_rrc_mbms_L23Configuration;          /* MBMS_L23Configuration */
static int hf_rrc_secondaryCCPCH_InfoDiff;        /* SecondaryCCPCHInfoDiff_MBMS */
static int hf_rrc_layer1Combining_01;             /* T_layer1Combining_01 */
static int hf_rrc_fdd_217;                        /* T_fdd_211 */
static int hf_rrc_MBMS_NeighbouringCellSCCPCHList_r6_item;  /* MBMS_NeighbouringCellSCCPCH_r6 */
static int hf_rrc_MBMS_NeighbouringCellSCCPCHList_v770ext_item;  /* MBMS_NeighbouringCellSCCPCH_v770ext */
static int hf_rrc_networkStandardTime;            /* BIT_STRING_SIZE_40 */
static int hf_rrc_correlativeSFN;                 /* INTEGER_0_4095 */
static int hf_rrc_mbms_CommonPhyChIdentity;       /* MBMS_CommonPhyChIdentity */
static int hf_rrc_secondaryCCPCHInfo_MBMS_02;     /* SecondaryCCPCHFrameType2Info */
static int hf_rrc_MBMS_PhyChInformationList_IMB384_item;  /* MBMS_PhyChInformation_IMB384 */
static int hf_rrc_MBMS_PhyChInformationList_r6_item;  /* MBMS_PhyChInformation_r6 */
static int hf_rrc_MBMS_PhyChInformationList_r7_item;  /* MBMS_PhyChInformation_r7 */
static int hf_rrc_mbmsPreferredFrequency;         /* INTEGER_1_maxMBMS_Freq */
static int hf_rrc_layerConvergenceInformation;    /* T_layerConvergenceInformation */
static int hf_rrc_mbms_Qoffset;                   /* MBMS_Qoffset */
static int hf_rrc_mbms_HCSoffset;                 /* INTEGER_0_7 */
static int hf_rrc_MBMS_PreferredFrequencyList_r6_item;  /* MBMS_PreferredFrequencyInfo_r6 */
static int hf_rrc_rbInformation;                  /* MBMS_CommonRBIdentity */
static int hf_rrc_shortTransmissionID;            /* MBMS_ShortTransmissionID */
static int hf_rrc_logicalChIdentity;              /* MBMS_LogicalChIdentity */
static int hf_rrc_MBMS_PTM_RBInformation_CList_item;  /* MBMS_PTM_RBInformation_C */
static int hf_rrc_layer1_CombiningStatus;         /* BOOLEAN */
static int hf_rrc_MBMS_PTM_RBInformation_NList_item;  /* MBMS_PTM_RBInformation_N */
static int hf_rrc_status;                         /* T_status */
static int hf_rrc_some;                           /* MBMS_SelectedServicesListFull */
static int hf_rrc_MBMS_SelectedServicesListFull_item;  /* MBMS_ServiceIdentity_r6 */
static int hf_rrc_MBMS_SelectedServicesListShort_item;  /* MBMS_ShortTransmissionID */
static int hf_rrc_mbms_SelectedServicesList;      /* MBMS_SelectedServicesListShort */
static int hf_rrc_modificationPeriodIdentity;     /* INTEGER_0_1 */
static int hf_rrc_accessprobabilityFactor_Idle;   /* MBMS_AccessProbabilityFactor */
static int hf_rrc_accessprobabilityFactor_Connected;  /* MBMS_AccessProbabilityFactor */
static int hf_rrc_mbms_ConnectedModeCountingScope;  /* MBMS_ConnectedModeCountingScope */
static int hf_rrc_MBMS_ServiceAccessInfoList_r6_item;  /* MBMS_ServiceAccessInfo_r6 */
static int hf_rrc_serviceIdentity;                /* OCTET_STRING_SIZE_3 */
static int hf_rrc_plmn_Identity_01;               /* T_plmn_Identity */
static int hf_rrc_sameAsMIB_PLMN_Id;              /* NULL */
static int hf_rrc_other_01;                       /* T_other_01 */
static int hf_rrc_sameAsMIB_MultiPLMN_Id;         /* INTEGER_1_5 */
static int hf_rrc_explicitPLMN_Id;                /* PLMN_Identity */
static int hf_rrc_mbms_ServiceTransmInfoList;     /* MBMS_ServiceTransmInfoList */
static int hf_rrc_nextSchedulingperiod;           /* INTEGER_0_31 */
static int hf_rrc_MBMS_ServiceSchedulingInfoList_r6_item;  /* MBMS_ServiceSchedulingInfo_r6 */
static int hf_rrc_start;                          /* INTEGER_0_255 */
static int hf_rrc_duration;                       /* INTEGER_1_256 */
static int hf_rrc_MBMS_ServiceTransmInfoList_item;  /* MBMS_ServiceTransmInfo */
static int hf_rrc_transpCHInformation_02;         /* MBMS_TrCHInformation_SIB5List */
static int hf_rrc_MBMS_SIBType5_SCCPCHList_r6_item;  /* MBMS_SIBType5_SCCPCH_r6 */
static int hf_rrc_t_318;                          /* T_318 */
static int hf_rrc_mbms_ServiceIdentity_01;        /* MBMS_ServiceIdentity_r6 */
static int hf_rrc_commonCCTrChIdentity;           /* MBMS_CommonCCTrChIdentity */
static int hf_rrc_MBMS_TranspChInfoForEachCCTrCh_r6_item;  /* MBMS_TranspChInfoForCCTrCh_r6 */
static int hf_rrc_MBMS_TranspChInfoForEachTrCh_r6_item;  /* MBMS_TranspChInfoForTrCh_r6 */
static int hf_rrc_commonTrChIdentity;             /* MBMS_CommonTrChIdentity */
static int hf_rrc_transpCh_Info;                  /* MBMS_CommonTrChIdentity */
static int hf_rrc_rbInformation_01;               /* MBMS_PTM_RBInformation_CList */
static int hf_rrc_MBMS_TrCHInformation_CurrList_item;  /* MBMS_TrCHInformation_Curr */
static int hf_rrc_transpCh_CombiningStatus;       /* BOOLEAN */
static int hf_rrc_rbInformation_02;               /* MBMS_PTM_RBInformation_NList */
static int hf_rrc_MBMS_TrCHInformation_NeighbList_item;  /* MBMS_TrCHInformation_Neighb */
static int hf_rrc_transpCh_Identity;              /* INTEGER_1_maxFACHPCH */
static int hf_rrc_MBMS_TrCHInformation_SIB5List_item;  /* MBMS_TrCHInformation_SIB5 */
static int hf_rrc_mbms_RequiredUEAction_01;       /* MBMS_RequiredUEAction_UMod */
static int hf_rrc_mbms_PreferredFrequency_01;     /* MBMS_PFLIndex */
static int hf_rrc_MBMS_UnmodifiedServiceList_r6_item;  /* MBMS_UnmodifiedService_r6 */
static int hf_rrc_MBMS_UnmodifiedServiceList_v770ext_item;  /* MBMS_UnmodifiedService_v770ext */
static int hf_rrc_imb_Indication;                 /* T_imb_Indication */
static int hf_rrc_MBSFNFrequencyList_item;        /* MBSFNFrequency */
static int hf_rrc_MBSFNFrequencyList_v860ext_item;  /* MBSFNFrequency_v860ext */
static int hf_rrc_notificationOfAllMBSFNServicesInTheBand;  /* T_notificationOfAllMBSFNServicesInTheBand */
static int hf_rrc_mbsfnFrequency;                 /* FrequencyInfo */
static int hf_rrc_mbsfnServicesNotification;      /* T_mbsfnServicesNotification */
static int hf_rrc_mbsfnServicesNotified;          /* NULL */
static int hf_rrc_mbsfnServicesNotNotified;       /* MBSFNservicesNotNotified_r7 */
static int hf_rrc_imb_Indication_01;              /* T_imb_Indication_01 */
static int hf_rrc_MBSFN_InterFrequencyNeighbourList_r7_item;  /* MBSFNInterFrequencyNeighbour_r7 */
static int hf_rrc_MBSFN_InterFrequencyNeighbourList_v860ext_item;  /* MBSFNInterFrequencyNeighbour_v860ext */
static int hf_rrc_MBSFN_TDDInformation_item;      /* MBSFN_TDDTimeSlotInfo */
static int hf_rrc_MBSFN_TDDInformation_LCR_item;  /* MBSFN_TDDTimeSlotInfo_LCR */
static int hf_rrc_timeSlotNumber_01;              /* TimeslotNumber_LCR_r4 */
static int hf_rrc_frequencyIndex;                 /* INTEGER_1_maxMBSFNClusters */
static int hf_rrc_timeSlotList;                   /* MBSFN_TDDInformation */
static int hf_rrc_tDMPeriod;                      /* INTEGER_2_9 */
static int hf_rrc_tDMOffset;                      /* INTEGER_0_8 */
static int hf_rrc_tDMLength;                      /* INTEGER_1_8 */
static int hf_rrc_MBSFN_TDM_Info_List_item;       /* MBSFN_TDM_Info */
static int hf_rrc_threshServingRSCP;              /* WLANThreshServingRSCP */
static int hf_rrc_threshServingECNO;              /* WLANThreshServingECNO */
static int hf_rrc_threshChannelUtilization;       /* WLANThreshChannelUtilization */
static int hf_rrc_threshBackhaulBandwidth;        /* WLANThreshBackhaulBandwidth */
static int hf_rrc_threshBeaconRSSI;               /* WLANThreshBeaconRSSI */
static int hf_rrc_offloadPreferenceIndicator;     /* BIT_STRING_SIZE_16 */
static int hf_rrc_t_SteeringWLAN;                 /* T_Reselection_S */
static int hf_rrc_threshServingLow_01;            /* INTEGER_M60_M13 */
static int hf_rrc_threshServingHigh;              /* INTEGER_M60_M13 */
static int hf_rrc_threshServingLow2_01;           /* INTEGER_M24_0 */
static int hf_rrc_threshServingHigh2;             /* INTEGER_M24_0 */
static int hf_rrc_threshChannelUtilizationLow;    /* INTEGER_0_255 */
static int hf_rrc_threshChannelUtilizationHigh;   /* INTEGER_0_255 */
static int hf_rrc_threshBackhaulDLBandwidthLow;   /* WLANThreshBackhaulRate */
static int hf_rrc_threshBackhaulDLBandwidthHigh;  /* WLANThreshBackhaulRate */
static int hf_rrc_threshBackhaulULBandwidthLow;   /* WLANThreshBackhaulRate */
static int hf_rrc_threshBackhaulULBandwidthHigh;  /* WLANThreshBackhaulRate */
static int hf_rrc_threshBeaconRSSILow;            /* INTEGER_0_255 */
static int hf_rrc_threshBeaconRSSIHigh;           /* INTEGER_0_255 */
static int hf_rrc_WLANIdentifierList_item;        /* WLANIdentifier */
static int hf_rrc_ssid;                           /* OCTET_STRING_SIZE_1_32 */
static int hf_rrc_bssid;                          /* OCTET_STRING_SIZE_6 */
static int hf_rrc_hessid;                         /* OCTET_STRING_SIZE_6 */
static int hf_rrc_WLANOffloadInformationPerPLMN_List_item;  /* WLANOffloadInformation */
static int hf_rrc_wlanOffloadConfig;              /* WLANOffloadConfig */
static int hf_rrc_wlanIdentifierList;             /* WLANIdentifierList */
static int hf_rrc_interRATHandoverInfoWithInterRATCapabilities_r3;  /* InterRATHandoverInfoWithInterRATCapabilities_r3 */
static int hf_rrc_srncRelocation;                 /* SRNC_RelocationInfo_r3 */
static int hf_rrc_rfc3095_ContextInfo;            /* RFC3095_ContextInfo_r5 */
static int hf_rrc_extension;                      /* NULL */
static int hf_rrc_rrc_FailureInfo;                /* RRC_FailureInfo */
static int hf_rrc_dL_DCCHmessage;                 /* T_dL_DCCHmessage */
static int hf_rrc_r3_31;                          /* T_r3_31 */
static int hf_rrc_interRATHandoverInfo_r3;        /* InterRATHandoverInfoWithInterRATCapabilities_r3_IEs */
static int hf_rrc_v390NonCriticalExtensions_01;   /* T_v390NonCriticalExtensions_01 */
static int hf_rrc_interRATHandoverInfoWithInterRATCapabilities_v390ext;  /* InterRATHandoverInfoWithInterRATCapabilities_v390ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_52;   /* T_v690NonCriticalExtensions_52 */
static int hf_rrc_interRATHandoverInfoWithInterRATCapabilities_v690ext;  /* InterRATHandoverInfoWithInterRATCapabilities_v690ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_35;   /* T_v860NonCriticalExtensions_35 */
static int hf_rrc_interRATHandoverInfoWithInterRATCapabilities_v860ext;  /* InterRATHandoverInfoWithInterRATCapabilities_v860ext_IEs */
static int hf_rrc_v920NonCriticalExtensions_08;   /* T_v920NonCriticalExtensions_08 */
static int hf_rrc_interRATHandoverInfoWithInterRATCapabilities_v920ext;  /* InterRATHandoverInfoWithInterRATCapabilities_v920ext_IEs */
static int hf_rrc_nonCriticalExtensions_275;      /* T_nonCriticalExtensions_275 */
static int hf_rrc_criticalExtensions_168;         /* T_criticalExtensions_166 */
static int hf_rrc_interRATHandoverInfo;           /* T_interRATHandoverInfo */
static int hf_rrc_ue_RATSpecificCapability_01;    /* InterRAT_UE_RadioAccessCapability_v860ext */
static int hf_rrc_ue_Inactivity_Period;           /* INTEGER_1_120 */
static int hf_rrc_r5_14;                          /* T_r5_14 */
static int hf_rrc_rFC3095_ContextInfoList_r5;     /* RFC3095_ContextInfoList_r5 */
static int hf_rrc_nonCriticalExtensions_276;      /* T_nonCriticalExtensions_276 */
static int hf_rrc_criticalExtensions_169;         /* T_criticalExtensions_167 */
static int hf_rrc_RFC3095_ContextInfoList_r5_item;  /* RFC3095_ContextInfo */
static int hf_rrc_r3_32;                          /* T_r3_32 */
static int hf_rrc_sRNC_RelocationInfo_r3;         /* SRNC_RelocationInfo_r3_IEs */
static int hf_rrc_v380NonCriticalExtensions_02;   /* T_v380NonCriticalExtensions_02 */
static int hf_rrc_sRNC_RelocationInfo_v380ext;    /* SRNC_RelocationInfo_v380ext_IEs */
static int hf_rrc_v390NonCriticalExtensions_02;   /* T_v390NonCriticalExtensions_02 */
static int hf_rrc_sRNC_RelocationInfo_v390ext;    /* SRNC_RelocationInfo_v390ext_IEs */
static int hf_rrc_v3a0NonCriticalExtensions_16;   /* T_v3a0NonCriticalExtensions_16 */
static int hf_rrc_sRNC_RelocationInfo_v3a0ext;    /* SRNC_RelocationInfo_v3a0ext_IEs */
static int hf_rrc_v3b0NonCriticalExtensions;      /* T_v3b0NonCriticalExtensions */
static int hf_rrc_sRNC_RelocationInfo_v3b0ext;    /* SRNC_RelocationInfo_v3b0ext_IEs */
static int hf_rrc_v3c0NonCriticalExtensions;      /* T_v3c0NonCriticalExtensions */
static int hf_rrc_sRNC_RelocationInfo_v3c0ext;    /* SRNC_RelocationInfo_v3c0ext_IEs */
static int hf_rrc_laterNonCriticalExtensions_70;  /* T_laterNonCriticalExtensions_67 */
static int hf_rrc_sRNC_RelocationInfo_v3d0ext;    /* SRNC_RelocationInfo_v3d0ext_IEs */
static int hf_rrc_sRNC_RelocationInfo_r3_add_ext;  /* T_sRNC_RelocationInfo_r3_add_ext */
static int hf_rrc_v3g0NonCriticalExtensions_02;   /* T_v3g0NonCriticalExtensions_02 */
static int hf_rrc_sRNC_RelocationInfo_v3g0ext;    /* SRNC_RelocationInfo_v3g0ext_IEs */
static int hf_rrc_v4b0NonCriticalExtensions_27;   /* T_v4b0NonCriticalExtensions_27 */
static int hf_rrc_sRNC_RelocationInfo_v4b0ext;    /* SRNC_RelocationInfo_v4b0ext_IEs */
static int hf_rrc_v590NonCriticalExtensions_31;   /* T_v590NonCriticalExtensions_31 */
static int hf_rrc_sRNC_RelocationInfo_v590ext;    /* SRNC_RelocationInfo_v590ext_IEs */
static int hf_rrc_v5a0NonCriticalExtensions;      /* T_v5a0NonCriticalExtensions */
static int hf_rrc_sRNC_RelocationInfo_v5a0ext;    /* SRNC_RelocationInfo_v5a0ext_IEs */
static int hf_rrc_v5b0NonCriticalExtensions_03;   /* T_v5b0NonCriticalExtensions_03 */
static int hf_rrc_sRNC_RelocationInfo_v5b0ext;    /* SRNC_RelocationInfo_v5b0ext_IEs */
static int hf_rrc_v5c0NonCriticalExtensions_02;   /* T_v5c0NonCriticalExtensions_02 */
static int hf_rrc_sRNC_RelocationInfo_v5c0ext;    /* SRNC_RelocationInfo_v5c0ext_IEs */
static int hf_rrc_v690NonCriticalExtensions_53;   /* T_v690NonCriticalExtensions_53 */
static int hf_rrc_sRNC_RelocationInfo_v690ext;    /* SRNC_RelocationInfo_v690ext_IEs */
static int hf_rrc_v6b0NonCriticalExtensions_22;   /* T_v6b0NonCriticalExtensions_21 */
static int hf_rrc_sRNC_RelocationInfo_v6b0ext;    /* SRNC_RelocationInfo_v6b0ext_IEs */
static int hf_rrc_v770NonCriticalExtensions_48;   /* T_v770NonCriticalExtensions_48 */
static int hf_rrc_sRNC_RelocationInfo_v770ext;    /* SRNC_RelocationInfo_v770ext_IEs */
static int hf_rrc_v7e0NonCriticalExtensions_04;   /* T_v7e0NonCriticalExtensions_04 */
static int hf_rrc_sRNC_RelocationInfo_v7e0ext;    /* SRNC_RelocationInfo_v7e0ext_IEs */
static int hf_rrc_v7f0NonCriticalExtensions_17;   /* T_v7f0NonCriticalExtensions_17 */
static int hf_rrc_sRNC_RelocationInfo_v7f0ext;    /* SRNC_RelocationInfo_v7f0ext_IEs */
static int hf_rrc_nonCriticalExtensions_277;      /* T_nonCriticalExtensions_277 */
static int hf_rrc_later_than_r3_28;               /* T_later_than_r3_28 */
static int hf_rrc_r4_14;                          /* T_r4_14 */
static int hf_rrc_sRNC_RelocationInfo_r4;         /* SRNC_RelocationInfo_r4_IEs */
static int hf_rrc_v4d0NonCriticalExtensions_14;   /* T_v4d0NonCriticalExtensions_14 */
static int hf_rrc_sRNC_RelocationInfo_v4d0ext;    /* SRNC_RelocationInfo_v4d0ext_IEs */
static int hf_rrc_sRNC_RelocationInfo_r4_add_ext;  /* BIT_STRING */
static int hf_rrc_v590NonCriticalExtensions_32;   /* T_v590NonCriticalExtensions_32 */
static int hf_rrc_v5a0NonCriticalExtensions_01;   /* T_v5a0NonCriticalExtensions_01 */
static int hf_rrc_v5b0NonCriticalExtensions_04;   /* T_v5b0NonCriticalExtensions_04 */
static int hf_rrc_v5c0NonCriticalExtensions_03;   /* T_v5c0NonCriticalExtensions_03 */
static int hf_rrc_v690NonCriticalExtensions_54;   /* T_v690NonCriticalExtensions_54 */
static int hf_rrc_v6b0NonCriticalExtensions_23;   /* T_v6b0NonCriticalExtensions_22 */
static int hf_rrc_v770NonCriticalExtensions_49;   /* T_v770NonCriticalExtensions_49 */
static int hf_rrc_v7e0NonCriticalExtensions_05;   /* T_v7e0NonCriticalExtensions_05 */
static int hf_rrc_v7f0NonCriticalExtensions_18;   /* T_v7f0NonCriticalExtensions_18 */
static int hf_rrc_nonCriticalExtensions_278;      /* T_nonCriticalExtensions_278 */
static int hf_rrc_criticalExtensions_170;         /* T_criticalExtensions_168 */
static int hf_rrc_r5_15;                          /* T_r5_15 */
static int hf_rrc_sRNC_RelocationInfo_r5;         /* SRNC_RelocationInfo_r5_IEs */
static int hf_rrc_sRNC_RelocationInfo_r5_add_ext;  /* BIT_STRING */
static int hf_rrc_v5a0NonCriticalExtensions_02;   /* T_v5a0NonCriticalExtensions_02 */
static int hf_rrc_v5b0NonCriticalExtensions_05;   /* T_v5b0NonCriticalExtensions_05 */
static int hf_rrc_v5c0NonCriticalExtensions_04;   /* T_v5c0NonCriticalExtensions_04 */
static int hf_rrc_v690NonCriticalExtensions_55;   /* T_v690NonCriticalExtensions_55 */
static int hf_rrc_v6b0NonCriticalExtensions_24;   /* T_v6b0NonCriticalExtensions_23 */
static int hf_rrc_v770NonCriticalExtensions_50;   /* T_v770NonCriticalExtensions_50 */
static int hf_rrc_v7e0NonCriticalExtensions_06;   /* T_v7e0NonCriticalExtensions_06 */
static int hf_rrc_v7f0NonCriticalExtensions_19;   /* T_v7f0NonCriticalExtensions_19 */
static int hf_rrc_nonCriticalExtensions_279;      /* T_nonCriticalExtensions_279 */
static int hf_rrc_criticalExtensions_171;         /* T_criticalExtensions_169 */
static int hf_rrc_r6_12;                          /* T_r6_12 */
static int hf_rrc_sRNC_RelocationInfo_r6;         /* SRNC_RelocationInfo_r6_IEs */
static int hf_rrc_sRNC_RelocationInfo_r6_add_ext;  /* T_sRNC_RelocationInfo_r6_add_ext */
static int hf_rrc_v6b0NonCriticalExtensions_25;   /* T_v6b0NonCriticalExtensions_24 */
static int hf_rrc_v770NonCriticalExtensions_51;   /* T_v770NonCriticalExtensions_51 */
static int hf_rrc_v820NonCriticalExtensions_03;   /* T_v820NonCriticalExtensions_03 */
static int hf_rrc_srnc_RelocationInfo_v820ext;    /* SRNC_RelocationInfo_v820ext_IEs */
static int hf_rrc_v860NonCriticalExtensions_36;   /* T_v860NonCriticalExtensions_36 */
static int hf_rrc_sRNC_RelocationInfo_v860ext;    /* SRNC_RelocationInfo_v860ext_IEs */
static int hf_rrc_nonCriticalExtensions_280;      /* T_nonCriticalExtensions_280 */
static int hf_rrc_criticalExtensions_172;         /* T_criticalExtensions_170 */
static int hf_rrc_r7_16;                          /* T_r7_16 */
static int hf_rrc_sRNC_RelocationInfo_r7;         /* SRNC_RelocationInfo_r7_IEs */
static int hf_rrc_sRNC_RelocationInfo_r7_add_ext;  /* T_sRNC_RelocationInfo_r7_add_ext */
static int hf_rrc_v820NonCriticalExtensions_04;   /* T_v820NonCriticalExtensions_04 */
static int hf_rrc_v860NonCriticalExtensions_37;   /* T_v860NonCriticalExtensions_37 */
static int hf_rrc_nonCriticalExtensions_281;      /* T_nonCriticalExtensions_281 */
static int hf_rrc_criticalExtensions_173;         /* T_criticalExtensions_171 */
static int hf_rrc_r8_12;                          /* T_r8_12 */
static int hf_rrc_sRNC_RelocationInfo_r8;         /* SRNC_RelocationInfo_r8_IEs */
static int hf_rrc_sRNC_RelocationInfo_r8_add_ext;  /* BIT_STRING */
static int hf_rrc_v7e0NonCriticalExtensions_07;   /* T_v7e0NonCriticalExtensions_07 */
static int hf_rrc_v7f0NonCriticalExtensions_20;   /* T_v7f0NonCriticalExtensions_20 */
static int hf_rrc_v8d0NonCriticalExtensions_01;   /* T_v8d0NonCriticalExtensions_01 */
static int hf_rrc_sRNC_RelocationInfo_v8d0ext;    /* SRNC_RelocationInfo_v8d0ext_IEs */
static int hf_rrc_nonCriticalExtensions_282;      /* T_nonCriticalExtensions_282 */
static int hf_rrc_criticalExtensions_174;         /* T_criticalExtensions_172 */
static int hf_rrc_r9_11;                          /* T_r9_11 */
static int hf_rrc_sRNC_RelocationInfo_r9;         /* SRNC_RelocationInfo_r9_IEs */
static int hf_rrc_sRNC_RelocationInfo_r9_add_ext;  /* BIT_STRING */
static int hf_rrc_v8d0NonCriticalExtensions_02;   /* T_v8d0NonCriticalExtensions_02 */
static int hf_rrc_v970NonCriticalExtensions_04;   /* T_v970NonCriticalExtensions_04 */
static int hf_rrc_sRNC_RelocationInfo_v970ext;    /* SRNC_RelocationInfo_v970ext_IEs */
static int hf_rrc_v9c0NonCriticalExtensions_13;   /* T_v9c0NonCriticalExtensions_13 */
static int hf_rrc_sRNC_RelocationInfo_v9c0ext;    /* SRNC_RelocationInfo_v9c0ext_IEs */
static int hf_rrc_nonCriticalExtensions_283;      /* T_nonCriticalExtensions_283 */
static int hf_rrc_criticalExtensions_175;         /* T_criticalExtensions_173 */
static int hf_rrc_r10_13;                         /* T_r10_13 */
static int hf_rrc_sRNC_RelocationInfo_r10;        /* SRNC_RelocationInfo_r10_IEs */
static int hf_rrc_sRNC_RelocationInfo_r10_add_ext;  /* BIT_STRING */
static int hf_rrc_v9c0NonCriticalExtensions_14;   /* T_v9c0NonCriticalExtensions_14 */
static int hf_rrc_vab0NonCriticalExtensions_01;   /* T_vab0NonCriticalExtensions_01 */
static int hf_rrc_sRNC_RelocationInfo_vab0ext;    /* SRNC_RelocationInfo_vab0ext_IEs */
static int hf_rrc_nonCriticalExtensions_284;      /* T_nonCriticalExtensions_284 */
static int hf_rrc_criticalExtensions_176;         /* T_criticalExtensions_174 */
static int hf_rrc_r11_15;                         /* T_r11_15 */
static int hf_rrc_sRNC_RelocationInfo_r11;        /* SRNC_RelocationInfo_r11_IEs */
static int hf_rrc_sRNC_RelocationInfo_r11_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_285;      /* T_nonCriticalExtensions_285 */
static int hf_rrc_criticalExtensions_177;         /* T_criticalExtensions_175 */
static int hf_rrc_r12_12;                         /* T_r12_12 */
static int hf_rrc_sRNC_RelocationInfo_r12;        /* SRNC_RelocationInfo_r12_IEs */
static int hf_rrc_sRNC_RelocationInfo_r12_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_286;      /* T_nonCriticalExtensions_286 */
static int hf_rrc_criticalExtensions_178;         /* T_criticalExtensions_176 */
static int hf_rrc_r13_10;                         /* T_r13_10 */
static int hf_rrc_sRNC_RelocationInfo_r13;        /* SRNC_RelocationInfo_r13_IEs */
static int hf_rrc_sRNC_RelocationInfo_r13_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_287;      /* T_nonCriticalExtensions_287 */
static int hf_rrc_criticalExtensions_179;         /* SRNC_RelocationInfo_LaterCriticalExtensions */
static int hf_rrc_stateOfRRC;                     /* StateOfRRC */
static int hf_rrc_stateOfRRC_Procedure;           /* StateOfRRC_Procedure */
static int hf_rrc_cipheringStatus;                /* CipheringStatus */
static int hf_rrc_calculationTimeForCiphering;    /* CalculationTimeForCiphering */
static int hf_rrc_cipheringInfoPerRB_List;        /* CipheringInfoPerRB_List */
static int hf_rrc_count_C_List;                   /* COUNT_C_List */
static int hf_rrc_integrityProtectionStatus;      /* IntegrityProtectionStatus */
static int hf_rrc_srb_SpecificIntegrityProtInfo;  /* SRB_SpecificIntegrityProtInfoList */
static int hf_rrc_implementationSpecificParams;   /* ImplementationSpecificParams */
static int hf_rrc_c_RNTI;                         /* C_RNTI */
static int hf_rrc_ue_Positioning_LastKnownPos;    /* UE_Positioning_LastKnownPos */
static int hf_rrc_cn_CommonGSM_MAP_NAS_SysInfo_04;  /* NAS_SystemInformationGSM_MAP */
static int hf_rrc_ongoingMeasRepList;             /* OngoingMeasRepList */
static int hf_rrc_rab_InformationList_01;         /* RAB_InformationSetupList */
static int hf_rrc_ul_TransChInfoList_01;          /* UL_AddReconfTransChInfoList */
static int hf_rrc_modeSpecificInfo_170;           /* T_modeSpecificInfo_170 */
static int hf_rrc_fdd_218;                        /* T_fdd_212 */
static int hf_rrc_dl_TransChInfoList_01;          /* DL_AddReconfTransChInfoList */
static int hf_rrc_cipheringStatusList;            /* CipheringStatusList */
static int hf_rrc_cn_DomainInformationList_v390ext;  /* CN_DomainInformationList_v390ext */
static int hf_rrc_cipheringInfoForSRB1_v3a0ext;   /* CipheringInfoPerRB_List_v3a0ext */
static int hf_rrc_startValueForCiphering_v3a0ext;  /* START_Value */
static int hf_rrc_startValueForCiphering_v3b0ext;  /* STARTList2 */
static int hf_rrc_rb_IdentityForHOMessage;        /* RB_Identity */
static int hf_rrc_tpc_CombinationInfoList;        /* TPC_CombinationInfoList */
static int hf_rrc_nonCriticalExtension;           /* T_nonCriticalExtension */
static int hf_rrc_TPC_CombinationInfoList_item;   /* TPC_Combination_Info */
static int hf_rrc_TPC_CombinationInfoList_r9_item;  /* TPC_Combination_Info_r9 */
static int hf_rrc_STARTList2_item;                /* STARTSingle */
static int hf_rrc_storedCompressedModeInfo;       /* StoredCompressedModeInfo */
static int hf_rrc_dl_UM_SN;                       /* BIT_STRING_SIZE_7 */
static int hf_rrc_CipheringStatusList_item;       /* CipheringStatusCNdomain */
static int hf_rrc_CodeChangeStatusList_item;      /* CodeChangeStatus */
static int hf_rrc_storedTGP_SequenceList;         /* StoredTGP_SequenceList */
static int hf_rrc_codeChangeStatusList;           /* CodeChangeStatusList */
static int hf_rrc_storedTGP_SequenceList_01;      /* StoredTGP_SequenceList_r8 */
static int hf_rrc_StoredTGP_SequenceList_item;    /* StoredTGP_Sequence */
static int hf_rrc_StoredTGP_SequenceList_r8_item;  /* StoredTGP_Sequence_r8 */
static int hf_rrc_current_tgps_Status;            /* T_current_tgps_Status */
static int hf_rrc_active;                         /* T_active */
static int hf_rrc_inactive;                       /* NULL */
static int hf_rrc_current_tgps_Status_01;         /* T_current_tgps_Status_01 */
static int hf_rrc_active_01;                      /* T_active_01 */
static int hf_rrc_cipheringStatusList_01;         /* CipheringStatusList_r4 */
static int hf_rrc_latestConfiguredCN_Domain;      /* CN_DomainIdentity */
static int hf_rrc_cipheringInfoPerRB_List_01;     /* CipheringInfoPerRB_List_r4 */
static int hf_rrc_ue_RadioAccessCapability_03;    /* UE_RadioAccessCapability_r4 */
static int hf_rrc_ue_RadioAccessCapability_ext;   /* UE_RadioAccessCapabBandFDDList */
static int hf_rrc_cn_DomainInformationList_01;    /* CN_DomainInformationListFull */
static int hf_rrc_ongoingMeasRepList_01;          /* OngoingMeasRepList_r4 */
static int hf_rrc_rab_InformationList_02;         /* RAB_InformationSetupList_r4 */
static int hf_rrc_dummy_18;                       /* T_dummy_15 */
static int hf_rrc_fdd_219;                        /* T_fdd_213 */
static int hf_rrc_dl_TransChInfoList_02;          /* DL_AddReconfTransChInfoList_r4 */
static int hf_rrc_ue_RadioAccessCapability_04;    /* UE_RadioAccessCapability_r5 */
static int hf_rrc_ue_RATSpecificCapability_02;    /* InterRAT_UE_RadioAccessCapabilityList_r5 */
static int hf_rrc_ongoingMeasRepList_02;          /* OngoingMeasRepList_r5 */
static int hf_rrc_srb_InformationList_01;         /* SRB_InformationSetupList_r5 */
static int hf_rrc_rab_InformationList_03;         /* RAB_InformationSetupList_r5 */
static int hf_rrc_dummy_19;                       /* T_dummy_16 */
static int hf_rrc_fdd_220;                        /* T_fdd_214 */
static int hf_rrc_dl_TransChInfoList_03;          /* DL_AddReconfTransChInfoList_r5 */
static int hf_rrc_ueCapabilityContainer_02;       /* T_ueCapabilityContainer_02 */
static int hf_rrc_ueCapabilityContainer_RSC;      /* T_ueCapabilityContainer_RSC */
static int hf_rrc_ueCapabilityContainer_UCI;      /* T_ueCapabilityContainer_UCI */
static int hf_rrc_intraFreqReportingCriteria_08;  /* IntraFreqReportingCriteria_r6_ext */
static int hf_rrc_ue_RadioAccessCapability_05;    /* UE_RadioAccessCapability_r6 */
static int hf_rrc_ueCapabilityContainer_03;       /* T_ueCapabilityContainer_03 */
static int hf_rrc_ueCapabilityContainer_RSC_01;   /* T_ueCapabilityContainer_RSC_01 */
static int hf_rrc_ueCapabilityContainer_UCI_01;   /* T_ueCapabilityContainer_UCI_01 */
static int hf_rrc_ongoingMeasRepList_03;          /* OngoingMeasRepList_r6 */
static int hf_rrc_srb_InformationList_02;         /* SRB_InformationSetupList_r6 */
static int hf_rrc_rab_InformationList_04;         /* RAB_InformationSetupList_r6 */
static int hf_rrc_ul_TransChInfoList_02;          /* UL_AddReconfTransChInfoList_r6 */
static int hf_rrc_measurementReport_01;           /* T_measurementReport */
static int hf_rrc_v7f0NonCriticalExtensions_21;   /* T_v7f0NonCriticalExtensions_21 */
static int hf_rrc_nonCriticalExtensions_288;      /* T_nonCriticalExtensions_288 */
static int hf_rrc_ueCapabilityContainer_04;       /* T_ueCapabilityContainer_04 */
static int hf_rrc_ueCapabilityContainer_RSC_02;   /* T_ueCapabilityContainer_RSC_02 */
static int hf_rrc_ueCapabilityContainer_UCI_02;   /* T_ueCapabilityContainer_UCI_02 */
static int hf_rrc_srns_t_305;                     /* T_305 */
static int hf_rrc_ongoingMeasRepList_04;          /* OngoingMeasRepList_r7 */
static int hf_rrc_srb_InformationList_03;         /* SRB_InformationSetupList_r7 */
static int hf_rrc_rab_InformationList_05;         /* RAB_InformationSetupList_r7 */
static int hf_rrc_ul_TransChInfoList_03;          /* UL_AddReconfTransChInfoList_r7 */
static int hf_rrc_dl_TransChInfoList_04;          /* DL_AddReconfTransChInfoList_r7 */
static int hf_rrc_measurementReport_02;           /* T_measurementReport_01 */
static int hf_rrc_v7f0NonCriticalExtensions_22;   /* T_v7f0NonCriticalExtensions_22 */
static int hf_rrc_nonCriticalExtensions_289;      /* T_nonCriticalExtensions_289 */
static int hf_rrc_thresholdSFN_GPS_TOW_us;        /* ThresholdSFN_GPS_TOW_us */
static int hf_rrc_ueCapabilityContainer_05;       /* T_ueCapabilityContainer_05 */
static int hf_rrc_ueCapabilityContainer_RSC_03;   /* T_ueCapabilityContainer_RSC_03 */
static int hf_rrc_ueCapabilityContainer_UCI_03;   /* T_ueCapabilityContainer_UCI_03 */
static int hf_rrc_ongoingMeasRepList_05;          /* OngoingMeasRepList_r8 */
static int hf_rrc_srb_InformationList_04;         /* SRB_InformationSetupList_r8 */
static int hf_rrc_rab_InformationList_06;         /* RAB_InformationSetupList_r8 */
static int hf_rrc_e_RGCH_CombinationInfoList;     /* E_RGCH_CombinationInfoList */
static int hf_rrc_storedCompressedModeInfo_01;    /* StoredCompressedModeInfo_r8 */
static int hf_rrc_measurementReport_03;           /* T_measurementReport_02 */
static int hf_rrc_ue_HistoryInformation;          /* UE_HistoryInformation */
static int hf_rrc_rab_InformationList_07;         /* RAB_InformationSetupList_v820ext */
static int hf_rrc_ueCapabilityContainer_06;       /* T_ueCapabilityContainer_06 */
static int hf_rrc_ueCapabilityContainer_RSC_04;   /* T_ueCapabilityContainer_RSC_04 */
static int hf_rrc_ueCapabilityContainer_UCI_04;   /* T_ueCapabilityContainer_UCI_04 */
static int hf_rrc_ongoingMeasRepList_06;          /* OngoingMeasRepList_r9 */
static int hf_rrc_dl_TransChInfoList_05;          /* DL_AddReconfTransChInfoList_r9 */
static int hf_rrc_secondary_tpc_CombinationInfoList;  /* TPC_CombinationInfoList_r9 */
static int hf_rrc_secondary_e_RGCH_CombinationInfoList;  /* E_RGCH_CombinationInfoList_r9 */
static int hf_rrc_measurementReport_04;           /* T_measurementReport_03 */
static int hf_rrc_ongoingMeasRepList_07;          /* OngoingMeasRepList_v970ext_IE */
static int hf_rrc_ueCapabilityContainer_07;       /* T_ueCapabilityContainer_07 */
static int hf_rrc_ueCapabilityContainer_RSC_05;   /* T_ueCapabilityContainer_RSC_05 */
static int hf_rrc_ueCapabilityContainer_UCI_05;   /* T_ueCapabilityContainer_UCI_05 */
static int hf_rrc_ongoingMeasRepList_08;          /* OngoingMeasRepList_r10 */
static int hf_rrc_measurementReport_05;           /* T_measurementReport_04 */
static int hf_rrc_ueCapabilityContainer_08;       /* T_ueCapabilityContainer_08 */
static int hf_rrc_ueCapabilityContainer_RSC_06;   /* T_ueCapabilityContainer_RSC_06 */
static int hf_rrc_ueCapabilityContainer_UCI_06;   /* T_ueCapabilityContainer_UCI_06 */
static int hf_rrc_ongoingMeasRepList_09;          /* OngoingMeasRepList_r11 */
static int hf_rrc_srb_InformationList_05;         /* SRB_InformationSetupList_r11 */
static int hf_rrc_rab_InformationList_08;         /* RAB_InformationSetupList_r11 */
static int hf_rrc_dl_TransChInfoList_06;          /* DL_AddReconfTransChInfoList_r11 */
static int hf_rrc_measurementReport_06;           /* T_measurementReport_05 */
static int hf_rrc_ueCapabilityContainer_09;       /* T_ueCapabilityContainer_09 */
static int hf_rrc_ueCapabilityContainer_RSC_07;   /* T_ueCapabilityContainer_RSC_07 */
static int hf_rrc_ueCapabilityContainer_UCI_07;   /* T_ueCapabilityContainer_UCI_07 */
static int hf_rrc_ongoingMeasRepList_10;          /* OngoingMeasRepList_r12 */
static int hf_rrc_measurementReport_07;           /* T_measurementReport_06 */
static int hf_rrc_ueCapabilityContainer_10;       /* T_ueCapabilityContainer_10 */
static int hf_rrc_ueCapabilityContainer_RSC_08;   /* T_ueCapabilityContainer_RSC_08 */
static int hf_rrc_ueCapabilityContainer_UCI_08;   /* T_ueCapabilityContainer_UCI_08 */
static int hf_rrc_ongoingMeasRepList_11;          /* OngoingMeasRepList_r13 */
static int hf_rrc_measurementReport_08;           /* T_measurementReport_07 */
static int hf_rrc_criticalExtensions_180;         /* T_criticalExtensions_177 */
static int hf_rrc_r14_04;                         /* T_r14_04 */
static int hf_rrc_sRNC_RelocationInfo_r14;        /* SRNC_RelocationInfo_r14_IEs */
static int hf_rrc_sRNC_RelocationInfo_r14_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_290;      /* T_nonCriticalExtensions_290 */
static int hf_rrc_sRNC_RelocationInfo_CriticalExtensions_r15_IEs;  /* SRNC_RelocationInfo_CriticalExtensions_r15_IEs */
static int hf_rrc_criticalExtensions_181;         /* T_criticalExtensions_178 */
static int hf_rrc_r15_04;                         /* T_r15_04 */
static int hf_rrc_sRNC_RelocationInfo_r15;        /* SRNC_RelocationInfo_r15_IEs */
static int hf_rrc_sRNC_RelocationInfo_r15_add_ext;  /* BIT_STRING */
static int hf_rrc_nonCriticalExtensions_291;      /* T_nonCriticalExtensions_291 */
static int hf_rrc_criticalExtensions_182;         /* T_criticalExtensions_179 */
static int hf_rrc_ueCapabilityContainer_11;       /* T_ueCapabilityContainer_11 */
static int hf_rrc_ueCapabilityContainer_RSC_09;   /* T_ueCapabilityContainer_RSC_09 */
static int hf_rrc_ueCapabilityContainer_UCI_09;   /* T_ueCapabilityContainer_UCI_09 */
static int hf_rrc_ongoingMeasRepList_12;          /* OngoingMeasRepList_r14 */
static int hf_rrc_measurementReport_09;           /* T_measurementReport_08 */
static int hf_rrc_ueCapabilityContainer_12;       /* T_ueCapabilityContainer_12 */
static int hf_rrc_ueCapabilityContainer_RSC_10;   /* T_ueCapabilityContainer_RSC_10 */
static int hf_rrc_ueCapabilityContainer_UCI_10;   /* T_ueCapabilityContainer_UCI_10 */
static int hf_rrc_ongoingMeasRepList_13;          /* OngoingMeasRepList_r15 */
static int hf_rrc_measurementReport_10;           /* T_measurementReport_09 */
static int hf_rrc_dl_HFN;                         /* BIT_STRING_SIZE_20_25 */
static int hf_rrc_ul_HFN;                         /* BIT_STRING_SIZE_20_25 */
static int hf_rrc_CipheringInfoPerRB_List_item;   /* CipheringInfoPerRB */
static int hf_rrc_CipheringInfoPerRB_List_r4_item;  /* CipheringInfoPerRB_r4 */
static int hf_rrc_CipheringStatusList_r4_item;    /* CipheringStatusCNdomain_r4 */
static int hf_rrc_CN_DomainInformationList_v390ext_item;  /* CN_DomainInformation_v390ext */
static int hf_rrc_tdd384_Measurements;            /* BOOLEAN */
static int hf_rrc_COUNT_C_List_item;              /* COUNT_CSingle */
static int hf_rrc_count_C;                        /* BIT_STRING_SIZE_32 */
static int hf_rrc_dummy3;                         /* SupportOfDedicatedPilotsForChEstimation */
static int hf_rrc_fdd_hspdsch_01;                 /* T_fdd_hspdsch_01 */
static int hf_rrc_supported_14;                   /* T_supported_07 */
static int hf_rrc_tdd384_hspdsch_01;              /* T_tdd384_hspdsch_01 */
static int hf_rrc_tdd128_hspdsch_01;              /* T_tdd128_hspdsch_01 */
static int hf_rrc_rfc3095_Context_Identity;       /* INTEGER_0_16383 */
static int hf_rrc_dl_mode;                        /* T_dl_mode */
static int hf_rrc_dl_ref_ir;                      /* OCTET_STRING_SIZE_1_3000 */
static int hf_rrc_dl_ref_time;                    /* INTEGER_0_4294967295 */
static int hf_rrc_dl_curr_time;                   /* INTEGER_0_4294967295 */
static int hf_rrc_dl_syn_offset_id;               /* INTEGER_0_65535 */
static int hf_rrc_dl_syn_slope_ts;                /* INTEGER_0_4294967295 */
static int hf_rrc_dl_dyn_changed;                 /* BOOLEAN */
static int hf_rrc_rg_CombinationIndex_01;         /* INTEGER_0_5 */
static int hf_rrc_E_RGCH_CombinationInfoList_item;  /* E_RGCH_Combination_Info */
static int hf_rrc_E_RGCH_CombinationInfoList_r9_item;  /* E_RGCH_Combination_Info_r9 */
static int hf_rrc_interRAT_UE_RadioAccessCapability;  /* InterRAT_UE_RadioAccessCapabilityList */
static int hf_rrc_event_06;                       /* Event1j_r6 */
static int hf_rrc_downlinkCompressedMode_04;      /* CompressedModeMeasCapability_r4 */
static int hf_rrc_uplinkCompressedMode_01;        /* CompressedModeMeasCapability_r4 */
static int hf_rrc_modify_13;                      /* NULL */
static int hf_rrc_setup_12;                       /* MeasurementType_Relocation_r14 */
static int hf_rrc_setup_13;                       /* MeasurementType_Relocation_r15 */
static int hf_rrc_measurementCommandWithType;     /* MeasurementCommandWithType */
static int hf_rrc_additionalMeasurementID_List;   /* AdditionalMeasurementID_List */
static int hf_rrc_measurementCommandWithType_01;  /* MeasurementCommandWithType_r4 */
static int hf_rrc_measurementCommand_v590ext_01;  /* T_measurementCommand_v590ext_01 */
static int hf_rrc_measurementCommandWithType_02;  /* MeasurementCommandWithType_r6 */
static int hf_rrc_measurementCommandWithType_03;  /* MeasurementCommandWithType_r7 */
static int hf_rrc_measurementCommandWithType_04;  /* MeasurementCommandWithType_r8 */
static int hf_rrc_measurementCommandWithType_05;  /* MeasurementCommandWithType_r9 */
static int hf_rrc_additionalMeasurementID_List_01;  /* AdditionalMeasurementID_List_r9 */
static int hf_rrc_measurementCommandWithType_06;  /* MeasurementCommandWithType_r10 */
static int hf_rrc_measurementCommandWithType_07;  /* MeasurementCommandWithType_r11 */
static int hf_rrc_measurementCommandWithType_08;  /* MeasurementCommandWithType_r12 */
static int hf_rrc_measurementCommandWithType_09;  /* MeasurementCommandWithType_r13 */
static int hf_rrc_measurementCommandWithType_10;  /* MeasurementCommandWithType_r14 */
static int hf_rrc_measurementCommandWithType_11;  /* MeasurementCommandWithType_r15 */
static int hf_rrc_OngoingMeasRepList_item;        /* OngoingMeasRep */
static int hf_rrc_OngoingMeasRepList_r4_item;     /* OngoingMeasRep_r4 */
static int hf_rrc_OngoingMeasRepList_r5_item;     /* OngoingMeasRep_r5 */
static int hf_rrc_OngoingMeasRepList_r6_item;     /* OngoingMeasRep_r6 */
static int hf_rrc_OngoingMeasRepList_r7_item;     /* OngoingMeasRep_r7 */
static int hf_rrc_OngoingMeasRepList_r8_item;     /* OngoingMeasRep_r8 */
static int hf_rrc_OngoingMeasRepList_r9_item;     /* OngoingMeasRep_r9 */
static int hf_rrc_OngoingMeasRepList_v970ext_IE_item;  /* OngoingMeasRep_v970ext_IEs */
static int hf_rrc_OngoingMeasRepList_r10_item;    /* OngoingMeasRep_r10 */
static int hf_rrc_OngoingMeasRepList_r11_item;    /* OngoingMeasRep_r11 */
static int hf_rrc_OngoingMeasRepList_r12_item;    /* OngoingMeasRep_r12 */
static int hf_rrc_OngoingMeasRepList_r13_item;    /* OngoingMeasRep_r13 */
static int hf_rrc_OngoingMeasRepList_r14_item;    /* OngoingMeasRep_r14 */
static int hf_rrc_OngoingMeasRepList_r15_item;    /* OngoingMeasRep_r15 */
static int hf_rrc_supportForRfc2507_01;           /* T_supportForRfc2507_01 */
static int hf_rrc_supportForRfc3095_01;           /* T_supportForRfc3095_01 */
static int hf_rrc_supported_15;                   /* T_supported_08 */
static int hf_rrc_supportForRfc2507_02;           /* T_supportForRfc2507_02 */
static int hf_rrc_supported_16;                   /* MaxHcContextSpace_r5 */
static int hf_rrc_supportForRfc3095_02;           /* T_supportForRfc3095_02 */
static int hf_rrc_supported_17;                   /* T_supported_09 */
static int hf_rrc_losslessDLRLC_PDUSizeChange_01;  /* T_losslessDLRLC_PDUSizeChange_01 */
static int hf_rrc_supportForRfc2507_03;           /* T_supportForRfc2507_03 */
static int hf_rrc_supportForRfc3095_03;           /* T_supportForRfc3095_03 */
static int hf_rrc_supported_18;                   /* T_supported_10 */
static int hf_rrc_fddPhysChCapability_11;         /* T_fddPhysChCapability_11 */
static int hf_rrc_downlinkPhysChCapability_19;    /* DL_PhysChCapabilityFDD_r4 */
static int hf_rrc_tdd384_PhysChCapability;        /* T_tdd384_PhysChCapability */
static int hf_rrc_tdd128_PhysChCapability_01;     /* T_tdd128_PhysChCapability_01 */
static int hf_rrc_fddPhysChCapability_12;         /* T_fddPhysChCapability_12 */
static int hf_rrc_downlinkPhysChCapability_20;    /* DL_PhysChCapabilityFDD_r5 */
static int hf_rrc_tdd384_PhysChCapability_01;     /* T_tdd384_PhysChCapability_01 */
static int hf_rrc_downlinkPhysChCapability_21;    /* DL_PhysChCapabilityTDD_r5 */
static int hf_rrc_tdd128_PhysChCapability_02;     /* T_tdd128_PhysChCapability_02 */
static int hf_rrc_downlinkPhysChCapability_22;    /* DL_PhysChCapabilityTDD_LCR_r5 */
static int hf_rrc_fddRF_Capability_04;            /* T_fddRF_Capability_04 */
static int hf_rrc_tdd384_RF_Capability_02;        /* T_tdd384_RF_Capability_01 */
static int hf_rrc_tdd128_RF_Capability_03;        /* T_tdd128_RF_Capability_01 */
static int hf_rrc_rfc3095_Context_List;           /* RFC3095_Context_List */
static int hf_rrc_RFC3095_Context_List_item;      /* RFC3095_Context_List_item */
static int hf_rrc_dl_RFC3095_Context;             /* DL_RFC3095_Context */
static int hf_rrc_ul_RFC3095_Context;             /* UL_RFC3095_Context */
static int hf_rrc_totalRLC_AM_BufferSize_05;      /* TotalRLC_AM_BufferSize_r5 */
static int hf_rrc_ul_RRC_HFN;                     /* BIT_STRING_SIZE_28 */
static int hf_rrc_dl_RRC_HFN;                     /* BIT_STRING_SIZE_28 */
static int hf_rrc_ul_RRC_SequenceNumber;          /* RRC_MessageSequenceNumber */
static int hf_rrc_dl_RRC_SequenceNumber;          /* RRC_MessageSequenceNumber */
static int hf_rrc_SRB_SpecificIntegrityProtInfoList_item;  /* SRB_SpecificIntegrityProtInfo */
static int hf_rrc_validity_CellPCH_UraPCH_01;     /* T_validity_CellPCH_UraPCH_01 */
static int hf_rrc_sfn_sfnType2Capability_01;      /* T_sfn_sfnType2Capability_01 */
static int hf_rrc_pdcp_Capability_03;             /* PDCP_Capability_r4 */
static int hf_rrc_rf_Capability_04;               /* RF_Capability_r4 */
static int hf_rrc_physicalChannelCapability_13;   /* PhysicalChannelCapability_r4 */
static int hf_rrc_ue_positioning_Capability_01;   /* UE_Positioning_Capability_r4 */
static int hf_rrc_measurementCapability_10;       /* MeasurementCapability_r4 */
static int hf_rrc_pdcp_Capability_04;             /* PDCP_Capability_r5 */
static int hf_rrc_rlc_Capability_05;              /* RLC_Capability_r5 */
static int hf_rrc_physicalChannelCapability_14;   /* PhysicalChannelCapability_r5 */
static int hf_rrc_ue_MultiModeRAT_Capability_01;  /* UE_MultiModeRAT_Capability_r5 */
static int hf_rrc_pdcp_Capability_05;             /* PDCP_Capability_r6 */
static int hf_rrc_ul_mode;                        /* T_ul_mode */
static int hf_rrc_ul_ref_ir;                      /* OCTET_STRING_SIZE_1_3000 */
static int hf_rrc_ul_ref_time;                    /* INTEGER_0_4294967295 */
static int hf_rrc_ul_curr_time;                   /* INTEGER_0_4294967295 */
static int hf_rrc_ul_syn_offset_id;               /* INTEGER_0_65535 */
static int hf_rrc_ul_syn_slope_ts;                /* INTEGER_0_4294967295 */
static int hf_rrc_ul_ref_sn_1;                    /* INTEGER_0_65535 */
/* named bits */
static int hf_rrc_T_cipheringAlgorithmCap_spare15;
static int hf_rrc_T_cipheringAlgorithmCap_spare14;
static int hf_rrc_T_cipheringAlgorithmCap_spare13;
static int hf_rrc_T_cipheringAlgorithmCap_spare12;
static int hf_rrc_T_cipheringAlgorithmCap_spare11;
static int hf_rrc_T_cipheringAlgorithmCap_spare10;
static int hf_rrc_T_cipheringAlgorithmCap_spare9;
static int hf_rrc_T_cipheringAlgorithmCap_spare8;
static int hf_rrc_T_cipheringAlgorithmCap_spare7;
static int hf_rrc_T_cipheringAlgorithmCap_spare6;
static int hf_rrc_T_cipheringAlgorithmCap_spare5;
static int hf_rrc_T_cipheringAlgorithmCap_spare4;
static int hf_rrc_T_cipheringAlgorithmCap_spare3;
static int hf_rrc_T_cipheringAlgorithmCap_uea2;
static int hf_rrc_T_cipheringAlgorithmCap_uea1;
static int hf_rrc_T_cipheringAlgorithmCap_uea0;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare15;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare14;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare13;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare12;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare11;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare10;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare9;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare8;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare7;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare6;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare5;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare4;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare3;
static int hf_rrc_T_integrityProtectionAlgorithmCap_uia2;
static int hf_rrc_T_integrityProtectionAlgorithmCap_uia1;
static int hf_rrc_T_integrityProtectionAlgorithmCap_spare0;
static int hf_rrc_T_assignedSubChannelNumber_b3;
static int hf_rrc_T_assignedSubChannelNumber_b2;
static int hf_rrc_T_assignedSubChannelNumber_b1;
static int hf_rrc_T_assignedSubChannelNumber_b0;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex7;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex6;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex5;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex4;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex3;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex2;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex1;
static int hf_rrc_T_channelisationCodeIndices_chCodeIndex0;
static int hf_rrc_T_subchannels_size4_subCh3;
static int hf_rrc_T_subchannels_size4_subCh2;
static int hf_rrc_T_subchannels_size4_subCh1;
static int hf_rrc_T_subchannels_size4_subCh0;
static int hf_rrc_T_subchannels_size8_subCh7;
static int hf_rrc_T_subchannels_size8_subCh6;
static int hf_rrc_T_subchannels_size8_subCh5;
static int hf_rrc_T_subchannels_size8_subCh4;
static int hf_rrc_T_subchannels_size8_subCh3;
static int hf_rrc_T_subchannels_size8_subCh2;
static int hf_rrc_T_subchannels_size8_subCh1;
static int hf_rrc_T_subchannels_size8_subCh0;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex15;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex14;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex13;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex12;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex11;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex10;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex9;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex8;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex7;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex6;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex5;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex4;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex3;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex2;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex1;
static int hf_rrc_T_channelisationCodeIndices_01_chCodeIndex0;
static int hf_rrc_T_subchannels_size4_01_subCh3;
static int hf_rrc_T_subchannels_size4_01_subCh2;
static int hf_rrc_T_subchannels_size4_01_subCh1;
static int hf_rrc_T_subchannels_size4_01_subCh0;
static int hf_rrc_T_subchannels_size8_01_subCh7;
static int hf_rrc_T_subchannels_size8_01_subCh6;
static int hf_rrc_T_subchannels_size8_01_subCh5;
static int hf_rrc_T_subchannels_size8_01_subCh4;
static int hf_rrc_T_subchannels_size8_01_subCh3;
static int hf_rrc_T_subchannels_size8_01_subCh2;
static int hf_rrc_T_subchannels_size8_01_subCh1;
static int hf_rrc_T_subchannels_size8_01_subCh0;
static int hf_rrc_T_subchannels_size16_subCh15;
static int hf_rrc_T_subchannels_size16_subCh14;
static int hf_rrc_T_subchannels_size16_subCh13;
static int hf_rrc_T_subchannels_size16_subCh12;
static int hf_rrc_T_subchannels_size16_subCh11;
static int hf_rrc_T_subchannels_size16_subCh10;
static int hf_rrc_T_subchannels_size16_subCh9;
static int hf_rrc_T_subchannels_size16_subCh8;
static int hf_rrc_T_subchannels_size16_subCh7;
static int hf_rrc_T_subchannels_size16_subCh6;
static int hf_rrc_T_subchannels_size16_subCh5;
static int hf_rrc_T_subchannels_size16_subCh4;
static int hf_rrc_T_subchannels_size16_subCh3;
static int hf_rrc_T_subchannels_size16_subCh2;
static int hf_rrc_T_subchannels_size16_subCh1;
static int hf_rrc_T_subchannels_size16_subCh0;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex7;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex6;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex5;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex4;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex3;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex2;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex1;
static int hf_rrc_T_availableSYNC_UlCodesIndics_sulCodeIndex0;
static int hf_rrc_T_subchannels_size4_02_subCh3;
static int hf_rrc_T_subchannels_size4_02_subCh2;
static int hf_rrc_T_subchannels_size4_02_subCh1;
static int hf_rrc_T_subchannels_size4_02_subCh0;
static int hf_rrc_T_subchannels_size8_02_subCh7;
static int hf_rrc_T_subchannels_size8_02_subCh6;
static int hf_rrc_T_subchannels_size8_02_subCh5;
static int hf_rrc_T_subchannels_size8_02_subCh4;
static int hf_rrc_T_subchannels_size8_02_subCh3;
static int hf_rrc_T_subchannels_size8_02_subCh2;
static int hf_rrc_T_subchannels_size8_02_subCh1;
static int hf_rrc_T_subchannels_size8_02_subCh0;
static int hf_rrc_AvailableSignatures_signature15;
static int hf_rrc_AvailableSignatures_signature14;
static int hf_rrc_AvailableSignatures_signature13;
static int hf_rrc_AvailableSignatures_signature12;
static int hf_rrc_AvailableSignatures_signature11;
static int hf_rrc_AvailableSignatures_signature10;
static int hf_rrc_AvailableSignatures_signature9;
static int hf_rrc_AvailableSignatures_signature8;
static int hf_rrc_AvailableSignatures_signature7;
static int hf_rrc_AvailableSignatures_signature6;
static int hf_rrc_AvailableSignatures_signature5;
static int hf_rrc_AvailableSignatures_signature4;
static int hf_rrc_AvailableSignatures_signature3;
static int hf_rrc_AvailableSignatures_signature2;
static int hf_rrc_AvailableSignatures_signature1;
static int hf_rrc_AvailableSignatures_signature0;
static int hf_rrc_AvailableSubChannelNumbers_subCh11;
static int hf_rrc_AvailableSubChannelNumbers_subCh10;
static int hf_rrc_AvailableSubChannelNumbers_subCh9;
static int hf_rrc_AvailableSubChannelNumbers_subCh8;
static int hf_rrc_AvailableSubChannelNumbers_subCh7;
static int hf_rrc_AvailableSubChannelNumbers_subCh6;
static int hf_rrc_AvailableSubChannelNumbers_subCh5;
static int hf_rrc_AvailableSubChannelNumbers_subCh4;
static int hf_rrc_AvailableSubChannelNumbers_subCh3;
static int hf_rrc_AvailableSubChannelNumbers_subCh2;
static int hf_rrc_AvailableSubChannelNumbers_subCh1;
static int hf_rrc_AvailableSubChannelNumbers_subCh0;
static int hf_rrc_T_bitmap_chCode16_SF16;
static int hf_rrc_T_bitmap_chCode15_SF16;
static int hf_rrc_T_bitmap_chCode14_SF16;
static int hf_rrc_T_bitmap_chCode13_SF16;
static int hf_rrc_T_bitmap_chCode12_SF16;
static int hf_rrc_T_bitmap_chCode11_SF16;
static int hf_rrc_T_bitmap_chCode10_SF16;
static int hf_rrc_T_bitmap_chCode9_SF16;
static int hf_rrc_T_bitmap_chCode8_SF16;
static int hf_rrc_T_bitmap_chCode7_SF16;
static int hf_rrc_T_bitmap_chCode6_SF16;
static int hf_rrc_T_bitmap_chCode5_SF16;
static int hf_rrc_T_bitmap_chCode4_SF16;
static int hf_rrc_T_bitmap_chCode3_SF16;
static int hf_rrc_T_bitmap_chCode2_SF16;
static int hf_rrc_T_bitmap_chCode1_SF16;
static int hf_rrc_T_bitmap_01_chCode32_SF32;
static int hf_rrc_T_bitmap_01_chCode31_SF32;
static int hf_rrc_T_bitmap_01_chCode30_SF32;
static int hf_rrc_T_bitmap_01_chCode29_SF32;
static int hf_rrc_T_bitmap_01_chCode28_SF32;
static int hf_rrc_T_bitmap_01_chCode27_SF32;
static int hf_rrc_T_bitmap_01_chCode26_SF32;
static int hf_rrc_T_bitmap_01_chCode25_SF32;
static int hf_rrc_T_bitmap_01_chCode24_SF32;
static int hf_rrc_T_bitmap_01_chCode23_SF32;
static int hf_rrc_T_bitmap_01_chCode22_SF32;
static int hf_rrc_T_bitmap_01_chCode21_SF32;
static int hf_rrc_T_bitmap_01_chCode20_SF32;
static int hf_rrc_T_bitmap_01_chCode19_SF32;
static int hf_rrc_T_bitmap_01_chCode18_SF32;
static int hf_rrc_T_bitmap_01_chCode17_SF32;
static int hf_rrc_T_bitmap_01_chCode16_SF32;
static int hf_rrc_T_bitmap_01_chCode15_SF32;
static int hf_rrc_T_bitmap_01_chCode14_SF32;
static int hf_rrc_T_bitmap_01_chCode13_SF32;
static int hf_rrc_T_bitmap_01_chCode12_SF32;
static int hf_rrc_T_bitmap_01_chCode11_SF32;
static int hf_rrc_T_bitmap_01_chCode10_SF32;
static int hf_rrc_T_bitmap_01_chCode9_SF32;
static int hf_rrc_T_bitmap_01_chCode8_SF32;
static int hf_rrc_T_bitmap_01_chCode7_SF32;
static int hf_rrc_T_bitmap_01_chCode6_SF32;
static int hf_rrc_T_bitmap_01_chCode5_SF32;
static int hf_rrc_T_bitmap_01_chCode4_SF32;
static int hf_rrc_T_bitmap_01_chCode3_SF32;
static int hf_rrc_T_bitmap_01_chCode2_SF32;
static int hf_rrc_T_bitmap_01_chCode1_SF32;
static int hf_rrc_T_sync_UL_CodesBitmap_code7;
static int hf_rrc_T_sync_UL_CodesBitmap_code6;
static int hf_rrc_T_sync_UL_CodesBitmap_code5;
static int hf_rrc_T_sync_UL_CodesBitmap_code4;
static int hf_rrc_T_sync_UL_CodesBitmap_code3;
static int hf_rrc_T_sync_UL_CodesBitmap_code2;
static int hf_rrc_T_sync_UL_CodesBitmap_code1;
static int hf_rrc_T_sync_UL_CodesBitmap_code0;
static int hf_rrc_Sync_UL_Codes_Bitmap_code7;
static int hf_rrc_Sync_UL_Codes_Bitmap_code6;
static int hf_rrc_Sync_UL_Codes_Bitmap_code5;
static int hf_rrc_Sync_UL_Codes_Bitmap_code4;
static int hf_rrc_Sync_UL_Codes_Bitmap_code3;
static int hf_rrc_Sync_UL_Codes_Bitmap_code2;
static int hf_rrc_Sync_UL_Codes_Bitmap_code1;
static int hf_rrc_Sync_UL_Codes_Bitmap_code0;
static int hf_rrc_GsmSecurityCapability_a5_7;
static int hf_rrc_GsmSecurityCapability_a5_6;
static int hf_rrc_GsmSecurityCapability_a5_5;
static int hf_rrc_GsmSecurityCapability_a5_4;
static int hf_rrc_GsmSecurityCapability_a5_3;
static int hf_rrc_GsmSecurityCapability_a5_2;
static int hf_rrc_GsmSecurityCapability_a5_1;

/* Initialize the subtree pointers */
static int ett_rrc;

static int ett_rrc_DL_DCCH_Message;
static int ett_rrc_DL_DCCH_MessageType;
static int ett_rrc_UL_DCCH_Message;
static int ett_rrc_UL_DCCH_MessageType;
static int ett_rrc_UL_DCCH_MessageType_ext;
static int ett_rrc_DL_CCCH_Message;
static int ett_rrc_DL_CCCH_MessageType;
static int ett_rrc_UL_CCCH_Message;
static int ett_rrc_UL_CCCH_MessageType;
static int ett_rrc_UL_CCCH_MessageType_r11;
static int ett_rrc_PCCH_Message;
static int ett_rrc_PCCH_MessageType;
static int ett_rrc_DL_SHCCH_Message;
static int ett_rrc_DL_SHCCH_MessageType;
static int ett_rrc_UL_SHCCH_Message;
static int ett_rrc_UL_SHCCH_MessageType;
static int ett_rrc_BCCH_FACH_Message;
static int ett_rrc_BCCH_FACH_MessageType;
static int ett_rrc_BCCH_BCH_Message;
static int ett_rrc_BCCH_BCH2_Message;
static int ett_rrc_MCCH_Message;
static int ett_rrc_MCCH_MessageType;
static int ett_rrc_MSCH_Message;
static int ett_rrc_MSCH_MessageType;
static int ett_rrc_ActiveSetUpdate;
static int ett_rrc_T_r3;
static int ett_rrc_T_laterNonCriticalExtensions;
static int ett_rrc_T_v4b0NonCriticalExtensions;
static int ett_rrc_T_v590NonCriticalExtensions;
static int ett_rrc_T_v690NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions;
static int ett_rrc_T_later_than_r3;
static int ett_rrc_T_criticalExtensions;
static int ett_rrc_T_r6;
static int ett_rrc_T_v6b0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_01;
static int ett_rrc_T_criticalExtensions_01;
static int ett_rrc_T_r7;
static int ett_rrc_T_v780NonCriticalExtensions;
static int ett_rrc_T_v7f0NonCriticalExtensions;
static int ett_rrc_T_v7g0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_02;
static int ett_rrc_T_criticalExtensions_02;
static int ett_rrc_T_r8;
static int ett_rrc_T_v890NonCriticalExtensions;
static int ett_rrc_T_v7g0NonCriticalExtensions_01;
static int ett_rrc_T_nonCriticalExtensions_03;
static int ett_rrc_T_criticalExtensions_03;
static int ett_rrc_T_r9;
static int ett_rrc_T_v950NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_04;
static int ett_rrc_T_criticalExtensions_04;
static int ett_rrc_T_r10;
static int ett_rrc_T_vb50NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_05;
static int ett_rrc_T_criticalExtensions_05;
static int ett_rrc_T_r11;
static int ett_rrc_T_nonCriticalExtensions_06;
static int ett_rrc_T_criticalExtensions_06;
static int ett_rrc_T_r12;
static int ett_rrc_T_nonCriticalExtensions_07;
static int ett_rrc_T_criticalExtensions_07;
static int ett_rrc_T_r13;
static int ett_rrc_T_nonCriticalExtensions_08;
static int ett_rrc_T_criticalExtensions_08;
static int ett_rrc_ActiveSetUpdate_r3_IEs;
static int ett_rrc_ActiveSetUpdate_v4b0ext_IEs;
static int ett_rrc_ActiveSetUpdate_v590ext_IEs;
static int ett_rrc_ActiveSetUpdate_v690ext_IEs;
static int ett_rrc_ActiveSetUpdate_r6_IEs;
static int ett_rrc_ActiveSetUpdate_v6b0ext_IEs;
static int ett_rrc_ActiveSetUpdate_r7_IEs;
static int ett_rrc_ActiveSetUpdate_v780ext_IEs;
static int ett_rrc_ActiveSetUpdate_v7f0ext_IEs;
static int ett_rrc_ActiveSetUpdate_v7g0ext_IEs;
static int ett_rrc_ActiveSetUpdate_r8_IEs;
static int ett_rrc_ActiveSetUpdate_v890ext_IEs;
static int ett_rrc_ActiveSetUpdate_r9_IEs;
static int ett_rrc_ActiveSetUpdate_v950ext_IEs;
static int ett_rrc_ActiveSetUpdate_r10_IEs;
static int ett_rrc_ActiveSetUpdate_vb50ext_IEs;
static int ett_rrc_ActiveSetUpdate_r11_IEs;
static int ett_rrc_ActiveSetUpdate_r12_IEs;
static int ett_rrc_ActiveSetUpdate_r13_IEs;
static int ett_rrc_ActiveSetUpdateComplete;
static int ett_rrc_T_laterNonCriticalExtensions_01;
static int ett_rrc_T_nonCriticalExtensions_09;
static int ett_rrc_ActiveSetUpdateFailure;
static int ett_rrc_T_laterNonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_10;
static int ett_rrc_AssistanceDataDelivery;
static int ett_rrc_T_r3_01;
static int ett_rrc_T_v3a0NonCriticalExtensions;
static int ett_rrc_T_laterNonCriticalExtensions_03;
static int ett_rrc_T_v4b0NonCriticalExtensions_01;
static int ett_rrc_T_v770NonCriticalExtension;
static int ett_rrc_T_v860NonCriticalExtension;
static int ett_rrc_T_v920NonCriticalExtension;
static int ett_rrc_T_va40NonCriticalExtension;
static int ett_rrc_T_vc50NonCriticalExtension;
static int ett_rrc_T_nonCriticalExtensions_11;
static int ett_rrc_T_later_than_r3_01;
static int ett_rrc_T_criticalExtensions_09;
static int ett_rrc_AssistanceDataDelivery_r3_IEs;
static int ett_rrc_AssistanceDataDelivery_v3a0ext;
static int ett_rrc_AssistanceDataDelivery_v4b0ext_IEs;
static int ett_rrc_AssistanceDataDelivery_v770ext_IEs;
static int ett_rrc_AssistanceDataDelivery_v860ext_IEs;
static int ett_rrc_AssistanceDataDelivery_v920ext_IEs;
static int ett_rrc_AssistanceDataDelivery_va40ext_IEs;
static int ett_rrc_AssistanceDataDelivery_vc50ext_IEs;
static int ett_rrc_CellChangeOrderFromUTRAN;
static int ett_rrc_T_r3_02;
static int ett_rrc_T_laterNonCriticalExtensions_04;
static int ett_rrc_T_v590NonCriticalExtensions_01;
static int ett_rrc_T_nonCriticalExtensions_12;
static int ett_rrc_T_later_than_r3_02;
static int ett_rrc_T_criticalExtensions_10;
static int ett_rrc_CellChangeOrderFromUTRAN_r3_IEs;
static int ett_rrc_CellChangeOrderFromUTRAN_v590ext_IEs;
static int ett_rrc_T_geran_SystemInfoType;
static int ett_rrc_CellChangeOrderFromUTRANFailure;
static int ett_rrc_T_r3_03;
static int ett_rrc_T_laterNonCriticalExtensions_05;
static int ett_rrc_T_nonCriticalExtensions_13;
static int ett_rrc_T_dummy;
static int ett_rrc_T_criticalExtensions_11;
static int ett_rrc_CellChangeOrderFromUTRANFailure_r3_IEs;
static int ett_rrc_CellUpdate;
static int ett_rrc_T_laterNonCriticalExtensions_06;
static int ett_rrc_T_v590NonCriticalExtensions_02;
static int ett_rrc_T_v690NonCriticalExtensions_01;
static int ett_rrc_T_v6b0NonCriticalExtensions_01;
static int ett_rrc_T_v770NonCriticalExtensions;
static int ett_rrc_T_v860NonCriticalExtensions;
static int ett_rrc_T_va40NonCriticalExtensions;
static int ett_rrc_T_vb50NonCriticalExtensions_01;
static int ett_rrc_T_vc50NonCriticalExtensions;
static int ett_rrc_CellUpdate_ve30ext_IEs;
static int ett_rrc_T_nonCriticalExtensions_14;
static int ett_rrc_CellUpdate_r3_add_ext_IEs;
static int ett_rrc_T_v7g0NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_15;
static int ett_rrc_CellUpdate_v590ext;
static int ett_rrc_CellUpdate_v690ext_IEs;
static int ett_rrc_CellUpdate_v6b0ext_IEs;
static int ett_rrc_CellUpdate_v770ext_IEs;
static int ett_rrc_CellUpdate_v7e0ext_IEs;
static int ett_rrc_CellUpdate_v7g0ext_IEs;
static int ett_rrc_CellUpdate_v860ext_IEs;
static int ett_rrc_CellUpdate_va40ext_IEs;
static int ett_rrc_CellUpdateFDD_r11;
static int ett_rrc_CellUpdate_vb50ext_IEs;
static int ett_rrc_CellUpdate_vc50ext_IEs;
static int ett_rrc_CellUpdateConfirm;
static int ett_rrc_T_r3_04;
static int ett_rrc_T_v3a0NonCriticalExtensions_01;
static int ett_rrc_T_laterNonCriticalExtensions_07;
static int ett_rrc_T_v4b0NonCriticalExtensions_02;
static int ett_rrc_T_v590NonCriticalExtenstions;
static int ett_rrc_T_v5d0NonCriticalExtenstions;
static int ett_rrc_T_v690NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_16;
static int ett_rrc_T_later_than_r3_03;
static int ett_rrc_T_criticalExtensions_12;
static int ett_rrc_T_r4;
static int ett_rrc_T_v4d0NonCriticalExtensions;
static int ett_rrc_T_v590NonCriticalExtenstions_01;
static int ett_rrc_T_v5d0NonCriticalExtenstions_01;
static int ett_rrc_T_v690NonCriticalExtensions_03;
static int ett_rrc_T_nonCriticalExtensions_17;
static int ett_rrc_T_criticalExtensions_13;
static int ett_rrc_T_r5;
static int ett_rrc_T_v5d0NonCriticalExtenstions_02;
static int ett_rrc_T_v690NonCriticalExtensions_04;
static int ett_rrc_T_nonCriticalExtensions_18;
static int ett_rrc_T_criticalExtensions_14;
static int ett_rrc_T_r6_01;
static int ett_rrc_T_v6b0NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_19;
static int ett_rrc_T_criticalExtensions_15;
static int ett_rrc_T_r7_01;
static int ett_rrc_T_v780NonCriticalExtensions_01;
static int ett_rrc_T_v860NonCriticalExtensions_01;
static int ett_rrc_T_nonCriticalExtensions_20;
static int ett_rrc_T_criticalExtensions_16;
static int ett_rrc_T_r8_01;
static int ett_rrc_T_v7d0NonCriticalExtensions;
static int ett_rrc_T_v7f0NonCriticalExtensions_01;
static int ett_rrc_T_v890NonCriticalExtensions_01;
static int ett_rrc_T_v7g0NonCriticalExtensions_03;
static int ett_rrc_T_v8a0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_21;
static int ett_rrc_T_criticalExtensions_17;
static int ett_rrc_T_r9_01;
static int ett_rrc_T_v950NonCriticalExtensions_01;
static int ett_rrc_T_v9c0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_22;
static int ett_rrc_T_criticalExtensions_18;
static int ett_rrc_T_r10_01;
static int ett_rrc_T_v9c0NonCriticalExtensions_01;
static int ett_rrc_T_vb50NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_23;
static int ett_rrc_T_criticalExtensions_19;
static int ett_rrc_T_r11_01;
static int ett_rrc_T_nonCriticalExtensions_24;
static int ett_rrc_T_criticalExtensions_20;
static int ett_rrc_T_r12_01;
static int ett_rrc_T_nonCriticalExtensions_25;
static int ett_rrc_T_criticalExtensions_21;
static int ett_rrc_T_r13_01;
static int ett_rrc_T_nonCriticalExtensions_26;
static int ett_rrc_CellUpdateConfirm_CriticalExtension_r14_IEs;
static int ett_rrc_T_r14;
static int ett_rrc_T_nonCriticalExtensions_27;
static int ett_rrc_T_criticalExtensions_22;
static int ett_rrc_CellUpdateConfirm_r14_IEs;
static int ett_rrc_CellUpdateConfirm_r3_IEs;
static int ett_rrc_T_modeSpecificTransChInfo;
static int ett_rrc_T_fdd;
static int ett_rrc_T_modeSpecificPhysChInfo;
static int ett_rrc_T_fdd_01;
static int ett_rrc_CellUpdateConfirm_v3a0ext;
static int ett_rrc_CellUpdateConfirm_v4b0ext_IEs;
static int ett_rrc_CellUpdateConfirm_v590ext_IEs;
static int ett_rrc_CellUpdateConfirm_v5d0ext_IEs;
static int ett_rrc_CellUpdateConfirm_r4_IEs;
static int ett_rrc_T_modeSpecificTransChInfo_01;
static int ett_rrc_T_fdd_02;
static int ett_rrc_T_modeSpecificPhysChInfo_01;
static int ett_rrc_T_fdd_03;
static int ett_rrc_CellUpdateConfirm_r5_IEs;
static int ett_rrc_T_modeSpecificTransChInfo_02;
static int ett_rrc_T_fdd_04;
static int ett_rrc_T_modeSpecificPhysChInfo_02;
static int ett_rrc_T_fdd_05;
static int ett_rrc_CellUpdateConfirm_r6_IEs;
static int ett_rrc_CellUpdateConfirm_v690ext_IEs;
static int ett_rrc_CellUpdateConfirm_v6b0ext_IEs;
static int ett_rrc_CellUpdateConfirm_r7_IEs;
static int ett_rrc_CellUpdateConfirm_r7_add_ext_IEs;
static int ett_rrc_T_v7f0NonCriticalExtensions_02;
static int ett_rrc_T_v7g0NonCriticalExtensions_04;
static int ett_rrc_T_nonCriticalExtensions_28;
static int ett_rrc_CellUpdateConfirm_v780ext_IEs;
static int ett_rrc_CellUpdateConfirm_v7d0ext_IEs;
static int ett_rrc_CellUpdateConfirm_v7f0ext_IEs;
static int ett_rrc_CellUpdateConfirm_v7g0ext_IEs;
static int ett_rrc_CellUpdateConfirm_r8_IEs;
static int ett_rrc_CellUpdateConfirm_v860ext_IEs;
static int ett_rrc_T_rab_InformationSetup;
static int ett_rrc_CellUpdateConfirm_v890ext_IEs;
static int ett_rrc_CellUpdateConfirm_v8a0ext_IEs;
static int ett_rrc_CellUpdateConfirm_r9_IEs;
static int ett_rrc_CellUpdateConfirm_v950ext_IEs;
static int ett_rrc_CellUpdateConfirm_v9c0ext_IEs;
static int ett_rrc_CellUpdateConfirm_r10_IEs;
static int ett_rrc_CellUpdateConfirm_vb50ext_IEs;
static int ett_rrc_CellUpdateConfirm_r11_IEs;
static int ett_rrc_CellUpdateConfirm_r12_IEs;
static int ett_rrc_CellUpdateConfirm_r13_IEs;
static int ett_rrc_CellUpdateConfirm_CCCH;
static int ett_rrc_T_r3_05;
static int ett_rrc_T_laterNonCriticalExtensions_08;
static int ett_rrc_T_v4b0NonCriticalExtensions_03;
static int ett_rrc_T_v590NonCriticalExtensions_03;
static int ett_rrc_T_v5d0NonCriticalExtenstions_03;
static int ett_rrc_T_v690NonCriticalExtensions_05;
static int ett_rrc_T_nonCriticalExtensions_29;
static int ett_rrc_T_later_than_r3_04;
static int ett_rrc_T_criticalExtensions_23;
static int ett_rrc_T_r4_01;
static int ett_rrc_T_v4d0NonCriticalExtensions_01;
static int ett_rrc_T_v590NonCriticalExtensions_04;
static int ett_rrc_T_v5d0NonCriticalExtenstions_04;
static int ett_rrc_T_v690NonCriticalExtensions_06;
static int ett_rrc_T_nonCriticalExtensions_30;
static int ett_rrc_T_criticalExtensions_24;
static int ett_rrc_T_r5_01;
static int ett_rrc_T_v5d0NonCriticalExtenstions_05;
static int ett_rrc_T_v690NonCriticalExtensions_07;
static int ett_rrc_T_nonCriticalExtensions_31;
static int ett_rrc_T_criticalExtensions_25;
static int ett_rrc_T_r6_02;
static int ett_rrc_T_v6b0NonCriticalExtensions_03;
static int ett_rrc_T_nonCriticalExtensions_32;
static int ett_rrc_T_criticalExtensions_26;
static int ett_rrc_T_r7_02;
static int ett_rrc_T_v780NonCriticalExtensions_02;
static int ett_rrc_T_v860NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_33;
static int ett_rrc_T_criticalExtensions_27;
static int ett_rrc_T_r8_02;
static int ett_rrc_T_v7d0NonCriticalExtensions_01;
static int ett_rrc_T_v890NonCriticalExtensions_02;
static int ett_rrc_T_v8a0NonCriticalExtensions_01;
static int ett_rrc_T_v7f0NonCriticalExtensions_03;
static int ett_rrc_T_v7g0NonCriticalExtensions_05;
static int ett_rrc_T_nonCriticalExtensions_34;
static int ett_rrc_T_criticalExtensions_28;
static int ett_rrc_T_r9_02;
static int ett_rrc_T_nonCriticalExtensions_35;
static int ett_rrc_T_criticalExtensions_29;
static int ett_rrc_T_r10_02;
static int ett_rrc_T_vb50NonCriticalExtensions_03;
static int ett_rrc_T_nonCriticalExtensions_36;
static int ett_rrc_T_criticalExtensions_30;
static int ett_rrc_T_r11_02;
static int ett_rrc_T_nonCriticalExtensions_37;
static int ett_rrc_T_criticalExtensions_31;
static int ett_rrc_T_r12_02;
static int ett_rrc_T_nonCriticalExtensions_38;
static int ett_rrc_T_criticalExtensions_32;
static int ett_rrc_T_r13_02;
static int ett_rrc_T_nonCriticalExtensions_39;
static int ett_rrc_T_criticalExtensions_33;
static int ett_rrc_CounterCheck;
static int ett_rrc_T_r3_06;
static int ett_rrc_T_laterNonCriticalExtensions_09;
static int ett_rrc_T_nonCriticalExtensions_40;
static int ett_rrc_T_later_than_r3_05;
static int ett_rrc_T_criticalExtensions_34;
static int ett_rrc_CounterCheck_r3_IEs;
static int ett_rrc_CounterCheckResponse;
static int ett_rrc_T_laterNonCriticalExtensions_10;
static int ett_rrc_T_nonCriticalExtensions_41;
static int ett_rrc_DownlinkDirectTransfer;
static int ett_rrc_T_r3_07;
static int ett_rrc_T_laterNonCriticalExtensions_11;
static int ett_rrc_T_nonCriticalExtensions_42;
static int ett_rrc_T_later_than_r3_06;
static int ett_rrc_T_criticalExtensions_35;
static int ett_rrc_DownlinkDirectTransfer_r3_IEs;
static int ett_rrc_ETWSPrimaryNotificationWithSecurity;
static int ett_rrc_T_nonCriticalExtensions_43;
static int ett_rrc_HandoverToUTRANCommand;
static int ett_rrc_T_r3_08;
static int ett_rrc_T_nonCriticalExtensions_44;
static int ett_rrc_T_criticalExtensions_36;
static int ett_rrc_T_r4_02;
static int ett_rrc_T_nonCriticalExtensions_45;
static int ett_rrc_T_criticalExtensions_37;
static int ett_rrc_T_r5_02;
static int ett_rrc_T_nonCriticalExtensions_46;
static int ett_rrc_T_criticalExtensions_38;
static int ett_rrc_T_r6_03;
static int ett_rrc_T_v6b0NonCriticalExtensions_04;
static int ett_rrc_T_nonCriticalExtensions_47;
static int ett_rrc_T_criticalExtensions_39;
static int ett_rrc_T_r7_03;
static int ett_rrc_T_v780NonCriticalExtensions_03;
static int ett_rrc_T_v820NonCriticalExtensions;
static int ett_rrc_T_v7d0NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_48;
static int ett_rrc_T_criticalExtensions_40;
static int ett_rrc_T_r8_03;
static int ett_rrc_T_v7d0NonCriticalExtensions_03;
static int ett_rrc_T_v890NonCriticalExtensions_03;
static int ett_rrc_T_v8a0NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_49;
static int ett_rrc_T_criticalExtensions_41;
static int ett_rrc_T_r9_03;
static int ett_rrc_T_v9c0NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_50;
static int ett_rrc_HandoverToUTRANCommand_r3_IEs;
static int ett_rrc_T_specificationMode;
static int ett_rrc_T_complete;
static int ett_rrc_T_modeSpecificInfo;
static int ett_rrc_T_fdd_06;
static int ett_rrc_T_preconfiguration;
static int ett_rrc_T_preConfigMode;
static int ett_rrc_T_defaultConfig;
static int ett_rrc_T_modeSpecificInfo_01;
static int ett_rrc_T_fdd_07;
static int ett_rrc_T_tdd;
static int ett_rrc_HandoverToUTRANCommand_r4_IEs;
static int ett_rrc_T_specificationMode_01;
static int ett_rrc_T_complete_01;
static int ett_rrc_T_modeSpecificInfo_02;
static int ett_rrc_T_fdd_08;
static int ett_rrc_T_preconfiguration_01;
static int ett_rrc_T_preConfigMode_01;
static int ett_rrc_T_defaultConfig_01;
static int ett_rrc_T_modeSpecificInfo_03;
static int ett_rrc_T_fdd_09;
static int ett_rrc_T_tdd_01;
static int ett_rrc_T_tdd384;
static int ett_rrc_T_tdd128;
static int ett_rrc_HandoverToUTRANCommand_r5_IEs;
static int ett_rrc_T_specificationMode_02;
static int ett_rrc_T_complete_02;
static int ett_rrc_T_modeSpecificInfo_04;
static int ett_rrc_T_fdd_10;
static int ett_rrc_T_preconfiguration_02;
static int ett_rrc_T_preConfigMode_02;
static int ett_rrc_T_defaultConfig_02;
static int ett_rrc_T_modeSpecificInfo_05;
static int ett_rrc_T_fdd_11;
static int ett_rrc_T_tdd_02;
static int ett_rrc_T_tdd384_01;
static int ett_rrc_T_tdd128_01;
static int ett_rrc_HandoverToUTRANCommand_r6_IEs;
static int ett_rrc_T_specificationMode_03;
static int ett_rrc_T_complete_03;
static int ett_rrc_T_preconfiguration_03;
static int ett_rrc_T_preConfigMode_03;
static int ett_rrc_T_defaultConfig_03;
static int ett_rrc_T_modeSpecificInfo_06;
static int ett_rrc_T_fdd_12;
static int ett_rrc_T_tdd_03;
static int ett_rrc_T_tdd384_02;
static int ett_rrc_T_tdd128_02;
static int ett_rrc_HandoverToUTRANCommand_v6b0ext_IEs;
static int ett_rrc_HandoverToUTRANCommand_r7_IEs;
static int ett_rrc_T_specificationMode_04;
static int ett_rrc_T_complete_04;
static int ett_rrc_T_preconfiguration_04;
static int ett_rrc_T_preConfigMode_04;
static int ett_rrc_T_defaultConfig_04;
static int ett_rrc_T_modeSpecificInfo_07;
static int ett_rrc_T_fdd_13;
static int ett_rrc_T_tdd_04;
static int ett_rrc_T_tdd384_03;
static int ett_rrc_T_tdd128_03;
static int ett_rrc_T_tdd768;
static int ett_rrc_HandoverToUTRANCommand_v780ext_IEs;
static int ett_rrc_HandoverToUTRANCommand_v7d0ext_IEs;
static int ett_rrc_HandoverToUTRANCommand_r8_IEs;
static int ett_rrc_T_specificationMode_05;
static int ett_rrc_T_complete_05;
static int ett_rrc_T_preconfiguration_05;
static int ett_rrc_T_preConfigMode_05;
static int ett_rrc_T_defaultConfig_05;
static int ett_rrc_T_modeSpecificInfo_08;
static int ett_rrc_T_fdd_14;
static int ett_rrc_T_tdd_05;
static int ett_rrc_T_tdd384_04;
static int ett_rrc_T_tdd128_04;
static int ett_rrc_T_tdd768_01;
static int ett_rrc_HandoverToUTRANCommand_v820ext_IEs;
static int ett_rrc_HandoverToUTRANCommand_v890ext_IEs;
static int ett_rrc_HandoverToUTRANCommand_v8a0ext_IEs;
static int ett_rrc_HandoverToUTRANCommand_r9_IEs;
static int ett_rrc_T_specificationMode_06;
static int ett_rrc_T_complete_06;
static int ett_rrc_T_preconfiguration_06;
static int ett_rrc_T_preConfigMode_06;
static int ett_rrc_T_defaultConfig_06;
static int ett_rrc_T_modeSpecificInfo_09;
static int ett_rrc_T_fdd_15;
static int ett_rrc_T_tdd_06;
static int ett_rrc_T_tdd384_05;
static int ett_rrc_T_tdd128_05;
static int ett_rrc_T_tdd768_02;
static int ett_rrc_HandoverToUTRANCommand_v9c0ext_IEs;
static int ett_rrc_HandoverToUTRANCommand_LaterCriticalExtensions;
static int ett_rrc_T_r10_03;
static int ett_rrc_T_v9c0NonCriticalExtensions_03;
static int ett_rrc_T_nonCriticalExtensions_51;
static int ett_rrc_T_criticalExtensions_42;
static int ett_rrc_T_r11_03;
static int ett_rrc_T_vbc0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_52;
static int ett_rrc_T_criticalExtensions_43;
static int ett_rrc_T_r12_03;
static int ett_rrc_T_nonCriticalExtensions_53;
static int ett_rrc_T_criticalExtensions_44;
static int ett_rrc_HandoverToUTRANCommand_r10_IEs;
static int ett_rrc_T_specificationMode_07;
static int ett_rrc_T_complete_07;
static int ett_rrc_T_preconfiguration_07;
static int ett_rrc_T_preConfigMode_07;
static int ett_rrc_T_defaultConfig_07;
static int ett_rrc_T_modeSpecificInfo_10;
static int ett_rrc_T_fdd_16;
static int ett_rrc_T_tdd_07;
static int ett_rrc_T_tdd384_06;
static int ett_rrc_T_tdd128_06;
static int ett_rrc_T_tdd768_03;
static int ett_rrc_HandoverToUTRANCommand_r11_IEs;
static int ett_rrc_T_specificationMode_08;
static int ett_rrc_T_complete_08;
static int ett_rrc_T_preconfiguration_08;
static int ett_rrc_T_preConfigMode_08;
static int ett_rrc_T_defaultConfig_08;
static int ett_rrc_T_modeSpecificInfo_11;
static int ett_rrc_T_fdd_17;
static int ett_rrc_T_tdd_08;
static int ett_rrc_T_tdd384_07;
static int ett_rrc_T_tdd128_07;
static int ett_rrc_T_tdd768_04;
static int ett_rrc_HandoverToUTRANCommand_vbc0ext_IEs;
static int ett_rrc_T_specificationMode_09;
static int ett_rrc_T_complete_09;
static int ett_rrc_HandoverToUTRANCommand_r12_IEs;
static int ett_rrc_T_specificationMode_10;
static int ett_rrc_T_complete_10;
static int ett_rrc_T_preconfiguration_09;
static int ett_rrc_T_preConfigMode_09;
static int ett_rrc_T_defaultConfig_09;
static int ett_rrc_T_modeSpecificInfo_12;
static int ett_rrc_T_fdd_18;
static int ett_rrc_T_tdd_09;
static int ett_rrc_T_tdd384_08;
static int ett_rrc_T_tdd128_08;
static int ett_rrc_T_tdd768_05;
static int ett_rrc_HandoverToUTRANComplete;
static int ett_rrc_T_laterNonCriticalExtensions_12;
static int ett_rrc_T_va40NonCriticalExtensions_01;
static int ett_rrc_T_vb50NonCriticalExtensions_04;
static int ett_rrc_T_nonCriticalExtensions_54;
static int ett_rrc_HandoverToUTRANComplete_va40ext;
static int ett_rrc_HandoverToUTRANComplete_vb50ext_IEs;
static int ett_rrc_InitialDirectTransfer;
static int ett_rrc_T_v3a0NonCriticalExtensions_02;
static int ett_rrc_T_laterNonCriticalExtensions_13;
static int ett_rrc_T_v590NonCriticalExtensions_05;
static int ett_rrc_T_v690NonCriticalExtensions_08;
static int ett_rrc_T_v770NonCriticalExtensions_01;
static int ett_rrc_T_v860NonCriticalExtensions_03;
static int ett_rrc_T_vb50NonCriticalExtensions_05;
static int ett_rrc_T_vc50NonCriticalExtensions_01;
static int ett_rrc_InitialDirectTransfer_v3a0ext;
static int ett_rrc_InitialDirectTransfer_v590ext;
static int ett_rrc_InitialDirectTransfer_v690ext_IEs;
static int ett_rrc_InitialDirectTransfer_v770ext_IEs;
static int ett_rrc_InitialDirectTransfer_v860ext_IEs;
static int ett_rrc_InitialDirectTransfer_r3_add_ext_IEs;
static int ett_rrc_T_nonCriticalExtensions_55;
static int ett_rrc_InitialDirectTransfer_v7g0ext_IEs;
static int ett_rrc_InitialDirectTransfer_vb50ext_IEs;
static int ett_rrc_InitialDirectTransfer_vc50ext_IEs;
static int ett_rrc_InitialDirectTransfer_ve30ext_IEs;
static int ett_rrc_T_nonCriticalExtensions_56;
static int ett_rrc_HandoverFromUTRANCommand_GSM;
static int ett_rrc_T_r3_09;
static int ett_rrc_T_laterNonCriticalExtensions_14;
static int ett_rrc_T_v690NonCriticalExtensions_09;
static int ett_rrc_T_v860NonCriticalExtensions_04;
static int ett_rrc_T_nonCriticalExtensions_57;
static int ett_rrc_T_later_than_r3_07;
static int ett_rrc_T_criticalExtensions_45;
static int ett_rrc_T_r6_04;
static int ett_rrc_T_v860NonCriticalExtensions_05;
static int ett_rrc_T_nonCriticalExtensions_58;
static int ett_rrc_T_criticalExtensions_46;
static int ett_rrc_HandoverFromUTRANCommand_GSM_r3_IEs;
static int ett_rrc_T_gsm_message;
static int ett_rrc_T_single_GSM_Message_r3;
static int ett_rrc_T_gsm_MessageList_r3;
static int ett_rrc_HandoverFromUTRANCommand_GSM_r6_IEs;
static int ett_rrc_T_gsm_message_01;
static int ett_rrc_T_single_GSM_Message_r6;
static int ett_rrc_T_gsm_MessageList_r6;
static int ett_rrc_T_geran_SystemInfoType_01;
static int ett_rrc_HandoverFromUTRANCommand_GSM_v690ext_IEs;
static int ett_rrc_T_geran_SystemInfoType_02;
static int ett_rrc_HandoverFromUTRANCommand_GSM_v860ext_IEs;
static int ett_rrc_HandoverFromUTRANCommand_GERANIu;
static int ett_rrc_T_handoverFromUTRANCommand_GERANIu;
static int ett_rrc_T_r5_03;
static int ett_rrc_T_nonCriticalExtensions_59;
static int ett_rrc_T_later_than_r5;
static int ett_rrc_T_criticalExtensions_47;
static int ett_rrc_HandoverFromUTRANCommand_GERANIu_r5_IEs;
static int ett_rrc_T_geranIu_Message;
static int ett_rrc_T_single_GERANIu_Message;
static int ett_rrc_T_geranIu_MessageList;
static int ett_rrc_HandoverFromUTRANCommand_CDMA2000;
static int ett_rrc_T_r3_10;
static int ett_rrc_T_laterNonCriticalExtensions_15;
static int ett_rrc_T_nonCriticalExtensions_60;
static int ett_rrc_T_later_than_r3_08;
static int ett_rrc_T_criticalExtensions_48;
static int ett_rrc_HandoverFromUTRANCommand_CDMA2000_r3_IEs;
static int ett_rrc_HandoverFromUTRANCommand_EUTRA;
static int ett_rrc_T_criticalExtensions_49;
static int ett_rrc_T_r8_04;
static int ett_rrc_T_nonCriticalExtensions_61;
static int ett_rrc_T_criticalExtensions_50;
static int ett_rrc_T_r11_04;
static int ett_rrc_T_nonCriticalExtensions_62;
static int ett_rrc_T_criticalExtensions_51;
static int ett_rrc_HandoverFromUTRANCommand_EUTRA_r8_IEs;
static int ett_rrc_HandoverFromUTRANCommand_EUTRA_r11_IEs;
static int ett_rrc_HandoverFromUTRANFailure;
static int ett_rrc_T_interRATMessage;
static int ett_rrc_T_gsm;
static int ett_rrc_T_cdma2000;
static int ett_rrc_T_laterNonCriticalExtensions_16;
static int ett_rrc_T_v590NonCriticalExtensions_06;
static int ett_rrc_T_v860NonCriticalExtensions_06;
static int ett_rrc_T_nonCriticalExtensions_63;
static int ett_rrc_HandoverFromUtranFailure_v590ext_IEs;
static int ett_rrc_HandoverFromUtranFailure_v860ext_IEs;
static int ett_rrc_InterRATHandoverInfo;
static int ett_rrc_T_predefinedConfigStatusList;
static int ett_rrc_T_uE_SecurityInformation;
static int ett_rrc_T_ue_CapabilityContainer;
static int ett_rrc_T_v390NonCriticalExtensions;
static int ett_rrc_T_present_01;
static int ett_rrc_T_v3a0NonCriticalExtensions_03;
static int ett_rrc_T_laterNonCriticalExtensions_17;
static int ett_rrc_T_v3g0NonCriticalExtensions;
static int ett_rrc_T_v4b0NonCriticalExtensions_04;
static int ett_rrc_T_v4d0NonCriticalExtensions_02;
static int ett_rrc_T_v590NonCriticalExtensions_07;
static int ett_rrc_T_v690NonCriticalExtensions_10;
static int ett_rrc_InterRATHandoverInfo_v390ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v3a0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v3d0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v3g0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_r3_add_ext_IEs;
static int ett_rrc_T_v7e0NonCriticalExtensions;
static int ett_rrc_T_v7f0NonCriticalExtensions_04;
static int ett_rrc_T_va40NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_64;
static int ett_rrc_InterRATHandoverInfo_v4b0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v4d0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v590ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v690ext1_IEs;
static int ett_rrc_InterRATHandoverInfo_v690ext_IEs;
static int ett_rrc_InterRATHandoverInfo_NonCriticalExtension_v6b0_IEs;
static int ett_rrc_T_v6e0NonCriticalExtensions;
static int ett_rrc_T_v770NonCriticalExtensions_02;
static int ett_rrc_T_v790nonCriticalExtensions;
static int ett_rrc_T_v860NonCriticalExtensions_07;
static int ett_rrc_T_v880NonCriticalExtensions;
static int ett_rrc_T_v920NonCriticalExtensions;
static int ett_rrc_T_v8b0NonCriticalExtensions;
static int ett_rrc_T_v950NonCriticalExtensions_02;
static int ett_rrc_T_va40NonCriticalExtensions_03;
static int ett_rrc_T_va80NonCriticalExtensions;
static int ett_rrc_T_vb50NonCriticalExtensions_06;
static int ett_rrc_T_vb70NonCriticalExtensions;
static int ett_rrc_InterRATHandoverInfo_v6b0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v6e0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v770ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v790ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v7e0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v7f0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v860ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v880ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v920ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v8b0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_v950ext_IEs;
static int ett_rrc_InterRATHandoverInfo_va40ext_IEs;
static int ett_rrc_InterRATHandoverInfoBand_va40ext_IEs;
static int ett_rrc_InterRATHandoverInfo_va80ext_IEs;
static int ett_rrc_InterRATHandoverInfo_vb50ext_IEs;
static int ett_rrc_InterRATHandoverInfo_vb70ext_IEs;
static int ett_rrc_InterRATHandoverInfo_vbc0ext_IEs;
static int ett_rrc_InterRATHandoverInfo_LaterNonCriticalExtensions;
static int ett_rrc_T_vc50NonCriticalExtensions_02;
static int ett_rrc_T_vd20NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_65;
static int ett_rrc_InterRATHandoverInfo_vc50ext_IEs;
static int ett_rrc_InterRATHandoverInfo_vd20ext_IEs;
static int ett_rrc_MeasurementControl;
static int ett_rrc_T_r3_11;
static int ett_rrc_T_v390nonCriticalExtensions;
static int ett_rrc_T_v3a0NonCriticalExtensions_04;
static int ett_rrc_T_laterNonCriticalExtensions_18;
static int ett_rrc_T_v4b0NonCriticalExtensions_05;
static int ett_rrc_T_v590NonCriticalExtensions_08;
static int ett_rrc_T_v5b0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_66;
static int ett_rrc_T_later_than_r3_09;
static int ett_rrc_T_criticalExtensions_52;
static int ett_rrc_T_r4_03;
static int ett_rrc_T_v4d0NonCriticalExtensions_03;
static int ett_rrc_T_v590NonCriticalExtensions_09;
static int ett_rrc_T_v5b0NonCriticalExtensions_01;
static int ett_rrc_T_nonCriticalExtensions_67;
static int ett_rrc_T_later_than_r4;
static int ett_rrc_T_criticalExtensions_53;
static int ett_rrc_T_r6_05;
static int ett_rrc_T_v6a0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_68;
static int ett_rrc_T_criticalExtensions_54;
static int ett_rrc_T_r7_04;
static int ett_rrc_T_v7b0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_69;
static int ett_rrc_T_criticalExtensions_55;
static int ett_rrc_T_r8_05;
static int ett_rrc_T_v8a0NonCriticalExtensions_03;
static int ett_rrc_T_vb50NonCriticalExtensions_07;
static int ett_rrc_T_nonCriticalExtensions_70;
static int ett_rrc_T_criticalExtensions_56;
static int ett_rrc_T_r9_04;
static int ett_rrc_T_v970NonCriticalExtensions;
static int ett_rrc_T_vb50NonCriticalExtensions_08;
static int ett_rrc_T_nonCriticalExtensions_71;
static int ett_rrc_T_criticalExtensions_57;
static int ett_rrc_T_r10_04;
static int ett_rrc_T_vaa0NonCriticalExtensions;
static int ett_rrc_T_vab0NonCriticalExtensions;
static int ett_rrc_T_vb50NonCriticalExtensions_09;
static int ett_rrc_T_nonCriticalExtensions_72;
static int ett_rrc_T_criticalExtensions_58;
static int ett_rrc_T_r11_05;
static int ett_rrc_T_nonCriticalExtensions_73;
static int ett_rrc_T_criticalExtensions_59;
static int ett_rrc_T_r12_04;
static int ett_rrc_T_nonCriticalExtensions_74;
static int ett_rrc_T_criticalExtensions_60;
static int ett_rrc_T_r13_03;
static int ett_rrc_T_nonCriticalExtensions_75;
static int ett_rrc_T_criticalExtensions_61;
static int ett_rrc_T_r14_01;
static int ett_rrc_T_nonCriticalExtensions_76;
static int ett_rrc_MeasurementControl_r3_IEs;
static int ett_rrc_MeasurementControl_v390ext;
static int ett_rrc_MeasurementControl_v3a0ext;
static int ett_rrc_MeasurementControl_r4_IEs;
static int ett_rrc_MeasurementControl_v590ext_IEs;
static int ett_rrc_T_measurementCommand_v590ext;
static int ett_rrc_MeasurementControl_v5b0ext_IEs;
static int ett_rrc_MeasurementControl_r6_IEs;
static int ett_rrc_MeasurementControl_v6a0ext_IEs;
static int ett_rrc_MeasurementControl_r7_IEs;
static int ett_rrc_MeasurementControl_v7b0ext_IEs;
static int ett_rrc_MeasurementControl_r8_IEs;
static int ett_rrc_MeasurementControl_v8a0ext_IEs;
static int ett_rrc_MeasurementControl_r9_IEs;
static int ett_rrc_MeasurementControl_v970ext_IEs;
static int ett_rrc_MeasurementControl_r10_IEs;
static int ett_rrc_MeasurementControl_vaa0ext_IEs;
static int ett_rrc_MeasurementControl_r11_IEs;
static int ett_rrc_MeasurementControl_vb50ext_IEs;
static int ett_rrc_MeasurementControl_r12_IEs;
static int ett_rrc_MeasurementControl_r13_IEs;
static int ett_rrc_MeasurementControl_r14_IEs;
static int ett_rrc_MeasurementControl_LaterCriticalExtensions_r14_IEs;
static int ett_rrc_T_criticalExtensions_62;
static int ett_rrc_T_r14_02;
static int ett_rrc_T_nonCriticalExtensions_77;
static int ett_rrc_MeasurementControl_LaterCriticalExtensions_r15_IEs;
static int ett_rrc_T_criticalExtensions_63;
static int ett_rrc_T_r15;
static int ett_rrc_T_nonCriticalExtensions_78;
static int ett_rrc_T_criticalExtensions_64;
static int ett_rrc_MeasurementControl_r15_IEs;
static int ett_rrc_MeasurementControlFailure;
static int ett_rrc_T_laterNonCriticalExtensions_19;
static int ett_rrc_T_v590NonCriticalExtensions_10;
static int ett_rrc_T_vc50NonCriticalExtensions_03;
static int ett_rrc_T_nonCriticalExtensions_79;
static int ett_rrc_MeasurementControlFailure_v590ext_IEs;
static int ett_rrc_MeasurementControlFailure_vc50ext_IEs;
static int ett_rrc_MeasurementReport;
static int ett_rrc_T_v390nonCriticalExtensions_01;
static int ett_rrc_T_laterNonCriticalExtensions_20;
static int ett_rrc_T_v4b0NonCriticalExtensions_06;
static int ett_rrc_T_v590NonCriticalExtensions_11;
static int ett_rrc_T_v5b0NonCriticalExtensions_02;
static int ett_rrc_T_v690NonCriticalExtensions_11;
static int ett_rrc_T_v770NonCriticalExtensions_03;
static int ett_rrc_T_v860NonCriticalExtensions_08;
static int ett_rrc_T_v920NonCriticalExtensions_01;
static int ett_rrc_T_v970NonCriticalExtensions_01;
static int ett_rrc_T_va40NonCriticalExtensions_04;
static int ett_rrc_T_vb50NonCriticalExtensions_10;
static int ett_rrc_MeasurementReport_v390ext;
static int ett_rrc_MeasurementReport_v4b0ext_IEs;
static int ett_rrc_MeasurementReport_v590ext_IEs;
static int ett_rrc_MeasurementReport_v5b0ext_IEs;
static int ett_rrc_MeasurementReport_v690ext_IEs;
static int ett_rrc_MeasurementReport_v770ext_IEs;
static int ett_rrc_MeasurementReport_v860ext_IEs;
static int ett_rrc_MeasurementReport_v920ext_IEs;
static int ett_rrc_MeasurementReport_v970ext_IEs;
static int ett_rrc_MeasurementReport_va40ext_IEs;
static int ett_rrc_MeasurementReport_vb50ext_IEs;
static int ett_rrc_MeasurementReport_LaterNonCriticalExtensions;
static int ett_rrc_T_vd20NonCriticalExtensions_01;
static int ett_rrc_MeasurementReport_vc50ext_IEs;
static int ett_rrc_MeasurementReport_vd20ext_IEs;
static int ett_rrc_MeasurementReport_ve30ext_IEs;
static int ett_rrc_MeasurementReport_vf20ext_IEs;
static int ett_rrc_T_nonCriticalExtensions_80;
static int ett_rrc_PagingType1;
static int ett_rrc_T_laterNonCriticalExtensions_21;
static int ett_rrc_T_v590NonCriticalExtensions_12;
static int ett_rrc_T_v860NonCriticalExtensions_09;
static int ett_rrc_T_vc50NonCriticalExtensions_04;
static int ett_rrc_T_nonCriticalExtensions_81;
static int ett_rrc_PagingType1_v590ext_IEs;
static int ett_rrc_PagingType1_v860ext_IEs;
static int ett_rrc_PagingType1_vc50ext_IEs;
static int ett_rrc_PagingType2;
static int ett_rrc_T_laterNonCriticalExtensions_22;
static int ett_rrc_T_nonCriticalExtensions_82;
static int ett_rrc_PhysicalChannelReconfiguration;
static int ett_rrc_T_r3_12;
static int ett_rrc_T_v3a0NonCriticalExtensions_05;
static int ett_rrc_T_laterNonCriticalExtensions_23;
static int ett_rrc_T_v4b0NonCriticalExtenstions;
static int ett_rrc_T_v590NonCriticalExtenstions_02;
static int ett_rrc_T_v690NonCriticalExtensions_12;
static int ett_rrc_T_v770NonCriticalExtensions_04;
static int ett_rrc_T_nonCriticalExtensions_83;
static int ett_rrc_T_later_than_r3_10;
static int ett_rrc_T_criticalExtensions_65;
static int ett_rrc_T_r4_04;
static int ett_rrc_T_v4d0NonCriticalExtensions_04;
static int ett_rrc_T_v590NonCriticalExtenstions_03;
static int ett_rrc_T_v690NonCriticalExtensions_13;
static int ett_rrc_T_v770NonCriticalExtensions_05;
static int ett_rrc_T_nonCriticalExtensions_84;
static int ett_rrc_T_criticalExtensions_66;
static int ett_rrc_T_r5_04;
static int ett_rrc_T_v690NonCriticalExtensions_14;
static int ett_rrc_T_v770NonCriticalExtensions_06;
static int ett_rrc_T_nonCriticalExtensions_85;
static int ett_rrc_T_criticalExtensions_67;
static int ett_rrc_T_r6_06;
static int ett_rrc_T_v6b0NonCriticalExtensions_05;
static int ett_rrc_T_v770NonCriticalExtensions_07;
static int ett_rrc_T_nonCriticalExtensions_86;
static int ett_rrc_T_criticalExtensions_68;
static int ett_rrc_T_r7_05;
static int ett_rrc_T_v780NonCriticalExtensions_04;
static int ett_rrc_T_v7d0NonCriticalExtensions_04;
static int ett_rrc_T_v7f0NonCriticalExtensions_05;
static int ett_rrc_T_v7g0NonCriticalExtensions_06;
static int ett_rrc_T_nonCriticalExtensions_87;
static int ett_rrc_T_criticalExtensions_69;
static int ett_rrc_T_r8_06;
static int ett_rrc_T_v7d0NonCriticalExtensions_05;
static int ett_rrc_T_v7f0NonCriticalExtensions_06;
static int ett_rrc_T_v890NonCriticalExtensions_04;
static int ett_rrc_T_v7g0NonCriticalExtensions_07;
static int ett_rrc_T_v8a0NonCriticalExtensions_04;
static int ett_rrc_T_nonCriticalExtensions_88;
static int ett_rrc_T_criticalExtensions_70;
static int ett_rrc_T_r9_05;
static int ett_rrc_T_v950NonCriticalExtensions_03;
static int ett_rrc_T_nonCriticalExtensions_89;
static int ett_rrc_T_criticalExtensions_71;
static int ett_rrc_T_r10_05;
static int ett_rrc_T_vb50NonCriticalExtensions_11;
static int ett_rrc_T_nonCriticalExtensions_90;
static int ett_rrc_T_criticalExtensions_72;
static int ett_rrc_T_r11_06;
static int ett_rrc_T_nonCriticalExtensions_91;
static int ett_rrc_T_criticalExtensions_73;
static int ett_rrc_T_r12_05;
static int ett_rrc_T_nonCriticalExtensions_92;
static int ett_rrc_T_criticalExtensions_74;
static int ett_rrc_T_r13_04;
static int ett_rrc_T_nonCriticalExtensions_93;
static int ett_rrc_T_criticalExtensions_75;
static int ett_rrc_PhysicalChannelReconfiguration_r3_IEs;
static int ett_rrc_T_modeSpecificInfo_13;
static int ett_rrc_T_fdd_19;
static int ett_rrc_PhysicalChannelReconfiguration_v3a0ext;
static int ett_rrc_PhysicalChannelReconfiguration_v4b0ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v590ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_r4_IEs;
static int ett_rrc_T_modeSpecificInfo_14;
static int ett_rrc_T_fdd_20;
static int ett_rrc_PhysicalChannelReconfiguration_r5_IEs;
static int ett_rrc_T_modeSpecificInfo_15;
static int ett_rrc_T_fdd_21;
static int ett_rrc_PhysicalChannelReconfiguration_r6_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v690ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v6b0ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_r7_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v770ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v780ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v7d0ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v7f0ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v7g0ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_r8_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v890ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v8a0ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_r9_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_v950ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_r10_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_vb50ext_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_r11_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_r12_IEs;
static int ett_rrc_PhysicalChannelReconfiguration_r13_IEs;
static int ett_rrc_PhysicalChannelReconfigurationComplete;
static int ett_rrc_T_laterNonCriticalExtensions_24;
static int ett_rrc_T_v770NonCriticalExtensions_08;
static int ett_rrc_T_nonCriticalExtensions_94;
static int ett_rrc_PhysicalChannelReconfigurationComplete_v770ext_IEs;
static int ett_rrc_PhysicalChannelReconfigurationFailure;
static int ett_rrc_T_laterNonCriticalExtensions_25;
static int ett_rrc_T_nonCriticalExtensions_95;
static int ett_rrc_PhysicalSharedChannelAllocation;
static int ett_rrc_T_r3_13;
static int ett_rrc_T_laterNonCriticalExtensions_26;
static int ett_rrc_T_nonCriticalExtensions_96;
static int ett_rrc_T_later_than_r3_11;
static int ett_rrc_T_criticalExtensions_76;
static int ett_rrc_T_r4_05;
static int ett_rrc_T_v4d0NonCriticalExtensions_05;
static int ett_rrc_T_v690NonCriticalExtensions_15;
static int ett_rrc_T_v770NonCriticalExtensions_09;
static int ett_rrc_T_nonCriticalExtensions_97;
static int ett_rrc_T_criticalExtensions_77;
static int ett_rrc_PhysicalSharedChannelAllocation_r3_IEs;
static int ett_rrc_PhysicalSharedChannelAllocation_r4_IEs;
static int ett_rrc_PhysicalSharedChannelAllocation_v690ext_IEs;
static int ett_rrc_PhysicalSharedChannelAllocation_v770ext_IEs;
static int ett_rrc_PUSCHCapacityRequest;
static int ett_rrc_T_allocationConfirmation;
static int ett_rrc_T_laterNonCriticalExtensions_27;
static int ett_rrc_T_v590NonCriticalExtensions_13;
static int ett_rrc_T_nonCriticalExtensions_98;
static int ett_rrc_PUSCHCapacityRequest_v590ext;
static int ett_rrc_RadioBearerReconfiguration;
static int ett_rrc_T_r3_14;
static int ett_rrc_T_v3aoNonCriticalExtensions;
static int ett_rrc_T_laterNonCriticalExtensions_28;
static int ett_rrc_T_v4b0NonCriticalExtensions_07;
static int ett_rrc_T_v590NonCriticalExtensions_14;
static int ett_rrc_T_v5d0NonCriticalExtenstions_06;
static int ett_rrc_T_v690NonCriticalExtensions_16;
static int ett_rrc_T_v770NonCriticalExtensions_10;
static int ett_rrc_T_nonCriticalExtensions_99;
static int ett_rrc_T_later_than_r3_12;
static int ett_rrc_T_criticalExtensions_78;
static int ett_rrc_T_r4_06;
static int ett_rrc_T_v4d0NonCriticalExtensions_06;
static int ett_rrc_T_v590NonCriticalExtensions_15;
static int ett_rrc_T_v5d0NonCriticalExtenstions_07;
static int ett_rrc_T_v690NonCriticalExtensions_17;
static int ett_rrc_T_v770NonCriticalExtensions_11;
static int ett_rrc_T_nonCriticalExtensions_100;
static int ett_rrc_T_criticalExtensions_79;
static int ett_rrc_T_r5_05;
static int ett_rrc_T_v5d0NonCriticalExtenstions_08;
static int ett_rrc_T_v690NonCriticalExtensions_18;
static int ett_rrc_T_v770NonCriticalExtensions_12;
static int ett_rrc_T_nonCriticalExtensions_101;
static int ett_rrc_T_criticalExtensions_80;
static int ett_rrc_T_r6_07;
static int ett_rrc_T_v6b0NonCriticalExtensions_06;
static int ett_rrc_T_v6f0NonCriticalExtensions;
static int ett_rrc_T_v770NonCriticalExtensions_13;
static int ett_rrc_T_nonCriticalExtensions_102;
static int ett_rrc_T_criticalExtensions_81;
static int ett_rrc_T_r7_06;
static int ett_rrc_T_v780NonCriticalExtensions_05;
static int ett_rrc_T_v790NonCriticalExtensions;
static int ett_rrc_T_v7d0NonCriticalExtensions_06;
static int ett_rrc_T_v7f0NonCriticalExtensions_07;
static int ett_rrc_T_v7g0NonCriticalExtensions_08;
static int ett_rrc_T_nonCriticalExtensions_103;
static int ett_rrc_T_criticalExtensions_82;
static int ett_rrc_T_r8_07;
static int ett_rrc_T_v7d0NonCriticalExtensions_07;
static int ett_rrc_T_v7f0NonCriticalExtensions_08;
static int ett_rrc_T_v890NonCriticalExtensions_05;
static int ett_rrc_T_v7g0NonCriticalExtensions_09;
static int ett_rrc_T_v8a0NonCriticalExtensions_05;
static int ett_rrc_T_nonCriticalExtensions_104;
static int ett_rrc_T_criticalExtensions_83;
static int ett_rrc_T_r9_06;
static int ett_rrc_T_v950NonCriticalExtensions_04;
static int ett_rrc_T_v9c0NonCriticalExtensions_04;
static int ett_rrc_T_nonCriticalExtensions_105;
static int ett_rrc_T_criticalExtensions_84;
static int ett_rrc_T_r10_06;
static int ett_rrc_T_v9c0NonCriticalExtensions_05;
static int ett_rrc_T_vaa0NonCriticalExtensions_01;
static int ett_rrc_T_vb50NonCriticalExtensions_12;
static int ett_rrc_T_nonCriticalExtensions_106;
static int ett_rrc_T_criticalExtensions_85;
static int ett_rrc_T_r11_07;
static int ett_rrc_T_nonCriticalExtensions_107;
static int ett_rrc_T_criticalExtensions_86;
static int ett_rrc_T_r12_06;
static int ett_rrc_T_nonCriticalExtensions_108;
static int ett_rrc_T_criticalExtensions_87;
static int ett_rrc_T_r13_05;
static int ett_rrc_T_nonCriticalExtensions_109;
static int ett_rrc_T_criticalExtensions_88;
static int ett_rrc_T_r14_03;
static int ett_rrc_T_nonCriticalExtensions_110;
static int ett_rrc_RadioBearerReconfiguration_vaa0ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_r3_IEs;
static int ett_rrc_T_dummy_01;
static int ett_rrc_T_fdd_22;
static int ett_rrc_T_modeSpecificPhysChInfo_03;
static int ett_rrc_T_fdd_23;
static int ett_rrc_RadioBearerReconfiguration_v3a0ext;
static int ett_rrc_RadioBearerReconfiguration_v4b0ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v590ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v5d0ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_r4_IEs;
static int ett_rrc_T_dummy_02;
static int ett_rrc_T_fdd_24;
static int ett_rrc_T_modeSpecificPhysChInfo_04;
static int ett_rrc_T_fdd_25;
static int ett_rrc_RadioBearerReconfiguration_r5_IEs;
static int ett_rrc_T_specificationMode_11;
static int ett_rrc_T_complete_11;
static int ett_rrc_T_dummy_03;
static int ett_rrc_T_fdd_26;
static int ett_rrc_T_preconfiguration_10;
static int ett_rrc_T_preConfigMode_10;
static int ett_rrc_T_defaultConfig_10;
static int ett_rrc_T_modeSpecificPhysChInfo_05;
static int ett_rrc_T_fdd_27;
static int ett_rrc_RadioBearerReconfiguration_r6_IEs;
static int ett_rrc_T_specificationMode_12;
static int ett_rrc_T_complete_12;
static int ett_rrc_T_preconfiguration_11;
static int ett_rrc_T_preConfigMode_11;
static int ett_rrc_T_defaultConfig_11;
static int ett_rrc_RadioBearerReconfiguration_v690ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v6b0ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v6f0ext_IEs;
static int ett_rrc_T_specificationMode_13;
static int ett_rrc_T_complete_13;
static int ett_rrc_RadioBearerReconfiguration_r7_IEs;
static int ett_rrc_T_specificationMode_14;
static int ett_rrc_T_complete_14;
static int ett_rrc_T_preconfiguration_12;
static int ett_rrc_T_preConfigMode_12;
static int ett_rrc_T_defaultConfig_12;
static int ett_rrc_RadioBearerReconfiguration_v770ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v780ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v790ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v7d0ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v7f0ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v7g0ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_r8_IEs;
static int ett_rrc_T_specificationMode_15;
static int ett_rrc_T_complete_15;
static int ett_rrc_T_preconfiguration_13;
static int ett_rrc_T_preConfigMode_13;
static int ett_rrc_T_defaultConfig_13;
static int ett_rrc_RadioBearerReconfiguration_v890ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v8a0ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_r9_IEs;
static int ett_rrc_T_specificationMode_16;
static int ett_rrc_T_complete_16;
static int ett_rrc_T_preconfiguration_14;
static int ett_rrc_T_preConfigMode_14;
static int ett_rrc_T_defaultConfig_14;
static int ett_rrc_RadioBearerReconfiguration_v950ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_v9c0ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_r10_IEs;
static int ett_rrc_T_specificationMode_17;
static int ett_rrc_T_complete_17;
static int ett_rrc_T_preconfiguration_15;
static int ett_rrc_T_preConfigMode_15;
static int ett_rrc_T_defaultConfig_15;
static int ett_rrc_RadioBearerReconfiguration_vb50ext_IEs;
static int ett_rrc_RadioBearerReconfiguration_r11_IEs;
static int ett_rrc_T_specificationMode_18;
static int ett_rrc_T_complete_18;
static int ett_rrc_T_preconfiguration_16;
static int ett_rrc_T_preConfigMode_16;
static int ett_rrc_T_defaultConfig_16;
static int ett_rrc_RadioBearerReconfiguration_r12_IEs;
static int ett_rrc_T_specificationMode_19;
static int ett_rrc_T_complete_19;
static int ett_rrc_T_preconfiguration_17;
static int ett_rrc_T_preConfigMode_17;
static int ett_rrc_T_defaultConfig_17;
static int ett_rrc_RadioBearerReconfiguration_r13_IEs;
static int ett_rrc_T_specificationMode_20;
static int ett_rrc_T_complete_20;
static int ett_rrc_T_preconfiguration_18;
static int ett_rrc_T_preConfigMode_18;
static int ett_rrc_T_defaultConfig_18;
static int ett_rrc_RadioBearerReconfiguration_r14_IEs;
static int ett_rrc_T_specificationMode_21;
static int ett_rrc_T_complete_21;
static int ett_rrc_T_preconfiguration_19;
static int ett_rrc_T_preConfigMode_19;
static int ett_rrc_T_defaultConfig_19;
static int ett_rrc_RadioBearerReconfiguration_LaterCriticalExtensions_r15_IEs;
static int ett_rrc_T_r15_01;
static int ett_rrc_T_nonCriticalExtensions_111;
static int ett_rrc_T_criticalExtensions_89;
static int ett_rrc_RadioBearerReconfiguration_r15_IEs;
static int ett_rrc_T_specificationMode_22;
static int ett_rrc_T_complete_22;
static int ett_rrc_T_preconfiguration_20;
static int ett_rrc_T_preConfigMode_20;
static int ett_rrc_T_defaultConfig_20;
static int ett_rrc_RadioBearerReconfigurationComplete;
static int ett_rrc_T_laterNonCriticalExtensions_29;
static int ett_rrc_T_v770NonCriticalExtensions_14;
static int ett_rrc_T_nonCriticalExtensions_112;
static int ett_rrc_RadioBearerReconfigurationComplete_v770ext_IEs;
static int ett_rrc_RadioBearerReconfigurationFailure;
static int ett_rrc_T_laterNonCriticalExtensions_30;
static int ett_rrc_T_nonCriticalExtensions_113;
static int ett_rrc_RadioBearerRelease;
static int ett_rrc_T_r3_15;
static int ett_rrc_T_v3a0NonCriticalExtensions_06;
static int ett_rrc_T_laterNonCriticalExtensions_31;
static int ett_rrc_T_v4b0NonCriticalExtensions_08;
static int ett_rrc_T_v590NonCriticalExtensions_16;
static int ett_rrc_T_v690NonCriticalExtensions_19;
static int ett_rrc_T_v770NonCriticalExtensions_15;
static int ett_rrc_T_nonCriticalExtensions_114;
static int ett_rrc_T_later_than_r3_13;
static int ett_rrc_T_criticalExtensions_90;
static int ett_rrc_T_r4_07;
static int ett_rrc_T_v4d0NonCriticalExtensions_07;
static int ett_rrc_T_v590NonCriticalExtensions_17;
static int ett_rrc_T_v690NonCriticalExtensions_20;
static int ett_rrc_T_v770NonCriticalExtensions_16;
static int ett_rrc_T_nonCriticalExtensions_115;
static int ett_rrc_T_criticalExtensions_91;
static int ett_rrc_T_r5_06;
static int ett_rrc_T_v690NonCriticalExtensions_21;
static int ett_rrc_T_v770NonCriticalExtensions_17;
static int ett_rrc_T_nonCriticalExtensions_116;
static int ett_rrc_T_criticalExtensions_92;
static int ett_rrc_T_r6_08;
static int ett_rrc_T_v6b0NonCriticalExtensions_07;
static int ett_rrc_T_v770NonCriticalExtensions_18;
static int ett_rrc_T_nonCriticalExtensions_117;
static int ett_rrc_T_criticalExtensions_93;
static int ett_rrc_T_r7_07;
static int ett_rrc_T_v780NonCriticalExtensions_06;
static int ett_rrc_T_v7d0NonCriticalExtensions_08;
static int ett_rrc_T_v7f0NonCriticalExtensions_09;
static int ett_rrc_T_v7g0NonCriticalExtensions_10;
static int ett_rrc_T_nonCriticalExtensions_118;
static int ett_rrc_T_criticalExtensions_94;
static int ett_rrc_T_r8_08;
static int ett_rrc_T_v7d0NonCriticalExtensions_09;
static int ett_rrc_T_v7f0NonCriticalExtensions_10;
static int ett_rrc_T_v890NonCriticalExtensions_06;
static int ett_rrc_T_v7g0NonCriticalExtensions_11;
static int ett_rrc_T_v8a0NonCriticalExtensions_06;
static int ett_rrc_T_nonCriticalExtensions_119;
static int ett_rrc_T_criticalExtensions_95;
static int ett_rrc_T_r9_07;
static int ett_rrc_T_v950NonCriticalExtensions_05;
static int ett_rrc_T_v970NonCriticalExtensions_02;
static int ett_rrc_T_v9c0NonCriticalExtensions_06;
static int ett_rrc_T_nonCriticalExtensions_120;
static int ett_rrc_T_criticalExtensions_96;
static int ett_rrc_T_r10_07;
static int ett_rrc_T_v9c0NonCriticalExtensions_07;
static int ett_rrc_T_vb50NonCriticalExtensions_13;
static int ett_rrc_T_nonCriticalExtensions_121;
static int ett_rrc_T_criticalExtensions_97;
static int ett_rrc_T_r11_08;
static int ett_rrc_T_nonCriticalExtensions_122;
static int ett_rrc_T_criticalExtensions_98;
static int ett_rrc_T_r12_07;
static int ett_rrc_T_nonCriticalExtensions_123;
static int ett_rrc_T_criticalExtensions_99;
static int ett_rrc_T_r13_06;
static int ett_rrc_T_nonCriticalExtensions_124;
static int ett_rrc_RadioBearerRelease_r3_IEs;
static int ett_rrc_T_dummy_04;
static int ett_rrc_T_fdd_28;
static int ett_rrc_T_modeSpecificPhysChInfo_06;
static int ett_rrc_T_fdd_29;
static int ett_rrc_RadioBearerRelease_v3a0ext;
static int ett_rrc_RadioBearerRelease_v4b0ext_IEs;
static int ett_rrc_RadioBearerRelease_v590ext_IEs;
static int ett_rrc_RadioBearerRelease_r4_IEs;
static int ett_rrc_T_dummy_05;
static int ett_rrc_T_fdd_30;
static int ett_rrc_T_modeSpecificPhysChInfo_07;
static int ett_rrc_T_fdd_31;
static int ett_rrc_RadioBearerRelease_r5_IEs;
static int ett_rrc_T_dummy_06;
static int ett_rrc_T_fdd_32;
static int ett_rrc_T_modeSpecificPhysChInfo_08;
static int ett_rrc_T_fdd_33;
static int ett_rrc_RadioBearerRelease_v690ext_IEs;
static int ett_rrc_RadioBearerRelease_r6_IEs;
static int ett_rrc_RadioBearerRelease_v6b0ext_IEs;
static int ett_rrc_RadioBearerRelease_r7_IEs;
static int ett_rrc_RadioBearerRelease_v770ext_IEs;
static int ett_rrc_RadioBearerRelease_v780ext_IEs;
static int ett_rrc_RadioBearerRelease_v7d0ext_IEs;
static int ett_rrc_RadioBearerRelease_v7f0ext_IEs;
static int ett_rrc_RadioBearerRelease_v7g0ext_IEs;
static int ett_rrc_RadioBearerRelease_r8_IEs;
static int ett_rrc_RadioBearerRelease_v890ext_IEs;
static int ett_rrc_RadioBearerRelease_v8a0ext_IEs;
static int ett_rrc_RadioBearerRelease_r9_IEs;
static int ett_rrc_RadioBearerRelease_v950ext_IEs;
static int ett_rrc_RadioBearerRelease_v970ext_IEs;
static int ett_rrc_RadioBearerRelease_v9c0ext_IEs;
static int ett_rrc_RadioBearerRelease_r10_IEs;
static int ett_rrc_RadioBearerRelease_vb50ext_IEs;
static int ett_rrc_RadioBearerRelease_r11_IEs;
static int ett_rrc_RadioBearerRelease_r12_IEs;
static int ett_rrc_RadioBearerRelease_r13_IEs;
static int ett_rrc_RadioBearerRelease_LaterCriticalExtensions_r15_IEs;
static int ett_rrc_T_r15_02;
static int ett_rrc_T_nonCriticalExtensions_125;
static int ett_rrc_T_criticalExtensions_100;
static int ett_rrc_RadioBearerRelease_r15_IEs;
static int ett_rrc_RadioBearerReleaseComplete;
static int ett_rrc_T_laterNonCriticalExtensions_32;
static int ett_rrc_T_v770NonCriticalExtensions_19;
static int ett_rrc_T_nonCriticalExtensions_126;
static int ett_rrc_RadioBearerReleaseComplete_v770ext_IEs;
static int ett_rrc_RadioBearerReleaseFailure;
static int ett_rrc_T_laterNonCriticalExtensions_33;
static int ett_rrc_T_nonCriticalExtensions_127;
static int ett_rrc_RadioBearerSetup;
static int ett_rrc_T_r3_16;
static int ett_rrc_T_v3a0NonCriticalExtensions_07;
static int ett_rrc_T_laterNonCriticalExtensions_34;
static int ett_rrc_T_v4b0NonCriticalExtensions_09;
static int ett_rrc_T_v590NonCriticalExtensions_18;
static int ett_rrc_T_v5d0NonCriticalExtenstions_09;
static int ett_rrc_T_v690NonCriticalExtensions_22;
static int ett_rrc_T_nonCriticalExtensions_128;
static int ett_rrc_T_later_than_r3_14;
static int ett_rrc_T_criticalExtensions_101;
static int ett_rrc_T_r4_08;
static int ett_rrc_T_v4d0NonCriticalExtensions_08;
static int ett_rrc_T_v590NonCriticalExtensions_19;
static int ett_rrc_T_v5d0NonCriticalExtenstions_10;
static int ett_rrc_T_v690NonCriticalExtensions_23;
static int ett_rrc_T_nonCriticalExtensions_129;
static int ett_rrc_T_criticalExtensions_102;
static int ett_rrc_T_r5_07;
static int ett_rrc_T_v5d0NonCriticalExtenstions_11;
static int ett_rrc_T_v690NonCriticalExtensions_24;
static int ett_rrc_T_nonCriticalExtensions_130;
static int ett_rrc_T_criticalExtensions_103;
static int ett_rrc_T_r6_09;
static int ett_rrc_T_v6b0NonCriticalExtensions_08;
static int ett_rrc_T_nonCriticalExtensions_131;
static int ett_rrc_T_criticalExtensions_104;
static int ett_rrc_T_r7_08;
static int ett_rrc_T_v780NonCriticalExtensions_07;
static int ett_rrc_T_v820NonCriticalExtensions_01;
static int ett_rrc_T_nonCriticalExtensions_132;
static int ett_rrc_T_criticalExtensions_105;
static int ett_rrc_T_r8_09;
static int ett_rrc_T_v7d0NonCriticalExtensions_10;
static int ett_rrc_T_v7f0NonCriticalExtensions_11;
static int ett_rrc_T_v890NonCriticalExtensions_07;
static int ett_rrc_T_v7g0NonCriticalExtensions_12;
static int ett_rrc_T_v8a0NonCriticalExtensions_07;
static int ett_rrc_T_nonCriticalExtensions_133;
static int ett_rrc_T_criticalExtensions_106;
static int ett_rrc_T_r9_08;
static int ett_rrc_T_v950NonCriticalExtensions_06;
static int ett_rrc_T_v9c0NonCriticalExtensions_08;
static int ett_rrc_T_nonCriticalExtensions_134;
static int ett_rrc_T_criticalExtensions_107;
static int ett_rrc_T_r10_08;
static int ett_rrc_T_v9c0NonCriticalExtensions_09;
static int ett_rrc_T_vb50NonCriticalExtensions_14;
static int ett_rrc_T_nonCriticalExtensions_135;
static int ett_rrc_T_criticalExtensions_108;
static int ett_rrc_T_r11_09;
static int ett_rrc_T_nonCriticalExtensions_136;
static int ett_rrc_T_criticalExtensions_109;
static int ett_rrc_T_r12_08;
static int ett_rrc_T_nonCriticalExtensions_137;
static int ett_rrc_T_criticalExtensions_110;
static int ett_rrc_T_r13_07;
static int ett_rrc_T_nonCriticalExtensions_138;
static int ett_rrc_RadioBearerSetup_r3_IEs;
static int ett_rrc_T_dummy_07;
static int ett_rrc_T_fdd_34;
static int ett_rrc_T_modeSpecificPhysChInfo_09;
static int ett_rrc_T_fdd_35;
static int ett_rrc_RadioBearerSetup_v3a0ext;
static int ett_rrc_RadioBearerSetup_v4b0ext_IEs;
static int ett_rrc_RadioBearerSetup_v590ext_IEs;
static int ett_rrc_RadioBearerSetup_v5d0ext_IEs;
static int ett_rrc_RadioBearerSetup_r4_IEs;
static int ett_rrc_T_dummy_08;
static int ett_rrc_T_fdd_36;
static int ett_rrc_T_modeSpecificPhysChInfo_10;
static int ett_rrc_T_fdd_37;
static int ett_rrc_RadioBearerSetup_r5_IEs;
static int ett_rrc_T_dummy_09;
static int ett_rrc_T_fdd_38;
static int ett_rrc_T_modeSpecificPhysChInfo_11;
static int ett_rrc_T_fdd_39;
static int ett_rrc_RadioBearerSetup_v690ext_IEs;
static int ett_rrc_RadioBearerSetup_r6_IEs;
static int ett_rrc_T_specificationMode_23;
static int ett_rrc_T_complete_23;
static int ett_rrc_T_dummy_10;
static int ett_rrc_RadioBearerSetup_v6b0ext_IEs;
static int ett_rrc_RadioBearerSetup_r7_IEs;
static int ett_rrc_T_specificationMode_24;
static int ett_rrc_T_complete_24;
static int ett_rrc_RadioBearerSetup_r7_add_ext_IEs;
static int ett_rrc_T_v7f0NonCriticalExtensions_12;
static int ett_rrc_T_v7g0NonCriticalExtensions_13;
static int ett_rrc_T_nonCriticalExtensions_139;
static int ett_rrc_RadioBearerSetup_v780ext_IEs;
static int ett_rrc_RadioBearerSetup_v7d0ext_IEs;
static int ett_rrc_RadioBearerSetup_v7f0ext_IEs;
static int ett_rrc_RadioBearerSetup_v7g0ext_IEs;
static int ett_rrc_RadioBearerSetup_r8_IEs;
static int ett_rrc_RadioBearerSetup_v820ext_IEs;
static int ett_rrc_RadioBearerSetup_v890ext_IEs;
static int ett_rrc_RadioBearerSetup_v8a0ext_IEs;
static int ett_rrc_RadioBearerSetup_r9_IEs;
static int ett_rrc_RadioBearerSetup_v950ext_IEs;
static int ett_rrc_RadioBearerSetup_v9c0ext_IEs;
static int ett_rrc_RadioBearerSetup_r10_IEs;
static int ett_rrc_RadioBearerSetup_vb50ext_IEs;
static int ett_rrc_RadioBearerSetup_r11_IEs;
static int ett_rrc_RadioBearerSetup_r12_IEs;
static int ett_rrc_RadioBearerSetup_r13_IEs;
static int ett_rrc_RadioBearerSetup_LaterCriticalExtensions_r15_IEs;
static int ett_rrc_T_r15_03;
static int ett_rrc_T_nonCriticalExtensions_140;
static int ett_rrc_T_criticalExtensions_111;
static int ett_rrc_RadioBearerSetup_r15_IEs;
static int ett_rrc_RadioBearerSetupComplete;
static int ett_rrc_T_laterNonCriticalExtensions_35;
static int ett_rrc_T_v770NonCriticalExtensions_20;
static int ett_rrc_T_nonCriticalExtensions_141;
static int ett_rrc_RadioBearerSetupComplete_v770ext_IEs;
static int ett_rrc_RadioBearerSetupFailure;
static int ett_rrc_T_laterNonCriticalExtensions_36;
static int ett_rrc_T_nonCriticalExtensions_142;
static int ett_rrc_RRCConnectionReject;
static int ett_rrc_T_r3_17;
static int ett_rrc_T_laterNonCriticalExtensions_37;
static int ett_rrc_T_v690NonCriticalExtensions_25;
static int ett_rrc_T_v6f0NonCriticalExtensions_01;
static int ett_rrc_T_v860NonCriticalExtensions_10;
static int ett_rrc_T_va40NonCriticalExtensions_05;
static int ett_rrc_T_vb50NonCriticalExtensions_15;
static int ett_rrc_T_nonCriticalExtensions_143;
static int ett_rrc_T_later_than_r3_15;
static int ett_rrc_T_criticalExtensions_112;
static int ett_rrc_RRCConnectionReject_r3_IEs;
static int ett_rrc_RRCConnectionReject_v690ext_IEs;
static int ett_rrc_RRCConnectionReject_v6f0ext_IEs;
static int ett_rrc_RRCConnectionReject_v860ext_IEs;
static int ett_rrc_RRCConnectionReject_va40ext_IEs;
static int ett_rrc_RRCConnectionReject_vb50ext_IEs;
static int ett_rrc_RRCConnectionRelease;
static int ett_rrc_T_r3_18;
static int ett_rrc_T_laterNonCriticalExtensions_38;
static int ett_rrc_T_v690NonCriticalExtensions_26;
static int ett_rrc_T_v770NonCriticalExtensions_21;
static int ett_rrc_T_v860NonCriticalExtensions_11;
static int ett_rrc_T_va40NonCriticalExtensions_06;
static int ett_rrc_T_nonCriticalExtensions_144;
static int ett_rrc_T_later_than_r3_16;
static int ett_rrc_T_criticalExtensions_113;
static int ett_rrc_T_r4_09;
static int ett_rrc_T_v4d0NonCriticalExtensions_09;
static int ett_rrc_T_v690NonCriticalExtensions_27;
static int ett_rrc_T_v770NonCriticalExtensions_22;
static int ett_rrc_T_v860NonCriticalExtensions_12;
static int ett_rrc_T_va40NonCriticalExtensions_07;
static int ett_rrc_T_vb50NonCriticalExtensions_16;
static int ett_rrc_T_nonCriticalExtensions_145;
static int ett_rrc_T_criticalExtensions_114;
static int ett_rrc_RRCConnectionRelease_r3_IEs;
static int ett_rrc_RRCConnectionRelease_r4_IEs;
static int ett_rrc_RRCConnectionRelease_v690ext_IEs;
static int ett_rrc_RRCConnectionRelease_v770ext_IEs;
static int ett_rrc_RRCConnectionRelease_v860ext_IEs;
static int ett_rrc_RRCConnectionRelease_va40ext_IEs;
static int ett_rrc_RRCConnectionRelease_vb50ext_IEs;
static int ett_rrc_RRCConnectionRelease_CCCH;
static int ett_rrc_T_r3_19;
static int ett_rrc_T_laterNonCriticalExtensions_39;
static int ett_rrc_T_v690NonCriticalExtensions_28;
static int ett_rrc_T_v860NonCriticalExtensions_13;
static int ett_rrc_T_va40NonCriticalExtensions_08;
static int ett_rrc_T_nonCriticalExtensions_146;
static int ett_rrc_T_later_than_r3_17;
static int ett_rrc_T_criticalExtensions_115;
static int ett_rrc_T_r4_10;
static int ett_rrc_T_v4d0NonCriticalExtensions_10;
static int ett_rrc_T_v690NonCriticalExtensions_29;
static int ett_rrc_T_v860NonCriticalExtensions_14;
static int ett_rrc_T_va40NonCriticalExtensions_09;
static int ett_rrc_T_nonCriticalExtensions_147;
static int ett_rrc_T_criticalExtensions_116;
static int ett_rrc_SEQUENCE_SIZE_1_maxURNTI_Group_OF_GroupReleaseInformation;
static int ett_rrc_T_criticalExtensions_117;
static int ett_rrc_T_r5_08;
static int ett_rrc_T_v690NonCriticalExtensions_30;
static int ett_rrc_T_v860NonCriticalExtensions_15;
static int ett_rrc_T_va40NonCriticalExtensions_10;
static int ett_rrc_T_vd20NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_148;
static int ett_rrc_T_criticalExtensions_118;
static int ett_rrc_RRCConnectionRelease_CCCH_r3_IEs;
static int ett_rrc_RRCConnectionRelease_CCCH_r4_IEs;
static int ett_rrc_RRCConnectionReleaseComplete;
static int ett_rrc_T_laterNonCriticalExtensions_40;
static int ett_rrc_T_nonCriticalExtensions_149;
static int ett_rrc_RRCConnectionRequest;
static int ett_rrc_T_v3d0NonCriticalExtensions;
static int ett_rrc_T_v4b0NonCriticalExtensions_10;
static int ett_rrc_T_v590NonCriticalExtensions_20;
static int ett_rrc_T_v690NonCriticalExtensions_31;
static int ett_rrc_T_v6b0NonCriticalExtensions_09;
static int ett_rrc_T_v6e0NonCriticalExtensions_01;
static int ett_rrc_T_v770NonCriticalExtensions_23;
static int ett_rrc_T_v7b0NonCriticalExtensions_01;
static int ett_rrc_T_v860NonCriticalExtensions_16;
static int ett_rrc_T_v7e0NonCriticalExtensions_01;
static int ett_rrc_T_v7g0NonCriticalExtensions_14;
static int ett_rrc_T_v920NonCriticalExtensions_02;
static int ett_rrc_T_v940NonCriticalExtensions;
static int ett_rrc_RRCConnectionRequest_v3d0ext_IEs;
static int ett_rrc_RRCConnectionRequest_v4b0ext_IEs;
static int ett_rrc_RRCConnectionRequest_v590ext_IEs;
static int ett_rrc_RRCConnectionRequest_v690ext_IEs;
static int ett_rrc_T_domainIndicator;
static int ett_rrc_T_cs_domain;
static int ett_rrc_RRCConnectionRequest_v6b0ext_IEs;
static int ett_rrc_RRCConnectionRequest_v6e0ext_IEs;
static int ett_rrc_RRCConnectionRequest_v770ext_IEs;
static int ett_rrc_RRCConnectionRequest_v7b0ext_IEs;
static int ett_rrc_RRCConnectionRequest_v7e0ext_IEs;
static int ett_rrc_RRCConnectionRequest_v7g0ext_IEs;
static int ett_rrc_RRCConnectionRequest_v860ext_IEs;
static int ett_rrc_RRCConnectionRequest_v920ext_IEs;
static int ett_rrc_RRCConnectionRequest_v940ext_IEs;
static int ett_rrc_RRCConnectionRequest_v9b0ext_IEs;
static int ett_rrc_RRCConnectionRequest_NonCriticalExts_va40_IEs;
static int ett_rrc_T_v9b0NonCriticalExtensions;
static int ett_rrc_T_vb50NonCriticalExtensions_17;
static int ett_rrc_T_vc50NonCriticalExtensions_05;
static int ett_rrc_T_nonCriticalExtensions_150;
static int ett_rrc_RRCConnectionRequest_va40ext_IEs;
static int ett_rrc_RRCConnectionRequest_vb50ext_IEs;
static int ett_rrc_RRCConnectionRequest_vc50ext_IEs;
static int ett_rrc_RRCConnectionSetup;
static int ett_rrc_T_r3_20;
static int ett_rrc_T_laterNonCriticalExtensions_41;
static int ett_rrc_T_v4b0NonCriticalExtensions_11;
static int ett_rrc_T_v590NonCriticalExtensions_21;
static int ett_rrc_T_v690NonCriticalExtensions_32;
static int ett_rrc_T_nonCriticalExtensions_151;
static int ett_rrc_T_later_than_r3_18;
static int ett_rrc_T_criticalExtensions_119;
static int ett_rrc_T_r4_11;
static int ett_rrc_T_v4d0NonCriticalExtensions_11;
static int ett_rrc_T_v590NonCriticalExtensions_22;
static int ett_rrc_T_v690NonCriticalExtensions_33;
static int ett_rrc_T_nonCriticalExtensions_152;
static int ett_rrc_T_criticalExtensions_120;
static int ett_rrc_T_r5_09;
static int ett_rrc_T_v690NonCriticalExtensions_34;
static int ett_rrc_T_nonCriticalExtensions_153;
static int ett_rrc_T_criticalExtensions_121;
static int ett_rrc_T_r6_10;
static int ett_rrc_T_v6b0NonCriticalExtensions_10;
static int ett_rrc_T_nonCriticalExtensions_154;
static int ett_rrc_T_criticalExtensions_122;
static int ett_rrc_T_r7_09;
static int ett_rrc_T_v780NonCriticalExtensions_08;
static int ett_rrc_T_v7d0NonCriticalExtensions_11;
static int ett_rrc_T_nonCriticalExtensions_155;
static int ett_rrc_T_criticalExtensions_123;
static int ett_rrc_T_r8_10;
static int ett_rrc_T_v7d0NonCriticalExtensions_12;
static int ett_rrc_T_v890NonCriticalExtensions_08;
static int ett_rrc_T_v8a0NonCriticalExtensions_08;
static int ett_rrc_T_nonCriticalExtensions_156;
static int ett_rrc_T_criticalExtensions_124;
static int ett_rrc_T_r9_09;
static int ett_rrc_T_v950NonCriticalExtensions_07;
static int ett_rrc_T_nonCriticalExtensions_157;
static int ett_rrc_T_criticalExtensions_125;
static int ett_rrc_T_r10_09;
static int ett_rrc_T_vaj0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_158;
static int ett_rrc_T_criticalExtensions_126;
static int ett_rrc_T_r11_10;
static int ett_rrc_T_vaj0NonCriticalExtensions_01;
static int ett_rrc_T_nonCriticalExtensions_159;
static int ett_rrc_T_criticalExtensions_127;
static int ett_rrc_T_r12_09;
static int ett_rrc_T_nonCriticalExtensions_160;
static int ett_rrc_T_criticalExtensions_128;
static int ett_rrc_RRCConnectionSetup_r3_IEs;
static int ett_rrc_RRCConnectionSetup_v4b0ext_IEs;
static int ett_rrc_RRCConnectionSetup_v590ext_IEs;
static int ett_rrc_RRCConnectionSetup_r4_IEs;
static int ett_rrc_RRCConnectionSetup_r5_IEs;
static int ett_rrc_T_specificationMode_25;
static int ett_rrc_T_complete_25;
static int ett_rrc_T_preconfiguration_21;
static int ett_rrc_T_preConfigMode_21;
static int ett_rrc_T_defaultConfig_21;
static int ett_rrc_RRCConnectionSetup_v690ext_IEs;
static int ett_rrc_RRCConnectionSetup_r6_IEs;
static int ett_rrc_T_specificationMode_26;
static int ett_rrc_T_complete_26;
static int ett_rrc_T_preconfiguration_22;
static int ett_rrc_T_preConfigMode_22;
static int ett_rrc_T_defaultConfig_22;
static int ett_rrc_RRCConnectionSetup_v6b0ext_IEs;
static int ett_rrc_RRCConnectionSetup_r7_IEs;
static int ett_rrc_T_specificationMode_27;
static int ett_rrc_T_complete_27;
static int ett_rrc_T_preconfiguration_23;
static int ett_rrc_T_preConfigMode_23;
static int ett_rrc_T_defaultConfig_23;
static int ett_rrc_RRCConnectionSetup_v780ext_IEs;
static int ett_rrc_RRCConnectionSetup_v7d0ext_IEs;
static int ett_rrc_RRCConnectionSetup_r8_IEs;
static int ett_rrc_T_specificationMode_28;
static int ett_rrc_T_complete_28;
static int ett_rrc_T_preconfiguration_24;
static int ett_rrc_T_preConfigMode_24;
static int ett_rrc_T_defaultConfig_24;
static int ett_rrc_RRCConnectionSetup_v890ext_IEs;
static int ett_rrc_RRCConnectionSetup_v8a0ext_IEs;
static int ett_rrc_RRCConnectionSetup_r9_IEs;
static int ett_rrc_T_specificationMode_29;
static int ett_rrc_T_complete_29;
static int ett_rrc_T_preconfiguration_25;
static int ett_rrc_T_preConfigMode_25;
static int ett_rrc_T_defaultConfig_25;
static int ett_rrc_RRCConnectionSetup_v950ext_IEs;
static int ett_rrc_RRCConnectionSetup_r10_IEs;
static int ett_rrc_T_specificationMode_30;
static int ett_rrc_T_complete_30;
static int ett_rrc_T_preconfiguration_26;
static int ett_rrc_T_preConfigMode_26;
static int ett_rrc_T_defaultConfig_26;
static int ett_rrc_RRCConnectionSetup_vaj0ext_IEs;
static int ett_rrc_RRCConnectionSetup_r11_IEs;
static int ett_rrc_T_specificationMode_31;
static int ett_rrc_T_complete_31;
static int ett_rrc_T_preconfiguration_27;
static int ett_rrc_T_preConfigMode_27;
static int ett_rrc_T_defaultConfig_27;
static int ett_rrc_RRCConnectionSetup_r12_IEs;
static int ett_rrc_T_specificationMode_32;
static int ett_rrc_T_complete_32;
static int ett_rrc_T_preconfiguration_28;
static int ett_rrc_T_preConfigMode_28;
static int ett_rrc_T_defaultConfig_28;
static int ett_rrc_RRCConnectionSetupComplete;
static int ett_rrc_T_v370NonCriticalExtensions;
static int ett_rrc_T_v380NonCriticalExtensions;
static int ett_rrc_T_v3a0NonCriticalExtensions_08;
static int ett_rrc_T_laterNonCriticalExtensions_42;
static int ett_rrc_T_v3g0NonCriticalExtensions_01;
static int ett_rrc_T_v4b0NonCriticalExtensions_12;
static int ett_rrc_T_v590NonCriticalExtensions_23;
static int ett_rrc_T_v5c0NonCriticalExtensions;
static int ett_rrc_T_v690NonCriticalExtensions_35;
static int ett_rrc_T_v770NonCriticalExtensions_24;
static int ett_rrc_T_va40NonCriticalExtensions_11;
static int ett_rrc_T_vb50NonCriticalExtensions_18;
static int ett_rrc_T_nonCriticalExtensions_161;
static int ett_rrc_RRCConnectionSetupComplete_v370ext;
static int ett_rrc_RRCConnectionSetupComplete_v380ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v3a0ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v3g0ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_r3_add_ext_IEs;
static int ett_rrc_T_v680NonCriticalExtensions;
static int ett_rrc_T_v7e0NonCriticalExtensions_02;
static int ett_rrc_T_v7f0NonCriticalExtensions_13;
static int ett_rrc_T_va40NonCriticalExtensions_12;
static int ett_rrc_T_nonCriticalExtensions_162;
static int ett_rrc_RRCConnectionSetupComplete_v4b0ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v590ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v5c0ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v650ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v680ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v690ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v770ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v7e0ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_v7f0ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_va40ext_IEs;
static int ett_rrc_RRCConnectionSetupCompleteBand_va40ext_IEs;
static int ett_rrc_RRCConnectionSetupComplete_vb50ext_IEs;
static int ett_rrc_RRC_FailureInfo;
static int ett_rrc_T_r3_21;
static int ett_rrc_T_laterNonCriticalExtensions_43;
static int ett_rrc_T_nonCriticalExtensions_163;
static int ett_rrc_T_criticalExtensions_129;
static int ett_rrc_RRC_FailureInfo_r3_IEs;
static int ett_rrc_RRCStatus;
static int ett_rrc_T_laterNonCriticalExtensions_44;
static int ett_rrc_T_nonCriticalExtensions_164;
static int ett_rrc_SecurityModeCommand;
static int ett_rrc_T_r3_22;
static int ett_rrc_T_laterNonCriticalExtensions_45;
static int ett_rrc_T_nonCriticalExtensions_165;
static int ett_rrc_T_later_than_r3_19;
static int ett_rrc_T_criticalExtensions_130;
static int ett_rrc_T_r7_10;
static int ett_rrc_T_nonCriticalExtensions_166;
static int ett_rrc_T_criticalExtensions_131;
static int ett_rrc_SecurityModeCommand_r3_IEs;
static int ett_rrc_SecurityModeCommand_r7_IEs;
static int ett_rrc_SecurityModeComplete;
static int ett_rrc_T_laterNonCriticalExtensions_46;
static int ett_rrc_T_nonCriticalExtensions_167;
static int ett_rrc_SecurityModeFailure;
static int ett_rrc_T_laterNonCriticalExtensions_47;
static int ett_rrc_T_nonCriticalExtensions_168;
static int ett_rrc_SignallingConnectionRelease;
static int ett_rrc_T_r3_23;
static int ett_rrc_T_laterNonCriticalExtensions_48;
static int ett_rrc_T_va40NonCriticalExtensions_13;
static int ett_rrc_T_nonCriticalExtensions_169;
static int ett_rrc_T_later_than_r3_20;
static int ett_rrc_T_criticalExtensions_132;
static int ett_rrc_SignallingConnectionRelease_r3_IEs;
static int ett_rrc_SignallingConnectionRelease_va40ext_IEs;
static int ett_rrc_SignallingConnectionReleaseIndication;
static int ett_rrc_T_laterNonCriticalExtensions_49;
static int ett_rrc_T_v860nonCriticalExtentions;
static int ett_rrc_T_nonCriticalExtensions_170;
static int ett_rrc_SignallingConnectionReleaseIndication_v860ext;
static int ett_rrc_SystemInformation_BCH;
static int ett_rrc_T_payload;
static int ett_rrc_T_lastAndFirst;
static int ett_rrc_T_lastAndComplete;
static int ett_rrc_T_lastAndCompleteAndFirst;
static int ett_rrc_T_completeAndFirst;
static int ett_rrc_SystemInformation2_BCH;
static int ett_rrc_T_segmentCombination;
static int ett_rrc_T_combination5;
static int ett_rrc_T_combination6;
static int ett_rrc_T_combination7;
static int ett_rrc_T_combination9;
static int ett_rrc_SystemInformation_FACH;
static int ett_rrc_T_payload_01;
static int ett_rrc_T_lastAndFirst_01;
static int ett_rrc_T_lastAndComplete_01;
static int ett_rrc_T_lastAndCompleteAndFirst_01;
static int ett_rrc_T_completeAndFirst_01;
static int ett_rrc_FirstSegment;
static int ett_rrc_FirstSegment2;
static int ett_rrc_FirstSegmentShort;
static int ett_rrc_FirstSegmentShort2;
static int ett_rrc_SubsequentSegment;
static int ett_rrc_SubsequentSegment2;
static int ett_rrc_LastSegment;
static int ett_rrc_LastSegment2;
static int ett_rrc_LastSegmentShort;
static int ett_rrc_LastSegmentShort2;
static int ett_rrc_CompleteSIB_List;
static int ett_rrc_CompleteSIB2_List;
static int ett_rrc_CompleteSIB;
static int ett_rrc_CompleteSIB2;
static int ett_rrc_CompleteSIBshort;
static int ett_rrc_CompleteSIBshort2;
static int ett_rrc_SystemInformationChangeIndication;
static int ett_rrc_T_laterNonCriticalExtensions_50;
static int ett_rrc_T_v860NonCriticalExtensions_17;
static int ett_rrc_T_vc50NonCriticalExtensions_06;
static int ett_rrc_T_nonCriticalExtensions_171;
static int ett_rrc_SystemInformationChangeIndication_v860ext_IEs;
static int ett_rrc_SystemInformationChangeIndication_vc50ext_IEs;
static int ett_rrc_TransportChannelReconfiguration;
static int ett_rrc_T_r3_24;
static int ett_rrc_T_v3a0NonCriticalExtensions_09;
static int ett_rrc_T_laterNonCriticalExtensions_51;
static int ett_rrc_T_v4b0NonCriticalExtensions_13;
static int ett_rrc_T_v590NonCriticalExtensions_24;
static int ett_rrc_T_v690NonCriticalExtensions_36;
static int ett_rrc_T_v770NonCriticalExtensions_25;
static int ett_rrc_T_nonCriticalExtensions_172;
static int ett_rrc_T_later_than_r3_21;
static int ett_rrc_T_criticalExtensions_133;
static int ett_rrc_T_r4_12;
static int ett_rrc_T_v4d0NonCriticalExtensions_12;
static int ett_rrc_T_v590NonCriticalExtensions_25;
static int ett_rrc_T_v690NonCriticalExtensions_37;
static int ett_rrc_T_v770NonCriticalExtensions_26;
static int ett_rrc_T_nonCriticalExtensions_173;
static int ett_rrc_T_criticalExtensions_134;
static int ett_rrc_T_r5_10;
static int ett_rrc_T_v690NonCriticalExtensions_38;
static int ett_rrc_T_v770NonCriticalExtensions_27;
static int ett_rrc_T_nonCriticalExtensions_174;
static int ett_rrc_T_criticalExtensions_135;
static int ett_rrc_T_r6_11;
static int ett_rrc_T_v6b0NonCriticalExtensions_11;
static int ett_rrc_T_v770NonCriticalExtensions_28;
static int ett_rrc_T_nonCriticalExtensions_175;
static int ett_rrc_T_criticalExtensions_136;
static int ett_rrc_T_r7_11;
static int ett_rrc_T_v780NonCriticalExtensions_09;
static int ett_rrc_T_v7d0NonCriticalExtensions_13;
static int ett_rrc_T_v7f0NonCriticalExtensions_14;
static int ett_rrc_T_v7g0NonCriticalExtensions_15;
static int ett_rrc_T_nonCriticalExtensions_176;
static int ett_rrc_T_criticalExtensions_137;
static int ett_rrc_T_r8_11;
static int ett_rrc_T_v7d0NonCriticalExtensions_14;
static int ett_rrc_T_v7f0NonCriticalExtensions_15;
static int ett_rrc_T_v890NonCriticalExtensions_09;
static int ett_rrc_T_v7g0NonCriticalExtensions_16;
static int ett_rrc_T_v8a0NonCriticalExtensions_09;
static int ett_rrc_T_nonCriticalExtensions_177;
static int ett_rrc_T_criticalExtensions_138;
static int ett_rrc_T_r9_10;
static int ett_rrc_T_v950NonCriticalExtensions_08;
static int ett_rrc_T_v9c0NonCriticalExtensions_10;
static int ett_rrc_T_nonCriticalExtensions_178;
static int ett_rrc_T_criticalExtensions_139;
static int ett_rrc_T_r10_10;
static int ett_rrc_T_v9c0NonCriticalExtensions_11;
static int ett_rrc_T_vb50NonCriticalExtensions_19;
static int ett_rrc_T_nonCriticalExtensions_179;
static int ett_rrc_T_criticalExtensions_140;
static int ett_rrc_T_r11_11;
static int ett_rrc_T_nonCriticalExtensions_180;
static int ett_rrc_T_criticalExtensions_141;
static int ett_rrc_T_r12_10;
static int ett_rrc_T_nonCriticalExtensions_181;
static int ett_rrc_T_criticalExtensions_142;
static int ett_rrc_T_r13_08;
static int ett_rrc_T_nonCriticalExtensions_182;
static int ett_rrc_T_criticalExtensions_143;
static int ett_rrc_TransportChannelReconfiguration_r3_IEs;
static int ett_rrc_T_dummy_11;
static int ett_rrc_T_fdd_40;
static int ett_rrc_T_modeSpecificPhysChInfo_12;
static int ett_rrc_T_fdd_41;
static int ett_rrc_TransportChannelReconfiguration_v3a0ext;
static int ett_rrc_TransportChannelReconfiguration_v4b0ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_v590ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_r4_IEs;
static int ett_rrc_T_dummy_12;
static int ett_rrc_T_fdd_42;
static int ett_rrc_T_modeSpecificPhysChInfo_13;
static int ett_rrc_T_fdd_43;
static int ett_rrc_TransportChannelReconfiguration_r5_IEs;
static int ett_rrc_T_dummy_13;
static int ett_rrc_T_fdd_44;
static int ett_rrc_T_modeSpecificPhysChInfo_14;
static int ett_rrc_T_fdd_45;
static int ett_rrc_TransportChannelReconfiguration_v690ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_r6_IEs;
static int ett_rrc_TransportChannelReconfiguration_v6b0ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_r7_IEs;
static int ett_rrc_TransportChannelReconfiguration_v770ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_v780ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_v7d0ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_v7f0ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_v7g0ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_r8_IEs;
static int ett_rrc_TransportChannelReconfiguration_v890ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_v8a0ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_r9_IEs;
static int ett_rrc_TransportChannelReconfiguration_v950ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_v9c0ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_r10_IEs;
static int ett_rrc_TransportChannelReconfiguration_vb50ext_IEs;
static int ett_rrc_TransportChannelReconfiguration_r11_IEs;
static int ett_rrc_TransportChannelReconfiguration_r12_IEs;
static int ett_rrc_TransportChannelReconfiguration_r13_IEs;
static int ett_rrc_TransportChannelReconfigurationComplete;
static int ett_rrc_T_laterNonCriticalExtensions_52;
static int ett_rrc_T_v770NonCriticalExtensions_29;
static int ett_rrc_T_nonCriticalExtensions_183;
static int ett_rrc_TransportChannelReconfigurationComplete_v770ext_IEs;
static int ett_rrc_TransportChannelReconfigurationFailure;
static int ett_rrc_T_laterNonCriticalExtensions_53;
static int ett_rrc_T_nonCriticalExtensions_184;
static int ett_rrc_TransportFormatCombinationControl;
static int ett_rrc_T_modeSpecificInfo_16;
static int ett_rrc_T_tdd_10;
static int ett_rrc_T_laterNonCriticalExtensions_54;
static int ett_rrc_T_v820NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_185;
static int ett_rrc_TransportFormatCombinationControl_v820ext_IEs;
static int ett_rrc_TransportFormatCombinationControlFailure;
static int ett_rrc_T_laterNonCriticalExtensions_55;
static int ett_rrc_T_nonCriticalExtensions_186;
static int ett_rrc_UECapabilityEnquiry;
static int ett_rrc_T_r3_25;
static int ett_rrc_T_laterNonCriticalExtensions_56;
static int ett_rrc_T_v4b0NonCriticalExtensions_14;
static int ett_rrc_T_v590NonCriticalExtensions_26;
static int ett_rrc_T_v770NonCriticalExtensions_30;
static int ett_rrc_T_v860NonCriticalExtensions_18;
static int ett_rrc_T_vaj0NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_187;
static int ett_rrc_T_later_than_r3_22;
static int ett_rrc_T_criticalExtensions_144;
static int ett_rrc_UECapabilityEnquiry_r3_IEs;
static int ett_rrc_UECapabilityEnquiry_v4b0ext_IEs;
static int ett_rrc_UECapabilityEnquiry_v590ext_IEs;
static int ett_rrc_UECapabilityEnquiry_v770ext_IEs;
static int ett_rrc_UECapabilityEnquiry_v860ext_IEs;
static int ett_rrc_UECapabilityEnquiry_vaj0ext_IEs;
static int ett_rrc_UECapabilityInformation;
static int ett_rrc_T_v370NonCriticalExtensions_01;
static int ett_rrc_T_v380NonCriticalExtensions_01;
static int ett_rrc_T_v3a0NonCriticalExtensions_10;
static int ett_rrc_T_laterNonCriticalExtensions_57;
static int ett_rrc_T_v4b0NonCriticalExtensions_15;
static int ett_rrc_T_v590NonCriticalExtensions_27;
static int ett_rrc_T_v5c0NonCriticalExtensions_01;
static int ett_rrc_T_v690NonCriticalExtensions_39;
static int ett_rrc_T_nonCriticalExtensions_188;
static int ett_rrc_UECapabilityInformation_v370ext;
static int ett_rrc_UECapabilityInformation_v380ext_IEs;
static int ett_rrc_UECapabilityInformation_v3a0ext_IEs;
static int ett_rrc_UECapabilityInformation_r3_add_ext_IEs;
static int ett_rrc_T_v680NonCriticalExtensions_01;
static int ett_rrc_T_v7e0NonCriticalExtensions_03;
static int ett_rrc_T_v7f0NonCriticalExtensions_16;
static int ett_rrc_T_va40NonCriticalExtensions_14;
static int ett_rrc_T_nonCriticalExtensions_189;
static int ett_rrc_UECapabilityInformation_v4b0ext;
static int ett_rrc_UECapabilityInformation_v590ext;
static int ett_rrc_UECapabilityInformation_v5c0ext;
static int ett_rrc_UECapabilityInformation_v650ext_IEs;
static int ett_rrc_UECapabilityInformation_v680ext_IEs;
static int ett_rrc_UECapabilityInformation_v690ext_IEs;
static int ett_rrc_UECapabilityInformation_v7e0ext_IEs;
static int ett_rrc_UECapabilityInformation_v7f0ext_IEs;
static int ett_rrc_UECapabilityInformation_va40ext_IEs;
static int ett_rrc_UECapabilityInformationConfirm;
static int ett_rrc_T_r3_26;
static int ett_rrc_T_laterNonCriticalExtensions_58;
static int ett_rrc_T_v770NonCriticalExtensions_31;
static int ett_rrc_T_nonCriticalExtensions_190;
static int ett_rrc_T_later_than_r3_23;
static int ett_rrc_T_criticalExtensions_145;
static int ett_rrc_UECapabilityInformationConfirm_r3_IEs;
static int ett_rrc_UECapabilityInformationConfirm_v770ext_IEs;
static int ett_rrc_UplinkDirectTransfer;
static int ett_rrc_T_laterNonCriticalExtensions_59;
static int ett_rrc_T_v690NonCriticalExtensions_40;
static int ett_rrc_T_v7g0NonCriticalExtensions_17;
static int ett_rrc_T_vb50NonCriticalExtensions_20;
static int ett_rrc_T_vc50NonCriticalExtensions_07;
static int ett_rrc_T_nonCriticalExtensions_191;
static int ett_rrc_UplinkDirectTransfer_v690ext_IEs;
static int ett_rrc_UplinkDirectTransfer_v7g0ext_IEs;
static int ett_rrc_UplinkDirectTransfer_vb50ext_IEs;
static int ett_rrc_UplinkDirectTransfer_vc50ext_IEs;
static int ett_rrc_UplinkPhysicalChannelControl;
static int ett_rrc_T_r3_27;
static int ett_rrc_T_laterNonCriticalExtensions_60;
static int ett_rrc_T_v4b0NonCriticalExtensions_16;
static int ett_rrc_T_noncriticalExtensions;
static int ett_rrc_T_later_than_r3_24;
static int ett_rrc_T_criticalExtensions_146;
static int ett_rrc_T_r4_13;
static int ett_rrc_T_v4d0NonCriticalExtensions_13;
static int ett_rrc_T_v690NonCriticalExtensions_41;
static int ett_rrc_T_nonCriticalExtensions_192;
static int ett_rrc_T_criticalExtensions_147;
static int ett_rrc_T_r5_11;
static int ett_rrc_T_v690NonCriticalExtensions_42;
static int ett_rrc_T_v6a0NonCriticalExtensions_01;
static int ett_rrc_T_nonCriticalExtensions_193;
static int ett_rrc_T_criticalExtensions_148;
static int ett_rrc_T_r7_12;
static int ett_rrc_T_nonCriticalExtensions_194;
static int ett_rrc_T_criticalExtensions_149;
static int ett_rrc_UplinkPhysicalChannelControl_r3_IEs;
static int ett_rrc_UplinkPhysicalChannelControl_v4b0ext_IEs;
static int ett_rrc_UplinkPhysicalChannelControl_r4_IEs;
static int ett_rrc_T_tddOption;
static int ett_rrc_T_tdd384_09;
static int ett_rrc_T_tdd128_09;
static int ett_rrc_UplinkPhysicalChannelControl_r5_IEs;
static int ett_rrc_T_tddOption_01;
static int ett_rrc_T_tdd384_10;
static int ett_rrc_T_tdd128_10;
static int ett_rrc_UplinkPhysicalChannelControl_v690ext_IEs;
static int ett_rrc_UplinkPhysicalChannelControl_v6a0ext_IEs;
static int ett_rrc_UplinkPhysicalChannelControl_r7_IEs;
static int ett_rrc_T_tddOption_02;
static int ett_rrc_T_tdd384_11;
static int ett_rrc_T_tdd768_06;
static int ett_rrc_T_tdd128_11;
static int ett_rrc_URAUpdate;
static int ett_rrc_T_laterNonCriticalExtensions_61;
static int ett_rrc_T_v770NonCriticalExtensions_32;
static int ett_rrc_T_v860NonCriticalExtensions_19;
static int ett_rrc_T_va40NonCriticalExtensions_15;
static int ett_rrc_T_nonCriticalExtensions_195;
static int ett_rrc_URAUpdate_r3_add_ext_IEs;
static int ett_rrc_T_nonCriticalExtensions_196;
static int ett_rrc_UraUpdate_v770ext_IEs;
static int ett_rrc_URAUpdate_v7e0ext_IEs;
static int ett_rrc_URAUpdate_v860ext_IEs;
static int ett_rrc_URAUpdate_va40ext_IEs;
static int ett_rrc_URAUpdateConfirm;
static int ett_rrc_T_r3_28;
static int ett_rrc_T_laterNonCriticalExtensions_62;
static int ett_rrc_T_v690NonCriticalExtensions_43;
static int ett_rrc_T_nonCriticalExtensions_197;
static int ett_rrc_T_later_than_r3_25;
static int ett_rrc_T_criticalExtensions_150;
static int ett_rrc_T_r5_12;
static int ett_rrc_T_v690NonCriticalExtensions_44;
static int ett_rrc_T_nonCriticalExtensions_198;
static int ett_rrc_T_criticalExtensions_151;
static int ett_rrc_T_r7_13;
static int ett_rrc_T_v860NonCriticalExtensions_20;
static int ett_rrc_T_nonCriticalExtensions_199;
static int ett_rrc_T_criticalExtensions_152;
static int ett_rrc_URAUpdateConfirm_r3_IEs;
static int ett_rrc_URAUpdateConfirm_r5_IEs;
static int ett_rrc_URAUpdateConfirm_v690ext_IEs;
static int ett_rrc_URAUpdateConfirm_r7_IEs;
static int ett_rrc_URAUpdateConfirm_v860ext_IEs;
static int ett_rrc_URAUpdateConfirm_CCCH;
static int ett_rrc_T_r3_29;
static int ett_rrc_T_laterNonCriticalExtensions_63;
static int ett_rrc_T_v690NonCriticalExtensions_45;
static int ett_rrc_T_v860NonCriticalExtensions_21;
static int ett_rrc_T_nonCriticalExtensions_200;
static int ett_rrc_T_later_than_r3_26;
static int ett_rrc_T_criticalExtensions_153;
static int ett_rrc_URAUpdateConfirm_CCCH_r3_IEs;
static int ett_rrc_UTRANMobilityInformation;
static int ett_rrc_T_r3_30;
static int ett_rrc_T_v3a0NonCriticalExtensions_11;
static int ett_rrc_T_laterNonCriticalExtensions_64;
static int ett_rrc_T_v690NonCriticalExtensions_46;
static int ett_rrc_T_v860NonCriticalExtentions;
static int ett_rrc_T_nonCriticalExtensions_201;
static int ett_rrc_T_later_than_r3_27;
static int ett_rrc_T_criticalExtensions_154;
static int ett_rrc_T_r5_13;
static int ett_rrc_T_v690NonCriticalExtensions_47;
static int ett_rrc_T_v860NonCriticalExtentions_01;
static int ett_rrc_T_nonCriticalExtensions_202;
static int ett_rrc_T_criticalExtensions_155;
static int ett_rrc_T_r7_14;
static int ett_rrc_T_v860NonCriticalExtensions_22;
static int ett_rrc_T_vb50NonCriticalExtentions;
static int ett_rrc_T_nonCriticalExtensions_203;
static int ett_rrc_T_criticalExtensions_156;
static int ett_rrc_T_r11_12;
static int ett_rrc_T_nonCriticalExtensions_204;
static int ett_rrc_T_criticalExtensions_157;
static int ett_rrc_T_r12_11;
static int ett_rrc_T_nonCriticalExtensions_205;
static int ett_rrc_T_criticalExtensions_158;
static int ett_rrc_T_r13_09;
static int ett_rrc_T_nonCriticalExtensions_206;
static int ett_rrc_T_criticalExtensions_159;
static int ett_rrc_UTRANMobilityInformation_r3_IEs;
static int ett_rrc_T_nonCriticalExtensions_207;
static int ett_rrc_UTRANMobilityInformation_v3a0ext_IEs;
static int ett_rrc_UTRANMobilityInformation_r5_IEs;
static int ett_rrc_UtranMobilityInformation_v690ext_IEs;
static int ett_rrc_UTRANMobilityInformation_r7_IEs;
static int ett_rrc_UTRANMobilityInformation_v860ext1_IEs;
static int ett_rrc_UTRANMobilityInformation_v860ext2_IEs;
static int ett_rrc_UTRANMobilityInformation_vb50ext_IEs;
static int ett_rrc_UTRANMobilityInformation_r11_IEs;
static int ett_rrc_UTRANMobilityInformation_r12_IEs;
static int ett_rrc_UTRANMobilityInformation_r13_IEs;
static int ett_rrc_UTRANMobilityInformationConfirm;
static int ett_rrc_T_laterNonCriticalExtensions_65;
static int ett_rrc_T_v770NonCriticalExtension_01;
static int ett_rrc_T_va40NonCriticalExtensions_16;
static int ett_rrc_T_nonCriticalExtensions_208;
static int ett_rrc_UTRANMobilityInformationConfirm_v770ext_IEs;
static int ett_rrc_UTRANMobilityInformationConfirm_va40ext_IEs;
static int ett_rrc_UTRANMobilityInformationFailure;
static int ett_rrc_T_laterNonCriticalExtensions_66;
static int ett_rrc_T_nonCriticalExtensions_209;
static int ett_rrc_MBMSAccessInformation;
static int ett_rrc_T_nonCriticalExtensions_210;
static int ett_rrc_MBMSCommonPTMRBInformation;
static int ett_rrc_T_v770NonCriticalExtensions_33;
static int ett_rrc_T_v780NonCriticalExtensions_10;
static int ett_rrc_T_v860NonCriticalExtensions_23;
static int ett_rrc_T_nonCriticalExtensions_211;
static int ett_rrc_MBMSCommonPTMRBInformation_v770ext_IEs;
static int ett_rrc_MBMSCommonPTMRBInformation_v780ext_IEs;
static int ett_rrc_MBMSCommonPTMRBInformation_v860ext_IEs;
static int ett_rrc_MBMSCurrentCellPTMRBInformation;
static int ett_rrc_T_v770NonCriticalExtensions_34;
static int ett_rrc_T_nonCriticalExtensions_212;
static int ett_rrc_MBMSCurrentCellPTMRBInfo_v770ext_IEs;
static int ett_rrc_MBMSGeneralInformation;
static int ett_rrc_T_v6b0NonCriticalExtensions_12;
static int ett_rrc_T_v770NonCriticalExtensions_35;
static int ett_rrc_T_v860NonCriticalExtensions_24;
static int ett_rrc_T_v890NoncriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_213;
static int ett_rrc_MBMSGeneralInformation_v6b0ext_IEs;
static int ett_rrc_MBMSGeneralInformation_v770ext_IEs;
static int ett_rrc_MBMSGeneralInformation_v860ext_IEs;
static int ett_rrc_MBMSGeneralInformation_v890ext_IEs;
static int ett_rrc_MBMSModificationRequest;
static int ett_rrc_T_v6b0NonCriticalExtensions_13;
static int ett_rrc_T_v6f0NonCriticalExtensions_02;
static int ett_rrc_T_nonCriticalExtensions_214;
static int ett_rrc_MBMSModificationRequest_v6b0ext_IEs;
static int ett_rrc_MBMSModificationRequest_v6f0ext_IEs;
static int ett_rrc_MBMSModifiedServicesInformation;
static int ett_rrc_T_v770NonCriticalExtensions_36;
static int ett_rrc_T_v7c0NonCriticalExtensions;
static int ett_rrc_T_nonCriticalExtensions_215;
static int ett_rrc_MBMSModifiedServicesInformation_v770ext_IEs;
static int ett_rrc_MBMSModifiedServicesInformation_v7c0ext_IEs;
static int ett_rrc_MBMSNeighbouringCellPTMRBInformation;
static int ett_rrc_T_v770NonCriticalExtensions_37;
static int ett_rrc_T_nonCriticalExtensions_216;
static int ett_rrc_MBMSNeighbouringCellPTMRBInformation_v770ext_IEs;
static int ett_rrc_MBMSSchedulingInformation;
static int ett_rrc_T_nonCriticalExtensions_217;
static int ett_rrc_MBMSUnmodifiedServicesInformation;
static int ett_rrc_T_v770NonCriticalExtensions_38;
static int ett_rrc_T_nonCriticalExtensions_218;
static int ett_rrc_MBMSUnmodifiedServicesInformation_v770ext_IEs;
static int ett_rrc_System_Information_Container;
static int ett_rrc_T_vb50NonCriticalExtensions_21;
static int ett_rrc_T_vc50NonCriticalExtensions_08;
static int ett_rrc_T_nonCriticalExtensions_219;
static int ett_rrc_System_Information_Container_vb50ext_IEs;
static int ett_rrc_System_Information_Container_vc50ext_IEs;
static int ett_rrc_LoggingMeasurementConfiguration;
static int ett_rrc_T_criticalExtensions_160;
static int ett_rrc_T_r10_11;
static int ett_rrc_T_nonCriticalExtensions_220;
static int ett_rrc_T_criticalExtensions_161;
static int ett_rrc_T_r11_13;
static int ett_rrc_T_nonCriticalExtensions_221;
static int ett_rrc_T_criticalExtensions_162;
static int ett_rrc_LoggingMeasurementConfiguration_r10_IEs;
static int ett_rrc_LoggingMeasurementConfiguration_r11_IEs;
static int ett_rrc_UEInformationResponse;
static int ett_rrc_T_vb50NonCriticalExtensions_22;
static int ett_rrc_T_vbb0NonCriticalExtensions;
static int ett_rrc_T_vc50NonCriticalExtensions_09;
static int ett_rrc_T_nonCriticalExtensions_222;
static int ett_rrc_UEInformationResponse_vb50ext_IEs;
static int ett_rrc_UEInformationResponse_vbb0ext_IEs;
static int ett_rrc_UEInformationResponse_vc50ext_IEs;
static int ett_rrc_UEInformationRequest;
static int ett_rrc_T_criticalExtensions_163;
static int ett_rrc_T_r10_12;
static int ett_rrc_T_nonCriticalExtensions_223;
static int ett_rrc_T_criticalExtensions_164;
static int ett_rrc_T_r11_14;
static int ett_rrc_T_nonCriticalExtensions_224;
static int ett_rrc_T_criticalExtensions_165;
static int ett_rrc_UEInformationRequest_r10_IEs;
static int ett_rrc_UEInformationRequest_r11_IEs;
static int ett_rrc_CN_DomainInformation;
static int ett_rrc_CN_DomainInformationFull;
static int ett_rrc_CN_DomainInformationList;
static int ett_rrc_CN_DomainInformationListFull;
static int ett_rrc_CN_DomainSysInfo;
static int ett_rrc_T_cn_Type;
static int ett_rrc_CN_DomainSysInfoList;
static int ett_rrc_CN_InformationInfo;
static int ett_rrc_CN_InformationInfo_r6;
static int ett_rrc_CN_InformationInfoFull;
static int ett_rrc_DomainSpecificEAB_Parameters;
static int ett_rrc_EAB_AccessClassBarredList;
static int ett_rrc_EAB_Configuration;
static int ett_rrc_EAB_Parameters;
static int ett_rrc_EAB_ParametersPerPLMN;
static int ett_rrc_EAB_ParametersPerPLMN_List;
static int ett_rrc_Ec_N0forANR;
static int ett_rrc_Gsm_map_IDNNS;
static int ett_rrc_T_routingbasis;
static int ett_rrc_T_localPTMSI;
static int ett_rrc_T_tMSIofsamePLMN;
static int ett_rrc_T_tMSIofdifferentPLMN;
static int ett_rrc_T_iMSIresponsetopaging;
static int ett_rrc_T_iMSIcauseUEinitiatedEvent;
static int ett_rrc_T_iMEI;
static int ett_rrc_T_spare2_01;
static int ett_rrc_T_spare1_01;
static int ett_rrc_IMEI;
static int ett_rrc_IMSI_GSM_MAP;
static int ett_rrc_IntraDomainNasNodeSelector;
static int ett_rrc_T_version;
static int ett_rrc_T_release99;
static int ett_rrc_T_cn_Type_01;
static int ett_rrc_T_later;
static int ett_rrc_LAI;
static int ett_rrc_LocationRegistrationAccessClassBarredList;
static int ett_rrc_LocationRegistrationParameters;
static int ett_rrc_MCC;
static int ett_rrc_MNC;
static int ett_rrc_MultiplePLMN_List_r6;
static int ett_rrc_SEQUENCE_SIZE_1_5_OF_PLMN_IdentityWithOptionalMCC_r6;
static int ett_rrc_PagingPermissionWithAccessControlForSharedNetwork;
static int ett_rrc_PagingPermissionWithAccessControlList;
static int ett_rrc_PagingPermissionWithAccessControlParameters;
static int ett_rrc_PLMN_Identity;
static int ett_rrc_PLMN_IdentityWithOptionalMCC_r6;
static int ett_rrc_PLMN_Type;
static int ett_rrc_T_gsm_MAP;
static int ett_rrc_T_ansi_41;
static int ett_rrc_T_gsm_MAP_and_ANSI_41;
static int ett_rrc_RAB_Identity;
static int ett_rrc_RAI;
static int ett_rrc_AccessClassBarredList;
static int ett_rrc_CellAccessRestriction;
static int ett_rrc_CellAccessRestriction_v870ext;
static int ett_rrc_CellBarred;
static int ett_rrc_T_barred;
static int ett_rrc_CellIdentity_PerRL_List;
static int ett_rrc_CellIDListItem;
static int ett_rrc_CellSelectReselectInfoSIB_3_4;
static int ett_rrc_T_cellSelectQualityMeasure;
static int ett_rrc_T_cpich_Ec_N0;
static int ett_rrc_T_modeSpecificInfo_17;
static int ett_rrc_T_fdd_46;
static int ett_rrc_T_tdd_11;
static int ett_rrc_CSG_DedicatedFrequencyInfoList;
static int ett_rrc_CSG_PSCSplitInfo;
static int ett_rrc_DedicatedWLANOffloadInformation;
static int ett_rrc_T_configurationInfo;
static int ett_rrc_T_newConfiguration;
static int ett_rrc_DomainSpecificAccessRestrictionForSharedNetwork_v670ext;
static int ett_rrc_DomainSpecificAccessRestrictionList_v670ext;
static int ett_rrc_DomainSpecificAccessRestrictionParam_v670ext;
static int ett_rrc_DomainSpecificAccessRestriction_v670ext;
static int ett_rrc_T_restriction;
static int ett_rrc_Mapping;
static int ett_rrc_Mapping_LCR_r4;
static int ett_rrc_MappingFunctionParameter;
static int ett_rrc_MappingFunctionParameterList;
static int ett_rrc_MappingInfo;
static int ett_rrc_DedicatedPriorityInformation;
static int ett_rrc_T_action;
static int ett_rrc_T_configureDedicatedPriorities;
static int ett_rrc_DedicatedPriorityInformation_r11;
static int ett_rrc_T_action_01;
static int ett_rrc_T_configureDedicatedPriorities_01;
static int ett_rrc_DedicatedPriorityInformation_r13;
static int ett_rrc_T_action_02;
static int ett_rrc_T_configureDedicatedPriorities_02;
static int ett_rrc_PriorityLevel;
static int ett_rrc_T_radioAccessTechnology;
static int ett_rrc_T_utraFDD;
static int ett_rrc_T_utraFDD_item;
static int ett_rrc_T_utraTDD;
static int ett_rrc_T_utraTDD_item;
static int ett_rrc_T_eutra;
static int ett_rrc_T_eutra_item;
static int ett_rrc_T_gsm_01;
static int ett_rrc_PriorityLevel_r11;
static int ett_rrc_T_radioAccessTechnology_01;
static int ett_rrc_T_utraFDD_01;
static int ett_rrc_T_utraFDD_item_01;
static int ett_rrc_T_utraTDD_01;
static int ett_rrc_T_utraTDD_item_01;
static int ett_rrc_SEQUENCE_SIZE_1_maxNumEUTRAFreqs_OF_EARFCNRange;
static int ett_rrc_T_gsm_02;
static int ett_rrc_PriorityLevel_r13;
static int ett_rrc_T_radioAccessTechnology_02;
static int ett_rrc_T_utraFDD_02;
static int ett_rrc_T_utraFDD_item_02;
static int ett_rrc_T_utraTDD_02;
static int ett_rrc_T_utraTDD_item_02;
static int ett_rrc_T_gsm_03;
static int ett_rrc_PriorityLevelList;
static int ett_rrc_PriorityLevelList_r11;
static int ett_rrc_PriorityLevelList_r13;
static int ett_rrc_RAT_FDD_Info;
static int ett_rrc_RAT_FDD_InfoList;
static int ett_rrc_RAT_TDD_Info;
static int ett_rrc_RAT_TDD_InfoList;
static int ett_rrc_URA_IdentityList;
static int ett_rrc_BackoffControlParams;
static int ett_rrc_CapabilityUpdateRequirement;
static int ett_rrc_CapabilityUpdateRequirement_r4_ext;
static int ett_rrc_CapabilityUpdateRequirement_r4;
static int ett_rrc_CapabilityUpdateRequirement_r5;
static int ett_rrc_CapabilityUpdateRequirement_v770ext;
static int ett_rrc_CapabilityUpdateRequirement_r7;
static int ett_rrc_CapabilityUpdateRequirement_v860ext;
static int ett_rrc_CapabilityUpdateRequirement_r8;
static int ett_rrc_CapabilityUpdateRequirement_vaj0ext;
static int ett_rrc_CapabilityUpdateRequirement_r12;
static int ett_rrc_CipheringModeCommand;
static int ett_rrc_CipheringModeCommand_r7;
static int ett_rrc_CipheringModeInfo;
static int ett_rrc_CipheringModeInfo_r7;
static int ett_rrc_CN_PagedUE_Identity;
static int ett_rrc_CompressedModeMeasCapability;
static int ett_rrc_CompressedModeMeasCapability_LCR_r4;
static int ett_rrc_CompressedModeMeasCapability_v860ext;
static int ett_rrc_CompressedModeMeasCapability_v920ext;
static int ett_rrc_CompressedModeMeasCapability_va40ext;
static int ett_rrc_CompressedModeMeasCapabEUTRA;
static int ett_rrc_CompressedModeMeasCapabEUTRAExt;
static int ett_rrc_CompressedModeMeasCapabEUTRAExt2;
static int ett_rrc_CompressedModeMeasCapabEUTRAList;
static int ett_rrc_CompressedModeMeasCapabEUTRAList2;
static int ett_rrc_CompressedModeMeasCapabEUTRAList3;
static int ett_rrc_CompressedModeMeasCapabFDDList;
static int ett_rrc_CompressedModeMeasCapabFDDList2;
static int ett_rrc_CompressedModeMeasCapabFDDList3;
static int ett_rrc_CompressedModeMeasCapabFDDList_ext;
static int ett_rrc_CompressedModeMeasCapabFDD;
static int ett_rrc_CompressedModeMeasCapabFDD2;
static int ett_rrc_CompressedModeMeasCapabFDD3;
static int ett_rrc_CompressedModeMeasCapabFDD_ext;
static int ett_rrc_CompressedModeMeasCapabTDDList;
static int ett_rrc_CompressedModeMeasCapabTDD;
static int ett_rrc_CompressedModeMeasCapabGSMList;
static int ett_rrc_CompressedModeMeasCapabGSM;
static int ett_rrc_CompressedModeMeasCapabMC;
static int ett_rrc_CPCH_Parameters;
static int ett_rrc_CSG_ProximityIndicationCapability;
static int ett_rrc_DL_InformationPerSecondaryRL_List;
static int ett_rrc_DL_InformationPerSecondaryRL_List_r12;
static int ett_rrc_DL_InformationPerSecondaryRL_List_r13;
static int ett_rrc_DL_InformationPerSecondaryRL;
static int ett_rrc_T_e_RGCH_Info;
static int ett_rrc_DL_InformationPerSecondaryRL_r12;
static int ett_rrc_T_e_RGCH_Info_01;
static int ett_rrc_DL_InformationPerSecondaryRL_r13;
static int ett_rrc_T_e_RGCH_Info_02;
static int ett_rrc_DL_PhysChCapabilityFDD;
static int ett_rrc_DL_PhysChCapabilityFDD_v380ext;
static int ett_rrc_DL_PhysChCapabilityFDD_v770ext;
static int ett_rrc_DL_PhysChCapabilityFDD_v860ext;
static int ett_rrc_DL_PhysChCapabilityFDD_v920ext;
static int ett_rrc_DL_PhysChCapabilityFDD_va40ext;
static int ett_rrc_DL_PhysChCapabilityFDD_vb50ext;
static int ett_rrc_DL_PhysChCapabilityFDD_vb80ext;
static int ett_rrc_DL_PhysChCapabilityFDD_vc50ext;
static int ett_rrc_DL_PhysChCapabilityFDD_vd20ext;
static int ett_rrc_DL_PhysChCapabilityFDD_ve30ext;
static int ett_rrc_DL_PhysChCapabilityFDD_vf10ext;
static int ett_rrc_DL_PhysChCapabilityTDD;
static int ett_rrc_DL_PhysChCapabilityTDD_LCR_r4;
static int ett_rrc_DL_PhysChCapabilityTDD_128_v770ext;
static int ett_rrc_DL_PhysChCapabilityTDD_128_v860ext;
static int ett_rrc_DL_PhysChCapabilityInfoTDD_128_va40ext;
static int ett_rrc_DL_PhysChCapabilityInfoTDD_128_vc50ext;
static int ett_rrc_DL_PhysChCapabilityTDD_768;
static int ett_rrc_T_tdd768_hspdsch;
static int ett_rrc_DL_PhysChCapabilityInfoTDD_768;
static int ett_rrc_DL_TransChCapability;
static int ett_rrc_DRAC_SysInfo;
static int ett_rrc_DRAC_SysInfoList;
static int ett_rrc_DynamicActivationTime;
static int ett_rrc_EUTRAbandSpecificCapUpdateReqList;
static int ett_rrc_FailureCauseWithProtErr;
static int ett_rrc_FailureCauseWithProtErrTrId;
static int ett_rrc_FrequencyBandsIndicatorSupport;
static int ett_rrc_T_modeSpecificInfo_18;
static int ett_rrc_T_fdd_47;
static int ett_rrc_T_tdd_12;
static int ett_rrc_FrequencyBandsIndicatorTDD128;
static int ett_rrc_FrequencyBandsIndicatorSupportTDD128;
static int ett_rrc_FrequencyBandsRedirectionFDD;
static int ett_rrc_FrequencyBandsIndicatorFDD;
static int ett_rrc_GroupIdentityWithReleaseInformation;
static int ett_rrc_GroupReleaseInformation;
static int ett_rrc_GSM_Measurements;
static int ett_rrc_MultiflowCapabBandCombination;
static int ett_rrc_MultiflowCapabBandCombList;
static int ett_rrc_MultiflowCapability;
static int ett_rrc_MultiflowPerBandCapability;
static int ett_rrc_MultiflowNonContiguousCapability;
static int ett_rrc_IdleIntervalMeasCapabEUTRA;
static int ett_rrc_IdleIntervalMeasCapabEUTRAExtension;
static int ett_rrc_IdleIntervalMeasCapabEUTRAList;
static int ett_rrc_IdleIntervalMeasCapabEUTRAExtensionList;
static int ett_rrc_IMSI_and_ESN_DS_41;
static int ett_rrc_InitialPriorityDelayList;
static int ett_rrc_InitialUE_Identity;
static int ett_rrc_IntegrityCheckInfo;
static int ett_rrc_IntegrityProtActivationInfo;
static int ett_rrc_IntegrityProtectionModeCommand;
static int ett_rrc_T_startIntegrityProtection;
static int ett_rrc_T_modify;
static int ett_rrc_IntegrityProtectionModeInfo;
static int ett_rrc_IntegrityProtectionModeInfo_r7;
static int ett_rrc_MeasurementCapability;
static int ett_rrc_MeasurementCapabilityExt;
static int ett_rrc_MeasurementCapabilityExt2;
static int ett_rrc_MeasurementCapabilityExt3;
static int ett_rrc_MeasurementCapabilityExt4;
static int ett_rrc_MeasurementCapabilityExt5;
static int ett_rrc_MeasurementCapabilityExt6;
static int ett_rrc_MeasurementCapability_r4_ext;
static int ett_rrc_MeasurementCapability_v860ext;
static int ett_rrc_MeasurementCapability_v920ext;
static int ett_rrc_MeasurementCapability_va40ext;
static int ett_rrc_MeasurementCapability_vb50ext;
static int ett_rrc_MeasurementCapabilityTDD;
static int ett_rrc_MeasurementCapabilityTDD_vb50ext;
static int ett_rrc_MeasurementCapability_vb70ext;
static int ett_rrc_MeasurementCapability_vc50ext;
static int ett_rrc_MeasurementCapability_ve30ext;
static int ett_rrc_MeasurementCapability_vf20ext;
static int ett_rrc_NonContiguousMultiCellCombinationList;
static int ett_rrc_NonContiguousMultiCell;
static int ett_rrc_MultiRAT_Capability;
static int ett_rrc_MultiModeRAT_Capability_v590ext;
static int ett_rrc_MultiModeRAT_Capability_v680ext;
static int ett_rrc_MultiModeRAT_Capability_v770ext;
static int ett_rrc_MultiModeRAT_Capability_v860ext;
static int ett_rrc_MultiModeRAT_Capability_vae0ext;
static int ett_rrc_MultiModeRAT_Capability_vb50ext;
static int ett_rrc_MultiModeRAT_Capability_vc50ext;
static int ett_rrc_MultiModeRAT_Capability_vd20ext;
static int ett_rrc_NeighCellSI_AcquisitionCapability;
static int ett_rrc_NetworkAssistedGANSS_Supported_List;
static int ett_rrc_NetworkAssistedGANSS_Supported_List_item;
static int ett_rrc_NetworkAssistedGANSS_Supported_List_v860ext;
static int ett_rrc_NetworkAssistedGANSS_Supported_List_v860ext_item;
static int ett_rrc_P_TMSI_and_RAI_GSM_MAP;
static int ett_rrc_PagingRecord;
static int ett_rrc_T_cn_Identity;
static int ett_rrc_T_utran_Identity;
static int ett_rrc_T_cn_OriginatedPage_connectedMode_UE;
static int ett_rrc_PagingRecord2_r5;
static int ett_rrc_T_utran_SingleUE_Identity;
static int ett_rrc_T_cn_OriginatedPage_connectedMode_UE_01;
static int ett_rrc_SEQUENCE_SIZE_1_maxURNTI_Group_OF_GroupIdentityWithReleaseInformation;
static int ett_rrc_PagingRecordList;
static int ett_rrc_PagingRecord2List_r5;
static int ett_rrc_PDCP_Capability;
static int ett_rrc_T_supportForRfc2507;
static int ett_rrc_PDCP_Capability_r4_ext;
static int ett_rrc_T_supportForRfc3095;
static int ett_rrc_T_supported;
static int ett_rrc_PDCP_Capability_r5_ext;
static int ett_rrc_PDCP_Capability_r5_ext2;
static int ett_rrc_PDCP_Capability_v770ext;
static int ett_rrc_PhysicalChannelCapability;
static int ett_rrc_T_fddPhysChCapability;
static int ett_rrc_T_tddPhysChCapability;
static int ett_rrc_PhysicalChannelCapability_v770ext;
static int ett_rrc_T_fddPhysChCapability_01;
static int ett_rrc_T_tddPhysChCapability_384;
static int ett_rrc_T_tddPhysChCapability_768;
static int ett_rrc_T_tddPhysChCapability_128;
static int ett_rrc_PhysicalChannelCapability_v860ext;
static int ett_rrc_T_fddPhysChCapability_02;
static int ett_rrc_T_tddPhysChCapability_128_01;
static int ett_rrc_PhysicalChannelCapability_v920ext;
static int ett_rrc_T_fddPhysChCapability_03;
static int ett_rrc_PhysicalChannelCapability_va40ext;
static int ett_rrc_T_fddPhysChCapability_04;
static int ett_rrc_T_tddPhysChCapability_128_02;
static int ett_rrc_PhysicalChannelCapability_vb50ext;
static int ett_rrc_T_fddPhysChCapability_05;
static int ett_rrc_PhysicalChannelCapability_vb80ext;
static int ett_rrc_T_fddPhysChCapability_06;
static int ett_rrc_PhysicalChannelCapability_vc50ext;
static int ett_rrc_T_fddPhysChCapability_07;
static int ett_rrc_T_tddPhysChCapability_01;
static int ett_rrc_PhysicalChannelCapability_vd20ext;
static int ett_rrc_T_fddPhysChCapability_08;
static int ett_rrc_PhysicalChannelCapability_ve30ext;
static int ett_rrc_T_fddPhysChCapability_09;
static int ett_rrc_PhysicalChannelCapabilityInfo_v770ext;
static int ett_rrc_T_tddPhysChCapability_768_01;
static int ett_rrc_T_tddPhysChCapability_128_03;
static int ett_rrc_PhysicalChannelCapability_vf10ext;
static int ett_rrc_T_fddPhysChCapability_10;
static int ett_rrc_PhysicalChannelCapability_LCR_r4;
static int ett_rrc_T_tdd128_PhysChCapability;
static int ett_rrc_PhysicalChannelCapability_hspdsch_r5;
static int ett_rrc_T_fdd_hspdsch;
static int ett_rrc_T_supported_01;
static int ett_rrc_T_tdd384_hspdsch;
static int ett_rrc_T_tdd128_hspdsch;
static int ett_rrc_PNBSCH_Allocation_r4;
static int ett_rrc_Pre_RedirectionInfo;
static int ett_rrc_ProtocolErrorIndicatorWithMoreInfo;
static int ett_rrc_T_errorOccurred;
static int ett_rrc_ProtocolErrorMoreInformation;
static int ett_rrc_T_diagnosticsType;
static int ett_rrc_T_type1;
static int ett_rrc_RadioFrequencyBandTDDextList;
static int ett_rrc_Rb_timer_indicator;
static int ett_rrc_RedirectionInfo;
static int ett_rrc_RedirectionInfo_r6;
static int ett_rrc_RedirectionInfo_v860ext;
static int ett_rrc_RF_Capability;
static int ett_rrc_T_fddRF_Capability;
static int ett_rrc_T_tddRF_Capability;
static int ett_rrc_RF_Capability_r4_ext;
static int ett_rrc_T_tddRF_Capability_01;
static int ett_rrc_RF_Capability_v770ext;
static int ett_rrc_T_tdd768RF_Capability;
static int ett_rrc_RF_Capability_v860ext;
static int ett_rrc_RF_Capability_vaa0ext;
static int ett_rrc_RLC_Capability;
static int ett_rrc_RLC_Capability_r5_ext;
static int ett_rrc_RLC_Capability_v770ext;
static int ett_rrc_RLC_Capability_v920ext;
static int ett_rrc_RLC_Capability_va40ext;
static int ett_rrc_RLC_Capability_vb50ext;
static int ett_rrc_RRC_ConnectionReleaseInformation;
static int ett_rrc_T_release;
static int ett_rrc_RRC_MessageSequenceNumberList;
static int ett_rrc_RSR_VCC_Info;
static int ett_rrc_SecurityCapability;
static int ett_rrc_T_cipheringAlgorithmCap;
static int ett_rrc_T_integrityProtectionAlgorithmCap;
static int ett_rrc_SecondaryServingEDCHCell_Info;
static int ett_rrc_SecondaryEDCH_Info_Common;
static int ett_rrc_T_servingGrant;
static int ett_rrc_SecondaryEDCH_Info_Common_r12;
static int ett_rrc_T_servingGrant_01;
static int ett_rrc_SecondaryEDCH_Info_Common_r14;
static int ett_rrc_T_servingGrant_02;
static int ett_rrc_Serving_HSDSCH_CellInformation;
static int ett_rrc_Serving_HSDSCH_CellInformation_r7;
static int ett_rrc_Serving_HSDSCH_CellInformation_r8;
static int ett_rrc_Serving_HSDSCH_CellInformation_r9;
static int ett_rrc_Serving_HSDSCH_CellInformation_r11;
static int ett_rrc_Serving_HSDSCH_CellInformation_r12;
static int ett_rrc_SimultaneousSCCPCH_DPCH_Reception;
static int ett_rrc_T_supported_02;
static int ett_rrc_SR_VCC_Info;
static int ett_rrc_SR_VCC_SecurityRABInfo_v860ext;
static int ett_rrc_STARTList;
static int ett_rrc_STARTSingle;
static int ett_rrc_SystemSpecificCapUpdateReqList;
static int ett_rrc_SystemSpecificCapUpdateReqList_r5;
static int ett_rrc_SystemSpecificCapUpdateReqList_r8;
static int ett_rrc_TMSI_and_LAI_GSM_MAP;
static int ett_rrc_TransportChannelCapability;
static int ett_rrc_TurboSupport;
static int ett_rrc_U_RNTI;
static int ett_rrc_U_RNTI_Group;
static int ett_rrc_U_RNTI_Short;
static int ett_rrc_UE_AddPos_Supported_List;
static int ett_rrc_UE_AddPos_element;
static int ett_rrc_UE_BasedNetworkPerformanceMeasurementsParameters;
static int ett_rrc_UE_CapabilityContainer_IEs;
static int ett_rrc_T_v6b0NonCriticalExtensions_14;
static int ett_rrc_T_v6e0NonCriticalExtensions_02;
static int ett_rrc_T_v770NonCriticalExtensions_39;
static int ett_rrc_T_v790NonCriticalExtensions_01;
static int ett_rrc_T_v860NonCriticalExtensions_25;
static int ett_rrc_T_v880NonCriticalExtensions_01;
static int ett_rrc_T_v890NonCriticalExtensions_10;
static int ett_rrc_T_v920NonCriticalExtensions_03;
static int ett_rrc_T_v970NonCriticalExtensions_03;
static int ett_rrc_T_va40NonCriticalExtensions_17;
static int ett_rrc_T_va60NonCriticalExtensions;
static int ett_rrc_T_va80NonCriticalExtensions_01;
static int ett_rrc_UE_RadioAccessCapability_v6b0ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_v6e0ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_v770ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_v790ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_v860ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_v880ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_v890ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_v920ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_v970ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_v9c0ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_LaterNonCriticalExtensions;
static int ett_rrc_T_v9c0NonCriticalExtensions_12;
static int ett_rrc_T_vaa0NonCriticalExtensions_02;
static int ett_rrc_T_vb50NonCriticalExtensions_23;
static int ett_rrc_T_vb70NonCriticalExtensions_01;
static int ett_rrc_T_vae0NonCriticalExtensions;
static int ett_rrc_T_vb80NonCriticalExtensions;
static int ett_rrc_T_vc50NonCriticalExtensions_10;
static int ett_rrc_T_vd20NonCriticalExtensions_03;
static int ett_rrc_UE_RadioAccessCapability_va40ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_va60ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_va80ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_vaa0ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_vae0ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_vb50ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_vb70ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_vb80ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_vc50ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_vd20ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_ve30ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_vf10ext_IEs;
static int ett_rrc_UE_RadioAccessCapability_vf20ext_IEs;
static int ett_rrc_T_nonCriticalExtensions_225;
static int ett_rrc_UE_ConnTimersAndConstants;
static int ett_rrc_UE_ConnTimersAndConstants_v3a0ext;
static int ett_rrc_UE_ConnTimersAndConstants_r5;
static int ett_rrc_UE_ConnTimersAndConstants_v860ext;
static int ett_rrc_UE_ConnTimersAndConstants_r11;
static int ett_rrc_UE_GANSSPositioning_Capability;
static int ett_rrc_UE_GANSSPositioning_Capability_v860ext_IEs;
static int ett_rrc_UE_IdleTimersAndConstants;
static int ett_rrc_UE_HSPA_Identities_r6;
static int ett_rrc_UE_IdleTimersAndConstants_v3a0ext;
static int ett_rrc_UE_MultiModeRAT_Capability;
static int ett_rrc_UE_RadioAccessCapability;
static int ett_rrc_UE_RadioAccessCapabilityInfo;
static int ett_rrc_UE_RadioAccessCapability_v370ext;
static int ett_rrc_UE_RadioAccessCapability_v380ext;
static int ett_rrc_UE_RadioAccessCapability_v3a0ext;
static int ett_rrc_UE_RadioAccessCapability_v3g0ext;
static int ett_rrc_UE_RadioAccessCapability_v650ext;
static int ett_rrc_UE_RadioAccessCapability_v690ext;
static int ett_rrc_UE_RadioAccessCapability_v7e0ext;
static int ett_rrc_UE_RadioAccessCapability_v7f0ext;
static int ett_rrc_UE_RadioAccessCapabilityInfo_v770ext;
static int ett_rrc_UE_RadioAccessCapabilityInfo_TDD128_v8b0ext;
static int ett_rrc_UE_RadioAccessCapabilityInfo_TDD128_vb50ext;
static int ett_rrc_UE_RadioAccessCapability_v860ext;
static int ett_rrc_UE_RadioAccessCapability_v880ext;
static int ett_rrc_UE_RadioAccessCapability_v920ext;
static int ett_rrc_UE_RadioAccessCapability_va40ext;
static int ett_rrc_UE_RadioAccessCapability_va80ext;
static int ett_rrc_UE_RadioAccessCapability_vb50ext;
static int ett_rrc_UE_RadioAccessCapability_vb70ext;
static int ett_rrc_UE_RadioAccessCapability_vbc0ext;
static int ett_rrc_UE_RadioAccessCapability_vd20ext;
static int ett_rrc_UE_RadioAccessCapabBand_va40ext;
static int ett_rrc_UE_RadioAccessCapabBandFDDList2;
static int ett_rrc_UE_RadioAccessCapabBandFDDList3;
static int ett_rrc_UE_RadioAccessCapabBandFDDList4;
static int ett_rrc_UE_RadioAccessCapabBandFDDList4_va60ext;
static int ett_rrc_UE_RadioAccessCapabBandFDDList4_va80ext;
static int ett_rrc_UE_RadioAccessCapabBandFDDList5;
static int ett_rrc_UE_RadioAccessCapabBandFDDList6;
static int ett_rrc_UE_RadioAccessCapabBandFDDList7;
static int ett_rrc_UE_RadioAccessCapabBandFDD2;
static int ett_rrc_T_fddRF_Capability_01;
static int ett_rrc_UE_RadioAccessCapabBandFDD3;
static int ett_rrc_UE_RadioAccessCapabBandFDD4;
static int ett_rrc_UE_RadioAccessCapabBandFDD4_va60ext;
static int ett_rrc_UE_RadioAccessCapabBandFDD4_va80ext;
static int ett_rrc_UE_RadioAccessCapabBandFDD5;
static int ett_rrc_T_fddRF_Capability_02;
static int ett_rrc_UE_RadioAccessCapabBandFDD6;
static int ett_rrc_UE_RadioAccessCapabBandFDD7;
static int ett_rrc_UE_PositioningCapabilityExt_v380;
static int ett_rrc_UE_PositioningCapabilityExt_v3a0;
static int ett_rrc_UE_PositioningCapabilityExt_v3g0;
static int ett_rrc_UE_PositioningCapability_v770ext;
static int ett_rrc_UE_PositioningCapability_v860ext;
static int ett_rrc_UE_PositioningCapability_vd20ext;
static int ett_rrc_UE_RadioAccessCapabBandCombList;
static int ett_rrc_UE_RadioAccessCapabBandFDDList;
static int ett_rrc_UE_RadioAccessCapabBandFDDList_ext;
static int ett_rrc_UE_RadioAccessCapabBandFDDList_ext2;
static int ett_rrc_UE_RadioAccessCapabBandFDD;
static int ett_rrc_T_fddRF_Capability_03;
static int ett_rrc_UE_RadioAcc