/* packet-usb-ptp.h
 *
 * usb image picture transfer protocol dissector
 * (c)2013 Max Baker <max@warped.org>
 * (c)2022 Jake Merdich <jake@merdich.com>
 *
 * Much of this adapted from libgphoto2/libgphoto2/camlibs/ptp2/
 *
 * Copyright (C) 2001 Mariusz Woloszyn <emsi@ipartners.pl>
 * Copyright (C) 2003-2012 Marcus Meissner <marcus@jet.franken.de>
 * Copyright (C) 2006-2008 Linus Walleij <triad@df.lth.se>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#define IF_CLASS_IMAGE_SUBCLASS_PTP 0x01
#define IF_CLASS_IMAGE_PROTOCOL_PTP 0x01

/* 7.1.1 [1] */
#define USB_PTP_TYPE_CMD        0x1
#define USB_PTP_TYPE_DATA       0x2
#define USB_PTP_TYPE_RESPONSE   0x3
#define USB_PTP_TYPE_EVENT      0x4

#define USB_PTP_VENDOR_EXT_MTP 0x00000006

#define USB_PTP_VENDOR_CANON     0x04a9
#define USB_PTP_VENDOR_CASIO     0x07cf
#define USB_PTP_VENDOR_NIKON     0x04b0
#define USB_PTP_VENDOR_FUJI      0x04cb
#define USB_PTP_VENDOR_OLYMPUS   0x07b4
#define USB_PTP_VENDOR_KODAK     0x040a
#define USB_PTP_VENDOR_LEICA     0x1a98
#define USB_PTP_VENDOR_PARROT    0x19cf
#define USB_PTP_VENDOR_PANASONIC 0x04da
#define USB_PTP_VENDOR_SONY      0x054c


#define USB_PTP_OC_GETDEVICEINFO           0x1001
#define USB_PTP_OC_GETSTORAGEIDS           0x1004
#define USB_PTP_OC_GETOBJECTHANDLES        0x1007
#define USB_PTP_OC_GETDEVICEPROPDESC       0x1014
#define USB_PTP_OC_SETDEVICEPROPVALUE      0x1016
#define USB_PTP_OC_GETOBJECTPROPSSUPPORTED 0x9801
#define USB_PTP_OC_GETOBJECTPROPDESC       0x9802

/* MASKED VALUE STRINGS */
typedef struct _usb_ptp_value_string_masked {
    uint32_t      mask;
    uint32_t      value;
    const char    *strptr;
} usb_ptp_value_string_masked_t;

/* PTP device info structure (returned by GetDevInfo) */
typedef struct _usb_ptp_device_info_t {
    uint16_t      StandardVersion;
    uint32_t      VendorExtensionID;
    uint16_t      VendorExtensionVersion;
    char         *VendorExtensionDesc;
    uint16_t      FunctionalMode;
    value_string *OperationsSupported;
    value_string *EventsSupported;
    value_string *DevicePropertiesSupported;
    value_string *CaptureFormats;
    value_string *ImageFormats;
    char         *Manufacturer;
    char         *Model;
    char         *DeviceVersion;
    char         *SerialNumber;
} usb_ptp_device_info_t;

/* Struct stored into usb_conv that keeps track of decoded device information
 *      Gets attached to *class_data in usb_conv */
typedef struct _usb_ptp_conv_info_t {
    uint32_t               flavor;
    usb_ptp_device_info_t *device_info;
    /*usb_ptp_object_info_t *object_info; NOT Implemented yet*/
} usb_ptp_conv_info_t;

/* Mask Definition for Value Strings */
#define USB_PTP_FLAVOR_NONE      0x0000
#define USB_PTP_FLAVOR_ALL       0x0001
#define USB_PTP_FLAVOR_ANDROID   0x0002
#define USB_PTP_FLAVOR_CANON     0x0004
#define USB_PTP_FLAVOR_CASIO     0x0008
#define USB_PTP_FLAVOR_KODAK     0x0010
#define USB_PTP_FLAVOR_FUJI      0x0020
#define USB_PTP_FLAVOR_MTP       0x0040
#define USB_PTP_FLAVOR_NIKON     0x0080
#define USB_PTP_FLAVOR_OLYMPUS   0x0100
#define USB_PTP_FLAVOR_LEICA     0x0200
#define USB_PTP_FLAVOR_PARROT    0x0400
#define USB_PTP_FLAVOR_PANASONIC 0x0800
#define USB_PTP_FLAVOR_SONY      0x1000

static const value_string usb_ptp_container_type_vals[] = {
    {USB_PTP_TYPE_CMD,      "Command Block"},
    {USB_PTP_TYPE_DATA,     "Data Block"},
    {USB_PTP_TYPE_RESPONSE, "Response Block"},
    {USB_PTP_TYPE_EVENT,    "Event Block"},
    {0, NULL}
};

/*
 *
 * SEMIAUTO-GENERATED CODE - The majority of these tables were auto-generated from tools/usb-ptp-extract-tables.pl
 *
 * NOTE: The tables contain additional information not in libgphoto, so you must hand merge the
 *       output from the above to these tables.
 *
 */

/* START AUTOGENERATED CODE */
/* PTP_AC StorageInfo Access Capability */
static const usb_ptp_value_string_masked_t usb_ptp_ac_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x0000, "ReadWrite"},
    {USB_PTP_FLAVOR_ALL       , 0x0001, "ReadOnly"},
    {USB_PTP_FLAVOR_ALL       , 0x0002, "ReadOnly_with_Object_Deletion"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_AT Association Types */
static const usb_ptp_value_string_masked_t usb_ptp_at_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x0000, "Undefined"},
    {USB_PTP_FLAVOR_ALL       , 0x0001, "GenericFolder"},
    {USB_PTP_FLAVOR_ALL       , 0x0002, "Album"},
    {USB_PTP_FLAVOR_ALL       , 0x0003, "TimeSequence"},
    {USB_PTP_FLAVOR_ALL       , 0x0004, "HorizontalPanoramic"},
    {USB_PTP_FLAVOR_ALL       , 0x0005, "VerticalPanoramic"},
    {USB_PTP_FLAVOR_ALL       , 0x0006, "2DPanoramic"},
    {USB_PTP_FLAVOR_ALL       , 0x0007, "AncillaryData"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_DPC Device Properties Codes */
static const usb_ptp_value_string_masked_t usb_ptp_dpc_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x5000, "Undefined"},
    {USB_PTP_FLAVOR_ALL       , 0x5001, "BatteryLevel"},
    {USB_PTP_FLAVOR_ALL       , 0x5002, "FunctionalMode"},
    {USB_PTP_FLAVOR_ALL       , 0x5003, "ImageSize"},
    {USB_PTP_FLAVOR_ALL       , 0x5004, "CompressionSetting"},
    {USB_PTP_FLAVOR_ALL       , 0x5005, "WhiteBalance"},
    {USB_PTP_FLAVOR_ALL       , 0x5006, "RGBGain"},
    {USB_PTP_FLAVOR_ALL       , 0x5007, "FNumber"},
    {USB_PTP_FLAVOR_ALL       , 0x5008, "FocalLength"},
    {USB_PTP_FLAVOR_ALL       , 0x5009, "FocusDistance"},
    {USB_PTP_FLAVOR_ALL       , 0x500a, "FocusMode"},
    {USB_PTP_FLAVOR_ALL       , 0x500b, "ExposureMeteringMode"},
    {USB_PTP_FLAVOR_ALL       , 0x500c, "FlashMode"},
    {USB_PTP_FLAVOR_ALL       , 0x500d, "ExposureTime"},
    {USB_PTP_FLAVOR_ALL       , 0x500e, "ExposureProgramMode"},
    {USB_PTP_FLAVOR_ALL       , 0x500f, "ExposureIndex"},
    {USB_PTP_FLAVOR_ALL       , 0x5010, "ExposureBiasCompensation"},
    {USB_PTP_FLAVOR_ALL       , 0x5011, "DateTime"},
    {USB_PTP_FLAVOR_ALL       , 0x5012, "CaptureDelay"},
    {USB_PTP_FLAVOR_ALL       , 0x5013, "StillCaptureMode"},
    {USB_PTP_FLAVOR_ALL       , 0x5014, "Contrast"},
    {USB_PTP_FLAVOR_ALL       , 0x5015, "Sharpness"},
    {USB_PTP_FLAVOR_ALL       , 0x5016, "DigitalZoom"},
    {USB_PTP_FLAVOR_ALL       , 0x5017, "EffectMode"},
    {USB_PTP_FLAVOR_ALL       , 0x5018, "BurstNumber"},
    {USB_PTP_FLAVOR_ALL       , 0x5019, "BurstInterval"},
    {USB_PTP_FLAVOR_ALL       , 0x501a, "TimelapseNumber"},
    {USB_PTP_FLAVOR_ALL       , 0x501b, "TimelapseInterval"},
    {USB_PTP_FLAVOR_ALL       , 0x501c, "FocusMeteringMode"},
    {USB_PTP_FLAVOR_ALL       , 0x501d, "UploadURL"},
    {USB_PTP_FLAVOR_ALL       , 0x501e, "Artist"},
    {USB_PTP_FLAVOR_ALL       , 0x501f, "CopyrightInfo"},
    {USB_PTP_FLAVOR_ALL       , 0x5020, "SupportedStreams"},
    {USB_PTP_FLAVOR_ALL       , 0x5021, "EnabledStreams"},
    {USB_PTP_FLAVOR_ALL       , 0x5022, "VideoFormat"},
    {USB_PTP_FLAVOR_ALL       , 0x5023, "VideoResolution"},
    {USB_PTP_FLAVOR_ALL       , 0x5024, "VideoQuality"},
    {USB_PTP_FLAVOR_ALL       , 0x5025, "VideoFrameRate"},
    {USB_PTP_FLAVOR_ALL       , 0x5026, "VideoContrast"},
    {USB_PTP_FLAVOR_ALL       , 0x5027, "VideoBrightness"},
    {USB_PTP_FLAVOR_ALL       , 0x5028, "AudioFormat"},
    {USB_PTP_FLAVOR_ALL       , 0x5029, "AudioBitrate"},
    {USB_PTP_FLAVOR_ALL       , 0x502a, "AudioSamplingRate"},
    {USB_PTP_FLAVOR_ALL       , 0x502b, "AudioBitPerSample"},
    {USB_PTP_FLAVOR_ALL       , 0x502c, "AudioVolume"},
    {USB_PTP_FLAVOR_ALL       , 0xd000, "EXTENSION"},
    {USB_PTP_FLAVOR_CANON     , 0xd001, "BeepMode"},
    {USB_PTP_FLAVOR_CASIO     , 0xd001, "MONITOR"},
    {USB_PTP_FLAVOR_KODAK     , 0xd001, "ColorTemperature"},
    {USB_PTP_FLAVOR_FUJI      , 0xd001, "FilmSimulation"},
    {USB_PTP_FLAVOR_CANON     , 0xd002, "BatteryKind"},
    {USB_PTP_FLAVOR_CASIO     , 0xd002, "STORAGE"},
    {USB_PTP_FLAVOR_KODAK     , 0xd002, "DateTimeStampFormat"},
    {USB_PTP_FLAVOR_FUJI      , 0xd002, "FilmSimulationTune"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd002, "Aperture"},
    {USB_PTP_FLAVOR_CANON     , 0xd003, "BatteryStatus"},
    {USB_PTP_FLAVOR_KODAK     , 0xd003, "BeepMode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd003, "FocusMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd004, "UILockType"},
    {USB_PTP_FLAVOR_CASIO     , 0xd004, "UNKNOWN_1"},
    {USB_PTP_FLAVOR_KODAK     , 0xd004, "VideoOut"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd004, "ExposureMeteringMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd005, "CameraMode"},
    {USB_PTP_FLAVOR_CASIO     , 0xd005, "UNKNOWN_2"},
    {USB_PTP_FLAVOR_KODAK     , 0xd005, "PowerSaving"},
    {USB_PTP_FLAVOR_CANON     , 0xd006, "ImageQuality"},
    {USB_PTP_FLAVOR_KODAK     , 0xd006, "UI_Language"},
    {USB_PTP_FLAVOR_CANON     , 0xd007, "FullViewFileFormat"},
    {USB_PTP_FLAVOR_CASIO     , 0xd007, "UNKNOWN_3"},
    {USB_PTP_FLAVOR_FUJI      , 0xd007, "DRangeMode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd007, "ISO"},
    {USB_PTP_FLAVOR_CANON     , 0xd008, "ImageSize"},
    {USB_PTP_FLAVOR_CASIO     , 0xd008, "RECORD_LIGHT"},
    {USB_PTP_FLAVOR_FUJI      , 0xd008, "ColorMode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd008, "ExposureCompensation"},
    {USB_PTP_FLAVOR_CANON     , 0xd009, "SelfTime"},
    {USB_PTP_FLAVOR_CASIO     , 0xd009, "UNKNOWN_4"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd009, "DriveMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd00a, "FlashMode"},
    {USB_PTP_FLAVOR_CASIO     , 0xd00a, "UNKNOWN_5"},
    {USB_PTP_FLAVOR_FUJI      , 0xd00a, "ColorSpace"},
    {USB_PTP_FLAVOR_CANON     , 0xd00b, "Beep"},
    {USB_PTP_FLAVOR_CASIO     , 0xd00b, "MOVIE_MODE"},
    {USB_PTP_FLAVOR_FUJI      , 0xd00b, "WhitebalanceTune1"},
    {USB_PTP_FLAVOR_CANON     , 0xd00c, "ShootingMode"},
    {USB_PTP_FLAVOR_CASIO     , 0xd00c, "HD_SETTING"},
    {USB_PTP_FLAVOR_FUJI      , 0xd00c, "WhitebalanceTune2"},
    {USB_PTP_FLAVOR_CANON     , 0xd00d, "ImageMode"},
    {USB_PTP_FLAVOR_CASIO     , 0xd00d, "HS_SETTING"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd00d, "ImageFormat"},
    {USB_PTP_FLAVOR_CANON     , 0xd00e, "DriveMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd00f, "EZoom"},
    {USB_PTP_FLAVOR_CASIO     , 0xd00f, "CS_HIGH_SPEED"},
    {USB_PTP_FLAVOR_ALL       , 0xd00f, "RICOH_ShutterSpeed"},
    {USB_PTP_FLAVOR_CANON     , 0xd010, "MeteringMode"},
    {USB_PTP_FLAVOR_CASIO     , 0xd010, "CS_UPPER_LIMIT"},
    {USB_PTP_FLAVOR_NIKON     , 0xd010, "ShootingBank"},
    {USB_PTP_FLAVOR_CANON     , 0xd011, "AFDistance"},
    {USB_PTP_FLAVOR_CASIO     , 0xd011, "CS_SHOT"},
    {USB_PTP_FLAVOR_NIKON     , 0xd011, "ShootingBankNameA"},
    {USB_PTP_FLAVOR_CANON     , 0xd012, "FocusingPoint"},
    {USB_PTP_FLAVOR_CASIO     , 0xd012, "UNKNOWN_6"},
    {USB_PTP_FLAVOR_NIKON     , 0xd012, "ShootingBankNameB"},
    {USB_PTP_FLAVOR_CANON     , 0xd013, "WhiteBalance"},
    {USB_PTP_FLAVOR_CASIO     , 0xd013, "UNKNOWN_7"},
    {USB_PTP_FLAVOR_NIKON     , 0xd013, "ShootingBankNameC"},
    {USB_PTP_FLAVOR_CANON     , 0xd014, "SlowShutterSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd014, "ShootingBankNameD"},
    {USB_PTP_FLAVOR_CANON     , 0xd015, "AFMode"},
    {USB_PTP_FLAVOR_CASIO     , 0xd015, "UNKNOWN_8"},
    {USB_PTP_FLAVOR_NIKON     , 0xd015, "ResetBank0"},
    {USB_PTP_FLAVOR_CANON     , 0xd016, "ImageStabilization"},
    {USB_PTP_FLAVOR_NIKON     , 0xd016, "RawCompression"},
    {USB_PTP_FLAVOR_CANON     , 0xd017, "Contrast"},
    {USB_PTP_FLAVOR_CASIO     , 0xd017, "UNKNOWN_9"},
    {USB_PTP_FLAVOR_FUJI      , 0xd017, "ColorTemperature"},
    {USB_PTP_FLAVOR_NIKON     , 0xd017, "WhiteBalanceAutoBias"},
    {USB_PTP_FLAVOR_CANON     , 0xd018, "ColorGain"},
    {USB_PTP_FLAVOR_CASIO     , 0xd018, "UNKNOWN_10"},
    {USB_PTP_FLAVOR_FUJI      , 0xd018, "Quality"},
    {USB_PTP_FLAVOR_LEICA     , 0xd018, "ExternalShooting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd018, "WhiteBalanceTungstenBias"},
    {USB_PTP_FLAVOR_CANON     , 0xd019, "Sharpness"},
    {USB_PTP_FLAVOR_CASIO     , 0xd019, "UNKNOWN_11"},
    {USB_PTP_FLAVOR_FUJI      , 0xd019, "RecMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd019, "WhiteBalanceFluorescentBias"},
    {USB_PTP_FLAVOR_CANON     , 0xd01a, "Sensitivity"},
    {USB_PTP_FLAVOR_CASIO     , 0xd01a, "UNKNOWN_12"},
    {USB_PTP_FLAVOR_FUJI      , 0xd01a, "LiveViewBrightness"},
    {USB_PTP_FLAVOR_NIKON     , 0xd01a, "WhiteBalanceDaylightBias"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd01a, "FaceDetection"},
    {USB_PTP_FLAVOR_CANON     , 0xd01b, "ParameterSet"},
    {USB_PTP_FLAVOR_CASIO     , 0xd01b, "UNKNOWN_13"},
    {USB_PTP_FLAVOR_FUJI      , 0xd01b, "ThroughImageZoom"},
    {USB_PTP_FLAVOR_NIKON     , 0xd01b, "WhiteBalanceFlashBias"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd01b, "AspectRatio"},
    {USB_PTP_FLAVOR_CANON     , 0xd01c, "ISOSpeed"},
    {USB_PTP_FLAVOR_CASIO     , 0xd01c, "UNKNOWN_14"},
    {USB_PTP_FLAVOR_FUJI      , 0xd01c, "NoiseReduction"},
    {USB_PTP_FLAVOR_NIKON     , 0xd01c, "WhiteBalanceCloudyBias"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd01c, "Shutterspeed"},
    {USB_PTP_FLAVOR_CANON     , 0xd01d, "Aperture"},
    {USB_PTP_FLAVOR_CASIO     , 0xd01d, "UNKNOWN_15"},
    {USB_PTP_FLAVOR_FUJI      , 0xd01d, "MacroMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd01d, "WhiteBalanceShadeBias"},
    {USB_PTP_FLAVOR_CANON     , 0xd01e, "ShutterSpeed"},
    {USB_PTP_FLAVOR_FUJI      , 0xd01e, "LiveViewStyle"},
    {USB_PTP_FLAVOR_NIKON     , 0xd01e, "WhiteBalanceColorTemperature"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd01e, "WhiteBalance"},
    {USB_PTP_FLAVOR_CANON     , 0xd01f, "ExpCompensation"},
    {USB_PTP_FLAVOR_NIKON     , 0xd01f, "WhiteBalancePresetNo"},
    {USB_PTP_FLAVOR_CANON     , 0xd020, "FlashCompensation"},
    {USB_PTP_FLAVOR_CASIO     , 0xd020, "UNKNOWN_16"},
    {USB_PTP_FLAVOR_FUJI      , 0xd020, "FaceDetectionMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd020, "WhiteBalancePresetName0"},
    {USB_PTP_FLAVOR_CANON     , 0xd021, "AEBExposureCompensation"},
    {USB_PTP_FLAVOR_FUJI      , 0xd021, "RedEyeCorrectionMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd021, "WhiteBalancePresetName1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd022, "RawCompression"},
    {USB_PTP_FLAVOR_NIKON     , 0xd022, "WhiteBalancePresetName2"},
    {USB_PTP_FLAVOR_CANON     , 0xd023, "AvOpen"},
    {USB_PTP_FLAVOR_FUJI      , 0xd023, "GrainEffect"},
    {USB_PTP_FLAVOR_NIKON     , 0xd023, "WhiteBalancePresetName3"},
    {USB_PTP_FLAVOR_CANON     , 0xd024, "AvMax"},
    {USB_PTP_FLAVOR_FUJI      , 0xd024, "SetEyeAFMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd024, "WhiteBalancePresetName4"},
    {USB_PTP_FLAVOR_CANON     , 0xd025, "FocalLength"},
    {USB_PTP_FLAVOR_FUJI      , 0xd025, "FocusPoints"},
    {USB_PTP_FLAVOR_NIKON     , 0xd025, "WhiteBalancePresetVal0"},
    {USB_PTP_FLAVOR_CANON     , 0xd026, "FocalLengthTele"},
    {USB_PTP_FLAVOR_FUJI      , 0xd026, "MFAssistMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd026, "WhiteBalancePresetVal1"},
    {USB_PTP_FLAVOR_CANON     , 0xd027, "FocalLengthWide"},
    {USB_PTP_FLAVOR_FUJI      , 0xd027, "InterlockAEAFArea"},
    {USB_PTP_FLAVOR_NIKON     , 0xd027, "WhiteBalancePresetVal2"},
    {USB_PTP_FLAVOR_CANON     , 0xd028, "FocalLengthDenominator"},
    {USB_PTP_FLAVOR_FUJI      , 0xd028, "CommandDialMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd028, "WhiteBalancePresetVal3"},
    {USB_PTP_FLAVOR_CANON     , 0xd029, "CaptureTransferMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd029, "Shadowing"},
    {USB_PTP_FLAVOR_NIKON     , 0xd029, "WhiteBalancePresetVal4"},
    {USB_PTP_FLAVOR_CANON     , 0xd02a, "Zoom"},
    {USB_PTP_FLAVOR_FUJI      , 0xd02a, "ExposureIndex"},
    {USB_PTP_FLAVOR_NIKON     , 0xd02a, "ImageSharpening"},
    {USB_PTP_FLAVOR_CANON     , 0xd02b, "NamePrefix"},
    {USB_PTP_FLAVOR_FUJI      , 0xd02b, "MovieISO"},
    {USB_PTP_FLAVOR_NIKON     , 0xd02b, "ToneCompensation"},
    {USB_PTP_FLAVOR_CANON     , 0xd02c, "SizeQualityMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd02c, "ColorModel"},
    {USB_PTP_FLAVOR_CANON     , 0xd02d, "SupportedThumbSize"},
    {USB_PTP_FLAVOR_NIKON     , 0xd02d, "HueAdjustment"},
    {USB_PTP_FLAVOR_CANON     , 0xd02e, "SizeOfOutputDataFromCamera"},
    {USB_PTP_FLAVOR_FUJI      , 0xd02e, "WideDynamicRange"},
    {USB_PTP_FLAVOR_NIKON     , 0xd02e, "FmmManualSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd02e, "NonCPULensDataFocalLength"},
    {USB_PTP_FLAVOR_CANON     , 0xd02f, "SizeOfInputDataToCamera"},
    {USB_PTP_FLAVOR_FUJI      , 0xd02f, "TNumber"},
    {USB_PTP_FLAVOR_NIKON     , 0xd02f, "F0ManualSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd02f, "NonCPULensDataMaximumAperture"},
    {USB_PTP_FLAVOR_CANON     , 0xd030, "RemoteAPIVersion"},
    {USB_PTP_FLAVOR_CASIO     , 0xd030, "UNKNOWN_17"},
    {USB_PTP_FLAVOR_NIKON     , 0xd030, "CaptureAreaCrop"},
    {USB_PTP_FLAVOR_NIKON     , 0xd030, "ShootingMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd031, "FirmwareVersion"},
    {USB_PTP_FLAVOR_NIKON     , 0xd031, "JPEG_Compression_Policy"},
    {USB_PTP_FLAVOR_CANON     , 0xd032, "CameraModel"},
    {USB_PTP_FLAVOR_NIKON     , 0xd032, "ColorSpace"},
    {USB_PTP_FLAVOR_CANON     , 0xd033, "CameraOwner"},
    {USB_PTP_FLAVOR_NIKON     , 0xd033, "AutoDXCrop"},
    {USB_PTP_FLAVOR_CANON     , 0xd034, "UnixTime"},
    {USB_PTP_FLAVOR_NIKON     , 0xd034, "FlickerReduction"},
    {USB_PTP_FLAVOR_CANON     , 0xd035, "CameraBodyID"},
    {USB_PTP_FLAVOR_NIKON     , 0xd035, "RemoteMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd036, "CameraOutput"},
    {USB_PTP_FLAVOR_NIKON     , 0xd036, "VideoMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd037, "DispAv"},
    {USB_PTP_FLAVOR_NIKON     , 0xd037, "EffectMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd038, "AvOpenApex"},
    {USB_PTP_FLAVOR_NIKON     , 0xd038, "1_Mode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd038, "WhiteBalancePresetName5"},
    {USB_PTP_FLAVOR_CANON     , 0xd039, "DZoomMagnification"},
    {USB_PTP_FLAVOR_NIKON     , 0xd039, "WhiteBalancePresetName6"},
    {USB_PTP_FLAVOR_CANON     , 0xd03a, "MlSpotPos"},
    {USB_PTP_FLAVOR_NIKON     , 0xd03a, "WhiteBalanceTunePreset5"},
    {USB_PTP_FLAVOR_CANON     , 0xd03b, "DispAvMax"},
    {USB_PTP_FLAVOR_NIKON     , 0xd03b, "WhiteBalanceTunePreset6"},
    {USB_PTP_FLAVOR_CANON     , 0xd03c, "AvMaxApex"},
    {USB_PTP_FLAVOR_NIKON     , 0xd03c, "WhiteBalancePresetProtect5"},
    {USB_PTP_FLAVOR_CANON     , 0xd03d, "EZoomStartPosition"},
    {USB_PTP_FLAVOR_NIKON     , 0xd03d, "WhiteBalancePresetProtect6"},
    {USB_PTP_FLAVOR_CANON     , 0xd03e, "FocalLengthOfTele"},
    {USB_PTP_FLAVOR_NIKON     , 0xd03e, "WhiteBalancePresetValue5"},
    {USB_PTP_FLAVOR_CANON     , 0xd03f, "EZoomSizeOfTele"},
    {USB_PTP_FLAVOR_NIKON     , 0xd03f, "WhiteBalancePresetValue6"},
    {USB_PTP_FLAVOR_CANON     , 0xd040, "PhotoEffect"},
    {USB_PTP_FLAVOR_NIKON     , 0xd040, "CSMMenuBankSelect"},
    {USB_PTP_FLAVOR_CANON     , 0xd041, "AssistLight"},
    {USB_PTP_FLAVOR_NIKON     , 0xd041, "MenuBankNameA"},
    {USB_PTP_FLAVOR_CANON     , 0xd042, "FlashQuantityCount"},
    {USB_PTP_FLAVOR_NIKON     , 0xd042, "MenuBankNameB"},
    {USB_PTP_FLAVOR_CANON     , 0xd043, "RotationAngle"},
    {USB_PTP_FLAVOR_NIKON     , 0xd043, "MenuBankNameC"},
    {USB_PTP_FLAVOR_CANON     , 0xd044, "RotationScene"},
    {USB_PTP_FLAVOR_NIKON     , 0xd044, "MenuBankNameD"},
    {USB_PTP_FLAVOR_CANON     , 0xd045, "EventEmulateMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd045, "ResetBank"},
    {USB_PTP_FLAVOR_CANON     , 0xd046, "DPOFVersion"},
    {USB_PTP_FLAVOR_NIKON     , 0xd046, "AFStillLockOnAcross"},
    {USB_PTP_FLAVOR_CANON     , 0xd047, "TypeOfSupportedSlideShow"},
    {USB_PTP_FLAVOR_NIKON     , 0xd047, "AFStillLockOnMove"},
    {USB_PTP_FLAVOR_CANON     , 0xd048, "AverageFilesizes"},
    {USB_PTP_FLAVOR_NIKON     , 0xd048, "A1AFCModePriority"},
    {USB_PTP_FLAVOR_CANON     , 0xd049, "ModelID"},
    {USB_PTP_FLAVOR_NIKON     , 0xd049, "A2AFSModePriority"},
    {USB_PTP_FLAVOR_NIKON     , 0xd04a, "A3GroupDynamicAF"},
    {USB_PTP_FLAVOR_NIKON     , 0xd04b, "A4AFActivation"},
    {USB_PTP_FLAVOR_NIKON     , 0xd04c, "FocusAreaIllumManualFocus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd04d, "FocusAreaIllumContinuous"},
    {USB_PTP_FLAVOR_NIKON     , 0xd04e, "FocusAreaIllumWhenSelected"},
    {USB_PTP_FLAVOR_NIKON     , 0xd04f, "FocusAreaSelect"},
    {USB_PTP_FLAVOR_NIKON     , 0xd04f, "FocusAreaWrap"},
    {USB_PTP_FLAVOR_NIKON     , 0xd050, "VerticalAFON"},
    {USB_PTP_FLAVOR_NIKON     , 0xd051, "AFLockOn"},
    {USB_PTP_FLAVOR_NIKON     , 0xd052, "FocusAreaZone"},
    {USB_PTP_FLAVOR_NIKON     , 0xd053, "EnableCopyright"},
    {USB_PTP_FLAVOR_NIKON     , 0xd054, "ISOAuto"},
    {USB_PTP_FLAVOR_CANON     , 0xd055, "PowerZoomPosition"},
    {USB_PTP_FLAVOR_NIKON     , 0xd055, "EVISOStep"},
    {USB_PTP_FLAVOR_CANON     , 0xd056, "StrobeSettingSimple"},
    {USB_PTP_FLAVOR_NIKON     , 0xd056, "EVStep"},
    {USB_PTP_FLAVOR_NIKON     , 0xd057, "EVStepExposureComp"},
    {USB_PTP_FLAVOR_CANON     , 0xd058, "ConnectTrigger"},
    {USB_PTP_FLAVOR_NIKON     , 0xd058, "ExposureCompensation"},
    {USB_PTP_FLAVOR_CANON     , 0xd059, "ChangeCameraMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd059, "CenterWeightArea"},
    {USB_PTP_FLAVOR_NIKON     , 0xd05a, "ExposureBaseMatrix"},
    {USB_PTP_FLAVOR_NIKON     , 0xd05b, "ExposureBaseCenter"},
    {USB_PTP_FLAVOR_NIKON     , 0xd05c, "ExposureBaseSpot"},
    {USB_PTP_FLAVOR_NIKON     , 0xd05d, "LiveViewAFArea"},
    {USB_PTP_FLAVOR_NIKON     , 0xd05e, "AELockMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd05f, "AELAFLMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd061, "LiveViewAFFocus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd062, "MeterOff"},
    {USB_PTP_FLAVOR_NIKON     , 0xd063, "SelfTimer"},
    {USB_PTP_FLAVOR_NIKON     , 0xd064, "MonitorOff"},
    {USB_PTP_FLAVOR_NIKON     , 0xd065, "ImgConfTime"},
    {USB_PTP_FLAVOR_NIKON     , 0xd066, "AutoOffTimers"},
    {USB_PTP_FLAVOR_NIKON     , 0xd067, "AngleLevel"},
    {USB_PTP_FLAVOR_NIKON     , 0xd068, "D1ShootingSpeed"},
    {USB_PTP_FLAVOR_NIKON     , 0xd069, "D2MaximumShots"},
    {USB_PTP_FLAVOR_NIKON     , 0xd06a, "ExposureDelayMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd06b, "LongExposureNoiseReduction"},
    {USB_PTP_FLAVOR_NIKON     , 0xd06c, "FileNumberSequence"},
    {USB_PTP_FLAVOR_NIKON     , 0xd06d, "ControlPanelFinderRearControl"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd06d, "LiveViewModeOM"},
    {USB_PTP_FLAVOR_NIKON     , 0xd06e, "ControlPanelFinderViewfinder"},
    {USB_PTP_FLAVOR_NIKON     , 0xd06f, "D7Illumination"},
    {USB_PTP_FLAVOR_NIKON     , 0xd070, "NrHighISO"},
    {USB_PTP_FLAVOR_NIKON     , 0xd071, "SHSET_CH_GUID_DISP"},
    {USB_PTP_FLAVOR_NIKON     , 0xd072, "ArtistName"},
    {USB_PTP_FLAVOR_NIKON     , 0xd073, "CopyrightInfo"},
    {USB_PTP_FLAVOR_NIKON     , 0xd074, "FlashSyncSpeed"},
    {USB_PTP_FLAVOR_NIKON     , 0xd075, "FlashShutterSpeed"},
    {USB_PTP_FLAVOR_NIKON     , 0xd076, "E3AAFlashMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd077, "E4ModelingFlash"},
    {USB_PTP_FLAVOR_NIKON     , 0xd078, "BracketSet"},
    {USB_PTP_FLAVOR_NIKON     , 0xd079, "E6ManualModeBracketing"},
    {USB_PTP_FLAVOR_NIKON     , 0xd07a, "BracketOrder"},
    {USB_PTP_FLAVOR_NIKON     , 0xd07b, "E8AutoBracketSelection"},
    {USB_PTP_FLAVOR_NIKON     , 0xd07c, "BracketingSet"},
    {USB_PTP_FLAVOR_NIKON     , 0xd07d, "AngleLevelPitching"},
    {USB_PTP_FLAVOR_NIKON     , 0xd07e, "AngleLevelYawing"},
    {USB_PTP_FLAVOR_NIKON     , 0xd07f, "ExtendShootingMenu"},
    {USB_PTP_FLAVOR_CASIO     , 0xd080, "UNKNOWN_18"},
    {USB_PTP_FLAVOR_NIKON     , 0xd080, "F1CenterButtonShootingMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd081, "CenterButtonPlaybackMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd082, "F2Multiselector"},
    {USB_PTP_FLAVOR_NIKON     , 0xd083, "F3PhotoInfoPlayback"},
    {USB_PTP_FLAVOR_NIKON     , 0xd084, "F4AssignFuncButton"},
    {USB_PTP_FLAVOR_NIKON     , 0xd085, "F5CustomizeCommDials"},
    {USB_PTP_FLAVOR_NIKON     , 0xd086, "ReverseCommandDial"},
    {USB_PTP_FLAVOR_NIKON     , 0xd087, "ApertureSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd088, "MenusAndPlayback"},
    {USB_PTP_FLAVOR_NIKON     , 0xd089, "F6ButtonsAndDials"},
    {USB_PTP_FLAVOR_NIKON     , 0xd08a, "NoCFCard"},
    {USB_PTP_FLAVOR_NIKON     , 0xd08b, "CenterButtonZoomRatio"},
    {USB_PTP_FLAVOR_NIKON     , 0xd08c, "FunctionButton2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd08d, "AFAreaPoint"},
    {USB_PTP_FLAVOR_NIKON     , 0xd08e, "NormalAFOn"},
    {USB_PTP_FLAVOR_NIKON     , 0xd08f, "CleanImageSensor"},
    {USB_PTP_FLAVOR_NIKON     , 0xd090, "ImageCommentString"},
    {USB_PTP_FLAVOR_NIKON     , 0xd091, "ImageCommentEnable"},
    {USB_PTP_FLAVOR_NIKON     , 0xd092, "ImageRotation"},
    {USB_PTP_FLAVOR_NIKON     , 0xd093, "ManualSetLensNo"},
    {USB_PTP_FLAVOR_NIKON     , 0xd09c, "RetractableLensWarning"},
    {USB_PTP_FLAVOR_NIKON     , 0xd09d, "FaceDetection"},
    {USB_PTP_FLAVOR_NIKON     , 0xd09e, "3DTrackingCaptureArea"},
    {USB_PTP_FLAVOR_NIKON     , 0xd09f, "MatrixMetering"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0a0, "MovScreenSize"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0a1, "MovVoice"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0a2, "MovMicrophone"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0a3, "MovFileSlot"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0a4, "MovRecProhibitCondition"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0a6, "ManualMovieSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0a7, "MovQuality"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0a8, "MovRecordMicrophoneLevelValue"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0aa, "MovWindNoiseReduction"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0ac, "MovRecordingZone"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0ad, "MovISOAutoControl"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0ae, "MovISOAutoHighLimit"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0af, "MovFileType"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0b2, "LiveViewScreenDisplaySetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0b3, "MonitorOffDelay"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0b4, "ExposureIndexEx"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0b5, "ISOControlSensitivity"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0b6, "RawImageSize"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0b7, "FlickerReductionSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0b9, "MultiBatteryInfo"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0ba, "DiffractionCompensation"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0bb, "MovieLogOutput"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0bc, "MovieAutoDistortion"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0be, "RemainingExposureTime"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0bf, "MovieLogSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0c0, "Bracketing"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0c1, "AutoExposureBracketStep"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0c2, "AutoExposureBracketProgram"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0c3, "AutoExposureBracketCount"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0c4, "WhiteBalanceBracketStep"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0c5, "WhiteBalanceBracketProgram"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0c6, "ADLBracketingPattern"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0c7, "ADLBracketingStep"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0cc, "HDMIOutputDataDepth"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd0dc, "CaptureTarget"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0e0, "LensID"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0e1, "LensSort"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0e2, "LensType"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0e3, "FocalLengthMin"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0e4, "FocalLengthMax"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0e5, "MaxApAtMinFocalLength"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0e6, "MaxApAtMaxFocalLength"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0e7, "LensTypeML"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0f0, "FinderISODisp"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0f2, "AutoOffPhoto"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0f3, "AutoOffMenu"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0f4, "AutoOffInfo"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0f5, "SelfTimerShootNum"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0f7, "VignetteCtrl"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0f8, "AutoDistortionControl"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0f9, "SceneMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0fc, "UserMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0fd, "SceneMode2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd0fe, "SelfTimerInterval"},
    {USB_PTP_FLAVOR_FUJI      , 0xd100, "Comment"},
    {USB_PTP_FLAVOR_NIKON     , 0xd100, "ExposureTime"},
    {USB_PTP_FLAVOR_CANON     , 0xd101, "Aperture"},
    {USB_PTP_FLAVOR_FUJI      , 0xd101, "SerialMode"},
    {USB_PTP_FLAVOR_MTP       , 0xd101, "SecureTime"},
    {USB_PTP_FLAVOR_NIKON     , 0xd101, "ACPower"},
    {USB_PTP_FLAVOR_CANON     , 0xd102, "ShutterSpeed"},
    {USB_PTP_FLAVOR_FUJI      , 0xd102, "ExposureDelay"},
    {USB_PTP_FLAVOR_MTP       , 0xd102, "DeviceCertificate"},
    {USB_PTP_FLAVOR_NIKON     , 0xd102, "WarningStatus"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd102, "ResolutionMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd103, "ISOSpeed"},
    {USB_PTP_FLAVOR_FUJI      , 0xd103, "PreviewTime"},
    {USB_PTP_FLAVOR_MTP       , 0xd103, "RevocationInfo"},
    {USB_PTP_FLAVOR_NIKON     , 0xd103, "MaximumShots"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd103, "FocusPriority"},
    {USB_PTP_FLAVOR_CANON     , 0xd104, "ExpCompensation"},
    {USB_PTP_FLAVOR_FUJI      , 0xd104, "BlackImageTone"},
    {USB_PTP_FLAVOR_NIKON     , 0xd104, "AFLockStatus"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd104, "DriveMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd105, "AutoExposureMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd105, "Illumination"},
    {USB_PTP_FLAVOR_NIKON     , 0xd105, "AELockStatus"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd105, "DateTimeFormat"},
    {USB_PTP_FLAVOR_CANON     , 0xd106, "DriveMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd106, "FrameGuideMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd106, "FVLockStatus"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd106, "ExposureBiasStep"},
    {USB_PTP_FLAVOR_CANON     , 0xd107, "MeteringMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd107, "ViewfinderWarning"},
    {USB_PTP_FLAVOR_NIKON     , 0xd107, "AutofocusLCDTopMode2"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd107, "WBMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd108, "FocusMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd108, "AutoImageRotation"},
    {USB_PTP_FLAVOR_NIKON     , 0xd108, "AutofocusArea"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd108, "OneTouchWB"},
    {USB_PTP_FLAVOR_CANON     , 0xd109, "WhiteBalance"},
    {USB_PTP_FLAVOR_FUJI      , 0xd109, "DetectImageRotation"},
    {USB_PTP_FLAVOR_NIKON     , 0xd109, "FlexibleProgram"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd109, "ManualWB"},
    {USB_PTP_FLAVOR_CANON     , 0xd10a, "ColorTemperature"},
    {USB_PTP_FLAVOR_FUJI      , 0xd10a, "ShutterPriorityMode1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd10a, "LightMeter"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd10a, "ManualWBRBBias"},
    {USB_PTP_FLAVOR_CANON     , 0xd10b, "WhiteBalanceAdjustA"},
    {USB_PTP_FLAVOR_FUJI      , 0xd10b, "ShutterPriorityMode2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd10b, "RecordingMedia"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd10b, "CustomWB"},
    {USB_PTP_FLAVOR_CANON     , 0xd10c, "WhiteBalanceAdjustB"},
    {USB_PTP_FLAVOR_NIKON     , 0xd10c, "USBSpeed"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd10c, "CustomWBValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd10d, "WhiteBalanceXA"},
    {USB_PTP_FLAVOR_NIKON     , 0xd10d, "CCDNumber"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd10d, "ExposureTimeEx"},
    {USB_PTP_FLAVOR_CANON     , 0xd10e, "WhiteBalanceXB"},
    {USB_PTP_FLAVOR_NIKON     , 0xd10e, "CameraOrientation"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd10e, "BulbMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd10f, "ColorSpace"},
    {USB_PTP_FLAVOR_NIKON     , 0xd10f, "GroupPtnType"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd10f, "AntiMirrorMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd110, "PictureStyle"},
    {USB_PTP_FLAVOR_NIKON     , 0xd110, "FNumberLock"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd110, "AEBracketingFrame"},
    {USB_PTP_FLAVOR_CANON     , 0xd111, "BatteryPower"},
    {USB_PTP_FLAVOR_NIKON     , 0xd111, "ExposureApertureLock"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd111, "AEBracketingStep"},
    {USB_PTP_FLAVOR_CANON     , 0xd112, "BatterySelect"},
    {USB_PTP_FLAVOR_FUJI      , 0xd112, "AFIlluminator"},
    {USB_PTP_FLAVOR_NIKON     , 0xd112, "TVLockSetting"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd112, "WBBracketingFrame"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd112, "WBBracketingRBFrame"},
    {USB_PTP_FLAVOR_CANON     , 0xd113, "CameraTime"},
    {USB_PTP_FLAVOR_FUJI      , 0xd113, "Beep"},
    {USB_PTP_FLAVOR_NIKON     , 0xd113, "AVLockSetting"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd113, "WBBracketingRBRange"},
    {USB_PTP_FLAVOR_CANON     , 0xd114, "AutoPowerOff"},
    {USB_PTP_FLAVOR_FUJI      , 0xd114, "AELock"},
    {USB_PTP_FLAVOR_NIKON     , 0xd114, "IllumSetting"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd114, "WBBracketingGMFrame"},
    {USB_PTP_FLAVOR_CANON     , 0xd115, "Owner"},
    {USB_PTP_FLAVOR_FUJI      , 0xd115, "ISOAutoSetting1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd115, "FocusPointBright"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd115, "WBBracketingGMRange"},
    {USB_PTP_FLAVOR_CANON     , 0xd116, "ModelID"},
    {USB_PTP_FLAVOR_FUJI      , 0xd116, "ISOAutoSetting2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd117, "ISOAutoSetting3"},
    {USB_PTP_FLAVOR_FUJI      , 0xd118, "ExposureStep"},
    {USB_PTP_FLAVOR_NIKON     , 0xd118, "ExposureCompFlashUsed"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd118, "FLBracketingFrame"},
    {USB_PTP_FLAVOR_CANON     , 0xd119, "PTPExtensionVersion"},
    {USB_PTP_FLAVOR_FUJI      , 0xd119, "CompensationStep"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd119, "FLBracketingStep"},
    {USB_PTP_FLAVOR_CANON     , 0xd11a, "DPOFVersion"},
    {USB_PTP_FLAVOR_FUJI      , 0xd11a, "ExposureSimpleSet"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd11a, "FlashBiasCompensation"},
    {USB_PTP_FLAVOR_CANON     , 0xd11b, "AvailableShots"},
    {USB_PTP_FLAVOR_FUJI      , 0xd11b, "CenterPhotometryRange"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd11b, "ManualFocusMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd11c, "CaptureDestination"},
    {USB_PTP_FLAVOR_FUJI      , 0xd11c, "PhotometryLevel1"},
    {USB_PTP_FLAVOR_CANON     , 0xd11d, "BracketMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd11d, "PhotometryLevel2"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd11d, "RawSaveMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd11e, "CurrentStorage"},
    {USB_PTP_FLAVOR_FUJI      , 0xd11e, "PhotometryLevel3"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd11e, "AUXLightMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd11f, "CurrentFolder"},
    {USB_PTP_FLAVOR_FUJI      , 0xd11f, "FlashTuneSpeed"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd11f, "LensSinkMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd120, "ImageFormat"},
    {USB_PTP_FLAVOR_FUJI      , 0xd120, "FlashShutterLimit"},
    {USB_PTP_FLAVOR_NIKON     , 0xd120, "ExternalFlashAttached"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd120, "BeepStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd121, "ImageFormatCF"},
    {USB_PTP_FLAVOR_FUJI      , 0xd121, "BuiltinFlashMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd121, "ExternalFlashStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd122, "ImageFormatSD"},
    {USB_PTP_FLAVOR_FUJI      , 0xd122, "FlashManualMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd122, "ExternalFlashSort"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd122, "ColorSpace"},
    {USB_PTP_FLAVOR_CANON     , 0xd123, "ImageFormatExtHD"},
    {USB_PTP_FLAVOR_FUJI      , 0xd123, "FlashRepeatingMode1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd123, "ExternalFlashMode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd123, "ColorMatching"},
    {USB_PTP_FLAVOR_CANON     , 0xd124, "RefocusState"},
    {USB_PTP_FLAVOR_FUJI      , 0xd124, "FlashRepeatingMode2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd124, "ExternalFlashCompensation"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd124, "Saturation"},
    {USB_PTP_FLAVOR_CANON     , 0xd125, "CameraNickname"},
    {USB_PTP_FLAVOR_FUJI      , 0xd125, "FlashRepeatingMode3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd125, "NewExternalFlashMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd126, "StroboSettingExpCompositionControl"},
    {USB_PTP_FLAVOR_FUJI      , 0xd126, "FlashCommanderMode1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd126, "FlashExposureCompensation"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd126, "NoiseReductionPattern"},
    {USB_PTP_FLAVOR_CANON     , 0xd127, "ConnectStatus"},
    {USB_PTP_FLAVOR_FUJI      , 0xd127, "FlashCommanderMode2"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd127, "NoiseReductionRandom"},
    {USB_PTP_FLAVOR_CANON     , 0xd128, "LensBarrelStatus"},
    {USB_PTP_FLAVOR_FUJI      , 0xd128, "FlashCommanderMode3"},
    {USB_PTP_FLAVOR_CANON     , 0xd129, "SilentShutterSetting"},
    {USB_PTP_FLAVOR_FUJI      , 0xd129, "FlashCommanderMode4"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd129, "ShadingMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd12a, "FlashCommanderMode5"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd12a, "ISOBoostMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd12b, "FlashCommanderMode6"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd12b, "ExposureIndexBiasStep"},
    {USB_PTP_FLAVOR_CANON     , 0xd12c, "LV_AF_EyeDetect"},
    {USB_PTP_FLAVOR_FUJI      , 0xd12c, "FlashCommanderMode7"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd12c, "FilterEffect"},
    {USB_PTP_FLAVOR_CANON     , 0xd12d, "AutoTransMobile"},
    {USB_PTP_FLAVOR_FUJI      , 0xd12d, "ModelingFlash"},
    {USB_PTP_FLAVOR_NIKON     , 0xd12d, "ExternalFlashMultiFlashMode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd12d, "ColorTune"},
    {USB_PTP_FLAVOR_CANON     , 0xd12e, "URLSupportFormat"},
    {USB_PTP_FLAVOR_FUJI      , 0xd12e, "BKT"},
    {USB_PTP_FLAVOR_NIKON     , 0xd12e, "ConnectionPath"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd12e, "Language"},
    {USB_PTP_FLAVOR_CANON     , 0xd12f, "SpecialAcc"},
    {USB_PTP_FLAVOR_FUJI      , 0xd12f, "BKTChange"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd12f, "LanguageCode"},
    {USB_PTP_FLAVOR_CANON     , 0xd130, "CompressionS"},
    {USB_PTP_FLAVOR_FUJI      , 0xd130, "BKTOrder"},
    {USB_PTP_FLAVOR_NIKON     , 0xd130, "HDRMode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd130, "RecviewMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd131, "CompressionM1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd131, "BKTSelection"},
    {USB_PTP_FLAVOR_MTP       , 0xd131, "PlaysForSureID"},
    {USB_PTP_FLAVOR_NIKON     , 0xd131, "HDRHighDynamic"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd131, "SleepTime"},
    {USB_PTP_FLAVOR_CANON     , 0xd132, "CompressionM2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd132, "AEAFLockButton"},
    {USB_PTP_FLAVOR_MTP       , 0xd132, "ZUNE_UNKNOWN2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd132, "HDRSmoothing"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd132, "ManualWBGMBias"},
    {USB_PTP_FLAVOR_CANON     , 0xd133, "CompressionL"},
    {USB_PTP_FLAVOR_FUJI      , 0xd133, "CenterButton"},
    {USB_PTP_FLAVOR_NIKON     , 0xd133, "HDRSaveIndividualImages"},
    {USB_PTP_FLAVOR_CANON     , 0xd134, "IntervalShootSetting"},
    {USB_PTP_FLAVOR_FUJI      , 0xd134, "MultiSelectorButton"},
    {USB_PTP_FLAVOR_CANON     , 0xd135, "IntervalShootState"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd135, "AELAFLMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd136, "PushMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd136, "FunctionLock"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd136, "AELButtonStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd137, "LvCFilterKind"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd137, "CompressionSettingEx"},
    {USB_PTP_FLAVOR_CANON     , 0xd138, "AEModeDial"},
    {USB_PTP_FLAVOR_NIKON     , 0xd138, "VibrationReduction"},
    {USB_PTP_FLAVOR_CANON     , 0xd139, "AEModeCustom"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd139, "ToneMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd13a, "MirrorUpSetting"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd13a, "GradationMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd13b, "HighlightTonePriority"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd13b, "DevelopMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd13c, "AFSelectFocusArea"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd13c, "ExtendInnerFlashMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd13d, "HDRSetting"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd13d, "OutputDeviceMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd13e, "TimeShootSetting"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd13e, "LiveViewMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd13f, "NFCApplicationInfo"},
    {USB_PTP_FLAVOR_CANON     , 0xd140, "PCWhiteBalance1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd140, "OptimizeImage"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd140, "LCDBacklight"},
    {USB_PTP_FLAVOR_CANON     , 0xd141, "PCWhiteBalance2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd141, "WBAutoType"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd141, "CustomDevelop"},
    {USB_PTP_FLAVOR_CANON     , 0xd142, "PCWhiteBalance3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd142, "Saturation"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd142, "GradationAutoBias"},
    {USB_PTP_FLAVOR_CANON     , 0xd143, "PCWhiteBalance4"},
    {USB_PTP_FLAVOR_NIKON     , 0xd143, "BW_FillerEffect"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd143, "FlashRCMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd144, "PCWhiteBalance5"},
    {USB_PTP_FLAVOR_NIKON     , 0xd144, "BW_Sharpness"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd144, "FlashRCGroupValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd145, "MWhiteBalance"},
    {USB_PTP_FLAVOR_FUJI      , 0xd145, "Password"},
    {USB_PTP_FLAVOR_NIKON     , 0xd145, "BW_Contrast"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd145, "FlashRCChannelValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd146, "MWhiteBalanceEx"},
    {USB_PTP_FLAVOR_FUJI      , 0xd146, "ChangePassword"},
    {USB_PTP_FLAVOR_NIKON     , 0xd146, "BW_Setting_Type"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd146, "FlashRCFPMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd147, "CommandDialSetting1"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd147, "FlashRCPhotoChromicMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd148, "CommandDialSetting2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd148, "Slot2SaveMode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd148, "FlashRCPhotoChromicBias"},
    {USB_PTP_FLAVOR_CANON     , 0xd149, "PowerZoomSpeed"},
    {USB_PTP_FLAVOR_FUJI      , 0xd149, "CommandDialSetting3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd149, "RawBitMode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd149, "FlashRCPhotoChromicManualBias"},
    {USB_PTP_FLAVOR_CANON     , 0xd14a, "NetworkServerRegion"},
    {USB_PTP_FLAVOR_FUJI      , 0xd14a, "CommandDialSetting4"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd14a, "FlashRCQuantityLightLevel"},
    {USB_PTP_FLAVOR_CANON     , 0xd14b, "GPSLogCtrl"},
    {USB_PTP_FLAVOR_FUJI      , 0xd14b, "ButtonsAndDials"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd14b, "FocusMeteringValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd14c, "GPSLogListNum"},
    {USB_PTP_FLAVOR_FUJI      , 0xd14c, "NonCPULensData"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd14c, "ISOBracketingFrame"},
    {USB_PTP_FLAVOR_CANON     , 0xd14d, "UnknownPropD14D"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd14d, "ISOBracketingStep"},
    {USB_PTP_FLAVOR_FUJI      , 0xd14e, "MBD200Batteries"},
    {USB_PTP_FLAVOR_NIKON     , 0xd14e, "ActiveDLighting"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd14e, "BulbMFMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd14f, "AFOnForMBD200Batteries"},
    {USB_PTP_FLAVOR_NIKON     , 0xd14f, "FlourescentType"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd14f, "BurstFPSValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd150, "PictureStyleStandard"},
    {USB_PTP_FLAVOR_NIKON     , 0xd150, "TuneColourTemperature"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd150, "ISOAutoBaseValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd151, "PictureStylePortrait"},
    {USB_PTP_FLAVOR_NIKON     , 0xd151, "TunePreset0"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd151, "ISOAutoMaxValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd152, "PictureStyleLandscape"},
    {USB_PTP_FLAVOR_NIKON     , 0xd152, "TunePreset1"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd152, "BulbLimiterValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd153, "PictureStyleNeutral"},
    {USB_PTP_FLAVOR_FUJI      , 0xd153, "FirmwareVersion"},
    {USB_PTP_FLAVOR_NIKON     , 0xd153, "TunePreset2"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd153, "DPIMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd154, "PictureStyleFaithful"},
    {USB_PTP_FLAVOR_FUJI      , 0xd154, "ShotCount"},
    {USB_PTP_FLAVOR_NIKON     , 0xd154, "TunePreset3"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd154, "DPICustomValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd155, "PictureStyleBlackWhite"},
    {USB_PTP_FLAVOR_FUJI      , 0xd155, "ShutterExchangeCount"},
    {USB_PTP_FLAVOR_NIKON     , 0xd155, "TunePreset4"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd155, "ResolutionValueSetting"},
    {USB_PTP_FLAVOR_CANON     , 0xd156, "PictureStyleAuto"},
    {USB_PTP_FLAVOR_NIKON     , 0xd156, "PrimarySlot"},
    {USB_PTP_FLAVOR_CANON     , 0xd157, "PictureStyleExStandard"},
    {USB_PTP_FLAVOR_FUJI      , 0xd157, "WorldClock"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd157, "AFTargetSize"},
    {USB_PTP_FLAVOR_CANON     , 0xd158, "PictureStyleExPortrait"},
    {USB_PTP_FLAVOR_FUJI      , 0xd158, "TimeDifference1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd158, "WBPresetProtect1"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd158, "LightSensorMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd159, "PictureStyleExLandscape"},
    {USB_PTP_FLAVOR_FUJI      , 0xd159, "TimeDifference2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd159, "WBPresetProtect2"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd159, "AEBracket"},
    {USB_PTP_FLAVOR_CANON     , 0xd15a, "PictureStyleExNeutral"},
    {USB_PTP_FLAVOR_FUJI      , 0xd15a, "Language"},
    {USB_PTP_FLAVOR_NIKON     , 0xd15a, "WBPresetProtect3"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd15a, "WBRBBracket"},
    {USB_PTP_FLAVOR_CANON     , 0xd15b, "PictureStyleExFaithful"},
    {USB_PTP_FLAVOR_FUJI      , 0xd15b, "FrameNumberSequence"},
    {USB_PTP_FLAVOR_NIKON     , 0xd15b, "ActiveFolder"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd15b, "WBGMBracket"},
    {USB_PTP_FLAVOR_CANON     , 0xd15c, "PictureStyleExBlackWhite"},
    {USB_PTP_FLAVOR_FUJI      , 0xd15c, "VideoMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd15c, "WBPresetProtect4"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd15c, "FlashBracket"},
    {USB_PTP_FLAVOR_CANON     , 0xd15d, "PictureStyleExAuto"},
    {USB_PTP_FLAVOR_FUJI      , 0xd15d, "SetUSBMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd15d, "WhiteBalanceReset"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd15d, "ISOBracket"},
    {USB_PTP_FLAVOR_CANON     , 0xd15e, "PictureStyleExFineDetail"},
    {USB_PTP_FLAVOR_NIKON     , 0xd15e, "WhiteBalanceNaturalLightAutoBias"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd15e, "MyModeStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd160, "PictureStyleUserSet1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd160, "BeepOff"},
    {USB_PTP_FLAVOR_CANON     , 0xd161, "PictureStyleUserSet2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd161, "CommentWriteSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd161, "AutofocusMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd162, "PictureStyleUserSet3"},
    {USB_PTP_FLAVOR_FUJI      , 0xd162, "BCRAppendDelimiter"},
    {USB_PTP_FLAVOR_CANON     , 0xd163, "PictureStyleExUserSet1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd163, "AFAssist"},
    {USB_PTP_FLAVOR_CANON     , 0xd164, "PictureStyleExUserSet2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd164, "ISOAutoShutterTime"},
    {USB_PTP_FLAVOR_NIKON     , 0xd164, "PADVPMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd165, "PictureStyleExUserSet3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd165, "ImageReview"},
    {USB_PTP_FLAVOR_CANON     , 0xd166, "MovieAVModeFine"},
    {USB_PTP_FLAVOR_NIKON     , 0xd166, "AFAreaIllumination"},
    {USB_PTP_FLAVOR_CANON     , 0xd167, "ShutterReleaseCounter"},
    {USB_PTP_FLAVOR_FUJI      , 0xd167, "CommentEx"},
    {USB_PTP_FLAVOR_NIKON     , 0xd167, "FlashMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd168, "AvailableImageSize"},
    {USB_PTP_FLAVOR_FUJI      , 0xd168, "VideoOutOnOff"},
    {USB_PTP_FLAVOR_NIKON     , 0xd168, "FlashCommanderMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd169, "ErrorHistory"},
    {USB_PTP_FLAVOR_NIKON     , 0xd169, "FlashSign"},
    {USB_PTP_FLAVOR_CANON     , 0xd16a, "LensExchangeHistory"},
    {USB_PTP_FLAVOR_NIKON     , 0xd16a, "ISO_Auto"},
    {USB_PTP_FLAVOR_CANON     , 0xd16b, "StroboExchangeHistory"},
    {USB_PTP_FLAVOR_NIKON     , 0xd16b, "RemoteTimeout"},
    {USB_PTP_FLAVOR_NIKON     , 0xd16c, "GridDisplay"},
    {USB_PTP_FLAVOR_NIKON     , 0xd16d, "FlashModeManualPower"},
    {USB_PTP_FLAVOR_NIKON     , 0xd16e, "FlashModeCommanderPower"},
    {USB_PTP_FLAVOR_FUJI      , 0xd16f, "CropMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd16f, "AutoFP"},
    {USB_PTP_FLAVOR_CANON     , 0xd170, "PictureStyleParam1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd170, "LensZoomPos"},
    {USB_PTP_FLAVOR_NIKON     , 0xd170, "DateImprintSetting"},
    {USB_PTP_FLAVOR_CANON     , 0xd171, "PictureStyleParam2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd171, "FocusPosition"},
    {USB_PTP_FLAVOR_NIKON     , 0xd171, "DateCounterSelect"},
    {USB_PTP_FLAVOR_CANON     , 0xd172, "PictureStyleParam3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd172, "DateCountData"},
    {USB_PTP_FLAVOR_FUJI      , 0xd173, "LiveViewImageQuality"},
    {USB_PTP_FLAVOR_NIKON     , 0xd173, "DateCountDisplaySetting"},
    {USB_PTP_FLAVOR_CANON     , 0xd174, "MovieRecordVolumeLine"},
    {USB_PTP_FLAVOR_FUJI      , 0xd174, "LiveViewImageSize"},
    {USB_PTP_FLAVOR_NIKON     , 0xd174, "RangeFinderSetting"},
    {USB_PTP_FLAVOR_CANON     , 0xd175, "NetworkCommunicationMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd175, "LiveViewCondition"},
    {USB_PTP_FLAVOR_CANON     , 0xd176, "CanonLogGamma"},
    {USB_PTP_FLAVOR_FUJI      , 0xd176, "StandbyMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd176, "LimitedAFAreaMode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xd176, "DateTimeUTC"},
    {USB_PTP_FLAVOR_CANON     , 0xd177, "SmartphoneShowImageConfig"},
    {USB_PTP_FLAVOR_FUJI      , 0xd177, "LiveViewExposure"},
    {USB_PTP_FLAVOR_NIKON     , 0xd177, "AFModeRestrictions"},
    {USB_PTP_FLAVOR_CANON     , 0xd178, "HighISOSettingNoiseReduction"},
    {USB_PTP_FLAVOR_FUJI      , 0xd178, "LiveViewWhiteBalance"},
    {USB_PTP_FLAVOR_CANON     , 0xd179, "MovieServoAF"},
    {USB_PTP_FLAVOR_FUJI      , 0xd179, "LiveViewWhiteBalanceGain"},
    {USB_PTP_FLAVOR_CANON     , 0xd17a, "ContinuousAFValid"},
    {USB_PTP_FLAVOR_FUJI      , 0xd17a, "LiveViewTuning"},
    {USB_PTP_FLAVOR_NIKON     , 0xd17a, "LowLightAF"},
    {USB_PTP_FLAVOR_CANON     , 0xd17b, "Attenuator"},
    {USB_PTP_FLAVOR_NIKON     , 0xd17b, "ApplyLiveViewSetting"},
    {USB_PTP_FLAVOR_CANON     , 0xd17c, "UTCTime"},
    {USB_PTP_FLAVOR_FUJI      , 0xd17c, "FocusMeteringMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd17c, "MovieAfSpeed"},
    {USB_PTP_FLAVOR_CANON     , 0xd17d, "Timezone"},
    {USB_PTP_FLAVOR_FUJI      , 0xd17d, "FocusLength"},
    {USB_PTP_FLAVOR_NIKON     , 0xd17d, "MovieAfSpeedWhenToApply"},
    {USB_PTP_FLAVOR_CANON     , 0xd17e, "Summertime"},
    {USB_PTP_FLAVOR_FUJI      , 0xd17e, "CropAreaFrameInfo"},
    {USB_PTP_FLAVOR_NIKON     , 0xd17e, "MovieAfTrackingSensitivity"},
    {USB_PTP_FLAVOR_CANON     , 0xd17f, "FlavorLUTParams"},
    {USB_PTP_FLAVOR_FUJI      , 0xd17f, "ResetSetting"},
    {USB_PTP_FLAVOR_CANON     , 0xd180, "CustomFunc1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd180, "CSMMenu"},
    {USB_PTP_FLAVOR_CANON     , 0xd181, "CustomFunc2"},
    {USB_PTP_FLAVOR_MTP       , 0xd181, "ZUNE_UNKNOWN1"},
    {USB_PTP_FLAVOR_MTP       , 0xd181, "Zune_UnknownVersion"},
    {USB_PTP_FLAVOR_NIKON     , 0xd181, "WarningDisplay"},
    {USB_PTP_FLAVOR_CANON     , 0xd182, "CustomFunc3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd182, "BatteryCellKind"},
    {USB_PTP_FLAVOR_CANON     , 0xd183, "CustomFunc4"},
    {USB_PTP_FLAVOR_NIKON     , 0xd183, "ISOAutoHiLimit"},
    {USB_PTP_FLAVOR_CANON     , 0xd184, "CustomFunc5"},
    {USB_PTP_FLAVOR_FUJI      , 0xd184, "IOPCode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd184, "DynamicAFArea"},
    {USB_PTP_FLAVOR_CANON     , 0xd185, "CustomFunc6"},
    {USB_PTP_FLAVOR_CANON     , 0xd186, "CustomFunc7"},
    {USB_PTP_FLAVOR_FUJI      , 0xd186, "TetherRawConditionCode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd186, "ContinuousSpeedHigh"},
    {USB_PTP_FLAVOR_CANON     , 0xd187, "CustomFunc8"},
    {USB_PTP_FLAVOR_FUJI      , 0xd187, "TetherRawCompatibilityCode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd187, "InfoDispSetting"},
    {USB_PTP_FLAVOR_CANON     , 0xd188, "CustomFunc9"},
    {USB_PTP_FLAVOR_CANON     , 0xd189, "CustomFunc10"},
    {USB_PTP_FLAVOR_NIKON     , 0xd189, "PreviewButton"},
    {USB_PTP_FLAVOR_CANON     , 0xd18a, "CustomFunc11"},
    {USB_PTP_FLAVOR_NIKON     , 0xd18a, "PreviewButton2"},
    {USB_PTP_FLAVOR_CANON     , 0xd18b, "CustomFunc12"},
    {USB_PTP_FLAVOR_NIKON     , 0xd18b, "AEAFLockButton2"},
    {USB_PTP_FLAVOR_CANON     , 0xd18c, "CustomFunc13"},
    {USB_PTP_FLAVOR_CANON     , 0xd18d, "CustomFunc14"},
    {USB_PTP_FLAVOR_NIKON     , 0xd18d, "IndicatorDisp"},
    {USB_PTP_FLAVOR_CANON     , 0xd18e, "CustomFunc15"},
    {USB_PTP_FLAVOR_NIKON     , 0xd18e, "CellKindPriority"},
    {USB_PTP_FLAVOR_CANON     , 0xd18f, "CustomFunc16"},
    {USB_PTP_FLAVOR_CANON     , 0xd190, "CustomFunc17"},
    {USB_PTP_FLAVOR_NIKON     , 0xd190, "BracketingFramesAndSteps"},
    {USB_PTP_FLAVOR_CANON     , 0xd191, "CustomFunc18"},
    {USB_PTP_FLAVOR_CANON     , 0xd192, "CustomFunc19"},
    {USB_PTP_FLAVOR_CANON     , 0xd193, "InnerDevelop"},
    {USB_PTP_FLAVOR_CANON     , 0xd194, "MultiAspect"},
    {USB_PTP_FLAVOR_CANON     , 0xd195, "MovieSoundRecord"},
    {USB_PTP_FLAVOR_CANON     , 0xd196, "MovieRecordVolume"},
    {USB_PTP_FLAVOR_CANON     , 0xd197, "WindCut"},
    {USB_PTP_FLAVOR_NIKON     , 0xd197, "MovieReleaseButton"},
    {USB_PTP_FLAVOR_CANON     , 0xd198, "ExtenderType"},
    {USB_PTP_FLAVOR_CANON     , 0xd199, "OLCInfoVersion"},
    {USB_PTP_FLAVOR_NIKON     , 0xd199, "FlashISOAutoHighLimit"},
    {USB_PTP_FLAVOR_CANON     , 0xd19a, "UnknownPropD19A"},
    {USB_PTP_FLAVOR_CANON     , 0xd19c, "UnknownPropD19C"},
    {USB_PTP_FLAVOR_CANON     , 0xd19d, "UnknownPropD19D"},
    {USB_PTP_FLAVOR_CANON     , 0xd19f, "GPSDeviceActive"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a0, "CustomFuncEx"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a0, "LiveViewMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a1, "MyMenu"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a1, "LiveViewDriveMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a2, "MyMenuList"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a2, "LiveViewStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a3, "WftStatus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a3, "LiveViewImageZoomRatio"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a4, "WftInputTransmission"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a4, "LiveViewProhibitCondition"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a5, "HDDirectoryStructure"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a5, "LiveViewExposurePreview"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a6, "BatteryInfo"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a6, "LiveViewSelector"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a7, "AdapterInfo"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a7, "LiveViewWhiteBalance"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a8, "LensStatus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a8, "MovieShutterSpeed"},
    {USB_PTP_FLAVOR_CANON     , 0xd1a9, "QuickReviewTime"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1a9, "MovieFNumber"},
    {USB_PTP_FLAVOR_CANON     , 0xd1aa, "CardExtension"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1aa, "MovieISO"},
    {USB_PTP_FLAVOR_CANON     , 0xd1ab, "TempStatus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1ab, "MovieExposureBiasCompensation"},
    {USB_PTP_FLAVOR_CANON     , 0xd1ac, "ShutterCounter"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1ac, "LiveViewImageSize"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1ac, "LiveViewMovieMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1ad, "SpecialOption"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1ad, "LiveViewPhotography"},
    {USB_PTP_FLAVOR_CANON     , 0xd1ae, "PhotoStudioMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1af, "SerialNumber"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1af, "MovieExposureMeteringMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1b0, "EVFOutputDevice"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1b0, "ExposureDisplayStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd1b1, "EVFMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1b1, "ExposureIndicateStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd1b2, "DepthOfFieldPreview"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1b2, "InfoDispErrStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd1b3, "EVFSharpness"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1b3, "ExposureIndicateLightup"},
    {USB_PTP_FLAVOR_CANON     , 0xd1b4, "EVFWBMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1b4, "ContinuousShootingCount"},
    {USB_PTP_FLAVOR_CANON     , 0xd1b5, "EVFClickWBCoeffs"},
    {USB_PTP_FLAVOR_CANON     , 0xd1b6, "EVFColorTemp"},
    {USB_PTP_FLAVOR_CANON     , 0xd1b7, "ExposureSimMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1b7, "MovieRecFrameCount"},
    {USB_PTP_FLAVOR_CANON     , 0xd1b8, "EVFRecordStatus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1b8, "CameraLiveViewStatus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1b9, "DetectionPeaking"},
    {USB_PTP_FLAVOR_CANON     , 0xd1ba, "LvAfSystem"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1ba, "LiveViewTFTStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd1bb, "MovSize"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1bb, "LiveViewImageStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd1bc, "LvViewTypeSelect"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1bc, "LiveViewImageCompression"},
    {USB_PTP_FLAVOR_CANON     , 0xd1bd, "MirrorDownStatus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1bd, "LiveViewZoomArea"},
    {USB_PTP_FLAVOR_CANON     , 0xd1be, "MovieParam"},
    {USB_PTP_FLAVOR_CANON     , 0xd1bf, "MirrorLockupState"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c0, "FlashChargingState"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1c0, "FlashOpen"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c1, "AloMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1c1, "FlashCharged"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c2, "FixedMovie"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c3, "OneShotRawOn"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c4, "ErrorForDisplay"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c5, "AEModeMovie"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c6, "BuiltinStroboMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c7, "StroboDispState"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c8, "StroboETTL2Metering"},
    {USB_PTP_FLAVOR_CANON     , 0xd1c9, "ContinuousAFMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1ca, "MovieParam2"},
    {USB_PTP_FLAVOR_CANON     , 0xd1cb, "StroboSettingExpComposition"},
    {USB_PTP_FLAVOR_CANON     , 0xd1cc, "MovieParam3"},
    {USB_PTP_FLAVOR_CANON     , 0xd1cd, "MovieParam4"},
    {USB_PTP_FLAVOR_CANON     , 0xd1cf, "LVMedicalRotate"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d0, "Artist"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d0, "FlashMRepeatValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d1, "Copyright"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d1, "FlashMRepeatCount"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d2, "BracketValue"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d2, "FlashMRepeatInterval"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d3, "FocusInfoEx"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d3, "FlashCommandChannel"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d4, "DepthOfField"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d4, "FlashCommandSelfMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d5, "Brightness"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d5, "FlashCommandSelfCompensation"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d6, "LensAdjustParams"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d6, "FlashCommandSelfValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d7, "EFComp"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d7, "FlashCommandAMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d8, "LensName"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d8, "FlashCommandACompensation"},
    {USB_PTP_FLAVOR_CANON     , 0xd1d9, "AEB"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1d9, "FlashCommandAValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd1da, "StroboSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1da, "FlashCommandBMode"},
    {USB_PTP_FLAVOR_CANON     , 0xd1db, "StroboWirelessSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1db, "FlashCommandBCompensation"},
    {USB_PTP_FLAVOR_CANON     , 0xd1dc, "StroboFiring"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1dc, "FlashCommandBValue"},
    {USB_PTP_FLAVOR_CANON     , 0xd1dd, "LensID"},
    {USB_PTP_FLAVOR_CANON     , 0xd1de, "LCDBrightness"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1de, "ExternalRecordingControl"},
    {USB_PTP_FLAVOR_CANON     , 0xd1df, "CADarkBright"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1df, "HighlightBrightness"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1e2, "SBWirelessMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1e3, "SBWirelessMultipleFlashMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1e4, "SBUsableGroup"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1e5, "WirelessCLSEntryMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1e6, "SBPINCode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1e7, "RadioMultipleFlashChannel"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1e8, "OpticalMultipleFlashChannel"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1e9, "FlashRangeDisplay"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1ea, "AllTestFiringDisable"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1ec, "SBSettingMemberLock"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1ed, "SBIntegrationFlashReady"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1f0, "ApplicationMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1f1, "ExposureRemaining"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1f2, "ActiveSlot"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1f4, "ISOAutoShutterCorrectionTime"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1f6, "MirrorUpStatus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1f7, "MirrorUpReleaseShootingCount"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1f8, "MovieAfAreaMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1f9, "MovieVibrationReduction"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1fa, "MovieFocusMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1fb, "RecordTimeCodes"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1fc, "CountUpMethod"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1fd, "TimeCodeOrigin"},
    {USB_PTP_FLAVOR_NIKON     , 0xd1fe, "DropFrame"},
    {USB_PTP_FLAVOR_FUJI      , 0xd200, "LightTune"},
    {USB_PTP_FLAVOR_NIKON     , 0xd200, "ActivePicCtrlItem"},
    {USB_PTP_FLAVOR_SONY      , 0xd200, "DPCCompensation"},
    {USB_PTP_FLAVOR_CANON     , 0xd201, "CAssistPreset"},
    {USB_PTP_FLAVOR_FUJI      , 0xd201, "ReleaseMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd201, "ChangePicCtrlItem"},
    {USB_PTP_FLAVOR_PARROT    , 0xd201, "PhotoSensorEnableMask"},
    {USB_PTP_FLAVOR_SONY      , 0xd201, "DRangeOptimize"},
    {USB_PTP_FLAVOR_CANON     , 0xd202, "CAssistBrightness"},
    {USB_PTP_FLAVOR_FUJI      , 0xd202, "BKTFrame1"},
    {USB_PTP_FLAVOR_PARROT    , 0xd202, "PhotoSensorsKeepOn"},
    {USB_PTP_FLAVOR_CANON     , 0xd203, "CAssistContrast"},
    {USB_PTP_FLAVOR_FUJI      , 0xd203, "BKTFrame2"},
    {USB_PTP_FLAVOR_PARROT    , 0xd203, "MultispectralImageSize"},
    {USB_PTP_FLAVOR_SONY      , 0xd203, "ImageSize"},
    {USB_PTP_FLAVOR_CANON     , 0xd204, "CAssistSaturation"},
    {USB_PTP_FLAVOR_FUJI      , 0xd204, "BKTStep"},
    {USB_PTP_FLAVOR_PARROT    , 0xd204, "MainBitDepth"},
    {USB_PTP_FLAVOR_CANON     , 0xd205, "CAssistColorBA"},
    {USB_PTP_FLAVOR_FUJI      , 0xd205, "ProgramShift"},
    {USB_PTP_FLAVOR_PARROT    , 0xd205, "MultispectralBitDepth"},
    {USB_PTP_FLAVOR_CANON     , 0xd206, "CAssistColorMG"},
    {USB_PTP_FLAVOR_FUJI      , 0xd206, "FocusAreas"},
    {USB_PTP_FLAVOR_PARROT    , 0xd206, "HeatingEnable"},
    {USB_PTP_FLAVOR_CANON     , 0xd207, "CAssistMonochrome"},
    {USB_PTP_FLAVOR_FUJI      , 0xd207, "PriorityMode"},
    {USB_PTP_FLAVOR_PARROT    , 0xd207, "WifiStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xd208, "FocusShiftSetting"},
    {USB_PTP_FLAVOR_PARROT    , 0xd208, "WifiSSID"},
    {USB_PTP_FLAVOR_CANON     , 0xd209, "MovieSelfTimer"},
    {USB_PTP_FLAVOR_FUJI      , 0xd209, "AFStatus"},
    {USB_PTP_FLAVOR_PARROT    , 0xd209, "WifiEncryptionType"},
    {USB_PTP_FLAVOR_PARROT    , 0xd20a, "WifiPassphrase"},
    {USB_PTP_FLAVOR_CANON     , 0xd20b, "Clarity"},
    {USB_PTP_FLAVOR_FUJI      , 0xd20b, "DeviceName"},
    {USB_PTP_FLAVOR_PARROT    , 0xd20b, "WifiChannel"},
    {USB_PTP_FLAVOR_CANON     , 0xd20c, "2GHDRSetting"},
    {USB_PTP_FLAVOR_FUJI      , 0xd20c, "MediaRecord"},
    {USB_PTP_FLAVOR_PARROT    , 0xd20c, "Localization"},
    {USB_PTP_FLAVOR_CANON     , 0xd20d, "MovieParam5"},
    {USB_PTP_FLAVOR_FUJI      , 0xd20d, "MediaCapacity"},
    {USB_PTP_FLAVOR_NIKON     , 0xd20d, "ElectronicFrontCurtainShutter"},
    {USB_PTP_FLAVOR_PARROT    , 0xd20d, "WifiMode"},
    {USB_PTP_FLAVOR_SONY      , 0xd20d, "ShutterSpeed"},
    {USB_PTP_FLAVOR_CANON     , 0xd20e, "HDRViewAssistModeRec"},
    {USB_PTP_FLAVOR_FUJI      , 0xd20e, "FreeSDRAMImages"},
    {USB_PTP_FLAVOR_NIKON     , 0xd20e, "MovieResetShootingMenu"},
    {USB_PTP_FLAVOR_NIKON     , 0xd20f, "MovieCaptureAreaCrop"},
    {USB_PTP_FLAVOR_SONY      , 0xd20f, "ColorTemp"},
    {USB_PTP_FLAVOR_NIKON     , 0xd210, "MovieAutoDxCrop"},
    {USB_PTP_FLAVOR_PARROT    , 0xd210, "AntiFlickeringFrequency"},
    {USB_PTP_FLAVOR_SONY      , 0xd210, "CCFilter"},
    {USB_PTP_FLAVOR_FUJI      , 0xd211, "MediaStatus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd211, "MovieWbAutoType"},
    {USB_PTP_FLAVOR_PARROT    , 0xd211, "DisplayOverlayMask"},
    {USB_PTP_FLAVOR_SONY      , 0xd211, "AspectRatio"},
    {USB_PTP_FLAVOR_FUJI      , 0xd212, "CurrentState"},
    {USB_PTP_FLAVOR_NIKON     , 0xd212, "MovieWbTuneAuto"},
    {USB_PTP_FLAVOR_PARROT    , 0xd212, "GPSInterval"},
    {USB_PTP_FLAVOR_FUJI      , 0xd213, "AELock2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd213, "MovieWbTuneIncandescent"},
    {USB_PTP_FLAVOR_PARROT    , 0xd213, "MultisensorsExposureMeteringMode"},
    {USB_PTP_FLAVOR_SONY      , 0xd213, "FocusFound"},
    {USB_PTP_FLAVOR_CANON     , 0xd214, "PropFinderAFFrame"},
    {USB_PTP_FLAVOR_NIKON     , 0xd214, "MovieWbFlourescentType"},
    {USB_PTP_FLAVOR_PARROT    , 0xd214, "MultisensorsExposureTime"},
    {USB_PTP_FLAVOR_SONY      , 0xd214, "Zoom"},
    {USB_PTP_FLAVOR_CANON     , 0xd215, "VariableMovieRecSetting"},
    {USB_PTP_FLAVOR_FUJI      , 0xd215, "Copyright"},
    {USB_PTP_FLAVOR_MTP       , 0xd215, "ZUNE_UNKNOWN3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd215, "MovieWbTuneFlourescent"},
    {USB_PTP_FLAVOR_PARROT    , 0xd215, "MultisensorsExposureProgramMode"},
    {USB_PTP_FLAVOR_SONY      , 0xd215, "ObjectInMemory"},
    {USB_PTP_FLAVOR_CANON     , 0xd216, "PropAutoRotate"},
    {USB_PTP_FLAVOR_FUJI      , 0xd216, "Copyright2"},
    {USB_PTP_FLAVOR_MTP       , 0xd216, "ZUNE_UNKNOWN4"},
    {USB_PTP_FLAVOR_NIKON     , 0xd216, "MovieWbTuneSunny"},
    {USB_PTP_FLAVOR_PARROT    , 0xd216, "MultisensorsExposureIndex"},
    {USB_PTP_FLAVOR_SONY      , 0xd216, "ExposeIndex"},
    {USB_PTP_FLAVOR_CANON     , 0xd217, "MFPeakingSetting"},
    {USB_PTP_FLAVOR_PARROT    , 0xd217, "MultisensorsIrradianceGain"},
    {USB_PTP_FLAVOR_CANON     , 0xd218, "MovieSpatialOversampling"},
    {USB_PTP_FLAVOR_FUJI      , 0xd218, "Aperture"},
    {USB_PTP_FLAVOR_NIKON     , 0xd218, "MovieWbTuneCloudy"},
    {USB_PTP_FLAVOR_PARROT    , 0xd218, "MultisensorsIrradianceIntegrationTime"},
    {USB_PTP_FLAVOR_SONY      , 0xd218, "BatteryLevel"},
    {USB_PTP_FLAVOR_CANON     , 0xd219, "MovieCropMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd219, "ShutterSpeed"},
    {USB_PTP_FLAVOR_NIKON     , 0xd219, "MovieWbTuneShade"},
    {USB_PTP_FLAVOR_PARROT    , 0xd219, "OverlapRate"},
    {USB_PTP_FLAVOR_SONY      , 0xd219, "SensorCrop"},
    {USB_PTP_FLAVOR_CANON     , 0xd21a, "ShutterType"},
    {USB_PTP_FLAVOR_NIKON     , 0xd21a, "MovieWbColorTemp"},
    {USB_PTP_FLAVOR_CANON     , 0xd21b, "WFTBatteryPower"},
    {USB_PTP_FLAVOR_FUJI      , 0xd21b, "DeviceError"},
    {USB_PTP_FLAVOR_NIKON     , 0xd21b, "MovieWbTuneColorTemp"},
    {USB_PTP_FLAVOR_SONY      , 0xd21b, "PictureEffect"},
    {USB_PTP_FLAVOR_CANON     , 0xd21c, "BatteryInfoEx"},
    {USB_PTP_FLAVOR_NIKON     , 0xd21c, "MovieWbPresetData0"},
    {USB_PTP_FLAVOR_SONY      , 0xd21c, "ABFilter"},
    {USB_PTP_FLAVOR_NIKON     , 0xd21d, "MovieWbPresetDataComment1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd21e, "MovieWbPresetDataComment2"},
    {USB_PTP_FLAVOR_SONY      , 0xd21e, "ISO"},
    {USB_PTP_FLAVOR_NIKON     , 0xd21f, "MovieWbPresetDataComment3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd220, "MovieWbPresetDataComment4"},
    {USB_PTP_FLAVOR_NIKON     , 0xd221, "MovieWbPresetDataComment5"},
    {USB_PTP_FLAVOR_FUJI      , 0xd222, "SensitivityFineTune1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd222, "MovieWbPresetDataComment6"},
    {USB_PTP_FLAVOR_SONY      , 0xd222, "StillImageStoreDestination"},
    {USB_PTP_FLAVOR_FUJI      , 0xd223, "SensitivityFineTune2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd223, "MovieWbPresetDataValue1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd224, "MovieWbPresetDataValue2"},
    {USB_PTP_FLAVOR_SONY      , 0xd224, "ExposureCompensation"},
    {USB_PTP_FLAVOR_NIKON     , 0xd225, "MovieWbPresetDataValue3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd226, "MovieWbPresetDataValue4"},
    {USB_PTP_FLAVOR_SONY      , 0xd226, "ISO2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd227, "MovieWbPresetDataValue5"},
    {USB_PTP_FLAVOR_NIKON     , 0xd228, "MovieWbPresetDataValue6"},
    {USB_PTP_FLAVOR_FUJI      , 0xd229, "CaptureRemaining"},
    {USB_PTP_FLAVOR_NIKON     , 0xd229, "MovieWbTunePreset1"},
    {USB_PTP_FLAVOR_SONY      , 0xd229, "ShutterSpeed2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd22a, "MovieRemainingTime"},
    {USB_PTP_FLAVOR_NIKON     , 0xd22a, "MovieWbTunePreset2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd22b, "MovieWbTunePreset3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd22c, "MovieWbTunePreset4"},
    {USB_PTP_FLAVOR_NIKON     , 0xd22d, "MovieWbTunePreset5"},
    {USB_PTP_FLAVOR_NIKON     , 0xd22e, "MovieWbTunePreset6"},
    {USB_PTP_FLAVOR_NIKON     , 0xd22f, "MovieWbPresetProtect1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd230, "ForceMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd230, "MovieWbPresetProtect2"},
    {USB_PTP_FLAVOR_NIKON     , 0xd231, "MovieWbPresetProtect3"},
    {USB_PTP_FLAVOR_NIKON     , 0xd232, "MovieWbPresetProtect4"},
    {USB_PTP_FLAVOR_NIKON     , 0xd233, "MovieWbPresetProtect5"},
    {USB_PTP_FLAVOR_NIKON     , 0xd234, "MovieWbPresetProtect6"},
    {USB_PTP_FLAVOR_NIKON     , 0xd235, "MovieWhiteBalanceReset"},
    {USB_PTP_FLAVOR_NIKON     , 0xd236, "MovieNrHighISO"},
    {USB_PTP_FLAVOR_NIKON     , 0xd237, "MovieActivePicCtrlItem"},
    {USB_PTP_FLAVOR_NIKON     , 0xd238, "MovieChangePicCtrlItem"},
    {USB_PTP_FLAVOR_NIKON     , 0xd239, "ExposureBaseCompHighlight"},
    {USB_PTP_FLAVOR_NIKON     , 0xd23a, "MovieWhiteBalance"},
    {USB_PTP_FLAVOR_NIKON     , 0xd23b, "MovieActiveDLighting"},
    {USB_PTP_FLAVOR_NIKON     , 0xd23c, "MovieWbTuneNatural"},
    {USB_PTP_FLAVOR_NIKON     , 0xd23d, "MovieAttenuator"},
    {USB_PTP_FLAVOR_NIKON     , 0xd23e, "MovieVignetteControl"},
    {USB_PTP_FLAVOR_NIKON     , 0xd23f, "MovieDiffractionCompensation"},
    {USB_PTP_FLAVOR_FUJI      , 0xd240, "ShutterSpeed2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd241, "ImageAspectRatio"},
    {USB_PTP_FLAVOR_NIKON     , 0xd241, "D241"},
    {USB_PTP_FLAVOR_FUJI      , 0xd242, "BatteryLevel"},
    {USB_PTP_FLAVOR_NIKON     , 0xd244, "D244"},
    {USB_PTP_FLAVOR_NIKON     , 0xd247, "D247"},
    {USB_PTP_FLAVOR_NIKON     , 0xd24f, "GUID"},
    {USB_PTP_FLAVOR_NIKON     , 0xd250, "D250"},
    {USB_PTP_FLAVOR_NIKON     , 0xd251, "D251"},
    {USB_PTP_FLAVOR_SONY      , 0xd2c1, "AutoFocus"},
    {USB_PTP_FLAVOR_SONY      , 0xd2c2, "Capture"},
    {USB_PTP_FLAVOR_SONY      , 0xd2c7, "StillImage"},
    {USB_PTP_FLAVOR_SONY      , 0xd2c8, "Movie"},
    {USB_PTP_FLAVOR_SONY      , 0xd2d1, "NearFar"},
    {USB_PTP_FLAVOR_SONY      , 0xd2dc, "AF_Area_Position"},
    {USB_PTP_FLAVOR_NIKON     , 0xd303, "UseDeviceStageFlag"},
    {USB_PTP_FLAVOR_NIKON     , 0xd304, "MovieCaptureMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd305, "SlowMotionMovieRecordScreenSize"},
    {USB_PTP_FLAVOR_NIKON     , 0xd306, "HighSpeedStillCaptureRate"},
    {USB_PTP_FLAVOR_NIKON     , 0xd307, "BestMomentCaptureMode"},
    {USB_PTP_FLAVOR_NIKON     , 0xd308, "ActiveSelectionFrameSavedDefault"},
    {USB_PTP_FLAVOR_NIKON     , 0xd309, "ActiveSelectionCapture40frameOver"},
    {USB_PTP_FLAVOR_FUJI      , 0xd310, "TotalShotCount"},
    {USB_PTP_FLAVOR_NIKON     , 0xd310, "ActiveSelectionOnReleaseRecord"},
    {USB_PTP_FLAVOR_NIKON     , 0xd311, "ActiveSelectionSelectedPictures"},
    {USB_PTP_FLAVOR_NIKON     , 0xd312, "ExposureRemainingInMovie"},
    {USB_PTP_FLAVOR_NIKON     , 0xd313, "OpticalVR"},
    {USB_PTP_FLAVOR_NIKON     , 0xd314, "ElectronicVR"},
    {USB_PTP_FLAVOR_NIKON     , 0xd315, "SilentPhotography"},
    {USB_PTP_FLAVOR_NIKON     , 0xd316, "FacePriority"},
    {USB_PTP_FLAVOR_NIKON     , 0xd317, "LensTypeNikon1"},
    {USB_PTP_FLAVOR_NIKON     , 0xd318, "ISONoiseReduction"},
    {USB_PTP_FLAVOR_FUJI      , 0xd320, "HighLightTone"},
    {USB_PTP_FLAVOR_FUJI      , 0xd321, "ShadowTone"},
    {USB_PTP_FLAVOR_FUJI      , 0xd322, "LongExposureNR"},
    {USB_PTP_FLAVOR_FUJI      , 0xd323, "FullTimeManualFocus"},
    {USB_PTP_FLAVOR_NIKON     , 0xd323, "MovieLoopLength"},
    {USB_PTP_FLAVOR_FUJI      , 0xd332, "ISODialHn1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd333, "ISODialHn2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd33f, "ViewMode1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd340, "ViewMode2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd343, "DispInfoMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd346, "LensISSwitch"},
    {USB_PTP_FLAVOR_FUJI      , 0xd347, "FocusPoint"},
    {USB_PTP_FLAVOR_FUJI      , 0xd34a, "InstantAFMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd34b, "PreAFMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd34c, "CustomSetting"},
    {USB_PTP_FLAVOR_FUJI      , 0xd34d, "LMOMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd34e, "LockButtonMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd34f, "AFLockMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd350, "MicJackMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd351, "ISMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd352, "DateTimeDispFormat"},
    {USB_PTP_FLAVOR_FUJI      , 0xd353, "AeAfLockKeyAssign"},
    {USB_PTP_FLAVOR_FUJI      , 0xd354, "CrossKeyAssign"},
    {USB_PTP_FLAVOR_FUJI      , 0xd355, "SilentMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd356, "PBSound"},
    {USB_PTP_FLAVOR_FUJI      , 0xd358, "EVFDispAutoRotate"},
    {USB_PTP_FLAVOR_FUJI      , 0xd359, "ExposurePreview"},
    {USB_PTP_FLAVOR_FUJI      , 0xd35a, "DispBrightness1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd35b, "DispBrightness2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd35c, "DispChroma1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd35d, "DispChroma2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd35e, "FocusCheckMode"},
    {USB_PTP_FLAVOR_FUJI      , 0xd35f, "FocusScaleUnit"},
    {USB_PTP_FLAVOR_FUJI      , 0xd361, "SetFunctionButton"},
    {USB_PTP_FLAVOR_FUJI      , 0xd363, "SensorCleanTiming"},
    {USB_PTP_FLAVOR_FUJI      , 0xd364, "CustomAutoPowerOff"},
    {USB_PTP_FLAVOR_FUJI      , 0xd365, "FileNamePrefix1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd366, "FileNamePrefix2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd36a, "BatteryInfo1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd36b, "BatteryInfo2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd36d, "LensNameAndSerial"},
    {USB_PTP_FLAVOR_FUJI      , 0xd36e, "CustomDispInfo"},
    {USB_PTP_FLAVOR_FUJI      , 0xd36f, "FunctionLockCategory1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd370, "FunctionLockCategory2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd371, "CustomPreviewTime"},
    {USB_PTP_FLAVOR_FUJI      , 0xd372, "FocusArea1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd373, "FocusArea2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd374, "FocusArea3"},
    {USB_PTP_FLAVOR_FUJI      , 0xd375, "FrameGuideGridInfo1"},
    {USB_PTP_FLAVOR_FUJI      , 0xd376, "FrameGuideGridInfo2"},
    {USB_PTP_FLAVOR_FUJI      , 0xd377, "FrameGuideGridInfo3"},
    {USB_PTP_FLAVOR_FUJI      , 0xd378, "FrameGuideGridInfo4"},
    {USB_PTP_FLAVOR_FUJI      , 0xd38a, "LensUnknownData"},
    {USB_PTP_FLAVOR_FUJI      , 0xd38c, "LensZoomPosCaps"},
    {USB_PTP_FLAVOR_FUJI      , 0xd38d, "LensFNumberList"},
    {USB_PTP_FLAVOR_FUJI      , 0xd38e, "LensFocalLengthList"},
    {USB_PTP_FLAVOR_FUJI      , 0xd390, "FocusLimiter"},
    {USB_PTP_FLAVOR_FUJI      , 0xd395, "FocusArea4"},
    {USB_PTP_FLAVOR_MTP       , 0xd401, "SynchronizationPartner"},
    {USB_PTP_FLAVOR_MTP       , 0xd402, "DeviceFriendlyName"},
    {USB_PTP_FLAVOR_MTP       , 0xd403, "VolumeLevel"},
    {USB_PTP_FLAVOR_MTP       , 0xd405, "DeviceIcon"},
    {USB_PTP_FLAVOR_MTP       , 0xd406, "SessionInitiatorInfo"},
    {USB_PTP_FLAVOR_MTP       , 0xd407, "PerceivedDeviceType"},
    {USB_PTP_FLAVOR_MTP       , 0xd410, "PlaybackRate"},
    {USB_PTP_FLAVOR_MTP       , 0xd411, "PlaybackObject"},
    {USB_PTP_FLAVOR_MTP       , 0xd412, "PlaybackContainerIndex"},
    {USB_PTP_FLAVOR_MTP       , 0xd413, "PlaybackPosition"},
    {USB_PTP_FLAVOR_SONY      , 0xd60e, "Zoom_Absolute"},
    {USB_PTP_FLAVOR_SONY      , 0xd60f, "Movie_Rec"},
    {USB_PTP_FLAVOR_SONY      , 0xd612, "Request_For_Update"},
    {USB_PTP_FLAVOR_SONY      , 0xd613, "Zoom_Wide_For_One_Shot"},
    {USB_PTP_FLAVOR_SONY      , 0xd614, "Zoom_Tele_For_One_Shot"},
    {USB_PTP_FLAVOR_SONY      , 0xd617, "Capture"},
    {USB_PTP_FLAVOR_SONY      , 0xd617, "S2_Button"},
    {USB_PTP_FLAVOR_SONY      , 0xd61c, "Media_Format"},
    {USB_PTP_FLAVOR_SONY      , 0xd61d, "AutoFocus"},
    {USB_PTP_FLAVOR_SONY      , 0xd61d, "S1_Button"},
    {USB_PTP_FLAVOR_SONY      , 0xd61e, "AE_Lock"},
    {USB_PTP_FLAVOR_SONY      , 0xd620, "PictureProfileInitialize"},
    {USB_PTP_FLAVOR_SONY      , 0xd621, "PictureProfile"},
    {USB_PTP_FLAVOR_SONY      , 0xd622, "AFSPrioritySetting"},
    {USB_PTP_FLAVOR_SONY      , 0xd623, "AFCPrioritySetting"},
    {USB_PTP_FLAVOR_SONY      , 0xd624, "LensUpdateState"},
    {USB_PTP_FLAVOR_SONY      , 0xd625, "Request_For_Update_For_Lens"},
    {USB_PTP_FLAVOR_SONY      , 0xd626, "SilentShooting"},
    {USB_PTP_FLAVOR_SONY      , 0xd627, "HDMIInfoDisplay"},
    {USB_PTP_FLAVOR_SONY      , 0xd628, "TCUBDisp"},
    {USB_PTP_FLAVOR_SONY      , 0xd629, "TCPreset"},
    {USB_PTP_FLAVOR_SONY      , 0xd62a, "TCMake"},
    {USB_PTP_FLAVOR_SONY      , 0xd62b, "TCRun"},
    {USB_PTP_FLAVOR_SONY      , 0xd62c, "UBPreset"},
    {USB_PTP_FLAVOR_SONY      , 0xd62d, "TCFormat"},
    {USB_PTP_FLAVOR_SONY      , 0xd62e, "LongExposureNR"},
    {USB_PTP_FLAVOR_SONY      , 0xd62f, "UBTimeRec"},
    {USB_PTP_FLAVOR_SONY      , 0xd637, "Power_Off"},
    {USB_PTP_FLAVOR_SONY      , 0xd638, "RequestOneShooting"},
    {USB_PTP_FLAVOR_SONY      , 0xd63b, "AF_Lock"},
    {USB_PTP_FLAVOR_SONY      , 0xd63c, "Zoom_Tele"},
    {USB_PTP_FLAVOR_SONY      , 0xd63e, "Zoom_Wide"},
    {USB_PTP_FLAVOR_SONY      , 0xd641, "Focus_Magnification"},
    {USB_PTP_FLAVOR_SONY      , 0xd6a1, "Focus_Near_For_One_Shot"},
    {USB_PTP_FLAVOR_SONY      , 0xd6a2, "Focus_Far_For_One_Shot"},
    {USB_PTP_FLAVOR_SONY      , 0xd6a3, "Focus_Near_For_Continuous"},
    {USB_PTP_FLAVOR_SONY      , 0xd6a4, "Focus_Far_For_Continuous"},
    {USB_PTP_FLAVOR_SONY      , 0xd6a7, "FocusMagnificationLevel"},
    {USB_PTP_FLAVOR_SONY      , 0xd6a8, "FocusMagnificationPosition"},
    {USB_PTP_FLAVOR_SONY      , 0xd6a9, "LensStatus"},
    {USB_PTP_FLAVOR_SONY      , 0xd6aa, "LiveviewResolution"},
    {USB_PTP_FLAVOR_SONY      , 0xd6af, "NotifyFocusPosition"},
    {USB_PTP_FLAVOR_SONY      , 0xd6b0, "DriveMode"},
    {USB_PTP_FLAVOR_SONY      , 0xd6b1, "DateTime"},
    {USB_PTP_FLAVOR_SONY      , 0xd6b3, "AspectRatio"},
    {USB_PTP_FLAVOR_SONY      , 0xd6b7, "ImageSize"},
    {USB_PTP_FLAVOR_SONY      , 0xd6b8, "WhiteBalance"},
    {USB_PTP_FLAVOR_SONY      , 0xd6b9, "CompressionSetting"},
    {USB_PTP_FLAVOR_SONY      , 0xd6ba, "CautionError"},
    {USB_PTP_FLAVOR_SONY      , 0xd6bb, "StorageInformation"},
    {USB_PTP_FLAVOR_SONY      , 0xd6bc, "MovieQualitySetting"},
    {USB_PTP_FLAVOR_SONY      , 0xd6bd, "MovieFormatSetting"},
    {USB_PTP_FLAVOR_SONY      , 0xd6be, "ZoomSetAbsolute"},
    {USB_PTP_FLAVOR_SONY      , 0xd6bf, "ZoomInformation"},
    {USB_PTP_FLAVOR_SONY      , 0xd6c1, "FocusSpeedForOneShot"},
    {USB_PTP_FLAVOR_SONY      , 0xd6c2, "FlashCompensation"},
    {USB_PTP_FLAVOR_SONY      , 0xd6c3, "ExposureCompensation"},
    {USB_PTP_FLAVOR_SONY      , 0xd6c5, "Aperture"},
    {USB_PTP_FLAVOR_SONY      , 0xd6c6, "ShootingFileInformation"},
    {USB_PTP_FLAVOR_SONY      , 0xd6c7, "MediaFormatState"},
    {USB_PTP_FLAVOR_SONY      , 0xd6c9, "ZoomMode"},
    {USB_PTP_FLAVOR_SONY      , 0xd6ca, "FlashMode"},
    {USB_PTP_FLAVOR_SONY      , 0xd6cb, "FocusMode"},
    {USB_PTP_FLAVOR_SONY      , 0xd6cc, "ExposureMode"},
    {USB_PTP_FLAVOR_SONY      , 0xd6cd, "MovieRecordingState"},
    {USB_PTP_FLAVOR_SONY      , 0xd6cf, "SelectSaveMedia"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d0, "StillSteady"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d1, "MovieSteady"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d2, "Housing"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d3, "K4OutputSetting"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d4, "HDMIRECControl"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d5, "TimeCodeOutputToHDMI"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d6, "HDMIResolution"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d7, "NTSC_PAL_Selector"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d8, "HDMIOutput"},
    {USB_PTP_FLAVOR_SONY      , 0xd6d9, "Camera_Setting_Reset"},
    {USB_PTP_FLAVOR_SONY      , 0xd6da, "Camera_Initialize"},
    {USB_PTP_FLAVOR_SONY      , 0xd6db, "ISOAutoMinimum"},
    {USB_PTP_FLAVOR_SONY      , 0xd6dc, "ISOAutoMaximum"},
    {USB_PTP_FLAVOR_SONY      , 0xd6dd, "APSCSuper35mm"},
    {USB_PTP_FLAVOR_SONY      , 0xd6de, "LiveviewStatus"},
    {USB_PTP_FLAVOR_SONY      , 0xd6df, "WhiteBalanceInitialize"},
    {USB_PTP_FLAVOR_SONY      , 0xd6e2, "OperatingMode"},
    {USB_PTP_FLAVOR_SONY      , 0xd6e3, "BiaxialFineTuningABDirection"},
    {USB_PTP_FLAVOR_SONY      , 0xd6e5, "HighISONr"},
    {USB_PTP_FLAVOR_SONY      , 0xd6e8, "AELockIndication"},
    {USB_PTP_FLAVOR_SONY      , 0xd6e9, "ElectronicFrontCurtainShutter"},
    {USB_PTP_FLAVOR_SONY      , 0xd6ea, "ShutterSpeed"},
    {USB_PTP_FLAVOR_SONY      , 0xd6ec, "FocusIndication"},
    {USB_PTP_FLAVOR_SONY      , 0xd6ef, "BiaxialFineTuningGMDirection"},
    {USB_PTP_FLAVOR_SONY      , 0xd6f0, "ColorTemperature"},
    {USB_PTP_FLAVOR_SONY      , 0xd6f1, "BatteryLevelIndication"},
    {USB_PTP_FLAVOR_SONY      , 0xd6f2, "ISO"},
    {USB_PTP_FLAVOR_SONY      , 0xd6f3, "AutoSlowShutter"},
    {USB_PTP_FLAVOR_SONY      , 0xd6fe, "DynamicRangeOptimizer"},
    {USB_PTP_FLAVOR_FUJI      , 0xdf01, "InitSequence"},
    {USB_PTP_FLAVOR_FUJI      , 0xdf24, "AppVersion"},
    {USB_PTP_FLAVOR_NIKON     , 0xf002, "1_ISO"},
    {USB_PTP_FLAVOR_NIKON     , 0xf003, "1_FNumber"},
    {USB_PTP_FLAVOR_NIKON     , 0xf004, "1_ShutterSpeed"},
    {USB_PTP_FLAVOR_NIKON     , 0xf006, "1_FNumber2"},
    {USB_PTP_FLAVOR_NIKON     , 0xf007, "1_ShutterSpeed2"},
    {USB_PTP_FLAVOR_NIKON     , 0xf009, "1_ImageCompression"},
    {USB_PTP_FLAVOR_NIKON     , 0xf00a, "1_ImageSize"},
    {USB_PTP_FLAVOR_NIKON     , 0xf00c, "1_WhiteBalance"},
    {USB_PTP_FLAVOR_NIKON     , 0xf00d, "1_LongExposureNoiseReduction"},
    {USB_PTP_FLAVOR_NIKON     , 0xf00e, "1_HiISONoiseReduction"},
    {USB_PTP_FLAVOR_NIKON     , 0xf00f, "1_ActiveDLighting"},
    {USB_PTP_FLAVOR_NIKON     , 0xf018, "1_Language"},
    {USB_PTP_FLAVOR_NIKON     , 0xf019, "1_ReleaseWithoutCard"},
    {USB_PTP_FLAVOR_NIKON     , 0xf01c, "1_MovQuality"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000010, "PhotoStyle"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000020, "ISO"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000030, "ShutterSpeed"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000040, "Aperture"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000050, "WhiteBalance"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000060, "Exposure"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000070, "AFArea"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000080, "CameraMode"},
    {USB_PTP_FLAVOR_PANASONIC , 0x020000a2, "ImageFormat"},
    {USB_PTP_FLAVOR_PANASONIC , 0x020000b0, "MeteringInfo"},
    {USB_PTP_FLAVOR_PANASONIC , 0x020000c0, "IntervalInfo"},
    {USB_PTP_FLAVOR_PANASONIC , 0x020000e0, "RecDispConfig"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000110, "RecInfoFlash"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000140, "BurstBracket"},
    {USB_PTP_FLAVOR_PANASONIC , 0x02000170, "RecPreviewConfig"},
    {USB_PTP_FLAVOR_PANASONIC , 0x020001a0, "RecInfoSelfTimer"},
    {USB_PTP_FLAVOR_PANASONIC , 0x020001b0, "RecInfoFlash2"},
    {USB_PTP_FLAVOR_PANASONIC , 0x06000010, "MovConfig"},
    {USB_PTP_FLAVOR_PANASONIC , 0x08000010, "08000010"},
    {USB_PTP_FLAVOR_PANASONIC , 0x08000091, "08000091"},
    {USB_PTP_FLAVOR_PANASONIC , 0x12000010, "GetFreeSpaceInImages"},
    {USB_PTP_FLAVOR_PANASONIC , 0x12010040, "LensGetMFBar"},
    {USB_PTP_FLAVOR_PANASONIC , 0x16000010, "GetBatteryInfo"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_DPFF Device Property Form Flag */
static const usb_ptp_value_string_masked_t usb_ptp_dpff_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x00, "None"},
    {USB_PTP_FLAVOR_ALL       , 0x01, "Range"},
    {USB_PTP_FLAVOR_ALL       , 0x02, "Enumeration"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_DPGS Device Property GetSet type */
static const usb_ptp_value_string_masked_t usb_ptp_dpgs_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x00, "Get"},
    {USB_PTP_FLAVOR_ALL       , 0x01, "GetSet"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_DTC Data Type Codes */
static const usb_ptp_value_string_masked_t usb_ptp_dtc_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x0009), "AINT128"},
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x0003), "AINT16"},
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x0005), "AINT32"},
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x0007), "AINT64"},
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x0001), "AINT8"},
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x000A), "AUINT128"},
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x0004), "AUINT16"},
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x0006), "AUINT32"},
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x0008), "AUINT64"},
    {USB_PTP_FLAVOR_ALL       , (0x4000 | 0x0002), "AUINT8"},
    {USB_PTP_FLAVOR_ALL       , 0x0000, "UNDEF"},
    {USB_PTP_FLAVOR_ALL       , 0x0001, "INT8"},
    {USB_PTP_FLAVOR_ALL       , 0x0002, "UINT8"},
    {USB_PTP_FLAVOR_ALL       , 0x0003, "INT16"},
    {USB_PTP_FLAVOR_ALL       , 0x0004, "UINT16"},
    {USB_PTP_FLAVOR_ALL       , 0x0005, "INT32"},
    {USB_PTP_FLAVOR_ALL       , 0x0006, "UINT32"},
    {USB_PTP_FLAVOR_ALL       , 0x0007, "INT64"},
    {USB_PTP_FLAVOR_ALL       , 0x0008, "UINT64"},
    {USB_PTP_FLAVOR_ALL       , 0x0009, "INT128"},
    {USB_PTP_FLAVOR_ALL       , 0x000a, "UINT128"},
    {USB_PTP_FLAVOR_ALL       , 0xffff, "STR"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_EC Event Codes */
static const usb_ptp_value_string_masked_t usb_ptp_ec_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x4000, "Undefined"},
    {USB_PTP_FLAVOR_ALL       , 0x4001, "CancelTransaction"},
    {USB_PTP_FLAVOR_ALL       , 0x4002, "ObjectAdded"},
    {USB_PTP_FLAVOR_ALL       , 0x4003, "ObjectRemoved"},
    {USB_PTP_FLAVOR_ALL       , 0x4004, "StoreAdded"},
    {USB_PTP_FLAVOR_ALL       , 0x4005, "StoreRemoved"},
    {USB_PTP_FLAVOR_ALL       , 0x4006, "DevicePropChanged"},
    {USB_PTP_FLAVOR_ALL       , 0x4007, "ObjectInfoChanged"},
    {USB_PTP_FLAVOR_ALL       , 0x4008, "DeviceInfoChanged"},
    {USB_PTP_FLAVOR_ALL       , 0x4009, "RequestObjectTransfer"},
    {USB_PTP_FLAVOR_ALL       , 0x400a, "StoreFull"},
    {USB_PTP_FLAVOR_ALL       , 0x400b, "DeviceReset"},
    {USB_PTP_FLAVOR_ALL       , 0x400c, "StorageInfoChanged"},
    {USB_PTP_FLAVOR_ALL       , 0x400d, "CaptureComplete"},
    {USB_PTP_FLAVOR_ALL       , 0x400e, "UnreportedStatus"},
    {USB_PTP_FLAVOR_FUJI      , 0xc001, "PreviewAvailable"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc001, "CreateRecView"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc002, "ObjectAdded"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc003, "AF_Frame"},
    {USB_PTP_FLAVOR_FUJI      , 0xc004, "ObjectAdded"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc004, "DirectStoreImage"},
    {USB_PTP_FLAVOR_CANON     , 0xc005, "ExtendedErrorcode"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc005, "ComplateCameraControlOff"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc006, "AF_Frame_Over_Info"},
    {USB_PTP_FLAVOR_CANON     , 0xc008, "ObjectInfoChanged"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc008, "DevicePropChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc009, "RequestObjectTransfer"},
    {USB_PTP_FLAVOR_CANON     , 0xc00b, "ShutterButtonPressed0"},
    {USB_PTP_FLAVOR_CANON     , 0xc00c, "CameraModeChanged"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc00c, "ImageTransferModeFinish"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc00d, "ImageRecordFinish"},
    {USB_PTP_FLAVOR_CANON     , 0xc00e, "ShutterButtonPressed1"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc00e, "SlotStatusChange"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc00f, "PrioritizeRecord"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc010, "FailCombiningAfterShooting"},
    {USB_PTP_FLAVOR_CANON     , 0xc011, "StartDirectTransfer"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc011, "NotifyAFTargetFrame"},
    {USB_PTP_FLAVOR_CANON     , 0xc013, "StopDirectTransfer"},
    {USB_PTP_FLAVOR_CANON     , 0xc01b, "TranscodeProgress"},
    {USB_PTP_FLAVOR_CANON     , 0xc101, "RequestGetEvent"},
    {USB_PTP_FLAVOR_NIKON     , 0xc101, "ObjectAddedInSDRAM"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc101, "CreateRecView_New"},
    {USB_PTP_FLAVOR_NIKON     , 0xc102, "CaptureCompleteRecInSdram"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc102, "ObjectAdded_New"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc102, "PropertyChanged"},
    {USB_PTP_FLAVOR_NIKON     , 0xc103, "AdvancedTransfer"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc103, "AF_Frame_New"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc103, "CaptureComplete"},
    {USB_PTP_FLAVOR_NIKON     , 0xc104, "PreviewImageAdded"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc104, "DirectStoreImage_New"},
    {USB_PTP_FLAVOR_NIKON     , 0xc105, "MovieRecordInterrupted"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc105, "ComplateCameraControlOff_New"},
    {USB_PTP_FLAVOR_NIKON     , 0xc106, "1stCaptureComplete"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc106, "AF_Frame_Over_Info_New"},
    {USB_PTP_FLAVOR_NIKON     , 0xc107, "MirrorUpCancelComplete"},
    {USB_PTP_FLAVOR_NIKON     , 0xc108, "MovieRecordComplete"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc108, "DevicePropChanged_New"},
    {USB_PTP_FLAVOR_PANASONIC , 0xc108, "ObjectAdded"},
    {USB_PTP_FLAVOR_PANASONIC , 0xc109, "ObjectAddedSDRAM"},
    {USB_PTP_FLAVOR_NIKON     , 0xc10a, "MovieRecordStarted"},
    {USB_PTP_FLAVOR_NIKON     , 0xc10b, "PictureControlAdjustChanged"},
    {USB_PTP_FLAVOR_NIKON     , 0xc10c, "LiveViewStateChanged"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc10c, "ImageTransferModeFinish_New"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc10d, "ImageRecordFinish_New"},
    {USB_PTP_FLAVOR_NIKON     , 0xc10e, "ManualSettingsLensDataChanged"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc10e, "SlotStatusChange_New"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc10f, "PrioritizeRecord_New"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc110, "FailCombiningAfterShooting_New"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc111, "NotifyAFTargetFrame_New"},
    {USB_PTP_FLAVOR_NIKON     , 0xc112, "ActiveSelectionInterrupted"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc112, "RawEditParamChanged"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0xc113, "OlyNotifyCreateDrawEdit"},
    {USB_PTP_FLAVOR_NIKON     , 0xc120, "SBAdded"},
    {USB_PTP_FLAVOR_NIKON     , 0xc121, "SBRemoved"},
    {USB_PTP_FLAVOR_NIKON     , 0xc122, "SBAttrChanged"},
    {USB_PTP_FLAVOR_NIKON     , 0xc123, "SBGroupAttrChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc180, "RequestCancelTransferMA"},
    {USB_PTP_FLAVOR_CANON     , 0xc181, "ObjectAddedEx"},
    {USB_PTP_FLAVOR_CANON     , 0xc182, "ObjectRemoved"},
    {USB_PTP_FLAVOR_CANON     , 0xc183, "RequestGetObjectInfoEx"},
    {USB_PTP_FLAVOR_CANON     , 0xc184, "StorageStatusChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc185, "StorageInfoChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc186, "RequestObjectTransfer"},
    {USB_PTP_FLAVOR_CANON     , 0xc187, "ObjectInfoChangedEx"},
    {USB_PTP_FLAVOR_CANON     , 0xc188, "ObjectContentChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc189, "PropValueChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc18a, "AvailListChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc18b, "CameraStatusChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc18d, "WillSoonShutdown"},
    {USB_PTP_FLAVOR_CANON     , 0xc18e, "ShutdownTimerUpdated"},
    {USB_PTP_FLAVOR_CANON     , 0xc18f, "RequestCancelTransfer"},
    {USB_PTP_FLAVOR_CANON     , 0xc190, "RequestObjectTransferDT"},
    {USB_PTP_FLAVOR_CANON     , 0xc191, "RequestCancelTransferDT"},
    {USB_PTP_FLAVOR_CANON     , 0xc192, "StoreAdded"},
    {USB_PTP_FLAVOR_CANON     , 0xc193, "StoreRemoved"},
    {USB_PTP_FLAVOR_CANON     , 0xc194, "BulbExposureTime"},
    {USB_PTP_FLAVOR_CANON     , 0xc195, "RecordingTime"},
    {USB_PTP_FLAVOR_CANON     , 0xc196, "InnerDevelopParam"},
    {USB_PTP_FLAVOR_CANON     , 0xc197, "RequestObjectTransferDevelop"},
    {USB_PTP_FLAVOR_CANON     , 0xc198, "GPSLogOutputProgress"},
    {USB_PTP_FLAVOR_CANON     , 0xc199, "GPSLogOutputComplete"},
    {USB_PTP_FLAVOR_CANON     , 0xc19a, "TouchTrans"},
    {USB_PTP_FLAVOR_CANON     , 0xc19b, "RequestObjectTransferExInfo"},
    {USB_PTP_FLAVOR_CANON     , 0xc19d, "PowerZoomInfoChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc19f, "RequestPushMode"},
    {USB_PTP_FLAVOR_CANON     , 0xc1a2, "RequestObjectTransferTS"},
    {USB_PTP_FLAVOR_CANON     , 0xc1a3, "AfResult"},
    {USB_PTP_FLAVOR_CANON     , 0xc1a4, "CTGInfoCheckComplete"},
    {USB_PTP_FLAVOR_CANON     , 0xc1a5, "OLCInfoChanged"},
    {USB_PTP_FLAVOR_CANON     , 0xc1a7, "ObjectAddedEx64"},
    {USB_PTP_FLAVOR_CANON     , 0xc1a8, "ObjectInfoChangedEx64"},
    {USB_PTP_FLAVOR_CANON     , 0xc1a9, "RequestObjectTransfer64"},
    {USB_PTP_FLAVOR_CANON     , 0xc1aa, "RequestObjectTransferDT64"},
    {USB_PTP_FLAVOR_CANON     , 0xc1ab, "RequestObjectTransferFTP64"},
    {USB_PTP_FLAVOR_CANON     , 0xc1ac, "RequestObjectTransferInfoEx64"},
    {USB_PTP_FLAVOR_CANON     , 0xc1ad, "RequestObjectTransferMA64"},
    {USB_PTP_FLAVOR_CANON     , 0xc1af, "ImportError"},
    {USB_PTP_FLAVOR_CANON     , 0xc1b0, "BlePairing"},
    {USB_PTP_FLAVOR_CANON     , 0xc1b1, "RequestAutoSendImages"},
    {USB_PTP_FLAVOR_CANON     , 0xc1b2, "RequestTranscodedBlockTransfer"},
    {USB_PTP_FLAVOR_CANON     , 0xc1b4, "RequestCAssistImage"},
    {USB_PTP_FLAVOR_CANON     , 0xc1f1, "RequestObjectTransferFTP"},
    {USB_PTP_FLAVOR_PARROT    , 0xc201, "Status"},
    {USB_PTP_FLAVOR_SONY      , 0xc201, "ObjectAdded"},
    {USB_PTP_FLAVOR_PARROT    , 0xc202, "MagnetoCalibrationStatus"},
    {USB_PTP_FLAVOR_SONY      , 0xc202, "ObjectRemoved"},
    {USB_PTP_FLAVOR_SONY      , 0xc203, "PropertyChanged"},
    {USB_PTP_FLAVOR_MTP       , 0xc801, "ObjectPropChanged"},
    {USB_PTP_FLAVOR_MTP       , 0xc802, "ObjectPropDescChanged"},
    {USB_PTP_FLAVOR_MTP       , 0xc803, "ObjectReferencesChanged"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_FST FilesystemType Values */
static const usb_ptp_value_string_masked_t usb_ptp_fst_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x0000, "Undefined"},
    {USB_PTP_FLAVOR_ALL       , 0x0001, "GenericFlat"},
    {USB_PTP_FLAVOR_ALL       , 0x0002, "GenericHierarchical"},
    {USB_PTP_FLAVOR_ALL       , 0x0003, "DCF"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_GOH GetObjectHandles */
static const usb_ptp_value_string_masked_t usb_ptp_goh_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x00000000, "ALL_ASSOCS"},
    {USB_PTP_FLAVOR_ALL       , 0x00000000, "ALL_FORMATS"},
    {USB_PTP_FLAVOR_ALL       , 0xffffffff, "ALL_STORAGE"},
    {USB_PTP_FLAVOR_ALL       , 0xffffffff, "ROOT_PARENT"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_OC Operation Codes */
static const usb_ptp_value_string_masked_t usb_ptp_oc_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x1000, "Undefined"},
    {USB_PTP_FLAVOR_ALL       , 0x1001, "GetDeviceInfo"},
    {USB_PTP_FLAVOR_ALL       , 0x1002, "OpenSession"},
    {USB_PTP_FLAVOR_ALL       , 0x1003, "CloseSession"},
    {USB_PTP_FLAVOR_ALL       , 0x1004, "GetStorageIDs"},
    {USB_PTP_FLAVOR_ALL       , 0x1005, "GetStorageInfo"},
    {USB_PTP_FLAVOR_ALL       , 0x1006, "GetNumObjects"},
    {USB_PTP_FLAVOR_ALL       , 0x1007, "GetObjectHandles"},
    {USB_PTP_FLAVOR_ALL       , 0x1008, "GetObjectInfo"},
    {USB_PTP_FLAVOR_ALL       , 0x1009, "GetObject"},
    {USB_PTP_FLAVOR_ALL       , 0x100a, "GetThumb"},
    {USB_PTP_FLAVOR_ALL       , 0x100b, "DeleteObject"},
    {USB_PTP_FLAVOR_ALL       , 0x100c, "SendObjectInfo"},
    {USB_PTP_FLAVOR_ALL       , 0x100d, "SendObject"},
    {USB_PTP_FLAVOR_ALL       , 0x100e, "InitiateCapture"},
    {USB_PTP_FLAVOR_ALL       , 0x100f, "FormatStore"},
    {USB_PTP_FLAVOR_ALL       , 0x1010, "ResetDevice"},
    {USB_PTP_FLAVOR_ALL       , 0x1011, "SelfTest"},
    {USB_PTP_FLAVOR_ALL       , 0x1012, "SetObjectProtection"},
    {USB_PTP_FLAVOR_ALL       , 0x1013, "PowerDown"},
    {USB_PTP_FLAVOR_ALL       , 0x1014, "GetDevicePropDesc"},
    {USB_PTP_FLAVOR_ALL       , 0x1015, "GetDevicePropValue"},
    {USB_PTP_FLAVOR_ALL       , 0x1016, "SetDevicePropValue"},
    {USB_PTP_FLAVOR_ALL       , 0x1017, "ResetDevicePropValue"},
    {USB_PTP_FLAVOR_ALL       , 0x1018, "TerminateOpenCapture"},
    {USB_PTP_FLAVOR_ALL       , 0x1019, "MoveObject"},
    {USB_PTP_FLAVOR_ALL       , 0x101a, "CopyObject"},
    {USB_PTP_FLAVOR_ALL       , 0x101b, "GetPartialObject"},
    {USB_PTP_FLAVOR_ALL       , 0x101c, "InitiateOpenCapture"},
    {USB_PTP_FLAVOR_ALL       , 0x101d, "StartEnumHandles"},
    {USB_PTP_FLAVOR_ALL       , 0x101e, "EnumHandles"},
    {USB_PTP_FLAVOR_ALL       , 0x101f, "StopEnumHandles"},
    {USB_PTP_FLAVOR_ALL       , 0x1020, "GetVendorExtensionMaps"},
    {USB_PTP_FLAVOR_ALL       , 0x1021, "GetVendorDeviceInfo"},
    {USB_PTP_FLAVOR_ALL       , 0x1022, "GetResizedImageObject"},
    {USB_PTP_FLAVOR_ALL       , 0x1023, "GetFilesystemManifest"},
    {USB_PTP_FLAVOR_ALL       , 0x1024, "GetStreamInfo"},
    {USB_PTP_FLAVOR_ALL       , 0x1025, "GetStream"},
    {USB_PTP_FLAVOR_ALL       , 0x9000, "EXTENSION"},
    {USB_PTP_FLAVOR_CANON     , 0x9001, "GetPartialObjectInfo"},
    {USB_PTP_FLAVOR_CASIO     , 0x9001, "STILL_START"},
    {USB_PTP_FLAVOR_LEICA     , 0x9001, "SetCameraSettings"},
    {USB_PTP_FLAVOR_CANON     , 0x9002, "SetObjectArchive"},
    {USB_PTP_FLAVOR_CASIO     , 0x9002, "STILL_STOP"},
    {USB_PTP_FLAVOR_LEICA     , 0x9002, "GetCameraSettings"},
    {USB_PTP_FLAVOR_CANON     , 0x9003, "KeepDeviceOn"},
    {USB_PTP_FLAVOR_KODAK     , 0x9003, "GetSerial"},
    {USB_PTP_FLAVOR_LEICA     , 0x9003, "GetLensParameter"},
    {USB_PTP_FLAVOR_CANON     , 0x9004, "LockDeviceUI"},
    {USB_PTP_FLAVOR_KODAK     , 0x9004, "SetSerial"},
    {USB_PTP_FLAVOR_LEICA     , 0x9004, "LEReleaseStages"},
    {USB_PTP_FLAVOR_CANON     , 0x9005, "UnlockDeviceUI"},
    {USB_PTP_FLAVOR_KODAK     , 0x9005, "SendFileObjectInfo"},
    {USB_PTP_FLAVOR_LEICA     , 0x9005, "LEOpenSession"},
    {USB_PTP_FLAVOR_CANON     , 0x9006, "GetObjectHandleByName"},
    {USB_PTP_FLAVOR_KODAK     , 0x9006, "SendFileObject"},
    {USB_PTP_FLAVOR_LEICA     , 0x9006, "LECloseSession"},
    {USB_PTP_FLAVOR_NIKON     , 0x9006, "GetProfileAllData"},
    {USB_PTP_FLAVOR_CASIO     , 0x9007, "FOCUS"},
    {USB_PTP_FLAVOR_LEICA     , 0x9007, "RequestObjectTransferReady"},
    {USB_PTP_FLAVOR_NIKON     , 0x9007, "SendProfileData"},
    {USB_PTP_FLAVOR_CANON     , 0x9008, "InitiateReleaseControl"},
    {USB_PTP_FLAVOR_KODAK     , 0x9008, "SetText"},
    {USB_PTP_FLAVOR_LEICA     , 0x9008, "GetGeoTrackingData"},
    {USB_PTP_FLAVOR_NIKON     , 0x9008, "DeleteProfile"},
    {USB_PTP_FLAVOR_CANON     , 0x9009, "TerminateReleaseControl"},
    {USB_PTP_FLAVOR_CASIO     , 0x9009, "CF_PRESS"},
    {USB_PTP_FLAVOR_NIKON     , 0x9009, "SetProfileData"},
    {USB_PTP_FLAVOR_CANON     , 0x900a, "TerminatePlaybackMode"},
    {USB_PTP_FLAVOR_CASIO     , 0x900a, "CF_RELEASE"},
    {USB_PTP_FLAVOR_LEICA     , 0x900a, "OpenDebugSession"},
    {USB_PTP_FLAVOR_CANON     , 0x900b, "ViewfinderOn"},
    {USB_PTP_FLAVOR_LEICA     , 0x900b, "CloseDebugSession"},
    {USB_PTP_FLAVOR_CANON     , 0x900c, "ViewfinderOff"},
    {USB_PTP_FLAVOR_CASIO     , 0x900c, "GET_OBJECT_INFO"},
    {USB_PTP_FLAVOR_LEICA     , 0x900c, "GetDebugBuffer"},
    {USB_PTP_FLAVOR_CANON     , 0x900d, "DoAeAfAwb"},
    {USB_PTP_FLAVOR_LEICA     , 0x900d, "DebugCommandString"},
    {USB_PTP_FLAVOR_CANON     , 0x900e, "GetCustomizeSpec"},
    {USB_PTP_FLAVOR_LEICA     , 0x900e, "GetDebugRoute"},
    {USB_PTP_FLAVOR_CANON     , 0x900f, "GetCustomizeItemInfo"},
    {USB_PTP_FLAVOR_LEICA     , 0x900f, "SetIPTCData"},
    {USB_PTP_FLAVOR_CANON     , 0x9010, "GetCustomizeData"},
    {USB_PTP_FLAVOR_LEICA     , 0x9010, "GetIPTCData"},
    {USB_PTP_FLAVOR_NIKON     , 0x9010, "AdvancedTransfer"},
    {USB_PTP_FLAVOR_CANON     , 0x9011, "SetCustomizeData"},
    {USB_PTP_FLAVOR_NIKON     , 0x9011, "GetFileInfoInBlock"},
    {USB_PTP_FLAVOR_CANON     , 0x9012, "GetCaptureStatus"},
    {USB_PTP_FLAVOR_CANON     , 0x9013, "CheckEvent"},
    {USB_PTP_FLAVOR_CANON     , 0x9014, "FocusLock"},
    {USB_PTP_FLAVOR_CANON     , 0x9015, "FocusUnlock"},
    {USB_PTP_FLAVOR_CANON     , 0x9016, "GetLocalReleaseParam"},
    {USB_PTP_FLAVOR_LEICA     , 0x9016, "LEControlAutoFocus"},
    {USB_PTP_FLAVOR_CANON     , 0x9017, "SetLocalReleaseParam"},
    {USB_PTP_FLAVOR_CANON     , 0x9018, "AskAboutPcEvf"},
    {USB_PTP_FLAVOR_CANON     , 0x9019, "SendPartialObject"},
    {USB_PTP_FLAVOR_LEICA     , 0x9019, "LEControlBulbExposure"},
    {USB_PTP_FLAVOR_CANON     , 0x901a, "InitiateCaptureInMemory"},
    {USB_PTP_FLAVOR_LEICA     , 0x901a, "LEControlContinuousExposure"},
    {USB_PTP_FLAVOR_CANON     , 0x901b, "GetPartialObjectEx"},
    {USB_PTP_FLAVOR_LEICA     , 0x901b, "901b"},
    {USB_PTP_FLAVOR_CANON     , 0x901c, "SetObjectTime"},
    {USB_PTP_FLAVOR_LEICA     , 0x901c, "LEControlPhotoLiveView"},
    {USB_PTP_FLAVOR_CANON     , 0x901d, "GetViewfinderImage"},
    {USB_PTP_FLAVOR_LEICA     , 0x901d, "LEKeepSessionActive"},
    {USB_PTP_FLAVOR_CANON     , 0x901e, "GetObjectAttributes"},
    {USB_PTP_FLAVOR_LEICA     , 0x901e, "LEMoveLens"},
    {USB_PTP_FLAVOR_CANON     , 0x901f, "ChangeUSBProtocol"},
    {USB_PTP_FLAVOR_CANON     , 0x9020, "GetChanges"},
    {USB_PTP_FLAVOR_FUJI      , 0x9020, "InitiateMovieCapture"},
    {USB_PTP_FLAVOR_LEICA     , 0x9020, "Get3DAxisData"},
    {USB_PTP_FLAVOR_CANON     , 0x9021, "GetObjectInfoEx"},
    {USB_PTP_FLAVOR_FUJI      , 0x9021, "TerminateMovieCapture"},
    {USB_PTP_FLAVOR_LEICA     , 0x9021, "LESetZoomMode"},
    {USB_PTP_FLAVOR_CANON     , 0x9022, "InitiateDirectTransfer"},
    {USB_PTP_FLAVOR_FUJI      , 0x9022, "GetCapturePreview"},
    {USB_PTP_FLAVOR_LEICA     , 0x9022, "LESetFocusCrossPosition"},
    {USB_PTP_FLAVOR_CANON     , 0x9023, "TerminateDirectTransfer"},
    {USB_PTP_FLAVOR_CANON     , 0x9024, "SendObjectInfoByPath"},
    {USB_PTP_FLAVOR_CASIO     , 0x9024, "SHUTTER"},
    {USB_PTP_FLAVOR_LEICA     , 0x9024, "LESetDisplayWindowPosition"},
    {USB_PTP_FLAVOR_CANON     , 0x9025, "SendObjectByPath"},
    {USB_PTP_FLAVOR_CASIO     , 0x9025, "GET_OBJECT"},
    {USB_PTP_FLAVOR_LEICA     , 0x9025, "LEGetStreamData"},
    {USB_PTP_FLAVOR_CANON     , 0x9026, "InitiateDirectTransferEx"},
    {USB_PTP_FLAVOR_CASIO     , 0x9026, "GET_THUMBNAIL"},
    {USB_PTP_FLAVOR_FUJI      , 0x9026, "SetFocusPoint"},
    {USB_PTP_FLAVOR_CANON     , 0x9027, "GetAncillaryObjectHandles"},
    {USB_PTP_FLAVOR_CASIO     , 0x9027, "GET_STILL_HANDLES"},
    {USB_PTP_FLAVOR_FUJI      , 0x9027, "ResetFocusPoint"},
    {USB_PTP_FLAVOR_CANON     , 0x9028, "GetTreeInfo"},
    {USB_PTP_FLAVOR_CASIO     , 0x9028, "STILL_RESET"},
    {USB_PTP_FLAVOR_CANON     , 0x9029, "GetTreeSize"},
    {USB_PTP_FLAVOR_CASIO     , 0x9029, "HALF_PRESS"},
    {USB_PTP_FLAVOR_CANON     , 0x902a, "NotifyProgress"},
    {USB_PTP_FLAVOR_CASIO     , 0x902a, "HALF_RELEASE"},
    {USB_PTP_FLAVOR_CANON     , 0x902b, "NotifyCancelAccepted"},
    {USB_PTP_FLAVOR_CASIO     , 0x902b, "CS_PRESS"},
    {USB_PTP_FLAVOR_FUJI      , 0x902b, "GetDeviceInfo"},
    {USB_PTP_FLAVOR_CANON     , 0x902c, "902C"},
    {USB_PTP_FLAVOR_CASIO     , 0x902c, "CS_RELEASE"},
    {USB_PTP_FLAVOR_FUJI      , 0x902c, "SetShutterSpeed"},
    {USB_PTP_FLAVOR_CANON     , 0x902d, "GetDirectory"},
    {USB_PTP_FLAVOR_CASIO     , 0x902d, "ZOOM"},
    {USB_PTP_FLAVOR_FUJI      , 0x902d, "SetAperture"},
    {USB_PTP_FLAVOR_CANON     , 0x902e, "902E"},
    {USB_PTP_FLAVOR_CASIO     , 0x902e, "CZ_PRESS"},
    {USB_PTP_FLAVOR_FUJI      , 0x902e, "SetExposureCompensation"},
    {USB_PTP_FLAVOR_CANON     , 0x902f, "902F"},
    {USB_PTP_FLAVOR_CASIO     , 0x902f, "CZ_RELEASE"},
    {USB_PTP_FLAVOR_CANON     , 0x9030, "SetPairingInfo"},
    {USB_PTP_FLAVOR_FUJI      , 0x9030, "CancelInitiateCapture"},
    {USB_PTP_FLAVOR_LEICA     , 0x9030, "OpenLiveViewSession"},
    {USB_PTP_FLAVOR_CANON     , 0x9031, "GetPairingInfo"},
    {USB_PTP_FLAVOR_LEICA     , 0x9031, "CloseLiveViewSession"},
    {USB_PTP_FLAVOR_CANON     , 0x9032, "DeletePairingInfo"},
    {USB_PTP_FLAVOR_CANON     , 0x9033, "GetMACAddress"},
    {USB_PTP_FLAVOR_CANON     , 0x9034, "SetDisplayMonitor"},
    {USB_PTP_FLAVOR_CANON     , 0x9035, "PairingComplete"},
    {USB_PTP_FLAVOR_CANON     , 0x9036, "GetWirelessMAXChannel"},
    {USB_PTP_FLAVOR_LEICA     , 0x9036, "LESetDateTime"},
    {USB_PTP_FLAVOR_LEICA     , 0x9037, "GetObjectPropListPaginated"},
    {USB_PTP_FLAVOR_FUJI      , 0x9040, "FmSendObjectInfo"},
    {USB_PTP_FLAVOR_CASIO     , 0x9041, "MOVIE_START"},
    {USB_PTP_FLAVOR_FUJI      , 0x9041, "FmSendObject"},
    {USB_PTP_FLAVOR_CASIO     , 0x9042, "MOVIE_STOP"},
    {USB_PTP_FLAVOR_FUJI      , 0x9042, "FmSendPartialObject"},
    {USB_PTP_FLAVOR_CASIO     , 0x9043, "MOVIE_PRESS"},
    {USB_PTP_FLAVOR_CASIO     , 0x9044, "MOVIE_RELEASE"},
    {USB_PTP_FLAVOR_CASIO     , 0x9045, "GET_MOVIE_HANDLES"},
    {USB_PTP_FLAVOR_CASIO     , 0x9046, "MOVIE_RESET"},
    {USB_PTP_FLAVOR_CANON     , 0x9068, "GetWebServiceSpec"},
    {USB_PTP_FLAVOR_CANON     , 0x9069, "GetWebServiceData"},
    {USB_PTP_FLAVOR_CANON     , 0x906a, "SetWebServiceData"},
    {USB_PTP_FLAVOR_CANON     , 0x906b, "DeleteWebServiceData"},
    {USB_PTP_FLAVOR_CANON     , 0x906c, "GetRootCertificateSpec"},
    {USB_PTP_FLAVOR_CANON     , 0x906d, "GetRootCertificateData"},
    {USB_PTP_FLAVOR_CANON     , 0x906e, "SetRootCertificateData"},
    {USB_PTP_FLAVOR_CANON     , 0x906f, "DeleteRootCertificateData"},
    {USB_PTP_FLAVOR_CANON     , 0x9075, "GetGpsMobilelinkObjectInfo"},
    {USB_PTP_FLAVOR_CANON     , 0x9076, "SendGpsTagInfo"},
    {USB_PTP_FLAVOR_CANON     , 0x9077, "GetTranscodeApproxSize"},
    {USB_PTP_FLAVOR_CANON     , 0x9078, "RequestTranscodeStart"},
    {USB_PTP_FLAVOR_CANON     , 0x9079, "RequestTranscodeCancel"},
    {USB_PTP_FLAVOR_CANON     , 0x9086, "SetRemoteShootingMode"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c0, "InitiateCaptureRecInSdram"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c1, "AfDrive"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c2, "ChangeCameraMode"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c3, "DelImageSDRAM"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c4, "GetLargeThumb"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c5, "CurveDownload"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c6, "CurveUpload"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c7, "GetEvent"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c8, "DeviceReady"},
    {USB_PTP_FLAVOR_NIKON     , 0x90c9, "SetPreWBData"},
    {USB_PTP_FLAVOR_NIKON     , 0x90ca, "GetVendorPropCodes"},
    {USB_PTP_FLAVOR_NIKON     , 0x90cb, "AfCaptureSDRAM"},
    {USB_PTP_FLAVOR_NIKON     , 0x90cc, "GetPictCtrlData"},
    {USB_PTP_FLAVOR_NIKON     , 0x90cd, "SetPictCtrlData"},
    {USB_PTP_FLAVOR_NIKON     , 0x90ce, "DelCstPicCtrl"},
    {USB_PTP_FLAVOR_NIKON     , 0x90cf, "GetPicCtrlCapability"},
    {USB_PTP_FLAVOR_NIKON     , 0x90e0, "GetDevicePTPIPInfo"},
    {USB_PTP_FLAVOR_LEICA     , 0x9100, "OpenProductionSession"},
    {USB_PTP_FLAVOR_CANON     , 0x9101, "GetStorageIDs"},
    {USB_PTP_FLAVOR_LEICA     , 0x9101, "CloseProductionSession"},
    {USB_PTP_FLAVOR_MTP       , 0x9101, "WMDRMPD_GetSecureTimeChallenge"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9101, "Capture"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9101, "9101"},
    {USB_PTP_FLAVOR_CANON     , 0x9102, "GetStorageInfo"},
    {USB_PTP_FLAVOR_LEICA     , 0x9102, "UpdateFirmware"},
    {USB_PTP_FLAVOR_MTP       , 0x9102, "WMDRMPD_GetSecureTimeResponse"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9102, "OpenSession"},
    {USB_PTP_FLAVOR_CANON     , 0x9103, "GetObjectInfo"},
    {USB_PTP_FLAVOR_LEICA     , 0x9103, "OpenOSDSession"},
    {USB_PTP_FLAVOR_MTP       , 0x9103, "WMDRMPD_SetLicenseResponse"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9103, "SelfCleaning"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9103, "CloseSession"},
    {USB_PTP_FLAVOR_CANON     , 0x9104, "GetObject"},
    {USB_PTP_FLAVOR_LEICA     , 0x9104, "CloseOSDSession"},
    {USB_PTP_FLAVOR_MTP       , 0x9104, "WMDRMPD_GetSyncList"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9104, "9104"},
    {USB_PTP_FLAVOR_CANON     , 0x9105, "DeleteObject"},
    {USB_PTP_FLAVOR_LEICA     , 0x9105, "GetOSDData"},
    {USB_PTP_FLAVOR_MTP       , 0x9105, "WMDRMPD_SendMeterChallengeQuery"},
    {USB_PTP_FLAVOR_CANON     , 0x9106, "FormatStore"},
    {USB_PTP_FLAVOR_LEICA     , 0x9106, "GetFirmwareStruct"},
    {USB_PTP_FLAVOR_MTP       , 0x9106, "WMDRMPD_GetMeterChallenge"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9106, "SetRGBGain"},
    {USB_PTP_FLAVOR_CANON     , 0x9107, "GetPartialObject"},
    {USB_PTP_FLAVOR_MTP       , 0x9107, "WMDRMPD_SetMeterResponse"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9107, "SetPresetMode"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9107, "9107"},
    {USB_PTP_FLAVOR_CANON     , 0x9108, "GetDeviceInfoEx"},
    {USB_PTP_FLAVOR_MTP       , 0x9108, "WMDRMPD_CleanDataStore"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9108, "SetWBBiasAll"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9108, "ListProperty"},
    {USB_PTP_FLAVOR_CANON     , 0x9109, "GetObjectInfoEx"},
    {USB_PTP_FLAVOR_MTP       , 0x9109, "WMDRMPD_GetLicenseState"},
    {USB_PTP_FLAVOR_CANON     , 0x910a, "GetThumbEx"},
    {USB_PTP_FLAVOR_MTP       , 0x910a, "WMDRMPD_SendWMDRMPDCommand"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x910a, "GetCameraControlMode"},
    {USB_PTP_FLAVOR_CANON     , 0x910b, "SendPartialObject"},
    {USB_PTP_FLAVOR_LEICA     , 0x910b, "GetDebugMenu"},
    {USB_PTP_FLAVOR_MTP       , 0x910b, "WMDRMPD_SendWMDRMPDRequest"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x910b, "SetCameraControlMode"},
    {USB_PTP_FLAVOR_CANON     , 0x910c, "SetObjectAttributes"},
    {USB_PTP_FLAVOR_LEICA     , 0x910c, "SetDebugMenu"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x910c, "SetWBRGBGain"},
    {USB_PTP_FLAVOR_CANON     , 0x910d, "GetObjectTime"},
    {USB_PTP_FLAVOR_LEICA     , 0x910d, "OdinMessage"},
    {USB_PTP_FLAVOR_CANON     , 0x910e, "SetObjectTime"},
    {USB_PTP_FLAVOR_LEICA     , 0x910e, "GetDebugObjectHandles"},
    {USB_PTP_FLAVOR_CANON     , 0x910f, "RemoteRelease"},
    {USB_PTP_FLAVOR_LEICA     , 0x910f, "GetDebugObject"},
    {USB_PTP_FLAVOR_CANON     , 0x9110, "SetDevicePropValueEx"},
    {USB_PTP_FLAVOR_LEICA     , 0x9110, "DeleteDebugObject"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9110, "9110"},
    {USB_PTP_FLAVOR_LEICA     , 0x9111, "GetDebugObjectInfo"},
    {USB_PTP_FLAVOR_LEICA     , 0x9112, "WriteDebugObject"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9112, "9112"},
    {USB_PTP_FLAVOR_CANON     , 0x9113, "GetRemoteMode"},
    {USB_PTP_FLAVOR_LEICA     , 0x9113, "CreateDebugObject"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9113, "9113"},
    {USB_PTP_FLAVOR_CANON     , 0x9114, "SetRemoteMode"},
    {USB_PTP_FLAVOR_LEICA     , 0x9114, "Calibrate3DAxis"},
    {USB_PTP_FLAVOR_CANON     , 0x9115, "SetEventMode"},
    {USB_PTP_FLAVOR_LEICA     , 0x9115, "MagneticCalibration"},
    {USB_PTP_FLAVOR_CANON     , 0x9116, "GetEvent"},
    {USB_PTP_FLAVOR_LEICA     , 0x9116, "GetViewFinderData"},
    {USB_PTP_FLAVOR_CANON     , 0x9117, "TransferComplete"},
    {USB_PTP_FLAVOR_CANON     , 0x9118, "CancelTransfer"},
    {USB_PTP_FLAVOR_CANON     , 0x9119, "ResetTransfer"},
    {USB_PTP_FLAVOR_CANON     , 0x911a, "PCHDDCapacity"},
    {USB_PTP_FLAVOR_CANON     , 0x911b, "SetUILock"},
    {USB_PTP_FLAVOR_CANON     , 0x911c, "ResetUILock"},
    {USB_PTP_FLAVOR_CANON     , 0x911d, "KeepDeviceOn"},
    {USB_PTP_FLAVOR_CANON     , 0x911e, "SetNullPacketMode"},
    {USB_PTP_FLAVOR_CANON     , 0x911f, "UpdateFirmware"},
    {USB_PTP_FLAVOR_CANON     , 0x9120, "TransferCompleteDT"},
    {USB_PTP_FLAVOR_CANON     , 0x9121, "CancelTransferDT"},
    {USB_PTP_FLAVOR_CANON     , 0x9122, "SetWftProfile"},
    {USB_PTP_FLAVOR_MTP       , 0x9122, "WPDWCN_ProcessWFCObject"},
    {USB_PTP_FLAVOR_CANON     , 0x9123, "GetWftProfile"},
    {USB_PTP_FLAVOR_CANON     , 0x9124, "SetProfileToWft"},
    {USB_PTP_FLAVOR_CANON     , 0x9125, "BulbStart"},
    {USB_PTP_FLAVOR_CANON     , 0x9126, "BulbEnd"},
    {USB_PTP_FLAVOR_CANON     , 0x9127, "RequestDevicePropValue"},
    {USB_PTP_FLAVOR_CANON     , 0x9128, "RemoteReleaseOn"},
    {USB_PTP_FLAVOR_CANON     , 0x9129, "RemoteReleaseOff"},
    {USB_PTP_FLAVOR_CANON     , 0x912a, "RegistBackgroundImage"},
    {USB_PTP_FLAVOR_CANON     , 0x912b, "ChangePhotoStudioMode"},
    {USB_PTP_FLAVOR_CANON     , 0x912c, "GetPartialObjectEx"},
    {USB_PTP_FLAVOR_CANON     , 0x9130, "ResetMirrorLockupState"},
    {USB_PTP_FLAVOR_CANON     , 0x9131, "PopupBuiltinFlash"},
    {USB_PTP_FLAVOR_CANON     , 0x9132, "EndGetPartialObjectEx"},
    {USB_PTP_FLAVOR_CANON     , 0x9133, "MovieSelectSWOn"},
    {USB_PTP_FLAVOR_CANON     , 0x9134, "MovieSelectSWOff"},
    {USB_PTP_FLAVOR_CANON     , 0x9135, "GetCTGInfo"},
    {USB_PTP_FLAVOR_CANON     , 0x9136, "GetLensAdjust"},
    {USB_PTP_FLAVOR_CANON     , 0x9137, "SetLensAdjust"},
    {USB_PTP_FLAVOR_CANON     , 0x9138, "ReadyToSendMusic"},
    {USB_PTP_FLAVOR_CANON     , 0x9139, "CreateHandle"},
    {USB_PTP_FLAVOR_CANON     , 0x913a, "SendPartialObjectEx"},
    {USB_PTP_FLAVOR_CANON     , 0x913b, "EndSendPartialObjectEx"},
    {USB_PTP_FLAVOR_CANON     , 0x913c, "SetCTGInfo"},
    {USB_PTP_FLAVOR_CANON     , 0x913d, "SetRequestOLCInfoGroup"},
    {USB_PTP_FLAVOR_CANON     , 0x913e, "SetRequestRollingPitchingLevel"},
    {USB_PTP_FLAVOR_CANON     , 0x913f, "GetCameraSupport"},
    {USB_PTP_FLAVOR_CANON     , 0x9140, "SetRating"},
    {USB_PTP_FLAVOR_CANON     , 0x9141, "RequestInnerDevelopStart"},
    {USB_PTP_FLAVOR_CANON     , 0x9142, "RequestInnerDevelopParamChange"},
    {USB_PTP_FLAVOR_CANON     , 0x9143, "RequestInnerDevelopEnd"},
    {USB_PTP_FLAVOR_CANON     , 0x9144, "GpsLoggingDataMode"},
    {USB_PTP_FLAVOR_CANON     , 0x9145, "GetGpsLogCurrentHandle"},
    {USB_PTP_FLAVOR_CANON     , 0x9146, "SetImageRecoveryData"},
    {USB_PTP_FLAVOR_CANON     , 0x9147, "GetImageRecoveryList"},
    {USB_PTP_FLAVOR_CANON     , 0x9148, "FormatImageRecoveryData"},
    {USB_PTP_FLAVOR_CANON     , 0x9149, "GetPresetLensAdjustParam"},
    {USB_PTP_FLAVOR_CANON     , 0x914a, "GetRawDispImage"},
    {USB_PTP_FLAVOR_CANON     , 0x914b, "SaveImageRecoveryData"},
    {USB_PTP_FLAVOR_CANON     , 0x914c, "RequestBLE"},
    {USB_PTP_FLAVOR_CANON     , 0x914d, "DrivePowerZoom"},
    {USB_PTP_FLAVOR_CANON     , 0x914f, "GetIptcData"},
    {USB_PTP_FLAVOR_CANON     , 0x9150, "SetIptcData"},
    {USB_PTP_FLAVOR_CANON     , 0x9151, "InitiateViewfinder"},
    {USB_PTP_FLAVOR_CANON     , 0x9152, "TerminateViewfinder"},
    {USB_PTP_FLAVOR_CANON     , 0x9153, "GetViewFinderData"},
    {USB_PTP_FLAVOR_CANON     , 0x9154, "DoAf"},
    {USB_PTP_FLAVOR_CANON     , 0x9155, "DriveLens"},
    {USB_PTP_FLAVOR_CANON     , 0x9156, "DepthOfFieldPreview"},
    {USB_PTP_FLAVOR_CANON     , 0x9157, "ClickWB"},
    {USB_PTP_FLAVOR_CANON     , 0x9158, "Zoom"},
    {USB_PTP_FLAVOR_CANON     , 0x9159, "ZoomPosition"},
    {USB_PTP_FLAVOR_CANON     , 0x915a, "SetLiveAfFrame"},
    {USB_PTP_FLAVOR_CANON     , 0x915b, "TouchAfPosition"},
    {USB_PTP_FLAVOR_CANON     , 0x915c, "SetLvPcFlavoreditMode"},
    {USB_PTP_FLAVOR_CANON     , 0x915d, "SetLvPcFlavoreditParam"},
    {USB_PTP_FLAVOR_CANON     , 0x915e, "RequestSensorCleaning"},
    {USB_PTP_FLAVOR_CANON     , 0x9160, "AfCancel"},
    {USB_PTP_FLAVOR_CANON     , 0x916b, "SetImageRecoveryDataEx"},
    {USB_PTP_FLAVOR_CANON     , 0x916c, "GetImageRecoveryListEx"},
    {USB_PTP_FLAVOR_CANON     , 0x916d, "CompleteAutoSendImages"},
    {USB_PTP_FLAVOR_CANON     , 0x916e, "NotifyAutoTransferStatus"},
    {USB_PTP_FLAVOR_CANON     , 0x916f, "GetReducedObject"},
    {USB_PTP_FLAVOR_CANON     , 0x9170, "GetObjectInfo64"},
    {USB_PTP_FLAVOR_MTP       , 0x9170, "AAVT_OpenMediaSession"},
    {USB_PTP_FLAVOR_CANON     , 0x9171, "GetObject64"},
    {USB_PTP_FLAVOR_MTP       , 0x9171, "AAVT_CloseMediaSession"},
    {USB_PTP_FLAVOR_CANON     , 0x9172, "GetPartialObject64"},
    {USB_PTP_FLAVOR_MTP       , 0x9172, "AAVT_GetNextDataBlock"},
    {USB_PTP_FLAVOR_CANON     , 0x9173, "GetObjectInfoEx64"},
    {USB_PTP_FLAVOR_MTP       , 0x9173, "AAVT_SetCurrentTimePosition"},
    {USB_PTP_FLAVOR_CANON     , 0x9174, "GetPartialObjectEX64"},
    {USB_PTP_FLAVOR_CANON     , 0x9175, "CreateHandle64"},
    {USB_PTP_FLAVOR_CANON     , 0x9177, "NotifySaveComplete"},
    {USB_PTP_FLAVOR_CANON     , 0x9178, "GetTranscodedBlock"},
    {USB_PTP_FLAVOR_CANON     , 0x9179, "TransferCompleteTranscodedBlock"},
    {USB_PTP_FLAVOR_MTP       , 0x9180, "WMDRMND_SendRegistrationRequest"},
    {USB_PTP_FLAVOR_MTP       , 0x9181, "WMDRMND_GetRegistrationResponse"},
    {USB_PTP_FLAVOR_CANON     , 0x9182, "NotifyEstimateNumberofImport"},
    {USB_PTP_FLAVOR_MTP       , 0x9182, "WMDRMND_GetProximityChallenge"},
    {USB_PTP_FLAVOR_CANON     , 0x9183, "NotifyNumberofImported"},
    {USB_PTP_FLAVOR_MTP       , 0x9183, "WMDRMND_SendProximityResponse"},
    {USB_PTP_FLAVOR_CANON     , 0x9184, "NotifySizeOfPartialDataTransfer"},
    {USB_PTP_FLAVOR_MTP       , 0x9184, "WMDRMND_SendWMDRMNDLicenseRequest"},
    {USB_PTP_FLAVOR_CANON     , 0x9185, "NotifyFinish"},
    {USB_PTP_FLAVOR_MTP       , 0x9185, "WMDRMND_GetWMDRMNDLicenseResponse"},
    {USB_PTP_FLAVOR_CANON     , 0x9186, "GetWFTData"},
    {USB_PTP_FLAVOR_CANON     , 0x9187, "SetWFTData"},
    {USB_PTP_FLAVOR_CANON     , 0x9188, "ChangeWFTSettingNumber"},
    {USB_PTP_FLAVOR_CANON     , 0x9189, "GetPictureStylePCFlavorParam"},
    {USB_PTP_FLAVOR_CANON     , 0x918a, "SetPictureStylePCFlavorParam"},
    {USB_PTP_FLAVOR_CANON     , 0x91ab, "GetObjectURL"},
    {USB_PTP_FLAVOR_CANON     , 0x91ac, "SetCAssistMode"},
    {USB_PTP_FLAVOR_CANON     , 0x91ad, "GetCAssistPresetThumb"},
    {USB_PTP_FLAVOR_CANON     , 0x91b9, "SetFELock"},
    {USB_PTP_FLAVOR_CANON     , 0x91ba, "DeleteWFTSettingNumber"},
    {USB_PTP_FLAVOR_CANON     , 0x91be, "SetDefaultCameraSetting"},
    {USB_PTP_FLAVOR_CANON     , 0x91bf, "GetAEData"},
    {USB_PTP_FLAVOR_CANON     , 0x91e4, "SendHostInfo"},
    {USB_PTP_FLAVOR_CANON     , 0x91e8, "NotifyNetworkError"},
    {USB_PTP_FLAVOR_CANON     , 0x91e9, "AdapterTransferProgress"},
    {USB_PTP_FLAVOR_CANON     , 0x91f0, "TransferCompleteFTP"},
    {USB_PTP_FLAVOR_CANON     , 0x91f1, "CancelTransferFTP"},
    {USB_PTP_FLAVOR_CANON     , 0x91f9, "NotifyBtStatus"},
    {USB_PTP_FLAVOR_CANON     , 0x91fd, "SetAdapterBatteryReport"},
    {USB_PTP_FLAVOR_CANON     , 0x91fe, "FAPIMessageTX"},
    {USB_PTP_FLAVOR_CANON     , 0x91ff, "FAPIMessageRX"},
    {USB_PTP_FLAVOR_NIKON     , 0x9200, "GetPreviewImg"},
    {USB_PTP_FLAVOR_MTP       , 0x9201, "WMPPD_ReportAddedDeletedItems"},
    {USB_PTP_FLAVOR_NIKON     , 0x9201, "StartLiveView"},
    {USB_PTP_FLAVOR_PARROT    , 0x9201, "GetSunshineValues"},
    {USB_PTP_FLAVOR_SONY      , 0x9201, "SDIOConnect"},
    {USB_PTP_FLAVOR_MTP       , 0x9202, "WMPPD_ReportAcquiredItems"},
    {USB_PTP_FLAVOR_NIKON     , 0x9202, "EndLiveView"},
    {USB_PTP_FLAVOR_PARROT    , 0x9202, "GetTemperatureValues"},
    {USB_PTP_FLAVOR_SONY      , 0x9202, "GetSDIOGetExtDeviceInfo"},
    {USB_PTP_FLAVOR_MTP       , 0x9203, "WMPPD_PlaylistObjectPref"},
    {USB_PTP_FLAVOR_NIKON     , 0x9203, "GetLiveViewImg"},
    {USB_PTP_FLAVOR_PARROT    , 0x9203, "GetAngleValues"},
    {USB_PTP_FLAVOR_SONY      , 0x9203, "GetDevicePropdesc"},
    {USB_PTP_FLAVOR_MTP       , 0x9204, "ZUNE_GETUNDEFINED001"},
    {USB_PTP_FLAVOR_NIKON     , 0x9204, "MfDrive"},
    {USB_PTP_FLAVOR_PARROT    , 0x9204, "GetGpsValues"},
    {USB_PTP_FLAVOR_SONY      , 0x9204, "GetDevicePropertyValue"},
    {USB_PTP_FLAVOR_NIKON     , 0x9205, "ChangeAfArea"},
    {USB_PTP_FLAVOR_PARROT    , 0x9205, "GetGyroscopeValues"},
    {USB_PTP_FLAVOR_SONY      , 0x9205, "SetControlDeviceA"},
    {USB_PTP_FLAVOR_NIKON     , 0x9206, "AfDriveCancel"},
    {USB_PTP_FLAVOR_PARROT    , 0x9206, "GetAccelerometerValues"},
    {USB_PTP_FLAVOR_SONY      , 0x9206, "GetControlDeviceDesc"},
    {USB_PTP_FLAVOR_NIKON     , 0x9207, "InitiateCaptureRecInMedia"},
    {USB_PTP_FLAVOR_PARROT    , 0x9207, "GetMagnetometerValues"},
    {USB_PTP_FLAVOR_SONY      , 0x9207, "SetControlDeviceB"},
    {USB_PTP_FLAVOR_PARROT    , 0x9208, "GetImuValues"},
    {USB_PTP_FLAVOR_NIKON     , 0x9209, "GetVendorStorageIDs"},
    {USB_PTP_FLAVOR_PARROT    , 0x9209, "GetStatusMask"},
    {USB_PTP_FLAVOR_SONY      , 0x9209, "GetAllDevicePropData"},
    {USB_PTP_FLAVOR_NIKON     , 0x920a, "StartMovieRecInCard"},
    {USB_PTP_FLAVOR_PARROT    , 0x920a, "EjectStorage"},
    {USB_PTP_FLAVOR_NIKON     , 0x920b, "EndMovieRec"},
    {USB_PTP_FLAVOR_NIKON     , 0x920c, "TerminateCapture"},
    {USB_PTP_FLAVOR_NIKON     , 0x920f, "GetFhdPicture"},
    {USB_PTP_FLAVOR_PARROT    , 0x9210, "StartMagnetoCalib"},
    {USB_PTP_FLAVOR_PARROT    , 0x9211, "StopMagnetoCalib"},
    {USB_PTP_FLAVOR_MTP       , 0x9212, "WMDRMPD_SendWMDRMPDAppRequest"},
    {USB_PTP_FLAVOR_PARROT    , 0x9212, "MagnetoCalibStatus"},
    {USB_PTP_FLAVOR_MTP       , 0x9213, "WMDRMPD_GetWMDRMPDAppResponse"},
    {USB_PTP_FLAVOR_PARROT    , 0x9213, "SendFirmwareUpdate"},
    {USB_PTP_FLAVOR_MTP       , 0x9214, "WMDRMPD_EnableTrustedFilesOperations"},
    {USB_PTP_FLAVOR_MTP       , 0x9215, "WMDRMPD_DisableTrustedFilesOperations"},
    {USB_PTP_FLAVOR_MTP       , 0x9216, "WMDRMPD_EndTrustedAppSession"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9301, "GetDeviceInfo"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9302, "OpenSession"},
    {USB_PTP_FLAVOR_NIKON     , 0x9400, "GetPartialObjectHiSpeed"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9401, "9401"},
    {USB_PTP_FLAVOR_NIKON     , 0x9402, "StartSpotWb"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9402, "SetDateTime"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9402, "GetProperty"},
    {USB_PTP_FLAVOR_NIKON     , 0x9403, "EndSpotWb"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9403, "SetProperty"},
    {USB_PTP_FLAVOR_NIKON     , 0x9404, "ChangeSpotWbArea"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9404, "InitiateCapture"},
    {USB_PTP_FLAVOR_NIKON     , 0x9405, "MeasureSpotWb"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9405, "9405"},
    {USB_PTP_FLAVOR_NIKON     , 0x9406, "EndSpotWbResultDisp"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9406, "9406"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9408, "9408"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9409, "9409"},
    {USB_PTP_FLAVOR_PANASONIC , 0x940a, "940A"},
    {USB_PTP_FLAVOR_PANASONIC , 0x940b, "SetCaptureTarget"},
    {USB_PTP_FLAVOR_NIKON     , 0x940c, "CancelImagesInSDRAM"},
    {USB_PTP_FLAVOR_PANASONIC , 0x940c, "MoveRecControl"},
    {USB_PTP_FLAVOR_PANASONIC , 0x940d, "PowerControl"},
    {USB_PTP_FLAVOR_PANASONIC , 0x940e, "PlayControl"},
    {USB_PTP_FLAVOR_PANASONIC , 0x940f, "PlayControlPlay"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9410, "9410"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9411, "SetGPSDataInfo"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9412, "Liveview"},
    {USB_PTP_FLAVOR_NIKON     , 0x9414, "GetSBHandles"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9414, "PollEvents"},
    {USB_PTP_FLAVOR_NIKON     , 0x9415, "GetSBAttrDesc"},
    {USB_PTP_FLAVOR_NIKON     , 0x9416, "GetSBAttrValue"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9416, "ManualFocusDrive"},
    {USB_PTP_FLAVOR_NIKON     , 0x9417, "SetSBAttrValue"},
    {USB_PTP_FLAVOR_NIKON     , 0x9418, "GetSBGroupAttrDesc"},
    {USB_PTP_FLAVOR_NIKON     , 0x9419, "GetSBGroupAttrValue"},
    {USB_PTP_FLAVOR_NIKON     , 0x941a, "SetSBGroupAttrValue"},
    {USB_PTP_FLAVOR_NIKON     , 0x941b, "TestFlash"},
    {USB_PTP_FLAVOR_NIKON     , 0x941c, "GetEventEx"},
    {USB_PTP_FLAVOR_NIKON     , 0x941d, "MirrorUpCancel"},
    {USB_PTP_FLAVOR_NIKON     , 0x941e, "PowerZoomByFocalLength"},
    {USB_PTP_FLAVOR_NIKON     , 0x941f, "ActiveSelectionControl"},
    {USB_PTP_FLAVOR_NIKON     , 0x9420, "SaveCameraSetting"},
    {USB_PTP_FLAVOR_NIKON     , 0x9421, "GetObjectSize"},
    {USB_PTP_FLAVOR_NIKON     , 0x9422, "ChangeMonitorOff"},
    {USB_PTP_FLAVOR_NIKON     , 0x9423, "GetLiveViewCompressedSize"},
    {USB_PTP_FLAVOR_NIKON     , 0x9424, "StartTracking"},
    {USB_PTP_FLAVOR_NIKON     , 0x9425, "EndTracking"},
    {USB_PTP_FLAVOR_NIKON     , 0x9426, "ChangeAELock"},
    {USB_PTP_FLAVOR_NIKON     , 0x9428, "GetLiveViewImageEx"},
    {USB_PTP_FLAVOR_NIKON     , 0x9431, "GetPartialObjectEx"},
    {USB_PTP_FLAVOR_NIKON     , 0x9432, "GetManualSettingLensData"},
    {USB_PTP_FLAVOR_NIKON     , 0x9433, "InitiatePixelMapping"},
    {USB_PTP_FLAVOR_NIKON     , 0x9434, "GetObjectsMetaData"},
    {USB_PTP_FLAVOR_NIKON     , 0x9435, "ChangeApplicationMode"},
    {USB_PTP_FLAVOR_NIKON     , 0x9436, "ResetMenu"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9481, "Capture"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9482, "GetDateTime"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9484, "GetLiveViewImage"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9485, "GetImage"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9486, "ChangedProperties"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9487, "MFDrive"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9489, "SetProperties"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9501, "SetCameraID"},
    {USB_PTP_FLAVOR_NIKON     , 0x9504, "GetDevicePropEx"},
    {USB_PTP_FLAVOR_OLYMPUS   , 0x9581, "GetCameraID"},
    {USB_PTP_FLAVOR_ANDROID   , 0x95c1, "GetPartialObject64"},
    {USB_PTP_FLAVOR_ANDROID   , 0x95c2, "SendPartialObject"},
    {USB_PTP_FLAVOR_ANDROID   , 0x95c3, "TruncateObject"},
    {USB_PTP_FLAVOR_ANDROID   , 0x95c4, "BeginEditObject"},
    {USB_PTP_FLAVOR_ANDROID   , 0x95c5, "EndEditObject"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9603, "ChangeEvent"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9605, "GetFromEventInfo"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9606, "SendDataInfo"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9607, "StartSendData"},
    {USB_PTP_FLAVOR_SONY      , 0x96f2, "SetExtPictureProfile"},
    {USB_PTP_FLAVOR_SONY      , 0x96f3, "GetExtPictureProfile"},
    {USB_PTP_FLAVOR_SONY      , 0x96f4, "GetExtLensInfo"},
    {USB_PTP_FLAVOR_SONY      , 0x96f5, "SendUpdateFile"},
    {USB_PTP_FLAVOR_SONY      , 0x96f6, "GetAllDevicePropData"},
    {USB_PTP_FLAVOR_SONY      , 0x96f8, "SetControlDeviceB"},
    {USB_PTP_FLAVOR_SONY      , 0x96fa, "SetControlDeviceA"},
    {USB_PTP_FLAVOR_SONY      , 0x96fd, "GetSDIOGetExtDeviceInfo"},
    {USB_PTP_FLAVOR_SONY      , 0x96fe, "Connect"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9703, "9703"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9704, "9704"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9705, "9705"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9706, "LiveviewImage"},
    {USB_PTP_FLAVOR_PANASONIC , 0x9707, "9707"},
    {USB_PTP_FLAVOR_MTP       , 0x9801, "GetObjectPropsSupported"},
    {USB_PTP_FLAVOR_MTP       , 0x9802, "GetObjectPropDesc"},
    {USB_PTP_FLAVOR_MTP       , 0x9803, "GetObjectPropValue"},
    {USB_PTP_FLAVOR_MTP       , 0x9804, "SetObjectPropValue"},
    {USB_PTP_FLAVOR_MTP       , 0x9805, "GetObjPropList"},
    {USB_PTP_FLAVOR_MTP       , 0x9806, "SetObjPropList"},
    {USB_PTP_FLAVOR_MTP       , 0x9807, "GetInterdependendPropdesc"},
    {USB_PTP_FLAVOR_MTP       , 0x9808, "SendObjectPropList"},
    {USB_PTP_FLAVOR_MTP       , 0x9810, "GetObjectReferences"},
    {USB_PTP_FLAVOR_MTP       , 0x9811, "SetObjectReferences"},
    {USB_PTP_FLAVOR_MTP       , 0x9812, "UpdateDeviceFirmware"},
    {USB_PTP_FLAVOR_MTP       , 0x9820, "Skip"},
    {USB_PTP_FLAVOR_ALL       , 0x9999, "CHDK"},
    {USB_PTP_FLAVOR_NIKON     , 0xfc01, "ServiceModeStart"},
    {USB_PTP_FLAVOR_NIKON     , 0xfc02, "ServiceModeStop"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_OFC Object Format Codes */
static const usb_ptp_value_string_masked_t usb_ptp_ofc_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x3000, "Undefined"},
    {USB_PTP_FLAVOR_ALL       , 0x3001, "Association"},
    {USB_PTP_FLAVOR_ALL       , 0x3002, "Script"},
    {USB_PTP_FLAVOR_ALL       , 0x3003, "Executable"},
    {USB_PTP_FLAVOR_ALL       , 0x3004, "Text"},
    {USB_PTP_FLAVOR_ALL       , 0x3005, "HTML"},
    {USB_PTP_FLAVOR_ALL       , 0x3006, "DPOF"},
    {USB_PTP_FLAVOR_ALL       , 0x3007, "AIFF"},
    {USB_PTP_FLAVOR_ALL       , 0x3008, "WAV"},
    {USB_PTP_FLAVOR_ALL       , 0x3009, "MP3"},
    {USB_PTP_FLAVOR_ALL       , 0x300a, "AVI"},
    {USB_PTP_FLAVOR_ALL       , 0x300b, "MPEG"},
    {USB_PTP_FLAVOR_ALL       , 0x300c, "ASF"},
    {USB_PTP_FLAVOR_ALL       , 0x300d, "QT"},
    {USB_PTP_FLAVOR_ALL       , 0x3800, "Defined"},
    {USB_PTP_FLAVOR_ALL       , 0x3801, "EXIF_JPEG"},
    {USB_PTP_FLAVOR_ALL       , 0x3802, "TIFF_EP"},
    {USB_PTP_FLAVOR_ALL       , 0x3803, "FlashPix"},
    {USB_PTP_FLAVOR_ALL       , 0x3804, "BMP"},
    {USB_PTP_FLAVOR_ALL       , 0x3805, "CIFF"},
    {USB_PTP_FLAVOR_ALL       , 0x3806, "Undefined_0x3806"},
    {USB_PTP_FLAVOR_ALL       , 0x3807, "GIF"},
    {USB_PTP_FLAVOR_ALL       , 0x3808, "JFIF"},
    {USB_PTP_FLAVOR_ALL       , 0x3809, "PCD"},
    {USB_PTP_FLAVOR_ALL       , 0x380a, "PICT"},
    {USB_PTP_FLAVOR_ALL       , 0x380b, "PNG"},
    {USB_PTP_FLAVOR_ALL       , 0x380c, "Undefined_0x380C"},
    {USB_PTP_FLAVOR_ALL       , 0x380d, "TIFF"},
    {USB_PTP_FLAVOR_ALL       , 0x380e, "TIFF_IT"},
    {USB_PTP_FLAVOR_ALL       , 0x380f, "JP2"},
    {USB_PTP_FLAVOR_ALL       , 0x3810, "JPX"},
    {USB_PTP_FLAVOR_ALL       , 0x3811, "DNG"},
    {USB_PTP_FLAVOR_KODAK     , 0xb002, "M3U"},
    {USB_PTP_FLAVOR_CANON     , 0xb101, "CRW"},
    {USB_PTP_FLAVOR_SONY      , 0xb101, "RAW"},
    {USB_PTP_FLAVOR_CANON     , 0xb103, "CRW3"},
    {USB_PTP_FLAVOR_CANON     , 0xb104, "MOV"},
    {USB_PTP_FLAVOR_CANON     , 0xb105, "MOV2"},
    {USB_PTP_FLAVOR_CANON     , 0xb108, "CR3"},
    {USB_PTP_FLAVOR_CANON     , 0xb1ff, "CHDK_CRW"},
    {USB_PTP_FLAVOR_MTP       , 0xb211, "MediaCard"},
    {USB_PTP_FLAVOR_MTP       , 0xb212, "MediaCardGroup"},
    {USB_PTP_FLAVOR_MTP       , 0xb213, "Encounter"},
    {USB_PTP_FLAVOR_MTP       , 0xb214, "EncounterBox"},
    {USB_PTP_FLAVOR_MTP       , 0xb215, "M4A"},
    {USB_PTP_FLAVOR_MTP       , 0xb217, "ZUNEUNDEFINED"},
    {USB_PTP_FLAVOR_MTP       , 0xb802, "Firmware"},
    {USB_PTP_FLAVOR_MTP       , 0xb881, "WindowsImageFormat"},
    {USB_PTP_FLAVOR_MTP       , 0xb900, "UndefinedAudio"},
    {USB_PTP_FLAVOR_MTP       , 0xb901, "WMA"},
    {USB_PTP_FLAVOR_MTP       , 0xb902, "OGG"},
    {USB_PTP_FLAVOR_MTP       , 0xb903, "AAC"},
    {USB_PTP_FLAVOR_MTP       , 0xb904, "AudibleCodec"},
    {USB_PTP_FLAVOR_MTP       , 0xb906, "FLAC"},
    {USB_PTP_FLAVOR_MTP       , 0xb909, "SamsungPlaylist"},
    {USB_PTP_FLAVOR_MTP       , 0xb980, "UndefinedVideo"},
    {USB_PTP_FLAVOR_MTP       , 0xb981, "WMV"},
    {USB_PTP_FLAVOR_MTP       , 0xb982, "MP4"},
    {USB_PTP_FLAVOR_MTP       , 0xb983, "MP2"},
    {USB_PTP_FLAVOR_MTP       , 0xb984, "3GP"},
    {USB_PTP_FLAVOR_MTP       , 0xba00, "UndefinedCollection"},
    {USB_PTP_FLAVOR_MTP       , 0xba01, "AbstractMultimediaAlbum"},
    {USB_PTP_FLAVOR_MTP       , 0xba02, "AbstractImageAlbum"},
    {USB_PTP_FLAVOR_MTP       , 0xba03, "AbstractAudioAlbum"},
    {USB_PTP_FLAVOR_MTP       , 0xba04, "AbstractVideoAlbum"},
    {USB_PTP_FLAVOR_MTP       , 0xba05, "AbstractAudioVideoPlaylist"},
    {USB_PTP_FLAVOR_MTP       , 0xba06, "AbstractContactGroup"},
    {USB_PTP_FLAVOR_MTP       , 0xba07, "AbstractMessageFolder"},
    {USB_PTP_FLAVOR_MTP       , 0xba08, "AbstractChapteredProduction"},
    {USB_PTP_FLAVOR_MTP       , 0xba09, "AbstractAudioPlaylist"},
    {USB_PTP_FLAVOR_MTP       , 0xba0a, "AbstractVideoPlaylist"},
    {USB_PTP_FLAVOR_MTP       , 0xba0b, "AbstractMediacast"},
    {USB_PTP_FLAVOR_MTP       , 0xba10, "WPLPlaylist"},
    {USB_PTP_FLAVOR_MTP       , 0xba11, "M3UPlaylist"},
    {USB_PTP_FLAVOR_MTP       , 0xba12, "MPLPlaylist"},
    {USB_PTP_FLAVOR_MTP       , 0xba13, "ASXPlaylist"},
    {USB_PTP_FLAVOR_MTP       , 0xba14, "PLSPlaylist"},
    {USB_PTP_FLAVOR_MTP       , 0xba80, "UndefinedDocument"},
    {USB_PTP_FLAVOR_MTP       , 0xba81, "AbstractDocument"},
    {USB_PTP_FLAVOR_MTP       , 0xba82, "XMLDocument"},
    {USB_PTP_FLAVOR_MTP       , 0xba83, "MSWordDocument"},
    {USB_PTP_FLAVOR_MTP       , 0xba84, "MHTCompiledHTMLDocument"},
    {USB_PTP_FLAVOR_MTP       , 0xba85, "MSExcelSpreadsheetXLS"},
    {USB_PTP_FLAVOR_MTP       , 0xba86, "MSPowerpointPresentationPPT"},
    {USB_PTP_FLAVOR_MTP       , 0xbb00, "UndefinedMessage"},
    {USB_PTP_FLAVOR_MTP       , 0xbb01, "AbstractMessage"},
    {USB_PTP_FLAVOR_MTP       , 0xbb80, "UndefinedContact"},
    {USB_PTP_FLAVOR_MTP       , 0xbb81, "AbstractContact"},
    {USB_PTP_FLAVOR_MTP       , 0xbb82, "vCard2"},
    {USB_PTP_FLAVOR_MTP       , 0xbb83, "vCard3"},
    {USB_PTP_FLAVOR_MTP       , 0xbe00, "UndefinedCalendarItem"},
    {USB_PTP_FLAVOR_MTP       , 0xbe01, "AbstractCalendarItem"},
    {USB_PTP_FLAVOR_MTP       , 0xbe02, "vCalendar1"},
    {USB_PTP_FLAVOR_MTP       , 0xbe03, "vCalendar2"},
    {USB_PTP_FLAVOR_MTP       , 0xbe80, "UndefinedWindowsExecutable"},
    {USB_PTP_FLAVOR_MTP       , 0xbe81, "MediaCast"},
    {USB_PTP_FLAVOR_MTP       , 0xbe82, "Section"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_OPC MTP Object Properties */
static const usb_ptp_value_string_masked_t usb_ptp_opc_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0xb104, "WirelessConfigurationFile"},
    {USB_PTP_FLAVOR_ALL       , 0xd901, "BuyFlag"},
    {USB_PTP_FLAVOR_ALL       , 0xdc01, "StorageID"},
    {USB_PTP_FLAVOR_ALL       , 0xdc02, "ObjectFormat"},
    {USB_PTP_FLAVOR_ALL       , 0xdc03, "ProtectionStatus"},
    {USB_PTP_FLAVOR_ALL       , 0xdc04, "ObjectSize"},
    {USB_PTP_FLAVOR_ALL       , 0xdc05, "AssociationType"},
    {USB_PTP_FLAVOR_ALL       , 0xdc06, "AssociationDesc"},
    {USB_PTP_FLAVOR_ALL       , 0xdc07, "ObjectFileName"},
    {USB_PTP_FLAVOR_ALL       , 0xdc08, "DateCreated"},
    {USB_PTP_FLAVOR_ALL       , 0xdc09, "DateModified"},
    {USB_PTP_FLAVOR_ALL       , 0xdc0a, "Keywords"},
    {USB_PTP_FLAVOR_ALL       , 0xdc0b, "ParentObject"},
    {USB_PTP_FLAVOR_ALL       , 0xdc0c, "AllowedFolderContents"},
    {USB_PTP_FLAVOR_ALL       , 0xdc0d, "Hidden"},
    {USB_PTP_FLAVOR_ALL       , 0xdc0e, "SystemObject"},
    {USB_PTP_FLAVOR_ALL       , 0xdc41, "PersistentUniqueObjectIdentifier"},
    {USB_PTP_FLAVOR_ALL       , 0xdc42, "SyncID"},
    {USB_PTP_FLAVOR_ALL       , 0xdc43, "PropertyBag"},
    {USB_PTP_FLAVOR_ALL       , 0xdc44, "Name"},
    {USB_PTP_FLAVOR_ALL       , 0xdc45, "CreatedBy"},
    {USB_PTP_FLAVOR_ALL       , 0xdc46, "Artist"},
    {USB_PTP_FLAVOR_ALL       , 0xdc47, "DateAuthored"},
    {USB_PTP_FLAVOR_ALL       , 0xdc48, "Description"},
    {USB_PTP_FLAVOR_ALL       , 0xdc49, "URLReference"},
    {USB_PTP_FLAVOR_ALL       , 0xdc4a, "LanguageLocale"},
    {USB_PTP_FLAVOR_ALL       , 0xdc4b, "CopyrightInformation"},
    {USB_PTP_FLAVOR_ALL       , 0xdc4c, "Source"},
    {USB_PTP_FLAVOR_ALL       , 0xdc4d, "OriginLocation"},
    {USB_PTP_FLAVOR_ALL       , 0xdc4e, "DateAdded"},
    {USB_PTP_FLAVOR_ALL       , 0xdc4f, "NonConsumable"},
    {USB_PTP_FLAVOR_ALL       , 0xdc50, "CorruptOrUnplayable"},
    {USB_PTP_FLAVOR_ALL       , 0xdc51, "ProducerSerialNumber"},
    {USB_PTP_FLAVOR_ALL       , 0xdc81, "RepresentativeSampleFormat"},
    {USB_PTP_FLAVOR_ALL       , 0xdc82, "RepresentativeSampleSize"},
    {USB_PTP_FLAVOR_ALL       , 0xdc83, "RepresentativeSampleHeight"},
    {USB_PTP_FLAVOR_ALL       , 0xdc84, "RepresentativeSampleWidth"},
    {USB_PTP_FLAVOR_ALL       , 0xdc85, "RepresentativeSampleDuration"},
    {USB_PTP_FLAVOR_ALL       , 0xdc86, "RepresentativeSampleData"},
    {USB_PTP_FLAVOR_ALL       , 0xdc87, "Width"},
    {USB_PTP_FLAVOR_ALL       , 0xdc88, "Height"},
    {USB_PTP_FLAVOR_ALL       , 0xdc89, "Duration"},
    {USB_PTP_FLAVOR_ALL       , 0xdc8a, "Rating"},
    {USB_PTP_FLAVOR_ALL       , 0xdc8b, "Track"},
    {USB_PTP_FLAVOR_ALL       , 0xdc8c, "Genre"},
    {USB_PTP_FLAVOR_ALL       , 0xdc8d, "Credits"},
    {USB_PTP_FLAVOR_ALL       , 0xdc8e, "Lyrics"},
    {USB_PTP_FLAVOR_ALL       , 0xdc8f, "SubscriptionContentID"},
    {USB_PTP_FLAVOR_ALL       , 0xdc90, "ProducedBy"},
    {USB_PTP_FLAVOR_ALL       , 0xdc91, "UseCount"},
    {USB_PTP_FLAVOR_ALL       , 0xdc92, "SkipCount"},
    {USB_PTP_FLAVOR_ALL       , 0xdc93, "LastAccessed"},
    {USB_PTP_FLAVOR_ALL       , 0xdc94, "ParentalRating"},
    {USB_PTP_FLAVOR_ALL       , 0xdc95, "MetaGenre"},
    {USB_PTP_FLAVOR_ALL       , 0xdc96, "Composer"},
    {USB_PTP_FLAVOR_ALL       , 0xdc97, "EffectiveRating"},
    {USB_PTP_FLAVOR_ALL       , 0xdc98, "Subtitle"},
    {USB_PTP_FLAVOR_ALL       , 0xdc99, "OriginalReleaseDate"},
    {USB_PTP_FLAVOR_ALL       , 0xdc9a, "AlbumName"},
    {USB_PTP_FLAVOR_ALL       , 0xdc9b, "AlbumArtist"},
    {USB_PTP_FLAVOR_ALL       , 0xdc9c, "Mood"},
    {USB_PTP_FLAVOR_ALL       , 0xdc9d, "DRMStatus"},
    {USB_PTP_FLAVOR_ALL       , 0xdc9e, "SubDescription"},
    {USB_PTP_FLAVOR_ALL       , 0xdcd1, "IsCropped"},
    {USB_PTP_FLAVOR_ALL       , 0xdcd2, "IsColorCorrected"},
    {USB_PTP_FLAVOR_ALL       , 0xdcd3, "ImageBitDepth"},
    {USB_PTP_FLAVOR_ALL       , 0xdcd4, "Fnumber"},
    {USB_PTP_FLAVOR_ALL       , 0xdcd5, "ExposureTime"},
    {USB_PTP_FLAVOR_ALL       , 0xdcd6, "ExposureIndex"},
    {USB_PTP_FLAVOR_ALL       , 0xdce0, "DisplayName"},
    {USB_PTP_FLAVOR_ALL       , 0xdce1, "BodyText"},
    {USB_PTP_FLAVOR_ALL       , 0xdce2, "Subject"},
    {USB_PTP_FLAVOR_ALL       , 0xdce3, "Priority"},
    {USB_PTP_FLAVOR_ALL       , 0xdd00, "GivenName"},
    {USB_PTP_FLAVOR_ALL       , 0xdd01, "MiddleNames"},
    {USB_PTP_FLAVOR_ALL       , 0xdd02, "FamilyName"},
    {USB_PTP_FLAVOR_ALL       , 0xdd03, "Prefix"},
    {USB_PTP_FLAVOR_ALL       , 0xdd04, "Suffix"},
    {USB_PTP_FLAVOR_ALL       , 0xdd05, "PhoneticGivenName"},
    {USB_PTP_FLAVOR_ALL       , 0xdd06, "PhoneticFamilyName"},
    {USB_PTP_FLAVOR_ALL       , 0xdd07, "EmailPrimary"},
    {USB_PTP_FLAVOR_ALL       , 0xdd08, "EmailPersonal1"},
    {USB_PTP_FLAVOR_ALL       , 0xdd09, "EmailPersonal2"},
    {USB_PTP_FLAVOR_ALL       , 0xdd0a, "EmailBusiness1"},
    {USB_PTP_FLAVOR_ALL       , 0xdd0b, "EmailBusiness2"},
    {USB_PTP_FLAVOR_ALL       , 0xdd0c, "EmailOthers"},
    {USB_PTP_FLAVOR_ALL       , 0xdd0d, "PhoneNumberPrimary"},
    {USB_PTP_FLAVOR_ALL       , 0xdd0e, "PhoneNumberPersonal"},
    {USB_PTP_FLAVOR_ALL       , 0xdd0f, "PhoneNumberPersonal2"},
    {USB_PTP_FLAVOR_ALL       , 0xdd10, "PhoneNumberBusiness"},
    {USB_PTP_FLAVOR_ALL       , 0xdd11, "PhoneNumberBusiness2"},
    {USB_PTP_FLAVOR_ALL       , 0xdd12, "PhoneNumberMobile"},
    {USB_PTP_FLAVOR_ALL       , 0xdd13, "PhoneNumberMobile2"},
    {USB_PTP_FLAVOR_ALL       , 0xdd14, "FaxNumberPrimary"},
    {USB_PTP_FLAVOR_ALL       , 0xdd15, "FaxNumberPersonal"},
    {USB_PTP_FLAVOR_ALL       , 0xdd16, "FaxNumberBusiness"},
    {USB_PTP_FLAVOR_ALL       , 0xdd17, "PagerNumber"},
    {USB_PTP_FLAVOR_ALL       , 0xdd18, "PhoneNumberOthers"},
    {USB_PTP_FLAVOR_ALL       , 0xdd19, "PrimaryWebAddress"},
    {USB_PTP_FLAVOR_ALL       , 0xdd1a, "PersonalWebAddress"},
    {USB_PTP_FLAVOR_ALL       , 0xdd1b, "BusinessWebAddress"},
    {USB_PTP_FLAVOR_ALL       , 0xdd1c, "InstantMessengerAddress"},
    {USB_PTP_FLAVOR_ALL       , 0xdd1d, "InstantMessengerAddress2"},
    {USB_PTP_FLAVOR_ALL       , 0xdd1e, "InstantMessengerAddress3"},
    {USB_PTP_FLAVOR_ALL       , 0xdd1f, "PostalAddressPersonalFull"},
    {USB_PTP_FLAVOR_ALL       , 0xdd20, "PostalAddressPersonalFullLine1"},
    {USB_PTP_FLAVOR_ALL       , 0xdd21, "PostalAddressPersonalFullLine2"},
    {USB_PTP_FLAVOR_ALL       , 0xdd22, "PostalAddressPersonalFullCity"},
    {USB_PTP_FLAVOR_ALL       , 0xdd23, "PostalAddressPersonalFullRegion"},
    {USB_PTP_FLAVOR_ALL       , 0xdd24, "PostalAddressPersonalFullPostalCode"},
    {USB_PTP_FLAVOR_ALL       , 0xdd25, "PostalAddressPersonalFullCountry"},
    {USB_PTP_FLAVOR_ALL       , 0xdd26, "PostalAddressBusinessFull"},
    {USB_PTP_FLAVOR_ALL       , 0xdd27, "PostalAddressBusinessLine1"},
    {USB_PTP_FLAVOR_ALL       , 0xdd28, "PostalAddressBusinessLine2"},
    {USB_PTP_FLAVOR_ALL       , 0xdd29, "PostalAddressBusinessCity"},
    {USB_PTP_FLAVOR_ALL       , 0xdd2a, "PostalAddressBusinessRegion"},
    {USB_PTP_FLAVOR_ALL       , 0xdd2b, "PostalAddressBusinessPostalCode"},
    {USB_PTP_FLAVOR_ALL       , 0xdd2c, "PostalAddressBusinessCountry"},
    {USB_PTP_FLAVOR_ALL       , 0xdd2d, "PostalAddressOtherFull"},
    {USB_PTP_FLAVOR_ALL       , 0xdd2e, "PostalAddressOtherLine1"},
    {USB_PTP_FLAVOR_ALL       , 0xdd2f, "PostalAddressOtherLine2"},
    {USB_PTP_FLAVOR_ALL       , 0xdd30, "PostalAddressOtherCity"},
    {USB_PTP_FLAVOR_ALL       , 0xdd31, "PostalAddressOtherRegion"},
    {USB_PTP_FLAVOR_ALL       , 0xdd32, "PostalAddressOtherPostalCode"},
    {USB_PTP_FLAVOR_ALL       , 0xdd33, "PostalAddressOtherCountry"},
    {USB_PTP_FLAVOR_ALL       , 0xdd34, "OrganizationName"},
    {USB_PTP_FLAVOR_ALL       , 0xdd35, "PhoneticOrganizationName"},
    {USB_PTP_FLAVOR_ALL       , 0xdd36, "Role"},
    {USB_PTP_FLAVOR_ALL       , 0xdd37, "Birthdate"},
    {USB_PTP_FLAVOR_ALL       , 0xdd40, "MessageTo"},
    {USB_PTP_FLAVOR_ALL       , 0xdd41, "MessageCC"},
    {USB_PTP_FLAVOR_ALL       , 0xdd42, "MessageBCC"},
    {USB_PTP_FLAVOR_ALL       , 0xdd43, "MessageRead"},
    {USB_PTP_FLAVOR_ALL       , 0xdd44, "MessageReceivedTime"},
    {USB_PTP_FLAVOR_ALL       , 0xdd45, "MessageSender"},
    {USB_PTP_FLAVOR_ALL       , 0xdd50, "ActivityBeginTime"},
    {USB_PTP_FLAVOR_ALL       , 0xdd51, "ActivityEndTime"},
    {USB_PTP_FLAVOR_ALL       , 0xdd52, "ActivityLocation"},
    {USB_PTP_FLAVOR_ALL       , 0xdd54, "ActivityRequiredAttendees"},
    {USB_PTP_FLAVOR_ALL       , 0xdd55, "ActivityOptionalAttendees"},
    {USB_PTP_FLAVOR_ALL       , 0xdd56, "ActivityResources"},
    {USB_PTP_FLAVOR_ALL       , 0xdd57, "ActivityAccepted"},
    {USB_PTP_FLAVOR_ALL       , 0xdd5d, "Owner"},
    {USB_PTP_FLAVOR_ALL       , 0xdd5e, "Editor"},
    {USB_PTP_FLAVOR_ALL       , 0xdd5f, "Webmaster"},
    {USB_PTP_FLAVOR_ALL       , 0xdd60, "URLSource"},
    {USB_PTP_FLAVOR_ALL       , 0xdd61, "URLDestination"},
    {USB_PTP_FLAVOR_ALL       , 0xdd62, "TimeBookmark"},
    {USB_PTP_FLAVOR_ALL       , 0xdd63, "ObjectBookmark"},
    {USB_PTP_FLAVOR_ALL       , 0xdd64, "ByteBookmark"},
    {USB_PTP_FLAVOR_ALL       , 0xdd70, "LastBuildDate"},
    {USB_PTP_FLAVOR_ALL       , 0xdd71, "TimetoLive"},
    {USB_PTP_FLAVOR_ALL       , 0xdd72, "MediaGUID"},
    {USB_PTP_FLAVOR_ALL       , 0xde91, "TotalBitRate"},
    {USB_PTP_FLAVOR_ALL       , 0xde92, "BitRateType"},
    {USB_PTP_FLAVOR_ALL       , 0xde93, "SampleRate"},
    {USB_PTP_FLAVOR_ALL       , 0xde94, "NumberOfChannels"},
    {USB_PTP_FLAVOR_ALL       , 0xde95, "AudioBitDepth"},
    {USB_PTP_FLAVOR_ALL       , 0xde97, "ScanDepth"},
    {USB_PTP_FLAVOR_ALL       , 0xde99, "AudioWAVECodec"},
    {USB_PTP_FLAVOR_ALL       , 0xde9a, "AudioBitRate"},
    {USB_PTP_FLAVOR_ALL       , 0xde9b, "VideoFourCCCodec"},
    {USB_PTP_FLAVOR_ALL       , 0xde9c, "VideoBitRate"},
    {USB_PTP_FLAVOR_ALL       , 0xde9d, "FramesPerThousandSeconds"},
    {USB_PTP_FLAVOR_ALL       , 0xde9e, "KeyFrameDistance"},
    {USB_PTP_FLAVOR_ALL       , 0xde9f, "BufferSize"},
    {USB_PTP_FLAVOR_ALL       , 0xdea0, "EncodingQuality"},
    {USB_PTP_FLAVOR_ALL       , 0xdea1, "EncodingProfile"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_OPFF MTP Device Property Codes */
static const usb_ptp_value_string_masked_t usb_ptp_opff_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x00, "None"},
    {USB_PTP_FLAVOR_ALL       , 0x01, "Range"},
    {USB_PTP_FLAVOR_ALL       , 0x02, "Enumeration"},
    {USB_PTP_FLAVOR_ALL       , 0x03, "DateTime"},
    {USB_PTP_FLAVOR_ALL       , 0x04, "FixedLengthArray"},
    {USB_PTP_FLAVOR_ALL       , 0x05, "RegularExpression"},
    {USB_PTP_FLAVOR_ALL       , 0x06, "ByteArray"},
    {USB_PTP_FLAVOR_ALL       , 0xff, "LongString"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_PS Protection Status */
static const usb_ptp_value_string_masked_t usb_ptp_ps_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x0000, "NoProtection"},
    {USB_PTP_FLAVOR_ALL       , 0x0001, "ReadOnly"},
    {USB_PTP_FLAVOR_MTP       , 0x8002, "ReadOnlyData"},
    {USB_PTP_FLAVOR_MTP       , 0x8003, "NonTransferableData"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_RC Response Codes */
static const usb_ptp_value_string_masked_t usb_ptp_rc_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x2000, "Undefined"},
    {USB_PTP_FLAVOR_ALL       , 0x2001, "OK"},
    {USB_PTP_FLAVOR_ALL       , 0x2002, "GeneralError"},
    {USB_PTP_FLAVOR_ALL       , 0x2003, "SessionNotOpen"},
    {USB_PTP_FLAVOR_ALL       , 0x2004, "InvalidTransactionID"},
    {USB_PTP_FLAVOR_ALL       , 0x2005, "OperationNotSupported"},
    {USB_PTP_FLAVOR_ALL       , 0x2006, "ParameterNotSupported"},
    {USB_PTP_FLAVOR_ALL       , 0x2007, "IncompleteTransfer"},
    {USB_PTP_FLAVOR_ALL       , 0x2008, "InvalidStorageId"},
    {USB_PTP_FLAVOR_ALL       , 0x2009, "InvalidObjectHandle"},
    {USB_PTP_FLAVOR_ALL       , 0x200a, "DevicePropNotSupported"},
    {USB_PTP_FLAVOR_ALL       , 0x200b, "InvalidObjectFormatCode"},
    {USB_PTP_FLAVOR_ALL       , 0x200c, "StoreFull"},
    {USB_PTP_FLAVOR_ALL       , 0x200d, "ObjectWriteProtected"},
    {USB_PTP_FLAVOR_ALL       , 0x200e, "StoreReadOnly"},
    {USB_PTP_FLAVOR_ALL       , 0x200f, "AccessDenied"},
    {USB_PTP_FLAVOR_ALL       , 0x2010, "NoThumbnailPresent"},
    {USB_PTP_FLAVOR_ALL       , 0x2011, "SelfTestFailed"},
    {USB_PTP_FLAVOR_ALL       , 0x2012, "PartialDeletion"},
    {USB_PTP_FLAVOR_ALL       , 0x2013, "StoreNotAvailable"},
    {USB_PTP_FLAVOR_ALL       , 0x2014, "SpecificationByFormatUnsupported"},
    {USB_PTP_FLAVOR_ALL       , 0x2015, "NoValidObjectInfo"},
    {USB_PTP_FLAVOR_ALL       , 0x2016, "InvalidCodeFormat"},
    {USB_PTP_FLAVOR_ALL       , 0x2017, "UnknownVendorCode"},
    {USB_PTP_FLAVOR_ALL       , 0x2018, "CaptureAlreadyTerminated"},
    {USB_PTP_FLAVOR_ALL       , 0x2019, "DeviceBusy"},
    {USB_PTP_FLAVOR_ALL       , 0x201a, "InvalidParentObject"},
    {USB_PTP_FLAVOR_ALL       , 0x201b, "InvalidDevicePropFormat"},
    {USB_PTP_FLAVOR_ALL       , 0x201c, "InvalidDevicePropValue"},
    {USB_PTP_FLAVOR_ALL       , 0x201d, "InvalidParameter"},
    {USB_PTP_FLAVOR_ALL       , 0x201e, "SessionAlreadyOpened"},
    {USB_PTP_FLAVOR_ALL       , 0x201f, "TransactionCanceled"},
    {USB_PTP_FLAVOR_ALL       , 0x2020, "SpecificationOfDestinationUnsupported"},
    {USB_PTP_FLAVOR_ALL       , 0x2021, "InvalidEnumHandle"},
    {USB_PTP_FLAVOR_ALL       , 0x2022, "NoStreamEnabled"},
    {USB_PTP_FLAVOR_ALL       , 0x2023, "InvalidDataSet"},
    {USB_PTP_FLAVOR_CANON     , 0xa001, "UnknownCommand"},
    {USB_PTP_FLAVOR_CANON     , 0xa001, "UNKNOWN_COMMAND"},
    {USB_PTP_FLAVOR_KODAK     , 0xa001, "FilenameRequired"},
    {USB_PTP_FLAVOR_NIKON     , 0xa001, "HardwareError"},
    {USB_PTP_FLAVOR_KODAK     , 0xa002, "FilenameConflicts"},
    {USB_PTP_FLAVOR_NIKON     , 0xa002, "OutOfFocus"},
    {USB_PTP_FLAVOR_KODAK     , 0xa003, "FilenameInvalid"},
    {USB_PTP_FLAVOR_NIKON     , 0xa003, "ChangeCameraModeFailed"},
    {USB_PTP_FLAVOR_NIKON     , 0xa004, "InvalidStatus"},
    {USB_PTP_FLAVOR_CANON     , 0xa005, "OperationRefused"},
    {USB_PTP_FLAVOR_CANON     , 0xa005, "OPERATION_REFUSED"},
    {USB_PTP_FLAVOR_NIKON     , 0xa005, "SetPropertyNotSupported"},
    {USB_PTP_FLAVOR_CANON     , 0xa006, "LensCoverClosed"},
    {USB_PTP_FLAVOR_CANON     , 0xa006, "LENS_COVER"},
    {USB_PTP_FLAVOR_NIKON     , 0xa006, "WbResetError"},
    {USB_PTP_FLAVOR_NIKON     , 0xa007, "DustReferenceError"},
    {USB_PTP_FLAVOR_NIKON     , 0xa008, "ShutterSpeedBulb"},
    {USB_PTP_FLAVOR_CANON     , 0xa009, "A009"},
    {USB_PTP_FLAVOR_NIKON     , 0xa009, "MirrorUpSequence"},
    {USB_PTP_FLAVOR_NIKON     , 0xa00a, "CameraModeNotAdjustFNumber"},
    {USB_PTP_FLAVOR_NIKON     , 0xa00b, "NotLiveView"},
    {USB_PTP_FLAVOR_NIKON     , 0xa00c, "MfDriveStepEnd"},
    {USB_PTP_FLAVOR_NIKON     , 0xa00e, "MfDriveStepInsufficiency"},
    {USB_PTP_FLAVOR_NIKON     , 0xa00f, "NoFullHDPresent"},
    {USB_PTP_FLAVOR_NIKON     , 0xa021, "StoreError"},
    {USB_PTP_FLAVOR_NIKON     , 0xa022, "AdvancedTransferCancel"},
    {USB_PTP_FLAVOR_NIKON     , 0xa022, "StoreUnformatted"},
    {USB_PTP_FLAVOR_CANON     , 0xa101, "BATTERY_LOW"},
    {USB_PTP_FLAVOR_CANON     , 0xa101, "LowBattery"},
    {USB_PTP_FLAVOR_CANON     , 0xa102, "ObjectNotReady"},
    {USB_PTP_FLAVOR_CANON     , 0xa102, "NOT_READY"},
    {USB_PTP_FLAVOR_CANON     , 0xa104, "CannotMakeObject"},
    {USB_PTP_FLAVOR_CANON     , 0xa106, "MemoryStatusNotReady"},
    {USB_PTP_FLAVOR_MTP       , 0xa121, "Invalid_WFC_Syntax"},
    {USB_PTP_FLAVOR_MTP       , 0xa122, "WFC_Version_Not_Supported"},
    {USB_PTP_FLAVOR_MTP       , 0xa170, "Invalid_Media_Session_ID"},
    {USB_PTP_FLAVOR_MTP       , 0xa171, "Media_Session_Limit_Reached"},
    {USB_PTP_FLAVOR_MTP       , 0xa172, "No_More_Data"},
    {USB_PTP_FLAVOR_NIKON     , 0xa200, "Bulb_Release_Busy"},
    {USB_PTP_FLAVOR_NIKON     , 0xa201, "Silent_Release_Busy"},
    {USB_PTP_FLAVOR_NIKON     , 0xa202, "MovieFrame_Release_Busy"},
    {USB_PTP_FLAVOR_NIKON     , 0xa204, "Shutter_Speed_Time"},
    {USB_PTP_FLAVOR_NIKON     , 0xa207, "Waiting_2ndRelease"},
    {USB_PTP_FLAVOR_NIKON     , 0xa208, "MirrorUpCapture_Already_Start"},
    {USB_PTP_FLAVOR_NIKON     , 0xa209, "Invalid_SBAttribute_Value"},
    {USB_PTP_FLAVOR_MTP       , 0xa800, "Undefined"},
    {USB_PTP_FLAVOR_MTP       , 0xa801, "Invalid_ObjectPropCode"},
    {USB_PTP_FLAVOR_MTP       , 0xa802, "Invalid_ObjectProp_Format"},
    {USB_PTP_FLAVOR_MTP       , 0xa803, "Invalid_ObjectProp_Value"},
    {USB_PTP_FLAVOR_MTP       , 0xa804, "Invalid_ObjectReference"},
    {USB_PTP_FLAVOR_MTP       , 0xa806, "Invalid_Dataset"},
    {USB_PTP_FLAVOR_MTP       , 0xa807, "Specification_By_Group_Unsupported"},
    {USB_PTP_FLAVOR_MTP       , 0xa808, "Specification_By_Depth_Unsupported"},
    {USB_PTP_FLAVOR_MTP       , 0xa809, "Object_Too_Large"},
    {USB_PTP_FLAVOR_MTP       , 0xa80a, "ObjectProp_Not_Supported"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_ST Storage Types */
static const usb_ptp_value_string_masked_t usb_ptp_st_mvals[] = {
    {USB_PTP_FLAVOR_ALL       , 0x0000, "Undefined"},
    {USB_PTP_FLAVOR_ALL       , 0x0001, "FixedROM"},
    {USB_PTP_FLAVOR_ALL       , 0x0002, "RemovableROM"},
    {USB_PTP_FLAVOR_ALL       , 0x0003, "FixedRAM"},
    {USB_PTP_FLAVOR_ALL       , 0x0004, "RemovableRAM"},
    {USB_PTP_FLAVOR_NONE      , 0, NULL}
};
/* PTP_VENDOR Vendor IDs */
static const value_string usb_ptp_vendor_vals[] = {
    {0x00000001, "EASTMAN_KODAK"},
    {0x00000002, "SEIKO_EPSON"},
    {0x00000003, "AGILENT"},
    {0x00000004, "POLAROID"},
    {0x00000005, "AGFA_GEVAERT"},
    {0x00000006, "MICROSOFT"},
    {0x00000007, "EQUINOX"},
    {0x00000008, "VIEWQUEST"},
    {0x00000009, "STMICROELECTRONICS"},
    {0x0000000A, "NIKON"},
    {0x0000000B, "CANON"},
    {0x0000000C, "FOTONATION"},
    {0x0000000D, "PENTAX"},
    {0x0000000E, "FUJI"},
    {0x00000011, "SONY"},
    {0x00000012, "NDD_MEDICAL_TECHNOLOGIES"},
    {0x0000001a, "SAMSUNG"},
    {0x0000001b, "PARROT"},
    {0x0000001c, "PANASONIC"},
    {0x0000fffc, "GP_LEICA"},
    {0x0000fffd, "GP_OLYMPUS_OMD"},
    {0x0000fffe, "GP_OLYMPUS"},
    {0xffffffff, "MTP"},
    {0, NULL}
};
/* END AUTOGENERATED CODE */
