/*
 * This file was generated by running ./tools/make-dmx-manfid.py
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * The ESTA Manufacturer ID Database is available at:
 * <https://tsp.esta.org/tsp/working_groups/CP/mfctrIDs.php>
 *
 */

#include "packet-dmx-manfid.h"

/*
 * ESTA codes download date: 2025-12-28
 */
static const value_string dmx_esta_manfid_vals[] = {
  { 0x0000, "ESTA / PLASA" },
  { 0x0001, "GEE" },
  { 0x0002, "Abstract AVR Ltd." },
  { 0x0003, "Chromatech Lighting Co., Ltd." },
  { 0x0007, "Tauran" },
  { 0x0008, "Guangdong Nanguang Photo & Video Systems Co., Ltd." },
  { 0x0009, "Aputure Imaging Industries Co., Ltd." },
  { 0x000A, "Interactive Imagination Ltd." },
  { 0x000B, "Phospec Industries Inc." },
  { 0x000C, "WAC Lighting Co." },
  { 0x000D, "Guangzhou Haoteng Lighting Co., Ltd." },
  { 0x000E, "Yaoxing Lighting Equipment (Guanghzou) Co., Ltd." },
  { 0x000F, "Shenzhen L-Thinker Technology Co., Ltd." },
  { 0x0010, "Dongguan Mi Xing Electronic Technology Co., Ltd." },
  { 0x0011, "Beijing Kedeshengye Technology Service Co., Ltd." },
  { 0x0012, "Apex Pro Light Co., Ltd." },
  { 0x0013, "Litemover BV" },
  { 0x0014, "SIRS Electronics, Inc." },
  { 0x0015, "Lumencraft Lighting Solutions" },
  { 0x0016, "Shenzhen Xuntek Electronics Co., Ltd" },
  { 0x0017, "Ereimul" },
  { 0x0018, "Macroblock, Inc." },
  { 0x0019, "Odelic Co., Ltd." },
  { 0x001A, "DLL Ltd." },
  { 0x001B, "Changsha Sunrise Electronic Technology Co. Ltd." },
  { 0x001C, "Kindwin Technology (HK) Ltd." },
  { 0x001D, "Luminator Technology Group" },
  { 0x001E, "Shenzhen Lumi Lime Technology Limited" },
  { 0x0020, "Wattle IT" },
  { 0x0021, "Electric Foundry Ltd." },
  { 0x0022, "PixelFLEX, LLC" },
  { 0x0057, "Blackbezt Lighting Technology Co., Ltd." },
  { 0x0058, "Big Dipper Laser Science and Technology Co.,Ltd." },
  { 0x0059, "Laysion Lighting Technology Co., Ltd." },
  { 0x005A, "TPD Lighting" },
  { 0x006A, "AIMTECH Electronik Tasarim Ltd. Sti." },
  { 0x006B, "SALZBRENNER media GmbH" },
  { 0x006C, "Flash-Butrym Sp.J." },
  { 0x006D, "AA Tasarim Ltd." },
  { 0x006E, "WHITEvoid GmbH" },
  { 0x006F, "AC Power Distribution/ACT Lighting Inc." },
  { 0x0070, "Instalighting GmbH" },
  { 0x0071, "Guangzhou Huaxinyuan Electronics Co., Ltd." },
  { 0x0072, "Guangzhou Zenith Aurora Lighting Co., Ltd." },
  { 0x0073, "Meijay Technologies Co., Ltd." },
  { 0x0074, "Thomann GmbH" },
  { 0x0075, "ODELI" },
  { 0x0076, "R. S. Schwarze Elektrotechnik Moderne Industrieelektronik GmbH" },
  { 0x0077, "CHAMP Licht" },
  { 0x0078, "Andy Lighting Technology Group Ltd." },
  { 0x0079, "Leyard Opto Electronics Co., Ltd." },
  { 0x007A, "Equivalent" },
  { 0x007B, "alurays lighting technology GmbH" },
  { 0x007C, "Huizhou Desay Intelligent Technology Co., Ltd." },
  { 0x007D, "JMS Pro Light" },
  { 0x007E, "Stichting Hypar Collective" },
  { 0x0080, "Shenzhen AOTO Electronics Co., Ltd." },
  { 0x0081, "Pino Solutions" },
  { 0x0082, "LKE Lasershowtechnik GmbH" },
  { 0x0083, "Guangzhou Bright Moon Technology Co., Ltd." },
  { 0x0084, "LEDIXIS (Exalux brand)" },
  { 0x0085, "Guangzhou Nanshi Light Equipment Co., Ltd." },
  { 0x0086, "Intella System Co., Ltd." },
  { 0x0087, "LMBD" },
  { 0x0088, "Guangzhou YaFeng Optoelectronic Equipment Co., Ltd." },
  { 0x0089, "Vulcan Lighting" },
  { 0x008A, "Guangzhou Lees Electronics Co., Ltd." },
  { 0x008B, "Opto Tech Corporation" },
  { 0x008C, "LRX Lighting (Dwight Crane Ltd.)" },
  { 0x008D, "Guangzhou Minghao Electronic Technology Co., Ltd." },
  { 0x008E, "Guangzhou Ao Mei Di Stage Lighting Equipment Co.,Ltd." },
  { 0x008F, "Jiangmen Coolfish Technology Co., Ltd." },
  { 0x0090, "Cyclops Lighting" },
  { 0x0091, "Guangzhou Shuozhi Optoelectronic Technology Co., Ltd. (Konelite)" },
  { 0x0092, "digiLED (UK) Ltd." },
  { 0x0093, "Luminous Show Technology Ltd." },
  { 0x0094, "Joinmax Display Technology Co., Ltd." },
  { 0x0095, "Ningbo Jeg Lighting Tech Co., Ltd." },
  { 0x0096, "SiChuan YuZhiWei Information Technology Lt., Co." },
  { 0x0097, "AdvancedRay (Beijing) Science & Technology Industries Co., Ltd." },
  { 0x0098, "Dedo Weigert Film GmbH" },
  { 0x009A, "Golden Sea Disco Light Manufacturer" },
  { 0x009B, "Guangzhou Jiawei Electronic Technology Co., Ltd." },
  { 0x009C, "LuxBalance Lighting" },
  { 0x009E, "Guangzhou Flying Butterfly Stage Lighting Equipment Co., Ltd." },
  { 0x009F, "Enedo Power SpA" },
  { 0x00A0, "Shenzhen Dicolor Optoelectronics Co., Ltd." },
  { 0x00A1, "Creative Lighting And Sound Systems Pty Ltd." },
  { 0x00A2, "EMP Designs Ltd." },
  { 0x00A3, "GuangZhou Huanshi Lighting Equipment Co., Limited" },
  { 0x00A4, "SAKMA Electronica Industrial S.A.U." },
  { 0x00A5, "Delta Electronics, Inc." },
  { 0x00A6, "Sensation Lighting Technology Co., Ltd." },
  { 0x00A7, "Syncronorm GmbH" },
  { 0x00A8, "Iwasaki Electric Co., Ltd." },
  { 0x00A9, "Richter Lighting Technologies GmbH" },
  { 0x00AA, "Hangzhou Easun Technology Co., Ltd." },
  { 0x00AB, "MFX Asia Co., Ltd" },
  { 0x00AC, "ZhouChuang Industrial Co. Limited" },
  { 0x00AD, "ColorDeve Co. Limited" },
  { 0x00AE, "Vitrulux Ltd" },
  { 0x00AF, "NanoPLC LLC" },
  { 0x00B0, "ARENA LUCI s.r.l." },
  { 0x00B1, "Guangzhou Omarte Lighting Co., Ltd." },
  { 0x00B2, "unonovesette srl" },
  { 0x00B3, "LANTERN" },
  { 0x00B4, "Lumos Design" },
  { 0x00B5, "Suga koubou Co., Ltd." },
  { 0x00B6, "DiGidot Technologies BV" },
  { 0x00B7, "Bron Elektronik AG" },
  { 0x00B8, "Shenzhen Singba Light Technology Co., Ltd." },
  { 0x00B9, "Guangzhou Baiyun District Sanjie Eletronic Stage Lighting Audio Equipment Factory" },
  { 0x00BA, "LiteGear Inc." },
  { 0x00BB, "Digital Lighting Engineering & Design, LLC" },
  { 0x00BC, "Ambion GmbH (Ambrain)" },
  { 0x00BD, "numeo GmbH" },
  { 0x00BE, "The Light Luminary for Cine and TV S.L. (VELVET LIGHT)" },
  { 0x00BF, "LumiOS (GTR Industries)" },
  { 0x00C0, "Foshan Yinhe Lanjing Lighting & Electrical Co., Ltd." },
  { 0x00C1, "Jingchuang Water Technology" },
  { 0x00C2, "Ledogen" },
  { 0x00C3, "Xicato" },
  { 0x00C4, "Guangzhou Dahe Electronic Technology Co. Ltd." },
  { 0x00C5, "DAGE Stage Lighting Master Co., Ltd." },
  { 0x00C6, "Guangzhou Lantian Electronic Technology Co., Ltd." },
  { 0x00C7, "THOR" },
  { 0x00C8, "Constell8 NV" },
  { 0x00C9, "Pangaea Technology" },
  { 0x0101, "St. Anne Engineering GmbH" },
  { 0x0102, "Bortis Elektronik" },
  { 0x0103, "Fontana Technologies" },
  { 0x0104, "Blizzard Lighting, LLC" },
  { 0x0105, "LIGHTHOW (SHANGHAI) Ltd." },
  { 0x0106, "A.L.A. Equipment Company Ltd." },
  { 0x0107, "Inventronics (Hangzhou), Inc." },
  { 0x0108, "Haya Lighting Equipment Limited" },
  { 0x0109, "V-Productions" },
  { 0x010A, "Elektralite" },
  { 0x010B, "DesignLED Technology (HK) Co., Ltd." },
  { 0x010C, "SES (Entertainment Services) Ltd." },
  { 0x010D, "Lumos / DMLite" },
  { 0x010E, "Guangzhou ATON Lighting Technology Co.,Ltd" },
  { 0x010F, "Saco Technologies Inc." },
  { 0x0110, "APF S.r.l." },
  { 0x0111, "Radig Hard & Software" },
  { 0x0112, "RGB Lighting Equipment Co., Ltd." },
  { 0x0113, "Airstar SAS" },
  { 0x0114, "BSL Lighting" },
  { 0x0115, "Kontrolcla Show Control S.L." },
  { 0x0116, "SmoothLUX B.V." },
  { 0x0117, "AD Toyo Lighting (Guangzhou) Co.,Ltd" },
  { 0x0118, "Vello Light Co., Ltd." },
  { 0x0119, "Peter Schneyder Design Management GmbH" },
  { 0x011A, "Guangzhou Hotion Technology Co., Ltd." },
  { 0x011B, "Jumptronic GmbH" },
  { 0x011C, "Letong Electronic (Guangzhou) Co., Ltd." },
  { 0x011D, "Yangzhou Zhituo Lighting Vision Technology Co., Ltd." },
  { 0x011E, "Master LED" },
  { 0x011F, "STF s.r.l." },
  { 0x0144, "KW-Veranstaltungstechnik" },
  { 0x016C, "LGR" },
  { 0x016D, "Hive Lighting" },
  { 0x016E, "Artled Technology Corp." },
  { 0x016F, "SQD Lighting Co. Ltd" },
  { 0x018F, "Guangzhou YiCheng Light Industry Ltd." },
  { 0x0190, "Wizlogics Co., Ltd." },
  { 0x0191, "Sycra Technologies" },
  { 0x0192, "Metro Marine LLC" },
  { 0x0193, "DMF Lighting" },
  { 0x0199, "Ocean LED Marine Ltd." },
  { 0x019A, "TwoGain Electronics" },
  { 0x019B, "ElectroTAS Soluciones Profesionales" },
  { 0x019C, "Ningbo Snappy Optoelectronics Co., Ltd." },
  { 0x019F, "DaisaLed Ltd." },
  { 0x01A0, "Light With LED" },
  { 0x01A1, "Yuesheng Stage Light Limited" },
  { 0x01A2, "Art Lighting Production, s.r.o." },
  { 0x01A3, "Dongguan Yongya Technology Co., Ltd" },
  { 0x01A4, "Custom Effects LED Solutions Inc." },
  { 0x01A5, "MJ Lighting Co., Ltd." },
  { 0x01A6, "Hengmei Lighting Technology Co., Ltd." },
  { 0x01A8, "ZongDa Photoelectricity Science and Technology Co., Ltd." },
  { 0x01A9, "Shenzhen Uniview LED Ltd. Co." },
  { 0x01AA, "Videndum Production Solutions Inc." },
  { 0x01AB, "Shanghai Euchips Industrial Co., Ltd." },
  { 0x01AC, "DongGuan Phcistar Optoelectronics Technology Co., Ltd." },
  { 0x01AF, "Hunan Minghe Opto Tech Co., Ltd." },
  { 0x01B1, "Lightcare A/S" },
  { 0x01B2, "DJSI Schinstad ANS (Northern Light)" },
  { 0x01B3, "Ricardo Dias" },
  { 0x01B4, "Inventeq B.V." },
  { 0x01B5, "Beijing Soft Rock Technology Development Co., Ltd." },
  { 0x01BE, "BEN-RI Electronica S.A." },
  { 0x01C7, "SCHIEDERWERK GmbH" },
  { 0x01C8, "Guangzhou JINLIN Stage Lighting Equipment Co., Ltd." },
  { 0x01C9, "ALPHA LITE Inc." },
  { 0x01CA, "CASCADE s.a.s." },
  { 0x01CB, "ILT Italy SRL" },
  { 0x01CC, "Portman Custom Lights" },
  { 0x01CD, "Compulite Systems (2000) LTD" },
  { 0x01CE, "Railiks Enterprises" },
  { 0x01CF, "SRM Technik GmbH" },
  { 0x01D0, "Shanghai Semping Electronics Co., Ltd." },
  { 0x01D1, "Yarilo Pro" },
  { 0x01D2, "GIP Innovation Tools GmbH" },
  { 0x01D3, "JSC Aksera" },
  { 0x01D4, "x-labs" },
  { 0x01D5, "Shenzhen Liantronics Co., Ltd" },
  { 0x01D6, "Argent Data Systems, Inc." },
  { 0x01D7, "LIMEDIA" },
  { 0x01D8, "Daniel Large Lighting" },
  { 0x01D9, "Lightronics Inc." },
  { 0x01DA, "Guangzhou Daisy Electronic Technology Co., Ltd." },
  { 0x01DB, "Logen Ltd." },
  { 0x01DC, "LED Linear GmbH" },
  { 0x01DD, "Photonia srl" },
  { 0x01DE, "Guangzhou Baiyun Xinxiang Lighting Equipment Factory (XPRO LIGHT)" },
  { 0x01DF, "GuangZhou Dream Lighting Equipment Co., Ltd." },
  { 0x01E0, "IBN Labs Ltd." },
  { 0x0200, "Lighting Infusion LLC" },
  { 0x0201, "Blinkinlabs, LLC" },
  { 0x0202, "Paul Heuts" },
  { 0x0203, "Artemide S.p.A" },
  { 0x0204, "LIGHTLINE Lasertechnik GmbH" },
  { 0x0205, "SmartShow UK" },
  { 0x0206, "Studio Due Light S.r.l." },
  { 0x0207, "SILL LIGHTS GmbH" },
  { 0x0208, "Shenzhen Yuming Vision Technology Co., Ltd." },
  { 0x0209, "ER Productions" },
  { 0x020A, "Seebacher GmbH" },
  { 0x0210, "Leksa Lighting Technologies Pvt. Ltd." },
  { 0x0211, "Arkaos S.A." },
  { 0x0212, "Frame The Space (FTSLED)" },
  { 0x0213, "Huizhou visionX Technology Co., Ltd." },
  { 0x0214, "Impactrum" },
  { 0x021A, "WizzuLED by Scooon" },
  { 0x0223, "ShenZhen Focus Vision Intelligent System Co., Ltd." },
  { 0x0224, "Vanguard LED Displays" },
  { 0x0225, "Northern Lights Electronic Design, LLC" },
  { 0x0235, "Company 235, LLC" },
  { 0x0238, "Jem Manufacturing Ltd" },
  { 0x0242, "ABLELITE INTERNATIONAL" },
  { 0x024C, "FBFX Ltd" },
  { 0x025B, "Imlight-Showtechnic" },
  { 0x026F, "Acuity Brands Lighting Inc." },
  { 0x0280, "Arrigo Lighting" },
  { 0x0286, "RMLX" },
  { 0x028F, "GRE Alpha Electronics Ltd." },
  { 0x02A0, "LLC Likhoslavl Plant of Lighting Engineering (Svetotehnika)" },
  { 0x02A1, "LLC Moscow Experimental Lighting Plant (TeleMechanic)" },
  { 0x02A2, "OJSC Kadoshkinsky electrotechnical" },
  { 0x02A3, "Big Bang Lightning" },
  { 0x02A4, "McNicoll Entertainment Systems" },
  { 0x02AA, "Jinnax Opto Technology Co., Ltd." },
  { 0x02AB, "Rift Labs" },
  { 0x02AC, "PSL Electronik Sanayi ve Ticaret A.S." },
  { 0x02AD, "SAVI Controls LLC" },
  { 0x02AE, "Tea Engineering Ltd." },
  { 0x02AF, "JMAZ Group, Inc." },
  { 0x02B0, "DMXControl-Projects e.V." },
  { 0x02B1, "Global Design Solutions Korea" },
  { 0x02B2, "Guangzhou Harbinger Co., Ltd." },
  { 0x02BA, "Chainzone Technology (Foshan) Co., Ltd." },
  { 0x02BC, "PXP Technology" },
  { 0x02BD, "RE-Engineering" },
  { 0x02C8, "Growflux LLC" },
  { 0x02C9, "Theatrixx Technologies" },
  { 0x02CA, "Acclaim Lighting" },
  { 0x02CB, "GVA Lighting, Inc." },
  { 0x02CC, "Brightix" },
  { 0x02D0, "Winona Lighting" },
  { 0x02D1, "Hoffmeister Leuchten GmbH" },
  { 0x02E1, "Tait Towers Manufacturing Inc." },
  { 0x02E2, "CLF Lighting BV." },
  { 0x02EA, "d3 Technologies Ltd." },
  { 0x02EB, "Amolvin Research & Development Lab." },
  { 0x02EC, "Lutron Electronics" },
  { 0x02ED, "OpenLX SP Ltd." },
  { 0x02EE, "Firma GUTKOWSKI - Gutkowski Jan" },
  { 0x02EF, "ABLETECH Co., Ltd." },
  { 0x02F0, "iColor LED Shenzhen Co., Ltd." },
  { 0x02F1, "Lichtmanufaktur Berlin GmbH" },
  { 0x02FE, "L8 LLC" },
  { 0x02FF, "Guangzhou Eway Stage Equipment Technology Co., Ltd." },
  { 0x0302, "Swefog Technology Group AB" },
  { 0x0303, "Shanghai Moons' Automation Control Co., Ltd" },
  { 0x0305, "DiCon Fiberoptics, Inc." },
  { 0x0306, "feno GmbH" },
  { 0x0307, "Ledium Kft." },
  { 0x0308, "ImageCue LLC" },
  { 0x030A, "Shenzhen Colordreamer Tech Ltd." },
  { 0x030B, "Guangzhou Wanrui Stage Light Equipment Co., Ltd." },
  { 0x030F, "EK INC (formerly Guangzhou Litewise Lighting Equipments Co., Ltd.)" },
  { 0x0311, "Guangzhou PUGUANG Electronic Technology Co., Ltd." },
  { 0x0312, "Guangzhou Xingkong Studio Lighting Co., Ltd." },
  { 0x032C, "Carallon Ltd." },
  { 0x033A, "Lux Lumen" },
  { 0x034B, "Rosstech Signals Inc." },
  { 0x035C, "STOD" },
  { 0x0372, "INACKS" },
  { 0x0378, "KASUGA" },
  { 0x038F, "Strich Labs" },
  { 0x0391, "Alcorn McBride Inc." },
  { 0x0393, "i2Systems" },
  { 0x0394, "Prism Projection" },
  { 0x039B, "Lightforce Lasertechnik" },
  { 0x03A1, "INAREX INC." },
  { 0x03A2, "licht.team" },
  { 0x03A8, "ARTFOX" },
  { 0x03AA, "AIGA Electronic (GuangZhou) Co., Ltd." },
  { 0x03AB, "ABMICROLONDON" },
  { 0x03C6, "NYSOFT" },
  { 0x03CE, "MVI LLC" },
  { 0x03D5, "eX Systems" },
  { 0x03D6, "i-Lumen" },
  { 0x03DA, "QST LED" },
  { 0x03E8, "Acson" },
  { 0x03F0, "jpbaye.de" },
  { 0x03FA, "ART-DMX" },
  { 0x0402, "Exato" },
  { 0x0404, "Luminxa" },
  { 0x040E, "Optoma Corporation" },
  { 0x0411, "SoundSwitch" },
  { 0x0412, "D's DMX" },
  { 0x041C, "IMLIGHT" },
  { 0x0424, "FLUX ECLAIRAGE" },
  { 0x0428, "ITSTECH" },
  { 0x0430, "BOE MLED Technology Co., Ltd" },
  { 0x0436, "CHRONIX" },
  { 0x043C, "Volux Lighting" },
  { 0x0440, "Guangzhou VAS Lighting Co., Ltd." },
  { 0x044E, "Ben Peoples Industries, LLC" },
  { 0x044F, "B2 Co., Ltd." },
  { 0x0455, "Lamp & Pencil" },
  { 0x047C, "LedsGo" },
  { 0x0480, "ASUSTeK Computer Inc." },
  { 0x0486, "LANZ (CZ) Lighting Ltd" },
  { 0x048E, "Krisledz Pte. Ltd." },
  { 0x048F, "Grand Canyon LED Lighting System (Suzhou) Co., Ltd." },
  { 0x04A6, "MEB Veranstaltungstechnik GmbH" },
  { 0x04A9, "Edward J. Keefe Jr." },
  { 0x04B2, "Shenzhen Meiyad Optoelectronics Co., Ltd" },
  { 0x04B4, "SKT Inc." },
  { 0x04B5, "Major" },
  { 0x04B6, "IntiLED" },
  { 0x04B8, "Guangzhou Hongcai Stage Equipment Co., Ltd." },
  { 0x04C4, "Ephesus Lighting, Inc." },
  { 0x04CA, "RT-DMX" },
  { 0x04CC, "Yubang Ruiying (Zhongshan) Electronics Co., LTD" },
  { 0x04CE, "Quisda" },
  { 0x04D0, "DMXCube" },
  { 0x04D6, "Kessil" },
  { 0x04D7, "Targetti Sankey Spa" },
  { 0x04D8, "Guangzhou Hong Yuan Electronic Technology Co., LTD." },
  { 0x04DC, "Modern Stage Service Projects" },
  { 0x04DD, "Topstriving Photoelectricity Technology Co., Ltd." },
  { 0x04E6, "Kelvix" },
  { 0x04EE, "Tivoli Lighting" },
  { 0x04F0, "SIGMA NET" },
  { 0x04F4, "Zeraus" },
  { 0x04FC, "Syncrolite LLC" },
  { 0x0504, "MYHP Limited" },
  { 0x050A, "ChamSys Ltd." },
  { 0x051C, "Ambitsel, Inc." },
  { 0x0520, "ANLC Ltd" },
  { 0x0529, "OSRAM" },
  { 0x052A, "DELTACAST" },
  { 0x0536, "tarm AG" },
  { 0x0537, "TERMINAL-COM" },
  { 0x0540, "EverBrighten Co., Ltd." },
  { 0x0550, "Pyrotechnics Management, Inc. (PMI)" },
  { 0x0555, "Maresch Electronics" },
  { 0x0556, "RAYSYS" },
  { 0x055F, "PRO-SOLUTIONS" },
  { 0x0560, "VingtQuatreVolts" },
  { 0x0568, "IDE Corporation" },
  { 0x056B, "COSMOLIGHT SRL" },
  { 0x056C, "Lumascape Lighting Industries" },
  { 0x0573, "JIAXING XINHUALI LIGHTING & SOUNDING CO., LTD." },
  { 0x0576, "Eleqta Technologies Private Limited" },
  { 0x057A, "RVE S.A.S." },
  { 0x0580, "Innovation LED Limited" },
  { 0x0582, "Jack LINE" },
  { 0x0586, "K 5600, Inc." },
  { 0x0588, "GuangZhou XiangMing Light Limited" },
  { 0x0592, "MIRAGE B.V." },
  { 0x0596, "ReveLux" },
  { 0x05A0, "Stage Smarts AB" },
  { 0x05A4, "IMMOLAS" },
  { 0x05A8, "Owl Labs" },
  { 0x05AB, "Shenzhen Lesan Lighting Co., Ltd." },
  { 0x05AC, "PRstage" },
  { 0x05B5, "Turkowski GmbH" },
  { 0x05BC, "CantoUSA" },
  { 0x05C0, "Vertigo" },
  { 0x05CF, "Brighten Technology Development Co., Ltd." },
  { 0x05D3, "D-LED Illumination Technologies Ltd." },
  { 0x05D4, "SHOWVEN Technologies Co., Ltd." },
  { 0x05DA, "Spacyal" },
  { 0x05E0, "esp_dmx" },
  { 0x05E2, "KORRO PLUS" },
  { 0x05E8, "Snap One" },
  { 0x05EB, "GUANGZHOU BO WEI TE LIGHTING CO.LTD" },
  { 0x05EF, "Guangzhou Chai Yi Light Co., Ltd." },
  { 0x05F2, "O'Light" },
  { 0x05F6, "Otiru Oy" },
  { 0x05F7, "Immersive Design Studios Inc." },
  { 0x0600, "TELMIC Neo" },
  { 0x0602, "Guangzhou Jinhong Stage Lighting Equipment.Co.,ltd" },
  { 0x0606, "Guangzhou YiGuang Stage Lighting Co., Ltd." },
  { 0x0609, "Diginet Control Systems Pty Ltd" },
  { 0x060A, "Kindwin Opto Electronic (ShenZhen) Co. Ltd" },
  { 0x060B, "Lighting Science Group (formerly LED Effects, Inc.)" },
  { 0x060D, "HANIL TNC CO.,LTD" },
  { 0x0614, "Master FX" },
  { 0x061C, "LEDRAYS INC" },
  { 0x0622, "Lupo SRL" },
  { 0x0623, "JAS LIGHTING & SOUND CO., LTD." },
  { 0x0624, "S4 Lights" },
  { 0x0628, "ERP Power" },
  { 0x062A, "LEDstructures" },
  { 0x062B, "CKC Lighting Co., Ltd." },
  { 0x063A, "AVM Belgium BVBA" },
  { 0x063C, "LaserNet" },
  { 0x0644, "COLEDER DISPLAY CO., LTD." },
  { 0x0645, "MATSUMURA ELECTRIC MFG. CO. , LTD." },
  { 0x064D, "KXD LIGHTING CO., LIMITED" },
  { 0x064E, "My Method" },
  { 0x0650, "RDC, Inc. d.b.a. LynTec" },
  { 0x0652, "Bretgeld Engineering GmbH" },
  { 0x0653, "USAI, LLC" },
  { 0x0654, "HUNAN XIANG CAIXU FILM AND TELEVISION CULTURE CO.LTD" },
  { 0x0656, "WELEDIT, LDA" },
  { 0x0658, "AZCOLOR LITE CO., LIMITED" },
  { 0x065E, "OFilms" },
  { 0x0660, "QSTECH CO.,LTD" },
  { 0x0668, "Motion FX" },
  { 0x066B, "AVANT-GARDE DE STUDIO FZ LLC" },
  { 0x066F, "GUANGZHOU CY LIGHTING EQUIPMENT CO.,LTD" },
  { 0x0674, "Raylogic Control systems Pvt Ltd." },
  { 0x067A, "Inster Co, Ltd" },
  { 0x067C, "LOTRONIC SA" },
  { 0x0682, "Beijing Ming Rui Lighting Technology Co., Ltd." },
  { 0x0684, "LEDART LLC" },
  { 0x0685, "IBL/ESD-Datentechnik GmbH" },
  { 0x0687, "INSMARINE LLC" },
  { 0x0688, "LUCIDISCENA" },
  { 0x0689, "GUANGDONG DONE POWER TECHNOLOGY CO" },
  { 0x068C, "Hitmusic SAS" },
  { 0x068E, "GUANGZHOU TEANMA STAGE LIGHTING FACTORY" },
  { 0x068F, "LEDEC GROUP LIMITED" },
  { 0x0692, "TORO SYSTEM" },
  { 0x0696, "SHENZHEN HOION LIGHTING CO.,LTD" },
  { 0x0697, "Shenzhen LED Innovator Technology Co., Ltd" },
  { 0x0698, "Techni-Lux" },
  { 0x06A0, "Light.Audio.Design" },
  { 0x06A1, "ProTec GmbH" },
  { 0x06A3, "RODLIGHT ALBRECHT SILBERBERGER" },
  { 0x06AC, "GOLVER PROJECTS S.L." },
  { 0x06AD, "LEDMAN OPTOELECTRONIC CO.,LTD." },
  { 0x06AE, "CANARA LIGHTING INDUSTRIES PVT LTD" },
  { 0x06AF, "ZHEJIANG JINGRI TECHNOLOGY CO.,LTD" },
  { 0x06B3, "NANOLUMENS, INC." },
  { 0x06B6, "GUANGDONG VSHINE LIGHTING TECHNOLOGY CO.,LTD" },
  { 0x06B9, "GUANGZHOU DASEN LIGHTING CORPORATION LIMITED" },
  { 0x06BA, "Lightner" },
  { 0x06BB, "IQ COMPANY Ltd." },
  { 0x06C0, "ANTILATENCY LTD" },
  { 0x06C4, "RHENAC Systems GmbH" },
  { 0x06C5, "ZHIYUN INFORMATION (INTERNATIONAL) TECHNOLOGY CO., LIMITED" },
  { 0x06C7, "L&L Luce&Light" },
  { 0x06C8, "Dongguan Huiguan Culture Technology Co., Ltd." },
  { 0x06CA, "Leding" },
  { 0x06CE, "American-Pro International" },
  { 0x06D1, "BIRUN ELECTRONIC INDUSTRIAL CO., LTD" },
  { 0x06D2, "LIGHTSTAR (BEIJING) ELECTRONIC CORPORATION" },
  { 0x06D3, "Boerner Distribution International GmbH" },
  { 0x06D8, "GUANGZHOU SUN-YUN TECHNOLOGY CO.,LTD" },
  { 0x06D9, "ELECTROCONCEPT SARL" },
  { 0x06DD, "GRUPPO SIGI SRLS" },
  { 0x06E0, "SHENZHEN LONGRUN OPTOELECTRONIC CO., LTD" },
  { 0x06E1, "Burck IT GmbH & Co. KG" },
  { 0x06E2, "ScreenCo" },
  { 0x06E4, "Dydell B.V." },
  { 0x06E6, "Equipson S.A." },
  { 0x06E8, "Vivalyte BV" },
  { 0x06EC, "SISTEMA Jsc" },
  { 0x06F0, "CTG sp. z o.o." },
  { 0x06F1, "Aqualux Lighting" },
  { 0x06F8, "CHONGQING XINYUANHUI OPTOELECTRONIC TECHNOLOGY CO.,LTD" },
  { 0x0700, "OXYGEN SMD Ltd" },
  { 0x0702, "Drinelec" },
  { 0x0704, "Lightdiction" },
  { 0x0705, "SHANGHAI FUJU LIGHTING TECHNOLOGY CO,.LTD" },
  { 0x0706, "LINEAR TECHNOLOGIE" },
  { 0x0707, "Conceptinetics Technologies and Consultancy Ltd." },
  { 0x0708, "AK-LIGHT" },
  { 0x070A, "NXT Lights" },
  { 0x070C, "Pixout SIA" },
  { 0x070D, "Lumenwerx ULC" },
  { 0x070E, "PragmaLab" },
  { 0x070F, "Theatrelight New Zealand" },
  { 0x0710, "D.T.S. Illuminazione srl" },
  { 0x0711, "Halonix Technologies Pvt Ltd." },
  { 0x0712, "Laser Imagineering GmbH" },
  { 0x0716, "Artem Ltd." },
  { 0x0718, "Eagle Lite" },
  { 0x071A, "YHX Visual" },
  { 0x071F, "Moss LED Inc" },
  { 0x0724, "PHC Lighting & BMS Sp. z o.o." },
  { 0x072B, "NEWSUBSTANCE Ltd." },
  { 0x072C, "SGM A/S" },
  { 0x072D, "Sting Alleman" },
  { 0x072F, "RayComposer - R. Adams" },
  { 0x0732, "Galaxia Electronics" },
  { 0x0734, "CPOINT" },
  { 0x073A, "AML Lighting Co.,LTD" },
  { 0x073B, "Corsair Technology Ltd." },
  { 0x0740, "Arkalumen" },
  { 0x0744, "DMX Pro Sales, LLC" },
  { 0x0745, "Guangzhou Wingo Stage Light Co., Ltd" },
  { 0x0746, "Candela LLC" },
  { 0x0748, "Chromateq" },
  { 0x074F, "Panasonic Corporation" },
  { 0x0753, "F&V Europe B.V." },
  { 0x0758, "IMPOLUX GmbH" },
  { 0x075E, "TEKNiTS Middle East FZ LLC" },
  { 0x075F, "LEDEngin Inc." },
  { 0x0764, "Inteca GmbH" },
  { 0x0766, "MR-Space LLC" },
  { 0x076A, "BeamZ (Tronios B.V.)" },
  { 0x076E, "DecoLed, LLC" },
  { 0x0772, "SP-Quality" },
  { 0x0776, "lumenetix" },
  { 0x077B, "GENLED Brands" },
  { 0x0782, "R9 Lighting" },
  { 0x0784, "PIXL Lighting Inc." },
  { 0x0786, "DMXDesktop" },
  { 0x078A, "FATEC sarl" },
  { 0x078E, "SHENZHEN BGLOPTO TECHNOLOGY Co., LTD." },
  { 0x0792, "MY-Semi Inc." },
  { 0x0793, "IMLTLED Technology Co., Ltd." },
  { 0x0797, "ARCPROLED Limited" },
  { 0x079B, "Pro Church Lights" },
  { 0x079F, "VPS Group, LLC" },
  { 0x07A3, "Guangzhou GBR PROLIGHT GROUP CO.,LTD (GBR PROLIGHT)" },
  { 0x07A4, "Shenzhen DEFG Co., Ltd" },
  { 0x07A5, "X LED Systems" },
  { 0x07A9, "Tridonic GmbH & Co KG" },
  { 0x07AC, "ShowTex NV" },
  { 0x07AD, "CLS LED BV" },
  { 0x07AE, "A-LITE B.V." },
  { 0x07B0, "ADDiCTiON BoX GbR" },
  { 0x07B1, "TBF-PyroTec GmbH" },
  { 0x07B3, "Shenzhen Fabulux Technology Co., Ltd" },
  { 0x07B5, "ARM Automation, Inc" },
  { 0x07B6, "Minleon USA" },
  { 0x07B8, "Zhuhai Demi Technology Co., Ltd." },
  { 0x07BA, "Tradia Co., LTD" },
  { 0x07BB, "Shenzhen SOSEN Electronics Co., Ltd." },
  { 0x07BE, "Sanko Device Co.Ltd." },
  { 0x07C0, "Code Mercenaries GmbH" },
  { 0x07C2, "BOOQlight BV" },
  { 0x07C5, "SBS Lighting LLC" },
  { 0x07C6, "BK Lighting" },
  { 0x07C8, "Sidus Link Ltd." },
  { 0x07CC, "Griven S.r.l." },
  { 0x07CF, "MH-Sound" },
  { 0x07D1, "Made By Mouse LTD" },
  { 0x07D2, "Guangdong The One Studio Co., Limited" },
  { 0x07D5, "PHIDA Stage Equipment Co., Ltd" },
  { 0x07D6, "Lite Puter Enterprise Co., Ltd." },
  { 0x07DA, "Flytech s.r.l." },
  { 0x07DB, "Foshan Yihe Technology Co., Ltd" },
  { 0x07DC, "EVLight (Guangzhou) Co.,Ltd." },
  { 0x07E2, "Lumi-Tru LTD" },
  { 0x07E3, "Lichtlogistik LED Support GmbH" },
  { 0x07E4, "Media Graph" },
  { 0x07E5, "TMI Electronics" },
  { 0x07E8, "ROCKETSIGN Technology HK Ltd" },
  { 0x07E9, "TechLink Co., Ltd." },
  { 0x07EA, "Le Maitre Ltd" },
  { 0x07EC, "Image Show LLC" },
  { 0x07EF, "Guangzhou V-Show Pro Lighting Co., Ltd." },
  { 0x07F0, "Lifud Technology Co., Ltd" },
  { 0x07F2, "CB Electronics" },
  { 0x07F3, "Sam Light" },
  { 0x07F4, "LED Flex Ltd." },
  { 0x07F5, "Shenzhen ATENTI Technologies Co., Ltd" },
  { 0x07F6, "Electric Distribution Systems" },
  { 0x07F7, "Dakco Technologies Co., Ltd." },
  { 0x07F8, "Ultimate Technology Solutions GmbH" },
  { 0x07F9, "Bion Technologies GmbH" },
  { 0x07FA, "Shenzhen Pony Systems Tech Co., Ltd." },
  { 0x07FC, "Electro Mind Co., Ltd." },
  { 0x07FD, "THELIGHT Luminary for Cine and TV S.L." },
  { 0x07FE, "Shenzhen Apexls Optoelectronic Co., Ltd." },
  { 0x07FF, "Guangzhou HOMEI LIGHT Manufacturer" },
  { 0x0800, "Hongyeah Light" },
  { 0x0801, "Guangzhou Favolite Stage Lighting Co., Ltd." },
  { 0x0802, "AstralPool" },
  { 0x0803, "Guangzhou FutureColor Electronic Technology Co., Ltd." },
  { 0x0804, "K&G Visual Technology" },
  { 0x0805, "T.C.M. Light-Solutions" },
  { 0x0806, "Air Giants Limited" },
  { 0x0807, "Event Lighting Pty, Ltd." },
  { 0x0808, "Cooper Lighting - Zero 88" },
  { 0x0809, "mumoco GmbH" },
  { 0x080A, "Shenzhen FantaLED Electronics Co., Ltd" },
  { 0x080B, "BANDINAMU CO., LTD." },
  { 0x080D, "HBJ Elektronik" },
  { 0x080F, "NavoLabs" },
  { 0x0810, "BDS Studios" },
  { 0x0811, "V-PRO" },
  { 0x0812, "Yamagiwa Corporation" },
  { 0x0813, "Shenzhen Scenico Optoelectronic Co., Ltd." },
  { 0x0814, "squareV" },
  { 0x0815, "Q Squared Systems, LLC" },
  { 0x0816, "Benjamin Graf Ton- und Medientechnik" },
  { 0x081C, "MR Electronics Ltd." },
  { 0x081E, "LOBO Electronic GmbH" },
  { 0x0822, "Hangzhou YD Illumination Co., Ltd" },
  { 0x0823, "Opito Labs GmbH" },
  { 0x0824, "Almotechnos CO.,LTD." },
  { 0x0826, "Easy Wireless Hire Limited t/a CORE Lighting" },
  { 0x0827, "PIXREAL" },
  { 0x0829, "CR-TEC Photoelectric" },
  { 0x082B, "Changsha ZMIOT Co., Ltd." },
  { 0x082E, "QubiCast GmbH" },
  { 0x0832, "Shenzhen EXC-LED Technology Co.,Ltd" },
  { 0x0835, "Guangdong Fahold Electronics Co., Ltd." },
  { 0x0836, "Nyvoll Lys" },
  { 0x0838, "LaserAV" },
  { 0x083A, "Bright Ideas Custom Electronics Inc." },
  { 0x083C, "TDT Productions" },
  { 0x083D, "Siluj Iluminacion S.L.U." },
  { 0x083E, "Guangdong Hua Chen Film & Television Stage Project Co., Ltd." },
  { 0x083F, "Shenzhen LeiFei Lighting Technologies Co.,Ltd." },
  { 0x0840, "Shenzhen Zwich Science and Technology Co.Ltd." },
  { 0x0841, "Guangzhou ICON Lighting Co.,Ltd" },
  { 0x0842, "Hunix Co., Ltd." },
  { 0x0843, "BHL Lichttechniek" },
  { 0x0845, "Cush Light LLC" },
  { 0x0846, "LDR - Luci della Ribalta Srl" },
  { 0x0847, "SlightLight AB" },
  { 0x0848, "SLC - Static Light Company Ltd" },
  { 0x084B, "Neon Circus Ltd" },
  { 0x084C, "Guangzhou Ba Lin Electronic Technology Co., Ltd." },
  { 0x084D, "Guangzhou NECO Stage Lighting Factory" },
  { 0x084E, "RGBshine Technology Co. Ltd." },
  { 0x084F, "Mantic Lighting Co.,Ltd" },
  { 0x0850, "Proland Group, LLC" },
  { 0x0851, "Junction Inc. Ltd" },
  { 0x0853, "Royal Ballet and Opera" },
  { 0x0854, "Sharp / NEC Display Solutions, Ltd." },
  { 0x0855, "GODOX Photo Equipment Co., Ltd." },
  { 0x0856, "Ctrl Element ehf" },
  { 0x0857, "BOS Lighting" },
  { 0x0858, "Juno Lighting Group" },
  { 0x085A, "Guangzhou Ming Jing Stage Light Equipment Co., Ltd." },
  { 0x085B, "Tolifo (Dongguan) Photographic Equipment Co. Ltd" },
  { 0x085E, "MMS Distribution Ltd" },
  { 0x085F, "Media Visions, Inc." },
  { 0x0860, "Resolution X Pty Ltd" },
  { 0x0862, "illuminous" },
  { 0x0863, "XTEC Industries Pte Ltd" },
  { 0x0864, "Hangzhou Youte Power., Co. Ltd" },
  { 0x0865, "Contrade GmbH" },
  { 0x0866, "PAL Lighting" },
  { 0x0867, "Huizhou LATU Film Equipment Co., Ltd" },
  { 0x0868, "Ushio America, Inc." },
  { 0x0869, "Club Cannon LLC" },
  { 0x086A, "Shenzhen Chip Optech Co.,LTD" },
  { 0x086C, "Bafa Elektronik ve Işık Tasarımları Sanayii Ticaret LTD Sti." },
  { 0x086D, "Velaflame, LLC" },
  { 0x086E, "Guangzhou Hi-LTTE Electronics Technology Co.,Ltd" },
  { 0x086F, "MARTINI RUS LLC" },
  { 0x0870, "Hunan YESTECH Optoelectronic Co., Ltd" },
  { 0x0871, "Changsha Maya Special Effects Equipment Co., Ltd" },
  { 0x0872, "GigaTera Lighting Inc." },
  { 0x0873, "Guangzhou BKLite Stage Lighting Equipment Co.,LTD" },
  { 0x0874, "Snow Professional Lighting" },
  { 0x0875, "ARC Solid-State Lighting Corp." },
  { 0x0876, "Power Gems LTD" },
  { 0x0877, "Skaff New Zealand Ltd" },
  { 0x0878, "OTTEC Technology GmbH" },
  { 0x087A, "Dextra Group Plc" },
  { 0x087B, "About Time Technologies" },
  { 0x087C, "Telectran International Pty Ltd." },
  { 0x087D, "TPV Technology Group" },
  { 0x087F, "Premier Sports Lighting, LLC" },
  { 0x0880, "GuangZhou LiDang Technology Inc." },
  { 0x0881, "Shenzhen Genesis-Systech Co., Ltd." },
  { 0x0883, "CEE Lighting Equipment Co.Ltd" },
  { 0x0884, "Bright Group" },
  { 0x0885, "SIRS-E" },
  { 0x0886, "KLIK Systems" },
  { 0x0887, "PrimOtek s.r.l.s." },
  { 0x0888, "Banglux Lighting Technology Co., Ltd." },
  { 0x0889, "Guangzhou Shenghui Electronic Technology Co., Ltd" },
  { 0x088A, "Highendled Electronics Company Limited" },
  { 0x088B, "Shenzhen Doit Vision Co., Ltd" },
  { 0x088C, "Guangzhou Yi Sheng Yuan Electronic Co.,Ltd(Esun)" },
  { 0x088D, "Guangzhou Ling Yang lighting Science and Technology Co.,Ltd" },
  { 0x088E, "Stage One International Co., Ltd." },
  { 0x088F, "First Design System Inc." },
  { 0x0890, "Taurus Light Co.,Limited" },
  { 0x0891, "Feiner Lichttechnik GMBH" },
  { 0x0892, "DongGuan Ruishen Technology Co.,Ltd" },
  { 0x0893, "Brighten LED Lighting Limited" },
  { 0x0894, "Dongguan HCP Technology Co., Ltd." },
  { 0x0895, "Dolby Laboratories, Inc." },
  { 0x0896, "CSD Design and Fabrication" },
  { 0x0898, "AEC ILLUMINAZIONE SRL" },
  { 0x0899, "Shenzhen Huimont Technology Co., Ltd" },
  { 0x089A, "ADL Electronics Ltd." },
  { 0x089B, "Guangzhou Shenhe Stage Lighting Equipment Co., Ltd." },
  { 0x089C, "SWIT Electronics Co.,Ltd" },
  { 0x089D, "gobo.ws" },
  { 0x089E, "Cronic Lighting" },
  { 0x08A1, "Shenzhen Gloshine Technology Co., Ltd" },
  { 0x08A2, "Guangzhou Gesida Light Equipment Co., Ltd." },
  { 0x08A3, "Redot Visual Effect Technologies (Shenzhen) Co., Ltd" },
  { 0x08A4, "Adam Hall GmbH" },
  { 0x08A5, "White Wing Logic" },
  { 0x08A6, "impulswerk.de" },
  { 0x08A7, "GuangZhou Deliya Opto-electronic Tech Co., Ltd" },
  { 0x08A8, "Guangzhou Yunpeng Lighting Equipment Co. Ltd." },
  { 0x08A9, "Lighten Corp." },
  { 0x08AA, "PiXL Factory" },
  { 0x08AB, "Qdot Lighting Limited" },
  { 0x08AC, "Bushveld Labs" },
  { 0x08AD, "Optical Productions LLC" },
  { 0x08AE, "Technical Audio Group Pty Ltd" },
  { 0x08AF, "AAdyn Technology" },
  { 0x08B0, "KIM Lighting" },
  { 0x08B1, "Fujian Starnet Evideo Information System Co.,Ltd." },
  { 0x08B2, "MCI Group" },
  { 0x08B3, "Stealth Light srl" },
  { 0x08B4, "Ledera Technology Co.,Ltd" },
  { 0x08B5, "ShenZhen Sunny Xiao Technology Co., Ltd." },
  { 0x08B6, "Graf Lichttechnik UG" },
  { 0x08B8, "LEDScape Lighting" },
  { 0x08B9, "Guangzhou Hua Rong Electronic Technology Co., Ltd." },
  { 0x08BA, "Meteor Lighting" },
  { 0x08BB, "Guangzhou CHEN Electronic Technology Co., Ltd." },
  { 0x08BC, "Michael Parkin" },
  { 0x08BD, "Lug Light Factory Sp. z o. o." },
  { 0x08BE, "Shenzhen FloatStone Technology Co., Ltd." },
  { 0x08BF, "Times Square Stage Lighting Inc." },
  { 0x08C0, "Real Tech International LTD." },
  { 0x08C1, "Project SSSHH Incorporated" },
  { 0x08C2, "Guangzhou Huipu Stage Effect Equipment Co., Ltd" },
  { 0x08C3, "Guangzhou Spark Stage Equipment Co. Ltd" },
  { 0x08C4, "Jacek Wagner" },
  { 0x08C5, "EHRGEIZ Lichttechnik GmbH" },
  { 0x08C6, "Guangzhou Ever Famous Electronic Co.,Ltd" },
  { 0x08C7, "Shenzhen SOSTRON Technology Co., Ltd" },
  { 0x08C8, "Guangzhou Moli Stage Equipment Co.,Ltd" },
  { 0x08C9, "LEDitgo Videowall Germany GmbH" },
  { 0x08CA, "Foshan City Xuandao Optoelectronics Equipment Co., Ltd" },
  { 0x08CB, "Practical LEDs.com" },
  { 0x08CC, "Guangzhou Santu Stage Lighting Equipment Co.Ltd" },
  { 0x08CE, "Zhejiang DGX Electronic Technology Co.,Ltd" },
  { 0x08CF, "Nanjing Lopu Co., Ltd" },
  { 0x08D0, "Image Engineering" },
  { 0x08D1, "Shenzhen Leqi Network Technology Co., Ltd." },
  { 0x08D2, "Curious Devices Ltd." },
  { 0x08D3, "SVI Public Company Limited" },
  { 0x08D4, "Sensa-Lite Ltd." },
  { 0x08D5, "Sense Effects" },
  { 0x08D6, "Guangzhou Precision Vision Intelligent Equipment Co, Ltd" },
  { 0x08D7, "PatternAgents, LLC" },
  { 0x08D8, "W.A. Benjamin Electric Co." },
  { 0x08D9, "STILED" },
  { 0x08DA, "PLC Intelligent Technology (Shanghai) Co., Ltd." },
  { 0x08DB, "Shenzhen iDisplay Technology Co.,Ltd" },
  { 0x08DC, "Splenditech Asia Pacific Limited" },
  { 0x08DD, "Matthew Tong" },
  { 0x08DE, "Delta Electronics (Jiangsu) Ltd." },
  { 0x08DF, "DetaiLED Solutions" },
  { 0x08E0, "Red Arrow Controls" },
  { 0x08E1, "Shenzhen CLT Electronics Co.,LTD" },
  { 0x08E2, "Particle Studio Ltd." },
  { 0x08E3, "Guangzhou JinZhiHui Electronic Technology Co.,Ltd." },
  { 0x08E4, "LMP Lichttechnik Vertriebsgesellschaft GmbH & Co KG" },
  { 0x08E5, "Digital Review" },
  { 0x08E6, "Shenzhen VisionMax Technology Co., Ltd" },
  { 0x08E7, "3A Guangzhou Electronics Co., Ltd" },
  { 0x08E8, "North Engineering" },
  { 0x08EA, "Changchun Cedar Electronic Technology Co.,Ltd." },
  { 0x08EB, "Guangzhou Lixin Lighting Co., Ltd." },
  { 0x08EC, "Marvin Nadrowski" },
  { 0x08ED, "ShowLED" },
  { 0x08EE, "Spacelights" },
  { 0x08EF, "Guangzhou RuiYang lighting technology co. LTD." },
  { 0x08F0, "Guang Dong LMJ Lighting Co., Ltd" },
  { 0x08F1, "SanDevices, LLC" },
  { 0x08F2, "Virtualny Agronom Ltd." },
  { 0x08F3, "Outdoor Lasers Ltd." },
  { 0x08F4, "MC Electronic Technology(GZ) Co., Ltd." },
  { 0x08F5, "Fufeng lighting" },
  { 0x08F6, "Eulum Design, LLC" },
  { 0x08F7, "Neotek Lighting" },
  { 0x08F8, "Liberal Logic Inc." },
  { 0x08F9, "ACS - Ackerman Computer Sciences" },
  { 0x08FA, "Phaton Lighting Co., Ltd." },
  { 0x08FB, "RPA Electronic Solutions Inc." },
  { 0x08FC, "Lights By Brian" },
  { 0x08FD, "Koto Electric Co., Ltd." },
  { 0x08FE, "Zhuhai Shengchang Electronics Co., Ltd." },
  { 0x0900, "nox multimedia GmbH" },
  { 0x0901, "GermTec GmbH & Co. KG" },
  { 0x0902, "DongGuan Betterway Lighting Co.,Ltd" },
  { 0x0903, "Shenzhen INFiLED Electronics, Ltd." },
  { 0x0904, "Bigbear Co., Ltd." },
  { 0x0905, "Locimation Pty Ltd" },
  { 0x0906, "Crystal Technica Limited" },
  { 0x0907, "Shenzhen GCL Electronics Co., Ltd" },
  { 0x0908, "Guangzhou DeLong Stage Equipment Co., Ltd." },
  { 0x0909, "Beijing Starlight Electronics Co., Ltd." },
  { 0x090A, "Jiangmen Seekway Technology Limited" },
  { 0x090B, "StarLighting" },
  { 0x090C, "GRE Alpha" },
  { 0x090E, "Sichuan esRadio Technology Co., Ltd" },
  { 0x090F, "Shenzhen Dingli Display Technology Co., Ltd" },
  { 0x0910, "Shenzhen Tecnon EXCO-Vision Technology Co., Ltd." },
  { 0x0911, "Guangzhou Aceda Professional Lighting Co., Ltd." },
  { 0x0912, "ags - Wissenschaftliche Arbeitsgemeinschaft fur Studio- und Senderfragen" },
  { 0x0913, "Guangzhou ECK Light Equipment Company Limited" },
  { 0x0914, "Xenio" },
  { 0x0915, "Guangzhou Chuangfeng Photoelectric Equipment Co., Ltd." },
  { 0x0916, "ACTOR-MATE CO., LTD." },
  { 0x0917, "Gavtronics" },
  { 0x0918, "David O Smith Design" },
  { 0x0919, "Foshan Leiyuan Photoelectric Co., LTD" },
  { 0x091A, "Celex LED Technology Ltd." },
  { 0x091B, "Krislite Pte. Ltd." },
  { 0x091C, "Wipro Enterprises Private Limited." },
  { 0x091D, "TouchPlate Technologies Inc." },
  { 0x091E, "Vanilla Internet Ltd" },
  { 0x091F, "Yaham Recience Technology Co,. ltd." },
  { 0x0920, "Vexica Technology Limited" },
  { 0x0921, "Guangzhou mengyi stage lighting equipment co., LTD." },
  { 0x0922, "von Gaisberg Engineering" },
  { 0x0923, "Hangzhou Roleds Lighting System Co., Ltd." },
  { 0x0925, "Guangzhou Aiweidy Lighting Acoustics Equipment Co.,Ltd." },
  { 0x0926, "Elumeros Lighting Limited" },
  { 0x0927, "Guangzhou Mingying Electronic Technology / Phazed Logik" },
  { 0x0928, "Chaostreff Backnang e.V." },
  { 0x0929, "UPlight stage equipment(GZ) CO., Ltd." },
  { 0x092A, "Unitech Digital Media srl" },
  { 0x092B, "Guangzhou Lightful Stage Lighting&Sound Equipment Co,.Ltd." },
  { 0x092C, "Guangzhou Chaoran Computer Co., Ltd." },
  { 0x092D, "LG Electronics" },
  { 0x092E, "YouEasy (Dongguan) Electronics Technology Co.,Ltd" },
  { 0x092F, "Guangzhou Shinelight Stage Equipment Factory" },
  { 0x0930, "jiaozuo shengguang film &equipment Co. Ltd" },
  { 0x0931, "Cristal Controles" },
  { 0x0932, "GUANGZHOU BORAY ELECTRON CO.,LTD" },
  { 0x0933, "Beyond Lighting WLL" },
  { 0x0934, "Zenopix Electronic Limited Company" },
  { 0x0935, "Guangzhou Huadu District Richa Lighting Equipment Factory" },
  { 0x0936, "AquaTronic" },
  { 0x0937, "Huizhou Zhonghan Electronic Technology Co., Ltd" },
  { 0x0938, "Guangzhou Vanray Lighting Equipment CO.,Ltd." },
  { 0x0939, "Edelmann Electronics" },
  { 0x093A, "HDT impex s.r.o." },
  { 0x093B, "Guangzhou Hongmingwei Stage Lighting Co., Ltd." },
  { 0x093D, "Sichuan Hushan Electric Co. Ltd" },
  { 0x093E, "Chengdu Jian Yi Technology Co., Ltd." },
  { 0x093F, "Guangzhou Julong Platform Lighting Equipment Factory" },
  { 0x0940, "Shenzhen CreateLED Electronics Co., Ltd" },
  { 0x0941, "Shenzen Zhuoyang Intelligent Technology Co., Ltd." },
  { 0x0942, "Showjockey Technology Co., Ltd" },
  { 0x0943, "Guangzhou Guangying Optoelectronics Co., Ltd" },
  { 0x0944, "Guangzhou Lighting Cosmos Optoelectronics Technology Co., Ltd." },
  { 0x0945, "Guangzhou Lin Xiang Stage Lighting Equipment CO.,LTD" },
  { 0x0946, "TBE Srl" },
  { 0x0947, "Shenzhen MOSO Electronics Technology Co., Ltd" },
  { 0x0948, "Wisconsin Lighting Lab, Inc. (WiLL)" },
  { 0x0949, "Shenzhen Jiuzhou Optoelectronic Technology" },
  { 0x094A, "Funovation, Inc" },
  { 0x094B, "Invisua Lighting BV" },
  { 0x094C, "Shenzhen Xiezhen Electronics Co., Ltd." },
  { 0x094D, "Quantum Theory" },
  { 0x094E, "Myostat Motion Control" },
  { 0x094F, "Creative Integration Studio" },
  { 0x0950, "Pure Effects" },
  { 0x0951, "Guangzhou GTD Lighting Technology Co., Ltd" },
  { 0x0952, "Guangzhou Sunway Entertainment Equipment Co., Ltd." },
  { 0x0953, "Boumakers Techniek" },
  { 0x0954, "Ledtop Visual Ltd." },
  { 0x0955, "8lightspace limited" },
  { 0x0956, "Expromo Europe A/S" },
  { 0x0957, "White Light Ltd" },
  { 0x0958, "Illum Technology LLC (previously Verde Designs, Inc.)" },
  { 0x0959, "Urbs Lighting, LLC" },
  { 0x095A, "kLabs Research UK" },
  { 0x095B, "Wuhan Zhongtian Jiaye Mechanical and Electrical Engineering Co. LTD" },
  { 0x095C, "Thomas Neumann Licht und Tontechnik" },
  { 0x095D, "Silver Curve Ltd" },
  { 0x095E, "Hondel Lighting Limited" },
  { 0x095F, "Elaborated Networks GmbH" },
  { 0x0960, "Fineline Solutions Ltd." },
  { 0x0961, "Delight Lighting" },
  { 0x0962, "Finland Lighting Oy" },
  { 0x0963, "Foshan Sololighting Technology Co., Ltd" },
  { 0x0964, "Inventions Guité Inc." },
  { 0x0965, "Fontana Fountains" },
  { 0x0967, "Arcus Licht- und Praesentationstechnik GmbH" },
  { 0x0968, "Guangzhou Beyond Lighting Co., Limited." },
  { 0x0969, "VCS Vision Control Solutions GmbH" },
  { 0x096A, "Primeview Global" },
  { 0x096C, "Guangzhou Nebula Stage Lighting Equipment Co., Ltd" },
  { 0x096D, "Guangzhou Xin Yilong Stage Lighting Equipment Co., Limited" },
  { 0x096E, "Calvitia Limited" },
  { 0x096F, "Shenzhen showho technolgy co.,ltd" },
  { 0x0970, "Aurum Engineering GmbH" },
  { 0x0971, "Plura Europe GmbH" },
  { 0x0972, "Holochrom GmbH" },
  { 0x0973, "Guangzhou Eagle Wei Photoelectric Technology Co., Ltd." },
  { 0x0974, "Marumo Electric Co., Ltd." },
  { 0x0975, "KB Design" },
  { 0x0976, "Axion Lighting LLC" },
  { 0x0977, "Guangzhou HuaYong Intelligent Technology Co., Ltd." },
  { 0x0978, "LE Veranstaltungstechnik" },
  { 0x0979, "Shanghai Arex Electronics Co., Ltd." },
  { 0x097A, "Teamboyce Limited" },
  { 0x097B, "Guangzhou Kimu Stage Lighting Equipment Co.,Ltd" },
  { 0x097D, "Brink Electronics" },
  { 0x097E, "Guangzhou Deyi Lighting Co., Ltd." },
  { 0x097F, "RaumZeitLabor e.V." },
  { 0x0980, "Moog Animatics" },
  { 0x0981, "Luxam, Ltd." },
  { 0x0982, "AC Entertainment Products Ltd." },
  { 0x0983, "S Squared Innovations Inc." },
  { 0x0984, "Laserworld AG" },
  { 0x0986, "ROE Visual Co. Ltd." },
  { 0x0987, "mathertel.de" },
  { 0x0988, "Wahlberg Motion Design" },
  { 0x0989, "YeGrin Liteworks" },
  { 0x098A, "DongGuan JuYang Electric Co., Ltd" },
  { 0x098B, "Glow Motion Technologies, LLC." },
  { 0x098C, "Shenzhen Longrich Energy Sources Technology Co., Ltd." },
  { 0x098D, "Batmink Ltd." },
  { 0x098E, "Ecosense Lighting Inc" },
  { 0x098F, "Digital Sputnik Lighting" },
  { 0x0990, "Stagelight Holding" },
  { 0x0991, "Guangdong Pomelo Photoelectric Equipment Co., Ltd" },
  { 0x0992, "Guangzhou Fengyi Stage Lighting Equipment Co., Ltd." },
  { 0x0993, "Shenzhen Trigger digital Technology Co., LTD" },
  { 0x0994, "Shenoy Studio Lighting Systems" },
  { 0x0995, "Rasha Professional" },
  { 0x0996, "CCI Power Supplies, LLC" },
  { 0x0997, "Star Iluminacao Computadorizada LTDA" },
  { 0x0999, "Concept Smoke Systems Ltd." },
  { 0x099A, "Aixz International (S)" },
  { 0x099B, "Luminoscape Lighting Limited" },
  { 0x099C, "Ray Bright Technologies" },
  { 0x099D, "Frenexport SPA" },
  { 0x099E, "LLC Lighting Technologies production" },
  { 0x099F, "Osten Lighting" },
  { 0x09A0, "Rnet Lighting Technology Limited" },
  { 0x09A1, "Veranstaltungstechnik König" },
  { 0x09A2, "Fountain People" },
  { 0x09A3, "Shenzhen Lightlink Display Technology Co., Ltd" },
  { 0x09A4, "Brighter Lighting Sp. z.o.o." },
  { 0x09A5, "Prolight Concepts Ltd." },
  { 0x09A6, "TourPro Lighting Company" },
  { 0x09A7, "Foshan Xinzhijie Optoelectronics Co., Ltd." },
  { 0x09A8, "Guangzhou Longman Optoelectronics Co., Ltd." },
  { 0x09AA, "Rushstage Show Lighting Limited" },
  { 0x09AD, "Dongguan Ensure Electronic Technology Co., LTD" },
  { 0x09AE, "Robert Juliat" },
  { 0x09AF, "Autotech Co." },
  { 0x09B0, "Luminii" },
  { 0x09B1, "Shenzhen Lianxinke Microelectronics Co., Ltd" },
  { 0x09B2, "Guangzhou Hedong Electronics Co., LTD" },
  { 0x09B3, "Aquatique Show Int." },
  { 0x09B4, "Brompton Technology Ltd." },
  { 0x09B5, "XBlack Visual Products" },
  { 0x09B6, "Second String Studios" },
  { 0x09B7, "inCon-trol water systems" },
  { 0x09B8, "Prolites S.A.L." },
  { 0x09BA, "Supervoimed OU" },
  { 0x09BB, "Guangzhou Yiyi Technology Co., Ltd." },
  { 0x09BD, "Shenzhen Zhongbo Photoelectric Co., Ltd" },
  { 0x09BE, "Arctos Showlasertechnik GmbH" },
  { 0x09C0, "Guangzhou Rainbow Lighting Equipment CO.,LTD" },
  { 0x09C1, "Argetron Elektrik Elektronik Organizasyon Gida San. ve Dis Tic. Ltd. Sti." },
  { 0x09C2, "Guangzhou Mingjing Technology Co., Ltd." },
  { 0x09C3, "Velleman nv" },
  { 0x09C4, "Guangzhou XinHuang Industrial Co., Ltd." },
  { 0x09C6, "Photon Manufacturing" },
  { 0x09C7, "ShoCobra" },
  { 0x09C8, "Crystal Fountains Inc." },
  { 0x09CC, "Motomuto Aps" },
  { 0x09CF, "Guangzhou Wincode Optronics Co., Limited" },
  { 0x09D0, "Luminar Enterprises" },
  { 0x09D1, "Environmental Lights" },
  { 0x09D2, "Shenzhen Siwelo Technology Co., LTD" },
  { 0x09D3, "WLPS Wodielite Production Services" },
  { 0x09D4, "Guangzhou Yilaiming Photoelectric Technology Co., Ltd" },
  { 0x09D5, "Shenzhen ImagineVision Technology Limited" },
  { 0x09D6, "Mittomakers" },
  { 0x09D7, "Unilumin Group" },
  { 0x09D8, "Pioneer Lighting Solutions India Pvt Ltd" },
  { 0x09DC, "Froggys Fog" },
  { 0x09DD, "Planet Innovation Products Inc" },
  { 0x09DE, "Matthias Bauch Software" },
  { 0x09E0, "Beiijing Keyi Starlight Technology Co., Ltd." },
  { 0x09E3, "Powerland Technology Inc." },
  { 0x09E9, "Starway" },
  { 0x09EE, "Suzhou Pinzong Electronic Technology, CO.,Ltd" },
  { 0x09EF, "Andrea Croce" },
  { 0x09F8, "UberDisplays" },
  { 0x09FC, "deskontrol electronics" },
  { 0x0A01, "Star-Reach Corporation" },
  { 0x0AAA, "AAA-LUX" },
  { 0x0D0C, "SmartDC Inc." },
  { 0x0D0E, "DMX Engineering LLC" },
  { 0x1112, "Zhuhai Bincolor Electronic Technology Co., Ltd." },
  { 0x1113, "SiliconCore Technology, Inc." },
  { 0x1200, "Seekway Technology Limited" },
  { 0x1201, "PRICOM Design" },
  { 0x1202, "Ushio Lighting, Inc." },
  { 0x1203, "Movecat GmbH" },
  { 0x1204, "ARES s.r.l. - Socio Unico" },
  { 0x1205, "Carbon Lighting Limited" },
  { 0x1206, "Hangel Technology Co., Ltd." },
  { 0x1207, "BSK Networks GbR" },
  { 0x1208, "Nuvolight GmbH & Co KG" },
  { 0x1209, "Philippe Bergeron Lights" },
  { 0x120A, "Bulldog Lighting and Events, Inc." },
  { 0x120B, "Brilliant Stages Ltd." },
  { 0x120C, "Shanxi Tian Gong Sheng Optoelectronic Equipment Technology Co." },
  { 0x1211, "Recrealab" },
  { 0x1212, "HPL Light Company" },
  { 0x1221, "SAGITTER-SDJ-Proel" },
  { 0x1222, "SM International" },
  { 0x1234, "ESTA" },
  { 0x12DA, "Newlab S.r.l." },
  { 0x12E0, "Luxlight Skandinavien AB" },
  { 0x12EA, "Kolberg Percussion GmbH" },
  { 0x12F4, "Stage Services Ltd." },
  { 0x12FA, "Hollywood Rentals LLC" },
  { 0x12FE, "City Design S.p.A." },
  { 0x131E, "Blossom Communications Corp." },
  { 0x1337, "Raven Systems Design, Inc." },
  { 0x134D, "VT-Control" },
  { 0x1370, "Ingenieurbuero Stahlkopf" },
  { 0x13AE, "Smartpark Creative Solutions" },
  { 0x1460, "SEIKO Epson Corporation" },
  { 0x1464, "HUMAL Elektroonika OU" },
  { 0x1490, "Grid Show Systems Inc." },
  { 0x14A0, "Intense Lighting, LLC" },
  { 0x14AC, "Zaklad Elektroniczny AGAT s.c." },
  { 0x1501, "Artixium France SAS" },
  { 0x1506, "v2 Lighting Group, Inc." },
  { 0x1507, "LC Handels GmbH" },
  { 0x1508, "TommyDMX" },
  { 0x150C, "ACASS SYSTEMS LLC" },
  { 0x152A, "SHOWTACLE Ltd." },
  { 0x154E, "Fire & Magic" },
  { 0x15A0, "GuangZhou MCSWE Technologies, INC" },
  { 0x15A2, "FEIMEX" },
  { 0x15D0, "Music & Lights S.r.l." },
  { 0x161A, "techKnow Design Ltd." },
  { 0x1626, "LEDsistem Teknolojileri Tic. Ltd. Sti." },
  { 0x1627, "Dynamic Visual Solutions LLC" },
  { 0x162A, "Nerd's Meter" },
  { 0x1688, "Exteria" },
  { 0x1690, "awaptec GmbH" },
  { 0x16A0, "Audio Effetti Srl" },
  { 0x16AE, "Electrone Americas Ltd. Co." },
  { 0x16DC, "Traxon Technologies Ltd." },
  { 0x16E4, "Aboutshow Color Light Co., LTD" },
  { 0x1701, "ARTBOX" },
  { 0x170E, "Serva Transport Systems GmbH" },
  { 0x170F, "Kezun Stage Lighting Equipment Co., Ltd." },
  { 0x174E, "Nordgas SNe-lightingsystem" },
  { 0x1750, "Yuesheng International Limited" },
  { 0x1808, "Guangzhou Jinye Electronic Technology Co., Ltd." },
  { 0x1809, "Rotolight" },
  { 0x180A, "Guangdong Longjoin Optoelectronics Technology Co. Ltd." },
  { 0x180B, "Light stream" },
  { 0x1871, "Smoke Factory GmbH" },
  { 0x1872, "Super-Can Industry Growing Co. Ltd." },
  { 0x1873, "Zhongshan Wellmake Electronic Technology Co., Ltd." },
  { 0x1888, "GUANZHOU KAVON STAGE EQUIPMENT CO., LTD." },
  { 0x18A6, "Steadfast Technology" },
  { 0x1900, "ADJ Products LLC" },
  { 0x1901, "Zhongshan Hiline Electronics Co., Ltd." },
  { 0x1938, "Solid State Luminaires" },
  { 0x1998, "PLS Electronics Ltd." },
  { 0x19B9, "Duralamp S.p.A." },
  { 0x19BA, "Guangzhou Xinzhijie Photoelectric Co., Ltd." },
  { 0x19BB, "Panalux Ltd." },
  { 0x19BC, "Newtone AS" },
  { 0x19F8, "CEZOS Spolka z ograniczona odpowiedzialnoscia, sp.k." },
  { 0x1A00, "LIGEO GmbH" },
  { 0x1A0D, "Cineo Lighting" },
  { 0x1A16, "WADAK GmbH" },
  { 0x1A1A, "ValDim Waterfountains Ltd." },
  { 0x1A3D, "Red Lighting s.r.l." },
  { 0x1AFA, "TMB" },
  { 0x1BB1, "PH Lightning AB" },
  { 0x1BC0, "ALS Stanislaw Binkiewicz" },
  { 0x1BC6, "Studio S Music City" },
  { 0x1C80, "Vehtec Tecnologia Ltda" },
  { 0x1CAB, "LTT sp. z o.o." },
  { 0x1E42, "SSE GmbH" },
  { 0x1E8D, "Moda Light" },
  { 0x1ECF, "Masiero s.r.l." },
  { 0x1ED8, "Antari Lighting And Effects Ltd." },
  { 0x2009, "Zboxes Intelligent Technology (Shanghai) Co., Ltd." },
  { 0x200A, "Vault189 Pty. Ltd." },
  { 0x2011, "Gantom Lighting & Controls" },
  { 0x207F, "Padura Elektronik GmbH" },
  { 0x20A6, "ALADIN Architekturlicht GmbH" },
  { 0x20AB, "IlluminaPi SAS" },
  { 0x20AD, "AZ e-lite Pte Ltd" },
  { 0x20B6, "Alkalite LED Technology Corp" },
  { 0x20B8, "Electron SA" },
  { 0x20B9, "ARRI -- Arnold & Richter Cine Technik GmbH & Co. Betriebs KG" },
  { 0x20BA, "AusChristmasLighting" },
  { 0x20BB, "Able Laser Tech Co., Ltd." },
  { 0x20BC, "Beijing Pargolite Technology Co., Ltd." },
  { 0x20BD, "Foshan Yoline Lighting Equipment Co., Ltd." },
  { 0x20BE, "Uranus Lighting Co., Ltd." },
  { 0x20BF, "Guangzhou Taifeng Stage Lighting Audio Equipment Factory" },
  { 0x20C0, "KappaStyle Productions." },
  { 0x20C1, "BrightBeats, LLC" },
  { 0x20C2, "Demilight" },
  { 0x20C3, "PIXILAB Technologies AB" },
  { 0x2121, "Brother,Brother & Sons Aps" },
  { 0x2122, "BEGLEC NV" },
  { 0x2130, "Bart van Stiphout Electronics & Software" },
  { 0x21A1, "Culture Crew bvba" },
  { 0x21A4, "CHAUVET Lighting" },
  { 0x21A9, "CaptSystemes" },
  { 0x21B3, "Coolon Pty Ltd" },
  { 0x21B4, "CHROMLECH" },
  { 0x21B5, "ChromaCove LLC" },
  { 0x2208, "C.I.M.E.S. (Conception Installation Maintenance En Eclairage & Sonorisation)" },
  { 0x2216, "D-Light Designs, LLC" },
  { 0x2222, "D.E.F. Srl" },
  { 0x2224, "DAS Integrator Pte Ltd" },
  { 0x2239, "Dream Solutions Ltd." },
  { 0x22A0, "EAS SYSTEMS" },
  { 0x22A6, "Elation Lighting Inc." },
  { 0x22A9, "Engineering Solutions Inc." },
  { 0x22AA, "EUTRAC - Intelligent Lighting GmbH" },
  { 0x22AB, "EVC" },
  { 0x22B9, "Etherlight" },
  { 0x2337, "Focon Showtechnic" },
  { 0x2338, "Humanlitech Co., Ltd." },
  { 0x2339, "Sky-Skan Europe GmbH" },
  { 0x233A, "4 Frames Lost UG" },
  { 0x23B2, "Gekko Technology Ltd." },
  { 0x2421, "HB-Laserkomponenten GmbH" },
  { 0x242A, "Hungaroflash" },
  { 0x2432, "Helvar Ltd" },
  { 0x2470, "Hale Microsystems LLC" },
  { 0x24A3, "Lighting Innovation Group AG" },
  { 0x24AA, "IT Ihme" },
  { 0x2500, "RATOC Systems, Inc." },
  { 0x2501, "Xero Manufacturing Pty Limited" },
  { 0x2621, "LEADER LIGHT s.r.o." },
  { 0x2622, "LDDE Vertriebs Gmbh" },
  { 0x2623, "Leonh Hardware Enterprise Inc." },
  { 0x2624, "Lisys Fenyrendszer Zrt." },
  { 0x2626, "LLT Lichttechnik GmbH&CO.KG" },
  { 0x2627, "Guangzhou Megota Technology Co., Ltd." },
  { 0x2630, "Laservision" },
  { 0x2632, "Lehigh Electric Products" },
  { 0x2635, "LjusDesign AB" },
  { 0x2636, "Lumonic Limited" },
  { 0x2637, "Loxone Electronics GmbH" },
  { 0x263A, "Lumenec Pty. Ltd." },
  { 0x263C, "I-Pix Digital Light Ltd." },
  { 0x26A2, "MEGATECHNICS Ltd." },
  { 0x26B4, "Milford Instruments Ltd." },
  { 0x2724, "Nila Inc." },
  { 0x2727, "Lumikit" },
  { 0x2734, "Nixer Ltd." },
  { 0x27A8, "Callegenix LLC" },
  { 0x2821, "Pioneer Corporation" },
  { 0x2826, "Peter Maes Technology" },
  { 0x2829, "PR-Electronic" },
  { 0x2836, "Planungsbuero" },
  { 0x28E1, "MTC maintronic GmbH" },
  { 0x2927, "ROAL Electronics SpA" },
  { 0x297E, "Lifetime Music Academy" },
  { 0x2984, "Getlux Ltd." },
  { 0x2999, "ALL-DO INTERNATIONAL CO., LTD." },
  { 0x29A1, "Sturdy Corporation" },
  { 0x29A9, "SRS Light Design" },
  { 0x29AA, "Steinigke Showtechnic GmbH" },
  { 0x29B2, "Selectron Bvba" },
  { 0x29B4, "Showtec (Highlite International B.V.)" },
  { 0x29B7, "Sundrax, LLC" },
  { 0x29B8, "Spotlight s.r.l." },
  { 0x29BA, "State Automation Pty Ltd." },
  { 0x29E8, "Stroytsirk LLC" },
  { 0x2A25, "Thorn Lighting Limited" },
  { 0x2A26, "Toni Maroni Gmb" },
  { 0x2AAB, "Urban Visuals & Effects Ltd." },
  { 0x2B28, "Visual Productions" },
  { 0x2B29, "MaNima Technologies BV" },
  { 0x2BA2, "WERPAX bvba" },
  { 0x2BA9, "The White Rabbit Company, Inc." },
  { 0x2BB4, "Williams Electronic Design Ltd." },
  { 0x2C1A, "DMX4ALL GmbH" },
  { 0x2C2A, "XTBA" },
  { 0x2CE0, "Lighting Services Inc." },
  { 0x2DC8, "Stellascapes" },
  { 0x2DDD, "Waylight" },
  { 0x2DDE, "Luminlite Electronics Co., Ltd." },
  { 0x2DDF, "Carpetlight GmbH" },
  { 0x3000, "PushingPixels" },
  { 0x3001, "Elemental LED, Inc." },
  { 0x3002, "Siberian Lighting" },
  { 0x3003, "ChamSix" },
  { 0x3235, "de koster Special Effects" },
  { 0x3331, "DMG Lumiere" },
  { 0x3332, "Teclumen s.r.l." },
  { 0x3333, "NightStarry Electronics Co., LTD." },
  { 0x3388, "Macostar International Ltd." },
  { 0x3434, "Global Design Solutions, Ltd." },
  { 0x3533, "Figure 53, LLC" },
  { 0x3534, "Five4, LLC" },
  { 0x3535, "Changsha Spark Technology Electronics Ltd." },
  { 0x3536, "Cindy Professional Lighting Co., Ltd." },
  { 0x3537, "Novacorp Inc." },
  { 0x3538, "Lightnet sp. z o. o." },
  { 0x361D, "Lumishore Ltd. UK" },
  { 0x3638, "Lumenpulse Lighting Inc." },
  { 0x37D0, "Boogy Brothers Showequipment" },
  { 0x37D7, "Lichttechnik & Sonderbau" },
  { 0x37DD, "Sehr gute GmbH" },
  { 0x3800, "OndeLight LTD" },
  { 0x3801, "SFX Controllers Sweden AB" },
  { 0x3805, "Yifeng Lighting Co., Ltd." },
  { 0x3806, "ACME EFFECTS LTD." },
  { 0x3868, "LanBolight Technology Co., LTD." },
  { 0x3888, "Fly Dragon Lighting Equipment Co.,ltd" },
  { 0x388A, "Guangzhou Yajiang (Yagang - Silver Star) Photoelectric Equipment Ltd." },
  { 0x3A37, "TheOlymp - Networking & InterNet Services" },
  { 0x3AFC, "Black Tank Engineering" },
  { 0x3B10, "NXP Semiconductors B.V." },
  { 0x3B88, "Shenzhen Eastar Electronic Co., Ltd." },
  { 0x3D30, "zactrack Lighting Technologies Gmbh" },
  { 0x400D, "Quasar Science LLC" },
  { 0x4051, "SAN JACK ANALOG HOUSE CO., LTD." },
  { 0x4131, "Altman Stage Lighting" },
  { 0x4141, "AVAB America, Inc." },
  { 0x4142, "Filmgear, Inc." },
  { 0x4143, "AC Lasers" },
  { 0x4144, "ADB - TTV Technologies nv" },
  { 0x4145, "ADE ELETTRONICA srl" },
  { 0x4146, "AUS FX" },
  { 0x4149, "Anidea Engineering, Inc." },
  { 0x414A, "Guangzhou Aiminte Technology Co., Ltd." },
  { 0x414C, "Artistic Licence Engineering Ltd." },
  { 0x414D, "Amptown Lichttechnik GmbH" },
  { 0x414E, "Anytronics Ltd." },
  { 0x4150, "Apogee Lighting" },
  { 0x4151, "Aquarii, Inc." },
  { 0x4153, "Audio Scene" },
  { 0x4154, "Arnold Tang Productions" },
  { 0x4156, "Audio Visual Devices P/L" },
  { 0x4164, "Adelto Industries Ltd." },
  { 0x416C, "Alenco BV" },
  { 0x4172, "ARNOLD LICHTTECHNIK" },
  { 0x4173, "Astera LED Technology GmbH" },
  { 0x4179, "AYRTON" },
  { 0x4241, "BECKHOFF Automation GmbH" },
  { 0x4243, "Bill Coghill Company : Bill Coghill Design" },
  { 0x4245, "Bytecraft Entertainment Pty Ltd" },
  { 0x424F, "BOTEX" },
  { 0x4253, "Barco" },
  { 0x42A2, "Birket Engineering, Inc." },
  { 0x4321, "Design Partners of Canada" },
  { 0x4344, "CDCA Ltd." },
  { 0x4347, "CAST Software" },
  { 0x4349, "C.I.Tronics Lighting Designers Ltda" },
  { 0x434B, "Color Kinetics Inc." },
  { 0x434C, "Crealux GmbH & Co. KG" },
  { 0x434D, "Coemar Spa" },
  { 0x434F, "Cortex Design" },
  { 0x4350, "CLAY PAKY S.p.A" },
  { 0x4353, "Capricorn Software" },
  { 0x4354, "City Theatrical, Inc." },
  { 0x4358, "Connex GmbH" },
  { 0x4369, "Cinetix Medien u. Interface GmbH" },
  { 0x436F, "CODEM MUSIC S.r.l." },
  { 0x4441, "DIGITAL ART SYSTEM" },
  { 0x4442, "ELETTROLAB S.r.l." },
  { 0x4443, "Claudio Dal Cero Engineering" },
  { 0x4444, "D.O.M. Datenverarbeitung GmbH" },
  { 0x4445, "Dezelectric Kft." },
  { 0x4446, "Doug Fleenor Design, Inc." },
  { 0x4449, "Durand Interstellar, Inc." },
  { 0x444C, "Dove Lighting Systems, Inc." },
  { 0x444D, "Digimedia Multimedia Lighting Solutions" },
  { 0x444E, "DALCNET SRL" },
  { 0x4450, "DMXPROFI.EU GmbH i.G." },
  { 0x4453, "Guangzhou Desheng Lighting Industrial Co., Ltd." },
  { 0x4456, "Devantech Ltd." },
  { 0x4466, "DF elettronica s.r.l." },
  { 0x4469, "Diamante Lighting Srl" },
  { 0x446C, "Guangdong Delos Lighting Industrial Co.,Ltd." },
  { 0x4533, "LEDdynamics, Inc." },
  { 0x453A, "E:cue Control GmbH" },
  { 0x4541, "Engineering Arts" },
  { 0x4543, "EC Elettronica Srl" },
  { 0x4544, "Electronics Diversified LLC" },
  { 0x4545, "EastSun Technology Co. Ltd." },
  { 0x454C, "Ingenieurbuero fuer Nachrichtentechnik in der Studio und Veranstaltungstechnik" },
  { 0x454D, "ELM Video Technology, Inc." },
  { 0x454E, "ENTTEC Pty Ltd" },
  { 0x4552, "EREA" },
  { 0x4553, "ERAL srl" },
  { 0x4554, "Entertainment Technology" },
  { 0x4563, "Les Eclairages Lou Inc." },
  { 0x456C, "Element Labs Inc." },
  { 0x4631, "OKEROAB AB" },
  { 0x464C, "Flashlight/Ampco Holding" },
  { 0x4653, "IT & Eventtechnik Fabian Stumpf" },
  { 0x4656, "Flexvisual" },
  { 0x4657, "The Fountain Workshop Ltd." },
  { 0x4658, "MAGIC FX B.V." },
  { 0x4678, "Global Special Effects" },
  { 0x4744, "Goddard Design Co." },
  { 0x4745, "GPE srl" },
  { 0x4747, "G&G LED Lighting" },
  { 0x474C, "G-LEC Europe GmbH" },
  { 0x4750, "DES" },
  { 0x4752, "Greenlite" },
  { 0x4753, "Guangzhou Haoyang Electronic Co., Ltd." },
  { 0x476C, "General Luminaire (Shanghai) Ltd." },
  { 0x4800, "VOD VISUAL.CO. (UK) Ltd." },
  { 0x4801, "Capture Visualisation AB" },
  { 0x4843, "Horizon Control Inc." },
  { 0x4844, "HxDx" },
  { 0x4845, "Howard Eaton Lighting Ltd." },
  { 0x484C, "HBE Lighting Systems" },
  { 0x484F, "Hollywood Controls Inc." },
  { 0x4856, "Enfis Ltd" },
  { 0x4881, "Rena Electronica B.V." },
  { 0x4941, "inoage GmbH" },
  { 0x4942, "IBEX UK Limited" },
  { 0x4944, "Ingham Designs" },
  { 0x4945, "Insta Elektro GmbH" },
  { 0x4947, "IGuzzini illuminazione spa" },
  { 0x4948, "Ice House Productions" },
  { 0x494C, "I-Lum" },
  { 0x494E, "Interactive Technologies, Inc." },
  { 0x4950, "Interesting Products, Inc." },
  { 0x4951, "IQAir AG" },
  { 0x4952, "Invisible Rival Incorporated" },
  { 0x4953, "Integrated System Technologies Ltd." },
  { 0x4954, "Integrated Theatre, Inc." },
  { 0x4973, "Innovation Solutions Ltd." },
  { 0x4A31, "Joshua 1 Systems Inc." },
  { 0x4A41, "JANUS srl" },
  { 0x4A42, "JB-lighting GmbH" },
  { 0x4A48, "James Harris" },
  { 0x4A4C, "Johnsson Lighting Technologies AB" },
  { 0x4A53, "JSC 'MFG'" },
  { 0x4A54, "James Thomas Engineering" },
  { 0x4A61, "Jands Pty Ltd." },
  { 0x4ACC, "RVL techniek" },
  { 0x4B00, "Gabor Galyas Lighting" },
  { 0x4B42, "KissBox" },
  { 0x4B43, "TmTech Electronic Co.,Ltd." },
  { 0x4B46, "Kino Flo, Inc." },
  { 0x4B4C, "KLH Electronics PLC" },
  { 0x4B4D, "KMX Inc." },
  { 0x4B55, "kuwatec, Inc." },
  { 0x4C20, "LAM32 srl" },
  { 0x4C41, "LaserAnimation Sollinger GmbH" },
  { 0x4C44, "LVDIAN PHOTOELECTRIC SCIENCE TECHNOLOGY LIMITED" },
  { 0x4C45, "Leviton Manufacturing Co., Inc." },
  { 0x4C47, "LightGeist Ltd." },
  { 0x4C4C, "LUMINEX Lighting Control Equipment bvba" },
  { 0x4C4D, "Ultratec Special Effects" },
  { 0x4C50, "LightProcessor Ltd" },
  { 0x4C52, "High End Systems Inc." },
  { 0x4C53, "Licht-, Steuer- und Schaltanlagenbau GmbH (LSS GmbH)" },
  { 0x4C54, "Licht-Technik" },
  { 0x4C55, "LumenRadio AB" },
  { 0x4C56, "LEDValley Technologies Sdn Bhd" },
  { 0x4C57, "LightWild LC" },
  { 0x4C58, "Lex Products Corp." },
  { 0x4C59, "Laser Technology Ltd." },
  { 0x4C5A, "Sumolight GmbH / LightMinded Industries, Inc." },
  { 0x4C5B, "LightLife, Gesellschaft fur audiovisuelle Erlebnisse mbH" },
  { 0x4C64, "LED Team" },
  { 0x4C65, "Legargeant and Associates" },
  { 0x4C69, "LIGHTOLIER" },
  { 0x4C6C, "Lampo Lighting Designers" },
  { 0x4C73, "LSC Lighting Systems (Aust) Pty. Ltd." },
  { 0x4CDC, "acdc LED Ltd." },
  { 0x4CE5, "LED Company s.r.o." },
  { 0x4D41, "MA Lighting Technology GmbH" },
  { 0x4D42, "LAN Systems--Midibox project" },
  { 0x4D44, "Les Generateurs de brouillard MDG Fog Generators Ltd." },
  { 0x4D4C, "Mode Lighting (UK) Ltd." },
  { 0x4D50, "Martin Professional A/S" },
  { 0x4D54, "medien technik cords" },
  { 0x4D56, "Avolites Ltd." },
  { 0x4D58, "MX design" },
  { 0x4D5A, "Covert Science GmbH" },
  { 0x4D61, "MARTINI S.p.A." },
  { 0x4D77, "Mueller Elektronik" },
  { 0x4E41, "Company NA" },
  { 0x4E4A, "NJD Electronics" },
  { 0x4E4C, "NOVALIGHT S.r.l." },
  { 0x4E57, "AIM Northwest" },
  { 0x4E69, "Niko" },
  { 0x4F41, "Oase GmbH" },
  { 0x4F43, "Offstage Controls (formerly Obsidian Control)" },
  { 0x4F4C, "DDS Elettronica" },
  { 0x4F75, "Outsight Pty Ltd." },
  { 0x5000, "http://www.orangepi-dmx.org" },
  { 0x5001, "Hua Yuan Ke Tai" },
  { 0x5002, "Shanghai Shylon Optoelectronic Technology Co., Ltd." },
  { 0x5003, "Futlight Optoelectronics Co.,Ltd." },
  { 0x5004, "Shanghai Sansi Electronic Engineering Co.,Ltd" },
  { 0x5005, "MEDIAM Ltd. (Modus brand)" },
  { 0x5006, "ENEDO Power SpA" },
  { 0x5007, "Alfalite" },
  { 0x5008, "Chengdu Chengyu Electronic Technology Co., Ltd." },
  { 0x5009, "Izzro Optoelectronics Technology Co., Ltd." },
  { 0x500A, "AU Optronics Corporation (AUO)" },
  { 0x500B, "WebKat Eletronic's" },
  { 0x500C, "L.E.C. Societe Lyonnaise D' Equipement Et De Controle" },
  { 0x5010, "Shenzhen Viye Technology Co., Ltd." },
  { 0x5011, "Guangzhou Skydance Co., Ltd." },
  { 0x5017, "American Lighting" },
  { 0x5040, "Guangzhou Color Imagination LED Lighting Ltd." },
  { 0x5041, "Philips Entertainment Lighting Asia" },
  { 0x5043, "Pathway Connectivity Inc." },
  { 0x504C, "Peperoni Lighting-Solutions" },
  { 0x504D, "Peter Meyer Project Management Adviser GmbH" },
  { 0x504E, "Uni-Bright nv" },
  { 0x5050, "Newton Engineering and Design Group LLC" },
  { 0x5051, "PDQ Manufacturing, Inc" },
  { 0x5052, "Production Resource Group" },
  { 0x5053, "Philips Selecon" },
  { 0x5058, "PXM s.c." },
  { 0x5062, "LED, Inc." },
  { 0x5065, "Peradise" },
  { 0x5066, "Pfannenberg GmbH" },
  { 0x5068, "Philips Lighting BV" },
  { 0x5070, "Show Light Oy" },
  { 0x5071, "Raindrop-Media" },
  { 0x5072, "ARRI Rental Deutschland GmbH" },
  { 0x5075, "Pulsar Light of Cambridge Ltd." },
  { 0x5099, "Altec Di Gregorio Andrea" },
  { 0x5100, "Luxibel" },
  { 0x5101, "LBT Electronics Pvt. Ltd." },
  { 0x5102, "INDATA d.o.o." },
  { 0x512D, "DJPOWER ELECTRONIC STAGE LIGHTING FIXTURE FACTORY (GUANGZHOU)" },
  { 0x5149, "JAP Optoelectronic Ltd." },
  { 0x514D, "QMAXZ lighting" },
  { 0x5153, "QuickSilver Controls, Inc." },
  { 0x5168, "Shenzhen Sunricher Technology Co.,Ltd." },
  { 0x516C, "Quicklights" },
  { 0x51D7, "Innovative Dimmers LLC (Ratpac dimmers)" },
  { 0x51D8, "Amperor Electronics (Shenzhen) Co., Ltd." },
  { 0x5200, "Shenzhen Aotian Technology Co. , Ltd." },
  { 0x5201, "Crestron Electronics, Inc." },
  { 0x5202, "Shenzhen Lianjin Photoelectricity Co., Ltd." },
  { 0x5244, "Revolution Display" },
  { 0x524C, "Radical Lighting Ltd." },
  { 0x524D, "RUIZ TECH" },
  { 0x524E, "RNC Systems Inc." },
  { 0x5250, "RootPath Ltd." },
  { 0x5252, "RoscoLab Ltd." },
  { 0x5253, "Robe Show Lighting s.r.o." },
  { 0x5341, "Stage Technologies Limited" },
  { 0x5342, "Industrias Sola Basic S.A. de C.V." },
  { 0x5343, "Ocean Thin Films Inc." },
  { 0x5344, "Stardraw.com Ltd." },
  { 0x5345, "Selador" },
  { 0x5346, "Synthe FX, LLC" },
  { 0x5347, "SGM Technology For Lighting SPA" },
  { 0x5348, "Schreder" },
  { 0x5349, "Soundsculpture Incorporated" },
  { 0x534A, "SAS Productions" },
  { 0x534B, "SK-Software" },
  { 0x534C, "SOUNDLIGHT" },
  { 0x534E, "Sand Network Systems" },
  { 0x5353, "Sean Sill" },
  { 0x5354, "Stagetronics Ltda" },
  { 0x5355, "Lochmun Ltd." },
  { 0x5356, "OOO SAMLIGHT" },
  { 0x5363, "SpaceCannon vH" },
  { 0x5368, "ShowCAD Control Systems Ltd." },
  { 0x536C, "StageLine Electronic" },
  { 0x5370, "Chroma-Q" },
  { 0x5374, "STG-Beikirch Industrieelektronik + Sicherheitstechnik GmbH & Co. KG" },
  { 0x5376, "SV-wtu eU" },
  { 0x5377, "SWISSON AG" },
  { 0x5379, "Singularity (UK) Ltd." },
  { 0x53A8, "Simon Tech" },
  { 0x5431, "AUTOLUX Handels- und ProduktionsgmbH" },
  { 0x5441, "TecArt Lighting" },
  { 0x5444, "Technographic Displays Ltd." },
  { 0x5445, "TESI Elettronica srl" },
  { 0x544C, "Tempest Lighting Inc." },
  { 0x5453, "TalentStorm Enterprises, Inc." },
  { 0x5454, "TamaTech Labo Company Ltd," },
  { 0x5459, "TDE-Lighttech B.V." },
  { 0x5550, "UP-LUX Eletronica Ltda." },
  { 0x5553, "StageLAB Projectors and Professional Lighting Ltd." },
  { 0x5555, "Martin Sukale Medientechnik GbR" },
  { 0x55AA, "Emilum GmbH" },
  { 0x564C, "Vari-Lite, Inc." },
  { 0x5651, "Vision Quest Lighting Inc." },
  { 0x5652, "Megapixel Visual Reality" },
  { 0x5653, "Viso Systems Aps" },
  { 0x5655, "Shenzhen CAS VU Technologies Co., Ltd." },
  { 0x5744, "W-DEV" },
  { 0x5746, "Wildfire, Inc." },
  { 0x5747, "Wenger / JR Clancy" },
  { 0x5753, "Wireless Solution Sweden AB" },
  { 0x5754, "LIGHTMAN (Interlite AB)" },
  { 0x5759, "Wybron, Inc." },
  { 0x584C, "X-Laser" },
  { 0x584D, "Xtraordinary Musical Accolade Systems" },
  { 0x5858, "Illuminance Technologies" },
  { 0x5865, "XENON ARCHITECTURAL LIGHTING" },
  { 0x586C, "Eurolumen (Shanghai) Lighting Co., LTD" },
  { 0x586D, "www.doityourselfchristmas.com hobbyists" },
  { 0x5888, "Plsao Optoelectronics Technology Co., Ltd." },
  { 0x5A53, "Zingerli Show Engineering" },
  { 0x5C40, "OXO" },
  { 0x5D00, "L1 Inc." },
  { 0x5D01, "MTS Medientechnik GmbH" },
  { 0x5D02, "Underwater Lights Limited" },
  { 0x5DAC, "Mediatec Group" },
  { 0x5E5D, "Multisenses GmbH" },
  { 0x5E5E, "Converging Systems Inc." },
  { 0x6019, "Artifice Industries Ltd." },
  { 0x6100, "Krobox Sdn Bhd" },
  { 0x610A, "Visenge Pty. Ltd" },
  { 0x6123, "CMYLight (S) Pte. Ltd." },
  { 0x6124, "Fiilex" },
  { 0x614C, "Alektra AB" },
  { 0x6154, "Advatek Lighting" },
  { 0x6164, "AVID Labs" },
  { 0x616C, "Advanced Lighting Systems" },
  { 0x6200, "LUCITAG Ltd." },
  { 0x6201, "NuDelta Digital, LLC" },
  { 0x6202, "ESCO Sp. z o.o." },
  { 0x6203, "Flektor" },
  { 0x6204, "Shenzhen Absen Optoelectronic Co., Ltd" },
  { 0x6205, "Zhuhai Ltech Technology Co., Ltd." },
  { 0x6206, "Lighting Innovation Company, LLC" },
  { 0x6273, "B&S Elektronische Geräte GmbH" },
  { 0x6342, "Mega Systems Inc." },
  { 0x6364, "CDS advanced technology bv" },
  { 0x636D, "Cambridge Micro Engineering Limited" },
  { 0x641A, "Heliospectra AB" },
  { 0x644C, "bdL KG" },
  { 0x6461, "Digilin Australia" },
  { 0x6464, "Dangeross Design" },
  { 0x646C, "dilitronics GmbH" },
  { 0x646F, "eldoLED BV" },
  { 0x6472, "Ingenieurburo Steffens" },
  { 0x64B9, "Finelite, Inc." },
  { 0x6542, "eBrain GmbH" },
  { 0x6543, "LES-TV Ltd." },
  { 0x6547, "euroGenie" },
  { 0x6553, "EtherShow" },
  { 0x6555, "Shantea Controls" },
  { 0x6565, "Stratus Systems LLC" },
  { 0x656C, "ELC lighting" },
  { 0x6573, "Environmental Lighting Solutions" },
  { 0x6574, "Electronic Theatre Controls, Inc." },
  { 0x6576, "eventa Aktiengesellschaft" },
  { 0x6600, "WANTS Electronics Co. Ltd." },
  { 0x6644, "Sunlab Technologies S.L." },
  { 0x666D, "MAD-Effects" },
  { 0x6673, "Freescale Semiconductor U.K. Ltd." },
  { 0x6756, "Lumisia Co., Ltd." },
  { 0x676C, "GLP German Light Products GmbH" },
  { 0x67F0, "Toshiba Lighting & Technology Corporation" },
  { 0x6816, "ChamberPlus Co., Ltd" },
  { 0x6864, "James Embedded Systems Engineering (JESE Ltd)" },
  { 0x6865, "Hubbell Entertainment, Inc." },
  { 0x686C, "HERA LED" },
  { 0x694C, "iLight Technologies Inc" },
  { 0x6969, "Better Way Lighting" },
  { 0x6972, "Immersion Room Inc." },
  { 0x6974, "Ittermann electronic GmbH" },
  { 0x6A6A, "Roxx GmbH" },
  { 0x6A6B, "JPK Systems Limited" },
  { 0x6B64, "Key Delfin" },
  { 0x6B69, "Magical Fountain SA de CV (Magic Fountain)" },
  { 0x6BEA, "Remoticom BV" },
  { 0x6BED, "Planar Systems, Inc." },
  { 0x6BEE, "Ephesus Lighting" },
  { 0x6BEF, "Shenzhen Ifountain Technology Ltd." },
  { 0x6C6D, "Zumtobel Lighting GmbH" },
  { 0x6C78, "Claude Heintz Design" },
  { 0x6C92, "Ambra Elettronica s.r.l." },
  { 0x6D61, "MAL Effekt-Technik GmbH" },
  { 0x6D62, "MBN GmbH" },
  { 0x6D63, "Sein & Schein GmbH" },
  { 0x6E00, "LEDeco solution, s.r.o." },
  { 0x6F00, "Guangzhou Huaying Stage Lighting Equipment Co. Ltd." },
  { 0x6F01, "DAVAI!JPL" },
  { 0x6F02, "hazebase (Uta Raabe e.K.)" },
  { 0x6FEA, "Lumina Visual Productions" },
  { 0x6FEB, "Insight Lighting" },
  { 0x6FEC, "Arc Lighting Co. Ltd." },
  { 0x6FED, "Explorentis" },
  { 0x6FEE, "fos design sp. z o.o." },
  { 0x7000, "Nippon Ceramic Co., Ltd." },
  { 0x700A, "Guangzhou Leemc Lighting Tech., Co., Ltd." },
  { 0x700B, "Vice Lighting DWC LLC" },
  { 0x7068, "Pharos Architectural Controls" },
  { 0x7070, "SBT GmbH" },
  { 0x7072, "Pr-Lighting Ltd." },
  { 0x7078, "PixelRange Inc." },
  { 0x70F0, "Pangolin Laser Systems, Inc." },
  { 0x7151, "The Light Source, Inc." },
  { 0x7363, "Sean Christopher FX" },
  { 0x7365, "Ballantyne Strong Inc." },
  { 0x736C, "Strand Lighting Ltd." },
  { 0x7400, "Danalux" },
  { 0x7401, "Harvatek Corporation" },
  { 0x7402, "Chris Kallas" },
  { 0x7403, "Yenrich Technology Corporation" },
  { 0x7764, "WET" },
  { 0x7765, "MKT engineering GmbH & Co. KG" },
  { 0x7777, "DVT Light" },
  { 0x7788, "DigitaLicht AG" },
  { 0x780E, "Mole-Richardson Co." },
  { 0x783A, "Audiolux Devices LLC" },
  { 0x786C, "XLN-t bvba" },
  { 0x7888, "Tontron Photoelectric Co., Limited" },
  { 0x78B4, "LED Flex Limited" },
  { 0x7900, "Leprecon / CAE, Inc." },
  { 0x79BC, "DC Reactive" },
  { 0x7A70, "Open Lighting" },
  { 0x7AA0, "Anaren Inc." },
  { 0x7AAA, "WEAD (Wagner Electronic and Design)" },
  { 0x7AAB, "Hyundai Fomex Co., Ltd." },
  { 0x7B1B, "DimLight Ltd." },
  { 0x7D00, "expanseElectronics" },
  { 0x7D61, "HMB|TEC GmbH" },
  { 0x7DE7, "Guangzhou ILightings Equipment Co., Ltd." },
  { 0x7DE8, "Shenzhen LAMP Technology Co., Ltd." },
  { 0x7DEA, "RobLight A/S" },
  { 0x7DEB, "Krypton" },
  { 0x7DEE, "zencontrol Pty Ltd" },
  { 0x7EE6, "ADPower Technology (WuXI) Inc." },
  { 0x7EE7, "Arthur Digital Solutions Kft" },
  { 0x7EE8, "Guangzhou Yingfeng Lighting Equipment Co., Ltd." },
  { 0x7EE9, "Technology Kitchen" },
  { 0x7EEA, "Cartwright Engineering" },
  { 0x7EEB, "mylaserpage" },
  { 0x7EEC, "SHENZHEN LP Display" },
  { 0x7EED, "Look Solutions GmbH & Co. KG" },
  { 0x7EEE, "General Lighting Electronic Co., Ltd." },
  { 0x7EEF, "Huizhou Mounteck Technology Co., Ltd." },
  { 0x7FF0, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FF1, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FF2, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FF3, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FF4, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FF5, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FF6, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FF7, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FF8, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FF9, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FFA, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FFB, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FFC, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FFD, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FFE, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0x7FFF, "RESERVED FOR PROTOTYPING/EXPERIMENTAL USE ONLY" },
  { 0xFFFC, "RDMNet RPT All Controllers" },
  { 0xFFFD, "RDMNet RPT All Devices" },
  { 0xFFFF, "ESTA" },
  { 0,      NULL }
};
value_string_ext dmx_esta_manfid_vals_ext = VALUE_STRING_EXT_INIT(dmx_esta_manfid_vals);
